.de EX		\"Begin example
.ne 5
.if n .sp 1
.if t .sp .5
.nf
.in +.5i
..
.de EE
.fi
.in -.5i
.if n .sp 1
.if t .sp .5
..
.TH XScreenSaver 1 "17-Jun-99" "X Version 11"
.SH NAME
webcollage - decorate the screen with random images from the web
.SH SYNOPSIS
.B webcollage
[\-display \fIhost:display.screen\fP]
[\-root]
[\-window\-id \fIid\fP]
[\-verbose]
[\-timeout \fIsecs\fP]
[\-delay \fIsecs\fP]
[\-background \fIbg\fP]
[\-no-output]
[\-urls-only]
[\-imagemap \fIfilename-base\fP]
[\-size \fIWxH\fP]
[\-opacity \fIratio\fP]
[\-filter \fIcommand\fP]
[\-filter2 \fIcommand\fP]
[\-http\-proxy host[:port]]
[\-dictionary \fIdictionary-file\fP]
[\-driftnet [\fIcmd\fP]]
.SH DESCRIPTION
The \fIwebcollage\fP program pulls random image off of the World Wide Web
and scatters them on the root window.  One satisfied customer described it
as "a nonstop pop culture brainbath."  This program finds its images by
doing random web searches, and extracting images from the returned pages.

\fIwebcollage\fP is written in
.BR perl (1)
and requires Perl 5.

It will be an order of magnitude faster if you also have
the \fIwebcollage-helper\fP program installed (a GDK/JPEG image
compositor), but \fIwebcollage\fP works without it as well.

\fIwebcollage\fP can be used in conjunction with the
.BR driftnet (1)
program (the Unix equivalent of EtherPEG) to snoop images from traffic
on your local subnet, instead of getting images from search engines.
.SH OPTIONS
.I webcollage
accepts the following options:
.TP 8
.B \-root
Draw on the root window.  This option is mandatory, if output is being
produced: drawing to a window other than the root window is not yet
supported.

Images are placed on the root window by using one of the
.BR xscreensaver-getimage (1),
.BR chbg (1),
.BR xv (1),
.BR xli (1),
or
.BR xloadimage (1)
programs (whichever is available.)
.TP 8
.B \-window\-id \fIid\fP
Draw to the indicated window instead; this only works if the
.BR xscreensaver-getimage (1)
program is installed.
.TP 8
.B \-verbose \fRor\fP \-v
Print diagnostics to stderr.  Multiple \fI-v\fP switches increase the
amount of output.  \fI-v\fP will print out the URLs of the images,
and where they were placed; \fI-vv\fP will print out any warnings,
and all URLs being loaded; \fI-vvv\fP will print information on
what URLs were rejected; and so on.
.TP 8
.B \-timeout \fIseconds\fP
How long to wait for a URL to complete before giving up on it and
moving on to the next one.
Default 30 seconds.
.TP 8
.B \-delay \fIseconds\fP
How long to sleep between images.  Default 2 seconds.  (Remember that
this program probably spends a lot of time waiting for the network.)
.TP 8
.B \-background \fIcolor-or-ppm\fP
What to use for the background onto which images are pasted.  This may be
a color name, a hexadecimal RGB specification in the form '#rrggbb', or 
the name of a PPM file.
.TP 8
.B \-size \fIWxH\fP
Normally, the output image will be made to be the size of the
screen (or target window.)  This lets you specify the desired size.
.TP 8
.B \-opacity \fIratio\fP
How transparently to paste the images together, with 0.0 meaning
"completely transparent" and 1.0 meaning "opaque."  Default 0.85.
A value of around 0.3 will produce an interestingly blurry image
after a while.
.TP 8
.B \-no-output
If this option is specified, then no composite output image will be
generated.  This is only useful when used in conjunction 
with \fB\-verbose\fP.
.TP 8
.B \-urls-only
If this option is specified, then no composite output image will be
generated: instead, a list of image URLs will be printed on stdout.
.TP 8
.B \-imagemap \fIfilename-base\fP
If this option is specified, then instead of writing an image to the
root window, two files will be created: "\fIbase\fP.html" and "\fIbase\fP.jpg".
The JPEG will be the collage; the HTML file will include that image, and
an image-map making the sub-images be linked to the pages on which they
were found (just like \fIhttp://www.jwz.org/webcollage/\fP.)
.TP 8
.B \-filter \fIcommand\fP
Filter all source images through this command.  The command must take
a PPM file on stdin, and write a new PPM file to stdout.  One good 
choice for a filter would be:
.EX
webcollage -root -filter 'vidwhacker -stdin -stdout'
.EE
.TP 8
.B \-filter2 \fIcommand\fP
Filter the \fIcomposite\fP image through this command.  The \fI-filter\fP
option applies to the sub-images; the \fI-filter2\fP applies to the
final, full-screen image.
.TP 8
.B \-http\-proxy \fIhost:port\fP
If you must go through a proxy to connect to the web, you can specify it 
with this option, or with the \fB$http_proxy\fP or \fB$HTTP_PROXY\fP 
environment variables.
.TP 8
.B \-dictionary \fIfile\fP
Webcollage normally looks at the system's default spell-check dictionary
to generate words to feed into the search engines.  You can specify an
alternate dictionary with this option.

Note that by default, webcollage searches for images using several
different methods, not all of which involve dictionary words, so
using a "topical" dictionary file will not, in itself, be as effective
as you might be hoping.
.TP 8
.B \-driftnet \fI[ args ]\fP
.BR driftnet (1)
is a program that snoops your local ethernet for packets that look
like they might be image files.  It can be used in conjunction 
with \fIwebcollage\fP to generate a collage of what other people on
your network are looking at, instead of a search-engine collage.
If you have \fIdriftnet\fP installed on your $PATH, just use 
the \fI\-driftnet\fP option.  You can also specify the location
of the program like this:
.EX
-driftnet /path/to/driftnet
.EE
or, you can provide extra arguments like this:
.EX
-driftnet '/path/to/driftnet -extra -args'
.EE
Driftnet version 0.1.5 or later is required.  Note that 
the \fIdriftnet\fP program requires root access, so you'll have
to make \fIdriftnet\fP be setuid-root for this to work.
Please exercise caution.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.TP 8
.B http_proxy\fR or \fPHTTP_PROXY
to get the default HTTP proxy host and port.
.SH FILES AND URLS
.I /usr/dict/words,
.I /usr/share/lib/dict/words,\fP
or
.I /usr/share/dict/words
to find the random words to feed to certain search engines.

    \fIhttp://www.altavista.com/image/randomlink\fP,
    \fIhttp://random.yahoo.com/fast/ryl\fP,
    \fIhttp://www.livejournal.com/stats/latest-img.bml\fP, and
    \fIhttp://www.google.com/\fP
to find random web pages.
.SH BOOBIES
The Internet being what it is, absolutely anything might show up in the
collage including -- quite possibly -- pornography, or even nudity.
.SH BUGS
Animating GIFs are not supported: only the first frame will be used.
.SH UPGRADES
The latest version of webcollage can be found as a part of
xscreensaver, at 
.B http://www.jwz.org/xscreensaver/,
or on the WebCollage page at 
.B http://www.jwz.org/webcollage/.

DriftNet:
.B http://www.ex-parrot.com/~chris/driftnet/
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1),
.BR xli (1),
.BR xv (1),
.BR xloadimage (1),
.BR ppmmake (1),
.BR giftopnm (1),
.BR pnmpaste (1),
.BR pnmscale (1),
.BR djpeg (1),
.BR cjpeg (1),
.BR xdpyinfo (1),
.BR perl (1),
.BR vidwhacker (MANSUFFIX),
.BR dadadodo (1),
.BR driftnet (1)
.BR EtherPEG ,
.BR EtherPeek
.SH COPYRIGHT
Copyright \(co 1998-2005 by Jamie Zawinski.  Permission to use, copy, modify,
distribute, and sell this software and its documentation for any purpose is
hereby granted without fee, provided that the above copyright notice appear
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Jamie Zawinski <jwz@jwz.org>, 24-May-1998.
