/*
 *  xfmedia - simple gtk2 media player based on xine
 *
 *  Copyright (c) 2004-2005 Brian Tarricone, <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _XFMEDIA__PLAYLIST_H_
#define _XFMEDIA__PLAYLIST_H_

#include <glib.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkmenu.h>
#include <gtk/gtkmenuitem.h>
#include <gtk/gtktogglebutton.h>

G_BEGIN_DECLS

typedef enum
{
    XFMEDIA_PLAYLIST_SORT_TITLE = 0,
    XFMEDIA_PLAYLIST_SORT_FILENAME,
    XFMEDIA_PLAYLIST_SORT_RANDOM
} XfmediaPlaylistSortType;

#define XFMEDIA_TYPE_PLAYLIST         (xfmedia_playlist_get_type())
#define XFMEDIA_PLAYLIST(object)      (G_TYPE_CHECK_INSTANCE_CAST((object), XFMEDIA_TYPE_PLAYLIST, XfmediaPlaylist))
#define XFMEDIA_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), XFMEDIA_TYPE_PLAYLIST, XfmediaPlaylistClass))
#define XFMEDIA_IS_PLAYLIST(object)   (G_TYPE_CHECK_INSTANCE_TYPE((object), XFMEDIA_TYPE_PLAYLIST))

typedef struct _XfmediaPlaylistEntryRef XfmediaPlaylistEntryRef;

typedef struct _XfmediaPlaylist XfmediaPlaylist;
typedef struct _XfmediaPlaylistClass XfmediaPlaylistClass;
typedef struct _XfmediaPlaylistPriv XfmediaPlaylistPriv;
    
struct _XfmediaPlaylist
{
    GtkVBox parent;
    
    /*< private */
    XfmediaPlaylistPriv *priv;
};

struct _XfmediaPlaylistClass
{
    GtkVBoxClass parent_class;
    
    /*< signals >*/
    void (*playlist_cleared)(XfmediaPlaylist *plist);
    void (*playlist_opened)(XfmediaPlaylist *plist, const gchar *filename);
    void (*playlist_saved)(XfmediaPlaylist *plist, const gchar *filename);
    void (*playlist_scrolled)(XfmediaPlaylist *plist);
    
    void (*entry_added)(XfmediaPlaylist *plist, gint idx);
    void (*entry_changed)(XfmediaPlaylist *plist, gint idx);
    void (*entry_removed)(XfmediaPlaylist *plist, const gchar *uri);
    void (*entry_activated)(XfmediaPlaylist *plist, gint idx);
    
    void (*shuffle_toggled)(XfmediaPlaylist *plist);
    void (*repeat_toggled)(XfmediaPlaylist *plist);
    void (*add_button_clicked)(XfmediaPlaylist *plist, GtkToggleButton *button);
    
    /*< reserved >*/
    void (*_xfmedia_res0)();
    void (*_xfmedia_res1)();
    void (*_xfmedia_res2)();
};

XfmediaPlaylistEntryRef *xfmedia_playlist_entry_ref_new_for_index
                                                 (XfmediaPlaylist *plist,
                                                  guint idx);
XfmediaPlaylistEntryRef *xfmedia_playlist_entry_ref_copy
                                                 (XfmediaPlaylistEntryRef *ref);
gboolean xfmedia_playlist_entry_ref_valid        (XfmediaPlaylistEntryRef *ref);
gint xfmedia_playlist_entry_ref_get_index        (XfmediaPlaylistEntryRef *ref);
void xfmedia_playlist_entry_ref_destroy          (XfmediaPlaylistEntryRef *ref);

GType xfmedia_playlist_get_type                  () G_GNUC_CONST;

GtkWidget *xfmedia_playlist_new                  ();

guint xfmedia_playlist_append_entry              (XfmediaPlaylist *plist,
                                                  const gchar *title,
                                                  gint length,
                                                  const gchar *filename,
                                                  gboolean metadata_loaded);
guint xfmedia_playlist_insert_entry              (XfmediaPlaylist *plist,
                                                  guint idx,
                                                  const gchar *title,
                                                  gint length,
                                                  const gchar *filename,
                                                  gboolean metadata_loaded);

void xfmedia_playlist_modify_entry               (XfmediaPlaylist *plist,
                                                  guint idx,
                                                  const gchar *title,
                                                  gint length,
                                                  const gchar *filename);
                                                   
gboolean xfmedia_playlist_remove_entry           (XfmediaPlaylist *plist,
                                                  guint idx);
void xfmedia_playlist_clear                      (XfmediaPlaylist *plist);

void xfmedia_playlist_set_metadata_loaded        (XfmediaPlaylist *plist,
                                                  guint idx,
                                                  gboolean metadata_loaded);
gboolean xfmedia_playlist_get_metadata_loaded    (XfmediaPlaylist *plist,
                                                  guint idx);
gboolean xfmedia_playlist_get                    (XfmediaPlaylist *plist,
                                                  guint idx,
                                                  gchar **title,
                                                  gint *length,
                                                  gchar **filename);
guint xfmedia_playlist_get_n_entries             (XfmediaPlaylist *plist);

gint xfmedia_playlist_get_selected               (XfmediaPlaylist *plist);

void xfmedia_playlist_set_bold_entry             (XfmediaPlaylist *plist,
                                                  XfmediaPlaylistEntryRef *ref);
void xfmedia_playlist_set_italic_entry           (XfmediaPlaylist *plist,
                                                  XfmediaPlaylistEntryRef *ref);

void xfmedia_playlist_context_menu_prepend_item  (XfmediaPlaylist *plist,
                                                  GtkMenuItem *menu_item);
void xfmedia_playlist_context_menu_append_item   (XfmediaPlaylist *plist,
                                                  GtkMenuItem *menu_item);

gboolean xfmedia_playlist_is_dirty               (XfmediaPlaylist *plist);

void xfmedia_playlist_set_shuffle_state          (XfmediaPlaylist *plist,
                                                  gboolean state);
gboolean xfmedia_playlist_get_shuffle_state      (XfmediaPlaylist *plist);
void xfmedia_playlist_set_repeat_state           (XfmediaPlaylist *plist,
                                                  gboolean state);
gboolean xfmedia_playlist_get_repeat_state       (XfmediaPlaylist *plist);

void xfmedia_playlist_scroll_to_index            (XfmediaPlaylist *plist,
                                                  gint idx,
                                                  gdouble align);
gboolean xfmedia_playlist_get_visible_range      (XfmediaPlaylist *plist,
                                                  guint *start,
                                                  guint *end);

void xfmedia_playlist_sort                       (XfmediaPlaylist *plist,
                                                  XfmediaPlaylistSortType type);

void xfmedia_playlist_set_external_menu          (XfmediaPlaylist *plist,
                                                  GtkMenu *menu);

void xfmedia_playlist_set_allowed_extensions     (XfmediaPlaylist *plist,
                                                  const gchar *extensions);
G_CONST_RETURN gchar *xfmedia_playlist_get_allowed_extensions
                                                 (XfmediaPlaylist *plist);

void xfmedia_playlist_trigger_new_playlist       (XfmediaPlaylist *plist);
void xfmedia_playlist_trigger_open_playlist      (XfmediaPlaylist *plist);
void xfmedia_playlist_trigger_save_playlist      (XfmediaPlaylist *plist);
void xfmedia_playlist_trigger_jump_to_file       (XfmediaPlaylist *plist);

gboolean xfmedia_playlist_has_focus              (XfmediaPlaylist *plist);
gboolean xfmedia_playlist_jump_to_file_box_has_focus
                                                 (XfmediaPlaylist *plist);

/* playlist shuffle-play management */
gboolean xfmedia_playlist_shuffle_check          (XfmediaPlaylist *plist,
                                                  guint idx);
gboolean xfmedia_playlist_shuffle_check_set      (XfmediaPlaylist *plist,
                                                  guint idx);
void xfmedia_playlist_shuffle_unset              (XfmediaPlaylist *plist,
                                                  guint idx);
void xfmedia_playlist_shuffle_unset_all          (XfmediaPlaylist *plist);
void xfmedia_playlist_shuffle_add_entries        (XfmediaPlaylist *plist,
                                                  gint start,
                                                  guint len);
void xfmedia_playlist_shuffle_remove_entries     (XfmediaPlaylist *plist,
                                                  guint start,
                                                  gint len);
void xfmedia_playlist_shuffle_swap_entries       (XfmediaPlaylist *plist,
                                                  guint a,
                                                  guint b);
void xfmedia_playlist_shuffle_init_entries       (XfmediaPlaylist *plist,
                                                  guint len);

G_END_DECLS

#endif
