// ==UserScript==
// @include       http://last.fm/*
// @include       http://*.last.fm/*
// @include       https://last.fm/*
// @include       https://*.last.fm/*
// @include       http://lastfm.de/*
// @include       http://*.lastfm.de/*
// @include       https://lastfm.de/*
// @include       https://*.lastfm.de/*
// @require       utils.js
// ==/UserScript==

window.Unity = external.getUnityObject(1);

function isCorrectPage() {
    var i, ids = ['nowPlayingMeta', 'radioControlPlay', 'radioControlPause', 'radioControlSkip', 'webRadio'];

    for (i = 0; i < ids.length; i++) {
        if (!document.getElementById(ids[i])) {
            return false;
        }
    }

    return true;
}

function trim(str) {
    return str.replace(/^\s+|\s+$/g, '');
}

function getTrackInfo() {
    var title = document.title;
    var artLocation = null;
    var album = null;
    var artist = null;
    try {
        var meta = document.getElementById('nowPlayingMeta');
        artLocation = document.evaluate('div/h1/a/img', meta, null,
                                        XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue.src;

        title = document.title.match(/.+(?= - Last\.fm$)/)[0];

        artist = document.evaluate('div/h1/a[2]', meta, null,
                                   XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue.innerHTML;
        artist = trim(artist);

        if (title.substr(0, artist.length + 3) === artist + ' - ') {
            title = title.substr(artist.length + 3);

            var trackAlbum = document.getElementById('trackAlbum');
            album = document.evaluate('ul/li/div/strong/a', trackAlbum, null,
                                      XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue.textContent;
            trim(album);
        } else {
            artist = null;
        }
    } catch (x) {}

    if (!artLocation) {
        return null;
    }

    return {
        title: title,
        album: album,
        artist: artist,
        artLocation: artLocation
    };
}

function musicPlayerSetup() {
    if (isCorrectPage() === false) {
        return;
    }
    Unity.MediaPlayer.init("last.fm");
    Unity.MediaPlayer.setCanGoPrevious(false);

    setTimeout(wrapCallback(function retry() {
        var trackInfo = getTrackInfo();

        setTimeout(retry, 1500);

        if (trackInfo) {
            Unity.MediaPlayer.setTrack(trackInfo);
        }
        var paused = document.getElementById('webRadio').className === 'paused';
        if (paused) {
            Unity.MediaPlayer.setPlaybackState(Unity.MediaPlayer.PlaybackState.PAUSED);
        } else {
            Unity.MediaPlayer.setPlaybackState(Unity.MediaPlayer.PlaybackState.PLAYING);
        }
	/*
        var playLists = document.evaluate('//a[@data-analytics-action="PlayRadioButton"]',
                                          document, null, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null);
        var i, node, res = [];
        for (i = 0; i < playLists.snapshotLength; i++) {
            node = playLists.snapshotItem(i);
        }*/
    }), 1000);

    Unity.MediaPlayer.onPlayPause(wrapCallback(function () {
        var paused = document.getElementById('webRadio').className === 'paused';
        var pause = document.getElementById('radioControlPause');
        var play = document.getElementById('radioControlPlay');
        if (paused) {
            launchClickEvent(play);
        } else {
            launchClickEvent(pause);
        }

        Unity.MediaPlayer.setPlaybackState(!paused);
    }));

    Unity.MediaPlayer.onNext(wrapCallback(function () {
        launchClickEvent(document.getElementById('radioControlSkip'));
    }));
}

Unity.init({ name: "last.fm",
             iconUrl: "icon://unity-webapps-last-fm",
             domains: [['last.fm', 'http://www.last.fm/'],
                       ['lastfm.de', 'http://www.lastfm.de/']],
             onInit: wrapCallback(musicPlayerSetup) });

