/*
 * Copyright 2009 by Ping Cheng, Wacom. <pingc@wacom.com> 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "xf86Wacom.h"

void xf86WcmTilt2R(WacomDeviceStatePtr ds);

/* Constants to convert X and Y tilt to rotation */
unsigned short tiltTable_00[65] = {
	( 0 | (90 << 8)),( 0 | (89 << 8)),( 0 | (88 << 8)),( 0 | (87 << 8)),( 0 | (86 << 8)),
	( 0 | (85 << 8)),( 0 | (84 << 8)),( 0 | (83 << 8)),( 0 | (82 << 8)),( 0 | (81 << 8)),
	( 0 | (80 << 8)),( 0 | (79 << 8)),( 0 | (78 << 8)),( 0 | (77 << 8)),( 0 | (76 << 8)),
	( 0 | (75 << 8)),( 0 | (74 << 8)),( 0 | (73 << 8)),( 0 | (72 << 8)),( 0 | (71 << 8)),
	( 0 | (70 << 8)),( 0 | (69 << 8)),( 0 | (68 << 8)),( 0 | (67 << 8)),( 0 | (66 << 8)),
	( 0 | (65 << 8)),( 0 | (64 << 8)),( 0 | (63 << 8)),( 0 | (62 << 8)),( 0 | (61 << 8)),
	( 0 | (60 << 8)),( 0 | (59 << 8)),( 0 | (58 << 8)),( 0 | (57 << 8)),( 0 | (56 << 8)),
	( 0 | (55 << 8)),( 0 | (54 << 8)),( 0 | (53 << 8)),( 0 | (52 << 8)),( 0 | (51 << 8)),
	( 0 | (50 << 8)),( 0 | (49 << 8)),( 0 | (48 << 8)),( 0 | (47 << 8)),( 0 | (46 << 8)),
	( 0 | (45 << 8)),( 0 | (44 << 8)),( 0 | (43 << 8)),( 0 | (42 << 8)),( 0 | (41 << 8)),
	( 0 | (40 << 8)),( 0 | (39 << 8)),( 0 | (38 << 8)),( 0 | (37 << 8)),( 0 | (36 << 8)),
	( 0 | (35 << 8)),( 0 | (34 << 8)),( 0 | (33 << 8)),( 0 | (32 << 8)),( 0 | (31 << 8)),
	( 0 | (30 << 8)),( 0 | (29 << 8)),( 0 | (28 << 8)),( 0 | (27 << 8)),( 0 | (26 << 8))
};

unsigned short tiltTable_01[64] = {
	(45 | (89 << 8)),(27 | (88 << 8)),(18 | (87 << 8)),(14 | (86 << 8)),(11 | (85 << 8)),
	( 9 | (84 << 8)),( 8 | (83 << 8)),( 7 | (82 << 8)),( 6 | (81 << 8)),( 6 | (80 << 8)),
	( 5 | (79 << 8)),( 5 | (78 << 8)),( 4 | (77 << 8)),( 4 | (76 << 8)),( 4 | (75 << 8)),
	( 3 | (74 << 8)),( 3 | (73 << 8)),( 3 | (72 << 8)),( 3 | (71 << 8)),( 3 | (70 << 8)),
	( 3 | (69 << 8)),( 2 | (68 << 8)),( 2 | (67 << 8)),( 2 | (66 << 8)),( 2 | (65 << 8)),
	( 2 | (64 << 8)),( 2 | (63 << 8)),( 2 | (62 << 8)),( 2 | (61 << 8)),( 2 | (60 << 8)),
	( 2 | (59 << 8)),( 2 | (58 << 8)),( 2 | (57 << 8)),( 1 | (56 << 8)),( 1 | (55 << 8)),
	( 1 | (54 << 8)),( 1 | (53 << 8)),( 1 | (52 << 8)),( 1 | (51 << 8)),( 1 | (50 << 8)),
	( 1 | (49 << 8)),( 1 | (48 << 8)),( 1 | (47 << 8)),( 1 | (46 << 8)),( 1 | (45 << 8)),
	( 1 | (44 << 8)),( 1 | (43 << 8)),( 1 | (42 << 8)),( 1 | (41 << 8)),( 1 | (40 << 8)),
	( 1 | (39 << 8)),( 1 | (38 << 8)),( 1 | (37 << 8)),( 1 | (36 << 8)),( 1 | (35 << 8)),
	( 1 | (34 << 8)),( 1 | (33 << 8)),( 1 | (32 << 8)),( 1 | (31 << 8)),( 1 | (30 << 8)),
	( 1 | (29 << 8)),( 1 | (28 << 8)),( 1 | (27 << 8)),( 0 | (26 << 8))
};

unsigned short tiltTable_02[63] = {
	(45 | (87 << 8)),(34 | (86 << 8)),(27 | (86 << 8)),(22 | (85 << 8)),(18 | (84 << 8)),
	(16 | (83 << 8)),(14 | (82 << 8)),(12 | (81 << 8)),(11 | (80 << 8)),(10 | (79 << 8)),
	( 9 | (78 << 8)),( 9 | (77 << 8)),( 8 | (76 << 8)),( 7 | (75 << 8)),( 7 | (74 << 8)),
	( 7 | (73 << 8)),( 6 | (72 << 8)),( 6 | (71 << 8)),( 5 | (70 << 8)),( 5 | (69 << 8)),
	( 5 | (68 << 8)),( 5 | (67 << 8)),( 4 | (66 << 8)),( 4 | (65 << 8)),( 4 | (64 << 8)),
	( 4 | (63 << 8)),( 4 | (62 << 8)),( 4 | (61 << 8)),( 3 | (60 << 8)),( 3 | (59 << 8)),
	( 3 | (58 << 8)),( 3 | (57 << 8)),( 3 | (56 << 8)),( 3 | (55 << 8)),( 3 | (54 << 8)),
	( 3 | (53 << 8)),( 3 | (52 << 8)),( 2 | (51 << 8)),( 2 | (50 << 8)),( 2 | (49 << 8)),
	( 2 | (48 << 8)),( 2 | (47 << 8)),( 2 | (46 << 8)),( 2 | (45 << 8)),( 2 | (44 << 8)),
	( 2 | (43 << 8)),( 2 | (42 << 8)),( 2 | (41 << 8)),( 2 | (40 << 8)),( 2 | (39 << 8)),
	( 2 | (38 << 8)),( 2 | (37 << 8)),( 1 | (36 << 8)),( 1 | (35 << 8)),( 1 | (34 << 8)),
	( 1 | (33 << 8)),( 1 | (32 << 8)),( 1 | (31 << 8)),( 1 | (30 << 8)),( 1 | (29 << 8)),
	( 1 | (28 << 8)),( 1 | (27 << 8)),( 1 | (26 << 8))
};

unsigned short tiltTable_03[62] = {
	(45 | (86 << 8)),(37 | (85 << 8)),(31 | (84 << 8)),(27 | (83 << 8)),(23 | (82 << 8)),
	(20 | (81 << 8)),(18 | (81 << 8)),(17 | (80 << 8)),(15 | (79 << 8)),(14 | (78 << 8)),
	(13 | (77 << 8)),(12 | (76 << 8)),(11 | (75 << 8)),(10 | (74 << 8)),(10 | (73 << 8)),
	( 9 | (72 << 8)),( 9 | (71 << 8)),( 8 | (70 << 8)),( 8 | (69 << 8)),( 7 | (68 << 8)),
	( 7 | (67 << 8)),( 7 | (66 << 8)),( 6 | (65 << 8)),( 6 | (64 << 8)),( 6 | (63 << 8)),
	( 6 | (62 << 8)),( 5 | (61 << 8)),( 5 | (60 << 8)),( 5 | (59 << 8)),( 5 | (58 << 8)),
	( 5 | (57 << 8)),( 4 | (56 << 8)),( 4 | (55 << 8)),( 4 | (54 << 8)),( 4 | (53 << 8)),
	( 4 | (52 << 8)),( 4 | (51 << 8)),( 4 | (50 << 8)),( 3 | (49 << 8)),( 3 | (48 << 8)),
	( 3 | (47 << 8)),( 3 | (46 << 8)),( 3 | (45 << 8)),( 3 | (44 << 8)),( 3 | (43 << 8)),
	( 3 | (42 << 8)),( 3 | (41 << 8)),( 3 | (40 << 8)),( 2 | (39 << 8)),( 2 | (38 << 8)),
	( 2 | (37 << 8)),( 2 | (36 << 8)),( 2 | (35 << 8)),( 2 | (34 << 8)),( 2 | (33 << 8)),
	( 2 | (32 << 8)),( 2 | (31 << 8)),( 2 | (30 << 8)),( 2 | (29 << 8)),( 2 | (28 << 8)),
	( 2 | (27 << 8)),( 1 | (26 << 8))
};

unsigned short tiltTable_04[61] = {
	(45 | (84 << 8)),(39 | (84 << 8)),(34 | (83 << 8)),(30 | (82 << 8)),(26 | (81 << 8)),
	(24 | (80 << 8)),(22 | (79 << 8)),(20 | (78 << 8)),(18 | (77 << 8)),(17 | (76 << 8)),
	(16 | (75 << 8)),(15 | (75 << 8)),(14 | (74 << 8)),(13 | (73 << 8)),(12 | (72 << 8)),
	(11 | (71 << 8)),(11 | (70 << 8)),(10 | (69 << 8)),(10 | (68 << 8)),( 9 | (67 << 8)),
	( 9 | (66 << 8)),( 9 | (65 << 8)),( 8 | (64 << 8)),( 8 | (63 << 8)),( 7 | (62 << 8)),
	( 7 | (61 << 8)),( 7 | (60 << 8)),( 7 | (59 << 8)),( 6 | (58 << 8)),( 6 | (57 << 8)),
	( 6 | (56 << 8)),( 6 | (55 << 8)),( 5 | (54 << 8)),( 5 | (53 << 8)),( 5 | (52 << 8)),
	( 5 | (51 << 8)),( 5 | (50 << 8)),( 5 | (49 << 8)),( 4 | (48 << 8)),( 4 | (47 << 8)),
	( 4 | (46 << 8)),( 4 | (45 << 8)),( 4 | (44 << 8)),( 4 | (43 << 8)),( 4 | (42 << 8)),
	( 3 | (41 << 8)),( 3 | (40 << 8)),( 3 | (39 << 8)),( 3 | (38 << 8)),( 3 | (37 << 8)),
	( 3 | (36 << 8)),( 3 | (35 << 8)),( 3 | (34 << 8)),( 3 | (33 << 8)),( 3 | (32 << 8)),
	( 2 | (31 << 8)),( 2 | (30 << 8)),( 2 | (29 << 8)),( 2 | (28 << 8)),( 2 | (27 << 8)),
	( 2 | (26 << 8))
};

unsigned short tiltTable_05[60] = {
	(45 | (83 << 8)),(40 | (82 << 8)),(35 | (81 << 8)),(32 | (81 << 8)),(29 | (80 << 8)),
	(26 | (79 << 8)),(24 | (78 << 8)),(22 | (77 << 8)),(21 | (76 << 8)),(19 | (75 << 8)),
	(18 | (74 << 8)),(17 | (73 << 8)),(16 | (72 << 8)),(15 | (71 << 8)),(14 | (70 << 8)),
	(14 | (69 << 8)),(13 | (69 << 8)),(12 | (68 << 8)),(12 | (67 << 8)),(11 | (66 << 8)),
	(11 | (65 << 8)),(10 | (64 << 8)),(10 | (63 << 8)),( 9 | (62 << 8)),( 9 | (61 << 8)),
	( 9 | (60 << 8)),( 8 | (59 << 8)),( 8 | (58 << 8)),( 8 | (57 << 8)),( 7 | (56 << 8)),
	( 7 | (55 << 8)),( 7 | (54 << 8)),( 7 | (53 << 8)),( 6 | (52 << 8)),( 6 | (51 << 8)),
	( 6 | (50 << 8)),( 6 | (49 << 8)),( 6 | (48 << 8)),( 5 | (47 << 8)),( 5 | (46 << 8)),
	( 5 | (45 << 8)),( 5 | (44 << 8)),( 5 | (43 << 8)),( 5 | (42 << 8)),( 4 | (41 << 8)),
	( 4 | (40 << 8)),( 4 | (39 << 8)),( 4 | (38 << 8)),( 4 | (37 << 8)),( 4 | (36 << 8)),
	( 4 | (35 << 8)),( 3 | (34 << 8)),( 3 | (33 << 8)),( 3 | (32 << 8)),( 3 | (31 << 8)),
	( 3 | (30 << 8)),( 3 | (29 << 8)),( 3 | (28 << 8)),( 3 | (27 << 8)),( 2 | (26 << 8))
};

unsigned short tiltTable_06[59] = {
	(45 | (82 << 8)),(41 | (81 << 8)),(37 | (80 << 8)),(34 | (79 << 8)),(31 | (78 << 8)),
	(28 | (78 << 8)),(26 | (77 << 8)),(24 | (76 << 8)),(23 | (75 << 8)),(21 | (74 << 8)),
	(20 | (73 << 8)),(19 | (72 << 8)),(18 | (71 << 8)),(17 | (70 << 8)),(16 | (69 << 8)),
	(15 | (68 << 8)),(15 | (67 << 8)),(14 | (66 << 8)),(13 | (65 << 8)),(13 | (64 << 8)),
	(12 | (63 << 8)),(12 | (63 << 8)),(11 | (62 << 8)),(11 | (61 << 8)),(10 | (60 << 8)),
	(10 | (59 << 8)),(10 | (58 << 8)),( 9 | (57 << 8)),( 9 | (56 << 8)),( 9 | (55 << 8)),
	( 8 | (54 << 8)),( 8 | (53 << 8)),( 8 | (52 << 8)),( 7 | (51 << 8)),( 7 | (50 << 8)),
	( 7 | (49 << 8)),( 7 | (48 << 8)),( 6 | (47 << 8)),( 6 | (46 << 8)),( 6 | (45 << 8)),
	( 6 | (44 << 8)),( 6 | (43 << 8)),( 5 | (42 << 8)),( 5 | (41 << 8)),( 5 | (40 << 8)),
	( 5 | (39 << 8)),( 5 | (38 << 8)),( 5 | (37 << 8)),( 4 | (36 << 8)),( 4 | (35 << 8)),
	( 4 | (34 << 8)),( 4 | (33 << 8)),( 4 | (32 << 8)),( 4 | (31 << 8)),( 3 | (30 << 8)),
	( 3 | (29 << 8)),( 3 | (28 << 8)),( 3 | (27 << 8)),( 3 | (26 << 8))
};

unsigned short tiltTable_07[58] = {
	(45 | (80 << 8)),(41 | (79 << 8)),(38 | (79 << 8)),(35 | (78 << 8)),(32 | (77 << 8)),
	(30 | (76 << 8)),(28 | (75 << 8)),(26 | (74 << 8)),(25 | (74 << 8)),(23 | (73 << 8)),
	(22 | (72 << 8)),(21 | (71 << 8)),(20 | (70 << 8)),(19 | (69 << 8)),(18 | (68 << 8)),
	(17 | (67 << 8)),(16 | (66 << 8)),(15 | (65 << 8)),(15 | (64 << 8)),(14 | (63 << 8)),
	(14 | (62 << 8)),(13 | (61 << 8)),(12 | (60 << 8)),(12 | (59 << 8)),(12 | (58 << 8)),
	(11 | (58 << 8)),(11 | (57 << 8)),(10 | (56 << 8)),(10 | (55 << 8)),(10 | (54 << 8)),
	( 9 | (53 << 8)),( 9 | (52 << 8)),( 9 | (51 << 8)),( 8 | (50 << 8)),( 8 | (49 << 8)),
	( 8 | (48 << 8)),( 8 | (47 << 8)),( 7 | (46 << 8)),( 7 | (45 << 8)),( 7 | (44 << 8)),
	( 7 | (43 << 8)),( 6 | (42 << 8)),( 6 | (41 << 8)),( 6 | (40 << 8)),( 6 | (39 << 8)),
	( 5 | (38 << 8)),( 5 | (37 << 8)),( 5 | (36 << 8)),( 5 | (35 << 8)),( 5 | (34 << 8)),
	( 5 | (33 << 8)),( 4 | (32 << 8)),( 4 | (31 << 8)),( 4 | (30 << 8)),( 4 | (29 << 8)),
	( 4 | (28 << 8)),( 4 | (27 << 8)),( 3 | (26 << 8))
};

unsigned short tiltTable_08[57] = {
	(45 | (79 << 8)),(42 | (78 << 8)),(39 | (77 << 8)),(36 | (77 << 8)),(33 | (76 << 8)),
	(31 | (75 << 8)),(29 | (74 << 8)),(28 | (73 << 8)),(26 | (72 << 8)),(25 | (71 << 8)),
	(23 | (71 << 8)),(22 | (70 << 8)),(21 | (69 << 8)),(20 | (68 << 8)),(19 | (67 << 8)),
	(18 | (66 << 8)),(18 | (65 << 8)),(17 | (64 << 8)),(16 | (63 << 8)),(15 | (62 << 8)),
	(15 | (61 << 8)),(14 | (60 << 8)),(14 | (59 << 8)),(13 | (58 << 8)),(13 | (57 << 8)),
	(12 | (56 << 8)),(12 | (55 << 8)),(11 | (54 << 8)),(11 | (53 << 8)),(11 | (53 << 8)),
	(10 | (52 << 8)),(10 | (51 << 8)),(10 | (50 << 8)),( 9 | (49 << 8)),( 9 | (48 << 8)),
	( 9 | (47 << 8)),( 8 | (46 << 8)),( 8 | (45 << 8)),( 8 | (44 << 8)),( 7 | (43 << 8)),
	( 7 | (42 << 8)),( 7 | (41 << 8)),( 7 | (40 << 8)),( 6 | (39 << 8)),( 6 | (38 << 8)),
	( 6 | (37 << 8)),( 6 | (36 << 8)),( 6 | (35 << 8)),( 5 | (34 << 8)),( 5 | (33 << 8)),
	( 5 | (32 << 8)),( 5 | (31 << 8)),( 5 | (30 << 8)),( 4 | (29 << 8)),( 4 | (28 << 8)),
	( 4 | (27 << 8)),( 4 | (26 << 8))
};

unsigned short tiltTable_09[56] = {
	(45 | (77 << 8)),(42 | (77 << 8)),(39 | (76 << 8)),(37 | (75 << 8)),(34 | (74 << 8)),
	(32 | (74 << 8)),(31 | (73 << 8)),(29 | (72 << 8)),(27 | (71 << 8)),(26 | (70 << 8)),
	(25 | (69 << 8)),(24 | (68 << 8)),(22 | (67 << 8)),(21 | (67 << 8)),(20 | (66 << 8)),
	(20 | (65 << 8)),(19 | (64 << 8)),(18 | (63 << 8)),(17 | (62 << 8)),(17 | (61 << 8)),
	(16 | (60 << 8)),(15 | (59 << 8)),(15 | (58 << 8)),(14 | (57 << 8)),(14 | (56 << 8)),
	(13 | (55 << 8)),(13 | (54 << 8)),(12 | (53 << 8)),(12 | (52 << 8)),(11 | (51 << 8)),
	(11 | (50 << 8)),(11 | (50 << 8)),(10 | (49 << 8)),(10 | (48 << 8)),(10 | (47 << 8)),
	( 9 | (46 << 8)),( 9 | (45 << 8)),( 9 | (44 << 8)),( 8 | (43 << 8)),( 8 | (42 << 8)),
	( 8 | (41 << 8)),( 8 | (40 << 8)),( 7 | (39 << 8)),( 7 | (38 << 8)),( 7 | (37 << 8)),
	( 7 | (36 << 8)),( 6 | (35 << 8)),( 6 | (34 << 8)),( 6 | (33 << 8)),( 6 | (32 << 8)),
	( 5 | (31 << 8)),( 5 | (30 << 8)),( 5 | (29 << 8)),( 5 | (28 << 8)),( 5 | (27 << 8)),
	( 4 | (26 << 8))
};

unsigned short tiltTable_10[55] = {
	(45 | (76 << 8)),(42 | (75 << 8)),(40 | (75 << 8)),(37 | (74 << 8)),(35 | (73 << 8)),
	(33 | (72 << 8)),(32 | (71 << 8)),(30 | (71 << 8)),(28 | (70 << 8)),(27 | (69 << 8)),
	(26 | (68 << 8)),(25 | (67 << 8)),(24 | (66 << 8)),(23 | (65 << 8)),(22 | (64 << 8)),
	(21 | (64 << 8)),(20 | (63 << 8)),(19 | (62 << 8)),(18 | (61 << 8)),(18 | (60 << 8)),
	(17 | (59 << 8)),(16 | (58 << 8)),(16 | (57 << 8)),(15 | (56 << 8)),(15 | (55 << 8)),
	(14 | (54 << 8)),(14 | (53 << 8)),(13 | (52 << 8)),(13 | (51 << 8)),(12 | (50 << 8)),
	(12 | (49 << 8)),(11 | (48 << 8)),(11 | (47 << 8)),(11 | (46 << 8)),(10 | (46 << 8)),
	(10 | (45 << 8)),(10 | (44 << 8)),( 9 | (43 << 8)),( 9 | (42 << 8)),( 9 | (41 << 8)),
	( 8 | (40 << 8)),( 8 | (39 << 8)),( 8 | (38 << 8)),( 8 | (37 << 8)),( 7 | (36 << 8)),
	( 7 | (35 << 8)),( 7 | (34 << 8)),( 7 | (33 << 8)),( 6 | (32 << 8)),( 6 | (31 << 8)),
	( 6 | (30 << 8)),( 6 | (29 << 8)),( 5 | (28 << 8)),( 5 | (27 << 8)),( 5 | (26 << 8))
};

unsigned short tiltTable_11[54] = {
	(45 | (75 << 8)),(42 | (74 << 8)),(40 | (73 << 8)),(38 | (72 << 8)),(36 | (72 << 8)),
	(34 | (71 << 8)),(32 | (70 << 8)),(31 | (69 << 8)),(29 | (68 << 8)),(28 | (68 << 8)),
	(27 | (67 << 8)),(26 | (66 << 8)),(25 | (65 << 8)),(24 | (64 << 8)),(23 | (63 << 8)),
	(22 | (62 << 8)),(21 | (61 << 8)),(20 | (60 << 8)),(19 | (60 << 8)),(19 | (59 << 8)),
	(18 | (58 << 8)),(17 | (57 << 8)),(17 | (56 << 8)),(16 | (55 << 8)),(16 | (54 << 8)),
	(15 | (53 << 8)),(14 | (52 << 8)),(14 | (51 << 8)),(13 | (50 << 8)),(13 | (49 << 8)),
	(13 | (48 << 8)),(12 | (47 << 8)),(12 | (46 << 8)),(11 | (45 << 8)),(11 | (44 << 8)),
	(11 | (44 << 8)),(10 | (43 << 8)),(10 | (42 << 8)),(10 | (41 << 8)),( 9 | (40 << 8)),
	( 9 | (39 << 8)),( 9 | (38 << 8)),( 8 | (37 << 8)),( 8 | (36 << 8)),( 8 | (35 << 8)),
	( 7 | (34 << 8)),( 7 | (33 << 8)),( 7 | (32 << 8)),( 7 | (31 << 8)),( 6 | (30 << 8)),
	( 6 | (29 << 8)),( 6 | (28 << 8)),( 6 | (27 << 8)),( 5 | (26 << 8))
};

unsigned short tiltTable_12[53] = {
	(45 | (73 << 8)),(43 | (73 << 8)),(40 | (72 << 8)),(38 | (71 << 8)),(37 | (70 << 8)),
	(35 | (70 << 8)),(33 | (69 << 8)),(32 | (68 << 8)),(30 | (67 << 8)),(29 | (66 << 8)),
	(28 | (65 << 8)),(27 | (65 << 8)),(26 | (64 << 8)),(25 | (63 << 8)),(24 | (62 << 8)),
	(23 | (61 << 8)),(22 | (60 << 8)),(21 | (59 << 8)),(20 | (58 << 8)),(19 | (57 << 8)),
	(19 | (57 << 8)),(18 | (56 << 8)),(17 | (55 << 8)),(17 | (54 << 8)),(16 | (53 << 8)),
	(16 | (52 << 8)),(15 | (51 << 8)),(15 | (50 << 8)),(14 | (49 << 8)),(14 | (48 << 8)),
	(13 | (47 << 8)),(13 | (46 << 8)),(12 | (45 << 8)),(12 | (44 << 8)),(12 | (43 << 8)),
	(11 | (42 << 8)),(11 | (41 << 8)),(10 | (41 << 8)),(10 | (40 << 8)),(10 | (39 << 8)),
	( 9 | (38 << 8)),( 9 | (37 << 8)),( 9 | (36 << 8)),( 8 | (35 << 8)),( 8 | (34 << 8)),
	( 8 | (33 << 8)),( 8 | (32 << 8)),( 7 | (31 << 8)),( 7 | (30 << 8)),( 7 | (29 << 8)),
	( 6 | (28 << 8)),( 6 | (27 << 8)),( 6 | (26 << 8))
};

unsigned short tiltTable_13[52] = {
	(45 | (72 << 8)),(43 | (71 << 8)),(41 | (71 << 8)),(39 | (70 << 8)),(37 | (69 << 8)),
	(35 | (68 << 8)),(34 | (67 << 8)),(32 | (67 << 8)),(31 | (66 << 8)),(30 | (65 << 8)),
	(29 | (64 << 8)),(27 | (63 << 8)),(26 | (63 << 8)),(25 | (62 << 8)),(24 | (61 << 8)),
	(23 | (60 << 8)),(23 | (59 << 8)),(22 | (58 << 8)),(21 | (57 << 8)),(20 | (56 << 8)),
	(20 | (55 << 8)),(19 | (55 << 8)),(18 | (54 << 8)),(18 | (53 << 8)),(17 | (52 << 8)),
	(16 | (51 << 8)),(16 | (50 << 8)),(15 | (49 << 8)),(15 | (48 << 8)),(14 | (47 << 8)),
	(14 | (46 << 8)),(13 | (45 << 8)),(13 | (44 << 8)),(13 | (43 << 8)),(12 | (42 << 8)),
	(12 | (41 << 8)),(11 | (40 << 8)),(11 | (39 << 8)),(11 | (39 << 8)),(10 | (38 << 8)),
	(10 | (37 << 8)),(10 | (36 << 8)),( 9 | (35 << 8)),( 9 | (34 << 8)),( 9 | (33 << 8)),
	( 8 | (32 << 8)),( 8 | (31 << 8)),( 8 | (30 << 8)),( 7 | (29 << 8)),( 7 | (28 << 8)),
	( 7 | (27 << 8)),( 6 | (26 << 8))
};

unsigned short tiltTable_14[51] = {
	(45 | (71 << 8)),(43 | (70 << 8)),(41 | (69 << 8)),(39 | (68 << 8)),(38 | (68 << 8)),
	(36 | (67 << 8)),(34 | (66 << 8)),(33 | (65 << 8)),(32 | (65 << 8)),(30 | (64 << 8)),
	(29 | (63 << 8)),(28 | (62 << 8)),(27 | (61 << 8)),(26 | (60 << 8)),(25 | (60 << 8)),
	(24 | (59 << 8)),(23 | (58 << 8)),(23 | (57 << 8)),(22 | (56 << 8)),(21 | (55 << 8)),
	(20 | (54 << 8)),(20 | (53 << 8)),(19 | (52 << 8)),(18 | (52 << 8)),(18 | (51 << 8)),
	(17 | (50 << 8)),(17 | (49 << 8)),(16 | (48 << 8)),(15 | (47 << 8)),(15 | (46 << 8)),
	(14 | (45 << 8)),(14 | (44 << 8)),(14 | (43 << 8)),(13 | (42 << 8)),(13 | (41 << 8)),
	(12 | (40 << 8)),(12 | (39 << 8)),(11 | (38 << 8)),(11 | (37 << 8)),(11 | (37 << 8)),
	(10 | (36 << 8)),(10 | (35 << 8)),(10 | (34 << 8)),( 9 | (33 << 8)),( 9 | (32 << 8)),
	( 9 | (31 << 8)),( 8 | (30 << 8)),( 8 | (29 << 8)),( 8 | (28 << 8)),( 7 | (27 << 8)),
	( 7 | (26 << 8))
};

unsigned short tiltTable_15[50] = {
	(45 | (69 << 8)),(43 | (69 << 8)),(41 | (68 << 8)),(40 | (67 << 8)),(38 | (66 << 8)),
	(36 | (66 << 8)),(35 | (65 << 8)),(34 | (64 << 8)),(32 | (63 << 8)),(31 | (63 << 8)),
	(30 | (62 << 8)),(29 | (61 << 8)),(28 | (60 << 8)),(27 | (59 << 8)),(26 | (58 << 8)),
	(25 | (58 << 8)),(24 | (57 << 8)),(23 | (56 << 8)),(22 | (55 << 8)),(22 | (54 << 8)),
	(21 | (53 << 8)),(20 | (52 << 8)),(20 | (51 << 8)),(19 | (50 << 8)),(18 | (50 << 8)),
	(18 | (49 << 8)),(17 | (48 << 8)),(17 | (47 << 8)),(16 | (46 << 8)),(16 | (45 << 8)),
	(15 | (44 << 8)),(15 | (43 << 8)),(14 | (42 << 8)),(14 | (41 << 8)),(13 | (40 << 8)),
	(13 | (39 << 8)),(12 | (38 << 8)),(12 | (37 << 8)),(11 | (36 << 8)),(11 | (35 << 8)),
	(11 | (35 << 8)),(10 | (34 << 8)),(10 | (33 << 8)),(10 | (32 << 8)),( 9 | (31 << 8)),
	( 9 | (30 << 8)),( 8 | (29 << 8)),( 8 | (28 << 8)),( 8 | (27 << 8)),( 7 | (26 << 8))
};

unsigned short tiltTable_16[49] = {
	(45 | (68 << 8)),(43 | (67 << 8)),(41 | (67 << 8)),(40 | (66 << 8)),(38 | (65 << 8)),
	(37 | (64 << 8)),(35 | (64 << 8)),(34 | (63 << 8)),(33 | (62 << 8)),(32 | (61 << 8)),
	(30 | (60 << 8)),(29 | (60 << 8)),(28 | (59 << 8)),(27 | (58 << 8)),(26 | (57 << 8)),
	(26 | (56 << 8)),(25 | (55 << 8)),(24 | (55 << 8)),(23 | (54 << 8)),(22 | (53 << 8)),
	(22 | (52 << 8)),(21 | (51 << 8)),(20 | (50 << 8)),(19 | (49 << 8)),(19 | (48 << 8)),
	(18 | (48 << 8)),(18 | (47 << 8)),(17 | (46 << 8)),(17 | (45 << 8)),(16 | (44 << 8)),
	(15 | (43 << 8)),(15 | (42 << 8)),(14 | (41 << 8)),(14 | (40 << 8)),(14 | (39 << 8)),
	(13 | (38 << 8)),(13 | (37 << 8)),(12 | (36 << 8)),(12 | (35 << 8)),(11 | (34 << 8)),
	(11 | (34 << 8)),(11 | (33 << 8)),(10 | (32 << 8)),(10 | (31 << 8)),( 9 | (30 << 8)),
	( 9 | (29 << 8)),( 9 | (28 << 8)),( 8 | (27 << 8)),( 8 | (26 << 8))
};

unsigned short tiltTable_17[48] = {
	(45 | (67 << 8)),(43 | (66 << 8)),(42 | (65 << 8)),(40 | (65 << 8)),(39 | (64 << 8)),
	(37 | (63 << 8)),(36 | (62 << 8)),(34 | (62 << 8)),(33 | (61 << 8)),(32 | (60 << 8)),
	(31 | (59 << 8)),(30 | (58 << 8)),(29 | (58 << 8)),(28 | (57 << 8)),(27 | (56 << 8)),
	(26 | (55 << 8)),(25 | (54 << 8)),(24 | (53 << 8)),(24 | (53 << 8)),(23 | (52 << 8)),
	(22 | (51 << 8)),(21 | (50 << 8)),(21 | (49 << 8)),(20 | (48 << 8)),(19 | (47 << 8)),
	(19 | (46 << 8)),(18 | (46 << 8)),(18 | (45 << 8)),(17 | (44 << 8)),(16 | (43 << 8)),
	(16 | (42 << 8)),(15 | (41 << 8)),(15 | (40 << 8)),(14 | (39 << 8)),(14 | (38 << 8)),
	(13 | (37 << 8)),(13 | (36 << 8)),(13 | (35 << 8)),(12 | (34 << 8)),(12 | (33 << 8)),
	(11 | (32 << 8)),(11 | (32 << 8)),(10 | (31 << 8)),(10 | (30 << 8)),(10 | (29 << 8)),
	( 9 | (28 << 8)),( 9 | (27 << 8)),( 8 | (26 << 8))
};

unsigned short tiltTable_18[47] = {
	(45 | (65 << 8)),(43 | (65 << 8)),(42 | (64 << 8)),(40 | (63 << 8)),(39 | (63 << 8)),
	(37 | (62 << 8)),(36 | (61 << 8)),(35 | (60 << 8)),(34 | (60 << 8)),(33 | (59 << 8)),
	(31 | (58 << 8)),(30 | (57 << 8)),(29 | (56 << 8)),(28 | (56 << 8)),(27 | (55 << 8)),
	(27 | (54 << 8)),(26 | (53 << 8)),(25 | (52 << 8)),(24 | (51 << 8)),(23 | (51 << 8)),
	(23 | (50 << 8)),(22 | (49 << 8)),(21 | (48 << 8)),(20 | (47 << 8)),(20 | (46 << 8)),
	(19 | (45 << 8)),(19 | (44 << 8)),(18 | (44 << 8)),(17 | (43 << 8)),(17 | (42 << 8)),
	(16 | (41 << 8)),(16 | (40 << 8)),(15 | (39 << 8)),(15 | (38 << 8)),(14 | (37 << 8)),
	(14 | (36 << 8)),(13 | (35 << 8)),(13 | (34 << 8)),(12 | (33 << 8)),(12 | (32 << 8)),
	(11 | (31 << 8)),(11 | (31 << 8)),(11 | (30 << 8)),(10 | (29 << 8)),(10 | (28 << 8)),
	( 9 | (27 << 8)),( 9 | (26 << 8))
};

unsigned short tiltTable_19[46] = {
	(45 | (64 << 8)),(43 | (63 << 8)),(42 | (63 << 8)),(40 | (62 << 8)),(39 | (61 << 8)),
	(38 | (61 << 8)),(36 | (60 << 8)),(35 | (59 << 8)),(34 | (58 << 8)),(33 | (58 << 8)),
	(32 | (57 << 8)),(31 | (56 << 8)),(30 | (55 << 8)),(29 | (54 << 8)),(28 | (54 << 8)),
	(27 | (53 << 8)),(26 | (52 << 8)),(25 | (51 << 8)),(25 | (50 << 8)),(24 | (50 << 8)),
	(23 | (49 << 8)),(22 | (48 << 8)),(22 | (47 << 8)),(21 | (46 << 8)),(20 | (45 << 8)),
	(20 | (44 << 8)),(19 | (43 << 8)),(18 | (43 << 8)),(18 | (42 << 8)),(17 | (41 << 8)),
	(17 | (40 << 8)),(16 | (39 << 8)),(16 | (38 << 8)),(15 | (37 << 8)),(15 | (36 << 8)),
	(14 | (35 << 8)),(14 | (34 << 8)),(13 | (33 << 8)),(13 | (32 << 8)),(12 | (31 << 8)),
	(12 | (30 << 8)),(11 | (30 << 8)),(11 | (29 << 8)),(10 | (28 << 8)),(10 | (27 << 8)),
	(10 | (26 << 8))
};

unsigned short tiltTable_20[45] = {
	(45 | (63 << 8)),(43 | (62 << 8)),(42 | (61 << 8)),(41 | (61 << 8)),(39 | (60 << 8)),
	(38 | (59 << 8)),(37 | (59 << 8)),(36 | (58 << 8)),(34 | (57 << 8)),(33 | (56 << 8)),
	(32 | (56 << 8)),(31 | (55 << 8)),(30 | (54 << 8)),(29 | (53 << 8)),(28 | (53 << 8)),
	(27 | (52 << 8)),(27 | (51 << 8)),(26 | (50 << 8)),(25 | (49 << 8)),(24 | (48 << 8)),
	(23 | (48 << 8)),(23 | (47 << 8)),(22 | (46 << 8)),(21 | (45 << 8)),(21 | (44 << 8)),
	(20 | (43 << 8)),(19 | (42 << 8)),(19 | (41 << 8)),(18 | (41 << 8)),(18 | (40 << 8)),
	(17 | (39 << 8)),(16 | (38 << 8)),(16 | (37 << 8)),(15 | (36 << 8)),(15 | (35 << 8)),
	(14 | (34 << 8)),(14 | (33 << 8)),(13 | (32 << 8)),(13 | (31 << 8)),(12 | (30 << 8)),
	(12 | (29 << 8)),(11 | (29 << 8)),(11 | (28 << 8)),(11 | (27 << 8)),(10 | (26 << 8))
};

unsigned short tiltTable_21[44] = {
	(45 | (62 << 8)),(44 | (61 << 8)),(42 | (60 << 8)),(41 | (60 << 8)),(39 | (59 << 8)),
	(38 | (58 << 8)),(37 | (57 << 8)),(36 | (57 << 8)),(35 | (56 << 8)),(34 | (55 << 8)),
	(33 | (55 << 8)),(32 | (54 << 8)),(31 | (53 << 8)),(30 | (52 << 8)),(29 | (51 << 8)),
	(28 | (51 << 8)),(27 | (50 << 8)),(26 | (49 << 8)),(25 | (48 << 8)),(25 | (47 << 8)),
	(24 | (46 << 8)),(23 | (46 << 8)),(22 | (45 << 8)),(22 | (44 << 8)),(21 | (43 << 8)),
	(20 | (42 << 8)),(20 | (41 << 8)),(19 | (40 << 8)),(18 | (40 << 8)),(18 | (39 << 8)),
	(17 | (38 << 8)),(17 | (37 << 8)),(16 | (36 << 8)),(16 | (35 << 8)),(15 | (34 << 8)),
	(15 | (33 << 8)),(14 | (32 << 8)),(13 | (31 << 8)),(13 | (30 << 8)),(12 | (29 << 8)),
	(12 | (28 << 8)),(12 | (28 << 8)),(11 | (27 << 8)),(11 | (26 << 8))
};

unsigned short tiltTable_22[43] = {
	(45 | (60 << 8)),(44 | (60 << 8)),(42 | (59 << 8)),(41 | (58 << 8)),(40 | (58 << 8)),
	(38 | (57 << 8)),(37 | (56 << 8)),(36 | (56 << 8)),(35 | (55 << 8)),(34 | (54 << 8)),
	(33 | (53 << 8)),(32 | (53 << 8)),(31 | (52 << 8)),(30 | (51 << 8)),(29 | (50 << 8)),
	(28 | (49 << 8)),(27 | (49 << 8)),(27 | (48 << 8)),(26 | (47 << 8)),(25 | (46 << 8)),
	(24 | (45 << 8)),(23 | (45 << 8)),(23 | (44 << 8)),(22 | (43 << 8)),(21 | (42 << 8)),
	(21 | (41 << 8)),(20 | (40 << 8)),(19 | (39 << 8)),(19 | (38 << 8)),(18 | (38 << 8)),
	(18 | (37 << 8)),(17 | (36 << 8)),(16 | (35 << 8)),(16 | (34 << 8)),(15 | (33 << 8)),
	(15 | (32 << 8)),(14 | (31 << 8)),(14 | (30 << 8)),(13 | (29 << 8)),(13 | (28 << 8)),
	(12 | (27 << 8)),(12 | (27 << 8)),(11 | (26 << 8))
};

unsigned short tiltTable_23[42] = {
	(45 | (59 << 8)),(44 | (58 << 8)),(42 | (58 << 8)),(41 | (57 << 8)),(40 | (56 << 8)),
	(39 | (56 << 8)),(37 | (55 << 8)),(36 | (54 << 8)),(35 | (54 << 8)),(34 | (53 << 8)),
	(33 | (52 << 8)),(32 | (51 << 8)),(31 | (51 << 8)),(30 | (50 << 8)),(29 | (49 << 8)),
	(29 | (48 << 8)),(28 | (48 << 8)),(27 | (47 << 8)),(26 | (46 << 8)),(25 | (45 << 8)),
	(24 | (44 << 8)),(24 | (43 << 8)),(23 | (43 << 8)),(22 | (42 << 8)),(22 | (41 << 8)),
	(21 | (40 << 8)),(20 | (39 << 8)),(20 | (38 << 8)),(19 | (37 << 8)),(18 | (37 << 8)),
	(18 | (36 << 8)),(17 | (35 << 8)),(17 | (34 << 8)),(16 | (33 << 8)),(15 | (32 << 8)),
	(15 | (31 << 8)),(14 | (30 << 8)),(14 | (29 << 8)),(13 | (28 << 8)),(13 | (27 << 8)),
	(12 | (26 << 8)),(12 | (26 << 8))
};

unsigned short tiltTable_24[41] = {
	(45 | (58 << 8)),(44 | (57 << 8)),(42 | (57 << 8)),(41 | (56 << 8)),(40 | (55 << 8)),
	(39 | (55 << 8)),(38 | (54 << 8)),(37 | (53 << 8)),(35 | (53 << 8)),(34 | (52 << 8)),
	(33 | (51 << 8)),(32 | (50 << 8)),(32 | (50 << 8)),(31 | (49 << 8)),(30 | (48 << 8)),
	(29 | (47 << 8)),(28 | (46 << 8)),(27 | (46 << 8)),(26 | (45 << 8)),(26 | (44 << 8)),
	(25 | (43 << 8)),(24 | (42 << 8)),(23 | (42 << 8)),(23 | (41 << 8)),(22 | (40 << 8)),
	(21 | (39 << 8)),(20 | (38 << 8)),(20 | (37 << 8)),(19 | (36 << 8)),(19 | (36 << 8)),
	(18 | (35 << 8)),(17 | (34 << 8)),(17 | (33 << 8)),(16 | (32 << 8)),(16 | (31 << 8)),
	(15 | (30 << 8)),(14 | (29 << 8)),(14 | (28 << 8)),(13 | (27 << 8)),(13 | (26 << 8)),
	(12 | (25 << 8))
};

unsigned short tiltTable_25[40] = {
	(45 | (57 << 8)),(44 | (56 << 8)),(42 | (55 << 8)),(41 | (55 << 8)),(40 | (54 << 8)),
	(39 | (53 << 8)),(38 | (53 << 8)),(37 | (52 << 8)),(36 | (51 << 8)),(35 | (51 << 8)),
	(34 | (50 << 8)),(33 | (49 << 8)),(32 | (48 << 8)),(31 | (48 << 8)),(30 | (47 << 8)),
	(29 | (46 << 8)),(28 | (45 << 8)),(27 | (45 << 8)),(27 | (44 << 8)),(26 | (43 << 8)),
	(25 | (42 << 8)),(24 | (41 << 8)),(24 | (41 << 8)),(23 | (40 << 8)),(22 | (39 << 8)),
	(21 | (38 << 8)),(21 | (37 << 8)),(20 | (36 << 8)),(19 | (35 << 8)),(19 | (35 << 8)),
	(18 | (34 << 8)),(17 | (33 << 8)),(17 | (32 << 8)),(16 | (31 << 8)),(16 | (30 << 8)),
	(15 | (29 << 8)),(14 | (28 << 8)),(14 | (27 << 8)),(13 | (26 << 8)),(13 | (25 << 8))
};

unsigned short tiltTable_26[39] = {
	(45 | (55 << 8)),(44 | (55 << 8)),(43 | (54 << 8)),(41 | (54 << 8)),(40 | (53 << 8)),
	(39 | (52 << 8)),(38 | (52 << 8)),(37 | (51 << 8)),(36 | (50 << 8)),(35 | (50 << 8)),
	(34 | (49 << 8)),(33 | (48 << 8)),(32 | (47 << 8)),(31 | (47 << 8)),(30 | (46 << 8)),
	(29 | (45 << 8)),(28 | (44 << 8)),(28 | (44 << 8)),(27 | (43 << 8)),(26 | (42 << 8)),
	(25 | (41 << 8)),(24 | (40 << 8)),(24 | (40 << 8)),(23 | (39 << 8)),(22 | (38 << 8)),
	(22 | (37 << 8)),(21 | (36 << 8)),(20 | (35 << 8)),(20 | (34 << 8)),(19 | (34 << 8)),
	(18 | (33 << 8)),(18 | (32 << 8)),(17 | (31 << 8)),(16 | (30 << 8)),(16 | (29 << 8)),
	(15 | (28 << 8)),(15 | (27 << 8)),(14 | (26 << 8)),(13 | (25 << 8))
};

unsigned short tiltTable_27[38] = {
	(45 | (54 << 8)),(44 | (54 << 8)),(43 | (53 << 8)),(41 | (52 << 8)),(40 | (52 << 8)),
	(39 | (51 << 8)),(38 | (50 << 8)),(37 | (50 << 8)),(36 | (49 << 8)),(35 | (48 << 8)),
	(34 | (48 << 8)),(33 | (47 << 8)),(32 | (46 << 8)),(31 | (46 << 8)),(30 | (45 << 8)),
	(30 | (44 << 8)),(29 | (43 << 8)),(28 | (42 << 8)),(27 | (42 << 8)),(26 | (41 << 8)),
	(25 | (40 << 8)),(25 | (39 << 8)),(24 | (38 << 8)),(23 | (38 << 8)),(22 | (37 << 8)),
	(22 | (36 << 8)),(21 | (35 << 8)),(20 | (34 << 8)),(20 | (33 << 8)),(19 | (33 << 8)),
	(18 | (32 << 8)),(18 | (31 << 8)),(17 | (30 << 8)),(16 | (29 << 8)),(16 | (28 << 8)),
	(15 | (27 << 8)),(15 | (26 << 8)),(14 | (25 << 8))
};

unsigned short tiltTable_28[37] = {
	(45 | (53 << 8)),(44 | (52 << 8)),(43 | (52 << 8)),(42 | (51 << 8)),(40 | (51 << 8)),
	(39 | (50 << 8)),(38 | (49 << 8)),(37 | (49 << 8)),(36 | (48 << 8)),(35 | (47 << 8)),
	(34 | (47 << 8)),(33 | (46 << 8)),(32 | (45 << 8)),(31 | (44 << 8)),(31 | (44 << 8)),
	(30 | (43 << 8)),(29 | (42 << 8)),(28 | (41 << 8)),(27 | (41 << 8)),(26 | (40 << 8)),
	(26 | (39 << 8)),(25 | (38 << 8)),(24 | (37 << 8)),(23 | (37 << 8)),(23 | (36 << 8)),
	(22 | (35 << 8)),(21 | (34 << 8)),(20 | (33 << 8)),(20 | (32 << 8)),(19 | (32 << 8)),
	(18 | (31 << 8)),(18 | (30 << 8)),(17 | (29 << 8)),(16 | (28 << 8)),(16 | (27 << 8)),
	(15 | (26 << 8)),(15 | (25 << 8))
};

unsigned short tiltTable_29[36] = {
	(45 | (52 << 8)),(44 | (51 << 8)),(43 | (51 << 8)),(42 | (50 << 8)),(40 | (50 << 8)),
	(39 | (49 << 8)),(38 | (48 << 8)),(37 | (48 << 8)),(36 | (47 << 8)),(35 | (46 << 8)),
	(34 | (46 << 8)),(33 | (45 << 8)),(33 | (44 << 8)),(32 | (43 << 8)),(31 | (43 << 8)),
	(30 | (42 << 8)),(29 | (41 << 8)),(28 | (40 << 8)),(27 | (40 << 8)),(27 | (39 << 8)),
	(26 | (38 << 8)),(25 | (37 << 8)),(24 | (36 << 8)),(23 | (36 << 8)),(23 | (35 << 8)),
	(22 | (34 << 8)),(21 | (33 << 8)),(21 | (32 << 8)),(20 | (31 << 8)),(19 | (31 << 8)),
	(18 | (30 << 8)),(18 | (29 << 8)),(17 | (28 << 8)),(16 | (27 << 8)),(16 | (26 << 8)),
	(15 | (25 << 8))
};

unsigned short tiltTable_30[35] = {
	(45 | (51 << 8)),(44 | (50 << 8)),(43 | (50 << 8)),(42 | (49 << 8)),(41 | (48 << 8)),
	(40 | (48 << 8)),(38 | (47 << 8)),(37 | (46 << 8)),(36 | (46 << 8)),(35 | (45 << 8)),
	(35 | (44 << 8)),(34 | (44 << 8)),(33 | (43 << 8)),(32 | (42 << 8)),(31 | (42 << 8)),
	(30 | (41 << 8)),(29 | (40 << 8)),(28 | (39 << 8)),(27 | (39 << 8)),(27 | (38 << 8)),
	(26 | (37 << 8)),(25 | (36 << 8)),(24 | (35 << 8)),(24 | (35 << 8)),(23 | (34 << 8)),
	(22 | (33 << 8)),(21 | (32 << 8)),(21 | (31 << 8)),(20 | (30 << 8)),(19 | (30 << 8)),
	(18 | (29 << 8)),(18 | (28 << 8)),(17 | (27 << 8)),(16 | (26 << 8)),(16 | (25 << 8))
};

unsigned short tiltTable_31[34] = {
	(45 | (50 << 8)),(44 | (49 << 8)),(43 | (48 << 8)),(42 | (48 << 8)),(41 | (47 << 8)),
	(40 | (47 << 8)),(39 | (46 << 8)),(38 | (45 << 8)),(37 | (45 << 8)),(36 | (44 << 8)),
	(35 | (43 << 8)),(34 | (43 << 8)),(33 | (42 << 8)),(32 | (41 << 8)),(31 | (41 << 8)),
	(30 | (40 << 8)),(29 | (39 << 8)),(28 | (38 << 8)),(28 | (38 << 8)),(27 | (37 << 8)),
	(26 | (36 << 8)),(25 | (35 << 8)),(24 | (34 << 8)),(24 | (34 << 8)),(23 | (33 << 8)),
	(22 | (32 << 8)),(21 | (31 << 8)),(21 | (30 << 8)),(20 | (29 << 8)),(19 | (29 << 8)),
	(18 | (28 << 8)),(18 | (27 << 8)),(17 | (26 << 8)),(16 | (25 << 8))
};

unsigned short tiltTable_32[33] = {
	(45 | (49 << 8)),(44 | (48 << 8)),(43 | (47 << 8)),(42 | (47 << 8)),(41 | (46 << 8)),
	(40 | (46 << 8)),(39 | (45 << 8)),(38 | (44 << 8)),(37 | (44 << 8)),(36 | (43 << 8)),
	(35 | (42 << 8)),(34 | (42 << 8)),(33 | (41 << 8)),(32 | (40 << 8)),(31 | (40 << 8)),
	(30 | (39 << 8)),(29 | (38 << 8)),(29 | (37 << 8)),(28 | (37 << 8)),(27 | (36 << 8)),
	(26 | (35 << 8)),(25 | (34 << 8)),(24 | (33 << 8)),(24 | (33 << 8)),(23 | (32 << 8)),
	(22 | (31 << 8)),(21 | (30 << 8)),(21 | (29 << 8)),(20 | (29 << 8)),(19 | (28 << 8)),
	(18 | (27 << 8)),(18 | (26 << 8)),(17 | (25 << 8))
};

unsigned short tiltTable_33[32] = {
	(45 | (47 << 8)),(44 | (47 << 8)),(43 | (46 << 8)),(42 | (46 << 8)),(41 | (45 << 8)),
	(40 | (45 << 8)),(39 | (44 << 8)),(38 | (43 << 8)),(37 | (43 << 8)),(36 | (42 << 8)),
	(35 | (41 << 8)),(34 | (41 << 8)),(33 | (40 << 8)),(32 | (39 << 8)),(31 | (39 << 8)),
	(30 | (38 << 8)),(29 | (37 << 8)),(29 | (36 << 8)),(28 | (36 << 8)),(27 | (35 << 8)),
	(26 | (34 << 8)),(25 | (33 << 8)),(24 | (33 << 8)),(24 | (32 << 8)),(23 | (31 << 8)),
	(22 | (30 << 8)),(21 | (29 << 8)),(21 | (28 << 8)),(20 | (28 << 8)),(19 | (27 << 8)),
	(18 | (26 << 8)),(18 | (25 << 8))
};

unsigned short tiltTable_34[31] = {
	(45 | (46 << 8)),(44 | (46 << 8)),(43 | (45 << 8)),(42 | (45 << 8)),(41 | (44 << 8)),
	(40 | (43 << 8)),(39 | (43 << 8)),(38 | (42 << 8)),(37 | (42 << 8)),(36 | (41 << 8)),
	(35 | (40 << 8)),(34 | (40 << 8)),(33 | (39 << 8)),(32 | (38 << 8)),(31 | (38 << 8)),
	(30 | (37 << 8)),(30 | (36 << 8)),(29 | (35 << 8)),(28 | (35 << 8)),(27 | (34 << 8)),
	(26 | (33 << 8)),(25 | (32 << 8)),(24 | (32 << 8)),(24 | (31 << 8)),(23 | (30 << 8)),
	(22 | (29 << 8)),(21 | (28 << 8)),(21 | (27 << 8)),(20 | (27 << 8)),(19 | (26 << 8)),
	(18 | (25 << 8))
};

unsigned short tiltTable_35[30] = {
	(45 | (45 << 8)),(44 | (45 << 8)),(43 | (44 << 8)),(42 | (44 << 8)),(41 | (43 << 8)),
	(40 | (42 << 8)),(39 | (42 << 8)),(38 | (41 << 8)),(37 | (41 << 8)),(36 | (40 << 8)),
	(35 | (39 << 8)),(34 | (39 << 8)),(33 | (38 << 8)),(32 | (37 << 8)),(31 | (37 << 8)),
	(30 | (36 << 8)),(30 | (35 << 8)),(29 | (34 << 8)),(28 | (34 << 8)),(27 | (33 << 8)),
	(26 | (32 << 8)),(25 | (31 << 8)),(24 | (31 << 8)),(24 | (30 << 8)),(23 | (29 << 8)),
	(22 | (28 << 8)),(21 | (27 << 8)),(20 | (26 << 8)),(20 | (26 << 8)),(19 | (25 << 8))
};

unsigned short tiltTable_36[29] = {
	(45 | (44 << 8)),(44 | (44 << 8)),(43 | (43 << 8)),(42 | (43 << 8)),(41 | (42 << 8)),
	(40 | (41 << 8)),(39 | (41 << 8)),(38 | (40 << 8)),(37 | (40 << 8)),(36 | (39 << 8)),
	(35 | (38 << 8)),(34 | (38 << 8)),(33 | (37 << 8)),(32 | (36 << 8)),(31 | (36 << 8)),
	(30 | (35 << 8)),(30 | (34 << 8)),(29 | (33 << 8)),(28 | (33 << 8)),(27 | (32 << 8)),
	(26 | (31 << 8)),(25 | (30 << 8)),(24 | (30 << 8)),(24 | (29 << 8)),(23 | (28 << 8)),
	(22 | (27 << 8)),(21 | (26 << 8)),(20 | (26 << 8)),(20 | (25 << 8))
};

unsigned short tiltTable_37[28] = {
	(45 | (43 << 8)),(44 | (43 << 8)),(43 | (42 << 8)),(42 | (42 << 8)),(41 | (41 << 8)),
	(40 | (40 << 8)),(39 | (40 << 8)),(38 | (39 << 8)),(37 | (39 << 8)),(36 | (38 << 8)),
	(35 | (37 << 8)),(34 | (37 << 8)),(33 | (36 << 8)),(32 | (35 << 8)),(31 | (35 << 8)),
	(30 | (34 << 8)),(30 | (33 << 8)),(29 | (33 << 8)),(28 | (32 << 8)),(27 | (31 << 8)),
	(26 | (30 << 8)),(25 | (29 << 8)),(24 | (29 << 8)),(24 | (28 << 8)),(23 | (27 << 8)),
	(22 | (26 << 8)),(21 | (25 << 8)),(20 | (25 << 8))
};

unsigned short tiltTable_38[27] = {
	(45 | (42 << 8)),(44 | (42 << 8)),(43 | (41 << 8)),(42 | (41 << 8)),(41 | (40 << 8)),
	(40 | (39 << 8)),(39 | (39 << 8)),(38 | (38 << 8)),(37 | (38 << 8)),(36 | (37 << 8)),
	(35 | (36 << 8)),(34 | (36 << 8)),(33 | (35 << 8)),(32 | (34 << 8)),(31 | (34 << 8)),
	(30 | (33 << 8)),(30 | (32 << 8)),(29 | (32 << 8)),(28 | (31 << 8)),(27 | (30 << 8)),
	(26 | (29 << 8)),(25 | (29 << 8)),(24 | (28 << 8)),(23 | (27 << 8)),(23 | (26 << 8)),
	(22 | (25 << 8)),(21 | (25 << 8))
};

unsigned short tiltTable_39[26] = {
	(45 | (41 << 8)),(44 | (41 << 8)),(43 | (40 << 8)),(42 | (40 << 8)),(41 | (39 << 8)),
	(40 | (38 << 8)),(39 | (38 << 8)),(38 | (37 << 8)),(37 | (37 << 8)),(36 | (36 << 8)),
	(35 | (35 << 8)),(34 | (35 << 8)),(33 | (34 << 8)),(32 | (33 << 8)),(31 | (33 << 8)),
	(30 | (32 << 8)),(30 | (31 << 8)),(29 | (31 << 8)),(28 | (30 << 8)),(27 | (29 << 8)),
	(26 | (28 << 8)),(25 | (28 << 8)),(24 | (27 << 8)),(23 | (26 << 8)),(22 | (25 << 8)),
	(22 | (24 << 8))
};

unsigned short tiltTable_40[25] = {
	(45 | (40 << 8)),(44 | (40 << 8)),(43 | (39 << 8)),(42 | (39 << 8)),(41 | (38 << 8)),
	(40 | (37 << 8)),(39 | (37 << 8)),(38 | (36 << 8)),(37 | (36 << 8)),(36 | (35 << 8)),
	(35 | (34 << 8)),(34 | (34 << 8)),(33 | (33 << 8)),(32 | (32 << 8)),(31 | (32 << 8)),
	(30 | (31 << 8)),(30 | (30 << 8)),(29 | (30 << 8)),(28 | (29 << 8)),(27 | (28 << 8)),
	(26 | (27 << 8)),(25 | (27 << 8)),(24 | (26 << 8)),(23 | (25 << 8)),(22 | (24 << 8))
};

unsigned short tiltTable_41[24] = {
	(45 | (39 << 8)),(44 | (39 << 8)),(43 | (38 << 8)),(42 | (38 << 8)),(41 | (37 << 8)),
	(40 | (36 << 8)),(39 | (36 << 8)),(38 | (35 << 8)),(37 | (35 << 8)),(36 | (34 << 8)),
	(35 | (34 << 8)),(34 | (33 << 8)),(33 | (32 << 8)),(32 | (32 << 8)),(31 | (31 << 8)),
	(30 | (30 << 8)),(29 | (29 << 8)),(29 | (29 << 8)),(28 | (28 << 8)),(27 | (27 << 8)),
	(26 | (27 << 8)),(25 | (26 << 8)),(24 | (25 << 8)),(23 | (24 << 8))
};

unsigned short tiltTable_42[23] = {
	(45 | (38 << 8)),(44 | (38 << 8)),(43 | (37 << 8)),(42 | (37 << 8)),(41 | (36 << 8)),
	(40 | (36 << 8)),(39 | (35 << 8)),(38 | (34 << 8)),(37 | (34 << 8)),(36 | (33 << 8)),
	(35 | (33 << 8)),(34 | (32 << 8)),(33 | (31 << 8)),(32 | (31 << 8)),(31 | (30 << 8)),
	(30 | (29 << 8)),(29 | (29 << 8)),(28 | (28 << 8)),(27 | (27 << 8)),(27 | (26 << 8)),
	(26 | (26 << 8)),(25 | (25 << 8)),(24 | (24 << 8))
};

unsigned short tiltTable_43[22] = {
	(45 | (37 << 8)),(44 | (37 << 8)),(43 | (36 << 8)),(42 | (36 << 8)),(41 | (35 << 8)),
	(40 | (35 << 8)),(39 | (34 << 8)),(38 | (33 << 8)),(37 | (33 << 8)),(36 | (32 << 8)),
	(35 | (32 << 8)),(34 | (31 << 8)),(33 | (30 << 8)),(32 | (30 << 8)),(31 | (29 << 8)),
	(30 | (28 << 8)),(29 | (28 << 8)),(28 | (27 << 8)),(27 | (26 << 8)),(26 | (25 << 8)),
	(25 | (25 << 8)),(24 | (24 << 8))
};

unsigned short tiltTable_44[21] = {
	(45 | (36 << 8)),(44 | (36 << 8)),(43 | (35 << 8)),(42 | (35 << 8)),(41 | (34 << 8)),
	(40 | (34 << 8)),(39 | (33 << 8)),(38 | (33 << 8)),(37 | (32 << 8)),(36 | (31 << 8)),
	(35 | (31 << 8)),(34 | (30 << 8)),(33 | (29 << 8)),(32 | (29 << 8)),(31 | (28 << 8)),
	(30 | (27 << 8)),(29 | (27 << 8)),(28 | (26 << 8)),(27 | (25 << 8)),(26 | (25 << 8)),
	(25 | (24 << 8))
};

unsigned short tiltTable_45[20] = {
	(45 | (35 << 8)),(44 | (35 << 8)),(43 | (34 << 8)),(42 | (34 << 8)),(41 | (33 << 8)),
	(40 | (33 << 8)),(39 | (32 << 8)),(38 | (32 << 8)),(37 | (31 << 8)),(36 | (30 << 8)),
	(35 | (30 << 8)),(34 | (29 << 8)),(33 | (29 << 8)),(32 | (28 << 8)),(31 | (27 << 8)),
	(30 | (27 << 8)),(29 | (26 << 8)),(28 | (25 << 8)),(27 | (24 << 8)),(26 | (24 << 8))
};

unsigned short tiltTable_46[19] = {
	(45 | (34 << 8)),(44 | (34 << 8)),(43 | (33 << 8)),(42 | (33 << 8)),(41 | (32 << 8)),
	(40 | (32 << 8)),(39 | (31 << 8)),(38 | (31 << 8)),(37 | (30 << 8)),(36 | (30 << 8)),
	(35 | (29 << 8)),(34 | (28 << 8)),(33 | (28 << 8)),(32 | (27 << 8)),(31 | (26 << 8)),
	(30 | (26 << 8)),(29 | (25 << 8)),(28 | (24 << 8)),(27 | (24 << 8))
};

unsigned short tiltTable_47[18] = {
	(45 | (33 << 8)),(44 | (33 << 8)),(43 | (32 << 8)),(42 | (32 << 8)),(41 | (31 << 8)),
	(40 | (31 << 8)),(39 | (30 << 8)),(38 | (30 << 8)),(37 | (29 << 8)),(36 | (29 << 8)),
	(35 | (28 << 8)),(34 | (27 << 8)),(33 | (27 << 8)),(32 | (26 << 8)),(31 | (25 << 8)),
	(30 | (25 << 8)),(29 | (24 << 8)),(28 | (23 << 8))
};

unsigned short tiltTable_48[17] = {
	(45 | (32 << 8)),(44 | (32 << 8)),(43 | (32 << 8)),(42 | (31 << 8)),(41 | (31 << 8)),
	(40 | (30 << 8)),(39 | (29 << 8)),(38 | (29 << 8)),(37 | (28 << 8)),(36 | (28 << 8)),
	(35 | (27 << 8)),(34 | (27 << 8)),(33 | (26 << 8)),(32 | (25 << 8)),(31 | (25 << 8)),
	(30 | (24 << 8)),(28 | (23 << 8))
};

unsigned short tiltTable_49[16] = {
	(45 | (32 << 8)),(44 | (31 << 8)),(43 | (31 << 8)),(42 | (30 << 8)),(41 | (30 << 8)),
	(40 | (29 << 8)),(39 | (29 << 8)),(38 | (28 << 8)),(37 | (27 << 8)),(36 | (27 << 8)),
	(35 | (26 << 8)),(34 | (26 << 8)),(33 | (25 << 8)),(31 | (24 << 8)),(30 | (24 << 8)),
	(29 | (23 << 8))
};

unsigned short tiltTable_50[15] = {
	(45 | (31 << 8)),(44 | (30 << 8)),(43 | (30 << 8)),(42 | (29 << 8)),(41 | (29 << 8)),
	(40 | (28 << 8)),(39 | (28 << 8)),(38 | (27 << 8)),(37 | (27 << 8)),(36 | (26 << 8)),
	(35 | (25 << 8)),(33 | (25 << 8)),(32 | (24 << 8)),(31 | (24 << 8)),(30 | (23 << 8))
};

unsigned short tiltTable_51[14] = {
	(45 | (30 << 8)),(44 | (29 << 8)),(43 | (29 << 8)),(42 | (28 << 8)),(41 | (28 << 8)),
	(40 | (27 << 8)),(39 | (27 << 8)),(38 | (26 << 8)),(37 | (26 << 8)),(35 | (25 << 8)),
	(34 | (25 << 8)),(33 | (24 << 8)),(32 | (23 << 8)),(31 | (23 << 8))
};

unsigned short tiltTable_52[13] = {
	(45 | (29 << 8)),(44 | (28 << 8)),(43 | (28 << 8)),(42 | (28 << 8)),(41 | (27 << 8)),
	(40 | (27 << 8)),(39 | (26 << 8)),(38 | (25 << 8)),(36 | (25 << 8)),(35 | (24 << 8)),
	(34 | (24 << 8)),(33 | (23 << 8)),(32 | (22 << 8))
};

unsigned short tiltTable_53[12] = {
	(45 | (28 << 8)),(44 | (28 << 8)),(43 | (27 << 8)),(42 | (27 << 8)),(41 | (26 << 8)),
	(40 | (26 << 8)),(39 | (25 << 8)),(37 | (25 << 8)),(36 | (24 << 8)),(35 | (23 << 8)),
	(34 | (23 << 8)),(33 | (22 << 8))
};

unsigned short tiltTable_54[11] = {
	(45 | (27 << 8)),(44 | (27 << 8)),(43 | (26 << 8)),(42 | (26 << 8)),(41 | (25 << 8)),
	(40 | (25 << 8)),(38 | (24 << 8)),(37 | (24 << 8)),(36 | (23 << 8)),(35 | (23 << 8)),
	(34 | (22 << 8))
};

unsigned short tiltTable_55[10] = {
	(45 | (26 << 8)),(44 | (26 << 8)),(43 | (25 << 8)),(42 | (25 << 8)),(41 | (25 << 8)),
	(40 | (24 << 8)),(38 | (23 << 8)),(37 | (23 << 8)),(36 | (22 << 8)),(35 | (22 << 8))
};

unsigned short tiltTable_56[9] = {
	(45 | (25 << 8)),(44 | (25 << 8)),(43 | (25 << 8)),(42 | (24 << 8)),(41 | (24 << 8)),
	(39 | (23 << 8)),(38 | (23 << 8)),(37 | (22 << 8)),(36 | (22 << 8))
};

unsigned short tiltTable_57[8] = {
	(45 | (25 << 8)),(44 | (24 << 8)),(43 | (24 << 8)),(42 | (23 << 8)),(40 | (23 << 8)),
	(39 | (22 << 8)),(38 | (22 << 8)),(37 | (21 << 8))
};

unsigned short tiltTable_58[7] = {
	(45 | (24 << 8)),(44 | (23 << 8)),(43 | (23 << 8)),(42 | (23 << 8)),(40 | (22 << 8)),
	(39 | (22 << 8)),(38 | (21 << 8))
};

unsigned short tiltTable_59[6] = {
	(45 | (23 << 8)),(44 | (23 << 8)),(43 | (22 << 8)),(42 | (22 << 8)),(40 | (21 << 8)),
	(39 | (21 << 8))
};

unsigned short tiltTable_60[5] = {
	(45 | (22 << 8)),(44 | (22 << 8)),(43 | (21 << 8)),(41 | (21 << 8)),(40 | (20 << 8))
};

unsigned short tiltTable_61[4] = {
	(45 | (21 << 8)),(44 | (21 << 8)),(43 | (21 << 8)),(41 | (20 << 8))
};

unsigned short tiltTable_62[3] = {
	(45 | (21 << 8)),(44 | (20 << 8)),(43 | (20 << 8))
};

unsigned short tiltTable_63[2] = {
	(45 | (20 << 8)),(44 | (19 << 8))
};

unsigned short tiltTable_64[1] = {
	(45 | (19 << 8))
};

unsigned short *cTable[] = {
	&tiltTable_00[0],&tiltTable_01[0],&tiltTable_02[0],&tiltTable_03[0],&tiltTable_04[0],&tiltTable_05[0],
	&tiltTable_06[0],&tiltTable_07[0],&tiltTable_08[0],&tiltTable_09[0],&tiltTable_10[0],&tiltTable_11[0],
	&tiltTable_12[0],&tiltTable_13[0],&tiltTable_14[0],&tiltTable_15[0],&tiltTable_16[0],&tiltTable_17[0],
	&tiltTable_18[0],&tiltTable_19[0],&tiltTable_20[0],&tiltTable_21[0],&tiltTable_22[0],&tiltTable_23[0],
	&tiltTable_24[0],&tiltTable_25[0],&tiltTable_26[0],&tiltTable_27[0],&tiltTable_28[0],&tiltTable_29[0],
	&tiltTable_30[0],&tiltTable_31[0],&tiltTable_32[0],&tiltTable_33[0],&tiltTable_34[0],&tiltTable_35[0],
	&tiltTable_36[0],&tiltTable_37[0],&tiltTable_38[0],&tiltTable_39[0],&tiltTable_40[0],&tiltTable_41[0],
	&tiltTable_42[0],&tiltTable_43[0],&tiltTable_44[0],&tiltTable_45[0],&tiltTable_46[0],&tiltTable_47[0],
	&tiltTable_48[0],&tiltTable_49[0],&tiltTable_50[0],&tiltTable_51[0],&tiltTable_52[0],&tiltTable_53[0],
	&tiltTable_54[0],&tiltTable_55[0],&tiltTable_56[0],&tiltTable_57[0],&tiltTable_58[0],&tiltTable_59[0],
	&tiltTable_60[0],&tiltTable_61[0],&tiltTable_62[0],&tiltTable_63[0],&tiltTable_64[0]
};

/*****************************************************************************
 *  xf86WcmTilt2R -
 *   Converts tilt X and Y to rotation, for Intuos4 mouse for now. 
 *   It can be used for other devices when necessary.
 ****************************************************************************/

void xf86WcmTilt2R(WacomDeviceStatePtr ds)
{
	short tilt_x = ds->tiltx;
	short tilt_y = ds->tilty;

	short offset = -180;
	unsigned short *xyTable;

	if (tilt_x < 0)
	{
		tilt_x = -tilt_x;
		offset *= -1;
	}

	if (tilt_y <= 0)
	{
		tilt_y = -tilt_y;
		offset *= -1;
		offset -= 180;
	}

	if (tilt_y < tilt_x)
	{
		short tmp = tilt_x;
		tilt_x = tilt_y;
		tilt_y = tmp;
		offset *= -1;
		offset -= 90;
	}

	xyTable = cTable[tilt_x];
	ds->rotation = (xyTable[tilt_y-tilt_x] & 0xFF) + offset;

	if (ds->rotation < 0)
	{
		ds->rotation *= -1;
	}

	/* Intuos4 mouse has an (180-5) offset */
	ds->rotation = ((360 - ds->rotation + 180 - 5) % 360) * 5;

	if (ds->rotation >= 900) 
		ds->rotation = 1800 - ds->rotation;
	else
		ds->rotation = -ds->rotation;
}

