/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc3;

import java.io.PrintStream;
import javax.transaction.xa.XAException;
import virtuoso.jdbc3.VirtuosoFuture;
import virtuoso.jdbc3.VirtuosoXid;

class XATransaction {
    static final int ACTIVE = 1;
    static final int IDLE = 2;
    static final int PREPARED = 3;
    static final int COMMITTED = 4;
    static final int ROLLEDBACK = 5;
    static final int ROLLBACKONLY = 6;
    private VirtuosoXid xid;
    private int status;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XATransaction(VirtuosoXid virtuosoXid, int n) {
        if (VirtuosoFuture.rpc_log != null) {
            PrintStream printStream = VirtuosoFuture.rpc_log;
            synchronized (printStream) {
                VirtuosoFuture.rpc_log.println("new VirtuosoXATransaction (xid=" + virtuosoXid.hashCode() + ", status=" + n + ") :" + this.hashCode());
                VirtuosoFuture.rpc_log.flush();
            }
        }
        this.xid = virtuosoXid;
        this.status = n;
    }

    VirtuosoXid getXid() {
        return this.xid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getStatus() {
        if (VirtuosoFuture.rpc_log != null) {
            PrintStream printStream = VirtuosoFuture.rpc_log;
            synchronized (printStream) {
                VirtuosoFuture.rpc_log.println("VirtuosoXATransaction.getStatus () ret=" + this.status + " :" + this.hashCode() + ")");
                VirtuosoFuture.rpc_log.flush();
            }
        }
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStatus(int n) {
        this.status = n;
        if (VirtuosoFuture.rpc_log != null) {
            PrintStream printStream = VirtuosoFuture.rpc_log;
            synchronized (printStream) {
                VirtuosoFuture.rpc_log.println("VirtuosoXATransaction.setStatus (status=" + n + ") :" + this.hashCode() + ")");
                VirtuosoFuture.rpc_log.flush();
            }
        }
    }

    void changeStatus(int n) throws XAException {
        this.changeStatus(n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeStatus(int n, boolean bl) throws XAException {
        this.checkNewStatus(n, bl);
        this.status = n;
        if (VirtuosoFuture.rpc_log != null) {
            PrintStream printStream = VirtuosoFuture.rpc_log;
            synchronized (printStream) {
                VirtuosoFuture.rpc_log.println("VirtuosoXATransaction.changeStatus (nstatus=" + n + ") :" + this.hashCode() + ")");
                VirtuosoFuture.rpc_log.flush();
            }
        }
    }

    void checkNewStatus(int n) throws XAException {
        this.checkNewStatus(n, false);
    }

    void checkNewStatus(int n, boolean bl) throws XAException {
        if (this.status == 1 && n != 2 && n != 1 && n != 6) {
            throw this.createException(n);
        }
        if (!(this.status != 2 || n == 3 || n == 4 && bl)) {
            throw this.createException(n);
        }
        if (this.status == 3 && n != 4 && n != 5) {
            throw this.createException(n);
        }
        if (this.status == 6 && n != 5 && n != 3) {
            throw this.createException(n);
        }
        if (this.status == 4 || this.status == 5) {
            throw this.createException(n);
        }
    }

    private String getName(int n) {
        switch (n) {
            case 1: {
                return "ACTIVE";
            }
            case 2: {
                return "IDLE";
            }
            case 3: {
                return "PREPARED";
            }
            case 4: {
                return "COMMITED";
            }
            case 5: {
                return "ROLLEDBACK";
            }
            case 6: {
                return "ROLLBACKONLY";
            }
        }
        return "UNKNOWN";
    }

    private XAException createException(int n) {
        XAException xAException = new XAException("Can't change transaction state from " + this.getName(this.status) + " to " + this.getName(n));
        xAException.errorCode = -7;
        return xAException;
    }
}

