/**
 * @file geis_backend_dbus.h
 * @brief internal GEIS DBUS Server
 *
 * Copyright 2011 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option) any
 * later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */
#ifndef GEIS_DBUS_SERVER_H_
#define GEIS_DBUS_SERVER_H_

#include "geis_backend.h"

#define GEIS_DBUS_MAX_BUS_NAME_LEN    64
#define GEIS_DBUS_MAX_BUS_OBJECT_LEN  64

typedef struct _GeisDBus
{
  DBusConnection *conn;
  int             fd;
  char            busname[GEIS_DBUS_MAX_BUS_NAME_LEN];
  char            busobject[GEIS_DBUS_MAX_BUS_OBJECT_LEN];
} GeisDBus;

/**
 * Constructs a new GEIS DBUS Server.
 *
 * @param[in] geis The API instance the Server will run in.
 *
 * The uTouch stack in Ubuntu Natty use DBUS to coordinate gesture and touch
 * information between Unity and Applications.
 */
GeisDBus* geis_server_dbus_new(Geis geis);

#endif /* GEIS_SERVER_DBUS_H_ */
