/* usplash
 *
 * usplash-testcard-theme.c - definition of testcard theme
 *
 * Copyright © 2006 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */


#include "bogl.h"
#include "usplash-theme.h"


/* Pixmap structure from autogenerated usplash-testcard.c */
extern struct bogl_pixmap pixmap_usplash_testcard;
extern struct bogl_font font_helvB10;


/* Theme definition */
struct usplash_theme testcard_theme = {
	.version = THEME_VERSION,

	/* Background and font */
	.pixmap = &pixmap_usplash_testcard,
	.font = &font_helvB10,

	/* Palette indexes */
	.background = 0x0,
	.progressbar_background = 0x7,
	.progressbar_foreground = 0x8,
	.text_background = 0x7,
	.text_foreground = 0xf,
	.text_success = 0xf,
	.text_failure = 0xc,

	/* Progress bar position and size in pixels */
	.progressbar_x = 220,
	.progressbar_y = 210,
	.progressbar_width = 200,
	.progressbar_height = 10,

	/* Text box position and size in pixels */
	.text_x = 160,
	.text_y = 256,
	.text_width = 320,
	.text_height = 84,

	/* Text details */
	.line_height = 15,
	.line_length = 32,
	.status_width = 30,
	.ratio = USPLASH_16_9,
};
