/* arm-linux.elf-entry.h
   created from arm-linux.elf-entry.bin, 16296 (0x3fa8) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2007 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2007 Laszlo Molnar
   Copyright (C) 2000-2007 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <mfx@users.sourceforge.net>          <ml1050@users.sourceforge.net>
 */


#define STUB_ARM_LINUX_ELF_ENTRY_SIZE    16296
#define STUB_ARM_LINUX_ELF_ENTRY_ADLER32 0x9b815c2e
#define STUB_ARM_LINUX_ELF_ENTRY_CRC32   0x3b801af9

unsigned char stub_arm_linux_elf_entry[16296] = {
127, 69, 76, 70,  1,  1,  1, 97,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x   0 */
  1,  0, 40,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x  10 */
244, 23,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,   /* 0x  20 */
 23,  0, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x  30 */
 24,192, 79,226,  6, 12,156,232, 12,160,138,224, 12,176,139,224,   /* 0x  40 */
  2,  0,160,225,  1,144, 76,224,  1, 26,129,226,  7,  0, 45,233,   /* 0x  50 */
  7, 32,160,227, 50, 48,160,227,  0, 64,224,227,192,  0,144,239,   /* 0x  60 */
  1, 10,112,227,254,255,255, 42,254,  1,185,232, 10,  0, 89,225,   /* 0x  70 */
254,  1,160,232, 15,  0,  0, 58,  9, 64, 64,224, 80, 80,143,226,   /* 0x  80 */
  0,224,160,225,  4, 80,133,224,  5,  0,160,225,  4, 16,137,224,   /* 0x  90 */
  0, 32,160,227,  2,  0,159,239,  0,144,156,229,140,144, 73,226,   /* 0x  a0 */
  9,160, 76,224,  4,160,138,224,  8,  0,219,229,  1, 64, 45,233,   /* 0x  b0 */
  0, 48,155,229, 12,  0,139,226,  4, 16,155,229, 14, 32,160,225,   /* 0x  c0 */
  8, 48,141,229,  8, 48,141,226, 15,224,160,225,  5,240,160,225,   /* 0x  d0 */
  2,128,189,232,252, 64, 45,233,  0,112,129,224,  0, 80,224,227,   /* 0x  e0 */
  2, 65,160,227, 20,  0,  0,234, 24,  0,189,232,  7,  0, 64,224,   /* 0x  f0 */
  3, 32, 66,224,  0, 32,132,229,  0, 64,160,225,  3,  0,160,225,   /* 0x 100 */
  2, 16,131,224,  0, 32,160,227,  2,  0,159,239,  4,  0,160,225,   /* 0x 110 */
240,128,189,232,  1, 64,208,228,  4, 64,164,224,  4, 76,176,225,   /* 0x 120 */
 14,240,160,225,  1, 48,208,228,  1, 48,194,228,  4, 64,148,224,   /* 0x 130 */
 14,  0,  0, 11, 18,  0,  0, 42,  1, 16,160,227, 29,  0,  0,234,   /* 0x 140 */
  1, 16, 65,226,  4, 64,148,224, 14,  0,  0, 11,  1, 16,161,224,   /* 0x 150 */
  4, 64,148,224, 14,  0,  0, 11,  1, 16,161,224,  4, 64,148,224,   /* 0x 160 */
 14,  0,  0, 11, 25,  0,  0, 58,  3, 48, 81,226,  0, 16,160,227,   /* 0x 170 */
 45,  0,  0, 58,  1, 80,208,228,  3, 84,133,225,  5, 80,240,225,   /* 0x 180 */
  3,  0,  0, 10,197, 80,176,225, 60,  0,  0, 42, 48,  0,  0,234,   /* 0x 190 */
  4, 64,148,224, 14,  0,  0, 11, 60,  0,  0, 42,  1, 16,160,227,   /* 0x 1a0 */
  4, 64,148,224, 14,  0,  0, 11, 60,  0,  0, 42,  4, 64,148,224,   /* 0x 1b0 */
 14,  0,  0, 11,  1, 16,161,224,  4, 64,148,224, 14,  0,  0, 11,   /* 0x 1c0 */
 52,  0,  0, 58,  4, 16,129,226, 64,  0,  0,234,  4, 64,148,224,   /* 0x 1d0 */
 14,  0,  0, 11,  1, 16,161,224,  2, 16,129,226,  5, 12,117,227,   /* 0x 1e0 */
  1, 16,129, 50,  1, 48,130,224,  1, 48, 83,229,  5, 48,210,231,   /* 0x 1f0 */
  1, 48,194,228,  1, 16, 81,226, 68,  0,  0, 26, 20,  0,  0,234,   /* 0x 200 */
252, 64, 45,233,  0,112,129,224,  0, 80,224,227,  2, 65,160,227,   /* 0x 210 */
 20,  0,  0,234, 24,  0,189,232,  7,  0, 64,224,  3, 32, 66,224,   /* 0x 220 */
  0, 32,132,229,  0, 64,160,225,  3,  0,160,225,  2, 16,131,224,   /* 0x 230 */
  0, 32,160,227,  2,  0,159,239,  4,  0,160,225,240,128,189,232,   /* 0x 240 */
  1, 64,208,228,  4, 64,164,224,  4, 76,176,225, 14,240,160,225,   /* 0x 250 */
  1, 48,208,228,  1, 48,194,228,  4, 64,148,224, 14,  0,  0, 11,   /* 0x 260 */
 18,  0,  0, 42,  1, 16,160,227, 29,  0,  0,234,  1, 16, 65,226,   /* 0x 270 */
  4, 64,148,224, 14,  0,  0, 11,  1, 16,177,224,  4, 64,148,224,   /* 0x 280 */
 14,  0,  0, 11,  1, 16,177,224,  4, 64,148,224, 14,  0,  0, 11,   /* 0x 290 */
 25,  0,  0, 58,  3, 48, 81,226,  0, 16,160,227, 44,  0,  0, 58,   /* 0x 2a0 */
  1, 80,208,228,  3, 84,133,225,  5, 80,240,225,  3,  0,  0, 10,   /* 0x 2b0 */
197, 80,176,225, 46,  0,  0,234,  4, 64,148,224, 14,  0,  0, 11,   /* 0x 2c0 */
  1, 16,177,224,  4, 64,148,224, 14,  0,  0, 11,  1, 16,177,224,   /* 0x 2d0 */
 59,  0,  0, 26,  1, 16,160,227,  4, 64,148,224, 14,  0,  0, 11,   /* 0x 2e0 */
  1, 16,177,224,  4, 64,148,224, 14,  0,  0, 11, 52,  0,  0, 58,   /* 0x 2f0 */
  2, 16,129,226,  1, 16,129,226,  5, 12,117,227,  1, 16,129, 50,   /* 0x 300 */
  0, 48,210,229,  5, 48,210,231,  1, 48,194,228,  1, 16, 81,226,   /* 0x 310 */
 63,  0,  0, 26, 20,  0,  0,234,  0, 16,129,224, 62, 64, 45,233,   /* 0x 320 */
  0, 80,224,227,  2, 65,160,227, 29,  0,  0,234, 26,  0,189,232,   /* 0x 330 */
  1,  0, 64,224,  3, 32, 66,224,  0, 32,132,229,  0, 64,160,225,   /* 0x 340 */
  3,  0,160,225,  2, 16,131,224,  0, 32,160,227,  2,  0,159,239,   /* 0x 350 */
  4,  0,160,225, 48,128,189,232,  4, 64,148,224, 14,240,160, 17,   /* 0x 360 */
  1, 64,208,228,  4, 64,164,224,  4, 76,176,225, 14,240,160,225,   /* 0x 370 */
  1, 16,160,227, 14,192,160,225, 14,  0,  0,235,  1, 16,177,224,   /* 0x 380 */
 14,  0,  0,235, 22,  0,  0, 58, 12,240,160,225,  1, 48,208,228,   /* 0x 390 */
  1, 48,194,228, 14,  0,  0,235, 27,  0,  0, 42, 20,  0,  0,235,   /* 0x 3a0 */
  3, 48, 81,226,  0, 16,160,227, 39,  0,  0, 58,  1, 80,208,228,   /* 0x 3b0 */
  3, 84,133,225,  5, 80,240,225,  3,  0,  0, 10, 14,  0,  0,235,   /* 0x 3c0 */
  1, 16,177,224, 14,  0,  0,235,  1, 16,177,224, 46,  0,  0, 26,   /* 0x 3d0 */
 20,  0,  0,235,  2, 16,129,226, 13, 12,117,227,  1, 16,129, 50,   /* 0x 3e0 */
  5, 48,210,231,  1, 16, 81,226,  1, 48,194,228, 48,  0,  0, 42,   /* 0x 3f0 */
 29,  0,  0,234,  0,192,221,229, 14,  0, 92,227,254,255,255, 26,   /* 0x 400 */
 12, 72, 45,233,  0,176,208,229,  6,204,160,227,171,177,160,225,   /* 0x 410 */
 28,203,160,225, 13,176,160,225, 58,205,140,226, 12,208, 77,224,   /* 0x 420 */
  0,192,147,229,  8, 48,141,229,  4,192,141,229,  0, 32,141,229,   /* 0x 430 */
 12, 48,141,226,  0,192,160,227,  4,192,131,228, 11,  0, 83,225,   /* 0x 440 */
 15,  0,  0, 26, 12, 48,141,226,  2, 32, 65,226,  0, 16,160,225,   /* 0x 450 */
  1,192,209,228,  7,192, 12,226, 18,192,205,229,  1,192,209,228,   /* 0x 460 */
 44,  2,160,225, 17,  0,205,229, 15,192, 12,226, 16,192,205,229,   /* 0x 470 */
 16,  0,141,226, 40,  0,  0,235, 11,208,160,225,  0, 48,160,225,   /* 0x 480 */
  3,  0,189,232,  0, 16,145,229,  0, 16,129,224,  0, 32,160,227,   /* 0x 490 */
  2,  0,159,239,  3,  0,160,225,  0,136,189,232,240, 79, 45,233,   /* 0x 4a0 */
 48,208, 77,226,  0, 48,141,229,  0, 48,208,229,  2, 80,208,229,   /* 0x 4b0 */
  1,224,208,229,  0,192,157,229, 20, 48,141,229, 92, 48,157,229,   /* 0x 4c0 */
  0, 64,160,227,  0, 64,140,229,  0, 64,131,229, 20,192,157,229,   /* 0x 4d0 */
  1, 48,208,229,  3, 48,140,224,  3,204,160,227, 28,195,160,225,   /* 0x 4e0 */
  1, 48,160,227, 19,238,160,225, 19, 53,160,225,115,206,140,226,   /* 0x 4f0 */
  1, 48, 67,226,  1,224, 78,226,  4,  0,128,226,  6,192,140,226,   /* 0x 500 */
  4, 16,141,229, 12, 48,141,229, 16,224,141,229,  8,  0,141,229,   /* 0x 510 */
 31,  0,  0,234,  8,  0,157,229,  1, 27,160,227,176, 16,131,225,   /* 0x 520 */
 12,  0, 84,225,132, 48,160,225,  1, 64,132,226, 28,  0,  0, 26,   /* 0x 530 */
  4, 48,157,229,  0, 96,160,227,  2,144,131,224,  3,224,160,225,   /* 0x 540 */
  6, 32,160,225,  4, 80,157,229,  9, 48,101,224,  3,  0, 82,225,   /* 0x 550 */
  1,224,142,226, 73,  2,  0, 10,  5, 48,210,231,  1, 32,130,226,   /* 0x 560 */
  5,  0, 82,227,  6,100,131,225, 40,  0,  0, 26,  0,176,160,227,   /* 0x 570 */
  1,192,160,227, 11,112,160,225,  0,  0,224,227, 44,192,141,229,   /* 0x 580 */
 24,176,141,229, 28,192,141,229, 32,192,141,229, 36,192,141,229,   /* 0x 590 */
 57,  2,  0,234,255,132,224,227,  8,  0, 80,225, 68,  0,  0,138,   /* 0x 5a0 */
  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,  0,  4,160,225,   /* 0x 5b0 */
  6,100,131,225, 12, 16,157,229, 24, 32,157,229,  1,160, 11,224,   /* 0x 5c0 */
  2, 18,160,225,  1, 48,138,224,131, 80,160,225,  8, 48,157,229,   /* 0x 5d0 */
181,192,147,225,160, 53,160,225,156,  3,  4,224,  4,  0, 86,225,   /* 0x 5e0 */
185,  0,  0, 42, 20,  0,157,229,  8, 48, 96,226, 87, 51,160,225,   /* 0x 5f0 */
 16, 16,157,229,  1, 32, 11,224, 18, 48,131,224,  8,  0,157,229,   /* 0x 600 */
  6, 44,160,227,147,  2, 34,224, 24, 16,157,229,  2, 59,108,226,   /* 0x 610 */
  6,  0, 81,227,195, 50,140,224,230,142,130,226,181, 48,128,225,   /* 0x 620 */
 12,128,136,226,  4,  0,160,209,  1, 16,160,211,164,  0,  0,218,   /* 0x 630 */
 44, 32,157,229, 84, 80,157,229, 11, 48, 98,224,  3,112,213,231,   /* 0x 640 */
  4,  0,160,225,  1, 16,160,227,135,112,160,225,  1, 92,  7,226,   /* 0x 650 */
129,160,160,225,133, 48,136,224, 10, 48,131,224,  1,  4, 80,227,   /* 0x 660 */
  2, 76,131,226,  1,192,129,226,119,  0,  0, 42,  9,  0, 94,225,   /* 0x 670 */
  0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,   /* 0x 680 */
176, 48,212,225,160, 37,160,225, 12, 16,129,224,147,  2, 12,224,   /* 0x 690 */
  2, 43, 99,226, 12,  0, 86,225,194, 34,131,224,163, 50, 67,224,   /* 0x 6a0 */
135,  0,  0, 42,  0,  0, 85,227, 12,  0,160,225,176, 32,196,225,   /* 0x 6b0 */
 10, 16,160,225,140,  0,  0, 10, 12,  0,160,225,164,  0,  0,234,   /* 0x 6c0 */
  0,  0, 85,227,176, 48,196,225,  6, 96,108,224,  0,  0,108,224,   /* 0x 6d0 */
164,  0,  0, 10,255,  0, 81,227,168,  0,  0,202,105,  0,  0,234,   /* 0x 6e0 */
  1,  4, 80,227,  3, 16,129,224,151,  0,  0, 42,  9,  0, 94,225,   /* 0x 6f0 */
  0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,   /* 0x 700 */
180, 48,152,225,160, 37,160,225,147,  2, 12,224,  2, 43, 99,226,   /* 0x 710 */
 12,  0, 86,225,163, 82, 67,224,194, 50,131,224,180, 48,136, 49,   /* 0x 720 */
180, 80,136, 33,  0,  0,108,224,  4, 16,160, 49, 12,  0,160, 49,   /* 0x 730 */
  6, 96,108, 32,255,  0, 81,227,129, 64,160,225,  1, 48,129,226,   /* 0x 740 */
143,  0,  0,218, 24,192,157,229,255,112,  1,226,  3,  0, 92,227,   /* 0x 750 */
 84, 16,157,229,  0, 32,160,211, 11,112,193,231,  1,176,139,226,   /* 0x 760 */
 24, 32,141,213, 57,  2,  0,218, 24, 48,157,229,  9,  0, 83,227,   /* 0x 770 */
 24, 80,157,197,  3, 48, 67,210,  6, 80, 69,194, 24, 48,141,213,   /* 0x 780 */
 24, 80,141,197, 57,  2,  0,234,172, 50, 76,224,  0, 32,100,224,   /* 0x 790 */
  8,192,157,229,  8,  0, 82,225,181, 48,140,225,  6, 96,100,224,   /* 0x 7a0 */
197,  0,  0,138,  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,   /* 0x 7b0 */
  2, 36,160,225,  6,100,131,225,  8,  0,157,229, 24, 48,157,229,   /* 0x 7c0 */
131,112,128,224,  6, 13,135,226,176,192,208,225,162, 53,160,225,   /* 0x 7d0 */
156,  3,  4,224,  4,  0, 86,225,225,  0,  0, 42, 24, 32,157,229,   /* 0x 7e0 */
  8, 80,157,229,  6,  0, 82,227,  2, 59,108,226,102, 30,133,226,   /* 0x 7f0 */
  3, 32,160,195, 32, 80,157,229,  0, 32,160,211,195, 50,140,224,   /* 0x 800 */
 24, 32,141,229, 28,192,157,229, 44, 32,157,229, 36, 80,141,229,   /* 0x 810 */
  4, 16,129,226,  4, 80,160,225, 32,192,141,229, 28, 32,141,229,   /* 0x 820 */
176, 48,192,225, 98,  1,  0,234,  2, 32,100,224,172, 50, 76,224,   /* 0x 830 */
  8,  0, 82,225,176, 48,192,225,  6, 96,100,224,236,  0,  0,138,   /* 0x 840 */
  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,  2, 36,160,225,   /* 0x 850 */
  6,100,131,225,102, 95,135,226,176,192,213,225,162, 53,160,225,   /* 0x 860 */
156,  3,  4,224,  4,  0, 86,225, 26,  1,  0, 42,  2, 59,108,226,   /* 0x 870 */
195, 50,140,224,  8,  0, 84,225,176, 48,197,225,252,  0,  0,138,   /* 0x 880 */
  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,  4, 68,160,225,   /* 0x 890 */
  6,100,131,225,  8, 80,157,229,129, 48,133,224,138, 48,131,224,   /* 0x 8a0 */
 30, 30,131,226,176,192,209,225,164, 53,160,225,156,  3,  2,224,   /* 0x 8b0 */
  2,  0, 86,225,  6, 96, 98, 32,172, 50, 76, 32,  4, 80, 98, 32,   /* 0x 8c0 */
 50,  1,  0, 42,  2, 59,108,226,195, 50,140,224,  0,  0, 91,227,   /* 0x 8d0 */
176, 48,193,225, 73,  2,  0, 10, 44,192,157,229, 24, 16,157,229,   /* 0x 8e0 */
 84,  0,157,229, 11, 48,108,224,  3,112,208,231,  6,  0, 81,227,   /* 0x 8f0 */
 11, 16,160,195,  9, 16,160,211, 24, 16,141,229, 11,112,192,231,   /* 0x 900 */
  2,  0,160,225,  1,176,139,226, 57,  2,  0,234,  2, 32,100,224,   /* 0x 910 */
172, 50, 76,224,  8,  0, 82,225,176, 48,197,225,  6, 96,100,224,   /* 0x 920 */
 37,  1,  0,138,  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,   /* 0x 930 */
  2, 36,160,225,  6,100,131,225, 27, 30,135,226,176,192,209,225,   /* 0x 940 */
162, 53,160,225,156,  3,  4,224,  4,  0, 86,225, 52,  1,  0, 42,   /* 0x 950 */
 44, 80,157,229,  2, 59,108,226, 28, 32,157,229,195, 50,140,224,   /* 0x 960 */
 28, 80,141,229,  4, 80,160,225, 44, 32,141,229,176, 48,193,225,   /* 0x 970 */
 90,  1,  0,234,  2, 32,100,224,172, 50, 76,224,  8,  0, 82,225,   /* 0x 980 */
176, 48,193,225,  6, 96,100,224, 63,  1,  0,138,  9,  0, 94,225,   /* 0x 990 */
 73,  2,  0, 10,  1, 48,222,228,  2, 36,160,225,  6,100,131,225,   /* 0x 9a0 */
114, 31,135,226,176,192,209,225,162, 53,160,225,156,  3,  4,224,   /* 0x 9b0 */
  4,  0, 86,225, 78,  1,  0, 42,  2, 59,108,226, 32, 32,157,229,   /* 0x 9c0 */
195, 50,140,224, 44,  0,157,229, 28,192,157,229,  4, 80,160,225,   /* 0x 9d0 */
 32,192,141,229, 28,  0,141,229, 49,  1,  0,234,172, 50, 76,224,   /* 0x 9e0 */
176, 48,193,225, 44,192,157,229, 32, 16,141,226, 10,  0,145,232,   /* 0x 9f0 */
  2, 80,100,224, 28, 32,157,229, 36, 16,141,229, 32, 32,141,229,   /* 0x a00 */
 28,192,141,229, 44, 48,141,229,  6, 96,100,224, 24, 32,157,229,   /* 0x a10 */
  8,  0,157,229,  6,  0, 82,227, 11, 32,160,195,  8, 32,160,211,   /* 0x a20 */
166, 30,128,226, 24, 32,141,229,  8, 16,129,226,255,116,224,227,   /* 0x a30 */
  7,  0, 85,225,106,  1,  0,138,  9,  0, 94,225, 73,  2,  0, 10,   /* 0x a40 */
  1, 48,222,228,  5, 84,160,225,  6,100,131,225,176,192,209,225,   /* 0x a50 */
165, 53,160,225,156,  3,  4,224,  4,  0, 86,225,120,  1,  0, 42,   /* 0x a60 */
 10, 34,129,224,  2, 59,108,226,195, 50,140,224,  4, 80,130,226,   /* 0x a70 */
  4,  0,160,225,  3,160,160,227,  0,128,160,227,176, 48,193,225,   /* 0x a80 */
152,  1,  0,234,  5, 32,100,224,172, 50, 76,224,  7,  0, 82,225,   /* 0x a90 */
  6, 96,100,224,176, 48,193,225,131,  1,  0,138,  9,  0, 94,225,   /* 0x aa0 */
 73,  2,  0, 10,  1, 48,222,228,  2, 36,160,225,  6,100,131,225,   /* 0x ab0 */
178,192,209,225,162, 53,160,225,156,  3,  4,224,  4,  0, 86,225,   /* 0x ac0 */
145,  1,  0, 42, 10, 34,129,224,  2, 59,108,226,195, 50,140,224,   /* 0x ad0 */
 65, 95,130,226,  4,  0,160,225,  3,160,160,227,  8,128,160,227,   /* 0x ae0 */
178, 48,193,225,152,  1,  0,234,172, 50, 76,224,178, 48,193,225,   /* 0x af0 */
  6, 96,100,224,  2,  0,100,224,129, 95,129,226,  8,160,160,227,   /* 0x b00 */
 16,128,160,227, 10,112,160,225,  1, 16,160,227,  1, 48,129,226,   /* 0x b10 */
  1,  4, 80,227,129, 64,160,225,  3, 16,129,224,164,  1,  0, 42,   /* 0x b20 */
  9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,   /* 0x b30 */
  6,100,131,225,180, 48,149,225,160, 37,160,225,147,  2, 12,224,   /* 0x b40 */
  2, 43, 99,226, 12,  0, 86,225,194, 34,131,224,163, 50, 67,224,   /* 0x b50 */
  0,  0,108,224,  4, 16,160, 49, 12,  0,160, 49,180, 32,133, 49,   /* 0x b60 */
  6, 96,108, 32,180, 48,133, 33,  1,112, 87,226,154,  1,  0, 26,   /* 0x b70 */
  1, 32,160,227, 18, 58, 65,224, 24, 80,157,229,  8, 48,131,224,   /* 0x b80 */
  3,  0, 85,227, 40, 48,141,229, 36,  2,  0,202,  8,192,157,229,   /* 0x b90 */
  3,  0, 83,227,  3, 48,160,163,131, 51,140,224, 54, 94,131,226,   /* 0x ba0 */
  2,112,160,225,  6,128,160,227,  1, 48,135,226,  1,  4, 80,227,   /* 0x bb0 */
135, 64,160,225,  3,112,135,224,203,  1,  0, 42,  9,  0, 94,225,   /* 0x bc0 */
  0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,   /* 0x bd0 */
180, 48,149,225,160, 37,160,225,147,  2, 12,224,  2, 43, 99,226,   /* 0x be0 */
 12,  0, 86,225,194, 34,131,224,163, 50, 67,224,  0,  0,108,224,   /* 0x bf0 */
  4,112,160, 49, 12,  0,160, 49,180, 32,133, 49,  6, 96,108, 32,   /* 0x c00 */
180, 48,133, 33,  1,128, 88,226,193,  1,  0, 26, 64, 32, 71,226,   /* 0x c10 */
  3,  0, 82,227,  2, 80,160,209, 30,  2,  0,218,194, 64,160,225,   /* 0x c20 */
 13,  0, 82,227,  1, 48,  2,226,  1,112, 68,226,  2,192,131,227,   /* 0x c30 */
  5, 64, 68,194,  8, 32,160,193,237,  1,  0,202, 28, 87,160,225,   /* 0x c40 */
  8, 16,157,229,133, 48,129,224,130, 48, 67,224, 85, 78,131,226,   /* 0x c50 */
 14, 64,132,226,  1,  2,  0,234,  1,  4, 80,227,  1, 32,130,226,   /* 0x c60 */
245,  1,  0, 42,  9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,   /* 0x c70 */
  1, 48,222,228,  6,100,131,225,160,  0,160,225,  0,  0, 86,225,   /* 0x c80 */
140,192,160,225,  6, 96, 96, 32,  1,192,140, 35,  4,  0, 82,225,   /* 0x c90 */
237,  1,  0, 26,  8, 32,157,229, 25, 77,130,226,  4, 64,132,226,   /* 0x ca0 */
 12, 82,160,225,  4,112,160,227,  1,160,160,227, 10,128,160,225,   /* 0x cb0 */
  1,  4, 80,227,136, 16,160,225,  1,192,136,226, 12,  2,  0, 42,   /* 0x cc0 */
  9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,   /* 0x cd0 */
  6,100,131,225,177, 48,148,225,160, 37,160,225, 12,128,136,224,   /* 0x ce0 */
147,  2, 12,224,  2, 43, 99,226, 12,  0, 86,225,194, 34,131,224,   /* 0x cf0 */
163, 50, 67,224, 10, 80,133, 33,  1,128,160, 49, 12,  0,160, 49,   /* 0x d00 */
177, 32,132, 49,177, 48,132, 33,  6, 96,108, 32,  0,  0,108, 32,   /* 0x d10 */
  1,112, 87,226,138,160,160,225,  3,  2,  0, 26,  1, 80,149,226,   /* 0x d20 */
 44, 80,141,229, 60,  2,  0, 10, 24, 48,157,229,  7, 48,131,226,   /* 0x d30 */
 24, 48,141,229, 44, 80,157,229, 11,  0, 85,225, 73,  2,  0,138,   /* 0x d40 */
 40,192,157,229, 84, 16,157,229, 11, 48,101,224,  2, 32,140,226,   /* 0x d50 */
  3, 64,129,224, 11,192,129,224,  1, 32, 82,226, 88, 80,157,229,   /* 0x d60 */
  0, 48,160,  3,  1, 48,160, 19,  1,176,139,226,  5,  0, 91,225,   /* 0x d70 */
  0, 48,160, 35,  1, 48,  3, 50,  1,112,212,228,  0,  0, 83,227,   /* 0x d80 */
  1,112,204,228, 45,  2,  0, 26, 88,192,157,229, 12,  0, 91,225,   /* 0x d90 */
 60,  0,  0, 58,  1,  4, 80,227, 65,  2,  0, 42,  9,  0, 94,225,   /* 0x da0 */
 73,  2,  0, 10,  1,224,142,226,  4,  0,157,229,  0, 16,157,229,   /* 0x db0 */
 92, 32,157,229, 14, 48, 96,224,  0,  0,160,227,  0, 48,129,229,   /* 0x dc0 */
  0,176,130,229, 74,  2,  0,234,  1,  0,160,227, 48,208,141,226,   /* 0x dd0 */
240,143,189,232,240, 79, 45,233, 48,208, 77,226,  0, 48,141,229,   /* 0x de0 */
  0, 48,208,229,  2, 80,208,229,  1,224,208,229,  0,192,157,229,   /* 0x df0 */
 20, 48,141,229, 92, 48,157,229,  0, 64,160,227,  0, 64,140,229,   /* 0x e00 */
  0, 64,131,229, 20,192,157,229,  1, 48,208,229,  3, 48,140,224,   /* 0x e10 */
  3,204,160,227, 28,195,160,225,  1, 48,160,227, 19,238,160,225,   /* 0x e20 */
 19, 53,160,225,115,206,140,226,  1, 48, 67,226,  1,224, 78,226,   /* 0x e30 */
  4,  0,128,226,  6,192,140,226,  4, 16,141,229, 12, 48,141,229,   /* 0x e40 */
 16,224,141,229,  8,  0,141,229, 31,  0,  0,234,  8,  0,157,229,   /* 0x e50 */
  1, 27,160,227,176, 16,131,225, 12,  0, 84,225,132, 48,160,225,   /* 0x e60 */
  1, 64,132,226, 28,  0,  0, 26,  4, 48,157,229,  0, 96,160,227,   /* 0x e70 */
  2,144,131,224,  3,224,160,225,  6, 32,160,225,  4, 80,157,229,   /* 0x e80 */
  9, 48,101,224,  3,  0, 82,225,  1,224,142,226, 73,  2,  0, 10,   /* 0x e90 */
  5, 48,210,231,  1, 32,130,226,  5,  0, 82,227,  6,100,131,225,   /* 0x ea0 */
 40,  0,  0, 26,  0,176,160,227,  1,192,160,227, 11,112,160,225,   /* 0x eb0 */
  0,  0,224,227, 44,192,141,229, 24,176,141,229, 28,192,141,229,   /* 0x ec0 */
 32,192,141,229, 36,192,141,229, 57,  2,  0,234,255,132,224,227,   /* 0x ed0 */
  8,  0, 80,225, 68,  0,  0,138,  9,  0, 94,225, 73,  2,  0, 10,   /* 0x ee0 */
  1, 48,222,228,  0,  4,160,225,  6,100,131,225, 12, 16,157,229,   /* 0x ef0 */
 24, 32,157,229,  1,160, 11,224,  2, 18,160,225,  1, 48,138,224,   /* 0x f00 */
131, 80,160,225,  8, 48,157,229,181,192,147,225,160, 53,160,225,   /* 0x f10 */
156,  3,  4,224,  4,  0, 86,225,185,  0,  0, 42, 20,  0,157,229,   /* 0x f20 */
  8, 48, 96,226, 87, 51,160,225, 16, 16,157,229,  1, 32, 11,224,   /* 0x f30 */
 18, 48,131,224,  8,  0,157,229,  6, 44,160,227,147,  2, 34,224,   /* 0x f40 */
 24, 16,157,229,  2, 59,108,226,  6,  0, 81,227,195, 50,140,224,   /* 0x f50 */
230,142,130,226,181, 48,128,225, 12,128,136,226,  4,  0,160,209,   /* 0x f60 */
  1, 16,160,211,164,  0,  0,218, 44, 32,157,229, 84, 80,157,229,   /* 0x f70 */
 11, 48, 98,224,  3,112,213,231,  4,  0,160,225,  1, 16,160,227,   /* 0x f80 */
135,112,160,225,  1, 92,  7,226,129,160,160,225,133, 48,136,224,   /* 0x f90 */
 10, 48,131,224,  1,  4, 80,227,  2, 76,131,226,  1,192,129,226,   /* 0x fa0 */
119,  0,  0, 42,  9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,   /* 0x fb0 */
  1, 48,222,228,  6,100,131,225,176, 48,212,225,160, 37,160,225,   /* 0x fc0 */
 12, 16,129,224,147,  2, 12,224,  2, 43, 99,226, 12,  0, 86,225,   /* 0x fd0 */
194, 34,131,224,163, 50, 67,224,135,  0,  0, 42,  0,  0, 85,227,   /* 0x fe0 */
 12,  0,160,225,176, 32,196,225, 10, 16,160,225,140,  0,  0, 10,   /* 0x ff0 */
 12,  0,160,225,164,  0,  0,234,  0,  0, 85,227,176, 48,196,225,   /* 0x1000 */
  6, 96,108,224,  0,  0,108,224,164,  0,  0, 10,255,  0, 81,227,   /* 0x1010 */
168,  0,  0,202,105,  0,  0,234,  1,  4, 80,227,  3, 16,129,224,   /* 0x1020 */
151,  0,  0, 42,  9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,   /* 0x1030 */
  1, 48,222,228,  6,100,131,225,180, 48,152,225,160, 37,160,225,   /* 0x1040 */
147,  2, 12,224,  2, 43, 99,226, 12,  0, 86,225,163, 82, 67,224,   /* 0x1050 */
194, 50,131,224,180, 48,136, 49,180, 80,136, 33,  0,  0,108,224,   /* 0x1060 */
  4, 16,160, 49, 12,  0,160, 49,  6, 96,108, 32,255,  0, 81,227,   /* 0x1070 */
129, 64,160,225,  1, 48,129,226,143,  0,  0,218, 24,192,157,229,   /* 0x1080 */
255,112,  1,226,  3,  0, 92,227, 84, 16,157,229,  0, 32,160,211,   /* 0x1090 */
 11,112,193,231,  1,176,139,226, 24, 32,141,213, 57,  2,  0,218,   /* 0x10a0 */
 24, 48,157,229,  9,  0, 83,227, 24, 80,157,197,  3, 48, 67,210,   /* 0x10b0 */
  6, 80, 69,194, 24, 48,141,213, 24, 80,141,197, 57,  2,  0,234,   /* 0x10c0 */
172, 50, 76,224,  0, 32,100,224,  8,192,157,229,  8,  0, 82,225,   /* 0x10d0 */
181, 48,140,225,  6, 96,100,224,197,  0,  0,138,  9,  0, 94,225,   /* 0x10e0 */
 73,  2,  0, 10,  1, 48,222,228,  2, 36,160,225,  6,100,131,225,   /* 0x10f0 */
  8,  0,157,229, 24, 48,157,229,131,112,128,224,  6, 13,135,226,   /* 0x1100 */
176,192,208,225,162, 53,160,225,156,  3,  4,224,  4,  0, 86,225,   /* 0x1110 */
225,  0,  0, 42, 24, 32,157,229,  8, 80,157,229,  6,  0, 82,227,   /* 0x1120 */
  2, 59,108,226,102, 30,133,226,  3, 32,160,195, 32, 80,157,229,   /* 0x1130 */
  0, 32,160,211,195, 50,140,224, 24, 32,141,229, 28,192,157,229,   /* 0x1140 */
 44, 32,157,229, 36, 80,141,229,  4, 16,129,226,  4, 80,160,225,   /* 0x1150 */
 32,192,141,229, 28, 32,141,229,176, 48,192,225, 98,  1,  0,234,   /* 0x1160 */
  2, 32,100,224,172, 50, 76,224,  8,  0, 82,225,176, 48,192,225,   /* 0x1170 */
  6, 96,100,224,236,  0,  0,138,  9,  0, 94,225, 73,  2,  0, 10,   /* 0x1180 */
  1, 48,222,228,  2, 36,160,225,  6,100,131,225,102, 95,135,226,   /* 0x1190 */
176,192,213,225,162, 53,160,225,156,  3,  4,224,  4,  0, 86,225,   /* 0x11a0 */
 26,  1,  0, 42,  2, 59,108,226,195, 50,140,224,  8,  0, 84,225,   /* 0x11b0 */
176, 48,197,225,252,  0,  0,138,  9,  0, 94,225, 73,  2,  0, 10,   /* 0x11c0 */
  1, 48,222,228,  4, 68,160,225,  6,100,131,225,  8, 80,157,229,   /* 0x11d0 */
129, 48,133,224,138, 48,131,224, 30, 30,131,226,176,192,209,225,   /* 0x11e0 */
164, 53,160,225,156,  3,  2,224,  2,  0, 86,225,  6, 96, 98, 32,   /* 0x11f0 */
172, 50, 76, 32,  4, 80, 98, 32, 50,  1,  0, 42,  2, 59,108,226,   /* 0x1200 */
195, 50,140,224,  0,  0, 91,227,176, 48,193,225, 73,  2,  0, 10,   /* 0x1210 */
 44,192,157,229, 24, 16,157,229, 84,  0,157,229, 11, 48,108,224,   /* 0x1220 */
  3,112,208,231,  6,  0, 81,227, 11, 16,160,195,  9, 16,160,211,   /* 0x1230 */
 24, 16,141,229, 11,112,192,231,  2,  0,160,225,  1,176,139,226,   /* 0x1240 */
 57,  2,  0,234,  2, 32,100,224,172, 50, 76,224,  8,  0, 82,225,   /* 0x1250 */
176, 48,197,225,  6, 96,100,224, 37,  1,  0,138,  9,  0, 94,225,   /* 0x1260 */
 73,  2,  0, 10,  1, 48,222,228,  2, 36,160,225,  6,100,131,225,   /* 0x1270 */
 27, 30,135,226,176,192,209,225,162, 53,160,225,156,  3,  4,224,   /* 0x1280 */
  4,  0, 86,225, 52,  1,  0, 42, 44, 80,157,229,  2, 59,108,226,   /* 0x1290 */
 28, 32,157,229,195, 50,140,224, 28, 80,141,229,  4, 80,160,225,   /* 0x12a0 */
 44, 32,141,229,176, 48,193,225, 90,  1,  0,234,  2, 32,100,224,   /* 0x12b0 */
172, 50, 76,224,  8,  0, 82,225,176, 48,193,225,  6, 96,100,224,   /* 0x12c0 */
 63,  1,  0,138,  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,   /* 0x12d0 */
  2, 36,160,225,  6,100,131,225,114, 31,135,226,176,192,209,225,   /* 0x12e0 */
162, 53,160,225,156,  3,  4,224,  4,  0, 86,225, 78,  1,  0, 42,   /* 0x12f0 */
  2, 59,108,226, 32, 32,157,229,195, 50,140,224, 44,  0,157,229,   /* 0x1300 */
 28,192,157,229,  4, 80,160,225, 32,192,141,229, 28,  0,141,229,   /* 0x1310 */
 49,  1,  0,234,172, 50, 76,224,176, 48,193,225, 44,192,157,229,   /* 0x1320 */
 32, 16,141,226, 10,  0,145,232,  2, 80,100,224, 28, 32,157,229,   /* 0x1330 */
 36, 16,141,229, 32, 32,141,229, 28,192,141,229, 44, 48,141,229,   /* 0x1340 */
  6, 96,100,224, 24, 32,157,229,  8,  0,157,229,  6,  0, 82,227,   /* 0x1350 */
 11, 32,160,195,  8, 32,160,211,166, 30,128,226, 24, 32,141,229,   /* 0x1360 */
  8, 16,129,226,255,116,224,227,  7,  0, 85,225,106,  1,  0,138,   /* 0x1370 */
  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,  5, 84,160,225,   /* 0x1380 */
  6,100,131,225,176,192,209,225,165, 53,160,225,156,  3,  4,224,   /* 0x1390 */
  4,  0, 86,225,120,  1,  0, 42, 10, 34,129,224,  2, 59,108,226,   /* 0x13a0 */
195, 50,140,224,  4, 80,130,226,  4,  0,160,225,  3,160,160,227,   /* 0x13b0 */
  0,128,160,227,176, 48,193,225,152,  1,  0,234,  5, 32,100,224,   /* 0x13c0 */
172, 50, 76,224,  7,  0, 82,225,  6, 96,100,224,176, 48,193,225,   /* 0x13d0 */
131,  1,  0,138,  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,   /* 0x13e0 */
  2, 36,160,225,  6,100,131,225,178,192,209,225,162, 53,160,225,   /* 0x13f0 */
156,  3,  4,224,  4,  0, 86,225,145,  1,  0, 42, 10, 34,129,224,   /* 0x1400 */
  2, 59,108,226,195, 50,140,224, 65, 95,130,226,  4,  0,160,225,   /* 0x1410 */
  3,160,160,227,  8,128,160,227,178, 48,193,225,152,  1,  0,234,   /* 0x1420 */
172, 50, 76,224,178, 48,193,225,  6, 96,100,224,  2,  0,100,224,   /* 0x1430 */
129, 95,129,226,  8,160,160,227, 16,128,160,227, 10,112,160,225,   /* 0x1440 */
  1, 16,160,227,  1, 48,129,226,  1,  4, 80,227,129, 64,160,225,   /* 0x1450 */
  3, 16,129,224,164,  1,  0, 42,  9,  0, 94,225,  0,  4,160,225,   /* 0x1460 */
 73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,180, 48,149,225,   /* 0x1470 */
160, 37,160,225,147,  2, 12,224,  2, 43, 99,226, 12,  0, 86,225,   /* 0x1480 */
194, 34,131,224,163, 50, 67,224,  0,  0,108,224,  4, 16,160, 49,   /* 0x1490 */
 12,  0,160, 49,180, 32,133, 49,  6, 96,108, 32,180, 48,133, 33,   /* 0x14a0 */
  1,112, 87,226,154,  1,  0, 26,  1, 32,160,227, 18, 58, 65,224,   /* 0x14b0 */
 24, 80,157,229,  8, 48,131,224,  3,  0, 85,227, 40, 48,141,229,   /* 0x14c0 */
 36,  2,  0,202,  8,192,157,229,  3,  0, 83,227,  3, 48,160,163,   /* 0x14d0 */
131, 51,140,224, 54, 94,131,226,  2,112,160,225,  6,128,160,227,   /* 0x14e0 */
  1, 48,135,226,  1,  4, 80,227,135, 64,160,225,  3,112,135,224,   /* 0x14f0 */
203,  1,  0, 42,  9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,   /* 0x1500 */
  1, 48,222,228,  6,100,131,225,180, 48,149,225,160, 37,160,225,   /* 0x1510 */
147,  2, 12,224,  2, 43, 99,226, 12,  0, 86,225,194, 34,131,224,   /* 0x1520 */
163, 50, 67,224,  0,  0,108,224,  4,112,160, 49, 12,  0,160, 49,   /* 0x1530 */
180, 32,133, 49,  6, 96,108, 32,180, 48,133, 33,  1,128, 88,226,   /* 0x1540 */
193,  1,  0, 26, 64, 32, 71,226,  3,  0, 82,227,  2, 80,160,209,   /* 0x1550 */
 30,  2,  0,218,194, 64,160,225, 13,  0, 82,227,  1, 48,  2,226,   /* 0x1560 */
  1,112, 68,226,  2,192,131,227,  5, 64, 68,194,  8, 32,160,193,   /* 0x1570 */
237,  1,  0,202, 28, 87,160,225,  8, 16,157,229,133, 48,129,224,   /* 0x1580 */
130, 48, 67,224, 85, 78,131,226, 14, 64,132,226,  1,  2,  0,234,   /* 0x1590 */
  1,  4, 80,227,  1, 32,130,226,245,  1,  0, 42,  9,  0, 94,225,   /* 0x15a0 */
  0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,   /* 0x15b0 */
160,  0,160,225,  0,  0, 86,225,140,192,160,225,  6, 96, 96, 32,   /* 0x15c0 */
  1,192,140, 35,  4,  0, 82,225,237,  1,  0, 26,  8, 32,157,229,   /* 0x15d0 */
 25, 77,130,226,  4, 64,132,226, 12, 82,160,225,  4,112,160,227,   /* 0x15e0 */
  1,160,160,227, 10,128,160,225,  1,  4, 80,227,136, 16,160,225,   /* 0x15f0 */
  1,192,136,226, 12,  2,  0, 42,  9,  0, 94,225,  0,  4,160,225,   /* 0x1600 */
 73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,177, 48,148,225,   /* 0x1610 */
160, 37,160,225, 12,128,136,224,147,  2, 12,224,  2, 43, 99,226,   /* 0x1620 */
 12,  0, 86,225,194, 34,131,224,163, 50, 67,224, 10, 80,133, 33,   /* 0x1630 */
  1,128,160, 49, 12,  0,160, 49,177, 32,132, 49,177, 48,132, 33,   /* 0x1640 */
  6, 96,108, 32,  0,  0,108, 32,  1,112, 87,226,138,160,160,225,   /* 0x1650 */
  3,  2,  0, 26,  1, 80,149,226, 44, 80,141,229, 60,  2,  0, 10,   /* 0x1660 */
 24, 48,157,229,  7, 48,131,226, 24, 48,141,229, 44, 80,157,229,   /* 0x1670 */
 11,  0, 85,225, 73,  2,  0,138, 40,192,157,229, 84, 16,157,229,   /* 0x1680 */
 11, 48,101,224,  2, 32,140,226,  3, 64,129,224, 11,192,129,224,   /* 0x1690 */
  1, 32, 82,226, 88, 80,157,229,  0, 48,160,  3,  1, 48,160, 19,   /* 0x16a0 */
  1,176,139,226,  5,  0, 91,225,  0, 48,160, 35,  1, 48,  3, 50,   /* 0x16b0 */
  1,112,212,228,  0,  0, 83,227,  1,112,204,228, 45,  2,  0, 26,   /* 0x16c0 */
 88,192,157,229, 12,  0, 91,225, 60,  0,  0, 58,  1,  4, 80,227,   /* 0x16d0 */
 65,  2,  0, 42,  9,  0, 94,225, 73,  2,  0, 10,  1,224,142,226,   /* 0x16e0 */
  4,  0,157,229,  0, 16,157,229, 92, 32,157,229, 14, 48, 96,224,   /* 0x16f0 */
  0,  0,160,227,  0, 48,129,229,  0,176,130,229, 74,  2,  0,234,   /* 0x1700 */
  1,  0,160,227, 48,208,141,226,240,143,189,232, 30, 32,160,227,   /* 0x1710 */
 12, 16,143,226,  2,  0,160,227,  4,  0,144,239,127,  0,160,227,   /* 0x1720 */
  1,  0,144,239, 80, 82, 79, 84, 95, 69, 88, 69, 67,124, 80, 82,   /* 0x1730 */
 79, 84, 95, 87, 82, 73, 84, 69, 32,102, 97,105,108,101,100, 46,   /* 0x1740 */
 10,  0,116,109,112, 47, 97,114,109, 45,108,105,110,117,120, 46,   /* 0x1750 */
101,108,102, 45,101,110,116,114,121, 46, 98,105,110, 58, 32, 32,   /* 0x1760 */
 32, 32, 32,102,105,108,101, 32,102,111,114,109, 97,116, 32,101,   /* 0x1770 */
108,102, 51, 50, 45,108,105,116,116,108,101, 97,114,109, 10, 10,   /* 0x1780 */
 83,101, 99,116,105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,   /* 0x1790 */
109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101,   /* 0x17a0 */
 32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32,   /* 0x17b0 */
 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,   /* 0x17c0 */
102,102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,103,115, 10,   /* 0x17d0 */
 32, 32, 48, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 32, 32, 32,   /* 0x17e0 */
 32, 32, 48, 48, 48, 48, 48, 48, 98, 48, 32, 32, 48, 48, 48, 48,   /* 0x17f0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x1800 */
 48, 48, 48, 48, 48, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x1810 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x1820 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 49, 32, 78, 82,   /* 0x1830 */
 86, 95, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x1840 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x1850 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1860 */
101, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x1870 */
 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 50,   /* 0x1880 */
 32, 78, 82, 86, 95, 84, 65, 73, 76, 32, 32, 32, 32, 32, 32, 48,   /* 0x1890 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x18a0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x18b0 */
 48, 48, 48,101, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x18c0 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x18d0 */
 32, 32, 51, 32, 78, 82, 86, 50, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x18e0 */
 32, 32, 48, 48, 48, 48, 48, 49, 50, 99, 32, 32, 48, 48, 48, 48,   /* 0x18f0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x1900 */
 48, 48, 48, 48, 48, 48,101, 52, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x1910 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x1920 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 52, 32, 78, 82,   /* 0x1930 */
 86, 50, 68, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x1940 */
 48, 49, 49, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x1950 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50,   /* 0x1960 */
 49, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x1970 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x1980 */
 78, 76, 89, 10, 32, 32, 53, 32, 78, 82, 86, 50, 66, 32, 32, 32,   /* 0x1990 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,100, 99, 32, 32,   /* 0x19a0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x19b0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 50, 56, 32, 32, 50, 42,   /* 0x19c0 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x19d0 */
 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32,   /* 0x19e0 */
 54, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32,   /* 0x19f0 */
 48, 48, 48, 48, 48, 48, 97, 56, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1a00 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x1a10 */
 48, 48, 48, 52, 48, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x1a20 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,   /* 0x1a30 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 55, 32, 76, 90, 77, 65,   /* 0x1a40 */
 95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 57,   /* 0x1a50 */
 51, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x1a60 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 52, 97, 99,   /* 0x1a70 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x1a80 */
 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x1a90 */
 89, 10, 32, 32, 56, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,   /* 0x1aa0 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 57, 51, 56, 32, 32, 48, 48,   /* 0x1ab0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1ac0 */
 32, 32, 48, 48, 48, 48, 48,100,101, 52, 32, 32, 50, 42, 42, 48,   /* 0x1ad0 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,   /* 0x1ae0 */
 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 57, 32,   /* 0x1af0 */
 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 48,   /* 0x1b00 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1b10 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x1b20 */
 49, 55, 49, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x1b30 */
 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x1b40 */
 49, 48, 32, 69, 76, 70, 77, 65, 73, 78, 89, 32, 32, 32, 32, 32,   /* 0x1b50 */
 32, 48, 48, 48, 48, 48, 48, 51, 54, 32, 32, 48, 48, 48, 48, 48,   /* 0x1b60 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x1b70 */
 48, 48, 48, 49, 55, 49, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x1b80 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x1b90 */
 89, 10, 32, 49, 49, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 32,   /* 0x1ba0 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x1bb0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1bc0 */
 32, 32, 48, 48, 48, 48, 49, 55, 53, 50, 32, 32, 50, 42, 42, 48,   /* 0x1bd0 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,   /* 0x1be0 */
 79, 78, 76, 89, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76,   /* 0x1bf0 */
 69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,   /* 0x1c00 */
 32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88,  9, 48, 48, 48,   /* 0x1c10 */
 48, 48, 48, 48, 48, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48,   /* 0x1c20 */
 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,   /* 0x1c30 */
 78, 82, 86, 50, 69,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,   /* 0x1c40 */
 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x1c50 */
 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 68,  9, 48, 48, 48, 48,   /* 0x1c60 */
 48, 48, 48, 48, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48,   /* 0x1c70 */
 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50,   /* 0x1c80 */
 66,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 66,   /* 0x1c90 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x1ca0 */
 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,  9, 48, 48, 48,   /* 0x1cb0 */
 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,   /* 0x1cc0 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x1cd0 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  9, 48, 48, 48,   /* 0x1ce0 */
 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,   /* 0x1cf0 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x1d00 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,  9, 48, 48, 48,   /* 0x1d10 */
 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,   /* 0x1d20 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x1d30 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,  9, 48, 48, 48,   /* 0x1d40 */
 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,   /* 0x1d50 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x1d60 */
 32, 32, 69, 76, 70, 77, 65, 73, 78, 89,  9, 48, 48, 48, 48, 48,   /* 0x1d70 */
 48, 48, 48, 32, 69, 76, 70, 77, 65, 73, 78, 89, 10, 48, 48, 48,   /* 0x1d80 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82,   /* 0x1d90 */
 86, 95, 72, 69, 65, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1da0 */
 78, 82, 86, 95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x1db0 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 95, 84, 65,   /* 0x1dc0 */
 73, 76,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 95,   /* 0x1dd0 */
 84, 65, 73, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x1de0 */
 32, 32, 32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,  9, 48,   /* 0x1df0 */
 48, 48, 48, 48, 48, 48, 48, 32, 69, 76, 70, 77, 65, 73, 78, 90,   /* 0x1e00 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,   /* 0x1e10 */
 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1e20 */
 32, 65, 68, 82, 77, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x1e30 */
 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48,   /* 0x1e40 */
 48, 48, 48, 48, 48, 32, 76, 69, 78, 70, 10, 48, 48, 48, 48, 48,   /* 0x1e50 */
 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,   /* 0x1e60 */
 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 80, 82, 48, 10,   /* 0x1e70 */
 48, 48, 48, 48, 48, 48, 48, 99, 32,103, 32, 32, 32, 32, 32, 32,   /* 0x1e80 */
 32, 69, 76, 70, 77, 65, 73, 78, 88,  9, 48, 48, 48, 48, 48, 48,   /* 0x1e90 */
 48, 48, 32, 95,115,116, 97,114,116, 10, 48, 48, 48, 48, 48, 48,   /* 0x1ea0 */
 48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32, 78, 82, 86, 50, 69,   /* 0x1eb0 */
  9, 48, 48, 48, 48, 48, 49, 50, 99, 32,117, 99,108, 95,110,114,   /* 0x1ec0 */
118, 50,101, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56,   /* 0x1ed0 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32,   /* 0x1ee0 */
 70, 32, 78, 82, 86, 50, 68,  9, 48, 48, 48, 48, 48, 49, 49, 56,   /* 0x1ef0 */
 32,117, 99,108, 95,110,114,118, 50,100, 95,100,101, 99,111,109,   /* 0x1f00 */
112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1f10 */
 32,103, 32, 32, 32, 32, 32, 70, 32, 78, 82, 86, 50, 66,  9, 48,   /* 0x1f20 */
 48, 48, 48, 48, 48,100, 99, 32,117, 99,108, 95,110,114,118, 50,   /* 0x1f30 */
 98, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48,   /* 0x1f40 */
 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32,   /* 0x1f50 */
 69, 76, 70, 77, 65, 73, 78, 89,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x1f60 */
 48, 32,101,110,100, 95,100,101, 99,111,109,112,114,101,115,115,   /* 0x1f70 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32,   /* 0x1f80 */
 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,  9, 48, 48, 48, 48, 48,   /* 0x1f90 */
 48, 48, 48, 32, 99,112,114, 48, 10, 10, 82, 69, 76, 79, 67, 65,   /* 0x1fa0 */
 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,   /* 0x1fb0 */
 32, 91, 69, 76, 70, 77, 65, 73, 78, 88, 93, 58, 10, 79, 70, 70,   /* 0x1fc0 */
 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,   /* 0x1fd0 */
 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,   /* 0x1fe0 */
 48, 48, 48, 48, 48, 48, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83,   /* 0x1ff0 */
 51, 50, 32, 32, 32, 32, 32, 32, 32, 65, 68, 82, 77, 10, 48, 48,   /* 0x2000 */
 48, 48, 48, 48, 48, 52, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83,   /* 0x2010 */
 51, 50, 32, 32, 32, 32, 32, 32, 32, 76, 69, 78, 70, 10, 48, 48,   /* 0x2020 */
 48, 48, 48, 48, 48, 56, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83,   /* 0x2030 */
 51, 50, 32, 32, 32, 32, 32, 32, 32, 67, 80, 82, 48, 10, 48, 48,   /* 0x2040 */
 48, 48, 48, 48, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x2050 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,   /* 0x2060 */
 89, 10, 48, 48, 48, 48, 48, 48, 53, 48, 32, 82, 95, 65, 82, 77,   /* 0x2070 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,   /* 0x2080 */
 77, 65, 73, 78, 88, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,   /* 0x2090 */
 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,   /* 0x20a0 */
 82, 86, 50, 69, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x20b0 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x20c0 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 48,   /* 0x20d0 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x20e0 */
 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 53,   /* 0x20f0 */
 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x2100 */
 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x2110 */
 54, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x2120 */
 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48,   /* 0x2130 */
 48, 54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x2140 */
 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48,   /* 0x2150 */
 48, 48, 55, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x2160 */
 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48,   /* 0x2170 */
 48, 48, 48, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x2180 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48,   /* 0x2190 */
 48, 48, 48, 48, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x21a0 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48,   /* 0x21b0 */
 48, 48, 48, 48, 48, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x21c0 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10,   /* 0x21d0 */
 48, 48, 48, 48, 48, 48, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x21e0 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69,   /* 0x21f0 */
 10, 48, 48, 48, 48, 48, 48, 97, 99, 32, 82, 95, 65, 82, 77, 95,   /* 0x2200 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,   /* 0x2210 */
 69, 10, 48, 48, 48, 48, 48, 48, 98, 52, 32, 82, 95, 65, 82, 77,   /* 0x2220 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,   /* 0x2230 */
 50, 69, 10, 48, 48, 48, 48, 48, 48, 98, 56, 32, 82, 95, 65, 82,   /* 0x2240 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,   /* 0x2250 */
 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 99, 48, 32, 82, 95, 65,   /* 0x2260 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x2270 */
 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 99, 52, 32, 82, 95,   /* 0x2280 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x2290 */
 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,100, 48, 32, 82,   /* 0x22a0 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x22b0 */
 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,100, 52, 32,   /* 0x22c0 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x22d0 */
 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,100, 99,   /* 0x22e0 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x22f0 */
 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,101,   /* 0x2300 */
 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x2310 */
 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x2320 */
101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x2330 */
 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48,   /* 0x2340 */
 48,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x2350 */
 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48,   /* 0x2360 */
 48, 48,102, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x2370 */
 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48,   /* 0x2380 */
 48, 48, 49, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x2390 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48,   /* 0x23a0 */
 48, 48, 48, 49, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x23b0 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 10,   /* 0x23c0 */
 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,   /* 0x23d0 */
 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 68, 93, 58, 10,   /* 0x23e0 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,   /* 0x23f0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,   /* 0x2400 */
 10, 48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 65, 82, 77, 95,   /* 0x2410 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,   /* 0x2420 */
 68, 10, 48, 48, 48, 48, 48, 48, 53, 99, 32, 82, 95, 65, 82, 77,   /* 0x2430 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,   /* 0x2440 */
 50, 68, 10, 48, 48, 48, 48, 48, 48, 54, 48, 32, 82, 95, 65, 82,   /* 0x2450 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,   /* 0x2460 */
 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 54, 56, 32, 82, 95, 65,   /* 0x2470 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x2480 */
 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 55, 52, 32, 82, 95,   /* 0x2490 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x24a0 */
 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 56, 48, 32, 82,   /* 0x24b0 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x24c0 */
 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 56, 99, 32,   /* 0x24d0 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x24e0 */
 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 57, 48,   /* 0x24f0 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x2500 */
 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 57,   /* 0x2510 */
 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x2520 */
 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,   /* 0x2530 */
 97, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x2540 */
 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48,   /* 0x2550 */
 48, 98, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x2560 */
 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48,   /* 0x2570 */
 48, 48, 98, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x2580 */
 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48,   /* 0x2590 */
 48, 48, 48, 99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x25a0 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48,   /* 0x25b0 */
 48, 48, 48, 48,100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x25c0 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48,   /* 0x25d0 */
 48, 48, 48, 48, 48,100, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x25e0 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10,   /* 0x25f0 */
 48, 48, 48, 48, 48, 48,101, 56, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x2600 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68,   /* 0x2610 */
 10, 48, 48, 48, 48, 48, 48,101, 99, 32, 82, 95, 65, 82, 77, 95,   /* 0x2620 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,   /* 0x2630 */
 68, 10, 48, 48, 48, 48, 48, 49, 49, 48, 32, 82, 95, 65, 82, 77,   /* 0x2640 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,   /* 0x2650 */
 50, 68, 10, 48, 48, 48, 48, 48, 49, 49, 52, 32, 82, 95, 65, 82,   /* 0x2660 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,   /* 0x2670 */
 86, 50, 68, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x2680 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86,   /* 0x2690 */
 50, 66, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x26a0 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x26b0 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32, 82,   /* 0x26c0 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x26d0 */
 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 54, 48, 32,   /* 0x26e0 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x26f0 */
 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 54, 56,   /* 0x2700 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x2710 */
 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 54,   /* 0x2720 */
 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x2730 */
 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48,   /* 0x2740 */
 55, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x2750 */
 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48,   /* 0x2760 */
 48, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x2770 */
 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48,   /* 0x2780 */
 48, 48, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x2790 */
 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48,   /* 0x27a0 */
 48, 48, 48, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x27b0 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48,   /* 0x27c0 */
 48, 48, 48, 48, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x27d0 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48,   /* 0x27e0 */
 48, 48, 48, 48, 48, 97, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x27f0 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10,   /* 0x2800 */
 48, 48, 48, 48, 48, 48, 97, 99, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x2810 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66,   /* 0x2820 */
 10, 48, 48, 48, 48, 48, 48, 98, 52, 32, 82, 95, 65, 82, 77, 95,   /* 0x2830 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,   /* 0x2840 */
 66, 10, 48, 48, 48, 48, 48, 48, 98, 56, 32, 82, 95, 65, 82, 77,   /* 0x2850 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,   /* 0x2860 */
 50, 66, 10, 48, 48, 48, 48, 48, 48,100, 52, 32, 82, 95, 65, 82,   /* 0x2870 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,   /* 0x2880 */
 86, 50, 66, 10, 48, 48, 48, 48, 48, 48,100, 56, 32, 82, 95, 65,   /* 0x2890 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x28a0 */
 82, 86, 50, 66, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,   /* 0x28b0 */
 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90,   /* 0x28c0 */
 77, 65, 95, 69, 76, 70, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0x28d0 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x28e0 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0x28f0 */
 48, 48, 48, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x2900 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51,   /* 0x2910 */
 48, 10, 48, 48, 48, 48, 48, 48, 52, 99, 32, 82, 95, 65, 82, 77,   /* 0x2920 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x2930 */
 65, 95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 56, 48,   /* 0x2940 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x2950 */
 32, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 10, 82,   /* 0x2960 */
 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,   /* 0x2970 */
 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 69, 67, 49,   /* 0x2980 */
 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,   /* 0x2990 */
 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,   /* 0x29a0 */
 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 55, 52, 32, 82, 95,   /* 0x29b0 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x29c0 */
 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,   /* 0x29d0 */
 48, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x29e0 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,   /* 0x29f0 */
 10, 48, 48, 48, 48, 48, 48, 98, 56, 32, 82, 95, 65, 82, 77, 95,   /* 0x2a00 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x2a10 */
 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 99, 99, 32,   /* 0x2a20 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x2a30 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,   /* 0x2a40 */
 48, 48, 48,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x2a50 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x2a60 */
 49, 48, 10, 48, 48, 48, 48, 48, 49, 48, 48, 32, 82, 95, 65, 82,   /* 0x2a70 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x2a80 */
 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 48,   /* 0x2a90 */
 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x2aa0 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,   /* 0x2ab0 */
 48, 48, 48, 48, 49, 52, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x2ac0 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x2ad0 */
 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 57, 48, 32, 82, 95,   /* 0x2ae0 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x2af0 */
 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,   /* 0x2b00 */
 49, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x2b10 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,   /* 0x2b20 */
 10, 48, 48, 48, 48, 48, 49,100, 56, 32, 82, 95, 65, 82, 77, 95,   /* 0x2b30 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x2b40 */
 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 48, 52, 32,   /* 0x2b50 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x2b60 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,   /* 0x2b70 */
 48, 48, 50, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x2b80 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x2b90 */
 49, 48, 10, 48, 48, 48, 48, 48, 50, 50, 48, 32, 82, 95, 65, 82,   /* 0x2ba0 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x2bb0 */
 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 51,   /* 0x2bc0 */
 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x2bd0 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,   /* 0x2be0 */
 48, 48, 48, 48, 50, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x2bf0 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x2c00 */
 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 52, 48, 32, 82, 95,   /* 0x2c10 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x2c20 */
 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,   /* 0x2c30 */
 50, 52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x2c40 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,   /* 0x2c50 */
 10, 48, 48, 48, 48, 48, 50, 53, 56, 32, 82, 95, 65, 82, 77, 95,   /* 0x2c60 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x2c70 */
 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 97, 52, 32,   /* 0x2c80 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x2c90 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,   /* 0x2ca0 */
 48, 48, 50, 99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x2cb0 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x2cc0 */
 49, 48, 10, 48, 48, 48, 48, 48, 50,101, 56, 32, 82, 95, 65, 82,   /* 0x2cd0 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x2ce0 */
 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 48,   /* 0x2cf0 */
 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x2d00 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,   /* 0x2d10 */
 48, 48, 48, 48, 51, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x2d20 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x2d30 */
 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 51, 99, 32, 82, 95,   /* 0x2d40 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x2d50 */
 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,   /* 0x2d60 */
 51, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x2d70 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,   /* 0x2d80 */
 10, 48, 48, 48, 48, 48, 51, 97, 48, 32, 82, 95, 65, 82, 77, 95,   /* 0x2d90 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x2da0 */
 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 97, 56, 32,   /* 0x2db0 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x2dc0 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,   /* 0x2dd0 */
 48, 48, 51, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x2de0 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x2df0 */
 49, 48, 10, 48, 48, 48, 48, 48, 51,101, 48, 32, 82, 95, 65, 82,   /* 0x2e00 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x2e10 */
 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51,101,   /* 0x2e20 */
 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x2e30 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,   /* 0x2e40 */
 48, 48, 48, 48, 52, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x2e50 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x2e60 */
 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52, 51, 56, 32, 82, 95,   /* 0x2e70 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x2e80 */
 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,   /* 0x2e90 */
 52, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x2ea0 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,   /* 0x2eb0 */
 10, 48, 48, 48, 48, 48, 52, 56, 52, 32, 82, 95, 65, 82, 77, 95,   /* 0x2ec0 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x2ed0 */
 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52, 56, 99, 32,   /* 0x2ee0 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x2ef0 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,   /* 0x2f00 */
 48, 48, 52, 98, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x2f10 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x2f20 */
 49, 48, 10, 48, 48, 48, 48, 48, 52,100, 52, 32, 82, 95, 65, 82,   /* 0x2f30 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x2f40 */
 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52,101,   /* 0x2f50 */
 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x2f60 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,   /* 0x2f70 */
 48, 48, 48, 48, 52,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x2f80 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x2f90 */
 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 53, 49, 56, 32, 82, 95,   /* 0x2fa0 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x2fb0 */
 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,   /* 0x2fc0 */
 53, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x2fd0 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,   /* 0x2fe0 */
 10, 48, 48, 48, 48, 48, 53, 57, 56, 32, 82, 95, 65, 82, 77, 95,   /* 0x2ff0 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x3000 */
 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 53, 97, 48, 32,   /* 0x3010 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x3020 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,   /* 0x3030 */
 48, 48, 53, 99, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x3040 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x3050 */
 49, 48, 10, 48, 48, 48, 48, 48, 53,101, 52, 32, 82, 95, 65, 82,   /* 0x3060 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x3070 */
 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 53,102,   /* 0x3080 */
 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x3090 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,   /* 0x30a0 */
 48, 48, 48, 48, 54, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x30b0 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x30c0 */
 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 54, 50, 52, 32, 82, 95,   /* 0x30d0 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x30e0 */
 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,   /* 0x30f0 */
 54, 52, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x3100 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,   /* 0x3110 */
 10, 48, 48, 48, 48, 48, 54, 56, 48, 32, 82, 95, 65, 82, 77, 95,   /* 0x3120 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x3130 */
 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 54, 56, 99, 32,   /* 0x3140 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x3150 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,   /* 0x3160 */
 48, 48, 54,100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x3170 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x3180 */
 49, 48, 10, 48, 48, 48, 48, 48, 54,101, 99, 32, 82, 95, 65, 82,   /* 0x3190 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x31a0 */
 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 55, 49,   /* 0x31b0 */
 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x31c0 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,   /* 0x31d0 */
 48, 48, 48, 48, 55, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x31e0 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x31f0 */
 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 55, 54, 99, 32, 82, 95,   /* 0x3200 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x3210 */
 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,   /* 0x3220 */
 55, 55, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x3230 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,   /* 0x3240 */
 10, 48, 48, 48, 48, 48, 55, 57, 99, 32, 82, 95, 65, 82, 77, 95,   /* 0x3250 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x3260 */
 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 55, 98, 56, 32,   /* 0x3270 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x3280 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,   /* 0x3290 */
 48, 48, 55, 99, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x32a0 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x32b0 */
 49, 48, 10, 48, 48, 48, 48, 48, 55,100, 48, 32, 82, 95, 65, 82,   /* 0x32c0 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x32d0 */
 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 55,102,   /* 0x32e0 */
 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x32f0 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,   /* 0x3300 */
 48, 48, 48, 48, 56, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x3310 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x3320 */
 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 56, 50, 99, 32, 82, 95,   /* 0x3330 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x3340 */
 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,   /* 0x3350 */
 56, 55, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x3360 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,   /* 0x3370 */
 10, 48, 48, 48, 48, 48, 56, 56, 56, 32, 82, 95, 65, 82, 77, 95,   /* 0x3380 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x3390 */
 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 56, 97, 48, 32,   /* 0x33a0 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x33b0 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,   /* 0x33c0 */
 48, 48, 56,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x33d0 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x33e0 */
 49, 48, 10, 48, 48, 48, 48, 48, 56,102, 52, 32, 82, 95, 65, 82,   /* 0x33f0 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x3400 */
 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 56,102,   /* 0x3410 */
 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x3420 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,   /* 0x3430 */
 48, 48, 48, 48, 57, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x3440 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x3450 */
 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 57, 50, 56, 32, 82, 95,   /* 0x3460 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x3470 */
 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79,   /* 0x3480 */
 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,   /* 0x3490 */
 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 93, 58,   /* 0x34a0 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x34b0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x34c0 */
 69, 10, 48, 48, 48, 48, 48, 48, 55, 52, 32, 82, 95, 65, 82, 77,   /* 0x34d0 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x34e0 */
 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 57, 48,   /* 0x34f0 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x3500 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,   /* 0x3510 */
 48, 48, 48, 48, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x3520 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x3530 */
 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 99, 99, 32, 82, 95, 65,   /* 0x3540 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x3550 */
 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x3560 */
102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x3570 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,   /* 0x3580 */
 48, 48, 48, 48, 48, 49, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x3590 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x35a0 */
 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49, 48, 56, 32, 82,   /* 0x35b0 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x35c0 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,   /* 0x35d0 */
 48, 49, 52, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x35e0 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,   /* 0x35f0 */
 48, 10, 48, 48, 48, 48, 48, 49, 57, 48, 32, 82, 95, 65, 82, 77,   /* 0x3600 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x3610 */
 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49, 99, 99,   /* 0x3620 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x3630 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,   /* 0x3640 */
 48, 48, 48, 49,100, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x3650 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x3660 */
 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 48, 52, 32, 82, 95, 65,   /* 0x3670 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x3680 */
 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50,   /* 0x3690 */
 49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x36a0 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,   /* 0x36b0 */
 48, 48, 48, 48, 48, 50, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x36c0 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x36d0 */
 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 51, 52, 32, 82,   /* 0x36e0 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x36f0 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,   /* 0x3700 */
 48, 50, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x3710 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,   /* 0x3720 */
 48, 10, 48, 48, 48, 48, 48, 50, 52, 48, 32, 82, 95, 65, 82, 77,   /* 0x3730 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x3740 */
 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 52, 99,   /* 0x3750 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x3760 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,   /* 0x3770 */
 48, 48, 48, 50, 53, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x3780 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x3790 */
 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 97, 52, 32, 82, 95, 65,   /* 0x37a0 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x37b0 */
 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50,   /* 0x37c0 */
 99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x37d0 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,   /* 0x37e0 */
 48, 48, 48, 48, 48, 50,101, 56, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x37f0 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x3800 */
 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 48, 52, 32, 82,   /* 0x3810 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x3820 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,   /* 0x3830 */
 48, 51, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x3840 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,   /* 0x3850 */
 48, 10, 48, 48, 48, 48, 48, 51, 51, 99, 32, 82, 95, 65, 82, 77,   /* 0x3860 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x3870 */
 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 56, 56,   /* 0x3880 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x3890 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,   /* 0x38a0 */
 48, 48, 48, 51, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x38b0 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x38c0 */
 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 97, 56, 32, 82, 95, 65,   /* 0x38d0 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x38e0 */
 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51,   /* 0x38f0 */
 99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x3900 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,   /* 0x3910 */
 48, 48, 48, 48, 48, 51,101, 48, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x3920 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x3930 */
 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51,101, 56, 32, 82,   /* 0x3940 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x3950 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,   /* 0x3960 */
 48, 52, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x3970 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,   /* 0x3980 */
 48, 10, 48, 48, 48, 48, 48, 52, 51, 56, 32, 82, 95, 65, 82, 77,   /* 0x3990 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x39a0 */
 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 54, 99,   /* 0x39b0 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x39c0 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,   /* 0x39d0 */
 48, 48, 48, 52, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x39e0 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x39f0 */
 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 56, 99, 32, 82, 95, 65,   /* 0x3a00 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x3a10 */
 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52,   /* 0x3a20 */
 98, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x3a30 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,   /* 0x3a40 */
 48, 48, 48, 48, 48, 52,100, 52, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x3a50 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x3a60 */
 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52,101, 99, 32, 82,   /* 0x3a70 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x3a80 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,   /* 0x3a90 */
 48, 52,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x3aa0 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,   /* 0x3ab0 */
 48, 10, 48, 48, 48, 48, 48, 53, 49, 56, 32, 82, 95, 65, 82, 77,   /* 0x3ac0 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x3ad0 */
 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 51, 99,   /* 0x3ae0 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x3af0 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,   /* 0x3b00 */
 48, 48, 48, 53, 57, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x3b10 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x3b20 */
 67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 97, 48, 32, 82, 95, 65,   /* 0x3b30 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x3b40 */
 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53,   /* 0x3b50 */
 99, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x3b60 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,   /* 0x3b70 */
 48, 48, 48, 48, 48, 53,101, 52, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x3b80 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x3b90 */
 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53,102, 99, 32, 82,   /* 0x3ba0 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x3bb0 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,   /* 0x3bc0 */
 48, 54, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x3bd0 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,   /* 0x3be0 */
 48, 10, 48, 48, 48, 48, 48, 54, 50, 52, 32, 82, 95, 65, 82, 77,   /* 0x3bf0 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x3c00 */
 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54, 52, 56,   /* 0x3c10 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x3c20 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,   /* 0x3c30 */
 48, 48, 48, 54, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x3c40 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x3c50 */
 67, 50, 48, 10, 48, 48, 48, 48, 48, 54, 56, 99, 32, 82, 95, 65,   /* 0x3c60 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x3c70 */
 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54,   /* 0x3c80 */
100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x3c90 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,   /* 0x3ca0 */
 48, 48, 48, 48, 48, 54,101, 99, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x3cb0 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x3cc0 */
 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 49, 99, 32, 82,   /* 0x3cd0 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x3ce0 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,   /* 0x3cf0 */
 48, 55, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x3d00 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,   /* 0x3d10 */
 48, 10, 48, 48, 48, 48, 48, 55, 54, 99, 32, 82, 95, 65, 82, 77,   /* 0x3d20 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x3d30 */
 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 55, 99,   /* 0x3d40 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x3d50 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,   /* 0x3d60 */
 48, 48, 48, 55, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x3d70 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x3d80 */
 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 98, 56, 32, 82, 95, 65,   /* 0x3d90 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x3da0 */
 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55,   /* 0x3db0 */
 99, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x3dc0 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,   /* 0x3dd0 */
 48, 48, 48, 48, 48, 55,100, 48, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x3de0 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x3df0 */
 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55,102, 52, 32, 82,   /* 0x3e00 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x3e10 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,   /* 0x3e20 */
 48, 56, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x3e30 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,   /* 0x3e40 */
 48, 10, 48, 48, 48, 48, 48, 56, 50, 99, 32, 82, 95, 65, 82, 77,   /* 0x3e50 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x3e60 */
 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56, 55, 99,   /* 0x3e70 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x3e80 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,   /* 0x3e90 */
 48, 48, 48, 56, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x3ea0 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x3eb0 */
 67, 50, 48, 10, 48, 48, 48, 48, 48, 56, 97, 48, 32, 82, 95, 65,   /* 0x3ec0 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x3ed0 */
 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56,   /* 0x3ee0 */
101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x3ef0 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,   /* 0x3f00 */
 48, 48, 48, 48, 48, 56,102, 52, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x3f10 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x3f20 */
 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56,102, 99, 32, 82,   /* 0x3f30 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x3f40 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,   /* 0x3f50 */
 48, 57, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x3f60 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,   /* 0x3f70 */
 48, 10, 48, 48, 48, 48, 48, 57, 50, 56, 32, 82, 95, 65, 82, 77,   /* 0x3f80 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x3f90 */
 65, 95, 68, 69, 67, 50, 48, 10                                    /* 0x3fa0 */
};
