/* places-place-bar.c generated by valac 0.10.0, the Vala compiler
 * generated from places-place-bar.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <clutk/clutk.h>
#include <unity.h>
#include <gee.h>
#include <clutter/clutter.h>
#include <stdlib.h>
#include <string.h>
#include <dee.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <cairo.h>
#include <gdk/gdk.h>


#define UNITY_PLACES_TYPE_PLACE_BAR (unity_places_place_bar_get_type ())
#define UNITY_PLACES_PLACE_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_PLACE_BAR, UnityPlacesPlaceBar))
#define UNITY_PLACES_PLACE_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_PLACE_BAR, UnityPlacesPlaceBarClass))
#define UNITY_PLACES_IS_PLACE_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_PLACE_BAR))
#define UNITY_PLACES_IS_PLACE_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_PLACE_BAR))
#define UNITY_PLACES_PLACE_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_PLACE_BAR, UnityPlacesPlaceBarClass))

typedef struct _UnityPlacesPlaceBar UnityPlacesPlaceBar;
typedef struct _UnityPlacesPlaceBarClass UnityPlacesPlaceBarClass;
typedef struct _UnityPlacesPlaceBarPrivate UnityPlacesPlaceBarPrivate;

#define UNITY_PLACES_TYPE_PLACE_MODEL (unity_places_place_model_get_type ())
#define UNITY_PLACES_PLACE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_PLACE_MODEL, UnityPlacesPlaceModel))
#define UNITY_PLACES_PLACE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_PLACE_MODEL, UnityPlacesPlaceModelClass))
#define UNITY_PLACES_IS_PLACE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_PLACE_MODEL))
#define UNITY_PLACES_IS_PLACE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_PLACE_MODEL))
#define UNITY_PLACES_PLACE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_PLACE_MODEL, UnityPlacesPlaceModelClass))

typedef struct _UnityPlacesPlaceModel UnityPlacesPlaceModel;
typedef struct _UnityPlacesPlaceModelClass UnityPlacesPlaceModelClass;

#define UNITY_PLACES_TYPE_PLACE_BAR_BACKGROUND (unity_places_place_bar_background_get_type ())
#define UNITY_PLACES_PLACE_BAR_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_PLACE_BAR_BACKGROUND, UnityPlacesPlaceBarBackground))
#define UNITY_PLACES_PLACE_BAR_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_PLACE_BAR_BACKGROUND, UnityPlacesPlaceBarBackgroundClass))
#define UNITY_PLACES_IS_PLACE_BAR_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_PLACE_BAR_BACKGROUND))
#define UNITY_PLACES_IS_PLACE_BAR_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_PLACE_BAR_BACKGROUND))
#define UNITY_PLACES_PLACE_BAR_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_PLACE_BAR_BACKGROUND, UnityPlacesPlaceBarBackgroundClass))

typedef struct _UnityPlacesPlaceBarBackground UnityPlacesPlaceBarBackground;
typedef struct _UnityPlacesPlaceBarBackgroundClass UnityPlacesPlaceBarBackgroundClass;

#define UNITY_PLACES_TYPE_PLACE_ENTRY_VIEW (unity_places_place_entry_view_get_type ())
#define UNITY_PLACES_PLACE_ENTRY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_PLACE_ENTRY_VIEW, UnityPlacesPlaceEntryView))
#define UNITY_PLACES_PLACE_ENTRY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_PLACE_ENTRY_VIEW, UnityPlacesPlaceEntryViewClass))
#define UNITY_PLACES_IS_PLACE_ENTRY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_PLACE_ENTRY_VIEW))
#define UNITY_PLACES_IS_PLACE_ENTRY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_PLACE_ENTRY_VIEW))
#define UNITY_PLACES_PLACE_ENTRY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_PLACE_ENTRY_VIEW, UnityPlacesPlaceEntryViewClass))

typedef struct _UnityPlacesPlaceEntryView UnityPlacesPlaceEntryView;
typedef struct _UnityPlacesPlaceEntryViewClass UnityPlacesPlaceEntryViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define UNITY_TESTING_TYPE_OBJECT_REGISTRY (unity_testing_object_registry_get_type ())
#define UNITY_TESTING_OBJECT_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TESTING_TYPE_OBJECT_REGISTRY, UnityTestingObjectRegistry))
#define UNITY_TESTING_OBJECT_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TESTING_TYPE_OBJECT_REGISTRY, UnityTestingObjectRegistryClass))
#define UNITY_TESTING_IS_OBJECT_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TESTING_TYPE_OBJECT_REGISTRY))
#define UNITY_TESTING_IS_OBJECT_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TESTING_TYPE_OBJECT_REGISTRY))
#define UNITY_TESTING_OBJECT_REGISTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TESTING_TYPE_OBJECT_REGISTRY, UnityTestingObjectRegistryClass))

typedef struct _UnityTestingObjectRegistry UnityTestingObjectRegistry;
typedef struct _UnityTestingObjectRegistryClass UnityTestingObjectRegistryClass;
#define _unity_testing_object_registry_unref0(var) ((var == NULL) ? NULL : (var = (unity_testing_object_registry_unref (var), NULL)))

#define UNITY_PLACES_TYPE_PLACE_ENTRY (unity_places_place_entry_get_type ())
#define UNITY_PLACES_PLACE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_PLACE_ENTRY, UnityPlacesPlaceEntry))
#define UNITY_PLACES_IS_PLACE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_PLACE_ENTRY))
#define UNITY_PLACES_PLACE_ENTRY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_PLACES_TYPE_PLACE_ENTRY, UnityPlacesPlaceEntryIface))

typedef struct _UnityPlacesPlaceEntry UnityPlacesPlaceEntry;
typedef struct _UnityPlacesPlaceEntryIface UnityPlacesPlaceEntryIface;

#define UNITY_PLACES_TYPE_PLACE (unity_places_place_get_type ())
#define UNITY_PLACES_PLACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_PLACE, UnityPlacesPlace))
#define UNITY_PLACES_PLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_PLACE, UnityPlacesPlaceClass))
#define UNITY_PLACES_IS_PLACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_PLACE))
#define UNITY_PLACES_IS_PLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_PLACE))
#define UNITY_PLACES_PLACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_PLACE, UnityPlacesPlaceClass))

typedef struct _UnityPlacesPlace UnityPlacesPlace;
typedef struct _UnityPlacesPlaceClass UnityPlacesPlaceClass;

#define UNITY_PLACES_TYPE_PLACE_VIEW (unity_places_place_view_get_type ())
#define UNITY_PLACES_PLACE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_PLACE_VIEW, UnityPlacesPlaceView))
#define UNITY_PLACES_PLACE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_PLACE_VIEW, UnityPlacesPlaceViewClass))
#define UNITY_PLACES_IS_PLACE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_PLACE_VIEW))
#define UNITY_PLACES_IS_PLACE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_PLACE_VIEW))
#define UNITY_PLACES_PLACE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_PLACE_VIEW, UnityPlacesPlaceViewClass))

typedef struct _UnityPlacesPlaceView UnityPlacesPlaceView;
typedef struct _UnityPlacesPlaceViewClass UnityPlacesPlaceViewClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _UnityPlacesPlaceBarBackgroundPrivate UnityPlacesPlaceBarBackgroundPrivate;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _UnityPlacesPlaceBar {
	CtkBox parent_instance;
	UnityPlacesPlaceBarPrivate * priv;
};

struct _UnityPlacesPlaceBarClass {
	CtkBoxClass parent_class;
};

struct _UnityPlacesPlaceBarPrivate {
	UnityShell* _shell;
	UnityPlacesPlaceModel* _model;
	UnityPlacesPlaceBarBackground* bg;
	CtkEffectGlow* glow;
	UnityPlacesPlaceEntryView* active_view;
};

struct _UnityPlacesPlaceEntryIface {
	GTypeInterface parent_iface;
	void (*connect) (UnityPlacesPlaceEntry* self);
	void (*set_search) (UnityPlacesPlaceEntry* self, const char* search, GHashTable* hints);
	void (*set_active_section) (UnityPlacesPlaceEntry* self, guint section_id);
	void (*set_global_search) (UnityPlacesPlaceEntry* self, const char* search, GHashTable* hints);
	const char* (*get_name) (UnityPlacesPlaceEntry* self);
	void (*set_name) (UnityPlacesPlaceEntry* self, const char* value);
	const char* (*get_icon) (UnityPlacesPlaceEntry* self);
	void (*set_icon) (UnityPlacesPlaceEntry* self, const char* value);
	const char* (*get_description) (UnityPlacesPlaceEntry* self);
	void (*set_description) (UnityPlacesPlaceEntry* self, const char* value);
	guint (*get_position) (UnityPlacesPlaceEntry* self);
	void (*set_position) (UnityPlacesPlaceEntry* self, guint value);
	char** (*get_mimetypes) (UnityPlacesPlaceEntry* self, int* result_length1);
	void (*set_mimetypes) (UnityPlacesPlaceEntry* self, char** value, int value_length1);
	gboolean (*get_sensitive) (UnityPlacesPlaceEntry* self);
	void (*set_sensitive) (UnityPlacesPlaceEntry* self, gboolean value);
	GeeHashMap* (*get_hints) (UnityPlacesPlaceEntry* self);
	void (*set_hints) (UnityPlacesPlaceEntry* self, GeeHashMap* value);
	gboolean (*get_online) (UnityPlacesPlaceEntry* self);
	void (*set_online) (UnityPlacesPlaceEntry* self, gboolean value);
	gboolean (*get_active) (UnityPlacesPlaceEntry* self);
	void (*set_active) (UnityPlacesPlaceEntry* self, gboolean value);
	DeeModel* (*get_sections_model) (UnityPlacesPlaceEntry* self);
	void (*set_sections_model) (UnityPlacesPlaceEntry* self, DeeModel* value);
	const char* (*get_entry_renderer_name) (UnityPlacesPlaceEntry* self);
	void (*set_entry_renderer_name) (UnityPlacesPlaceEntry* self, const char* value);
	DeeModel* (*get_entry_groups_model) (UnityPlacesPlaceEntry* self);
	void (*set_entry_groups_model) (UnityPlacesPlaceEntry* self, DeeModel* value);
	DeeModel* (*get_entry_results_model) (UnityPlacesPlaceEntry* self);
	void (*set_entry_results_model) (UnityPlacesPlaceEntry* self, DeeModel* value);
	GeeHashMap* (*get_entry_renderer_hints) (UnityPlacesPlaceEntry* self);
	void (*set_entry_renderer_hints) (UnityPlacesPlaceEntry* self, GeeHashMap* value);
	const char* (*get_global_renderer_name) (UnityPlacesPlaceEntry* self);
	void (*set_global_renderer_name) (UnityPlacesPlaceEntry* self, const char* value);
	DeeModel* (*get_global_groups_model) (UnityPlacesPlaceEntry* self);
	void (*set_global_groups_model) (UnityPlacesPlaceEntry* self, DeeModel* value);
	DeeModel* (*get_global_results_model) (UnityPlacesPlaceEntry* self);
	void (*set_global_results_model) (UnityPlacesPlaceEntry* self, DeeModel* value);
	GeeHashMap* (*get_global_renderer_hints) (UnityPlacesPlaceEntry* self);
	void (*set_global_renderer_hints) (UnityPlacesPlaceEntry* self, GeeHashMap* value);
	UnityPlacesPlace* (*get_parent) (UnityPlacesPlaceEntry* self);
	void (*set_parent) (UnityPlacesPlaceEntry* self, UnityPlacesPlace* value);
};

struct _UnityPlacesPlaceBarBackground {
	ClutterCairoTexture parent_instance;
	UnityPlacesPlaceBarBackgroundPrivate * priv;
};

struct _UnityPlacesPlaceBarBackgroundClass {
	ClutterCairoTextureClass parent_class;
};

struct _UnityPlacesPlaceBarBackgroundPrivate {
	UnityShell* _shell;
	gint last_width;
	gint last_height;
	GdkPixbuf* tile;
	gint _entry_position;
};


static gpointer unity_places_place_bar_parent_class = NULL;
static gpointer unity_places_place_bar_background_parent_class = NULL;

GType unity_places_place_bar_get_type (void) G_GNUC_CONST;
GType unity_places_place_model_get_type (void) G_GNUC_CONST;
GType unity_places_place_bar_background_get_type (void) G_GNUC_CONST;
GType unity_places_place_entry_view_get_type (void) G_GNUC_CONST;
#define UNITY_PLACES_PLACE_BAR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_PLACES_TYPE_PLACE_BAR, UnityPlacesPlaceBarPrivate))
enum  {
	UNITY_PLACES_PLACE_BAR_DUMMY_PROPERTY,
	UNITY_PLACES_PLACE_BAR_SHELL,
	UNITY_PLACES_PLACE_BAR_MODEL
};
UnityPlacesPlaceBar* unity_places_place_bar_new (UnityShell* shell, UnityPlacesPlaceModel* model);
UnityPlacesPlaceBar* unity_places_place_bar_construct (GType object_type, UnityShell* shell, UnityPlacesPlaceModel* model);
gpointer unity_testing_object_registry_ref (gpointer instance);
void unity_testing_object_registry_unref (gpointer instance);
GParamSpec* unity_testing_param_spec_object_registry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void unity_testing_value_set_object_registry (GValue* value, gpointer v_object);
void unity_testing_value_take_object_registry (GValue* value, gpointer v_object);
gpointer unity_testing_value_get_object_registry (const GValue* value);
GType unity_testing_object_registry_get_type (void) G_GNUC_CONST;
UnityTestingObjectRegistry* unity_testing_object_registry_get_default (void);
void unity_testing_object_registry_register (UnityTestingObjectRegistry* self, const char* name, GObject* object);
void unity_places_place_bar_reset (UnityPlacesPlaceBar* self);
GType unity_places_place_get_type (void) G_GNUC_CONST;
GType unity_places_place_entry_get_type (void) G_GNUC_CONST;
UnityPlacesPlaceEntry* unity_places_place_entry_view_get_entry (UnityPlacesPlaceEntryView* self);
void unity_places_place_entry_set_active (UnityPlacesPlaceEntry* self, gboolean value);
void unity_places_place_bar_background_set_entry_position (UnityPlacesPlaceBarBackground* self, gint value);
void unity_places_place_bar_active_entry_name (UnityPlacesPlaceBar* self, const char* name);
GType unity_places_place_view_get_type (void) G_GNUC_CONST;
const char* unity_places_place_entry_get_name (UnityPlacesPlaceEntry* self);
static void unity_places_place_bar_on_entry_activated (UnityPlacesPlaceBar* self, UnityPlacesPlaceView* view, UnityPlacesPlaceEntryView* entry_view);
static void unity_places_place_bar_real_allocate (ClutterActor* base, const ClutterActorBox* box, ClutterAllocationFlags flags);
UnityShell* unity_places_place_bar_get_shell (UnityPlacesPlaceBar* self);
static void unity_places_place_bar_real_get_preferred_height (ClutterActor* base, float for_width, float* min_height, float* nat_height);
gint unity_places_place_bar_background_get_entry_position (UnityPlacesPlaceBarBackground* self);
#define UNITY_PLACES_PLACE_ENTRY_VIEW_WIDTH 80
static void unity_places_place_bar_set_shell (UnityPlacesPlaceBar* self, UnityShell* value);
UnityPlacesPlaceModel* unity_places_place_bar_get_model (UnityPlacesPlaceBar* self);
void unity_places_place_bar_set_model (UnityPlacesPlaceBar* self, UnityPlacesPlaceModel* value);
UnityPlacesPlaceBarBackground* unity_places_place_bar_background_new (UnityShell* shell);
UnityPlacesPlaceBarBackground* unity_places_place_bar_background_construct (GType object_type, UnityShell* shell);
UnityPlacesPlaceView* unity_places_place_view_new (UnityPlacesPlace* place);
UnityPlacesPlaceView* unity_places_place_view_construct (GType object_type, UnityPlacesPlace* place);
static void _unity_places_place_bar_on_entry_activated_unity_places_place_view_entry_activated (UnityPlacesPlaceView* _sender, UnityPlacesPlaceEntryView* entry_view, gpointer self);
static void _lambda76_ (UnityPlacesPlace* p, UnityPlacesPlaceBar* self);
static void __lambda76__unity_places_place_model_place_added (UnityPlacesPlaceModel* _sender, UnityPlacesPlace* place, gpointer self);
static GObject * unity_places_place_bar_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_places_place_bar_finalize (GObject* obj);
static void unity_places_place_bar_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_places_place_bar_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define UNITY_PLACES_PLACE_BAR_BACKGROUND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_PLACES_TYPE_PLACE_BAR_BACKGROUND, UnityPlacesPlaceBarBackgroundPrivate))
enum  {
	UNITY_PLACES_PLACE_BAR_BACKGROUND_DUMMY_PROPERTY,
	UNITY_PLACES_PLACE_BAR_BACKGROUND_SHELL,
	UNITY_PLACES_PLACE_BAR_BACKGROUND_ENTRY_POSITION
};
#define UNITY_PLACES_PLACE_BAR_BACKGROUND_BG "/usr/share/unity/dash_background.png"
static void unity_places_place_bar_background_real_allocate (ClutterActor* base, const ClutterActorBox* box, ClutterAllocationFlags flags);
static gboolean unity_places_place_bar_background_update_background (UnityPlacesPlaceBarBackground* self);
static gboolean _unity_places_place_bar_background_update_background_gsource_func (gpointer self);
UnityShell* unity_places_place_bar_background_get_shell (UnityPlacesPlaceBarBackground* self);
static void unity_places_place_bar_background_set_shell (UnityPlacesPlaceBarBackground* self, UnityShell* value);
static GObject * unity_places_place_bar_background_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_places_place_bar_background_finalize (GObject* obj);
static void unity_places_place_bar_background_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_places_place_bar_background_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void g_cclosure_user_marshal_VOID__OBJECT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

UnityPlacesPlaceBar* unity_places_place_bar_construct (GType object_type, UnityShell* shell, UnityPlacesPlaceModel* model) {
	UnityPlacesPlaceBar * self;
	UnityTestingObjectRegistry* _tmp0_;
	g_return_val_if_fail (shell != NULL, NULL);
	g_return_val_if_fail (model != NULL, NULL);
	self = (UnityPlacesPlaceBar*) g_object_new (object_type, "shell", shell, "model", model, "orientation", CTK_ORIENTATION_HORIZONTAL, "homogeneous", FALSE, "spacing", 0, NULL);
	unity_testing_object_registry_register (_tmp0_ = unity_testing_object_registry_get_default (), "UnityPlacesPlaceBar", (GObject*) self);
	_unity_testing_object_registry_unref0 (_tmp0_);
	return self;
}


UnityPlacesPlaceBar* unity_places_place_bar_new (UnityShell* shell, UnityPlacesPlaceModel* model) {
	return unity_places_place_bar_construct (UNITY_PLACES_TYPE_PLACE_BAR, shell, model);
}


void unity_places_place_bar_reset (UnityPlacesPlaceBar* self) {
	g_return_if_fail (self != NULL);
	if (UNITY_PLACES_IS_PLACE_ENTRY_VIEW (self->priv->active_view)) {
		UnityPlacesPlaceEntryView* _tmp0_;
		unity_places_place_entry_set_active (unity_places_place_entry_view_get_entry (self->priv->active_view), FALSE);
		self->priv->active_view = (_tmp0_ = NULL, _g_object_unref0 (self->priv->active_view), _tmp0_);
	}
	unity_places_place_bar_background_set_entry_position (self->priv->bg, 0);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void unity_places_place_bar_active_entry_name (UnityPlacesPlaceBar* self, const char* name) {
	GList* children;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	children = clutter_container_get_children ((ClutterContainer*) self);
	{
		GList* p_collection;
		GList* p_it;
		p_collection = children;
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
			ClutterActor* p;
			p = _g_object_ref0 ((ClutterActor*) p_it->data);
			{
				ClutterActor* _tmp0_;
				UnityPlacesPlaceView* view;
				GList* c;
				gboolean found;
				view = _g_object_ref0 ((_tmp0_ = p, UNITY_PLACES_IS_PLACE_VIEW (_tmp0_) ? ((UnityPlacesPlaceView*) _tmp0_) : NULL));
				c = clutter_container_get_children ((ClutterContainer*) view);
				found = FALSE;
				{
					GList* e_collection;
					GList* e_it;
					e_collection = c;
					for (e_it = e_collection; e_it != NULL; e_it = e_it->next) {
						ClutterActor* e;
						e = _g_object_ref0 ((ClutterActor*) e_it->data);
						{
							ClutterActor* _tmp1_;
							UnityPlacesPlaceEntryView* v;
							v = _g_object_ref0 ((_tmp1_ = e, UNITY_PLACES_IS_PLACE_ENTRY_VIEW (_tmp1_) ? ((UnityPlacesPlaceEntryView*) _tmp1_) : NULL));
							if (_vala_strcmp0 (unity_places_place_entry_get_name (unity_places_place_entry_view_get_entry (v)), name) == 0) {
								unity_places_place_bar_on_entry_activated (self, view, v);
								found = TRUE;
								_g_object_unref0 (v);
								_g_object_unref0 (e);
								break;
							}
							_g_object_unref0 (v);
							_g_object_unref0 (e);
						}
					}
				}
				if (found) {
					_g_list_free0 (c);
					_g_object_unref0 (view);
					_g_object_unref0 (p);
					break;
				}
				_g_list_free0 (c);
				_g_object_unref0 (view);
				_g_object_unref0 (p);
			}
		}
	}
	_g_list_free0 (children);
}


static void unity_places_place_bar_real_allocate (ClutterActor* base, const ClutterActorBox* box, ClutterAllocationFlags flags) {
	UnityPlacesPlaceBar * self;
	CtkPadding _tmp0_ = {0};
	CtkPadding _tmp1_;
	self = (UnityPlacesPlaceBar*) base;
	ctk_actor_set_padding ((CtkActor*) self, (_tmp1_ = (_tmp0_.top = 0.0f, _tmp0_.right = (float) unity_shell_get_indicators_width (self->priv->_shell), _tmp0_.bottom = 0.0f, _tmp0_.left = (float) unity_shell_get_launcher_width_foobar (self->priv->_shell), _tmp0_), &_tmp1_));
	CLUTTER_ACTOR_CLASS (unity_places_place_bar_parent_class)->allocate ((ClutterActor*) CTK_BOX (self), box, flags);
}


static void unity_places_place_bar_real_get_preferred_height (ClutterActor* base, float for_width, float* min_height, float* nat_height) {
	UnityPlacesPlaceBar * self;
	self = (UnityPlacesPlaceBar*) base;
	*min_height = 56.0f;
	*nat_height = 56.0f;
}


static void unity_places_place_bar_on_entry_activated (UnityPlacesPlaceBar* self, UnityPlacesPlaceView* view, UnityPlacesPlaceEntryView* entry_view) {
	UnityPlacesPlaceEntryView* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	g_return_if_fail (entry_view != NULL);
	if (self->priv->active_view == entry_view) {
		return;
	}
	if (UNITY_PLACES_IS_PLACE_ENTRY_VIEW (self->priv->active_view)) {
		unity_places_place_entry_set_active (unity_places_place_entry_view_get_entry (self->priv->active_view), FALSE);
	}
	self->priv->active_view = (_tmp0_ = _g_object_ref0 (entry_view), _g_object_unref0 (self->priv->active_view), _tmp0_);
	unity_places_place_entry_set_active (unity_places_place_entry_view_get_entry (self->priv->active_view), TRUE);
	unity_places_place_bar_background_set_entry_position (self->priv->bg, (gint) (clutter_actor_get_x ((ClutterActor*) view) + clutter_actor_get_x ((ClutterActor*) entry_view)));
	ctk_effect_set_invalidate_effect_cache ((CtkEffect*) self->priv->glow, TRUE);
	g_signal_emit_by_name (self, "entry-view-activated", unity_places_place_entry_view_get_entry (entry_view), unity_places_place_bar_background_get_entry_position (self->priv->bg) + (UNITY_PLACES_PLACE_ENTRY_VIEW_WIDTH / 2));
}


UnityShell* unity_places_place_bar_get_shell (UnityPlacesPlaceBar* self) {
	UnityShell* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_shell;
	return result;
}


static void unity_places_place_bar_set_shell (UnityPlacesPlaceBar* self, UnityShell* value) {
	UnityShell* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_shell = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_shell), _tmp0_);
	g_object_notify ((GObject *) self, "shell");
}


UnityPlacesPlaceModel* unity_places_place_bar_get_model (UnityPlacesPlaceBar* self) {
	UnityPlacesPlaceModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_model;
	return result;
}


void unity_places_place_bar_set_model (UnityPlacesPlaceBar* self, UnityPlacesPlaceModel* value) {
	UnityPlacesPlaceModel* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_model = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_model), _tmp0_);
	g_object_notify ((GObject *) self, "model");
}


static void _unity_places_place_bar_on_entry_activated_unity_places_place_view_entry_activated (UnityPlacesPlaceView* _sender, UnityPlacesPlaceEntryView* entry_view, gpointer self) {
	unity_places_place_bar_on_entry_activated (self, _sender, entry_view);
}


static void _lambda76_ (UnityPlacesPlace* p, UnityPlacesPlaceBar* self) {
	UnityPlacesPlaceView* view;
	g_return_if_fail (p != NULL);
	view = g_object_ref_sink (unity_places_place_view_new (p));
	ctk_box_pack ((CtkBox*) self, (ClutterActor*) view, FALSE, TRUE);
	clutter_actor_show ((ClutterActor*) view);
	g_signal_connect_object (view, "entry-activated", (GCallback) _unity_places_place_bar_on_entry_activated_unity_places_place_view_entry_activated, self, 0);
	_g_object_unref0 (view);
}


static void __lambda76__unity_places_place_model_place_added (UnityPlacesPlaceModel* _sender, UnityPlacesPlace* place, gpointer self) {
	_lambda76_ (place, self);
}


static GObject * unity_places_place_bar_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityPlacesPlaceBar * self;
	parent_class = G_OBJECT_CLASS (unity_places_place_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_PLACES_PLACE_BAR (obj);
	{
		UnityPlacesPlaceBarBackground* _tmp0_;
		CtkEffectGlow* _tmp1_;
		ClutterColor _tmp2_ = {0};
		ClutterColor _tmp3_;
		self->priv->bg = (_tmp0_ = g_object_ref_sink (unity_places_place_bar_background_new (self->priv->_shell)), _g_object_unref0 (self->priv->bg), _tmp0_);
		ctk_actor_set_background ((CtkActor*) self, (ClutterActor*) self->priv->bg);
		clutter_actor_show ((ClutterActor*) self->priv->bg);
		self->priv->glow = (_tmp1_ = g_object_ref_sink ((CtkEffectGlow*) ctk_effect_glow_new ()), _g_object_unref0 (self->priv->glow), _tmp1_);
		ctk_effect_glow_set_color (self->priv->glow, (_tmp3_ = (_tmp2_.red = (guint8) 255, _tmp2_.green = (guint8) 255, _tmp2_.blue = (guint8) 255, _tmp2_.alpha = (guint8) 255, _tmp2_), &_tmp3_));
		ctk_effect_glow_set_factor (self->priv->glow, 1.0f);
		ctk_effect_set_margin ((CtkEffect*) self->priv->glow, 5);
		ctk_actor_add_effect ((CtkActor*) self, (CtkEffect*) self->priv->glow);
		{
			GeeIterator* _place_it;
			_place_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->_model);
			while (TRUE) {
				UnityPlacesPlace* place;
				UnityPlacesPlaceView* view;
				if (!gee_iterator_next (_place_it)) {
					break;
				}
				place = _g_object_ref0 ((UnityPlacesPlace*) gee_iterator_get (_place_it));
				view = g_object_ref_sink (unity_places_place_view_new (place));
				ctk_box_pack ((CtkBox*) self, (ClutterActor*) view, FALSE, TRUE);
				clutter_actor_show ((ClutterActor*) view);
				g_signal_connect_object (view, "entry-activated", (GCallback) _unity_places_place_bar_on_entry_activated_unity_places_place_view_entry_activated, self, 0);
				_g_object_unref0 (view);
				_g_object_unref0 (place);
			}
			_g_object_unref0 (_place_it);
		}
		g_signal_connect_object (self->priv->_model, "place-added", (GCallback) __lambda76__unity_places_place_model_place_added, self, 0);
	}
	return obj;
}


static void unity_places_place_bar_class_init (UnityPlacesPlaceBarClass * klass) {
	unity_places_place_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPlacesPlaceBarPrivate));
	CLUTTER_ACTOR_CLASS (klass)->allocate = unity_places_place_bar_real_allocate;
	CLUTTER_ACTOR_CLASS (klass)->get_preferred_height = unity_places_place_bar_real_get_preferred_height;
	G_OBJECT_CLASS (klass)->get_property = unity_places_place_bar_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_places_place_bar_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_places_place_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_places_place_bar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_PLACE_BAR_SHELL, g_param_spec_object ("shell", "shell", "shell", UNITY_TYPE_SHELL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_PLACE_BAR_MODEL, g_param_spec_object ("model", "model", "model", UNITY_PLACES_TYPE_PLACE_MODEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_signal_new ("entry_view_activated", UNITY_PLACES_TYPE_PLACE_BAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_INT, G_TYPE_NONE, 2, UNITY_PLACES_TYPE_PLACE_ENTRY, G_TYPE_INT);
}


static void unity_places_place_bar_instance_init (UnityPlacesPlaceBar * self) {
	self->priv = UNITY_PLACES_PLACE_BAR_GET_PRIVATE (self);
	self->priv->active_view = NULL;
}


static void unity_places_place_bar_finalize (GObject* obj) {
	UnityPlacesPlaceBar * self;
	self = UNITY_PLACES_PLACE_BAR (obj);
	_g_object_unref0 (self->priv->_shell);
	_g_object_unref0 (self->priv->_model);
	_g_object_unref0 (self->priv->bg);
	_g_object_unref0 (self->priv->glow);
	_g_object_unref0 (self->priv->active_view);
	G_OBJECT_CLASS (unity_places_place_bar_parent_class)->finalize (obj);
}


GType unity_places_place_bar_get_type (void) {
	static volatile gsize unity_places_place_bar_type_id__volatile = 0;
	if (g_once_init_enter (&unity_places_place_bar_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlacesPlaceBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_places_place_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPlacesPlaceBar), 0, (GInstanceInitFunc) unity_places_place_bar_instance_init, NULL };
		GType unity_places_place_bar_type_id;
		unity_places_place_bar_type_id = g_type_register_static (CTK_TYPE_BOX, "UnityPlacesPlaceBar", &g_define_type_info, 0);
		g_once_init_leave (&unity_places_place_bar_type_id__volatile, unity_places_place_bar_type_id);
	}
	return unity_places_place_bar_type_id__volatile;
}


static void unity_places_place_bar_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityPlacesPlaceBar * self;
	self = UNITY_PLACES_PLACE_BAR (object);
	switch (property_id) {
		case UNITY_PLACES_PLACE_BAR_SHELL:
		g_value_set_object (value, unity_places_place_bar_get_shell (self));
		break;
		case UNITY_PLACES_PLACE_BAR_MODEL:
		g_value_set_object (value, unity_places_place_bar_get_model (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_places_place_bar_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityPlacesPlaceBar * self;
	self = UNITY_PLACES_PLACE_BAR (object);
	switch (property_id) {
		case UNITY_PLACES_PLACE_BAR_SHELL:
		unity_places_place_bar_set_shell (self, g_value_get_object (value));
		break;
		case UNITY_PLACES_PLACE_BAR_MODEL:
		unity_places_place_bar_set_model (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


UnityPlacesPlaceBarBackground* unity_places_place_bar_background_construct (GType object_type, UnityShell* shell) {
	UnityPlacesPlaceBarBackground * self;
	g_return_val_if_fail (shell != NULL, NULL);
	self = (UnityPlacesPlaceBarBackground*) g_object_new (object_type, "shell", shell, NULL);
	return self;
}


UnityPlacesPlaceBarBackground* unity_places_place_bar_background_new (UnityShell* shell) {
	return unity_places_place_bar_background_construct (UNITY_PLACES_TYPE_PLACE_BAR_BACKGROUND, shell);
}


static gboolean _unity_places_place_bar_background_update_background_gsource_func (gpointer self) {
	gboolean result;
	result = unity_places_place_bar_background_update_background (self);
	return result;
}


static void unity_places_place_bar_background_real_allocate (ClutterActor* base, const ClutterActorBox* box, ClutterAllocationFlags flags) {
	UnityPlacesPlaceBarBackground * self;
	gint width;
	gint height;
	gboolean _tmp0_ = FALSE;
	self = (UnityPlacesPlaceBarBackground*) base;
	width = (gint) ((*box).x2 - (*box).x1);
	height = (gint) ((*box).y2 - (*box).y1);
	CLUTTER_ACTOR_CLASS (unity_places_place_bar_background_parent_class)->allocate ((ClutterActor*) CLUTTER_CAIRO_TEXTURE (self), box, flags);
	if (width != self->priv->last_width) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = height != self->priv->last_height;
	}
	if (_tmp0_) {
		self->priv->last_width = width;
		self->priv->last_height = height;
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 0, _unity_places_place_bar_background_update_background_gsource_func, g_object_ref (self), g_object_unref);
	}
}


static gpointer _cairo_pattern_reference0 (gpointer self) {
	return self ? cairo_pattern_reference (self) : NULL;
}


static gboolean unity_places_place_bar_background_update_background (UnityPlacesPlaceBarBackground* self) {
	gboolean result = FALSE;
	cairo_t* cr;
	cairo_t* _tmp0_;
	gint x;
	gint y;
	gint width;
	gint height;
	gint radius;
	gint launcher_width;
	gint panel_height;
	gint entry_width;
	gint top_padding;
	g_return_val_if_fail (self != NULL, FALSE);
	cr = NULL;
	clutter_cairo_texture_set_surface_size ((ClutterCairoTexture*) self, (guint) self->priv->last_width, (guint) self->priv->last_height);
	cr = (_tmp0_ = clutter_cairo_texture_create ((ClutterCairoTexture*) self), _cairo_destroy0 (cr), _tmp0_);
	cairo_set_operator (cr, CAIRO_OPERATOR_CLEAR);
	cairo_paint (cr);
	cairo_set_operator (cr, CAIRO_OPERATOR_OVER);
	cairo_set_line_width (cr, 1.5);
	cairo_set_source_rgba (cr, 1.0, 1.0, 1.0, 0.0);
	cairo_translate (cr, -0.5, -0.5);
	x = -1;
	y = -1;
	width = self->priv->last_width + 2;
	height = self->priv->last_height;
	radius = 13;
	launcher_width = unity_shell_get_launcher_width_foobar (self->priv->_shell);
	panel_height = unity_shell_get_panel_height_foobar (self->priv->_shell);
	entry_width = UNITY_PLACES_PLACE_ENTRY_VIEW_WIDTH;
	top_padding = 3;
	cairo_move_to (cr, (double) x, (double) y);
	cairo_line_to (cr, (double) width, (double) y);
	cairo_line_to (cr, (double) width, (double) height);
	if (unity_places_place_bar_background_get_entry_position (self) != 0) {
		gint x1;
		gint x2;
		x1 = unity_places_place_bar_background_get_entry_position (self);
		x2 = unity_places_place_bar_background_get_entry_position (self) + entry_width;
		cairo_line_to (cr, (double) (x2 + radius), (double) height);
		cairo_curve_to (cr, (double) x2, (double) height, (double) x2, (double) height, (double) x2, (double) (height - radius));
		cairo_line_to (cr, (double) x2, (double) (radius + top_padding));
		cairo_curve_to (cr, (double) x2, (double) top_padding, (double) x2, (double) top_padding, (double) (x2 - radius), (double) top_padding);
		cairo_line_to (cr, (double) (x1 + radius), (double) top_padding);
		cairo_curve_to (cr, (double) x1, (double) top_padding, (double) x1, (double) top_padding, (double) x1, (double) (top_padding + radius));
		if (x1 < (launcher_width + entry_width)) {
			cairo_line_to (cr, (double) launcher_width, (double) panel_height);
		} else {
			cairo_line_to (cr, (double) x1, (double) (height - radius));
			cairo_curve_to (cr, (double) x1, (double) height, (double) x1, (double) height, (double) (x1 - radius), (double) height);
			cairo_line_to (cr, (double) (launcher_width + radius), (double) height);
			cairo_curve_to (cr, (double) launcher_width, (double) height, (double) launcher_width, (double) height, (double) launcher_width, (double) (height - radius));
			cairo_line_to (cr, (double) launcher_width, (double) panel_height);
		}
	} else {
		cairo_line_to (cr, (double) (launcher_width + radius), (double) height);
		cairo_curve_to (cr, (double) launcher_width, (double) height, (double) launcher_width, (double) height, (double) launcher_width, (double) (height - radius));
		cairo_line_to (cr, (double) launcher_width, (double) panel_height);
	}
	cairo_line_to (cr, (double) x, (double) panel_height);
	cairo_close_path (cr);
	cairo_stroke_preserve (cr);
	cairo_clip_preserve (cr);
	if (GDK_IS_PIXBUF (self->priv->tile)) {
		cairo_pattern_t* pat;
		gdk_cairo_set_source_pixbuf (cr, self->priv->tile, (double) 0, (double) 0);
		pat = _cairo_pattern_reference0 (cairo_get_source (cr));
		cairo_pattern_set_extend (pat, CAIRO_EXTEND_REPEAT);
		cairo_paint_with_alpha (cr, 0.25);
		_cairo_pattern_destroy0 (pat);
	}
	cairo_reset_clip (cr);
	cairo_set_source_rgba (cr, 1.0, 1.0, 1.0, 0.6);
	cairo_stroke (cr);
	result = FALSE;
	_cairo_destroy0 (cr);
	return result;
}


UnityShell* unity_places_place_bar_background_get_shell (UnityPlacesPlaceBarBackground* self) {
	UnityShell* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_shell;
	return result;
}


static void unity_places_place_bar_background_set_shell (UnityPlacesPlaceBarBackground* self, UnityShell* value) {
	UnityShell* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_shell = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_shell), _tmp0_);
	g_object_notify ((GObject *) self, "shell");
}


gint unity_places_place_bar_background_get_entry_position (UnityPlacesPlaceBarBackground* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_entry_position;
	return result;
}


void unity_places_place_bar_background_set_entry_position (UnityPlacesPlaceBarBackground* self, gint value) {
	g_return_if_fail (self != NULL);
	if (self->priv->_entry_position != value) {
		self->priv->_entry_position = value;
		unity_places_place_bar_background_update_background (self);
	}
	g_object_notify ((GObject *) self, "entry-position");
}


static GObject * unity_places_place_bar_background_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityPlacesPlaceBarBackground * self;
	GError * _inner_error_;
	parent_class = G_OBJECT_CLASS (unity_places_place_bar_background_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_PLACES_PLACE_BAR_BACKGROUND (obj);
	_inner_error_ = NULL;
	{
		{
			GdkPixbuf* _tmp0_;
			GdkPixbuf* _tmp1_;
			_tmp0_ = gdk_pixbuf_new_from_file (UNITY_PLACES_PLACE_BAR_BACKGROUND_BG, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch15_g_error;
			}
			self->priv->tile = (_tmp1_ = _tmp0_, _g_object_unref0 (self->priv->tile), _tmp1_);
		}
		goto __finally15;
		__catch15_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("places-place-bar.vala:191: Unable to load dash background");
				_g_error_free0 (e);
			}
		}
		__finally15:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	return obj;
}


static void unity_places_place_bar_background_class_init (UnityPlacesPlaceBarBackgroundClass * klass) {
	unity_places_place_bar_background_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPlacesPlaceBarBackgroundPrivate));
	CLUTTER_ACTOR_CLASS (klass)->allocate = unity_places_place_bar_background_real_allocate;
	G_OBJECT_CLASS (klass)->get_property = unity_places_place_bar_background_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_places_place_bar_background_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_places_place_bar_background_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_places_place_bar_background_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_PLACE_BAR_BACKGROUND_SHELL, g_param_spec_object ("shell", "shell", "shell", UNITY_TYPE_SHELL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_PLACE_BAR_BACKGROUND_ENTRY_POSITION, g_param_spec_int ("entry-position", "entry-position", "entry-position", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void unity_places_place_bar_background_instance_init (UnityPlacesPlaceBarBackground * self) {
	self->priv = UNITY_PLACES_PLACE_BAR_BACKGROUND_GET_PRIVATE (self);
	self->priv->last_width = 0;
	self->priv->last_height = 0;
	self->priv->tile = NULL;
	self->priv->_entry_position = 0;
}


static void unity_places_place_bar_background_finalize (GObject* obj) {
	UnityPlacesPlaceBarBackground * self;
	self = UNITY_PLACES_PLACE_BAR_BACKGROUND (obj);
	_g_object_unref0 (self->priv->_shell);
	_g_object_unref0 (self->priv->tile);
	G_OBJECT_CLASS (unity_places_place_bar_background_parent_class)->finalize (obj);
}


GType unity_places_place_bar_background_get_type (void) {
	static volatile gsize unity_places_place_bar_background_type_id__volatile = 0;
	if (g_once_init_enter (&unity_places_place_bar_background_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlacesPlaceBarBackgroundClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_places_place_bar_background_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPlacesPlaceBarBackground), 0, (GInstanceInitFunc) unity_places_place_bar_background_instance_init, NULL };
		GType unity_places_place_bar_background_type_id;
		unity_places_place_bar_background_type_id = g_type_register_static (CLUTTER_TYPE_CAIRO_TEXTURE, "UnityPlacesPlaceBarBackground", &g_define_type_info, 0);
		g_once_init_leave (&unity_places_place_bar_background_type_id__volatile, unity_places_place_bar_background_type_id);
	}
	return unity_places_place_bar_background_type_id__volatile;
}


static void unity_places_place_bar_background_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityPlacesPlaceBarBackground * self;
	self = UNITY_PLACES_PLACE_BAR_BACKGROUND (object);
	switch (property_id) {
		case UNITY_PLACES_PLACE_BAR_BACKGROUND_SHELL:
		g_value_set_object (value, unity_places_place_bar_background_get_shell (self));
		break;
		case UNITY_PLACES_PLACE_BAR_BACKGROUND_ENTRY_POSITION:
		g_value_set_int (value, unity_places_place_bar_background_get_entry_position (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_places_place_bar_background_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityPlacesPlaceBarBackground * self;
	self = UNITY_PLACES_PLACE_BAR_BACKGROUND (object);
	switch (property_id) {
		case UNITY_PLACES_PLACE_BAR_BACKGROUND_SHELL:
		unity_places_place_bar_background_set_shell (self, g_value_get_object (value));
		break;
		case UNITY_PLACES_PLACE_BAR_BACKGROUND_ENTRY_POSITION:
		unity_places_place_bar_background_set_entry_position (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__OBJECT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_INT) (gpointer data1, gpointer arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_INT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_int (param_values + 2), data2);
}



