/* scrollerchild-controller.c generated by valac 0.10.0, the Vala compiler
 * generated from scrollerchild-controller.vala, do not modify */

/*
 *      scrollerchild-controller.vala
 *      Copyright (C) 2010 Canonical Ltd
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 3 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *      MA 02110-1301, USA.
 *
 *
 *      Authored by Gordon Allott <gord.allott@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <unity.h>
#include <libdbusmenu-glib/client.h>
#include <libdbusmenu-glib/menuitem-proxy.h>
#include <libdbusmenu-glib/menuitem.h>
#include <libdbusmenu-glib/server.h>
#include <float.h>
#include <math.h>
#include <clutk/clutk.h>
#include <stdlib.h>
#include <string.h>
#include <clutter/clutter.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <glib/gstdio.h>


#define UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER_MENU_STATE (unity_launcher_scroller_child_controller_menu_state_get_type ())

#define UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER (unity_launcher_scroller_child_controller_get_type ())
#define UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER, UnityLauncherScrollerChildController))
#define UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER, UnityLauncherScrollerChildControllerClass))
#define UNITY_LAUNCHER_IS_SCROLLER_CHILD_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER))
#define UNITY_LAUNCHER_IS_SCROLLER_CHILD_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER))
#define UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER, UnityLauncherScrollerChildControllerClass))

typedef struct _UnityLauncherScrollerChildController UnityLauncherScrollerChildController;
typedef struct _UnityLauncherScrollerChildControllerClass UnityLauncherScrollerChildControllerClass;
typedef struct _UnityLauncherScrollerChildControllerPrivate UnityLauncherScrollerChildControllerPrivate;

#define UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER (unity_launcher_quicklist_controller_get_type ())
#define UNITY_LAUNCHER_QUICKLIST_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER, UnityLauncherQuicklistController))
#define UNITY_LAUNCHER_QUICKLIST_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER, UnityLauncherQuicklistControllerClass))
#define UNITY_LAUNCHER_IS_QUICKLIST_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER))
#define UNITY_LAUNCHER_IS_QUICKLIST_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER))
#define UNITY_LAUNCHER_QUICKLIST_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER, UnityLauncherQuicklistControllerClass))

typedef struct _UnityLauncherQuicklistController UnityLauncherQuicklistController;
typedef struct _UnityLauncherQuicklistControllerClass UnityLauncherQuicklistControllerClass;

#define UNITY_LAUNCHER_TYPE_SCROLLER_CHILD (unity_launcher_scroller_child_get_type ())
#define UNITY_LAUNCHER_SCROLLER_CHILD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD, UnityLauncherScrollerChild))
#define UNITY_LAUNCHER_SCROLLER_CHILD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD, UnityLauncherScrollerChildClass))
#define UNITY_LAUNCHER_IS_SCROLLER_CHILD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD))
#define UNITY_LAUNCHER_IS_SCROLLER_CHILD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD))
#define UNITY_LAUNCHER_SCROLLER_CHILD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD, UnityLauncherScrollerChildClass))

typedef struct _UnityLauncherScrollerChild UnityLauncherScrollerChild;
typedef struct _UnityLauncherScrollerChildClass UnityLauncherScrollerChildClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _UnityLauncherScrollerChildPrivate UnityLauncherScrollerChildPrivate;

#define UNITY_LAUNCHER_TYPE_PIN_TYPE (unity_launcher_pin_type_get_type ())

#define UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER_STATE (unity_launcher_quicklist_controller_state_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block11Data Block11Data;

typedef enum  {
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_NO_MENU,
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_LABEL,
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_MENU,
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_MENU_CLOSE_WHEN_LEAVE
} UnityLauncherScrollerChildControllerMenuState;

typedef void (*UnityLauncherScrollerChildControllermenu_cb) (DbusmenuMenuitem* menu, void* user_data);
struct _UnityLauncherScrollerChildController {
	GObject parent_instance;
	UnityLauncherScrollerChildControllerPrivate * priv;
	UnityLauncherScrollerChildControllerMenuState menu_state;
	guint32 last_press_time;
	gboolean button_down;
	float click_start_pos_x;
	float click_start_pos_y;
	gint drag_sensitivity;
};

struct _UnityLauncherScrollerChildControllerClass {
	GObjectClass parent_class;
	void (*get_menu_actions) (UnityLauncherScrollerChildController* self, UnityLauncherScrollerChildControllermenu_cb callback, void* callback_target);
	void (*get_menu_navigation) (UnityLauncherScrollerChildController* self, UnityLauncherScrollerChildControllermenu_cb callback, void* callback_target);
	void (*activate) (UnityLauncherScrollerChildController* self);
	UnityLauncherQuicklistController* (*get_menu_controller) (UnityLauncherScrollerChildController* self);
	gboolean (*can_drag) (UnityLauncherScrollerChildController* self);
};

struct _UnityLauncherScrollerChildControllerPrivate {
	UnityLauncherScrollerChild* _child;
	char* _name;
	gboolean _hide;
	UnityThemeFilePath* theme_file_path;
	UnityLauncherQuicklistController* _menu;
	gboolean no_activate;
};

typedef enum  {
	UNITY_LAUNCHER_PIN_TYPE_UNPINNED,
	UNITY_LAUNCHER_PIN_TYPE_PINNED,
	UNITY_LAUNCHER_PIN_TYPE_ALWAYS,
	UNITY_LAUNCHER_PIN_TYPE_NEVER
} UnityLauncherPinType;

struct _UnityLauncherScrollerChild {
	CtkActor parent_instance;
	UnityLauncherScrollerChildPrivate * priv;
	UnityLauncherPinType pin_type;
	gboolean do_not_render;
	UnityLauncherScrollerChildController* controller;
	float grabbed_push;
	UnityUnityIcon* processed_icon;
};

struct _UnityLauncherScrollerChildClass {
	CtkActorClass parent_class;
};

typedef enum  {
	UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_LABEL,
	UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_MENU,
	UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_CLOSED
} UnityLauncherQuicklistControllerState;

struct _Block11Data {
	int _ref_count_;
	UnityLauncherScrollerChildController * self;
	char* icon_name;
};


extern gboolean unity_launcher_disable_quicklists;
static gpointer unity_launcher_scroller_child_controller_parent_class = NULL;
static UnityDragModelIface* unity_launcher_scroller_child_controller_unity_drag_model_parent_iface = NULL;

GType unity_launcher_scroller_child_controller_menu_state_get_type (void) G_GNUC_CONST;
GType unity_launcher_scroller_child_controller_get_type (void) G_GNUC_CONST;
GType unity_launcher_quicklist_controller_get_type (void) G_GNUC_CONST;
GType unity_launcher_scroller_child_get_type (void) G_GNUC_CONST;
#define UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER, UnityLauncherScrollerChildControllerPrivate))
enum  {
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_DUMMY_PROPERTY,
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_CHILD,
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_NAME,
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_HIDE,
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU
};
UnityLauncherScrollerChildController* unity_launcher_scroller_child_controller_construct (GType object_type, UnityLauncherScrollerChild* child_);
void unity_launcher_scroller_child_controller_closed (UnityLauncherScrollerChildController* self);
void unity_launcher_scroller_child_controller_get_menu_actions (UnityLauncherScrollerChildController* self, UnityLauncherScrollerChildControllermenu_cb callback, void* callback_target);
static void unity_launcher_scroller_child_controller_real_get_menu_actions (UnityLauncherScrollerChildController* self, UnityLauncherScrollerChildControllermenu_cb callback, void* callback_target);
void unity_launcher_scroller_child_controller_get_menu_navigation (UnityLauncherScrollerChildController* self, UnityLauncherScrollerChildControllermenu_cb callback, void* callback_target);
static void unity_launcher_scroller_child_controller_real_get_menu_navigation (UnityLauncherScrollerChildController* self, UnityLauncherScrollerChildControllermenu_cb callback, void* callback_target);
void unity_launcher_scroller_child_controller_activate (UnityLauncherScrollerChildController* self);
static void unity_launcher_scroller_child_controller_real_activate (UnityLauncherScrollerChildController* self);
UnityLauncherQuicklistController* unity_launcher_scroller_child_controller_get_menu_controller (UnityLauncherScrollerChildController* self);
static UnityLauncherQuicklistController* unity_launcher_scroller_child_controller_real_get_menu_controller (UnityLauncherScrollerChildController* self);
gboolean unity_launcher_scroller_child_controller_can_drag (UnityLauncherScrollerChildController* self);
static gboolean unity_launcher_scroller_child_controller_real_can_drag (UnityLauncherScrollerChildController* self);
static gboolean unity_launcher_scroller_child_controller_on_leave_event (UnityLauncherScrollerChildController* self, ClutterEvent* event);
static void unity_launcher_scroller_child_controller_ensure_menu_state (UnityLauncherScrollerChildController* self);
static gboolean unity_launcher_scroller_child_controller_on_press_event (UnityLauncherScrollerChildController* self, ClutterEvent* event);
static gboolean unity_launcher_scroller_child_controller_on_release_event (UnityLauncherScrollerChildController* self, ClutterEvent* event);
UnityLauncherScrollerChild* unity_launcher_scroller_child_controller_get_child (UnityLauncherScrollerChildController* self);
GType unity_launcher_pin_type_get_type (void) G_GNUC_CONST;
UnityLauncherQuicklistController* unity_launcher_scroller_child_controller_get_menu (UnityLauncherScrollerChildController* self);
GType unity_launcher_quicklist_controller_state_get_type (void) G_GNUC_CONST;
UnityLauncherQuicklistControllerState unity_launcher_quicklist_controller_get_state (UnityLauncherQuicklistController* self);
void unity_launcher_quicklist_controller_set_state (UnityLauncherQuicklistController* self, UnityLauncherQuicklistControllerState value);
static gboolean unity_launcher_scroller_child_controller_on_enter_event (UnityLauncherScrollerChildController* self, ClutterEvent* event);
void unity_launcher_scroller_child_controller_set_menu (UnityLauncherScrollerChildController* self, UnityLauncherQuicklistController* value);
gboolean unity_launcher_quicklist_controller_is_menu_open (void);
gboolean unity_launcher_quicklist_controller_do_menus_match (UnityLauncherQuicklistController* menu);
static gboolean _lambda20_ (UnityLauncherScrollerChildController* self);
static gboolean __lambda20__gsource_func (gpointer self);
static ClutterActor* unity_launcher_scroller_child_controller_real_get_icon (UnityDragModel* base);
ClutterActor* unity_launcher_scroller_child_get_content (UnityLauncherScrollerChild* self);
static char* unity_launcher_scroller_child_controller_real_get_drag_data (UnityDragModel* base);
const char* unity_launcher_scroller_child_controller_get_name (UnityLauncherScrollerChildController* self);
static gboolean unity_launcher_scroller_child_controller_on_motion_event (UnityLauncherScrollerChildController* self, ClutterEvent* event);
void unity_launcher_scroller_child_controller_load_icon_from_icon_name (UnityLauncherScrollerChildController* self, const char* icon_name);
static gboolean unity_launcher_scroller_child_controller_try_load_from_file (UnityLauncherScrollerChildController* self, const char* filepath);
static void _lambda21_ (UnityThemeFilePath* theme, const char* filepath, UnityLauncherScrollerChildController* self);
void unity_launcher_scroller_child_set_icon (UnityLauncherScrollerChild* self, GdkPixbuf* value);
static void __lambda21__unity_theme_file_path_found_icon_path (UnityThemeFilePath* _sender, const char* filepath, gpointer self);
static void _lambda22_ (Block11Data* _data11_);
static void __lambda22__unity_theme_file_path_failed (UnityThemeFilePath* _sender, gpointer self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (Block11Data* _data11_);
static void unity_launcher_scroller_child_controller_set_child (UnityLauncherScrollerChildController* self, UnityLauncherScrollerChild* value);
void unity_launcher_scroller_child_controller_set_name (UnityLauncherScrollerChildController* self, const char* value);
gboolean unity_launcher_scroller_child_controller_get_hide (UnityLauncherScrollerChildController* self);
void unity_launcher_scroller_child_controller_set_hide (UnityLauncherScrollerChildController* self, gboolean value);
static gboolean _unity_launcher_scroller_child_controller_on_press_event_clutter_actor_button_press_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static gboolean _unity_launcher_scroller_child_controller_on_release_event_clutter_actor_button_release_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static gboolean _unity_launcher_scroller_child_controller_on_enter_event_clutter_actor_enter_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static gboolean _unity_launcher_scroller_child_controller_on_leave_event_clutter_actor_leave_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static gboolean _unity_launcher_scroller_child_controller_on_motion_event_clutter_actor_motion_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
#define UNITY_LAUNCHER_SHORT_DELAY ((guint) 400)
static GObject * unity_launcher_scroller_child_controller_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_launcher_scroller_child_controller_finalize (GObject* obj);
static void unity_launcher_scroller_child_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_launcher_scroller_child_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



GType unity_launcher_scroller_child_controller_menu_state_get_type (void) {
	static volatile gsize unity_launcher_scroller_child_controller_menu_state_type_id__volatile = 0;
	if (g_once_init_enter (&unity_launcher_scroller_child_controller_menu_state_type_id__volatile)) {
		static const GEnumValue values[] = {{UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_NO_MENU, "UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_NO_MENU", "no-menu"}, {UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_LABEL, "UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_LABEL", "label"}, {UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_MENU, "UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_MENU", "menu"}, {UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_MENU_CLOSE_WHEN_LEAVE, "UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_MENU_CLOSE_WHEN_LEAVE", "menu-close-when-leave"}, {0, NULL, NULL}};
		GType unity_launcher_scroller_child_controller_menu_state_type_id;
		unity_launcher_scroller_child_controller_menu_state_type_id = g_enum_register_static ("UnityLauncherScrollerChildControllerMenuState", values);
		g_once_init_leave (&unity_launcher_scroller_child_controller_menu_state_type_id__volatile, unity_launcher_scroller_child_controller_menu_state_type_id);
	}
	return unity_launcher_scroller_child_controller_menu_state_type_id__volatile;
}


UnityLauncherScrollerChildController* unity_launcher_scroller_child_controller_construct (GType object_type, UnityLauncherScrollerChild* child_) {
	UnityLauncherScrollerChildController * self;
	g_return_val_if_fail (child_ != NULL, NULL);
	self = (UnityLauncherScrollerChildController*) g_object_new (object_type, "child", child_, NULL);
	return self;
}


void unity_launcher_scroller_child_controller_closed (UnityLauncherScrollerChildController* self) {
	g_return_if_fail (self != NULL);
}


static void unity_launcher_scroller_child_controller_real_get_menu_actions (UnityLauncherScrollerChildController* self, UnityLauncherScrollerChildControllermenu_cb callback, void* callback_target) {
	g_return_if_fail (self != NULL);
	callback (NULL, callback_target);
}


void unity_launcher_scroller_child_controller_get_menu_actions (UnityLauncherScrollerChildController* self, UnityLauncherScrollerChildControllermenu_cb callback, void* callback_target) {
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_GET_CLASS (self)->get_menu_actions (self, callback, callback_target);
}


static void unity_launcher_scroller_child_controller_real_get_menu_navigation (UnityLauncherScrollerChildController* self, UnityLauncherScrollerChildControllermenu_cb callback, void* callback_target) {
	g_return_if_fail (self != NULL);
	callback (NULL, callback_target);
}


void unity_launcher_scroller_child_controller_get_menu_navigation (UnityLauncherScrollerChildController* self, UnityLauncherScrollerChildControllermenu_cb callback, void* callback_target) {
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_GET_CLASS (self)->get_menu_navigation (self, callback, callback_target);
}


static void unity_launcher_scroller_child_controller_real_activate (UnityLauncherScrollerChildController* self) {
	g_return_if_fail (self != NULL);
}


void unity_launcher_scroller_child_controller_activate (UnityLauncherScrollerChildController* self) {
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_GET_CLASS (self)->activate (self);
}


static UnityLauncherQuicklistController* unity_launcher_scroller_child_controller_real_get_menu_controller (UnityLauncherScrollerChildController* self) {
	UnityLauncherQuicklistController* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


UnityLauncherQuicklistController* unity_launcher_scroller_child_controller_get_menu_controller (UnityLauncherScrollerChildController* self) {
	return UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_GET_CLASS (self)->get_menu_controller (self);
}


static gboolean unity_launcher_scroller_child_controller_real_can_drag (UnityLauncherScrollerChildController* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = TRUE;
	return result;
}


gboolean unity_launcher_scroller_child_controller_can_drag (UnityLauncherScrollerChildController* self) {
	return UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_GET_CLASS (self)->can_drag (self);
}


static gboolean unity_launcher_scroller_child_controller_on_leave_event (UnityLauncherScrollerChildController* self, ClutterEvent* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	self->button_down = FALSE;
	self->menu_state = UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_NO_MENU;
	if (self->menu_state != UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_MENU) {
		unity_launcher_scroller_child_controller_ensure_menu_state (self);
	}
	result = FALSE;
	return result;
}


static gboolean unity_launcher_scroller_child_controller_on_press_event (UnityLauncherScrollerChildController* self, ClutterEvent* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	switch ((*event).button.button) {
		case 1:
		{
			{
				self->last_press_time = (*event).button.time;
				self->button_down = TRUE;
				self->priv->no_activate = FALSE;
				self->click_start_pos_x = (*event).button.x;
				self->click_start_pos_y = (*event).button.y;
			}
			break;
		}
		case 3:
		{
			{
				self->menu_state = UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_MENU;
				unity_launcher_scroller_child_controller_ensure_menu_state (self);
			}
			break;
		}
		default:
		{
			break;
		}
	}
	result = FALSE;
	return result;
}


static gboolean unity_launcher_scroller_child_controller_on_release_event (UnityLauncherScrollerChildController* self, ClutterEvent* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->_child->grabbed_push = (float) 0;
	if ((*event).button.button == 1) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		if (self->button_down == TRUE) {
			_tmp1_ = ((*event).button.time - self->last_press_time) < 500;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			_tmp0_ = self->priv->no_activate == FALSE;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			if (UNITY_LAUNCHER_IS_QUICKLIST_CONTROLLER (self->priv->_menu)) {
				gboolean _tmp2_ = FALSE;
				if (unity_launcher_quicklist_controller_get_state (self->priv->_menu) == UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_LABEL) {
					_tmp2_ = TRUE;
				} else {
					_tmp2_ = unity_launcher_quicklist_controller_get_state (self->priv->_menu) == UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_MENU;
				}
				if (_tmp2_) {
					unity_launcher_quicklist_controller_set_state (self->priv->_menu, UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_CLOSED);
				}
			}
			unity_launcher_scroller_child_controller_activate (self);
		} else {
			unity_launcher_quicklist_controller_set_state (self->priv->_menu, UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_LABEL);
			unity_launcher_scroller_child_controller_ensure_menu_state (self);
		}
	}
	self->button_down = FALSE;
	result = FALSE;
	return result;
}


static gboolean unity_launcher_scroller_child_controller_on_enter_event (UnityLauncherScrollerChildController* self, ClutterEvent* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	self->menu_state = UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_LABEL;
	unity_launcher_scroller_child_controller_ensure_menu_state (self);
	result = FALSE;
	return result;
}


static gboolean _lambda20_ (UnityLauncherScrollerChildController* self) {
	gboolean result = FALSE;
	if (unity_launcher_quicklist_controller_get_state (self->priv->_menu) != UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_MENU) {
		unity_launcher_quicklist_controller_set_state (self->priv->_menu, UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_MENU);
	}
	result = FALSE;
	return result;
}


static gboolean __lambda20__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda20_ (self);
	return result;
}


static void unity_launcher_scroller_child_controller_ensure_menu_state (UnityLauncherScrollerChildController* self) {
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	if (unity_drag_controller_get_is_dragging (unity_drag_controller_get_default ())) {
		return;
	}
	if (UNITY_LAUNCHER_IS_QUICKLIST_CONTROLLER (self->priv->_menu) == FALSE) {
		UnityLauncherQuicklistController* _tmp0_;
		unity_launcher_scroller_child_controller_set_menu (self, _tmp0_ = unity_launcher_scroller_child_controller_get_menu_controller (self));
		_g_object_unref0 (_tmp0_);
		if (UNITY_LAUNCHER_IS_QUICKLIST_CONTROLLER (self->priv->_menu) == FALSE) {
			return;
		}
	}
	if (unity_launcher_disable_quicklists) {
		unity_launcher_quicklist_controller_set_state (self->priv->_menu, UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_CLOSED);
		return;
	}
	if (unity_launcher_quicklist_controller_get_state (self->priv->_menu) == UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_MENU) {
		_tmp2_ = unity_launcher_quicklist_controller_is_menu_open ();
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = unity_launcher_quicklist_controller_do_menus_match (self->priv->_menu);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		return;
	}
	if (self->menu_state == UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_NO_MENU) {
		unity_launcher_quicklist_controller_set_state (self->priv->_menu, UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_CLOSED);
	}
	if (self->menu_state == UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_LABEL) {
		unity_launcher_quicklist_controller_set_state (self->priv->_menu, UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_LABEL);
	}
	if (self->menu_state == UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_MENU) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda20__gsource_func, g_object_ref (self), g_object_unref);
	}
}


static ClutterActor* unity_launcher_scroller_child_controller_real_get_icon (UnityDragModel* base) {
	UnityLauncherScrollerChildController * self;
	ClutterActor* result = NULL;
	self = (UnityLauncherScrollerChildController*) base;
	result = unity_launcher_scroller_child_get_content (self->priv->_child);
	return result;
}


static char* unity_launcher_scroller_child_controller_real_get_drag_data (UnityDragModel* base) {
	UnityLauncherScrollerChildController * self;
	char* result = NULL;
	self = (UnityLauncherScrollerChildController*) base;
	result = g_strdup (self->priv->_name);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean unity_launcher_scroller_child_controller_on_motion_event (UnityLauncherScrollerChildController* self, ClutterEvent* event) {
	gboolean result = FALSE;
	UnityDragController* drag_controller;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	drag_controller = _g_object_ref0 (unity_drag_controller_get_default ());
	if (!unity_launcher_disable_quicklists) {
		self->button_down = FALSE;
		result = FALSE;
		_g_object_unref0 (drag_controller);
		return result;
	}
	if (self->button_down) {
		_tmp1_ = unity_drag_controller_get_is_dragging (drag_controller) == FALSE;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = unity_launcher_scroller_child_controller_can_drag (self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		float diff;
		float diff_y;
		self->menu_state = UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_NO_MENU;
		unity_launcher_scroller_child_controller_ensure_menu_state (self);
		diff = fabsf ((*event).motion.x - self->click_start_pos_x);
		diff_y = fabsf ((*event).motion.y - self->click_start_pos_y);
		if (diff_y > 5) {
			self->priv->no_activate = TRUE;
		}
		if (((*event).motion.x - self->click_start_pos_x) > 0) {
			self->priv->_child->grabbed_push = powf (diff, 0.5f);
			clutter_actor_queue_relayout ((ClutterActor*) self->priv->_child);
		}
		if (diff > self->drag_sensitivity) {
			float x = 0.0F;
			float y = 0.0F;
			self->priv->_child->grabbed_push = (float) 0;
			clutter_actor_queue_relayout ((ClutterActor*) self->priv->_child);
			clutter_actor_get_transformed_position ((ClutterActor*) self->priv->_child, &x, &y);
			unity_drag_controller_start_drag (drag_controller, (UnityDragModel*) self, self->click_start_pos_x - x, (*event).button.y - y);
			clutter_actor_set_reactive ((ClutterActor*) self->priv->_child, TRUE);
			self->button_down = FALSE;
			result = TRUE;
			_g_object_unref0 (drag_controller);
			return result;
		}
	}
	result = FALSE;
	_g_object_unref0 (drag_controller);
	return result;
}


static const char* string_to_string (const char* self) {
	const char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void _lambda21_ (UnityThemeFilePath* theme, const char* filepath, UnityLauncherScrollerChildController* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (theme != NULL);
	g_return_if_fail (filepath != NULL);
	{
		GdkPixbuf* _tmp0_;
		GdkPixbuf* _tmp1_;
		_tmp0_ = gdk_pixbuf_new_from_file (filepath, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch50_g_error;
		}
		unity_launcher_scroller_child_set_icon (self->priv->_child, _tmp1_ = _tmp0_);
		_g_object_unref0 (_tmp1_);
	}
	goto __finally50;
	__catch50_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			char* _tmp2_;
			g_warning ("scrollerchild-controller.vala:316: %s", _tmp2_ = g_strconcat ("Could not load from ", string_to_string (filepath), NULL));
			_g_free0 (_tmp2_);
			_g_error_free0 (e);
		}
	}
	__finally50:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda21__unity_theme_file_path_found_icon_path (UnityThemeFilePath* _sender, const char* filepath, gpointer self) {
	_lambda21_ (_sender, filepath, self);
}


static void _lambda22_ (Block11Data* _data11_) {
	UnityLauncherScrollerChildController * self;
	GError * _inner_error_ = NULL;
	self = _data11_->self;
	{
		GtkIconTheme* default_theme;
		GdkPixbuf* _tmp0_;
		default_theme = _g_object_ref0 (gtk_icon_theme_get_default ());
		_tmp0_ = gtk_icon_theme_load_icon (default_theme, GTK_STOCK_MISSING_IMAGE, 48, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (default_theme);
			goto __catch51_g_error;
		}
		unity_launcher_scroller_child_set_icon (self->priv->_child, _tmp0_);
		_g_object_unref0 (default_theme);
	}
	goto __finally51;
	__catch51_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("scrollerchild-controller.vala:328: Could not load any icon for %s", _data11_->icon_name);
			_g_error_free0 (e);
		}
	}
	__finally51:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda22__unity_theme_file_path_failed (UnityThemeFilePath* _sender, gpointer self) {
	_lambda22_ (self);
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void block11_data_unref (Block11Data* _data11_) {
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		_g_object_unref0 (_data11_->self);
		_g_free0 (_data11_->icon_name);
		g_slice_free (Block11Data, _data11_);
	}
}


void unity_launcher_scroller_child_controller_load_icon_from_icon_name (UnityLauncherScrollerChildController* self, const char* icon_name) {
	Block11Data* _data11_;
	char* _tmp0_;
	gboolean _tmp1_;
	UnityThemeFilePath* _tmp2_;
	GtkIconTheme* theme;
	GtkIconTheme* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_name != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_data11_->icon_name = g_strdup (icon_name);
	if (unity_launcher_scroller_child_controller_try_load_from_file (self, _data11_->icon_name)) {
		block11_data_unref (_data11_);
		return;
	}
	if ((_tmp1_ = unity_launcher_scroller_child_controller_try_load_from_file (self, _tmp0_ = g_strconcat ("/usr/share/pixmaps/", _data11_->icon_name, NULL)), _g_free0 (_tmp0_), _tmp1_)) {
		block11_data_unref (_data11_);
		return;
	}
	self->priv->theme_file_path = (_tmp2_ = unity_theme_file_path_new (), _g_object_unref0 (self->priv->theme_file_path), _tmp2_);
	theme = _g_object_ref0 (gtk_icon_theme_get_default ());
	unity_theme_file_path_add_icon_theme (self->priv->theme_file_path, theme);
	theme = (_tmp3_ = gtk_icon_theme_new (), _g_object_unref0 (theme), _tmp3_);
	gtk_icon_theme_set_custom_theme (theme, "unity-icon-theme");
	unity_theme_file_path_add_icon_theme (self->priv->theme_file_path, theme);
	gtk_icon_theme_set_custom_theme (theme, "Web");
	unity_theme_file_path_add_icon_theme (self->priv->theme_file_path, theme);
	g_signal_connect_object (self->priv->theme_file_path, "found-icon-path", (GCallback) __lambda21__unity_theme_file_path_found_icon_path, self, 0);
	g_signal_connect_data (self->priv->theme_file_path, "failed", (GCallback) __lambda22__unity_theme_file_path_failed, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	unity_theme_file_path_get_icon_filepath (self->priv->theme_file_path, _data11_->icon_name, NULL, NULL);
	_g_object_unref0 (theme);
	block11_data_unref (_data11_);
}


static gboolean unity_launcher_scroller_child_controller_try_load_from_file (UnityLauncherScrollerChildController* self, const char* filepath) {
	gboolean result = FALSE;
	GdkPixbuf* pixbuf;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filepath != NULL, FALSE);
	pixbuf = NULL;
	if (g_file_test (filepath, G_FILE_TEST_IS_REGULAR)) {
		{
			GdkPixbuf* _tmp0_;
			GdkPixbuf* _tmp1_;
			_tmp0_ = gdk_pixbuf_new_from_file_at_scale (filepath, 48, 48, TRUE, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch52_g_error;
			}
			pixbuf = (_tmp1_ = _tmp0_, _g_object_unref0 (pixbuf), _tmp1_);
		}
		goto __finally52;
		__catch52_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("scrollerchild-controller.vala:346: Unable to load image from file '%s'" \
": %s", filepath, e->message);
				_g_error_free0 (e);
			}
		}
		__finally52:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (pixbuf);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		if (GDK_IS_PIXBUF (pixbuf)) {
			unity_launcher_scroller_child_set_icon (self->priv->_child, pixbuf);
			result = TRUE;
			_g_object_unref0 (pixbuf);
			return result;
		}
	}
	result = FALSE;
	_g_object_unref0 (pixbuf);
	return result;
}


UnityLauncherScrollerChild* unity_launcher_scroller_child_controller_get_child (UnityLauncherScrollerChildController* self) {
	UnityLauncherScrollerChild* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_child;
	return result;
}


static void unity_launcher_scroller_child_controller_set_child (UnityLauncherScrollerChildController* self, UnityLauncherScrollerChild* value) {
	UnityLauncherScrollerChild* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_child = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_child), _tmp0_);
	g_object_notify ((GObject *) self, "child");
}


const char* unity_launcher_scroller_child_controller_get_name (UnityLauncherScrollerChildController* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_name;
	return result;
}


void unity_launcher_scroller_child_controller_set_name (UnityLauncherScrollerChildController* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_name), _tmp0_);
	g_object_notify ((GObject *) self, "name");
}


gboolean unity_launcher_scroller_child_controller_get_hide (UnityLauncherScrollerChildController* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_hide;
	return result;
}


void unity_launcher_scroller_child_controller_set_hide (UnityLauncherScrollerChildController* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_hide = value;
	g_object_notify ((GObject *) self, "hide");
}


UnityLauncherQuicklistController* unity_launcher_scroller_child_controller_get_menu (UnityLauncherScrollerChildController* self) {
	UnityLauncherQuicklistController* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_menu;
	return result;
}


void unity_launcher_scroller_child_controller_set_menu (UnityLauncherScrollerChildController* self, UnityLauncherQuicklistController* value) {
	UnityLauncherQuicklistController* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_menu = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_menu), _tmp0_);
	g_object_notify ((GObject *) self, "menu");
}


static gboolean _unity_launcher_scroller_child_controller_on_press_event_clutter_actor_button_press_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = unity_launcher_scroller_child_controller_on_press_event (self, event);
	return result;
}


static gboolean _unity_launcher_scroller_child_controller_on_release_event_clutter_actor_button_release_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = unity_launcher_scroller_child_controller_on_release_event (self, event);
	return result;
}


static gboolean _unity_launcher_scroller_child_controller_on_enter_event_clutter_actor_enter_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = unity_launcher_scroller_child_controller_on_enter_event (self, event);
	return result;
}


static gboolean _unity_launcher_scroller_child_controller_on_leave_event_clutter_actor_leave_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = unity_launcher_scroller_child_controller_on_leave_event (self, event);
	return result;
}


static gboolean _unity_launcher_scroller_child_controller_on_motion_event_clutter_actor_motion_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = unity_launcher_scroller_child_controller_on_motion_event (self, event);
	return result;
}


static GObject * unity_launcher_scroller_child_controller_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityLauncherScrollerChildController * self;
	parent_class = G_OBJECT_CLASS (unity_launcher_scroller_child_controller_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER (obj);
	{
		UnityThemeFilePath* _tmp0_;
		UnityLauncherScrollerChildController* _tmp1_;
		ClutterAnimation* anim;
		self->priv->theme_file_path = (_tmp0_ = unity_theme_file_path_new (), _g_object_unref0 (self->priv->theme_file_path), _tmp0_);
		unity_launcher_scroller_child_controller_set_name (self, "Bug Found, You Defeated Unity, +20,000 exp");
		self->priv->_child->controller = (_tmp1_ = _g_object_ref0 (self), _g_object_unref0 (self->priv->_child->controller), _tmp1_);
		g_signal_connect_object ((ClutterActor*) self->priv->_child, "button-press-event", (GCallback) _unity_launcher_scroller_child_controller_on_press_event_clutter_actor_button_press_event, self, 0);
		g_signal_connect_object ((ClutterActor*) self->priv->_child, "button-release-event", (GCallback) _unity_launcher_scroller_child_controller_on_release_event_clutter_actor_button_release_event, self, 0);
		g_signal_connect_object ((ClutterActor*) self->priv->_child, "enter-event", (GCallback) _unity_launcher_scroller_child_controller_on_enter_event_clutter_actor_enter_event, self, 0);
		g_signal_connect_object ((ClutterActor*) self->priv->_child, "leave-event", (GCallback) _unity_launcher_scroller_child_controller_on_leave_event_clutter_actor_leave_event, self, 0);
		g_signal_connect_object ((ClutterActor*) self->priv->_child, "motion-event", (GCallback) _unity_launcher_scroller_child_controller_on_motion_event_clutter_actor_motion_event, self, 0);
		clutter_actor_set_opacity ((ClutterActor*) self->priv->_child, (guint8) 0);
		anim = _g_object_ref0 (clutter_actor_animate ((ClutterActor*) self->priv->_child, (gulong) CLUTTER_EASE_IN_QUAD, UNITY_LAUNCHER_SHORT_DELAY, "opacity", 0xff, NULL));
		_g_object_unref0 (anim);
	}
	return obj;
}


static void unity_launcher_scroller_child_controller_class_init (UnityLauncherScrollerChildControllerClass * klass) {
	unity_launcher_scroller_child_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityLauncherScrollerChildControllerPrivate));
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_CLASS (klass)->get_menu_actions = unity_launcher_scroller_child_controller_real_get_menu_actions;
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_CLASS (klass)->get_menu_navigation = unity_launcher_scroller_child_controller_real_get_menu_navigation;
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_CLASS (klass)->activate = unity_launcher_scroller_child_controller_real_activate;
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_CLASS (klass)->get_menu_controller = unity_launcher_scroller_child_controller_real_get_menu_controller;
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_CLASS (klass)->can_drag = unity_launcher_scroller_child_controller_real_can_drag;
	G_OBJECT_CLASS (klass)->get_property = unity_launcher_scroller_child_controller_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_launcher_scroller_child_controller_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_launcher_scroller_child_controller_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_launcher_scroller_child_controller_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_CHILD, g_param_spec_object ("child", "child", "child", UNITY_LAUNCHER_TYPE_SCROLLER_CHILD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_HIDE, g_param_spec_boolean ("hide", "hide", "hide", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU, g_param_spec_object ("menu", "menu", "menu", UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("request_removal", UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void unity_launcher_scroller_child_controller_unity_drag_model_interface_init (UnityDragModelIface * iface) {
	unity_launcher_scroller_child_controller_unity_drag_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_icon = unity_launcher_scroller_child_controller_real_get_icon;
	iface->get_drag_data = unity_launcher_scroller_child_controller_real_get_drag_data;
}


static void unity_launcher_scroller_child_controller_instance_init (UnityLauncherScrollerChildController * self) {
	self->priv = UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_GET_PRIVATE (self);
	self->last_press_time = (guint32) 0;
	self->button_down = FALSE;
	self->click_start_pos_x = 0.0f;
	self->click_start_pos_y = 0.0f;
	self->drag_sensitivity = 60;
	self->priv->no_activate = FALSE;
}


static void unity_launcher_scroller_child_controller_finalize (GObject* obj) {
	UnityLauncherScrollerChildController * self;
	self = UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER (obj);
	_g_object_unref0 (self->priv->_child);
	_g_free0 (self->priv->_name);
	_g_object_unref0 (self->priv->theme_file_path);
	_g_object_unref0 (self->priv->_menu);
	G_OBJECT_CLASS (unity_launcher_scroller_child_controller_parent_class)->finalize (obj);
}


GType unity_launcher_scroller_child_controller_get_type (void) {
	static volatile gsize unity_launcher_scroller_child_controller_type_id__volatile = 0;
	if (g_once_init_enter (&unity_launcher_scroller_child_controller_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityLauncherScrollerChildControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_launcher_scroller_child_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityLauncherScrollerChildController), 0, (GInstanceInitFunc) unity_launcher_scroller_child_controller_instance_init, NULL };
		static const GInterfaceInfo unity_drag_model_info = { (GInterfaceInitFunc) unity_launcher_scroller_child_controller_unity_drag_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType unity_launcher_scroller_child_controller_type_id;
		unity_launcher_scroller_child_controller_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityLauncherScrollerChildController", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (unity_launcher_scroller_child_controller_type_id, UNITY_DRAG_TYPE_MODEL, &unity_drag_model_info);
		g_once_init_leave (&unity_launcher_scroller_child_controller_type_id__volatile, unity_launcher_scroller_child_controller_type_id);
	}
	return unity_launcher_scroller_child_controller_type_id__volatile;
}


static void unity_launcher_scroller_child_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityLauncherScrollerChildController * self;
	self = UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER (object);
	switch (property_id) {
		case UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_CHILD:
		g_value_set_object (value, unity_launcher_scroller_child_controller_get_child (self));
		break;
		case UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_NAME:
		g_value_set_string (value, unity_launcher_scroller_child_controller_get_name (self));
		break;
		case UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_HIDE:
		g_value_set_boolean (value, unity_launcher_scroller_child_controller_get_hide (self));
		break;
		case UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU:
		g_value_set_object (value, unity_launcher_scroller_child_controller_get_menu (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_launcher_scroller_child_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityLauncherScrollerChildController * self;
	self = UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER (object);
	switch (property_id) {
		case UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_CHILD:
		unity_launcher_scroller_child_controller_set_child (self, g_value_get_object (value));
		break;
		case UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_NAME:
		unity_launcher_scroller_child_controller_set_name (self, g_value_get_string (value));
		break;
		case UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_HIDE:
		unity_launcher_scroller_child_controller_set_hide (self, g_value_get_boolean (value));
		break;
		case UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU:
		unity_launcher_scroller_child_controller_set_menu (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




