/* quicklist-controller.c generated by valac 0.10.0, the Vala compiler
 * generated from quicklist-controller.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */
/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Gordon Allott <gord.allott@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <clutk/clutk.h>
#include <unity.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <libdbusmenu-glib/client.h>
#include <libdbusmenu-glib/menuitem-proxy.h>
#include <libdbusmenu-glib/menuitem.h>
#include <libdbusmenu-glib/server.h>


#define UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER (unity_launcher_quicklist_controller_get_type ())
#define UNITY_LAUNCHER_QUICKLIST_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER, UnityLauncherQuicklistController))
#define UNITY_LAUNCHER_QUICKLIST_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER, UnityLauncherQuicklistControllerClass))
#define UNITY_LAUNCHER_IS_QUICKLIST_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER))
#define UNITY_LAUNCHER_IS_QUICKLIST_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER))
#define UNITY_LAUNCHER_QUICKLIST_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER, UnityLauncherQuicklistControllerClass))

typedef struct _UnityLauncherQuicklistController UnityLauncherQuicklistController;
typedef struct _UnityLauncherQuicklistControllerClass UnityLauncherQuicklistControllerClass;

#define UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER_STATE (unity_launcher_quicklist_controller_state_get_type ())
typedef struct _UnityLauncherQuicklistControllerPrivate UnityLauncherQuicklistControllerPrivate;

#define UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER (unity_launcher_scroller_child_controller_get_type ())
#define UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER, UnityLauncherScrollerChildController))
#define UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER, UnityLauncherScrollerChildControllerClass))
#define UNITY_LAUNCHER_IS_SCROLLER_CHILD_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER))
#define UNITY_LAUNCHER_IS_SCROLLER_CHILD_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER))
#define UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER, UnityLauncherScrollerChildControllerClass))

typedef struct _UnityLauncherScrollerChildController UnityLauncherScrollerChildController;
typedef struct _UnityLauncherScrollerChildControllerClass UnityLauncherScrollerChildControllerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define UNITY_LAUNCHER_TYPE_APPLICATION_QUICKLIST_CONTROLLER (unity_launcher_application_quicklist_controller_get_type ())
#define UNITY_LAUNCHER_APPLICATION_QUICKLIST_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_APPLICATION_QUICKLIST_CONTROLLER, UnityLauncherApplicationQuicklistController))
#define UNITY_LAUNCHER_APPLICATION_QUICKLIST_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_APPLICATION_QUICKLIST_CONTROLLER, UnityLauncherApplicationQuicklistControllerClass))
#define UNITY_LAUNCHER_IS_APPLICATION_QUICKLIST_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_APPLICATION_QUICKLIST_CONTROLLER))
#define UNITY_LAUNCHER_IS_APPLICATION_QUICKLIST_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_APPLICATION_QUICKLIST_CONTROLLER))
#define UNITY_LAUNCHER_APPLICATION_QUICKLIST_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_APPLICATION_QUICKLIST_CONTROLLER, UnityLauncherApplicationQuicklistControllerClass))

typedef struct _UnityLauncherApplicationQuicklistController UnityLauncherApplicationQuicklistController;
typedef struct _UnityLauncherApplicationQuicklistControllerClass UnityLauncherApplicationQuicklistControllerClass;
typedef struct _UnityLauncherApplicationQuicklistControllerPrivate UnityLauncherApplicationQuicklistControllerPrivate;

#define UNITY_LAUNCHER_TYPE_QUICKLIST_MENU (unity_launcher_quicklist_menu_get_type ())
#define UNITY_LAUNCHER_QUICKLIST_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_MENU, UnityLauncherQuicklistMenu))
#define UNITY_LAUNCHER_QUICKLIST_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_QUICKLIST_MENU, UnityLauncherQuicklistMenuClass))
#define UNITY_LAUNCHER_IS_QUICKLIST_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_MENU))
#define UNITY_LAUNCHER_IS_QUICKLIST_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_QUICKLIST_MENU))
#define UNITY_LAUNCHER_QUICKLIST_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_MENU, UnityLauncherQuicklistMenuClass))

typedef struct _UnityLauncherQuicklistMenu UnityLauncherQuicklistMenu;
typedef struct _UnityLauncherQuicklistMenuClass UnityLauncherQuicklistMenuClass;

#define UNITY_LAUNCHER_TYPE_SCROLLER_CHILD (unity_launcher_scroller_child_get_type ())
#define UNITY_LAUNCHER_SCROLLER_CHILD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD, UnityLauncherScrollerChild))
#define UNITY_LAUNCHER_SCROLLER_CHILD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD, UnityLauncherScrollerChildClass))
#define UNITY_LAUNCHER_IS_SCROLLER_CHILD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD))
#define UNITY_LAUNCHER_IS_SCROLLER_CHILD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD))
#define UNITY_LAUNCHER_SCROLLER_CHILD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD, UnityLauncherScrollerChildClass))

typedef struct _UnityLauncherScrollerChild UnityLauncherScrollerChild;
typedef struct _UnityLauncherScrollerChildClass UnityLauncherScrollerChildClass;

#define UNITY_LAUNCHER_TYPE_QUICKLIST_MENU_ITEM (unity_launcher_quicklist_menu_item_get_type ())
#define UNITY_LAUNCHER_QUICKLIST_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_MENU_ITEM, UnityLauncherQuicklistMenuItem))
#define UNITY_LAUNCHER_QUICKLIST_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_QUICKLIST_MENU_ITEM, UnityLauncherQuicklistMenuItemClass))
#define UNITY_LAUNCHER_IS_QUICKLIST_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_MENU_ITEM))
#define UNITY_LAUNCHER_IS_QUICKLIST_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_QUICKLIST_MENU_ITEM))
#define UNITY_LAUNCHER_QUICKLIST_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_MENU_ITEM, UnityLauncherQuicklistMenuItemClass))

typedef struct _UnityLauncherQuicklistMenuItem UnityLauncherQuicklistMenuItem;
typedef struct _UnityLauncherQuicklistMenuItemClass UnityLauncherQuicklistMenuItemClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define UNITY_LAUNCHER_TYPE_QUICKLIST_MENU_SEPERATOR (unity_launcher_quicklist_menu_seperator_get_type ())
#define UNITY_LAUNCHER_QUICKLIST_MENU_SEPERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_MENU_SEPERATOR, UnityLauncherQuicklistMenuSeperator))
#define UNITY_LAUNCHER_QUICKLIST_MENU_SEPERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_QUICKLIST_MENU_SEPERATOR, UnityLauncherQuicklistMenuSeperatorClass))
#define UNITY_LAUNCHER_IS_QUICKLIST_MENU_SEPERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_MENU_SEPERATOR))
#define UNITY_LAUNCHER_IS_QUICKLIST_MENU_SEPERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_QUICKLIST_MENU_SEPERATOR))
#define UNITY_LAUNCHER_QUICKLIST_MENU_SEPERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_MENU_SEPERATOR, UnityLauncherQuicklistMenuSeperatorClass))

typedef struct _UnityLauncherQuicklistMenuSeperator UnityLauncherQuicklistMenuSeperator;
typedef struct _UnityLauncherQuicklistMenuSeperatorClass UnityLauncherQuicklistMenuSeperatorClass;

#define UNITY_LAUNCHER_TYPE_QUICKLIST_CHECK_MENU_ITEM (unity_launcher_quicklist_check_menu_item_get_type ())
#define UNITY_LAUNCHER_QUICKLIST_CHECK_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_CHECK_MENU_ITEM, UnityLauncherQuicklistCheckMenuItem))
#define UNITY_LAUNCHER_QUICKLIST_CHECK_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_QUICKLIST_CHECK_MENU_ITEM, UnityLauncherQuicklistCheckMenuItemClass))
#define UNITY_LAUNCHER_IS_QUICKLIST_CHECK_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_CHECK_MENU_ITEM))
#define UNITY_LAUNCHER_IS_QUICKLIST_CHECK_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_QUICKLIST_CHECK_MENU_ITEM))
#define UNITY_LAUNCHER_QUICKLIST_CHECK_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_CHECK_MENU_ITEM, UnityLauncherQuicklistCheckMenuItemClass))

typedef struct _UnityLauncherQuicklistCheckMenuItem UnityLauncherQuicklistCheckMenuItem;
typedef struct _UnityLauncherQuicklistCheckMenuItemClass UnityLauncherQuicklistCheckMenuItemClass;

#define UNITY_LAUNCHER_TYPE_QUICKLIST_RADIO_MENU_ITEM (unity_launcher_quicklist_radio_menu_item_get_type ())
#define UNITY_LAUNCHER_QUICKLIST_RADIO_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_RADIO_MENU_ITEM, UnityLauncherQuicklistRadioMenuItem))
#define UNITY_LAUNCHER_QUICKLIST_RADIO_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_QUICKLIST_RADIO_MENU_ITEM, UnityLauncherQuicklistRadioMenuItemClass))
#define UNITY_LAUNCHER_IS_QUICKLIST_RADIO_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_RADIO_MENU_ITEM))
#define UNITY_LAUNCHER_IS_QUICKLIST_RADIO_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_QUICKLIST_RADIO_MENU_ITEM))
#define UNITY_LAUNCHER_QUICKLIST_RADIO_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_RADIO_MENU_ITEM, UnityLauncherQuicklistRadioMenuItemClass))

typedef struct _UnityLauncherQuicklistRadioMenuItem UnityLauncherQuicklistRadioMenuItem;
typedef struct _UnityLauncherQuicklistRadioMenuItemClass UnityLauncherQuicklistRadioMenuItemClass;
typedef struct _Block10Data Block10Data;

#define UNITY_TESTING_TYPE_OBJECT_REGISTRY (unity_testing_object_registry_get_type ())
#define UNITY_TESTING_OBJECT_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TESTING_TYPE_OBJECT_REGISTRY, UnityTestingObjectRegistry))
#define UNITY_TESTING_OBJECT_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TESTING_TYPE_OBJECT_REGISTRY, UnityTestingObjectRegistryClass))
#define UNITY_TESTING_IS_OBJECT_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TESTING_TYPE_OBJECT_REGISTRY))
#define UNITY_TESTING_IS_OBJECT_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TESTING_TYPE_OBJECT_REGISTRY))
#define UNITY_TESTING_OBJECT_REGISTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TESTING_TYPE_OBJECT_REGISTRY, UnityTestingObjectRegistryClass))

typedef struct _UnityTestingObjectRegistry UnityTestingObjectRegistry;
typedef struct _UnityTestingObjectRegistryClass UnityTestingObjectRegistryClass;
#define _unity_testing_object_registry_unref0(var) ((var == NULL) ? NULL : (var = (unity_testing_object_registry_unref (var), NULL)))

typedef enum  {
	UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_LABEL,
	UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_MENU,
	UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_CLOSED
} UnityLauncherQuicklistControllerState;

struct _UnityLauncherQuicklistController {
	GObject parent_instance;
	UnityLauncherQuicklistControllerPrivate * priv;
	CtkMenuExpandable* menu;
};

struct _UnityLauncherQuicklistControllerClass {
	GObjectClass parent_class;
};

struct _UnityLauncherQuicklistControllerPrivate {
	UnityLauncherScrollerChildController* _attached_controller;
	UnityLauncherQuicklistControllerState _state;
};

struct _UnityLauncherApplicationQuicklistController {
	UnityLauncherQuicklistController parent_instance;
	UnityLauncherApplicationQuicklistControllerPrivate * priv;
};

struct _UnityLauncherApplicationQuicklistControllerClass {
	UnityLauncherQuicklistControllerClass parent_class;
};

typedef void (*UnityLauncherScrollerChildControllermenu_cb) (DbusmenuMenuitem* menu, void* user_data);
struct _Block10Data {
	int _ref_count_;
	UnityLauncherApplicationQuicklistController * self;
	CtkMenuItem* menuitem;
	DbusmenuMenuitem* dbusmenuitem;
};


extern UnityLauncherQuicklistController* unity_launcher_ql_controller_singleton;
UnityLauncherQuicklistController* unity_launcher_ql_controller_singleton = NULL;
extern gboolean unity_launcher_disable_quicklists;
gboolean unity_launcher_disable_quicklists = FALSE;
static gpointer unity_launcher_quicklist_controller_parent_class = NULL;
static gpointer unity_launcher_application_quicklist_controller_parent_class = NULL;

GType unity_launcher_quicklist_controller_get_type (void) G_GNUC_CONST;
GType unity_launcher_quicklist_controller_state_get_type (void) G_GNUC_CONST;
GType unity_launcher_scroller_child_controller_get_type (void) G_GNUC_CONST;
#define UNITY_LAUNCHER_QUICKLIST_CONTROLLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER, UnityLauncherQuicklistControllerPrivate))
enum  {
	UNITY_LAUNCHER_QUICKLIST_CONTROLLER_DUMMY_PROPERTY,
	UNITY_LAUNCHER_QUICKLIST_CONTROLLER_ATTACHED_CONTROLLER,
	UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE
};
UnityLauncherQuicklistController* unity_launcher_quicklist_controller_get_current_menu (void);
gboolean unity_launcher_quicklist_controller_is_menu_open (void);
UnityLauncherQuicklistControllerState unity_launcher_quicklist_controller_get_state (UnityLauncherQuicklistController* self);
gboolean unity_launcher_quicklist_controller_do_menus_match (UnityLauncherQuicklistController* menu);
CtkMenuExpandable* unity_launcher_quicklist_controller_get_view (UnityLauncherQuicklistController* self);
UnityLauncherQuicklistController* unity_launcher_quicklist_controller_construct (GType object_type);
UnityLauncherScrollerChildController* unity_launcher_quicklist_controller_get_attached_controller (UnityLauncherQuicklistController* self);
static void unity_launcher_quicklist_controller_set_attached_controller (UnityLauncherQuicklistController* self, UnityLauncherScrollerChildController* value);
void unity_launcher_quicklist_controller_set_state (UnityLauncherQuicklistController* self, UnityLauncherQuicklistControllerState value);
static void unity_launcher_quicklist_controller_finalize (GObject* obj);
static void unity_launcher_quicklist_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_launcher_quicklist_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType unity_launcher_application_quicklist_controller_get_type (void) G_GNUC_CONST;
enum  {
	UNITY_LAUNCHER_APPLICATION_QUICKLIST_CONTROLLER_DUMMY_PROPERTY
};
UnityLauncherApplicationQuicklistController* unity_launcher_application_quicklist_controller_new (UnityLauncherScrollerChildController* scroller_child);
UnityLauncherApplicationQuicklistController* unity_launcher_application_quicklist_controller_construct (GType object_type, UnityLauncherScrollerChildController* scroller_child);
static void unity_launcher_application_quicklist_controller_new_menu (UnityLauncherApplicationQuicklistController* self);
UnityLauncherQuicklistMenu* unity_launcher_quicklist_menu_new (void);
UnityLauncherQuicklistMenu* unity_launcher_quicklist_menu_construct (GType object_type);
GType unity_launcher_quicklist_menu_get_type (void) G_GNUC_CONST;
static void _lambda23_ (UnityLauncherApplicationQuicklistController* self);
static void __lambda23__clutter_actor_destroy (ClutterActor* _sender, gpointer self);
static void _lambda24_ (UnityLauncherApplicationQuicklistController* self);
static void __lambda24__clutter_actor_destroy (ClutterActor* _sender, gpointer self);
GType unity_launcher_scroller_child_get_type (void) G_GNUC_CONST;
UnityLauncherScrollerChild* unity_launcher_scroller_child_controller_get_child (UnityLauncherScrollerChildController* self);
static void unity_launcher_application_quicklist_controller_attach_to_stage (UnityLauncherApplicationQuicklistController* self, ClutterActor* child, ClutterActor* parent);
static void _unity_launcher_application_quicklist_controller_attach_to_stage_clutter_actor_parent_set (ClutterActor* _sender, ClutterActor* old_parent, gpointer self);
static void unity_launcher_application_quicklist_controller_on_state_change (UnityLauncherApplicationQuicklistController* self);
const char* unity_launcher_scroller_child_controller_get_name (UnityLauncherScrollerChildController* self);
UnityLauncherQuicklistMenuItem* unity_launcher_quicklist_menu_item_new_with_label (const char* label);
UnityLauncherQuicklistMenuItem* unity_launcher_quicklist_menu_item_construct_with_label (GType object_type, const char* label);
GType unity_launcher_quicklist_menu_item_get_type (void) G_GNUC_CONST;
static void _lambda25_ (UnityLauncherApplicationQuicklistController* self);
static void __lambda25__ctk_menu_item_activated (CtkMenuItem* _sender, gpointer self);
void unity_launcher_scroller_child_controller_get_menu_actions (UnityLauncherScrollerChildController* self, UnityLauncherScrollerChildControllermenu_cb callback, void* callback_target);
static void _lambda26_ (DbusmenuMenuitem* top_menu, UnityLauncherApplicationQuicklistController* self);
UnityLauncherQuicklistMenuSeperator* unity_launcher_quicklist_menu_seperator_new (void);
UnityLauncherQuicklistMenuSeperator* unity_launcher_quicklist_menu_seperator_construct (GType object_type);
GType unity_launcher_quicklist_menu_seperator_get_type (void) G_GNUC_CONST;
static CtkMenuItem* unity_launcher_application_quicklist_controller_menu_item_from_dbusmenuitem (UnityLauncherApplicationQuicklistController* self, DbusmenuMenuitem* dbusmenuitem);
static void __lambda26__unitylauncherscrollerchildcontrollermenu_cb (DbusmenuMenuitem* menu, gpointer self);
void unity_launcher_scroller_child_controller_get_menu_navigation (UnityLauncherScrollerChildController* self, UnityLauncherScrollerChildControllermenu_cb callback, void* callback_target);
static void _lambda33_ (DbusmenuMenuitem* bottom_menu, UnityLauncherApplicationQuicklistController* self);
static void __lambda33__unitylauncherscrollerchildcontrollermenu_cb (DbusmenuMenuitem* menu, gpointer self);
UnityLauncherQuicklistCheckMenuItem* unity_launcher_quicklist_check_menu_item_new_with_label (const char* label);
UnityLauncherQuicklistCheckMenuItem* unity_launcher_quicklist_check_menu_item_construct_with_label (GType object_type, const char* label);
GType unity_launcher_quicklist_check_menu_item_get_type (void) G_GNUC_CONST;
UnityLauncherQuicklistRadioMenuItem* unity_launcher_quicklist_radio_menu_item_new_with_label (GSList* group, const char* label);
UnityLauncherQuicklistRadioMenuItem* unity_launcher_quicklist_radio_menu_item_construct_with_label (GType object_type, GSList* group, const char* label);
GType unity_launcher_quicklist_radio_menu_item_get_type (void) G_GNUC_CONST;
static void _lambda27_ (Block10Data* _data10_);
static void __lambda27__ctk_check_menu_item_toggled (CtkCheckMenuItem* _sender, gpointer self);
static void _lambda28_ (const char* property_name, void* value, Block10Data* _data10_);
static void __lambda28__dbusmenu_menuitem_property_changed (DbusmenuMenuitem* _sender, const char* property_name, void* value, gpointer self);
static void _lambda29_ (const char* property_name, void* value, Block10Data* _data10_);
static void __lambda29__dbusmenu_menuitem_property_changed (DbusmenuMenuitem* _sender, const char* property_name, void* value, gpointer self);
static void _lambda30_ (Block10Data* _data10_);
static void __lambda30__ctk_menu_item_activated (CtkMenuItem* _sender, gpointer self);
static void _lambda31_ (UnityLauncherApplicationQuicklistController* self);
static gboolean _lambda32_ (UnityLauncherApplicationQuicklistController* self);
static gboolean __lambda32__gsource_func (gpointer self);
static void __lambda31__ctk_menu_item_activated (CtkMenuItem* _sender, gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (Block10Data* _data10_);
gpointer unity_testing_object_registry_ref (gpointer instance);
void unity_testing_object_registry_unref (gpointer instance);
GParamSpec* unity_testing_param_spec_object_registry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void unity_testing_value_set_object_registry (GValue* value, gpointer v_object);
void unity_testing_value_take_object_registry (GValue* value, gpointer v_object);
gpointer unity_testing_value_get_object_registry (const GValue* value);
GType unity_testing_object_registry_get_type (void) G_GNUC_CONST;
UnityTestingObjectRegistry* unity_testing_object_registry_get_default (void);
void unity_testing_object_registry_register (UnityTestingObjectRegistry* self, const char* name, GObject* object);
static void _unity_launcher_application_quicklist_controller_on_state_change_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda34_ (UnityLauncherApplicationQuicklistController* self);
static void __lambda34__unity_drag_controller_drag_start (UnityDragController* _sender, UnityDragModel* model, gpointer self);
static GObject * unity_launcher_application_quicklist_controller_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static int _vala_strcmp0 (const char * str1, const char * str2);



GType unity_launcher_quicklist_controller_state_get_type (void) {
	static volatile gsize unity_launcher_quicklist_controller_state_type_id__volatile = 0;
	if (g_once_init_enter (&unity_launcher_quicklist_controller_state_type_id__volatile)) {
		static const GEnumValue values[] = {{UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_LABEL, "UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_LABEL", "label"}, {UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_MENU, "UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_MENU", "menu"}, {UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_CLOSED, "UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_CLOSED", "closed"}, {0, NULL, NULL}};
		GType unity_launcher_quicklist_controller_state_type_id;
		unity_launcher_quicklist_controller_state_type_id = g_enum_register_static ("UnityLauncherQuicklistControllerState", values);
		g_once_init_leave (&unity_launcher_quicklist_controller_state_type_id__volatile, unity_launcher_quicklist_controller_state_type_id);
	}
	return unity_launcher_quicklist_controller_state_type_id__volatile;
}


UnityLauncherQuicklistController* unity_launcher_quicklist_controller_get_current_menu (void) {
	UnityLauncherQuicklistController* result = NULL;
	result = unity_launcher_ql_controller_singleton;
	return result;
}


gboolean unity_launcher_quicklist_controller_is_menu_open (void) {
	gboolean result = FALSE;
	if (UNITY_LAUNCHER_IS_QUICKLIST_CONTROLLER (unity_launcher_ql_controller_singleton)) {
		result = unity_launcher_quicklist_controller_get_state (unity_launcher_ql_controller_singleton) == UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_MENU;
		return result;
	}
	result = FALSE;
	return result;
}


gboolean unity_launcher_quicklist_controller_do_menus_match (UnityLauncherQuicklistController* menu) {
	gboolean result = FALSE;
	g_return_val_if_fail (menu != NULL, FALSE);
	result = menu == unity_launcher_ql_controller_singleton;
	return result;
}


CtkMenuExpandable* unity_launcher_quicklist_controller_get_view (UnityLauncherQuicklistController* self) {
	CtkMenuExpandable* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->menu;
	return result;
}


UnityLauncherQuicklistController* unity_launcher_quicklist_controller_construct (GType object_type) {
	UnityLauncherQuicklistController * self;
	self = (UnityLauncherQuicklistController*) g_object_new (object_type, NULL);
	return self;
}


UnityLauncherScrollerChildController* unity_launcher_quicklist_controller_get_attached_controller (UnityLauncherQuicklistController* self) {
	UnityLauncherScrollerChildController* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_attached_controller;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void unity_launcher_quicklist_controller_set_attached_controller (UnityLauncherQuicklistController* self, UnityLauncherScrollerChildController* value) {
	UnityLauncherScrollerChildController* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_attached_controller = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_attached_controller), _tmp0_);
	g_object_notify ((GObject *) self, "attached-controller");
}


UnityLauncherQuicklistControllerState unity_launcher_quicklist_controller_get_state (UnityLauncherQuicklistController* self) {
	UnityLauncherQuicklistControllerState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}


void unity_launcher_quicklist_controller_set_state (UnityLauncherQuicklistController* self, UnityLauncherQuicklistControllerState value) {
	UnityDragController* drag_controller;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	drag_controller = _g_object_ref0 (unity_drag_controller_get_default ());
	if (unity_drag_controller_get_is_dragging (drag_controller)) {
		value = UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_CLOSED;
	}
	if (value == UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_LABEL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = value == UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_MENU;
	}
	if (_tmp0_) {
		gboolean _tmp1_ = FALSE;
		UnityLauncherQuicklistController* _tmp2_;
		if (unity_launcher_ql_controller_singleton != self) {
			_tmp1_ = unity_launcher_ql_controller_singleton != NULL;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			UnityLauncherQuicklistController* tmp_qlc;
			tmp_qlc = _g_object_ref0 (unity_launcher_ql_controller_singleton);
			unity_launcher_quicklist_controller_set_state (tmp_qlc, UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_CLOSED);
			if (unity_launcher_quicklist_controller_get_view (tmp_qlc) != NULL) {
				g_warning ("quicklist-controller.vala:52: old menu not destroyed when opening new " \
"menu");
			}
			_g_object_unref0 (tmp_qlc);
		}
		unity_launcher_ql_controller_singleton = (_tmp2_ = _g_object_ref0 (self), _g_object_unref0 (unity_launcher_ql_controller_singleton), _tmp2_);
	}
	if (value == UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_CLOSED) {
		UnityLauncherQuicklistController* _tmp4_;
		if (CTK_IS_MENU_EXPANDABLE (self->menu)) {
			CtkMenuExpandable* _tmp3_;
			clutter_actor_destroy ((ClutterActor*) self->menu);
			self->menu = (_tmp3_ = NULL, _g_object_unref0 (self->menu), _tmp3_);
		}
		unity_launcher_ql_controller_singleton = (_tmp4_ = NULL, _g_object_unref0 (unity_launcher_ql_controller_singleton), _tmp4_);
	}
	self->priv->_state = value;
	_g_object_unref0 (drag_controller);
	g_object_notify ((GObject *) self, "state");
}


static void unity_launcher_quicklist_controller_class_init (UnityLauncherQuicklistControllerClass * klass) {
	unity_launcher_quicklist_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityLauncherQuicklistControllerPrivate));
	G_OBJECT_CLASS (klass)->get_property = unity_launcher_quicklist_controller_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_launcher_quicklist_controller_set_property;
	G_OBJECT_CLASS (klass)->finalize = unity_launcher_quicklist_controller_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_QUICKLIST_CONTROLLER_ATTACHED_CONTROLLER, g_param_spec_object ("attached-controller", "attached-controller", "attached-controller", UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE, g_param_spec_enum ("state", "state", "state", UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER_STATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void unity_launcher_quicklist_controller_instance_init (UnityLauncherQuicklistController * self) {
	self->priv = UNITY_LAUNCHER_QUICKLIST_CONTROLLER_GET_PRIVATE (self);
}


static void unity_launcher_quicklist_controller_finalize (GObject* obj) {
	UnityLauncherQuicklistController * self;
	self = UNITY_LAUNCHER_QUICKLIST_CONTROLLER (obj);
	_g_object_unref0 (self->menu);
	_g_object_unref0 (self->priv->_attached_controller);
	G_OBJECT_CLASS (unity_launcher_quicklist_controller_parent_class)->finalize (obj);
}


GType unity_launcher_quicklist_controller_get_type (void) {
	static volatile gsize unity_launcher_quicklist_controller_type_id__volatile = 0;
	if (g_once_init_enter (&unity_launcher_quicklist_controller_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityLauncherQuicklistControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_launcher_quicklist_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityLauncherQuicklistController), 0, (GInstanceInitFunc) unity_launcher_quicklist_controller_instance_init, NULL };
		GType unity_launcher_quicklist_controller_type_id;
		unity_launcher_quicklist_controller_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityLauncherQuicklistController", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&unity_launcher_quicklist_controller_type_id__volatile, unity_launcher_quicklist_controller_type_id);
	}
	return unity_launcher_quicklist_controller_type_id__volatile;
}


static void unity_launcher_quicklist_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityLauncherQuicklistController * self;
	self = UNITY_LAUNCHER_QUICKLIST_CONTROLLER (object);
	switch (property_id) {
		case UNITY_LAUNCHER_QUICKLIST_CONTROLLER_ATTACHED_CONTROLLER:
		g_value_set_object (value, unity_launcher_quicklist_controller_get_attached_controller (self));
		break;
		case UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE:
		g_value_set_enum (value, unity_launcher_quicklist_controller_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_launcher_quicklist_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityLauncherQuicklistController * self;
	self = UNITY_LAUNCHER_QUICKLIST_CONTROLLER (object);
	switch (property_id) {
		case UNITY_LAUNCHER_QUICKLIST_CONTROLLER_ATTACHED_CONTROLLER:
		unity_launcher_quicklist_controller_set_attached_controller (self, g_value_get_object (value));
		break;
		case UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE:
		unity_launcher_quicklist_controller_set_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


UnityLauncherApplicationQuicklistController* unity_launcher_application_quicklist_controller_construct (GType object_type, UnityLauncherScrollerChildController* scroller_child) {
	UnityLauncherApplicationQuicklistController * self;
	g_return_val_if_fail (scroller_child != NULL, NULL);
	self = (UnityLauncherApplicationQuicklistController*) g_object_new (object_type, "attached-controller", scroller_child, NULL);
	return self;
}


UnityLauncherApplicationQuicklistController* unity_launcher_application_quicklist_controller_new (UnityLauncherScrollerChildController* scroller_child) {
	return unity_launcher_application_quicklist_controller_construct (UNITY_LAUNCHER_TYPE_APPLICATION_QUICKLIST_CONTROLLER, scroller_child);
}


static void _lambda23_ (UnityLauncherApplicationQuicklistController* self) {
	unity_launcher_quicklist_controller_set_state ((UnityLauncherQuicklistController*) self, UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_CLOSED);
}


static void __lambda23__clutter_actor_destroy (ClutterActor* _sender, gpointer self) {
	_lambda23_ (self);
}


static void _lambda24_ (UnityLauncherApplicationQuicklistController* self) {
	unity_shell_remove_fullscreen_request (unity_global_shell, (GObject*) self);
}


static void __lambda24__clutter_actor_destroy (ClutterActor* _sender, gpointer self) {
	_lambda24_ (self);
}


static void unity_launcher_application_quicklist_controller_new_menu (UnityLauncherApplicationQuicklistController* self) {
	UnityLauncherQuicklistMenu* _tmp0_;
	CtkMenuExpandable* _tmp1_;
	UnityLauncherScrollerChild* _tmp2_;
	g_return_if_fail (self != NULL);
	((UnityLauncherQuicklistController*) self)->menu = (_tmp1_ = (_tmp0_ = g_object_ref_sink (unity_launcher_quicklist_menu_new ()), CTK_IS_MENU_EXPANDABLE (_tmp0_) ? ((CtkMenuExpandable*) _tmp0_) : NULL), _g_object_unref0 (((UnityLauncherQuicklistController*) self)->menu), _tmp1_);
	g_signal_connect_object ((ClutterActor*) ((UnityLauncherQuicklistController*) self)->menu, "destroy", (GCallback) __lambda23__clutter_actor_destroy, self, 0);
	if (UNITY_IS_SHELL (unity_global_shell)) {
		g_signal_connect_object ((ClutterActor*) ((UnityLauncherQuicklistController*) self)->menu, "destroy", (GCallback) __lambda24__clutter_actor_destroy, self, 0);
		ctk_menu_set_swallow_clicks ((CtkMenu*) ((UnityLauncherQuicklistController*) self)->menu, unity_shell_get_menus_swallow_events (unity_global_shell));
	}
	ctk_menu_set_detect_clicks ((CtkMenu*) ((UnityLauncherQuicklistController*) self)->menu, FALSE);
	ctk_menu_attach_to_actor ((CtkMenu*) ((UnityLauncherQuicklistController*) self)->menu, (_tmp2_ = unity_launcher_scroller_child_controller_get_child (unity_launcher_quicklist_controller_get_attached_controller ((UnityLauncherQuicklistController*) self)), CTK_IS_ACTOR (_tmp2_) ? ((CtkActor*) _tmp2_) : NULL));
	unity_launcher_application_quicklist_controller_attach_to_stage (self, (ClutterActor*) unity_launcher_scroller_child_controller_get_child (unity_launcher_quicklist_controller_get_attached_controller ((UnityLauncherQuicklistController*) self)), (ClutterActor*) unity_launcher_scroller_child_controller_get_child (unity_launcher_quicklist_controller_get_attached_controller ((UnityLauncherQuicklistController*) self)));
	ctk_menu_expandable_set_anchor_position (((UnityLauncherQuicklistController*) self)->menu, (float) 0, (float) 0, 0);
}


static void _unity_launcher_application_quicklist_controller_attach_to_stage_clutter_actor_parent_set (ClutterActor* _sender, ClutterActor* old_parent, gpointer self) {
	unity_launcher_application_quicklist_controller_attach_to_stage (self, _sender, old_parent);
}


static void unity_launcher_application_quicklist_controller_attach_to_stage (UnityLauncherApplicationQuicklistController* self, ClutterActor* child, ClutterActor* parent) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	g_return_if_fail (parent != NULL);
	g_signal_parse_name ("parent-set", CLUTTER_TYPE_ACTOR, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (child, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _unity_launcher_application_quicklist_controller_attach_to_stage_clutter_actor_parent_set, self);
	if (CLUTTER_IS_STAGE (clutter_actor_get_stage (child))) {
		ClutterActor* _tmp1_;
		ClutterActor* _tmp2_;
		clutter_container_add_actor ((ClutterContainer*) (_tmp1_ = clutter_actor_get_stage (child), CLUTTER_IS_STAGE (_tmp1_) ? ((ClutterStage*) _tmp1_) : NULL), (ClutterActor*) ((UnityLauncherQuicklistController*) self)->menu);
		clutter_container_raise_child ((ClutterContainer*) (_tmp2_ = clutter_actor_get_stage (child), CLUTTER_IS_STAGE (_tmp2_) ? ((ClutterStage*) _tmp2_) : NULL), (ClutterActor*) ((UnityLauncherQuicklistController*) self)->menu, NULL);
	} else {
		g_signal_connect_object (child, "parent-set", (GCallback) _unity_launcher_application_quicklist_controller_attach_to_stage_clutter_actor_parent_set, self, 0);
	}
}


static void _lambda25_ (UnityLauncherApplicationQuicklistController* self) {
	unity_launcher_quicklist_controller_set_state ((UnityLauncherQuicklistController*) self, UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_CLOSED);
}


static void __lambda25__ctk_menu_item_activated (CtkMenuItem* _sender, gpointer self) {
	_lambda25_ (self);
}


static void _lambda26_ (DbusmenuMenuitem* top_menu, UnityLauncherApplicationQuicklistController* self) {
	if (DBUSMENU_IS_MENUITEM (top_menu)) {
		if (dbusmenu_menuitem_get_root (top_menu)) {
			GList* menu_items;
			menu_items = dbusmenu_menuitem_get_children (top_menu);
			if (menu_items != NULL) {
				UnityLauncherQuicklistMenuSeperator* separator;
				separator = g_object_ref_sink (unity_launcher_quicklist_menu_seperator_new ());
				ctk_menu_prepend ((CtkMenu*) unity_launcher_quicklist_controller_get_view ((UnityLauncherQuicklistController*) self), (ClutterActor*) separator, FALSE);
				_g_object_unref0 (separator);
			}
			menu_items = g_list_reverse (menu_items);
			{
				GList* menuitem_collection;
				GList* menuitem_it;
				menuitem_collection = menu_items;
				for (menuitem_it = menuitem_collection; menuitem_it != NULL; menuitem_it = menuitem_it->next) {
					DbusmenuMenuitem* menuitem;
					menuitem = _g_object_ref0 ((DbusmenuMenuitem*) menuitem_it->data);
					{
						CtkMenuItem* view_menuitem;
						view_menuitem = unity_launcher_application_quicklist_controller_menu_item_from_dbusmenuitem (self, menuitem);
						if (view_menuitem != NULL) {
							ctk_menu_prepend ((CtkMenu*) unity_launcher_quicklist_controller_get_view ((UnityLauncherQuicklistController*) self), (ClutterActor*) view_menuitem, FALSE);
							g_object_unref ((GObject*) view_menuitem);
						}
						_g_object_unref0 (view_menuitem);
						_g_object_unref0 (menuitem);
					}
				}
			}
			menu_items = g_list_reverse (menu_items);
		} else {
			g_warning ("quicklist-controller.vala:243: menu given not a root item");
		}
	}
}


static void __lambda26__unitylauncherscrollerchildcontrollermenu_cb (DbusmenuMenuitem* menu, gpointer self) {
	_lambda26_ (menu, self);
}


static void _lambda33_ (DbusmenuMenuitem* bottom_menu, UnityLauncherApplicationQuicklistController* self) {
	float x = 0.0F;
	float y = 0.0F;
	float w = 0.0F;
	float h = 0.0F;
	UnityLauncherScrollerChild* _tmp0_;
	UnityLauncherScrollerChild* _tmp1_;
	UnityLauncherScrollerChild* _tmp2_;
	if (DBUSMENU_IS_MENUITEM (bottom_menu)) {
		if (dbusmenu_menuitem_get_root (bottom_menu)) {
			UnityLauncherQuicklistMenuSeperator* separator;
			GList* menu_items;
			separator = g_object_ref_sink (unity_launcher_quicklist_menu_seperator_new ());
			ctk_menu_append ((CtkMenu*) unity_launcher_quicklist_controller_get_view ((UnityLauncherQuicklistController*) self), (ClutterActor*) separator, FALSE);
			menu_items = dbusmenu_menuitem_get_children (bottom_menu);
			{
				GList* menuitem_collection;
				GList* menuitem_it;
				menuitem_collection = menu_items;
				for (menuitem_it = menuitem_collection; menuitem_it != NULL; menuitem_it = menuitem_it->next) {
					DbusmenuMenuitem* menuitem;
					menuitem = _g_object_ref0 ((DbusmenuMenuitem*) menuitem_it->data);
					{
						CtkMenuItem* view_menuitem;
						view_menuitem = unity_launcher_application_quicklist_controller_menu_item_from_dbusmenuitem (self, menuitem);
						if (view_menuitem != NULL) {
							ctk_menu_append ((CtkMenu*) unity_launcher_quicklist_controller_get_view ((UnityLauncherQuicklistController*) self), (ClutterActor*) view_menuitem, FALSE);
							g_object_unref ((GObject*) view_menuitem);
						}
						_g_object_unref0 (view_menuitem);
						_g_object_unref0 (menuitem);
					}
				}
			}
			_g_object_unref0 (separator);
		} else {
			g_warning ("quicklist-controller.vala:272: menu given not a root item");
		}
	}
	clutter_actor_get_transformed_position ((ClutterActor*) (_tmp0_ = unity_launcher_scroller_child_controller_get_child (unity_launcher_quicklist_controller_get_attached_controller ((UnityLauncherQuicklistController*) self)), CTK_IS_ACTOR (_tmp0_) ? ((CtkActor*) _tmp0_) : NULL), &x, &y);
	w = clutter_actor_get_width ((ClutterActor*) (_tmp1_ = unity_launcher_scroller_child_controller_get_child (unity_launcher_quicklist_controller_get_attached_controller ((UnityLauncherQuicklistController*) self)), CTK_IS_ACTOR (_tmp1_) ? ((CtkActor*) _tmp1_) : NULL));
	h = clutter_actor_get_height ((ClutterActor*) (_tmp2_ = unity_launcher_scroller_child_controller_get_child (unity_launcher_quicklist_controller_get_attached_controller ((UnityLauncherQuicklistController*) self)), CTK_IS_ACTOR (_tmp2_) ? ((CtkActor*) _tmp2_) : NULL));
	ctk_menu_expandable_compute_style_textures (((UnityLauncherQuicklistController*) self)->menu);
	ctk_menu_expandable_set_expansion_size_factor (((UnityLauncherQuicklistController*) self)->menu, 0.0f);
	ctk_menu_expandable_set_anchor_position (((UnityLauncherQuicklistController*) self)->menu, (x + w) - 4, y + (h / 2.0f), 0);
	clutter_actor_animate ((ClutterActor*) ((UnityLauncherQuicklistController*) self)->menu, (gulong) CLUTTER_LINEAR, (guint) 100, "expansion-size-factor", 1.0f, NULL);
}


static void __lambda33__unitylauncherscrollerchildcontrollermenu_cb (DbusmenuMenuitem* menu, gpointer self) {
	_lambda33_ (menu, self);
}


static void unity_launcher_application_quicklist_controller_on_state_change (UnityLauncherApplicationQuicklistController* self) {
	g_return_if_fail (self != NULL);
	if (UNITY_IS_SHELL (unity_global_shell)) {
		unity_shell_remove_fullscreen_request (unity_global_shell, (GObject*) self);
	}
	if (unity_launcher_quicklist_controller_get_state ((UnityLauncherQuicklistController*) self) == UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_CLOSED) {
		return;
	}
	if (((UnityLauncherQuicklistController*) self)->menu == NULL) {
		unity_launcher_application_quicklist_controller_new_menu (self);
	}
	if (unity_launcher_quicklist_controller_get_state ((UnityLauncherQuicklistController*) self) == UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_LABEL) {
		char* label;
		UnityLauncherQuicklistMenuItem* menuitem;
		float x = 0.0F;
		float y = 0.0F;
		float w = 0.0F;
		float h = 0.0F;
		UnityLauncherScrollerChild* _tmp0_;
		UnityLauncherScrollerChild* _tmp1_;
		UnityLauncherScrollerChild* _tmp2_;
		ctk_menu_remove_all ((CtkMenu*) ((UnityLauncherQuicklistController*) self)->menu);
		label = g_strdup (unity_launcher_scroller_child_controller_get_name (unity_launcher_quicklist_controller_get_attached_controller ((UnityLauncherQuicklistController*) self)));
		menuitem = g_object_ref_sink (unity_launcher_quicklist_menu_item_new_with_label (label));
		g_signal_connect_object ((CtkMenuItem*) menuitem, "activated", (GCallback) __lambda25__ctk_menu_item_activated, self, 0);
		clutter_actor_set_reactive ((ClutterActor*) menuitem, FALSE);
		ctk_menu_append ((CtkMenu*) ((UnityLauncherQuicklistController*) self)->menu, (ClutterActor*) menuitem, TRUE);
		clutter_actor_get_transformed_position ((ClutterActor*) (_tmp0_ = unity_launcher_scroller_child_controller_get_child (unity_launcher_quicklist_controller_get_attached_controller ((UnityLauncherQuicklistController*) self)), CTK_IS_ACTOR (_tmp0_) ? ((CtkActor*) _tmp0_) : NULL), &x, &y);
		w = clutter_actor_get_width ((ClutterActor*) (_tmp1_ = unity_launcher_scroller_child_controller_get_child (unity_launcher_quicklist_controller_get_attached_controller ((UnityLauncherQuicklistController*) self)), CTK_IS_ACTOR (_tmp1_) ? ((CtkActor*) _tmp1_) : NULL));
		h = clutter_actor_get_height ((ClutterActor*) (_tmp2_ = unity_launcher_scroller_child_controller_get_child (unity_launcher_quicklist_controller_get_attached_controller ((UnityLauncherQuicklistController*) self)), CTK_IS_ACTOR (_tmp2_) ? ((CtkActor*) _tmp2_) : NULL));
		ctk_menu_expandable_compute_style_textures (((UnityLauncherQuicklistController*) self)->menu);
		ctk_menu_expandable_set_expansion_size_factor (((UnityLauncherQuicklistController*) self)->menu, 0.0f);
		ctk_menu_expandable_set_anchor_position (((UnityLauncherQuicklistController*) self)->menu, (x + w) - 4, y + (h / 2.0f), 0);
		_g_object_unref0 (menuitem);
		_g_free0 (label);
	} else {
		if (unity_launcher_quicklist_controller_get_state ((UnityLauncherQuicklistController*) self) == UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_MENU) {
			if (UNITY_IS_SHELL (unity_global_shell)) {
				unity_shell_add_fullscreen_request (unity_global_shell, (GObject*) self);
			}
			if (ctk_menu_get_num_items ((CtkMenu*) ((UnityLauncherQuicklistController*) self)->menu) == 0) {
				char* label;
				UnityLauncherQuicklistMenuItem* menuitem;
				label = g_strdup (unity_launcher_scroller_child_controller_get_name (unity_launcher_quicklist_controller_get_attached_controller ((UnityLauncherQuicklistController*) self)));
				menuitem = g_object_ref_sink (unity_launcher_quicklist_menu_item_new_with_label (label));
				clutter_actor_set_reactive ((ClutterActor*) menuitem, FALSE);
				ctk_menu_append ((CtkMenu*) ((UnityLauncherQuicklistController*) self)->menu, (ClutterActor*) menuitem, FALSE);
				_g_object_unref0 (menuitem);
				_g_free0 (label);
			}
			ctk_menu_set_close_on_leave ((CtkMenu*) ((UnityLauncherQuicklistController*) self)->menu, FALSE);
			ctk_menu_set_detect_clicks ((CtkMenu*) ((UnityLauncherQuicklistController*) self)->menu, TRUE);
			unity_launcher_scroller_child_controller_get_menu_actions (unity_launcher_quicklist_controller_get_attached_controller ((UnityLauncherQuicklistController*) self), __lambda26__unitylauncherscrollerchildcontrollermenu_cb, self);
			unity_launcher_scroller_child_controller_get_menu_navigation (unity_launcher_quicklist_controller_get_attached_controller ((UnityLauncherQuicklistController*) self), __lambda33__unitylauncherscrollerchildcontrollermenu_cb, self);
		}
	}
}


static void _lambda27_ (Block10Data* _data10_) {
	UnityLauncherApplicationQuicklistController * self;
	gint _tmp0_ = 0;
	CtkMenuItem* _tmp1_;
	gint is_checked;
	self = _data10_->self;
	if (ctk_check_menu_item_get_active ((_tmp1_ = _data10_->menuitem, CTK_IS_CHECK_MENU_ITEM (_tmp1_) ? ((CtkCheckMenuItem*) _tmp1_) : NULL))) {
		_tmp0_ = DBUSMENU_MENUITEM_TOGGLE_STATE_CHECKED;
	} else {
		_tmp0_ = DBUSMENU_MENUITEM_TOGGLE_STATE_UNCHECKED;
	}
	is_checked = _tmp0_;
	dbusmenu_menuitem_property_set_int (_data10_->dbusmenuitem, DBUSMENU_MENUITEM_PROP_TOGGLE_STATE, is_checked);
}


static void __lambda27__ctk_check_menu_item_toggled (CtkCheckMenuItem* _sender, gpointer self) {
	_lambda27_ (self);
}


static void _lambda28_ (const char* property_name, void* value, Block10Data* _data10_) {
	UnityLauncherApplicationQuicklistController * self;
	self = _data10_->self;
	g_return_if_fail (property_name != NULL);
	if (_vala_strcmp0 (property_name, DBUSMENU_MENUITEM_PROP_TOGGLE_STATE) == 0) {
		gint* value_weak;
		gboolean _tmp0_ = FALSE;
		CtkMenuItem* _tmp1_;
		value_weak = (gint*) value;
		if ((*value_weak) == DBUSMENU_MENUITEM_TOGGLE_STATE_CHECKED) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = FALSE;
		}
		ctk_check_menu_item_set_active ((_tmp1_ = _data10_->menuitem, CTK_IS_CHECK_MENU_ITEM (_tmp1_) ? ((CtkCheckMenuItem*) _tmp1_) : NULL), _tmp0_);
	}
}


static void __lambda28__dbusmenu_menuitem_property_changed (DbusmenuMenuitem* _sender, const char* property_name, void* value, gpointer self) {
	_lambda28_ (property_name, value, self);
}


static void _lambda29_ (const char* property_name, void* value, Block10Data* _data10_) {
	UnityLauncherApplicationQuicklistController * self;
	self = _data10_->self;
	g_return_if_fail (property_name != NULL);
	if (_vala_strcmp0 (property_name, DBUSMENU_MENUITEM_PROP_LABEL) == 0) {
		const char* value_weak;
		value_weak = (const char*) value;
		ctk_menu_item_set_label (_data10_->menuitem, value_weak);
	} else {
		if (_vala_strcmp0 (property_name, DBUSMENU_MENUITEM_PROP_ENABLED) == 0) {
			gboolean* value_weak;
			value_weak = (gboolean*) value;
			clutter_actor_set_reactive ((ClutterActor*) _data10_->menuitem, *value_weak);
		}
	}
}


static void __lambda29__dbusmenu_menuitem_property_changed (DbusmenuMenuitem* _sender, const char* property_name, void* value, gpointer self) {
	_lambda29_ (property_name, value, self);
}


static void _lambda30_ (Block10Data* _data10_) {
	UnityLauncherApplicationQuicklistController * self;
	self = _data10_->self;
	dbusmenu_menuitem_handle_event (_data10_->dbusmenuitem, "clicked", NULL, (guint) clutter_get_current_event_time ());
}


static void __lambda30__ctk_menu_item_activated (CtkMenuItem* _sender, gpointer self) {
	_lambda30_ (self);
}


static gboolean _lambda32_ (UnityLauncherApplicationQuicklistController* self) {
	gboolean result = FALSE;
	unity_launcher_quicklist_controller_set_state ((UnityLauncherQuicklistController*) self, UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_CLOSED);
	result = FALSE;
	return result;
}


static gboolean __lambda32__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda32_ (self);
	return result;
}


static void _lambda31_ (UnityLauncherApplicationQuicklistController* self) {
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda32__gsource_func, g_object_ref (self), g_object_unref);
}


static void __lambda31__ctk_menu_item_activated (CtkMenuItem* _sender, gpointer self) {
	_lambda31_ (self);
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (Block10Data* _data10_) {
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		_g_object_unref0 (_data10_->self);
		_g_object_unref0 (_data10_->menuitem);
		_g_object_unref0 (_data10_->dbusmenuitem);
		g_slice_free (Block10Data, _data10_);
	}
}


static CtkMenuItem* unity_launcher_application_quicklist_controller_menu_item_from_dbusmenuitem (UnityLauncherApplicationQuicklistController* self, DbusmenuMenuitem* dbusmenuitem) {
	CtkMenuItem* result = NULL;
	Block10Data* _data10_;
	char* label;
	char* _tmp0_;
	char* type;
	char* check_type;
	CtkMenuItem* _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (dbusmenuitem != NULL, NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_data10_->dbusmenuitem = _g_object_ref0 (dbusmenuitem);
	if (dbusmenu_menuitem_property_get_bool (_data10_->dbusmenuitem, DBUSMENU_MENUITEM_PROP_VISIBLE) == FALSE) {
		result = NULL;
		block10_data_unref (_data10_);
		return result;
	}
	label = g_strdup ("UNDEFINED");
	label = (_tmp0_ = g_strdup (dbusmenu_menuitem_property_get (_data10_->dbusmenuitem, DBUSMENU_MENUITEM_PROP_LABEL)), _g_free0 (label), _tmp0_);
	type = g_strdup ("label");
	check_type = g_strdup (dbusmenu_menuitem_property_get (_data10_->dbusmenuitem, DBUSMENU_MENUITEM_PROP_TOGGLE_TYPE));
	if (_vala_strcmp0 (check_type, DBUSMENU_MENUITEM_TOGGLE_CHECK) == 0) {
		char* _tmp1_;
		type = (_tmp1_ = g_strdup ("check"), _g_free0 (type), _tmp1_);
	}
	if (_vala_strcmp0 (check_type, DBUSMENU_MENUITEM_TOGGLE_RADIO) == 0) {
		char* _tmp2_;
		type = (_tmp2_ = g_strdup ("radio"), _g_free0 (type), _tmp2_);
	}
	if (_vala_strcmp0 (dbusmenu_menuitem_property_get (_data10_->dbusmenuitem, "type"), DBUSMENU_CLIENT_TYPES_SEPARATOR) == 0) {
		char* _tmp3_;
		type = (_tmp3_ = g_strdup ("seperator"), _g_free0 (type), _tmp3_);
	}
	if (dbusmenu_menuitem_property_get (_data10_->dbusmenuitem, DBUSMENU_MENUITEM_PROP_ICON_NAME) != NULL) {
		char* _tmp4_;
		type = (_tmp4_ = g_strdup ("stock_image"), _g_free0 (type), _tmp4_);
	}
	if (_vala_strcmp0 (type, "label") == 0) {
		CtkMenuItem* _tmp5_;
		_data10_->menuitem = (_tmp5_ = (CtkMenuItem*) g_object_ref_sink (unity_launcher_quicklist_menu_item_new_with_label (label)), _g_object_unref0 (_data10_->menuitem), _tmp5_);
	} else {
		gboolean _tmp6_ = FALSE;
		if (_vala_strcmp0 (type, "check") == 0) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = _vala_strcmp0 (type, "radio") == 0;
		}
		if (_tmp6_) {
			gint checked;
			CtkMenuItem* _tmp10_;
			if (_vala_strcmp0 (type, "check") == 0) {
				CtkMenuItem* _tmp7_;
				_data10_->menuitem = (_tmp7_ = (CtkMenuItem*) g_object_ref_sink (unity_launcher_quicklist_check_menu_item_new_with_label (label)), _g_object_unref0 (_data10_->menuitem), _tmp7_);
			} else {
				CtkMenuItem* _tmp8_;
				_data10_->menuitem = (_tmp8_ = (CtkMenuItem*) g_object_ref_sink (unity_launcher_quicklist_radio_menu_item_new_with_label (NULL, label)), _g_object_unref0 (_data10_->menuitem), _tmp8_);
			}
			checked = dbusmenu_menuitem_property_get_int (_data10_->dbusmenuitem, DBUSMENU_MENUITEM_PROP_TOGGLE_STATE);
			if (checked == DBUSMENU_MENUITEM_TOGGLE_STATE_CHECKED) {
				CtkMenuItem* _tmp9_;
				ctk_check_menu_item_set_active ((_tmp9_ = _data10_->menuitem, CTK_IS_CHECK_MENU_ITEM (_tmp9_) ? ((CtkCheckMenuItem*) _tmp9_) : NULL), TRUE);
			}
			g_signal_connect_data ((_tmp10_ = _data10_->menuitem, CTK_IS_CHECK_MENU_ITEM (_tmp10_) ? ((CtkCheckMenuItem*) _tmp10_) : NULL), "toggled", (GCallback) __lambda27__ctk_check_menu_item_toggled, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
			g_signal_connect_data (_data10_->dbusmenuitem, "property-changed", (GCallback) __lambda28__dbusmenu_menuitem_property_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
		} else {
			if (_vala_strcmp0 (type, "seperator") == 0) {
				CtkMenuItem* _tmp11_;
				_data10_->menuitem = (_tmp11_ = (CtkMenuItem*) g_object_ref_sink (unity_launcher_quicklist_menu_seperator_new ()), _g_object_unref0 (_data10_->menuitem), _tmp11_);
			} else {
				g_warning ("quicklist-controller.vala:370: not a menu item we understand, %s", dbusmenu_menuitem_property_get (_data10_->dbusmenuitem, "type"));
				result = NULL;
				_g_free0 (check_type);
				_g_free0 (type);
				_g_free0 (label);
				block10_data_unref (_data10_);
				return result;
			}
		}
	}
	g_signal_connect_data (_data10_->dbusmenuitem, "property-changed", (GCallback) __lambda29__dbusmenu_menuitem_property_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	clutter_actor_set_reactive ((ClutterActor*) _data10_->menuitem, dbusmenu_menuitem_property_get_bool (_data10_->dbusmenuitem, DBUSMENU_MENUITEM_PROP_ENABLED));
	g_signal_connect_data (_data10_->menuitem, "activated", (GCallback) __lambda30__ctk_menu_item_activated, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	g_signal_connect_object (_data10_->menuitem, "activated", (GCallback) __lambda31__ctk_menu_item_activated, self, 0);
	result = _g_object_ref0 ((_tmp12_ = _data10_->menuitem, CTK_IS_MENU_ITEM (_tmp12_) ? ((CtkMenuItem*) _tmp12_) : NULL));
	_g_free0 (check_type);
	_g_free0 (type);
	_g_free0 (label);
	block10_data_unref (_data10_);
	return result;
	_g_free0 (check_type);
	_g_free0 (type);
	_g_free0 (label);
	block10_data_unref (_data10_);
}


static void _unity_launcher_application_quicklist_controller_on_state_change_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_launcher_application_quicklist_controller_on_state_change (self);
}


static void _lambda34_ (UnityLauncherApplicationQuicklistController* self) {
	unity_launcher_quicklist_controller_set_state ((UnityLauncherQuicklistController*) self, UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_CLOSED);
}


static void __lambda34__unity_drag_controller_drag_start (UnityDragController* _sender, UnityDragModel* model, gpointer self) {
	_lambda34_ (self);
}


static GObject * unity_launcher_application_quicklist_controller_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityLauncherApplicationQuicklistController * self;
	parent_class = G_OBJECT_CLASS (unity_launcher_application_quicklist_controller_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_LAUNCHER_APPLICATION_QUICKLIST_CONTROLLER (obj);
	{
		UnityTestingObjectRegistry* _tmp0_;
		UnityDragController* drag_controller;
		unity_testing_object_registry_register (_tmp0_ = unity_testing_object_registry_get_default (), "QuicklistController", (GObject*) self);
		_unity_testing_object_registry_unref0 (_tmp0_);
		unity_launcher_application_quicklist_controller_new_menu (self);
		g_signal_connect_object ((GObject*) self, "notify::state", (GCallback) _unity_launcher_application_quicklist_controller_on_state_change_g_object_notify, self, 0);
		unity_launcher_quicklist_controller_set_state ((UnityLauncherQuicklistController*) self, UNITY_LAUNCHER_QUICKLIST_CONTROLLER_STATE_LABEL);
		drag_controller = _g_object_ref0 (unity_drag_controller_get_default ());
		g_signal_connect_object (drag_controller, "drag-start", (GCallback) __lambda34__unity_drag_controller_drag_start, self, 0);
		_g_object_unref0 (drag_controller);
	}
	return obj;
}


static void unity_launcher_application_quicklist_controller_class_init (UnityLauncherApplicationQuicklistControllerClass * klass) {
	unity_launcher_application_quicklist_controller_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = unity_launcher_application_quicklist_controller_constructor;
}


static void unity_launcher_application_quicklist_controller_instance_init (UnityLauncherApplicationQuicklistController * self) {
}


GType unity_launcher_application_quicklist_controller_get_type (void) {
	static volatile gsize unity_launcher_application_quicklist_controller_type_id__volatile = 0;
	if (g_once_init_enter (&unity_launcher_application_quicklist_controller_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityLauncherApplicationQuicklistControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_launcher_application_quicklist_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityLauncherApplicationQuicklistController), 0, (GInstanceInitFunc) unity_launcher_application_quicklist_controller_instance_init, NULL };
		GType unity_launcher_application_quicklist_controller_type_id;
		unity_launcher_application_quicklist_controller_type_id = g_type_register_static (UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER, "UnityLauncherApplicationQuicklistController", &g_define_type_info, 0);
		g_once_init_leave (&unity_launcher_application_quicklist_controller_type_id__volatile, unity_launcher_application_quicklist_controller_type_id);
	}
	return unity_launcher_application_quicklist_controller_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




