/* expose-manager.c generated by valac 0.10.0, the Vala compiler
 * generated from expose-manager.vala, do not modify */

/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <mutter-plugins.h>
#include <unity-private.h>
#include <unity.h>
#include <gee.h>
#include <gdk/gdk.h>


#define UNITY_TYPE_EXPOSE_CLONE (unity_expose_clone_get_type ())
#define UNITY_EXPOSE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_EXPOSE_CLONE, UnityExposeClone))
#define UNITY_EXPOSE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_EXPOSE_CLONE, UnityExposeCloneClass))
#define UNITY_IS_EXPOSE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_EXPOSE_CLONE))
#define UNITY_IS_EXPOSE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_EXPOSE_CLONE))
#define UNITY_EXPOSE_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_EXPOSE_CLONE, UnityExposeCloneClass))

typedef struct _UnityExposeClone UnityExposeClone;
typedef struct _UnityExposeCloneClass UnityExposeCloneClass;
typedef struct _UnityExposeClonePrivate UnityExposeClonePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

#define UNITY_TYPE_EXPOSE_MANAGER (unity_expose_manager_get_type ())
#define UNITY_EXPOSE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_EXPOSE_MANAGER, UnityExposeManager))
#define UNITY_EXPOSE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_EXPOSE_MANAGER, UnityExposeManagerClass))
#define UNITY_IS_EXPOSE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_EXPOSE_MANAGER))
#define UNITY_IS_EXPOSE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_EXPOSE_MANAGER))
#define UNITY_EXPOSE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_EXPOSE_MANAGER, UnityExposeManagerClass))

typedef struct _UnityExposeManager UnityExposeManager;
typedef struct _UnityExposeManagerClass UnityExposeManagerClass;
typedef struct _UnityExposeManagerPrivate UnityExposeManagerPrivate;

#define UNITY_TYPE_PLUGIN (unity_plugin_get_type ())
#define UNITY_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_PLUGIN, UnityPlugin))
#define UNITY_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_PLUGIN, UnityPluginClass))
#define UNITY_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_PLUGIN))
#define UNITY_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_PLUGIN))
#define UNITY_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_PLUGIN, UnityPluginClass))

typedef struct _UnityPlugin UnityPlugin;
typedef struct _UnityPluginClass UnityPluginClass;
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _UnityPluginPrivate UnityPluginPrivate;

struct _UnityExposeClone {
	ClutterGroup parent_instance;
	UnityExposeClonePrivate * priv;
	gboolean dirty;
};

struct _UnityExposeCloneClass {
	ClutterGroupClass parent_class;
};

struct _UnityExposeClonePrivate {
	ClutterClone* clone;
	ClutterActor* darken_box;
	ClutterActor* original_parent;
	gboolean hovered;
	gboolean dragging;
	float drag_start_x;
	float drag_start_y;
	gboolean drag_moved;
	float _pre_drag_scale_x;
	float _pre_drag_scale_y;
	gboolean _fade_on_close;
	ClutterActor* _source;
	guint8 _hovered_opacity;
	guint8 _unhovered_opacity;
	guint8 _darken;
	gboolean _enable_dnd;
};

struct _Block1Data {
	int _ref_count_;
	UnityExposeClone * self;
	ClutterActor* window;
};

struct _UnityExposeManager {
	GObject parent_instance;
	UnityExposeManagerPrivate * priv;
	GList* exposed_windows;
};

struct _UnityExposeManagerClass {
	GObjectClass parent_class;
};

struct _UnityExposeManagerPrivate {
	ClutterGroup* expose_group;
	UnityPlugin* owner;
	ClutterStage* stage;
	UnityLauncherLauncher* launcher;
	gboolean _expose_showing;
	gboolean _coverflow;
	gint _left_buffer;
	gint _right_buffer;
	gint _top_buffer;
	gint _bottom_buffer;
	guint8 _hovered_opacity;
	guint8 _unhovered_opacity;
	guint8 _darken;
	guint coverflow_index;
	UnityExposeClone* last_selected_clone;
};

struct _Block2Data {
	int _ref_count_;
	UnityExposeManager * self;
	UnityExposeClone* _clone;
};

struct _UnityPlugin {
	GObject parent_instance;
	UnityPluginPrivate * priv;
	GeeArrayList* backgrounds;
	GdkRectangle primary_monitor;
	UnityGestureDispatcher* gesture_dispatcher;
};

struct _UnityPluginClass {
	GObjectClass parent_class;
};


static gpointer unity_expose_clone_parent_class = NULL;
static gpointer unity_expose_manager_parent_class = NULL;

GType unity_expose_clone_get_type (void) G_GNUC_CONST;
#define UNITY_EXPOSE_CLONE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_EXPOSE_CLONE, UnityExposeClonePrivate))
enum  {
	UNITY_EXPOSE_CLONE_DUMMY_PROPERTY,
	UNITY_EXPOSE_CLONE_PRE_DRAG_PARENT,
	UNITY_EXPOSE_CLONE_PRE_DRAG_SCALE_X,
	UNITY_EXPOSE_CLONE_PRE_DRAG_SCALE_Y,
	UNITY_EXPOSE_CLONE_FADE_ON_CLOSE,
	UNITY_EXPOSE_CLONE_SOURCE,
	UNITY_EXPOSE_CLONE_HOVERED_OPACITY,
	UNITY_EXPOSE_CLONE_UNHOVERED_OPACITY,
	UNITY_EXPOSE_CLONE_DARKEN,
	UNITY_EXPOSE_CLONE_ENABLE_DND
};
UnityExposeClone* unity_expose_clone_new (ClutterActor* source);
UnityExposeClone* unity_expose_clone_construct (GType object_type, ClutterActor* source);
void unity_expose_clone_set_darken (UnityExposeClone* self, guint8 value);
void unity_expose_clone_set_hovered_opacity (UnityExposeClone* self, guint8 value);
void unity_expose_clone_set_unhovered_opacity (UnityExposeClone* self, guint8 value);
void unity_expose_clone_set_enable_dnd (UnityExposeClone* self, gboolean value);
static void unity_expose_clone_set_source (UnityExposeClone* self, ClutterActor* value);
static void unity_expose_clone_on_source_destroyed (UnityExposeClone* self);
static void _unity_expose_clone_on_source_destroyed_clutter_actor_destroy (ClutterActor* _sender, gpointer self);
guint8 unity_expose_clone_get_darken (UnityExposeClone* self);
static gboolean unity_expose_clone_on_button_press (UnityExposeClone* self, ClutterEvent* evnt);
gboolean unity_expose_clone_get_enable_dnd (UnityExposeClone* self);
static void unity_expose_clone_start_drag (UnityExposeClone* self, ClutterEvent* evnt);
static gboolean unity_expose_clone_on_stage_captured_event (UnityExposeClone* self, ClutterEvent* event);
static gboolean _unity_expose_clone_on_stage_captured_event_clutter_actor_captured_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static void unity_expose_clone_set_pre_drag_scale_x (UnityExposeClone* self, float value);
static void unity_expose_clone_set_pre_drag_scale_y (UnityExposeClone* self, float value);
static void unity_expose_clone_end_drag (UnityExposeClone* self, gint x, gint y);
static gboolean unity_expose_clone_on_mouse_leave (UnityExposeClone* self, ClutterEvent* evnt);
static gboolean unity_expose_clone_on_mouse_enter (UnityExposeClone* self, ClutterEvent* evnt);
guint8 unity_expose_clone_get_hovered_opacity (UnityExposeClone* self);
guint8 unity_expose_clone_get_unhovered_opacity (UnityExposeClone* self);
void unity_expose_clone_restore_window_position (UnityExposeClone* self, gint active_workspace);
ClutterActor* unity_expose_clone_get_source (UnityExposeClone* self);
gboolean unity_expose_clone_get_fade_on_close (UnityExposeClone* self);
static void _lambda0_ (Block1Data* _data1_);
static void __lambda0__clutter_animation_completed (ClutterAnimation* _sender, gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
ClutterActor* unity_expose_clone_get_pre_drag_parent (UnityExposeClone* self);
float unity_expose_clone_get_pre_drag_scale_x (UnityExposeClone* self);
float unity_expose_clone_get_pre_drag_scale_y (UnityExposeClone* self);
void unity_expose_clone_set_fade_on_close (UnityExposeClone* self, gboolean value);
static gboolean _unity_expose_clone_on_mouse_enter_clutter_actor_enter_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static gboolean _unity_expose_clone_on_mouse_leave_clutter_actor_leave_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static gboolean _unity_expose_clone_on_button_press_clutter_actor_button_press_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static GObject * unity_expose_clone_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_expose_clone_finalize (GObject* obj);
static void unity_expose_clone_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_expose_clone_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType unity_expose_manager_get_type (void) G_GNUC_CONST;
GType unity_plugin_get_type (void) G_GNUC_CONST;
#define UNITY_EXPOSE_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_EXPOSE_MANAGER, UnityExposeManagerPrivate))
enum  {
	UNITY_EXPOSE_MANAGER_DUMMY_PROPERTY,
	UNITY_EXPOSE_MANAGER_EXPOSE_SHOWING,
	UNITY_EXPOSE_MANAGER_COVERFLOW,
	UNITY_EXPOSE_MANAGER_LEFT_BUFFER,
	UNITY_EXPOSE_MANAGER_RIGHT_BUFFER,
	UNITY_EXPOSE_MANAGER_TOP_BUFFER,
	UNITY_EXPOSE_MANAGER_BOTTOM_BUFFER,
	UNITY_EXPOSE_MANAGER_HOVERED_OPACITY,
	UNITY_EXPOSE_MANAGER_UNHOVERED_OPACITY,
	UNITY_EXPOSE_MANAGER_DARKEN
};
static void _g_list_free_g_object_unref (GList* self);
UnityExposeManager* unity_expose_manager_new (UnityPlugin* owner, UnityLauncherLauncher* launcher);
UnityExposeManager* unity_expose_manager_construct (GType object_type, UnityPlugin* owner, UnityLauncherLauncher* launcher);
void unity_expose_manager_set_hovered_opacity (UnityExposeManager* self, guint8 value);
void unity_expose_manager_set_unhovered_opacity (UnityExposeManager* self, guint8 value);
void unity_expose_manager_set_darken (UnityExposeManager* self, guint8 value);
void unity_expose_manager_start_expose (UnityExposeManager* self, GSList* windows);
gboolean unity_expose_manager_get_expose_showing (UnityExposeManager* self);
MutterPlugin* unity_plugin_get_plugin (UnityPlugin* self);
static void unity_expose_manager_on_clone_destroyed (UnityExposeManager* self);
static void _unity_expose_manager_on_clone_destroyed_clutter_actor_destroy (ClutterActor* _sender, gpointer self);
guint8 unity_expose_manager_get_hovered_opacity (UnityExposeManager* self);
guint8 unity_expose_manager_get_unhovered_opacity (UnityExposeManager* self);
guint8 unity_expose_manager_get_darken (UnityExposeManager* self);
static void _lambda19_ (Block2Data* _data2_);
static void __lambda19__clutter_animation_completed (ClutterAnimation* _sender, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
gboolean unity_expose_manager_get_coverflow (UnityExposeManager* self);
static void unity_expose_manager_position_windows_coverflow (UnityExposeManager* self, GList* windows, ClutterActor* active);
void unity_expose_manager_position_windows_on_grid (UnityExposeManager* self, GList* _windows, gint top_buffer, gint left_buffer, gint right_buffer, gint bottom_buffer);
gint unity_expose_manager_get_top_buffer (UnityExposeManager* self);
gint unity_expose_manager_get_left_buffer (UnityExposeManager* self);
gint unity_expose_manager_get_right_buffer (UnityExposeManager* self);
gint unity_expose_manager_get_bottom_buffer (UnityExposeManager* self);
static void unity_expose_manager_set_expose_showing (UnityExposeManager* self, gboolean value);
static gboolean unity_expose_manager_on_stage_captured_event (UnityExposeManager* self, ClutterEvent* event);
static gboolean _unity_expose_manager_on_stage_captured_event_clutter_actor_captured_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
void unity_expose_manager_end_expose (UnityExposeManager* self);
static gint unity_expose_manager_direct_comparison (UnityExposeManager* self, void* a, void* b);
static void unity_expose_manager_handle_event_coverflow (UnityExposeManager* self, ClutterEvent* event);
static void unity_expose_manager_handle_event_expose (UnityExposeManager* self, ClutterEvent* event, ClutterActor* actor);
static void unity_expose_manager_pick_window (UnityExposeManager* self, ClutterEvent* event, ClutterActor* actor);
void unity_expose_manager_set_coverflow (UnityExposeManager* self, gboolean value);
void unity_expose_manager_set_left_buffer (UnityExposeManager* self, gint value);
void unity_expose_manager_set_right_buffer (UnityExposeManager* self, gint value);
void unity_expose_manager_set_top_buffer (UnityExposeManager* self, gint value);
void unity_expose_manager_set_bottom_buffer (UnityExposeManager* self, gint value);
static GObject * unity_expose_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_expose_manager_finalize (GObject* obj);
static void unity_expose_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_expose_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



static void _unity_expose_clone_on_source_destroyed_clutter_actor_destroy (ClutterActor* _sender, gpointer self) {
	unity_expose_clone_on_source_destroyed (self);
}


UnityExposeClone* unity_expose_clone_construct (GType object_type, ClutterActor* source) {
	UnityExposeClone * self;
	ClutterColor _tmp3_ = {0};
	ClutterColor _tmp4_;
	ClutterActor* _tmp5_;
	g_return_val_if_fail (source != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	unity_expose_clone_set_darken (self, (guint8) 0);
	unity_expose_clone_set_hovered_opacity (self, (guint8) 255);
	unity_expose_clone_set_unhovered_opacity (self, (guint8) 255);
	unity_expose_clone_set_enable_dnd (self, FALSE);
	unity_expose_clone_set_source (self, source);
	if (MUTTER_IS_WINDOW (source)) {
		ClutterActor* _tmp0_;
		ClutterClone* _tmp1_;
		self->priv->clone = (_tmp1_ = g_object_ref_sink ((ClutterClone*) clutter_clone_new (mutter_window_get_texture ((_tmp0_ = source, MUTTER_IS_WINDOW (_tmp0_) ? ((MutterWindow*) _tmp0_) : NULL)))), _g_object_unref0 (self->priv->clone), _tmp1_);
	} else {
		ClutterClone* _tmp2_;
		self->priv->clone = (_tmp2_ = g_object_ref_sink ((ClutterClone*) clutter_clone_new (source)), _g_object_unref0 (self->priv->clone), _tmp2_);
	}
	g_signal_connect_object (source, "destroy", (GCallback) _unity_expose_clone_on_source_destroyed_clutter_actor_destroy, self, 0);
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) self->priv->clone);
	clutter_actor_show ((ClutterActor*) self->priv->clone);
	clutter_actor_set_reactive ((ClutterActor*) self->priv->clone, TRUE);
	clutter_actor_set_position ((ClutterActor*) self->priv->clone, (float) 0, (float) 0);
	self->priv->darken_box = (_tmp5_ = (ClutterActor*) g_object_ref_sink ((ClutterRectangle*) clutter_rectangle_new_with_color ((_tmp4_ = (_tmp3_.red = (guint8) 0, _tmp3_.green = (guint8) 0, _tmp3_.blue = (guint8) 0, _tmp3_.alpha = (guint8) 255, _tmp3_), &_tmp4_))), _g_object_unref0 (self->priv->darken_box), _tmp5_);
	clutter_container_add_actor ((ClutterContainer*) self, self->priv->darken_box);
	clutter_actor_raise_top (self->priv->darken_box);
	clutter_actor_set_position (self->priv->darken_box, (float) 0, (float) 0);
	clutter_actor_set_size (self->priv->darken_box, clutter_actor_get_width (source), clutter_actor_get_height (source));
	clutter_actor_set_opacity (self->priv->darken_box, unity_expose_clone_get_darken (self));
	return self;
}


UnityExposeClone* unity_expose_clone_new (ClutterActor* source) {
	return unity_expose_clone_construct (UNITY_TYPE_EXPOSE_CLONE, source);
}


static void unity_expose_clone_on_source_destroyed (UnityExposeClone* self) {
	g_return_if_fail (self != NULL);
	clutter_actor_destroy ((ClutterActor*) self);
}


static gboolean unity_expose_clone_on_button_press (UnityExposeClone* self, ClutterEvent* evnt) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->_enable_dnd) {
		result = FALSE;
		return result;
	}
	unity_expose_clone_start_drag (self, evnt);
	result = TRUE;
	return result;
}


static gboolean _unity_expose_clone_on_stage_captured_event_clutter_actor_captured_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = unity_expose_clone_on_stage_captured_event (self, event);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void unity_expose_clone_start_drag (UnityExposeClone* self, ClutterEvent* evnt) {
	ClutterActor* _tmp0_;
	float x = 0.0F;
	float y = 0.0F;
	double scale_x = 0.0;
	double scale_y = 0.0;
	g_return_if_fail (self != NULL);
	self->priv->dragging = TRUE;
	g_signal_connect_object (clutter_actor_get_stage ((ClutterActor*) self), "captured-event", (GCallback) _unity_expose_clone_on_stage_captured_event_clutter_actor_captured_event, self, 0);
	self->priv->original_parent = (_tmp0_ = _g_object_ref0 (clutter_actor_get_parent ((ClutterActor*) self)), _g_object_unref0 (self->priv->original_parent), _tmp0_);
	clutter_event_get_coords (evnt, &x, &y);
	clutter_actor_get_scale ((ClutterActor*) self, &scale_x, &scale_y);
	self->priv->drag_start_x = x;
	self->priv->drag_start_y = y;
	unity_expose_clone_set_pre_drag_scale_x (self, (float) scale_x);
	unity_expose_clone_set_pre_drag_scale_y (self, (float) scale_y);
	self->priv->drag_moved = FALSE;
}


static void unity_expose_clone_end_drag (UnityExposeClone* self, gint x, gint y) {
	guint _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* target;
	g_return_if_fail (self != NULL);
	self->priv->dragging = FALSE;
	clutter_actor_set_reactive ((ClutterActor*) self->priv->clone, TRUE);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	g_signal_parse_name ("captured-event", CLUTTER_TYPE_ACTOR, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (clutter_actor_get_stage ((ClutterActor*) self), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _unity_expose_clone_on_stage_captured_event_clutter_actor_captured_event, self);
	if (!self->priv->drag_moved) {
		return;
	}
	clutter_actor_hide ((ClutterActor*) self);
	target = _g_object_ref0 (clutter_stage_get_actor_at_pos ((_tmp1_ = clutter_actor_get_stage ((ClutterActor*) self), CLUTTER_IS_STAGE (_tmp1_) ? ((ClutterStage*) _tmp1_) : NULL), CLUTTER_PICK_REACTIVE, x, y));
	clutter_actor_show ((ClutterActor*) self);
	g_signal_emit_by_name (self, "drag-dropped", target);
	unity_expose_clone_on_mouse_leave (self, NULL);
	_g_object_unref0 (target);
}


static gboolean unity_expose_clone_on_stage_captured_event (UnityExposeClone* self, ClutterEvent* event) {
	gboolean result = FALSE;
	float x = 0.0F;
	float y = 0.0F;
	g_return_val_if_fail (self != NULL, FALSE);
	clutter_event_get_coords (event, &x, &y);
	if (!self->priv->dragging) {
		unity_expose_clone_end_drag (self, (gint) x, (gint) y);
		result = FALSE;
		return result;
	}
	if ((*event).type == CLUTTER_MOTION) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		if (fabs ((double) ((*event).motion.x - self->priv->drag_start_x)) > 30) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = fabs ((double) ((*event).motion.y - self->priv->drag_start_y)) > 30;
		}
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = self->priv->drag_moved;
		}
		if (_tmp0_) {
			if (!self->priv->drag_moved) {
				float width = 0.0F;
				float height = 0.0F;
				clutter_actor_get_transformed_size ((ClutterActor*) self, &width, &height);
				clutter_actor_reparent ((ClutterActor*) self, clutter_actor_get_stage ((ClutterActor*) self));
				clutter_actor_set_scale ((ClutterActor*) self, (double) (width / clutter_actor_get_width ((ClutterActor*) self)), (double) (height / clutter_actor_get_height ((ClutterActor*) self)));
				clutter_actor_raise_top ((ClutterActor*) self);
				self->priv->drag_moved = TRUE;
				clutter_actor_set_reactive ((ClutterActor*) self, FALSE);
				clutter_actor_set_reactive ((ClutterActor*) self->priv->clone, FALSE);
			}
			clutter_actor_set_position ((ClutterActor*) self, (*event).motion.x - (clutter_actor_get_width ((ClutterActor*) self) / 2), (*event).motion.y - (clutter_actor_get_height ((ClutterActor*) self) / 2));
		}
	} else {
		if ((*event).type == CLUTTER_BUTTON_RELEASE) {
			unity_expose_clone_end_drag (self, (gint) x, (gint) y);
			result = self->priv->drag_moved;
			return result;
		}
	}
	result = FALSE;
	return result;
}


static gboolean unity_expose_clone_on_mouse_enter (UnityExposeClone* self, ClutterEvent* evnt) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->hovered = TRUE;
	clutter_actor_set_opacity ((ClutterActor*) self, self->priv->_hovered_opacity);
	clutter_actor_set_opacity (self->priv->darken_box, (guint8) 0);
	result = FALSE;
	return result;
}


static gboolean unity_expose_clone_on_mouse_leave (UnityExposeClone* self, ClutterEvent* evnt) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->hovered = FALSE;
	clutter_actor_set_opacity ((ClutterActor*) self, self->priv->_unhovered_opacity);
	clutter_actor_set_opacity (self->priv->darken_box, unity_expose_clone_get_darken (self));
	result = FALSE;
	return result;
}


static void _lambda0_ (Block1Data* _data1_) {
	UnityExposeClone * self;
	self = _data1_->self;
	clutter_actor_destroy ((ClutterActor*) self);
	clutter_actor_set_opacity (_data1_->window, (guint8) 255);
}


static void __lambda0__clutter_animation_completed (ClutterAnimation* _sender, gpointer self) {
	_lambda0_ (self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->window);
		g_slice_free (Block1Data, _data1_);
	}
}


void unity_expose_clone_restore_window_position (UnityExposeClone* self, gint active_workspace) {
	Block1Data* _data1_;
	guint8 opacity;
	gboolean _tmp0_ = FALSE;
	ClutterAnimation* anim;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	clutter_actor_set_anchor_point_from_gravity ((ClutterActor*) self, CLUTTER_GRAVITY_NORTH_WEST);
	_data1_->window = _g_object_ref0 (self->priv->_source);
	opacity = (guint8) 0;
	if (!self->priv->_fade_on_close) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		if (MUTTER_IS_WINDOW (_data1_->window)) {
			ClutterActor* _tmp3_;
			_tmp2_ = mutter_window_showing_on_its_workspace ((_tmp3_ = _data1_->window, MUTTER_IS_WINDOW (_tmp3_) ? ((MutterWindow*) _tmp3_) : NULL));
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			ClutterActor* _tmp4_;
			_tmp1_ = mutter_window_get_workspace ((_tmp4_ = _data1_->window, MUTTER_IS_WINDOW (_tmp4_) ? ((MutterWindow*) _tmp4_) : NULL)) == active_workspace;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = _tmp1_;
	}
	if (_tmp0_) {
		opacity = (guint8) 255;
	}
	g_object_set ((GObject*) self, "scale-gravity", CLUTTER_GRAVITY_CENTER, NULL);
	anim = _g_object_ref0 (clutter_actor_animate ((ClutterActor*) self, (gulong) CLUTTER_EASE_IN_OUT_SINE, (guint) 250, "scale-x", 1.f, "scale-y", 1.f, "opacity", opacity, "x", clutter_actor_get_x (_data1_->window), "y", clutter_actor_get_y (_data1_->window), NULL));
	clutter_actor_set_opacity (_data1_->window, (guint8) 0);
	g_signal_connect_data (anim, "completed", (GCallback) __lambda0__clutter_animation_completed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_g_object_unref0 (anim);
	block1_data_unref (_data1_);
}


ClutterActor* unity_expose_clone_get_pre_drag_parent (UnityExposeClone* self) {
	ClutterActor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->original_parent;
	return result;
}


float unity_expose_clone_get_pre_drag_scale_x (UnityExposeClone* self) {
	float result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_pre_drag_scale_x;
	return result;
}


static void unity_expose_clone_set_pre_drag_scale_x (UnityExposeClone* self, float value) {
	g_return_if_fail (self != NULL);
	self->priv->_pre_drag_scale_x = value;
	g_object_notify ((GObject *) self, "pre-drag-scale-x");
}


float unity_expose_clone_get_pre_drag_scale_y (UnityExposeClone* self) {
	float result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_pre_drag_scale_y;
	return result;
}


static void unity_expose_clone_set_pre_drag_scale_y (UnityExposeClone* self, float value) {
	g_return_if_fail (self != NULL);
	self->priv->_pre_drag_scale_y = value;
	g_object_notify ((GObject *) self, "pre-drag-scale-y");
}


gboolean unity_expose_clone_get_fade_on_close (UnityExposeClone* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_fade_on_close;
	return result;
}


void unity_expose_clone_set_fade_on_close (UnityExposeClone* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_fade_on_close = value;
	g_object_notify ((GObject *) self, "fade-on-close");
}


ClutterActor* unity_expose_clone_get_source (UnityExposeClone* self) {
	ClutterActor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_source;
	return result;
}


static void unity_expose_clone_set_source (UnityExposeClone* self, ClutterActor* value) {
	g_return_if_fail (self != NULL);
	self->priv->_source = value;
	g_object_notify ((GObject *) self, "source");
}


guint8 unity_expose_clone_get_hovered_opacity (UnityExposeClone* self) {
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_hovered_opacity;
	return result;
}


void unity_expose_clone_set_hovered_opacity (UnityExposeClone* self, guint8 value) {
	g_return_if_fail (self != NULL);
	self->priv->_hovered_opacity = value;
	g_object_notify ((GObject *) self, "hovered-opacity");
}


guint8 unity_expose_clone_get_unhovered_opacity (UnityExposeClone* self) {
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_unhovered_opacity;
	return result;
}


void unity_expose_clone_set_unhovered_opacity (UnityExposeClone* self, guint8 value) {
	g_return_if_fail (self != NULL);
	self->priv->_unhovered_opacity = value;
	g_object_notify ((GObject *) self, "unhovered-opacity");
}


guint8 unity_expose_clone_get_darken (UnityExposeClone* self) {
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_darken;
	return result;
}


void unity_expose_clone_set_darken (UnityExposeClone* self, guint8 value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	self->priv->_darken = value;
	if (!self->priv->hovered) {
		_tmp0_ = CLUTTER_IS_ACTOR (self->priv->darken_box);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		clutter_actor_set_opacity (self->priv->darken_box, unity_expose_clone_get_darken (self));
	}
	g_object_notify ((GObject *) self, "darken");
}


gboolean unity_expose_clone_get_enable_dnd (UnityExposeClone* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_enable_dnd;
	return result;
}


void unity_expose_clone_set_enable_dnd (UnityExposeClone* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_enable_dnd = value;
	g_object_notify ((GObject *) self, "enable-dnd");
}


static gboolean _unity_expose_clone_on_mouse_enter_clutter_actor_enter_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = unity_expose_clone_on_mouse_enter (self, event);
	return result;
}


static gboolean _unity_expose_clone_on_mouse_leave_clutter_actor_leave_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = unity_expose_clone_on_mouse_leave (self, event);
	return result;
}


static gboolean _unity_expose_clone_on_button_press_clutter_actor_button_press_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = unity_expose_clone_on_button_press (self, event);
	return result;
}


static GObject * unity_expose_clone_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityExposeClone * self;
	parent_class = G_OBJECT_CLASS (unity_expose_clone_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_EXPOSE_CLONE (obj);
	{
		g_signal_connect_object ((ClutterActor*) self, "enter-event", (GCallback) _unity_expose_clone_on_mouse_enter_clutter_actor_enter_event, self, 0);
		g_signal_connect_object ((ClutterActor*) self, "leave-event", (GCallback) _unity_expose_clone_on_mouse_leave_clutter_actor_leave_event, self, 0);
		g_signal_connect_object ((ClutterActor*) self, "button-press-event", (GCallback) _unity_expose_clone_on_button_press_clutter_actor_button_press_event, self, 0);
	}
	return obj;
}


static void unity_expose_clone_class_init (UnityExposeCloneClass * klass) {
	unity_expose_clone_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityExposeClonePrivate));
	G_OBJECT_CLASS (klass)->get_property = unity_expose_clone_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_expose_clone_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_expose_clone_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_expose_clone_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_CLONE_PRE_DRAG_PARENT, g_param_spec_object ("pre-drag-parent", "pre-drag-parent", "pre-drag-parent", CLUTTER_TYPE_ACTOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_CLONE_PRE_DRAG_SCALE_X, g_param_spec_float ("pre-drag-scale-x", "pre-drag-scale-x", "pre-drag-scale-x", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_CLONE_PRE_DRAG_SCALE_Y, g_param_spec_float ("pre-drag-scale-y", "pre-drag-scale-y", "pre-drag-scale-y", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_CLONE_FADE_ON_CLOSE, g_param_spec_boolean ("fade-on-close", "fade-on-close", "fade-on-close", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_CLONE_SOURCE, g_param_spec_object ("source", "source", "source", CLUTTER_TYPE_ACTOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_CLONE_HOVERED_OPACITY, g_param_spec_uchar ("hovered-opacity", "hovered-opacity", "hovered-opacity", 0, G_MAXUINT8, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_CLONE_UNHOVERED_OPACITY, g_param_spec_uchar ("unhovered-opacity", "unhovered-opacity", "unhovered-opacity", 0, G_MAXUINT8, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_CLONE_DARKEN, g_param_spec_uchar ("darken", "darken", "darken", 0, G_MAXUINT8, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_CLONE_ENABLE_DND, g_param_spec_boolean ("enable-dnd", "enable-dnd", "enable-dnd", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("drag_dropped", UNITY_TYPE_EXPOSE_CLONE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, CLUTTER_TYPE_ACTOR);
}


static void unity_expose_clone_instance_init (UnityExposeClone * self) {
	self->priv = UNITY_EXPOSE_CLONE_GET_PRIVATE (self);
}


static void unity_expose_clone_finalize (GObject* obj) {
	UnityExposeClone * self;
	self = UNITY_EXPOSE_CLONE (obj);
	_g_object_unref0 (self->priv->clone);
	_g_object_unref0 (self->priv->darken_box);
	_g_object_unref0 (self->priv->original_parent);
	G_OBJECT_CLASS (unity_expose_clone_parent_class)->finalize (obj);
}


GType unity_expose_clone_get_type (void) {
	static volatile gsize unity_expose_clone_type_id__volatile = 0;
	if (g_once_init_enter (&unity_expose_clone_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityExposeCloneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_expose_clone_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityExposeClone), 0, (GInstanceInitFunc) unity_expose_clone_instance_init, NULL };
		GType unity_expose_clone_type_id;
		unity_expose_clone_type_id = g_type_register_static (CLUTTER_TYPE_GROUP, "UnityExposeClone", &g_define_type_info, 0);
		g_once_init_leave (&unity_expose_clone_type_id__volatile, unity_expose_clone_type_id);
	}
	return unity_expose_clone_type_id__volatile;
}


static void unity_expose_clone_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityExposeClone * self;
	self = UNITY_EXPOSE_CLONE (object);
	switch (property_id) {
		case UNITY_EXPOSE_CLONE_PRE_DRAG_PARENT:
		g_value_set_object (value, unity_expose_clone_get_pre_drag_parent (self));
		break;
		case UNITY_EXPOSE_CLONE_PRE_DRAG_SCALE_X:
		g_value_set_float (value, unity_expose_clone_get_pre_drag_scale_x (self));
		break;
		case UNITY_EXPOSE_CLONE_PRE_DRAG_SCALE_Y:
		g_value_set_float (value, unity_expose_clone_get_pre_drag_scale_y (self));
		break;
		case UNITY_EXPOSE_CLONE_FADE_ON_CLOSE:
		g_value_set_boolean (value, unity_expose_clone_get_fade_on_close (self));
		break;
		case UNITY_EXPOSE_CLONE_SOURCE:
		g_value_set_object (value, unity_expose_clone_get_source (self));
		break;
		case UNITY_EXPOSE_CLONE_HOVERED_OPACITY:
		g_value_set_uchar (value, unity_expose_clone_get_hovered_opacity (self));
		break;
		case UNITY_EXPOSE_CLONE_UNHOVERED_OPACITY:
		g_value_set_uchar (value, unity_expose_clone_get_unhovered_opacity (self));
		break;
		case UNITY_EXPOSE_CLONE_DARKEN:
		g_value_set_uchar (value, unity_expose_clone_get_darken (self));
		break;
		case UNITY_EXPOSE_CLONE_ENABLE_DND:
		g_value_set_boolean (value, unity_expose_clone_get_enable_dnd (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_expose_clone_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityExposeClone * self;
	self = UNITY_EXPOSE_CLONE (object);
	switch (property_id) {
		case UNITY_EXPOSE_CLONE_PRE_DRAG_SCALE_X:
		unity_expose_clone_set_pre_drag_scale_x (self, g_value_get_float (value));
		break;
		case UNITY_EXPOSE_CLONE_PRE_DRAG_SCALE_Y:
		unity_expose_clone_set_pre_drag_scale_y (self, g_value_get_float (value));
		break;
		case UNITY_EXPOSE_CLONE_FADE_ON_CLOSE:
		unity_expose_clone_set_fade_on_close (self, g_value_get_boolean (value));
		break;
		case UNITY_EXPOSE_CLONE_SOURCE:
		unity_expose_clone_set_source (self, g_value_get_object (value));
		break;
		case UNITY_EXPOSE_CLONE_HOVERED_OPACITY:
		unity_expose_clone_set_hovered_opacity (self, g_value_get_uchar (value));
		break;
		case UNITY_EXPOSE_CLONE_UNHOVERED_OPACITY:
		unity_expose_clone_set_unhovered_opacity (self, g_value_get_uchar (value));
		break;
		case UNITY_EXPOSE_CLONE_DARKEN:
		unity_expose_clone_set_darken (self, g_value_get_uchar (value));
		break;
		case UNITY_EXPOSE_CLONE_ENABLE_DND:
		unity_expose_clone_set_enable_dnd (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


UnityExposeManager* unity_expose_manager_construct (GType object_type, UnityPlugin* owner, UnityLauncherLauncher* launcher) {
	UnityExposeManager * self;
	UnityLauncherLauncher* _tmp0_;
	UnityPlugin* _tmp1_;
	GList* _tmp2_;
	ClutterStage* _tmp3_;
	g_return_val_if_fail (owner != NULL, NULL);
	g_return_val_if_fail (launcher != NULL, NULL);
	self = (UnityExposeManager*) g_object_new (object_type, NULL);
	self->priv->launcher = (_tmp0_ = _g_object_ref0 (launcher), _g_object_unref0 (self->priv->launcher), _tmp0_);
	self->priv->owner = (_tmp1_ = _g_object_ref0 (owner), _g_object_unref0 (self->priv->owner), _tmp1_);
	self->exposed_windows = (_tmp2_ = NULL, __g_list_free_g_object_unref0 (self->exposed_windows), _tmp2_);
	self->priv->stage = (_tmp3_ = CLUTTER_STAGE (unity_shell_get_stage ((UnityShell*) owner)), _g_object_unref0 (self->priv->stage), _tmp3_);
	unity_expose_manager_set_hovered_opacity (self, (guint8) 255);
	unity_expose_manager_set_unhovered_opacity (self, (guint8) 255);
	unity_expose_manager_set_darken (self, (guint8) 0);
	return self;
}


UnityExposeManager* unity_expose_manager_new (UnityPlugin* owner, UnityLauncherLauncher* launcher) {
	return unity_expose_manager_construct (UNITY_TYPE_EXPOSE_MANAGER, owner, launcher);
}


static void _unity_expose_manager_on_clone_destroyed_clutter_actor_destroy (ClutterActor* _sender, gpointer self) {
	unity_expose_manager_on_clone_destroyed (self);
}


static void _lambda19_ (Block2Data* _data2_) {
	UnityExposeManager * self;
	self = _data2_->self;
	clutter_actor_destroy ((ClutterActor*) _data2_->_clone);
}


static void __lambda19__clutter_animation_completed (ClutterAnimation* _sender, gpointer self) {
	_lambda19_ (self);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_object_unref0 (_data2_->_clone);
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean _unity_expose_manager_on_stage_captured_event_clutter_actor_captured_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = unity_expose_manager_on_stage_captured_event (self, event);
	return result;
}


void unity_expose_manager_start_expose (UnityExposeManager* self, GSList* windows) {
	GList* _tmp0_;
	GList* children;
	GList* mutter_windows;
	g_return_if_fail (self != NULL);
	self->exposed_windows = (_tmp0_ = NULL, __g_list_free_g_object_unref0 (self->exposed_windows), _tmp0_);
	if (!self->priv->_expose_showing) {
		ClutterGroup* _tmp1_;
		ClutterActor* window_group;
		ClutterActor* _tmp2_;
		if (self->priv->expose_group != NULL) {
			clutter_actor_destroy ((ClutterActor*) self->priv->expose_group);
		}
		self->priv->expose_group = (_tmp1_ = g_object_ref_sink ((ClutterGroup*) clutter_group_new ()), _g_object_unref0 (self->priv->expose_group), _tmp1_);
		window_group = _g_object_ref0 (mutter_plugin_get_window_group (unity_plugin_get_plugin (self->priv->owner)));
		clutter_container_add_actor ((_tmp2_ = window_group, CLUTTER_IS_CONTAINER (_tmp2_) ? ((ClutterContainer*) _tmp2_) : NULL), (ClutterActor*) self->priv->expose_group);
		clutter_actor_raise_top ((ClutterActor*) self->priv->expose_group);
		clutter_actor_show ((ClutterActor*) self->priv->expose_group);
		_g_object_unref0 (window_group);
	}
	children = clutter_container_get_children ((ClutterContainer*) self->priv->expose_group);
	{
		GList* c_collection;
		GList* c_it;
		c_collection = children;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			ClutterActor* c;
			c = _g_object_ref0 ((ClutterActor*) c_it->data);
			{
				ClutterActor* _tmp3_;
				UnityExposeClone* _clone;
				_clone = _g_object_ref0 ((_tmp3_ = c, UNITY_IS_EXPOSE_CLONE (_tmp3_) ? ((UnityExposeClone*) _tmp3_) : NULL));
				_clone->dirty = TRUE;
				_g_object_unref0 (_clone);
				_g_object_unref0 (c);
			}
		}
	}
	{
		GSList* actor_collection;
		GSList* actor_it;
		actor_collection = windows;
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			ClutterActor* actor;
			actor = _g_object_ref0 ((ClutterActor*) actor_it->data);
			{
				gboolean _tmp4_ = FALSE;
				UnityExposeClone* clone;
				gboolean was_existing;
				if (!MUTTER_IS_WINDOW (actor)) {
					_tmp4_ = TRUE;
				} else {
					gboolean _tmp5_ = FALSE;
					gboolean _tmp6_ = FALSE;
					ClutterActor* _tmp7_;
					if (mutter_window_get_window_type ((_tmp7_ = actor, MUTTER_IS_WINDOW (_tmp7_) ? ((MutterWindow*) _tmp7_) : NULL)) != META_COMP_WINDOW_NORMAL) {
						ClutterActor* _tmp8_;
						_tmp6_ = mutter_window_get_window_type ((_tmp8_ = actor, MUTTER_IS_WINDOW (_tmp8_) ? ((MutterWindow*) _tmp8_) : NULL)) != META_COMP_WINDOW_DIALOG;
					} else {
						_tmp6_ = FALSE;
					}
					if (_tmp6_) {
						ClutterActor* _tmp9_;
						_tmp5_ = mutter_window_get_window_type ((_tmp9_ = actor, MUTTER_IS_WINDOW (_tmp9_) ? ((MutterWindow*) _tmp9_) : NULL)) != META_COMP_WINDOW_MODAL_DIALOG;
					} else {
						_tmp5_ = FALSE;
					}
					_tmp4_ = _tmp5_;
				}
				if (_tmp4_) {
					_g_object_unref0 (actor);
					continue;
				}
				clone = NULL;
				was_existing = FALSE;
				{
					GList* c_collection;
					GList* c_it;
					c_collection = children;
					for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
						ClutterActor* c;
						c = _g_object_ref0 ((ClutterActor*) c_it->data);
						{
							ClutterActor* _tmp10_;
							UnityExposeClone* _clone;
							_clone = _g_object_ref0 ((_tmp10_ = c, UNITY_IS_EXPOSE_CLONE (_tmp10_) ? ((UnityExposeClone*) _tmp10_) : NULL));
							if (unity_expose_clone_get_source (_clone) == actor) {
								UnityExposeClone* _tmp11_;
								clone = (_tmp11_ = _g_object_ref0 (_clone), _g_object_unref0 (clone), _tmp11_);
								was_existing = TRUE;
								_clone->dirty = FALSE;
								_g_object_unref0 (_clone);
								_g_object_unref0 (c);
								break;
							}
							_g_object_unref0 (_clone);
							_g_object_unref0 (c);
						}
					}
				}
				if (clone == NULL) {
					UnityExposeClone* _tmp12_;
					clone = (_tmp12_ = g_object_ref_sink (unity_expose_clone_new (actor)), _g_object_unref0 (clone), _tmp12_);
				}
				unity_expose_clone_set_fade_on_close (clone, TRUE);
				if (!was_existing) {
					clutter_actor_set_position ((ClutterActor*) clone, clutter_actor_get_x (actor), clutter_actor_get_y (actor));
					clutter_actor_set_size ((ClutterActor*) clone, clutter_actor_get_width (actor), clutter_actor_get_height (actor));
				}
				self->exposed_windows = g_list_append (self->exposed_windows, _g_object_ref0 (clone));
				clutter_actor_set_reactive ((ClutterActor*) clone, TRUE);
				clutter_container_add_actor ((ClutterContainer*) self->priv->expose_group, (ClutterActor*) clone);
				g_signal_connect_object ((ClutterActor*) clone, "destroy", (GCallback) _unity_expose_manager_on_clone_destroyed_clutter_actor_destroy, self, 0);
				unity_expose_clone_set_hovered_opacity (clone, self->priv->_hovered_opacity);
				unity_expose_clone_set_unhovered_opacity (clone, self->priv->_unhovered_opacity);
				if (!was_existing) {
					gint _tmp13_ = 0;
					if (self->priv->_expose_showing) {
						_tmp13_ = 0;
					} else {
						_tmp13_ = (gint) self->priv->_unhovered_opacity;
					}
					clutter_actor_set_opacity ((ClutterActor*) clone, (guint8) _tmp13_);
				}
				unity_expose_clone_set_darken (clone, self->priv->_darken);
				_g_object_unref0 (clone);
				_g_object_unref0 (actor);
			}
		}
	}
	{
		GList* c_collection;
		GList* c_it;
		c_collection = children;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			ClutterActor* c;
			c = _g_object_ref0 ((ClutterActor*) c_it->data);
			{
				Block2Data* _data2_;
				ClutterActor* _tmp14_;
				_data2_ = g_slice_new0 (Block2Data);
				_data2_->_ref_count_ = 1;
				_data2_->self = g_object_ref (self);
				_data2_->_clone = _g_object_ref0 ((_tmp14_ = c, UNITY_IS_EXPOSE_CLONE (_tmp14_) ? ((UnityExposeClone*) _tmp14_) : NULL));
				if (_data2_->_clone->dirty) {
					ClutterAnimation* anim;
					anim = _g_object_ref0 (clutter_actor_animate ((ClutterActor*) _data2_->_clone, (gulong) CLUTTER_EASE_IN_OUT_SINE, (guint) 250, "scale-x", 0.0f, "scale-y", 0.0f, "opacity", 0, NULL));
					g_signal_connect_data (anim, "completed", (GCallback) __lambda19__clutter_animation_completed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
					_g_object_unref0 (anim);
				}
				_g_object_unref0 (c);
				block2_data_unref (_data2_);
			}
		}
	}
	mutter_windows = mutter_plugin_get_windows (unity_plugin_get_plugin (self->priv->owner));
	{
		GList* w_collection;
		GList* w_it;
		w_collection = mutter_windows;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			MutterWindow* w;
			w = _g_object_ref0 ((MutterWindow*) w_it->data);
			{
				MutterWindow* _tmp15_;
				MutterWindow* _tmp16_;
				if (mutter_window_get_window_type (w) == META_COMP_WINDOW_DESKTOP) {
					_g_object_unref0 (w);
					continue;
				}
				clutter_actor_set_reactive ((_tmp15_ = w, CLUTTER_IS_ACTOR (_tmp15_) ? ((ClutterActor*) _tmp15_) : NULL), FALSE);
				clutter_actor_set_opacity ((_tmp16_ = w, CLUTTER_IS_ACTOR (_tmp16_) ? ((ClutterActor*) _tmp16_) : NULL), (guint8) 0);
				_g_object_unref0 (w);
			}
		}
	}
	self->priv->coverflow_index = (guint) 0;
	if (self->priv->_coverflow) {
		unity_expose_manager_position_windows_coverflow (self, self->exposed_windows, (ClutterActor*) ((UnityExposeClone*) g_list_nth_data (self->exposed_windows, self->priv->coverflow_index)));
	} else {
		unity_expose_manager_position_windows_on_grid (self, self->exposed_windows, self->priv->_top_buffer, self->priv->_left_buffer, self->priv->_right_buffer, self->priv->_bottom_buffer);
	}
	if (!self->priv->_expose_showing) {
		unity_expose_manager_set_expose_showing (self, TRUE);
		g_signal_connect_object ((ClutterActor*) self->priv->stage, "captured-event", (GCallback) _unity_expose_manager_on_stage_captured_event_clutter_actor_captured_event, self, 0);
		unity_shell_add_fullscreen_request ((UnityShell*) self->priv->owner, (GObject*) self);
	}
	_g_list_free0 (children);
}


static void unity_expose_manager_on_clone_destroyed (UnityExposeManager* self) {
	GList* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	if ((_tmp1_ = g_list_length (_tmp0_ = clutter_container_get_children ((ClutterContainer*) self->priv->expose_group)) <= 1, _g_list_free0 (_tmp0_), _tmp1_)) {
		unity_expose_manager_end_expose (self);
	}
}


void unity_expose_manager_end_expose (UnityExposeManager* self) {
	GList* mutter_windows;
	gboolean _tmp0_ = FALSE;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	if (!self->priv->_expose_showing) {
		return;
	}
	mutter_windows = mutter_plugin_get_windows (unity_plugin_get_plugin (self->priv->owner));
	{
		GList* window_collection;
		GList* window_it;
		window_collection = mutter_windows;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MutterWindow* window;
			window = _g_object_ref0 ((MutterWindow*) window_it->data);
			{
				gboolean exposed;
				exposed = FALSE;
				{
					GList* clone_collection;
					GList* clone_it;
					clone_collection = self->exposed_windows;
					for (clone_it = clone_collection; clone_it != NULL; clone_it = clone_it->next) {
						UnityExposeClone* clone;
						clone = _g_object_ref0 ((UnityExposeClone*) clone_it->data);
						{
							if (unity_expose_clone_get_source (clone) == CLUTTER_ACTOR (window)) {
								exposed = TRUE;
								_g_object_unref0 (clone);
								break;
							}
							_g_object_unref0 (clone);
						}
					}
				}
				if (!exposed) {
					clutter_actor_animate ((ClutterActor*) window, (gulong) CLUTTER_EASE_IN_OUT_SINE, (guint) 250, "opacity", 255, NULL);
				}
				clutter_actor_set_reactive ((ClutterActor*) window, TRUE);
				_g_object_unref0 (window);
			}
		}
	}
	{
		GList* actor_collection;
		GList* actor_it;
		actor_collection = self->exposed_windows;
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			UnityExposeClone* actor;
			actor = _g_object_ref0 ((UnityExposeClone*) actor_it->data);
			{
				unity_expose_clone_restore_window_position (actor, meta_screen_get_active_workspace_index (mutter_plugin_get_screen (unity_plugin_get_plugin (self->priv->owner))));
				_g_object_unref0 (actor);
			}
		}
	}
	if (UNITY_IS_EXPOSE_CLONE (self->priv->last_selected_clone)) {
		_tmp0_ = MUTTER_IS_WINDOW (unity_expose_clone_get_source (self->priv->last_selected_clone));
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		UnityExposeClone* clone;
		guint32 time_ = 0U;
		ClutterActor* _tmp1_;
		MetaWindow* meta;
		UnityExposeClone* _tmp2_;
		clone = _g_object_ref0 (self->priv->last_selected_clone);
		clutter_actor_raise_top ((ClutterActor*) clone);
		meta = mutter_window_get_meta_window ((_tmp1_ = unity_expose_clone_get_source (clone), MUTTER_IS_WINDOW (_tmp1_) ? ((MutterWindow*) _tmp1_) : NULL));
		time_ = meta_display_get_current_time (meta_window_get_display (meta));
		meta_workspace_activate (meta_window_get_workspace (meta), time_);
		meta_window_activate (meta, time_);
		self->priv->last_selected_clone = (_tmp2_ = NULL, _g_object_unref0 (self->priv->last_selected_clone), _tmp2_);
		_g_object_unref0 (clone);
	}
	unity_expose_manager_set_expose_showing (self, FALSE);
	unity_shell_remove_fullscreen_request ((UnityShell*) self->priv->owner, (GObject*) self);
	g_signal_parse_name ("captured-event", CLUTTER_TYPE_ACTOR, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((ClutterActor*) self->priv->stage, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _unity_expose_manager_on_stage_captured_event_clutter_actor_captured_event, self);
}


static void unity_expose_manager_position_windows_coverflow (UnityExposeManager* self, GList* windows, ClutterActor* active) {
	ClutterActor* last;
	gint middle_size;
	gint width;
	gint slice_width;
	gint middle_y;
	gint middle_x;
	gint middle_index;
	float scale;
	ClutterActor* _tmp0_;
	gint current_x;
	ClutterActor* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (active != NULL);
	last = NULL;
	middle_size = (gint) (self->priv->owner->primary_monitor.width * 0.8f);
	width = (((gint) self->priv->owner->primary_monitor.width) - self->priv->_left_buffer) - self->priv->_right_buffer;
	slice_width = width / 10;
	middle_y = ((gint) self->priv->owner->primary_monitor.height) / 2;
	middle_x = self->priv->_left_buffer + (width / 2);
	middle_index = g_list_index (windows, active);
	scale = MIN (1.f, (self->priv->owner->primary_monitor.height / 2) / MAX (clutter_actor_get_height (active), clutter_actor_get_width (active)));
	scale = 1.f;
	clutter_actor_set_anchor_point_from_gravity (active, CLUTTER_GRAVITY_CENTER);
	clutter_actor_animate (active, (gulong) CLUTTER_EASE_IN_OUT_SINE, (guint) 250, "x", (float) middle_x, "y", (float) middle_y, "depth", self->priv->owner->primary_monitor.width * (-0.7), "scale-x", scale, "scale-y", scale, "rotation-angle-y", 0.f, NULL);
	clutter_actor_raise_top (active);
	last = (_tmp0_ = _g_object_ref0 (active), _g_object_unref0 (last), _tmp0_);
	current_x = middle_x - middle_size;
	{
		gint i;
		i = middle_index - 1;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				ClutterActor* actor;
				ClutterActor* _tmp2_;
				if (!_tmp1_) {
					i--;
				}
				_tmp1_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				actor = _g_object_ref0 ((ClutterActor*) g_list_nth_data (windows, (guint) i));
				clutter_actor_set_anchor_point_from_gravity (actor, CLUTTER_GRAVITY_CENTER);
				clutter_actor_lower (actor, last);
				scale = MIN (1.f, (self->priv->owner->primary_monitor.height / 2) / MAX (clutter_actor_get_height (actor), clutter_actor_get_width (actor)));
				scale = 1.f;
				clutter_actor_animate (actor, (gulong) CLUTTER_EASE_IN_OUT_SINE, (guint) 250, "x", (float) current_x, "y", (float) middle_y, "depth", self->priv->owner->primary_monitor.width * (-0.7), "scale-x", scale, "scale-y", scale, "rotation-angle-y", 60.f, NULL);
				current_x = current_x - slice_width;
				last = (_tmp2_ = _g_object_ref0 (actor), _g_object_unref0 (last), _tmp2_);
				_g_object_unref0 (actor);
			}
		}
	}
	last = (_tmp3_ = _g_object_ref0 (active), _g_object_unref0 (last), _tmp3_);
	current_x = middle_x + middle_size;
	{
		gint i;
		i = middle_index + 1;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				ClutterActor* actor;
				ClutterActor* _tmp5_;
				if (!_tmp4_) {
					i++;
				}
				_tmp4_ = FALSE;
				if (!(i < g_list_length (windows))) {
					break;
				}
				actor = _g_object_ref0 ((ClutterActor*) g_list_nth_data (windows, (guint) i));
				clutter_actor_set_anchor_point_from_gravity (actor, CLUTTER_GRAVITY_CENTER);
				clutter_actor_lower (actor, last);
				scale = MIN (1.f, (self->priv->owner->primary_monitor.height / 2) / MAX (clutter_actor_get_height (actor), clutter_actor_get_width (actor)));
				scale = 1.f;
				clutter_actor_animate (actor, (gulong) CLUTTER_EASE_IN_OUT_SINE, (guint) 250, "x", (float) current_x, "y", (float) middle_y, "depth", self->priv->owner->primary_monitor.width * (-0.7), "scale-x", scale, "scale-y", scale, "rotation-angle-y", -60.f, NULL);
				current_x = current_x + slice_width;
				last = (_tmp5_ = _g_object_ref0 (actor), _g_object_unref0 (last), _tmp5_);
				_g_object_unref0 (actor);
			}
		}
	}
	_g_object_unref0 (last);
}


static gint unity_expose_manager_direct_comparison (UnityExposeManager* self, void* a, void* b) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	if (a > b) {
		result = 1;
		return result;
	} else {
		if (a < b) {
			result = -1;
			return result;
		}
	}
	result = 0;
	return result;
}


void unity_expose_manager_position_windows_on_grid (UnityExposeManager* self, GList* _windows, gint top_buffer, gint left_buffer, gint right_buffer, gint bottom_buffer) {
	GList* windows;
	gint count;
	gint cols;
	gint rows;
	gint boxWidth;
	gint boxHeight;
	g_return_if_fail (self != NULL);
	if (g_list_length (_windows) < 1) {
		g_warning ("expose-manager.vala:528: There are no windows to position on grid");
		return;
	}
	windows = g_list_copy (_windows);
	windows = g_list_sort (windows, (GCompareFunc) unity_expose_manager_direct_comparison);
	count = (gint) g_list_length (windows);
	cols = (gint) ceil (sqrt ((double) count));
	if (cols < 1) {
		cols = 1;
	}
	rows = 1;
	while (TRUE) {
		if (!((cols * rows) < count)) {
			break;
		}
		rows++;
	}
	boxWidth = (gint) (((self->priv->owner->primary_monitor.width - left_buffer) - right_buffer) / cols);
	boxHeight = (gint) (((self->priv->owner->primary_monitor.height - top_buffer) - bottom_buffer) / rows);
	{
		gint row;
		row = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					row++;
				}
				_tmp0_ = FALSE;
				if (!(row < rows)) {
					break;
				}
				if (row == (rows - 1)) {
					boxWidth = (gint) (((self->priv->owner->primary_monitor.width - left_buffer) - right_buffer) / g_list_length (windows));
				}
				{
					gint col;
					col = 0;
					{
						gboolean _tmp1_;
						_tmp1_ = TRUE;
						while (TRUE) {
							gint centerX;
							gint centerY;
							ClutterActor* window;
							gint windowX;
							gint windowY;
							float scale;
							if (!_tmp1_) {
								col++;
							}
							_tmp1_ = FALSE;
							if (!(col < cols)) {
								break;
							}
							if (g_list_length (windows) == 0) {
								__g_list_free_g_object_unref0 (windows);
								return;
							}
							centerX = ((boxWidth / 2) + (boxWidth * col)) + left_buffer;
							centerY = ((boxHeight / 2) + (boxHeight * row)) + top_buffer;
							window = NULL;
							{
								GList* actor_collection;
								GList* actor_it;
								actor_collection = windows;
								for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
									ClutterActor* actor;
									actor = _g_object_ref0 ((ClutterActor*) actor_it->data);
									{
										double window_distance;
										double actor_distance;
										if (window == NULL) {
											ClutterActor* _tmp2_;
											window = (_tmp2_ = _g_object_ref0 (actor), _g_object_unref0 (window), _tmp2_);
											_g_object_unref0 (actor);
											continue;
										}
										window_distance = sqrt (fabs ((double) (centerX - (clutter_actor_get_x (window) + (clutter_actor_get_width (window) / 2)))) + fabs ((double) (centerY - (clutter_actor_get_y (window) + (clutter_actor_get_height (window) / 2)))));
										actor_distance = sqrt (fabs ((double) (centerX - (clutter_actor_get_x (actor) + (clutter_actor_get_width (actor) / 2)))) + fabs ((double) (centerY - (clutter_actor_get_y (actor) + (clutter_actor_get_height (actor) / 2)))));
										if (actor_distance < window_distance) {
											ClutterActor* _tmp3_;
											window = (_tmp3_ = _g_object_ref0 (actor), _g_object_unref0 (window), _tmp3_);
										}
										_g_object_unref0 (actor);
									}
								}
							}
							windows = g_list_remove (windows, window);
							windowX = centerX - (((gint) clutter_actor_get_width (window)) / 2);
							windowY = centerY - (((gint) clutter_actor_get_height (window)) / 2);
							scale = MIN (MIN ((float) 1, (boxWidth - 20) / clutter_actor_get_width (window)), MIN ((float) 1, (boxHeight - 20) / clutter_actor_get_height (window)));
							g_object_set ((GObject*) window, "scale-gravity", CLUTTER_GRAVITY_CENTER, NULL);
							clutter_actor_animate (window, (gulong) CLUTTER_EASE_IN_OUT_SINE, (guint) 250, "x", (float) windowX, "y", (float) windowY, "scale-x", scale, "scale-y", scale, "opacity", self->priv->_unhovered_opacity, NULL);
							_g_object_unref0 (window);
						}
					}
				}
			}
		}
	}
	__g_list_free_g_object_unref0 (windows);
}


static void unity_expose_manager_handle_event_coverflow (UnityExposeManager* self, ClutterEvent* event) {
	g_return_if_fail (self != NULL);
	if ((*event).type == CLUTTER_KEY_RELEASE) {
		guint16 keycode;
		gboolean _tmp0_ = FALSE;
		keycode = clutter_event_get_key_code (event);
		if (keycode == 113) {
			_tmp0_ = self->priv->coverflow_index > 0;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			self->priv->coverflow_index--;
		} else {
			gboolean _tmp1_ = FALSE;
			if (keycode == 114) {
				_tmp1_ = self->priv->coverflow_index < (g_list_length (self->exposed_windows) - 1);
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				self->priv->coverflow_index++;
			} else {
				if (keycode == 36) {
					UnityExposeClone* clone;
					ClutterActor* _tmp2_;
					MetaWindow* meta;
					clone = _g_object_ref0 ((UnityExposeClone*) g_list_nth_data (self->exposed_windows, self->priv->coverflow_index));
					clutter_actor_raise_top ((ClutterActor*) clone);
					meta = mutter_window_get_meta_window ((_tmp2_ = unity_expose_clone_get_source (clone), MUTTER_IS_WINDOW (_tmp2_) ? ((MutterWindow*) _tmp2_) : NULL));
					meta_workspace_activate (meta_window_get_workspace (meta), clutter_event_get_time (event));
					meta_window_activate (meta, clutter_event_get_time (event));
					unity_expose_manager_end_expose (self);
					_g_object_unref0 (clone);
				}
			}
		}
		unity_expose_manager_position_windows_coverflow (self, self->exposed_windows, (ClutterActor*) ((UnityExposeClone*) g_list_nth_data (self->exposed_windows, self->priv->coverflow_index)));
	}
}


static void unity_expose_manager_handle_event_expose (UnityExposeManager* self, ClutterEvent* event, ClutterActor* actor) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (actor != NULL);
	if ((*event).type == CLUTTER_BUTTON_RELEASE) {
		_tmp0_ = clutter_event_get_button (event) == 1;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ClutterActor* _tmp2_;
		UnityExposeClone* clone;
		gboolean _tmp3_ = FALSE;
		guint _tmp5_;
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			if (clutter_actor_get_parent (actor) != NULL) {
				_tmp1_ = !UNITY_IS_EXPOSE_CLONE (actor);
			} else {
				_tmp1_ = FALSE;
			}
			if (!_tmp1_) {
				break;
			}
			actor = clutter_actor_get_parent (actor);
		}
		clone = _g_object_ref0 ((_tmp2_ = actor, UNITY_IS_EXPOSE_CLONE (_tmp2_) ? ((UnityExposeClone*) _tmp2_) : NULL));
		if (clone != NULL) {
			_tmp3_ = MUTTER_IS_WINDOW (unity_expose_clone_get_source (clone));
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			ClutterActor* _tmp4_;
			MetaWindow* meta;
			clutter_actor_raise_top ((ClutterActor*) clone);
			meta = mutter_window_get_meta_window ((_tmp4_ = unity_expose_clone_get_source (clone), MUTTER_IS_WINDOW (_tmp4_) ? ((MutterWindow*) _tmp4_) : NULL));
			meta_workspace_activate (meta_window_get_workspace (meta), clutter_event_get_time (event));
			meta_window_activate (meta, clutter_event_get_time (event));
		}
		g_signal_parse_name ("captured-event", CLUTTER_TYPE_ACTOR, &_tmp5_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((ClutterActor*) self->priv->stage, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _unity_expose_manager_on_stage_captured_event_clutter_actor_captured_event, self);
		unity_expose_manager_end_expose (self);
		_g_object_unref0 (clone);
	}
}


static void unity_expose_manager_pick_window (UnityExposeManager* self, ClutterEvent* event, ClutterActor* actor) {
	ClutterActor* _tmp1_;
	UnityExposeClone* clone;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (actor != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (clutter_actor_get_parent (actor) != NULL) {
			_tmp0_ = !UNITY_IS_EXPOSE_CLONE (actor);
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		actor = clutter_actor_get_parent (actor);
	}
	clone = _g_object_ref0 ((_tmp1_ = actor, UNITY_IS_EXPOSE_CLONE (_tmp1_) ? ((UnityExposeClone*) _tmp1_) : NULL));
	if (clone != NULL) {
		_tmp2_ = MUTTER_IS_WINDOW (unity_expose_clone_get_source (clone));
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		UnityExposeClone* _tmp3_;
		self->priv->last_selected_clone = (_tmp3_ = _g_object_ref0 (clone), _g_object_unref0 (self->priv->last_selected_clone), _tmp3_);
	} else {
		UnityExposeClone* _tmp4_;
		self->priv->last_selected_clone = (_tmp4_ = NULL, _g_object_unref0 (self->priv->last_selected_clone), _tmp4_);
	}
	_g_object_unref0 (clone);
}


static gboolean unity_expose_manager_on_stage_captured_event (UnityExposeManager* self, ClutterEvent* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	float x = 0.0F;
	float y = 0.0F;
	ClutterActor* actor;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((*event).type == CLUTTER_ENTER) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = (*event).type == CLUTTER_LEAVE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	clutter_event_get_coords (event, &x, &y);
	actor = clutter_stage_get_actor_at_pos (self->priv->stage, CLUTTER_PICK_REACTIVE, (gint) x, (gint) y);
	if ((*event).type == CLUTTER_BUTTON_PRESS) {
		unity_expose_manager_pick_window (self, event, actor);
	}
	if (self->priv->_coverflow) {
		unity_expose_manager_handle_event_coverflow (self, event);
	} else {
		unity_expose_manager_handle_event_expose (self, event, actor);
	}
	result = TRUE;
	return result;
}


gboolean unity_expose_manager_get_expose_showing (UnityExposeManager* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_expose_showing;
	return result;
}


static void unity_expose_manager_set_expose_showing (UnityExposeManager* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_expose_showing = value;
	g_object_notify ((GObject *) self, "expose-showing");
}


gboolean unity_expose_manager_get_coverflow (UnityExposeManager* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_coverflow;
	return result;
}


void unity_expose_manager_set_coverflow (UnityExposeManager* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_coverflow = value;
	g_object_notify ((GObject *) self, "coverflow");
}


gint unity_expose_manager_get_left_buffer (UnityExposeManager* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_left_buffer;
	return result;
}


void unity_expose_manager_set_left_buffer (UnityExposeManager* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_left_buffer = value;
	g_object_notify ((GObject *) self, "left-buffer");
}


gint unity_expose_manager_get_right_buffer (UnityExposeManager* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_right_buffer;
	return result;
}


void unity_expose_manager_set_right_buffer (UnityExposeManager* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_right_buffer = value;
	g_object_notify ((GObject *) self, "right-buffer");
}


gint unity_expose_manager_get_top_buffer (UnityExposeManager* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_top_buffer;
	return result;
}


void unity_expose_manager_set_top_buffer (UnityExposeManager* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_top_buffer = value;
	g_object_notify ((GObject *) self, "top-buffer");
}


gint unity_expose_manager_get_bottom_buffer (UnityExposeManager* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_bottom_buffer;
	return result;
}


void unity_expose_manager_set_bottom_buffer (UnityExposeManager* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_bottom_buffer = value;
	g_object_notify ((GObject *) self, "bottom-buffer");
}


guint8 unity_expose_manager_get_hovered_opacity (UnityExposeManager* self) {
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_hovered_opacity;
	return result;
}


void unity_expose_manager_set_hovered_opacity (UnityExposeManager* self, guint8 value) {
	g_return_if_fail (self != NULL);
	self->priv->_hovered_opacity = value;
	g_object_notify ((GObject *) self, "hovered-opacity");
}


guint8 unity_expose_manager_get_unhovered_opacity (UnityExposeManager* self) {
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_unhovered_opacity;
	return result;
}


void unity_expose_manager_set_unhovered_opacity (UnityExposeManager* self, guint8 value) {
	g_return_if_fail (self != NULL);
	self->priv->_unhovered_opacity = value;
	g_object_notify ((GObject *) self, "unhovered-opacity");
}


guint8 unity_expose_manager_get_darken (UnityExposeManager* self) {
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_darken;
	return result;
}


void unity_expose_manager_set_darken (UnityExposeManager* self, guint8 value) {
	g_return_if_fail (self != NULL);
	self->priv->_darken = value;
	g_object_notify ((GObject *) self, "darken");
}


static GObject * unity_expose_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityExposeManager * self;
	parent_class = G_OBJECT_CLASS (unity_expose_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_EXPOSE_MANAGER (obj);
	{
	}
	return obj;
}


static void unity_expose_manager_class_init (UnityExposeManagerClass * klass) {
	unity_expose_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityExposeManagerPrivate));
	G_OBJECT_CLASS (klass)->get_property = unity_expose_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_expose_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_expose_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_expose_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_MANAGER_EXPOSE_SHOWING, g_param_spec_boolean ("expose-showing", "expose-showing", "expose-showing", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_MANAGER_COVERFLOW, g_param_spec_boolean ("coverflow", "coverflow", "coverflow", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_MANAGER_LEFT_BUFFER, g_param_spec_int ("left-buffer", "left-buffer", "left-buffer", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_MANAGER_RIGHT_BUFFER, g_param_spec_int ("right-buffer", "right-buffer", "right-buffer", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_MANAGER_TOP_BUFFER, g_param_spec_int ("top-buffer", "top-buffer", "top-buffer", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_MANAGER_BOTTOM_BUFFER, g_param_spec_int ("bottom-buffer", "bottom-buffer", "bottom-buffer", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_MANAGER_HOVERED_OPACITY, g_param_spec_uchar ("hovered-opacity", "hovered-opacity", "hovered-opacity", 0, G_MAXUINT8, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_MANAGER_UNHOVERED_OPACITY, g_param_spec_uchar ("unhovered-opacity", "unhovered-opacity", "unhovered-opacity", 0, G_MAXUINT8, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_EXPOSE_MANAGER_DARKEN, g_param_spec_uchar ("darken", "darken", "darken", 0, G_MAXUINT8, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void unity_expose_manager_instance_init (UnityExposeManager * self) {
	self->priv = UNITY_EXPOSE_MANAGER_GET_PRIVATE (self);
	self->priv->last_selected_clone = NULL;
}


static void unity_expose_manager_finalize (GObject* obj) {
	UnityExposeManager * self;
	self = UNITY_EXPOSE_MANAGER (obj);
	__g_list_free_g_object_unref0 (self->exposed_windows);
	_g_object_unref0 (self->priv->expose_group);
	_g_object_unref0 (self->priv->owner);
	_g_object_unref0 (self->priv->stage);
	_g_object_unref0 (self->priv->launcher);
	_g_object_unref0 (self->priv->last_selected_clone);
	G_OBJECT_CLASS (unity_expose_manager_parent_class)->finalize (obj);
}


GType unity_expose_manager_get_type (void) {
	static volatile gsize unity_expose_manager_type_id__volatile = 0;
	if (g_once_init_enter (&unity_expose_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityExposeManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_expose_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityExposeManager), 0, (GInstanceInitFunc) unity_expose_manager_instance_init, NULL };
		GType unity_expose_manager_type_id;
		unity_expose_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityExposeManager", &g_define_type_info, 0);
		g_once_init_leave (&unity_expose_manager_type_id__volatile, unity_expose_manager_type_id);
	}
	return unity_expose_manager_type_id__volatile;
}


static void unity_expose_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityExposeManager * self;
	self = UNITY_EXPOSE_MANAGER (object);
	switch (property_id) {
		case UNITY_EXPOSE_MANAGER_EXPOSE_SHOWING:
		g_value_set_boolean (value, unity_expose_manager_get_expose_showing (self));
		break;
		case UNITY_EXPOSE_MANAGER_COVERFLOW:
		g_value_set_boolean (value, unity_expose_manager_get_coverflow (self));
		break;
		case UNITY_EXPOSE_MANAGER_LEFT_BUFFER:
		g_value_set_int (value, unity_expose_manager_get_left_buffer (self));
		break;
		case UNITY_EXPOSE_MANAGER_RIGHT_BUFFER:
		g_value_set_int (value, unity_expose_manager_get_right_buffer (self));
		break;
		case UNITY_EXPOSE_MANAGER_TOP_BUFFER:
		g_value_set_int (value, unity_expose_manager_get_top_buffer (self));
		break;
		case UNITY_EXPOSE_MANAGER_BOTTOM_BUFFER:
		g_value_set_int (value, unity_expose_manager_get_bottom_buffer (self));
		break;
		case UNITY_EXPOSE_MANAGER_HOVERED_OPACITY:
		g_value_set_uchar (value, unity_expose_manager_get_hovered_opacity (self));
		break;
		case UNITY_EXPOSE_MANAGER_UNHOVERED_OPACITY:
		g_value_set_uchar (value, unity_expose_manager_get_unhovered_opacity (self));
		break;
		case UNITY_EXPOSE_MANAGER_DARKEN:
		g_value_set_uchar (value, unity_expose_manager_get_darken (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_expose_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityExposeManager * self;
	self = UNITY_EXPOSE_MANAGER (object);
	switch (property_id) {
		case UNITY_EXPOSE_MANAGER_EXPOSE_SHOWING:
		unity_expose_manager_set_expose_showing (self, g_value_get_boolean (value));
		break;
		case UNITY_EXPOSE_MANAGER_COVERFLOW:
		unity_expose_manager_set_coverflow (self, g_value_get_boolean (value));
		break;
		case UNITY_EXPOSE_MANAGER_LEFT_BUFFER:
		unity_expose_manager_set_left_buffer (self, g_value_get_int (value));
		break;
		case UNITY_EXPOSE_MANAGER_RIGHT_BUFFER:
		unity_expose_manager_set_right_buffer (self, g_value_get_int (value));
		break;
		case UNITY_EXPOSE_MANAGER_TOP_BUFFER:
		unity_expose_manager_set_top_buffer (self, g_value_get_int (value));
		break;
		case UNITY_EXPOSE_MANAGER_BOTTOM_BUFFER:
		unity_expose_manager_set_bottom_buffer (self, g_value_get_int (value));
		break;
		case UNITY_EXPOSE_MANAGER_HOVERED_OPACITY:
		unity_expose_manager_set_hovered_opacity (self, g_value_get_uchar (value));
		break;
		case UNITY_EXPOSE_MANAGER_UNHOVERED_OPACITY:
		unity_expose_manager_set_unhovered_opacity (self, g_value_get_uchar (value));
		break;
		case UNITY_EXPOSE_MANAGER_DARKEN:
		unity_expose_manager_set_darken (self, g_value_get_uchar (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




