/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@gmail.com>
 *
 */

namespace Unity.ApplicationsPlace {

  public enum ResultsColumn
  {
    URI = 0,
    ICON_HINT,
    GROUP_ID,
    MIMETYPE,
    DISPLAY_NAME,
    COMMENT
  }
  
  public enum SectionsColumn
  {
    DISPLAY_NAME = 0,
    ICON_HINT
  }
  
  public enum Section
  {
    ALL_APPLICATIONS = 0,
    ACCESSORIES,
    UNIVERSAL_ACCESS,
    DEVELOPER_TOOLS,
    EDUCATION,
    SCIENCE,
    GAMES,
    GRAPHICS,
    INTERNET,
    MULTIMEDIA,
    OFFICE,
    THEMES,
    SYSTEM,
    LAST_SECTION
  }
  
  public enum GroupsColumn
  {
    RENDERER = 0,
    DISPLAY_NAME,
    ICON_HINT
  }
  
  public enum Group
  {
    MOST_USED,
    INSTALLED,
    AVAILABLE,
    EMPTY_SEARCH,
    EMPTY_SECTION
  }
  
  public enum RunnerGroup
  {
    RESULTS,
    HISTORY
  }
}
