// -*- mode: js; js-indent-level: 4; indent-tabs-mode: nil -*-
var Cu = Components.utils;
var Ci = Components.interfaces;
var Cc = Components.classes;
var Cr = Components.results;

Cu.import("resource://gre/modules/PopupNotifications.jsm");
Cu.import("resource://unity/l10n.js");

UnityPopupManager = function (mainWindow) {
    this.mainWindow = mainWindow;
}

UnityPopupManager.prototype.requestIntegration = function (document, name, domain, integrateCallback, dontAskActionCallback) {
    var message = l10n.formatMessage('prompt.message', [name, domain]);

    return this.mainWindow.PopupNotifications.show(this.mainWindow.gBrowser.getBrowserForDocument(document),
						   "unity-permission-popup",
						   message,
						   null,
						   { label: l10n.formatMessage('prompt.yes'),
						     accessKey: l10n.formatMessage('prompt.yesAccessKey'),
						     callback: integrateCallback },
						   [
						       { label: l10n.formatMessage('prompt.no'),
							 accessKey: l10n.formatMessage('prompt.noAccessKey'),
							 callback: new Function() },

						       { label: l10n.formatMessage('prompt.dontask'),
							 accessKey: l10n.formatMessage('prompt.dontaskAccessKey'),
							 callback: dontAskActionCallback }
						   ]);


}

var EXPORTED_SYMBOLS = ["UnityPopupManager"];
