from ConfigParser import ConfigParser

from tests.platform.linux.test_dbus import DBusTwistedTestCase
from ubuntuone.syncdaemon import config

class TestDBusConfig(DBusTwistedTestCase):

    def test_get_throttling_limits(self):
        """Test getting throttling limits"""
        dbus_config = self.main.external.dbus_iface.config
        limits = dbus_config.get_throttling_limits()
        self.assertEquals(limits['download'], -1)
        self.assertEquals(limits['upload'], -1)

    def test_set_throttling_limits(self):
        """Test setting throttling limits"""
        dbus_config = self.main.external.dbus_iface.config
        dbus_config.set_throttling_limits(10, 20)
        limits = dbus_config.get_throttling_limits()
        self.assertEquals(limits['download'], 10)
        self.assertEquals(limits['upload'], 20)
        conf = ConfigParser()
        conf.read(config.get_user_config().config_file)
        self.assertEquals(conf.get(config.THROTTLING, 'read_limit'), '10')
        self.assertEquals(conf.get(config.THROTTLING, 'write_limit'), '20')

    def test_enable_bandwidth_throttling(self):
        """Test for enabling bandwidth throttling"""
        dbus_config = self.main.external.dbus_iface.config
        enabled = dbus_config.bandwidth_throttling_enabled()
        self.assertFalse(enabled)
        dbus_config.enable_bandwidth_throttling()
        enabled = dbus_config.bandwidth_throttling_enabled()
        self.assertTrue(enabled)
        conf = ConfigParser()
        conf.read(config.get_user_config().config_file)
        self.assertEquals(conf.get(config.THROTTLING, 'on'), 'True')

    def test_disable_bandwidth_throttling(self):
        """Test for disabling bandwidth throttling"""
        dbus_config = self.main.external.dbus_iface.config
        enabled = dbus_config.bandwidth_throttling_enabled()
        self.assertFalse(enabled)
        # enable throttling
        dbus_config.enable_bandwidth_throttling()
        enabled = dbus_config.bandwidth_throttling_enabled()
        self.assertTrue(enabled)
        # now disable throttling and check
        dbus_config.disable_bandwidth_throttling()
        enabled = dbus_config.bandwidth_throttling_enabled()
        self.assertFalse(enabled)
        conf = ConfigParser()
        conf.read(config.get_user_config().config_file)
        self.assertEquals(conf.get(config.THROTTLING, 'on'), 'False')

    def test_files_sync_enabled(self):
        """Test for toggling files sync."""
        dbus_config = self.main.external.dbus_iface.config
        enabled = dbus_config.files_sync_enabled()
        self.assertTrue(enabled)
        dbus_config.set_files_sync_enabled(False)
        enabled = dbus_config.files_sync_enabled()
        self.assertFalse(enabled)
        dbus_config.set_files_sync_enabled(True)
        enabled = dbus_config.files_sync_enabled()
        self.assertTrue(enabled)
        conf = ConfigParser()
        conf.read(config.get_user_config().config_file)
        self.assertEquals(conf.get(config.MAIN, 'files_sync_enabled'), 'True')
