#ifndef UBUNTULOOKS_TYPES_H
#define UBUNTULOOKS_TYPES_H

typedef unsigned char boolean;
typedef unsigned char uint8;

typedef enum
{
	CL_STATE_NORMAL,
	CL_STATE_ACTIVE,
	CL_STATE_PRELIGHT,
	CL_STATE_SELECTED,
	CL_STATE_INSENSITIVE
} UbuntulooksStateType;

typedef enum
{
	CL_CORNER_NONE        = 0,
	CL_CORNER_TOPLEFT     = 1,
	CL_CORNER_TOPRIGHT    = 2,
	CL_CORNER_BOTTOMLEFT  = 4,
	CL_CORNER_BOTTOMRIGHT = 8,
	CL_CORNER_ALL         = 15
} UbuntulooksCorners;

typedef enum
{
	CL_JUNCTION_NONE      = 0,
	CL_JUNCTION_BEGIN     = 1,
	CL_JUNCTION_END       = 2
} UbuntulooksJunction;

typedef enum
{
	CL_STEPPER_UNKNOWN    = 0,
	CL_STEPPER_A          = 1,
	CL_STEPPER_B          = 2,
	CL_STEPPER_C          = 4,
	CL_STEPPER_D          = 8
} UbuntulooksStepper;

typedef enum
{
	CL_ORDER_FIRST,
	CL_ORDER_MIDDLE,
	CL_ORDER_LAST
} UbuntulooksOrder;

typedef enum
{
	CL_ORIENTATION_LEFT_TO_RIGHT,
	CL_ORIENTATION_RIGHT_TO_LEFT,
	CL_ORIENTATION_BOTTOM_TO_TOP,
	CL_ORIENTATION_TOP_TO_BOTTOM
} UbuntulooksOrientation;

typedef enum
{
	CL_GAP_LEFT,
	CL_GAP_RIGHT,
	CL_GAP_TOP,
	CL_GAP_BOTTOM
} UbuntulooksGapSide;

typedef enum
{
	CL_SHADOW_NONE,
	CL_SHADOW_IN,
	CL_SHADOW_OUT,
	CL_SHADOW_ETCHED_IN,
	CL_SHADOW_ETCHED_OUT
} UbuntulooksShadowType;

typedef enum
{
	CL_HANDLE_TOOLBAR,
	CL_HANDLE_SPLITTER
} UbuntulooksHandleType;

typedef enum
{
	CL_ARROW_NORMAL,
	CL_ARROW_COMBO
} UbuntulooksArrowType;

typedef enum
{
	CL_DIRECTION_UP,
	CL_DIRECTION_DOWN,
	CL_DIRECTION_LEFT,
	CL_DIRECTION_RIGHT
} UbuntulooksDirection;

typedef enum
{
	CL_PROGRESSBAR_CONTINUOUS,
	CL_PROGRESSBAR_DISCRETE
} UbuntulooksProgressBarStyle;

typedef enum
{
	CL_WINDOW_EDGE_NORTH_WEST,
	CL_WINDOW_EDGE_NORTH,
	CL_WINDOW_EDGE_NORTH_EAST,
	CL_WINDOW_EDGE_WEST,
	CL_WINDOW_EDGE_EAST,
	CL_WINDOW_EDGE_SOUTH_WEST,
	CL_WINDOW_EDGE_SOUTH,
	CL_WINDOW_EDGE_SOUTH_EAST  
} UbuntulooksWindowEdge;

typedef enum
{
	CL_CHECKBUTTON_CHECKED = 1,
	CL_CHECKBUTTON_UNCHECKED = 2,
	CL_CHECKBUTTON_INCONSISTENT = 3,
} UbuntulooksCheckButtonState;

typedef struct
{
	double r;
	double g;
	double b;
} CairoColor;

typedef struct
{
	double x;
	double y;
	double width;
	double height;
} UbuntulooksRectangle;

typedef struct
{
	CairoColor bg[5];
	CairoColor base[5];
	CairoColor text[5];
	
	CairoColor shade[9];
	CairoColor spot[3];
} UbuntulooksColors;

typedef struct
{
	boolean active;
	boolean prelight;
	boolean disabled;
	boolean focus;
	boolean is_default;
	boolean enable_glow;
	boolean rtl;
	
	UbuntulooksStateType state_type;
	
	uint8 corners;
	uint8 xthickness;
	uint8 ythickness;

	CairoColor parentbg;
} WidgetParameters;

typedef struct
{
	boolean inverted;
	int     fill_size;
	boolean horizontal;
} SliderParameters;

typedef struct
{
	UbuntulooksOrientation orientation;
	UbuntulooksProgressBarStyle style;
} ProgressBarParameters;

typedef struct
{
	int linepos;
} OptionMenuParameters;

typedef struct
{
	UbuntulooksShadowType shadow;
	UbuntulooksGapSide gap_side;
	int gap_x;
	int gap_width;
	CairoColor *border;
} FrameParameters;

typedef struct
{
	UbuntulooksGapSide gap_side;
} TabParameters;

typedef struct
{
	UbuntulooksCorners    corners;
	UbuntulooksShadowType shadow;
} ShadowParameters;

typedef struct
{
	boolean horizontal;
} SeparatorParameters;

typedef struct
{
	UbuntulooksOrder order;
	boolean         resizable;
} ListViewHeaderParameters;

typedef struct
{
	CairoColor         color;
	UbuntulooksJunction junction;       /* On which sides the slider junctions */
	UbuntulooksStepper  steppers;       /* The visible steppers */
	boolean            horizontal;
	boolean            has_color;
} ScrollBarParameters;

typedef struct
{
	UbuntulooksHandleType type;
	boolean              horizontal; 
} HandleParameters;

typedef struct
{
	UbuntulooksStepper stepper;         /* Which stepper to draw */
} ScrollBarStepperParameters;

typedef struct
{
	UbuntulooksArrowType type;
	UbuntulooksDirection direction;
} ArrowParameters;

typedef struct
{
	UbuntulooksWindowEdge edge;
} ResizeGripParameters;

typedef struct
{
	UbuntulooksShadowType shadow_type;
	boolean              in_cell;
	boolean              in_menu;
} CheckboxParameters;


#define UBUNTULOOKS_RECTANGLE_SET(rect, _x, _y, _w, _h) rect.x      = _x; \
                                                       rect.y      = _y; \
                                                       rect.width  = _w; \
                                                       rect.height = _h;

#endif /* UBUNTULOOKS_TYPES_H */
