:: Author: Manuel de la Pena <manuel@canonical.com>
::
:: Copyright 2010 Canonical Ltd.
::
:: This program is free software: you can redistribute it and/or modify it
:: under the terms of the GNU General Public License version 3, as published
:: by the Free Software Foundation.
::
:: This program is distributed in the hope that it will be useful, but
:: WITHOUT ANY WARRANTY; without even the implied warranties of
:: MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
:: PURPOSE.  See the GNU General Public License for more details.
::
:: You should have received a copy of the GNU General Public License along
:: with this program.  If not, see <http://www.gnu.org/licenses/>.
@ECHO off
:: We could have Python 2.6 or 2.7 on Windows. In order to check availability,
:: we should first check for 2.7, and run the tests, otherwise fall back to 2.6.
SET PYTHONEXEPATH=""
:: This is very annoying; FOR /F will work differently depending on the output
:: of reg which is not consistent between OS versions (XP, 7). We must choose
:: the tokens according to OS version.
SET PYTHONPATHTOKENS=3
VER | FIND "XP" > nul
IF %ERRORLEVEL% == 0 SET PYTHONPATHTOKENS=4
ECHO Checking if python 2.7 is in the system
:: Look for python 2.7
FOR /F "tokens=%PYTHONPATHTOKENS%" %%A IN ('REG QUERY HKLM\Software\Python\PythonCore\2.7\InstallPath /ve') DO @SET PYTHONEXEPATH=%%A
IF NOT %PYTHONEXEPATH% == "" GOTO :PYTHONPRESENT
ECHO Checking if python 2.6 is in the system
:: we do not have python 2.7 in the system, try to find 2.6
FOR /F "tokens=%PYTHONPATHTOKENS%" %%A IN ('REG QUERY HKLM\Software\Python\PythonCore\2.6\InstallPath /ve') DO @SET PYTHONEXEPATH=%%A
IF NOT %PYTHONEXEPATH% == "" GOTO :PYTHONPRESENT

:: we do not have python (2.6 or 2.7) this could hapen in the case  that the
:: user installed the 32version in a 64 machine, let check if the software was installed in the wow key

:: Look for python 2.7 in WoW64
ECHO Checking if python 2.7 32 is in the system
FOR /F "tokens=%PYTHONPATHTOKENS%" %%A IN ('REG QUERY HKLM\Software\Wow6432Node\Python\PythonCore\2.7\InstallPath /ve') DO @SET PYTHONEXEPATH=%%A
IF NOT %PYTHONEXEPATH% == "" GOTO :PYTHONPRESENT
ECHO Checking if python 2.6 32 is in the system
:: we do not have python 2.7 in the system, try to find 2.6
FOR /F "tokens=%PYTHONPATHTOKENS%" %%A IN ('REG QUERY HKLM\Software\Wow6432Node\Python\PythonCore\2.6\InstallPath /ve') DO @SET PYTHONEXEPATH=%%A
IF NOT %PYTHONEXEPATH% == "" GOTO :PYTHONPRESENT

ECHO Please ensure you have python installed
GOTO :END


:PYTHONPRESENT
ECHO Python found, building auto-generated modules...
:: call setup.py build so that the qt uic is called
::START "Build code" /D%CD% /WAIT "%PYTHONEXEPATH%\python.exe" setup.py build
"%PYTHONEXEPATH%\python.exe" setup.py build
ECHO Running tests
:: execute the tests with a number of ignored linux only modules
"%PYTHONEXEPATH%\python.exe" "%PYTHONEXEPATH%\Scripts\u1trial" -c ubuntu_sso -i "test_gui.py, test_linux.py, test_txsecrets.py" --reactor=qt4 --gui %*
:: Clean the build from the setupt.py
ECHO Cleaning the generated code before running the style checks...
"%PYTHONEXEPATH%\python.exe" setup.py clean
ECHO Performing style checks...
SET IGNORE_LINT="ubuntu_sso\gtk,ubuntu_sso\networkstate\linux.py,ubuntu_sso\main\linux.py,ubuntu_sso\main\tests\test_linux.py,ubuntu_sso\utils\txsecrets.py,ubuntu_sso\utils\tests\test_txsecrets.py,ubuntu_sso\tests\bin,bin\ubuntu-sso-login"
"%PYTHONEXEPATH%\python.exe" "%PYTHONEXEPATH%\Scripts\u1lint" -i "%IGNORE_LINT%" ubuntu_sso
:: test for style if we can, if pep8 is not present, move to the end
"%PYTHONEXEPATH%\Scripts\pep8.exe" --repeat .
:: Delete the temp folders
RMDIR /q /s _trial_temp
RMDIR /q /s .coverage
:END
