#!/usr/bin/env python
# setup.py - Build system for Ubuntu SSO Client package
#
# Author: Natalia B. Bidart <natalia.bidart@canonical.com>
#
# Copyright 2010 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
"""setup.py"""

import os
import sys

try:
    import DistUtilsExtra.auto
    from DistUtilsExtra.command import build_extra
except ImportError:
    print >> sys.stderr, 'To build this program you need '\
                         'https://launchpad.net/python-distutils-extra'
    sys.exit(1)
assert DistUtilsExtra.auto.__version__ >= '2.18', \
       'needs DistUtilsExtra.auto >= 2.18'

from distutils.core import setup
from distutils.spawn import find_executable
from distutils.command import clean, build

# Defining variables for various rules here, similar to a Makefile.am
CLEANFILES = ['data/com.ubuntu.sso.service', 'po/ubuntu-sso-client.pot',
              'MANIFEST']


# XXX: This needs some serious cleanup
class SSOBuild(build_extra.build_extra):
    """Class to build the extra files."""

    description = 'build extra files needed by ubuntu-sso-client'

    def run(self):
        """Do the build."""
        sed = find_executable('sed')
        if sed is None:
            sys.stderr.write('Cannont find sed; required to build')
            sys.exit(-1)

        in_file = 'data/com.ubuntu.sso.service.in'
        out_file = 'data/com.ubuntu.sso.service'
        replaced_path = '/usr/lib/ubuntu-sso-client'

        cmd = "%(cmd)s -e 's|\@libexecdir\@|%(rep)s|g' < %(in)s > %(out)s"
        os.system( cmd %
                  {'cmd' : sed,
                   'rep' : replaced_path,
                   'in' : in_file,
                   'out' : out_file,
                   }
                  )

        # Run the parent build command
        build_extra.build_extra.run(self)


class SSOClean(clean.clean):
    """Class to clean up after the build."""

    description = 'Clean up built files.'

    def run(self):
        """Clean up the built files."""
        for built_file in CLEANFILES:
            if os.path.exists(built_file):
                os.unlink(built_file)

        # Run the parent clean command
        clean.clean.run(self)


DistUtilsExtra.auto.setup(
    name='ubuntu-sso-client',
    version='1.0.9',
    license='GPL v3',
    author='Natalia Bidart',
    author_email='natalia.bidart@canonical.com',
    description='Ubuntu Single Sign-On client',
    long_description='Desktop service to allow applications to sign in' \
        'to Ubuntu services via SSO',
    url='https://launchpad.net/ubuntu-sso-client',
    packages=['ubuntu_sso'],
    data_files=[
        ('share/dbus-1/services', ['data/com.ubuntu.sso.service']),
        ('lib/ubuntu-sso-client', ['bin/ubuntu-sso-login']),
        ('share/ubuntu-sso-client/data', ['data/ui.glade'])],
    cmdclass={
        'build' : SSOBuild,
        'clean' : SSOClean})
