<?
	/**
	 * Create the images for the Firefox preferences dialog in the specified
	 * directory.
	 */
	function createPreferences($dir) {
		renderPreferences($dir.'Options.png', 32);
	}
	
	/**
	 * Render the complete image to a given file.
	 *
	 * The columns are:
	 * General, Privacy, Content, Downloads, Advanced, Tabs
	 *
	 * The rows are:
	 * Normal, Hover
	 */
	function renderPreferences($filename, $size) {
		// define the icons to render
		$icons = array(
			array(CATEGORIES, 'preferences-desktop'),
			array(PLACES, 'privacy'),					// TODO
			array(APPS, 'internet-web-browser'),
			array(MIMETYPES, 'package'),
			array(CATEGORIES, 'applications-system'),
			getTabIcon()
		);
		
		// compose the first rows of the toolbar
		$firstrow = renderRow($icons, $size);
		$highlight = renderHighlight($firstrow);
		
		// create single PNG containing all states
		$states = array($firstrow, $highlight);
		$prefs =
			renderColumnFromPngs(
				$states, count($icons) * $size, $size);
		copy($prefs, $filename);
	}
	
	/**
	 * Patch the preferences CSS file so the colors match Human.
	 */
	function patchPreferences() {
		// don't patch Tango
		global $theme;
		if(TANGO == $theme) {
			return;
		}
		
		$infile = 'classic/global/preferences.css';
		$patchfile = 'custom/prefspatch';
		system("patch $infile < $patchfile"); 
	}
	
	/**
	 * Get the neutral tab icon.
	 */
	function getTabIcon() {
		// return custom icon (TODO)
		return array(PLACES, 'tab');	
	}
	
?>