<?
	/**
	 * Create the images for the Firefox help dialog in the specified
	 * directory.
	 */
	function createHelp($dir) {
		renderHelp($dir.'Toolbar.png', 24);
	}
	
	/**
	 * Render a complete toolbar image to a given file.
	 *
	 * The columns are:
	 * Back, Forward, Home, Print
	 *
	 * The rows are:
	 * Normal, Hover, Disabled
	 */
	function renderHelp($filename, $size) {
		// define the icons to render
		$icons = array(
			array(ACTIONS, 'back'),
			array(ACTIONS, 'forward'),
			array(ACTIONS, 'go-home'),
			array(ACTIONS, 'document-print')
		);
		
		// compose the first rows of the toolbar
		$firstrow = renderRow($icons, $size);
		$highlight = renderHighlight($firstrow);
		$disabled = renderDisabled($firstrow);
		
		// create single PNG containing all states
		$states = array($firstrow, $highlight, $disabled);
		$help =
			renderColumnFromPngs(
				$states, count($icons) * $size, $size);
		copy($help, $filename);
	}
	
?>