/* tracker-main.c generated by valac 0.25.2.3-2bd7, the Vala compiler
 * generated from tracker-main.vala, do not modify */

/*
 * Copyright (C) 2006, Jamie McCracken <jamiemcc@gnome.org>
 * Copyright (C) 2008-2011, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "tracker-store/tracker-config.h"
#include <signal.h>
#include <sys/select.h>
#include "libtracker-common/tracker-common.h"
#include "libtracker-data/tracker-db-interface.h"
#include "libtracker-data/tracker-data-query.h"
#include "libtracker-data/tracker-data-update.h"
#include "libtracker-data/tracker-data-backup.h"
#include "libtracker-sparql/tracker-sparql.h"
#include <locale.h>
#include <glib/gi18n-lib.h>
#include "libtracker-data/tracker-db-config.h"
#include "libtracker-data/tracker-db-manager.h"
#include <gio/gio.h>
#include "libtracker-data/tracker-data-manager.h"
#include "tracker-store/tracker-locale-change.h"
#include "tracker-store/tracker-events.h"
#include "tracker-store/tracker-writeback.h"
#include <gobject/gvaluecollector.h>


#define TRACKER_TYPE_MAIN (tracker_main_get_type ())
#define TRACKER_MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_MAIN, TrackerMain))
#define TRACKER_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_MAIN, TrackerMainClass))
#define TRACKER_IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_MAIN))
#define TRACKER_IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_MAIN))
#define TRACKER_MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_MAIN, TrackerMainClass))

typedef struct _TrackerMain TrackerMain;
typedef struct _TrackerMainClass TrackerMainClass;
typedef struct _TrackerMainPrivate TrackerMainPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TRACKER_TYPE_STATUS (tracker_status_get_type ())
#define TRACKER_STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STATUS, TrackerStatus))
#define TRACKER_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STATUS, TrackerStatusClass))
#define TRACKER_IS_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STATUS))
#define TRACKER_IS_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STATUS))
#define TRACKER_STATUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STATUS, TrackerStatusClass))

typedef struct _TrackerStatus TrackerStatus;
typedef struct _TrackerStatusClass TrackerStatusClass;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _TrackerParamSpecMain TrackerParamSpecMain;

struct _TrackerMain {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerMainPrivate * priv;
};

struct _TrackerMainClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerMain *self);
};

struct _TrackerParamSpecMain {
	GParamSpec parent_instance;
};


static gpointer tracker_main_parent_class = NULL;
static GMainLoop* tracker_main_main_loop;
static GMainLoop* tracker_main_main_loop = NULL;
static gchar* tracker_main_log_filename;
static gchar* tracker_main_log_filename = NULL;
static gboolean tracker_main_shutdown;
static gboolean tracker_main_shutdown = FALSE;
static gboolean tracker_main_version;
static gboolean tracker_main_version = FALSE;
static gint tracker_main_verbosity;
static gint tracker_main_verbosity = 0;
static gboolean tracker_main_force_reindex;
static gboolean tracker_main_force_reindex = FALSE;
static gboolean tracker_main_readonly_mode;
static gboolean tracker_main_readonly_mode = FALSE;
static gboolean tracker_main_in_loop;
static gboolean tracker_main_in_loop = FALSE;

gpointer tracker_main_ref (gpointer instance);
void tracker_main_unref (gpointer instance);
GParamSpec* tracker_param_spec_main (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_value_set_main (GValue* value, gpointer v_object);
void tracker_value_take_main (GValue* value, gpointer v_object);
gpointer tracker_value_get_main (const GValue* value);
GType tracker_main_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_MAIN_DUMMY_PROPERTY
};
#define TRACKER_MAIN_LICENSE "This program is free software and comes without any warranty.\n" \
"It is licensed under version 2 or later of the General Public\n" \
"License which can be viewed at:\n" \
"  http://www.gnu.org/licenses/gpl.txt\n"
#define TRACKER_MAIN_SELECT_CACHE_SIZE 100
#define TRACKER_MAIN_UPDATE_CACHE_SIZE 100
static void tracker_main_sanity_check_option_values (TrackerConfig* config);
static void tracker_main_do_shutdown (void);
static gboolean tracker_main_shutdown_timeout_cb (void);
static void tracker_main_signal_handler (gint signo);
static void tracker_main_initialize_signal_handler (void);
static void _tracker_main_signal_handler_sighandler_t (gint signal);
static void tracker_main_initialize_priority (void);
static gchar** tracker_main_get_writeback_predicates (void);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void tracker_main_config_verbosity_changed_cb (GObject* object, GParamSpec* spec);
static gint tracker_main_main (gchar** args, int args_length1);
void tzset (void);
gboolean tracker_dbus_init (TrackerConfig* config_p);
static void _tracker_main_config_verbosity_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
GType tracker_status_get_type (void) G_GNUC_CONST;
guint tracker_status_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
TrackerStatus* tracker_dbus_register_notifier (void);
TrackerBusyCallback tracker_status_get_callback (TrackerStatus* self, void** result_target, GDestroyNotify* result_target_destroy_notify);
void tracker_store_init (void);
gboolean tracker_dbus_register_objects (void);
gboolean tracker_dbus_register_names (void);
gboolean tracker_dbus_register_prepare_class_signal (void);
static gchar** _tracker_main_get_writeback_predicates_tracker_writeback_get_predicates_func (int* result_length1);
void tracker_store_resume (void);
void tracker_store_shutdown (void);
static gboolean _tracker_main_shutdown_timeout_cb_gsource_func (gpointer self);
void tracker_dbus_shutdown (void);
TrackerMain* tracker_main_new (void);
TrackerMain* tracker_main_construct (GType object_type);
static void tracker_main_finalize (TrackerMain* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry TRACKER_MAIN_entries[5] = {{"version", 'V', 0, G_OPTION_ARG_NONE, &tracker_main_version, "Displays version information", NULL}, {"verbosity", 'v', 0, G_OPTION_ARG_INT, &tracker_main_verbosity, "Logging, 0 = errors only, 1 = minimal, 2 = detailed and 3 = debug (def" \
"ault = 0)", NULL}, {"force-reindex", 'r', 0, G_OPTION_ARG_NONE, &tracker_main_force_reindex, "Force a re-index of all content", NULL}, {"readonly-mode", 'n', 0, G_OPTION_ARG_NONE, &tracker_main_readonly_mode, "Only allow read based actions on the database", NULL}, {NULL}};

static void tracker_main_sanity_check_option_values (TrackerConfig* config) {
	TrackerConfig* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	TrackerConfig* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
#line 56 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_return_if_fail (config != NULL);
#line 57 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_message ("General options:");
#line 58 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp0_ = config;
#line 58 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp1_ = tracker_config_get_verbosity (_tmp0_);
#line 58 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp2_ = _tmp1_;
#line 58 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_message ("  Verbosity  ............................  %d", _tmp2_);
#line 60 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_message ("Store options:");
#line 61 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp4_ = tracker_main_readonly_mode;
#line 61 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp4_) {
#line 61 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp3_ = "yes";
#line 188 "tracker-main.c"
	} else {
#line 61 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp3_ = "no";
#line 192 "tracker-main.c"
	}
#line 61 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_message ("  Readonly mode  ........................  %s", _tmp3_);
#line 62 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp5_ = config;
#line 62 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp6_ = tracker_config_get_graphupdated_delay (_tmp5_);
#line 62 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp7_ = _tmp6_;
#line 62 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_message ("  GraphUpdated Delay ....................  %d", _tmp7_);
#line 204 "tracker-main.c"
}


static void tracker_main_do_shutdown (void) {
	GMainLoop* _tmp0_ = NULL;
#line 66 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp0_ = tracker_main_main_loop;
#line 66 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp0_ != NULL) {
#line 214 "tracker-main.c"
		GMainLoop* _tmp1_ = NULL;
#line 67 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp1_ = tracker_main_main_loop;
#line 67 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_main_loop_quit (_tmp1_);
#line 220 "tracker-main.c"
	}
#line 70 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_shutdown = TRUE;
#line 224 "tracker-main.c"
}


static gboolean tracker_main_shutdown_timeout_cb (void) {
	gboolean result = FALSE;
#line 74 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_critical ("Could not exit in a timely fashion - terminating...");
#line 75 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	exit (1);
#line 73 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	return result;
#line 236 "tracker-main.c"
}


static void tracker_main_signal_handler (gint signo) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
#line 82 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp0_ = tracker_main_in_loop;
#line 82 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp0_) {
#line 83 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		exit (1);
#line 249 "tracker-main.c"
	}
#line 86 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp1_ = signo;
#line 86 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	switch (_tmp1_) {
#line 86 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		case SIGTERM:
#line 86 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		case SIGINT:
#line 259 "tracker-main.c"
		{
			gint _tmp2_ = 0;
			const gchar* _tmp3_ = NULL;
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
			tracker_main_in_loop = TRUE;
#line 90 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
			tracker_main_do_shutdown ();
#line 92 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
			_tmp2_ = signo;
#line 92 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
			_tmp3_ = g_strsignal (_tmp2_);
#line 92 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
			if (_tmp3_ != NULL) {
#line 273 "tracker-main.c"
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				const gchar* _tmp6_ = NULL;
#line 93 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
				g_print ("\n");
#line 94 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
				_tmp4_ = signo;
#line 94 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
				_tmp5_ = signo;
#line 94 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
				_tmp6_ = g_strsignal (_tmp5_);
#line 94 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
				g_print ("Received signal:%d->'%s'", _tmp4_, _tmp6_);
#line 287 "tracker-main.c"
			}
#line 96 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
			break;
#line 291 "tracker-main.c"
		}
		default:
		{
			gint _tmp7_ = 0;
			const gchar* _tmp8_ = NULL;
#line 98 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
			_tmp7_ = signo;
#line 98 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
			_tmp8_ = g_strsignal (_tmp7_);
#line 98 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
			if (_tmp8_ != NULL) {
#line 303 "tracker-main.c"
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				const gchar* _tmp11_ = NULL;
#line 99 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
				g_print ("\n");
#line 100 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
				_tmp9_ = signo;
#line 100 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
				_tmp10_ = signo;
#line 100 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
				_tmp11_ = g_strsignal (_tmp10_);
#line 100 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
				g_print ("Received signal:%d->'%s'", _tmp9_, _tmp11_);
#line 317 "tracker-main.c"
			}
#line 102 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
			break;
#line 321 "tracker-main.c"
		}
	}
}


static void _tracker_main_signal_handler_sighandler_t (gint signal) {
#line 111 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_signal_handler (signal);
#line 330 "tracker-main.c"
}


static void tracker_main_initialize_signal_handler (void) {
	sigset_t empty_mask = {0};
	sigset_t _tmp0_ = {0};
	struct sigaction act = {0};
	sigset_t _tmp1_ = {0};
	struct sigaction _tmp2_ = {0};
	struct sigaction _tmp3_ = {0};
	struct sigaction _tmp4_ = {0};
#line 107 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	memset (&empty_mask, 0, sizeof (sigset_t));
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp0_ = empty_mask;
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	sigemptyset (&_tmp0_);
#line 110 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	memset (&act, 0, sizeof (struct sigaction));
#line 111 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	act.sa_handler = _tracker_main_signal_handler_sighandler_t;
#line 112 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp1_ = empty_mask;
#line 112 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	act.sa_mask = _tmp1_;
#line 113 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	act.sa_flags = 0;
#line 115 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp2_ = act;
#line 115 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	sigaction (SIGTERM, &_tmp2_, NULL);
#line 116 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp3_ = act;
#line 116 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	sigaction (SIGINT, &_tmp3_, NULL);
#line 117 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp4_ = act;
#line 117 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	sigaction (SIGHUP, &_tmp4_, NULL);
#line 370 "tracker-main.c"
}


static void tracker_main_initialize_priority (void) {
#line 122 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_ioprio_init ();
#line 377 "tracker-main.c"
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if ((*length) == (*size)) {
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 388 "tracker-main.c"
	}
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	(*array)[(*length)++] = value;
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	(*array)[*length] = NULL;
#line 394 "tracker-main.c"
}


static gchar** tracker_main_get_writeback_predicates (void) {
	gchar** result = NULL;
	gchar** predicates_to_signal = NULL;
	gint predicates_to_signal_length1 = 0;
	gint _predicates_to_signal_size_ = 0;
	GError * _inner_error_ = NULL;
#line 132 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	predicates_to_signal = NULL;
#line 132 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	predicates_to_signal_length1 = 0;
#line 132 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_predicates_to_signal_size_ = predicates_to_signal_length1;
#line 410 "tracker-main.c"
	{
		TrackerDBCursor* cursor = NULL;
		TrackerDBCursor* _tmp0_ = NULL;
#line 135 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp0_ = tracker_data_query_sparql_cursor ("SELECT ?predicate WHERE { ?predicate tracker:writeback true }", &_inner_error_);
#line 135 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		cursor = _tmp0_;
#line 135 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 420 "tracker-main.c"
			goto __catch5_g_error;
		}
#line 137 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		while (TRUE) {
#line 425 "tracker-main.c"
			gboolean _tmp1_ = FALSE;
			TrackerDBCursor* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			gchar** _tmp4_ = NULL;
			gint _tmp4__length1 = 0;
			TrackerDBCursor* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
#line 137 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
			_tmp2_ = cursor;
#line 137 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
			_tmp3_ = tracker_sparql_cursor_next ((TrackerSparqlCursor*) _tmp2_, NULL, &_inner_error_);
#line 137 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
			_tmp1_ = _tmp3_;
#line 137 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 137 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
				_g_object_unref0 (cursor);
#line 444 "tracker-main.c"
				goto __catch5_g_error;
			}
#line 137 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
			if (!_tmp1_) {
#line 137 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
				break;
#line 451 "tracker-main.c"
			}
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
			_tmp4_ = predicates_to_signal;
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
			_tmp4__length1 = predicates_to_signal_length1;
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
			_tmp5_ = cursor;
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
			_tmp6_ = tracker_sparql_cursor_get_string ((TrackerSparqlCursor*) _tmp5_, 0, NULL);
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
			_tmp7_ = g_strdup (_tmp6_);
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
			_vala_array_add1 (&predicates_to_signal, &predicates_to_signal_length1, &_predicates_to_signal_size_, _tmp7_);
#line 465 "tracker-main.c"
		}
#line 134 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (cursor);
#line 469 "tracker-main.c"
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 134 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		e = _inner_error_;
#line 134 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_inner_error_ = NULL;
#line 141 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp8_ = e;
#line 141 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp9_ = _tmp8_->message;
#line 141 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_critical ("Unable to retrieve tracker:writeback properties: %s", _tmp9_);
#line 134 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_error_free0 (e);
#line 489 "tracker-main.c"
	}
	__finally5:
#line 134 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 134 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		predicates_to_signal = (_vala_array_free (predicates_to_signal, predicates_to_signal_length1, (GDestroyNotify) g_free), NULL);
#line 134 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 134 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_clear_error (&_inner_error_);
#line 134 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		return NULL;
#line 502 "tracker-main.c"
	}
#line 144 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	result = predicates_to_signal;
#line 144 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	return result;
#line 508 "tracker-main.c"
}


static void tracker_main_config_verbosity_changed_cb (GObject* object, GParamSpec* spec) {
	gint verbosity = 0;
	GObject* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
#line 147 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_return_if_fail (object != NULL);
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp0_ = object;
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp1_ = tracker_config_get_verbosity (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TRACKER_TYPE_CONFIG, TrackerConfig));
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp2_ = _tmp1_;
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	verbosity = _tmp2_;
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp4_ = verbosity;
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp4_ > 0) {
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp3_ = "enabling";
#line 537 "tracker-main.c"
	} else {
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp3_ = "disabling";
#line 541 "tracker-main.c"
	}
#line 150 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp5_ = verbosity;
#line 150 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_message ("Log verbosity is set to %d, %s D-Bus client lookup", _tmp5_, _tmp3_);
#line 154 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp6_ = verbosity;
#line 154 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_dbus_enable_client_lookup (_tmp6_ > 0);
#line 551 "tracker-main.c"
}


static void _tracker_main_config_verbosity_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 215 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_config_verbosity_changed_cb (_sender, pspec);
#line 558 "tracker-main.c"
}


static gchar** _tracker_main_get_writeback_predicates_tracker_writeback_get_predicates_func (int* result_length1) {
	gchar** result;
	result = tracker_main_get_writeback_predicates ();
#line 296 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	return result;
#line 567 "tracker-main.c"
}


static gboolean _tracker_main_shutdown_timeout_cb_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_main_shutdown_timeout_cb ();
#line 317 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	return result;
#line 576 "tracker-main.c"
}


static gint tracker_main_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean _tmp6_ = FALSE;
	TrackerConfig* config = NULL;
	TrackerConfig* _tmp7_ = NULL;
	TrackerDBConfig* db_config = NULL;
	TrackerDBConfig* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	TrackerConfig* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	TrackerConfig* _tmp18_ = NULL;
	TrackerConfig* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	TrackerConfig* _tmp21_ = NULL;
	gulong config_verbosity_id = 0UL;
	TrackerConfig* _tmp22_ = NULL;
	gulong _tmp23_ = 0UL;
	TrackerDBManagerFlags flags = 0;
	gboolean _tmp24_ = FALSE;
	TrackerStatus* notifier = NULL;
	TrackerStatus* _tmp26_ = NULL;
	TrackerBusyCallback busy_callback = NULL;
	TrackerStatus* _tmp27_ = NULL;
	void* _tmp28_ = NULL;
	GDestroyNotify _tmp29_ = NULL;
	TrackerBusyCallback _tmp30_ = NULL;
	void* busy_callback_target = NULL;
	GDestroyNotify busy_callback_target_destroy_notify = NULL;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gint chunk_size_mb = 0;
	TrackerDBConfig* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	gsize chunk_size = 0UL;
	gint _tmp36_ = 0;
	gchar* rotate_to = NULL;
	TrackerDBConfig* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	gboolean do_rotating = FALSE;
	gint _tmp41_ = 0;
	gboolean _tmp42_ = FALSE;
	gsize _tmp43_ = 0UL;
	const gchar* _tmp44_ = NULL;
	gint select_cache_size = 0;
	gint update_cache_size = 0;
	gchar* cache_size_s = NULL;
	const gchar* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	gboolean _tmp47_ = FALSE;
	const gchar* _tmp48_ = NULL;
	const gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	gboolean _tmp54_ = FALSE;
	const gchar* _tmp55_ = NULL;
	gboolean is_first_time_index = FALSE;
	gboolean _tmp66_ = FALSE;
	gboolean _tmp67_ = FALSE;
	TrackerConfig* _tmp70_ = NULL;
	gulong _tmp71_ = 0UL;
	gint _tmp72_ = 0;
	gsize _tmp73_ = 0UL;
	GError * _inner_error_ = NULL;
#line 158 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	setlocale (LC_ALL, "");
#line 160 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 161 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 162 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	textdomain (GETTEXT_PACKAGE);
#line 165 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	tzset ();
#line 167 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_verbosity = -1;
#line 660 "tracker-main.c"
	{
		GOptionContext* context = NULL;
		const gchar* _tmp0_ = NULL;
		GOptionContext* _tmp1_ = NULL;
		GOptionContext* _tmp2_ = NULL;
		GOptionContext* _tmp3_ = NULL;
#line 173 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp0_ = _ ("- start the tracker daemon");
#line 173 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp1_ = g_option_context_new (_tmp0_);
#line 173 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		context = _tmp1_;
#line 174 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp2_ = context;
#line 174 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_option_context_add_main_entries (_tmp2_, TRACKER_MAIN_entries, NULL);
#line 175 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp3_ = context;
#line 175 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_option_context_parse (_tmp3_, &args_length1, &args, &_inner_error_);
#line 175 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 175 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
			_g_option_context_free0 (context);
#line 685 "tracker-main.c"
			goto __catch6_g_error;
		}
#line 169 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_option_context_free0 (context);
#line 690 "tracker-main.c"
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 169 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		e = _inner_error_;
#line 169 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_inner_error_ = NULL;
#line 177 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp4_ = e;
#line 177 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp5_ = _tmp4_->message;
#line 177 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_printerr ("Invalid arguments, %s\n", _tmp5_);
#line 178 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		result = 1;
#line 178 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_error_free0 (e);
#line 178 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		return result;
#line 714 "tracker-main.c"
	}
	__finally6:
#line 169 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 169 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 169 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_clear_error (&_inner_error_);
#line 169 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		return 0;
#line 725 "tracker-main.c"
	}
#line 181 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp6_ = tracker_main_version;
#line 181 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp6_) {
#line 183 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_print ("%s", "\nTracker " PACKAGE_VERSION "\n\n" TRACKER_MAIN_LICENSE "\n");
#line 184 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		result = 0;
#line 184 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		return result;
#line 737 "tracker-main.c"
	}
#line 187 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_initialize_signal_handler ();
#line 190 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_initialize_priority ();
#line 193 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp7_ = tracker_config_new ();
#line 193 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	config = _tmp7_;
#line 194 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp8_ = tracker_db_config_new ();
#line 194 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	db_config = _tmp8_;
#line 197 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp9_ = tracker_main_verbosity;
#line 197 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp9_ > (-1)) {
#line 755 "tracker-main.c"
		TrackerConfig* _tmp10_ = NULL;
		gint _tmp11_ = 0;
#line 198 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp10_ = config;
#line 198 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp11_ = tracker_main_verbosity;
#line 198 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		tracker_config_set_verbosity (_tmp10_, _tmp11_);
#line 764 "tracker-main.c"
	}
#line 202 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp12_ = config;
#line 202 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp13_ = tracker_config_get_verbosity (_tmp12_);
#line 202 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp14_ = _tmp13_;
#line 202 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_log_init (_tmp14_, &_tmp15_);
#line 202 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_free0 (tracker_main_log_filename);
#line 202 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_log_filename = _tmp15_;
#line 203 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp16_ = tracker_main_log_filename;
#line 203 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp16_ != NULL) {
#line 782 "tracker-main.c"
		const gchar* _tmp17_ = NULL;
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp17_ = tracker_main_log_filename;
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_message ("Using log file:'%s'", _tmp17_);
#line 788 "tracker-main.c"
	}
#line 207 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp18_ = config;
#line 207 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_sanity_check_option_values (_tmp18_);
#line 209 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp19_ = config;
#line 209 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp20_ = tracker_dbus_init (_tmp19_);
#line 209 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (!_tmp20_) {
#line 210 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		result = 1;
#line 210 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (db_config);
#line 210 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (config);
#line 210 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		return result;
#line 808 "tracker-main.c"
	}
#line 214 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp21_ = config;
#line 214 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_config_verbosity_changed_cb ((GObject*) _tmp21_, NULL);
#line 215 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp22_ = config;
#line 215 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp23_ = g_signal_connect ((GObject*) _tmp22_, "notify::verbosity", (GCallback) _tracker_main_config_verbosity_changed_cb_g_object_notify, NULL);
#line 215 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	config_verbosity_id = _tmp23_;
#line 217 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	flags = TRACKER_DB_MANAGER_REMOVE_CACHE;
#line 219 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp24_ = tracker_main_force_reindex;
#line 219 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp24_) {
#line 826 "tracker-main.c"
		TrackerDBManagerFlags _tmp25_ = 0;
#line 223 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp25_ = flags;
#line 223 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		flags = _tmp25_ | TRACKER_DB_MANAGER_FORCE_REINDEX;
#line 832 "tracker-main.c"
	}
#line 226 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp26_ = tracker_dbus_register_notifier ();
#line 226 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	notifier = _tmp26_;
#line 227 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp27_ = notifier;
#line 227 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp30_ = tracker_status_get_callback (_tmp27_, &_tmp28_, &_tmp29_);
#line 227 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	busy_callback = _tmp30_;
#line 227 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	busy_callback_target = _tmp28_;
#line 227 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	busy_callback_target_destroy_notify = _tmp29_;
#line 229 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_store_init ();
#line 232 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp31_ = tracker_dbus_register_objects ();
#line 232 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (!_tmp31_) {
#line 233 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		result = 1;
#line 233 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		(busy_callback_target_destroy_notify == NULL) ? NULL : (busy_callback_target_destroy_notify (busy_callback_target), NULL);
#line 233 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		busy_callback = NULL;
#line 233 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		busy_callback_target = NULL;
#line 233 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		busy_callback_target_destroy_notify = NULL;
#line 233 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (notifier);
#line 233 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (db_config);
#line 233 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (config);
#line 233 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		return result;
#line 872 "tracker-main.c"
	}
#line 236 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp32_ = tracker_dbus_register_names ();
#line 236 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (!_tmp32_) {
#line 237 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		result = 1;
#line 237 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		(busy_callback_target_destroy_notify == NULL) ? NULL : (busy_callback_target_destroy_notify (busy_callback_target), NULL);
#line 237 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		busy_callback = NULL;
#line 237 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		busy_callback_target = NULL;
#line 237 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		busy_callback_target_destroy_notify = NULL;
#line 237 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (notifier);
#line 237 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (db_config);
#line 237 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (config);
#line 237 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		return result;
#line 896 "tracker-main.c"
	}
#line 240 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp33_ = db_config;
#line 240 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp34_ = tracker_db_config_get_journal_chunk_size (_tmp33_);
#line 240 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp35_ = _tmp34_;
#line 240 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	chunk_size_mb = _tmp35_;
#line 241 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp36_ = chunk_size_mb;
#line 241 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	chunk_size = (gsize) ((((gsize) _tmp36_) * ((gsize) 1024)) * ((gsize) 1024));
#line 242 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp37_ = db_config;
#line 242 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp38_ = tracker_db_config_get_journal_rotate_destination (_tmp37_);
#line 242 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp39_ = _tmp38_;
#line 242 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	rotate_to = _tmp39_;
#line 244 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp40_ = rotate_to;
#line 244 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (g_strcmp0 (_tmp40_, "") == 0) {
#line 245 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_free0 (rotate_to);
#line 245 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		rotate_to = NULL;
#line 926 "tracker-main.c"
	}
#line 248 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp41_ = chunk_size_mb;
#line 248 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	do_rotating = _tmp41_ != (-1);
#line 250 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp42_ = do_rotating;
#line 250 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp43_ = chunk_size;
#line 250 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp44_ = rotate_to;
#line 250 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_db_journal_set_rotating (_tmp42_, _tmp43_, _tmp44_);
#line 255 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp45_ = g_getenv ("TRACKER_STORE_SELECT_CACHE_SIZE");
#line 255 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp46_ = g_strdup (_tmp45_);
#line 255 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_free0 (cache_size_s);
#line 255 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	cache_size_s = _tmp46_;
#line 256 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp48_ = cache_size_s;
#line 256 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp48_ != NULL) {
#line 952 "tracker-main.c"
		const gchar* _tmp49_ = NULL;
#line 256 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp49_ = cache_size_s;
#line 256 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp47_ = g_strcmp0 (_tmp49_, "") != 0;
#line 958 "tracker-main.c"
	} else {
#line 256 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp47_ = FALSE;
#line 962 "tracker-main.c"
	}
#line 256 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp47_) {
#line 966 "tracker-main.c"
		const gchar* _tmp50_ = NULL;
		gint _tmp51_ = 0;
#line 257 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp50_ = cache_size_s;
#line 257 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp51_ = atoi (_tmp50_);
#line 257 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		select_cache_size = _tmp51_;
#line 975 "tracker-main.c"
	} else {
#line 259 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		select_cache_size = TRACKER_MAIN_SELECT_CACHE_SIZE;
#line 979 "tracker-main.c"
	}
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp52_ = g_getenv ("TRACKER_STORE_UPDATE_CACHE_SIZE");
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp53_ = g_strdup (_tmp52_);
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_free0 (cache_size_s);
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	cache_size_s = _tmp53_;
#line 263 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp55_ = cache_size_s;
#line 263 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp55_ != NULL) {
#line 993 "tracker-main.c"
		const gchar* _tmp56_ = NULL;
#line 263 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp56_ = cache_size_s;
#line 263 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp54_ = g_strcmp0 (_tmp56_, "") != 0;
#line 999 "tracker-main.c"
	} else {
#line 263 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp54_ = FALSE;
#line 1003 "tracker-main.c"
	}
#line 263 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp54_) {
#line 1007 "tracker-main.c"
		const gchar* _tmp57_ = NULL;
		gint _tmp58_ = 0;
#line 264 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp57_ = cache_size_s;
#line 264 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp58_ = atoi (_tmp57_);
#line 264 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		update_cache_size = _tmp58_;
#line 1016 "tracker-main.c"
	} else {
#line 266 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		update_cache_size = TRACKER_MAIN_UPDATE_CACHE_SIZE;
#line 1020 "tracker-main.c"
	}
	{
		TrackerDBManagerFlags _tmp59_ = 0;
		gint _tmp60_ = 0;
		gint _tmp61_ = 0;
		TrackerBusyCallback _tmp62_ = NULL;
		void* _tmp62__target = NULL;
		gboolean _tmp63_ = FALSE;
#line 272 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp59_ = flags;
#line 272 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp60_ = select_cache_size;
#line 272 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp61_ = update_cache_size;
#line 272 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp62_ = busy_callback;
#line 272 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp62__target = busy_callback_target;
#line 272 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		tracker_data_manager_init (_tmp59_, NULL, &_tmp63_, TRUE, FALSE, (guint) _tmp60_, (guint) _tmp61_, _tmp62_, _tmp62__target, "Initializing", &_inner_error_);
#line 272 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		is_first_time_index = _tmp63_;
#line 272 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1045 "tracker-main.c"
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		GError* _tmp64_ = NULL;
		const gchar* _tmp65_ = NULL;
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		e = _inner_error_;
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_inner_error_ = NULL;
#line 282 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp64_ = e;
#line 282 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp65_ = _tmp64_->message;
#line 282 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_critical ("Cannot initialize database: %s", _tmp65_);
#line 283 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		result = 1;
#line 283 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_error_free0 (e);
#line 283 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_free0 (cache_size_s);
#line 283 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_free0 (rotate_to);
#line 283 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		(busy_callback_target_destroy_notify == NULL) ? NULL : (busy_callback_target_destroy_notify (busy_callback_target), NULL);
#line 283 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		busy_callback = NULL;
#line 283 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		busy_callback_target = NULL;
#line 283 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		busy_callback_target_destroy_notify = NULL;
#line 283 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (notifier);
#line 283 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (db_config);
#line 283 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (config);
#line 283 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		return result;
#line 1089 "tracker-main.c"
	}
	__finally7:
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_free0 (cache_size_s);
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_free0 (rotate_to);
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		(busy_callback_target_destroy_notify == NULL) ? NULL : (busy_callback_target_destroy_notify (busy_callback_target), NULL);
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		busy_callback = NULL;
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		busy_callback_target = NULL;
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		busy_callback_target_destroy_notify = NULL;
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (notifier);
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (db_config);
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (config);
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_clear_error (&_inner_error_);
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		return 0;
#line 1118 "tracker-main.c"
	}
#line 286 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_object_unref0 (db_config);
#line 286 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	db_config = NULL;
#line 287 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_object_unref0 (notifier);
#line 287 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	notifier = NULL;
#line 289 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp66_ = tracker_main_shutdown;
#line 289 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (!_tmp66_) {
#line 291 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		tracker_locale_change_initialize_subscription ();
#line 293 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		tracker_dbus_register_prepare_class_signal ();
#line 295 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		tracker_events_init ();
#line 296 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		tracker_writeback_init (_tracker_main_get_writeback_predicates_tracker_writeback_get_predicates_func);
#line 297 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		tracker_store_resume ();
#line 299 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_message ("Waiting for D-Bus requests...");
#line 1144 "tracker-main.c"
	}
#line 305 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp67_ = tracker_main_shutdown;
#line 305 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (!_tmp67_) {
#line 1150 "tracker-main.c"
		GMainLoop* _tmp68_ = NULL;
		GMainLoop* _tmp69_ = NULL;
#line 306 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp68_ = g_main_loop_new (NULL, FALSE);
#line 306 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_g_main_loop_unref0 (tracker_main_main_loop);
#line 306 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		tracker_main_main_loop = _tmp68_;
#line 307 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		_tmp69_ = tracker_main_main_loop;
#line 307 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_main_loop_run (_tmp69_);
#line 1163 "tracker-main.c"
	}
#line 313 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_message ("Shutdown started");
#line 315 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_store_shutdown ();
#line 317 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_timeout_add_full (G_PRIORITY_LOW, (guint) 5000, _tracker_main_shutdown_timeout_cb_gsource_func, NULL, NULL);
#line 319 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_message ("Cleaning up");
#line 322 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_writeback_shutdown ();
#line 323 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_events_shutdown ();
#line 325 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_locale_change_shutdown_subscription ();
#line 327 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_dbus_shutdown ();
#line 328 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_data_manager_shutdown ();
#line 329 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_log_shutdown ();
#line 331 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp70_ = config;
#line 331 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp71_ = config_verbosity_id;
#line 331 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_signal_handler_disconnect ((GObject*) _tmp70_, _tmp71_);
#line 332 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_object_unref0 (config);
#line 332 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	config = NULL;
#line 335 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp72_ = chunk_size_mb;
#line 335 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_tmp73_ = chunk_size;
#line 335 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_db_journal_set_rotating (_tmp72_ != (-1), _tmp73_, NULL);
#line 337 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_print ("\nOK\n\n");
#line 339 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_free0 (tracker_main_log_filename);
#line 339 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_log_filename = NULL;
#line 341 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_main_loop_unref0 (tracker_main_main_loop);
#line 341 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_main_loop = NULL;
#line 343 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	result = 0;
#line 343 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_free0 (cache_size_s);
#line 343 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_free0 (rotate_to);
#line 343 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	(busy_callback_target_destroy_notify == NULL) ? NULL : (busy_callback_target_destroy_notify (busy_callback_target), NULL);
#line 343 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	busy_callback = NULL;
#line 343 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	busy_callback_target = NULL;
#line 343 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	busy_callback_target_destroy_notify = NULL;
#line 343 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_object_unref0 (notifier);
#line 343 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_object_unref0 (db_config);
#line 343 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	_g_object_unref0 (config);
#line 343 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	return result;
#line 1233 "tracker-main.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 157 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	return tracker_main_main (argv, argc);
#line 1243 "tracker-main.c"
}


TrackerMain* tracker_main_construct (GType object_type) {
	TrackerMain* self = NULL;
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	self = (TrackerMain*) g_type_create_instance (object_type);
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	return self;
#line 1253 "tracker-main.c"
}


TrackerMain* tracker_main_new (void) {
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	return tracker_main_construct (TRACKER_TYPE_MAIN);
#line 1260 "tracker-main.c"
}


static void tracker_value_main_init (GValue* value) {
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	value->data[0].v_pointer = NULL;
#line 1267 "tracker-main.c"
}


static void tracker_value_main_free_value (GValue* value) {
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (value->data[0].v_pointer) {
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		tracker_main_unref (value->data[0].v_pointer);
#line 1276 "tracker-main.c"
	}
}


static void tracker_value_main_copy_value (const GValue* src_value, GValue* dest_value) {
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (src_value->data[0].v_pointer) {
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		dest_value->data[0].v_pointer = tracker_main_ref (src_value->data[0].v_pointer);
#line 1286 "tracker-main.c"
	} else {
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1290 "tracker-main.c"
	}
}


static gpointer tracker_value_main_peek_pointer (const GValue* value) {
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	return value->data[0].v_pointer;
#line 1298 "tracker-main.c"
}


static gchar* tracker_value_main_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (collect_values[0].v_pointer) {
#line 1305 "tracker-main.c"
		TrackerMain* object;
		object = collect_values[0].v_pointer;
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		if (object->parent_instance.g_class == NULL) {
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1312 "tracker-main.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1316 "tracker-main.c"
		}
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		value->data[0].v_pointer = tracker_main_ref (object);
#line 1320 "tracker-main.c"
	} else {
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		value->data[0].v_pointer = NULL;
#line 1324 "tracker-main.c"
	}
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	return NULL;
#line 1328 "tracker-main.c"
}


static gchar* tracker_value_main_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerMain** object_p;
	object_p = collect_values[0].v_pointer;
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (!object_p) {
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1339 "tracker-main.c"
	}
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (!value->data[0].v_pointer) {
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		*object_p = NULL;
#line 1345 "tracker-main.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		*object_p = value->data[0].v_pointer;
#line 1349 "tracker-main.c"
	} else {
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		*object_p = tracker_main_ref (value->data[0].v_pointer);
#line 1353 "tracker-main.c"
	}
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	return NULL;
#line 1357 "tracker-main.c"
}


GParamSpec* tracker_param_spec_main (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerParamSpecMain* spec;
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TYPE_MAIN), NULL);
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	return G_PARAM_SPEC (spec);
#line 1371 "tracker-main.c"
}


gpointer tracker_value_get_main (const GValue* value) {
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_MAIN), NULL);
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	return value->data[0].v_pointer;
#line 1380 "tracker-main.c"
}


void tracker_value_set_main (GValue* value, gpointer v_object) {
	TrackerMain* old;
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_MAIN));
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	old = value->data[0].v_pointer;
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (v_object) {
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_MAIN));
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		value->data[0].v_pointer = v_object;
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		tracker_main_ref (value->data[0].v_pointer);
#line 1400 "tracker-main.c"
	} else {
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		value->data[0].v_pointer = NULL;
#line 1404 "tracker-main.c"
	}
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (old) {
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		tracker_main_unref (old);
#line 1410 "tracker-main.c"
	}
}


void tracker_value_take_main (GValue* value, gpointer v_object) {
	TrackerMain* old;
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_MAIN));
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	old = value->data[0].v_pointer;
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (v_object) {
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_MAIN));
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		value->data[0].v_pointer = v_object;
#line 1429 "tracker-main.c"
	} else {
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		value->data[0].v_pointer = NULL;
#line 1433 "tracker-main.c"
	}
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (old) {
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		tracker_main_unref (old);
#line 1439 "tracker-main.c"
	}
}


static void tracker_main_class_init (TrackerMainClass * klass) {
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_parent_class = g_type_class_peek_parent (klass);
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	((TrackerMainClass *) klass)->finalize = tracker_main_finalize;
#line 1449 "tracker-main.c"
}


static void tracker_main_instance_init (TrackerMain * self) {
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	self->ref_count = 1;
#line 1456 "tracker-main.c"
}


static void tracker_main_finalize (TrackerMain* obj) {
	TrackerMain * self;
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_MAIN, TrackerMain);
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_signal_handlers_destroy (self);
#line 1466 "tracker-main.c"
}


GType tracker_main_get_type (void) {
	static volatile gsize tracker_main_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_main_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_value_main_init, tracker_value_main_free_value, tracker_value_main_copy_value, tracker_value_main_peek_pointer, "p", tracker_value_main_collect_value, "p", tracker_value_main_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerMainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerMain), 0, (GInstanceInitFunc) tracker_main_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_main_type_id;
		tracker_main_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerMain", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_main_type_id__volatile, tracker_main_type_id);
	}
	return tracker_main_type_id__volatile;
}


gpointer tracker_main_ref (gpointer instance) {
	TrackerMain* self;
	self = instance;
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	g_atomic_int_inc (&self->ref_count);
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	return instance;
#line 1491 "tracker-main.c"
}


void tracker_main_unref (gpointer instance) {
	TrackerMain* self;
	self = instance;
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		TRACKER_MAIN_GET_CLASS (self)->finalize (self);
#line 21 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-main.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1504 "tracker-main.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



