/* -*- Mode: javascript; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
/* ***** BEGIN LICENSE BLOCK *****
 *	 Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is edsintegration.
 *
 * The Initial Developer of the Original Code is
 * Mozilla Corp.
 * Portions created by the Initial Developer are Copyright (C) 2011
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Mike Conley <mconley@mozilla.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 * ***** END LICENSE BLOCK ***** */

var EXPORTED_SYMBOLS = [ "LibEClient" ];

const Cu = Components.utils;
const Cc = Components.classes;
const Ci = Components.interfaces;

Cu.import("resource://gre/modules/ctypes.jsm");
Cu.import("resource://gre/modules/Services.jsm");
Cu.import("resource://gre/modules/XPCOMUtils.jsm");

Cu.import("resource://edsintegration/LibGLib.jsm");
Cu.import("resource://edsintegration/libedataserver-ctypes.jsm");
Cu.import("resource://edsintegration/LibGCancellable.jsm");
Cu.import("resource://edsintegration/LibGAsyncResult.jsm");
Cu.import("resource://edsintegration/LibECredentials.jsm");
Cu.import("resource://edsintegration/LibESource.jsm");

XPCOMUtils.defineLazyGetter(this, "EClient", function() {
  return ctypes.StructType("EClient");
});


XPCOMUtils.defineLazyGetter(this, "e_client_error_quark", function() {
  var e_client_error_quark =
    libedataserver.declare("e_client_error_quark",
                           ctypes.default_abi,
                           LibGLib.GQuark);

  if (!e_client_error_quark)
    throw "e_client_error_quark unavailable";

  return e_client_error_quark;
});


XPCOMUtils.defineLazyGetter(this, "e_client_get_backend_property", function() {
  var e_client_get_backend_property =
    libedataserver.declare("e_client_get_backend_property",
                           ctypes.default_abi,
                           ctypes.void_t,
                           EClient.ptr,
                           LibGLib.gchar.ptr,
                           LibGCancellable.GCancellable.ptr,
                           LibGAsyncResult.GAsyncReadyCallback,
                           LibGLib.gpointer);
  if (!e_client_get_backend_property)
    throw "e_client_get_backend_property is unavailable";

  return e_client_get_backend_property;
});


XPCOMUtils.defineLazyGetter(this, "e_client_get_backend_property_finish", function() {
  var e_client_get_backend_property_finish =
    libedataserver.declare("e_client_get_backend_property_finish",
                           ctypes.default_abi,
                           LibGLib.gboolean,
                           EClient.ptr,
                           LibGAsyncResult.GAsyncResult.ptr,
                           LibGLib.gchar.ptr.ptr,
                           LibGLib.GError.ptr.ptr);
  if (!e_client_get_backend_property_finish)
    throw "e_client_get_backend_property finish is unavailable";

  return e_client_get_backend_property_finish;
});


XPCOMUtils.defineLazyGetter(this, "e_client_get_source", function() {
  var e_client_get_source =
    libedataserver.declare("e_client_get_source",
                           ctypes.default_abi,
                           LibESource.ESource.ptr,
                           EClient.ptr);
  if (!e_client_get_source)
    throw "e_client_get_source is unavailable";

  return e_client_get_source;
});


XPCOMUtils.defineLazyGetter(this, "e_client_get_uri", function() {
  var e_client_get_uri =
    libedataserver.declare("e_client_get_uri",
                           ctypes.default_abi,
                           LibGLib.gchar.ptr,
                           EClient.ptr);
  if (!e_client_get_uri)
    throw "e_client_get_uri is unavailable";

  return e_client_get_uri;
});


XPCOMUtils.defineLazyGetter(this, "e_client_is_opened", function() {
  var e_client_is_opened =
    libedataserver.declare("e_client_is_opened",
                           ctypes.default_abi,
                           LibGLib.gboolean,
                           EClient.ptr);
  if (!e_client_is_opened)
    throw "e_client_is_opened is unavailable";

  return e_client_is_opened;
});


XPCOMUtils.defineLazyGetter(this, "e_client_is_readonly", function() {
  var e_client_is_readonly =
    libedataserver.declare("e_client_is_readonly",
                           ctypes.default_abi,
                           LibGLib.gboolean,
                           EClient.ptr);
  if (!e_client_is_readonly)
    throw "e_client_is_readonly is unavailable";

  return e_client_is_readonly;
});


XPCOMUtils.defineLazyGetter(this, "e_client_open", function() {
  var e_client_open =
    libedataserver.declare("e_client_open",
                           ctypes.default_abi,
                           ctypes.void_t,
                           EClient.ptr,
                           LibGLib.gboolean,
                           LibGCancellable.GCancellable.ptr,
                           LibGAsyncResult.GAsyncReadyCallback,
                           LibGLib.gpointer);
  if (!e_client_open)
    throw "e_client_open is unavailable";

  return e_client_open;
});


XPCOMUtils.defineLazyGetter(this, "e_client_process_authentication", function() {
  var e_client_process_authentication =
    libedataserver.declare("e_client_process_authentication",
                           ctypes.default_abi,
                           ctypes.void_t,
                           EClient.ptr,
                           LibECredentials.ECredentials.ptr);

  if (!e_client_process_authentication)
    throw "e_client_process_authentication is unavailable";

  return e_client_process_authentication;
});


XPCOMUtils.defineLazyGetter(this, "e_client_open_finish", function() {
  var e_client_open_finish =
    libedataserver.declare("e_client_open_finish",
                           ctypes.default_abi,
                           LibGLib.gboolean,
                           EClient.ptr,
                           LibGAsyncResult.GAsyncResult.ptr,
                           LibGLib.GError.ptr.ptr);

  if (!e_client_open_finish)
    throw "e_client_open_finish is unavailable";

  return e_client_open_finish;
});


XPCOMUtils.defineLazyGetter(this, "e_client_remove_sync", function() {
  var e_client_remove_sync =
    libedataserver.declare("e_client_remove_sync",
                           ctypes.default_abi,
                           LibGLib.gboolean,
                           EClient.ptr,
                           LibGCancellable.GCancellable.ptr,
                           LibGLib.GError.ptr.ptr);

  if (!e_client_remove_sync)
    throw "e_client_remove_sync is unavailable";

  return e_client_remove_sync;
});


var LibEClient = {
  _enums: [
    "E_CLIENT_ERROR_INVALID_ARG",
    "E_CLIENT_ERROR_BUSY",
    "E_CLIENT_ERROR_SOURCE_NOT_LOADED",
    "E_CLIENT_ERROR_SOURCE_ALREADY_LOADED",
    "E_CLIENT_ERROR_AUTHENTICATION_FAILED",
    "E_CLIENT_ERROR_AUTHENTICATION_REQUIRED",
    "E_CLIENT_ERROR_REPOSITORY_OFFLINE",
    "E_CLIENT_ERROR_OFFLINE_UNAVAILABLE",
    "E_CLIENT_ERROR_PERMISSION_DENIED",
    "E_CLIENT_ERROR_CANCELLED",
    "E_CLIENT_ERROR_COULD_NOT_CANCEL",
    "E_CLIENT_ERROR_NOT_SUPPORTED",
    "E_CLIENT_ERROR_TLS_NOT_AVAILABLE",
    "E_CLIENT_ERROR_UNSUPPORTED_AUTHENTICATION_METHOD",
    "E_CLIENT_ERROR_SEARCH_SIZE_LIMIT_EXCEEDED",
    "E_CLIENT_ERROR_SEARCH_TIME_LIMIT_EXCEEDED",
    "E_CLIENT_ERROR_INVALID_QUERY",
    "E_CLIENT_ERROR_QUERY_REFUSED",
    "E_CLIENT_ERROR_DBUS_ERROR",
    "E_CLIENT_ERROR_OTHER_ERROR"],

  EClient: EClient,

  getBackendProperty: function LEC_getBackendProperty(aEClient, aPropName, aGCancellable,
                                                      aCallback, aData) {
    return e_client_get_backend_property(aEClient, aPropName, aGCancellable, aCallback, aData);
  },

  getBackendPropertyFinish: function LEC_getBackendPropertyFinish(aEClient, aResult,
                                                                  aPropPtr, aErrPtr) {
    return e_client_get_backend_property_finish(aEClient, aResult,
                                                aPropPtr, aErrPtr) == LibGLib.TRUE;
  },

  getSource: function LEC_getSource(aEClient) {
    return e_client_get_source(aEClient);
  },

  getUri: function LEC_getUri(aEClient) {
    let result = e_client_get_uri(aEClient);
    if (result.isNull())
      return null;
    return result.readString();
  },

  isOpened: function LEC_isOpened(aEClient) {
    return e_client_is_opened(aEClient) == LibGLib.TRUE;
  },
  
  isReadOnly: function LEC_isReadOnly(aEClient) {
    return e_client_is_readonly(aEClient) == LibGLib.TRUE;
  },

  open: function LEC_open(aEClient, aOnlyIfExists, aCancellable,
                          aCallback, aData) {
    let onlyIfExists = aOnlyIfExists ? LibGLib.TRUE : LibGLib.FALSE;
    return e_client_open(aEClient, aOnlyIfExists, aCancellable,
                         aCallback, aData);
  },

  openFinish: function LEC_openFinish(aEClient, aAsyncResult, aErrPtr) {
    return e_client_open_finish(aEClient, aAsyncResult, aErrPtr) == LibGLib.TRUE;
  },

  processAuth: function LEC_processAuth(aEClient, aECredentials) {
    return e_client_process_authentication(aEClient, aECredentials);
  },

  getEnum: function LEC_getEnum(aEnumString) {
    let index = this._enums.indexOf(aEnumString);
    if (index == -1)
      return null;
    return index;
  },

  errorQuark: function LEC_errorQuark() {
    return e_client_error_quark();
  },

  removeSync: function LEC_removeSync(aEClient, aCancellable, aErrPtr) {
    return e_client_remove_sync(aEClient, aCancellable, aErrPtr)
           == LibGLib.TRUE;
  },

}
