.if t .ds TX T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if t .ds LX L\\h'-0.36m'\\v'-0.15v'\\s-2A\\s+2\\h'-0.15m'\\v'0.15v'T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.TH DVISPC 1
.SH NAME
dvispc \- Modify a DVI file to be page-independent in specials
.SH SYNOPSIS
.B dvispc
[\fB\-c\fR] [\fB\-bvz\fR]
\fIinput_dvi_file\fR [\fIoutput_dvi_file\fR]
.PP
.B dvispc \-d
\fIinput_dvi_file\fR
.PP
.B dvispc \-s
[\fB\-p..\fR] \fIinput_dvi_file\fR [\fIoutput_text_file\fR]
.PP
.B dvispc \-a
[\fB\-ltv\fR] [\fB\-J..\fR] [\fB\-p..\fR] [\fB\-r..\fR]
\fIinput_dvi_file\fR [\fIoutput_text_file\fR]
.PP
.B dvispc \-x[..]
[\fB\-ltv\fR] [\fB\-r..\fR]
[\fIinput_text_file\fR] \fIoutput_dvi_file\fR
.SH DESCRIPTION
.B Dvispc
is a utility to modify/edit \*(TX DVI file with the following features:
.PP
    Mode option \fB\-c\fR (default):
        correct an input DVI to be page-independent in specials (default)
.PP
    Mode option \fB\-d\fR:
        dry run to check if an input DVI is page-independent in specials
.PP
    Mode option \fB\-s\fR:
        show all specials in the input DVI
.PP
    Mode option \fB\-a\fR:
        translate DVI into a Text (like \fBdv2dt\fR in dtl)
.PP
    Mode option \fB\-x\fR:
        translate Text into a DVI (like \fBdt2dv\fR in dtl)
.PP
(1) The \fImain\fR feature of
.B dvispc
is the first one, to make a page-independent DVI file.
.PP
A "pure" DVI file must be actually page-independent.
However in recent years, DVI files with lots of \\special's (color,
annotation etc.) are commonly used, and they are not always
page-independent. In such case, for example,
.B dviselect
or
.B dvidvi
fails to preserve \\special's (e.g. page color might be lost).
.PP
The program
.B dvispc
corrects such page-"dependent" DVI files to be page-independent,
which can be safely processed by
.B dviselect
or
.B dvidvi
and then properly converted to other formats such as PostScript and PDF.
.PP
(2) To know whether such a correction is needed or not,
.B dvispc \-d
will suffice.
.PP
(3) The mode \fB\-s\fR lists all specials found in the input DVI as-is,
with a preceding number which denotes the page where it appears.
For example,
.PP
.RS
[1]
.br
{color push  Black}
.br
{color pop}
.br
{color push rgb 1 0 0}
.br
{color pop}
.br
[2]
.br
{color push  Black}
.br
{color pop}
.RE
.LP
This feature is equivalent to a program
.B dvispecials
in TeX-Guy package
<http://www-masu.ist.osaka-u.ac.jp/%7Ekakugawa/TeX-Guy/>
and
.B dvii \-s
<https://ctan.org/pkg/dvii>.
.PP
(4) The mode \fB-a\fR and \fB-x\fR correspond to
.B dv2dt
and
.B dt2dv
in the dtl (= DVI Text Language) package respectively. By default
.B dvispc \-a
formats the output text in its own style, but DTL-compatible
format is available with
.B \-t
option. Also,
.B dvispc \-x
can accept DTL-compatible text input.
.SH SUPPORTED SPECIALS
Currently
.B dvispc
supports the followings:
.PP
    dvips-compatible specials
        color push, color pop, background
    dvipdfm(x) specials
        pdf:bcolor, pdf:ecolor, pdf:bgcolor, pdf:bann, pdf:eann
    tpic specials:
        pn
.PP
Other specials might be supported in the future if needed.
.SH SEE ALSO
dviselect(1), dvidvi(1), dvips(1), dvipdfmx(1)
.SH AUTHOR
The program
.B dvispc
is derived from the DVIOUT package (DVI previewer for Windows)
by Toshio OSHIMA ("SHIMA"), Yoshiki OTOBE, and Kazunori ASAYAMA.
Current version is maintained by Japanese \*(TX Development Community
<https://texjp.org>.
.br
For more information, please refer to
dvispc-en.txt (in English) and dvispc-ja.txt (in Japanese)
on our GitHub repository, <https://github.com/texjporg/tex-jp-build>
(under source/texk/dviout-util directory).
