/*
 * Copyright (c) 1986-2007 Purdue University
 * All rights reserved.
 * 
 * Developed by:  Daniel Trinkle
 *                Department of Computer Science, Purdue University
 *                http://www.cs.purdue.edu/
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal with the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * o Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimers.
 * 
 * o Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimers in the
 *   documentation and/or other materials provided with the distribution.
 * 
 * o Neither the names of Daniel Trinkle, Purdue University, nor the
 *   names of its contributors may be used to endorse or promote products
 *   derived from this Software without specific prior written
 *   permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE CONTRIBUTORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS WITH THE SOFTWARE.
 */

/*
 * detex [-e environment-list] [-c] [-l] [-n] [-s] [-t] [-w] [file[.tex] ]
 *
 *	This program is used to remove TeX or LaTeX constructs from a text
 *	file.
 */

#include "detex.h"

#ifdef KPATHSEA

#include <c-auto.h>
#include <kpathsea/c-auto.h>
#include <kpathsea/config.h>
#include <kpathsea/c-memstr.h>
#include <kpathsea/c-pathmx.h>
#include <kpathsea/c-std.h>
#include <kpathsea/tex-file.h>

#ifdef HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif

#else /* KPATHSEA */

#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#define	strrchr rindex
#endif
#ifndef MAXPATHLEN
#include <sys/param.h>
#endif
#define PATH_MAX MAXPATHLEN
#ifdef OS2
#include <stdlib.h>
#endif

#ifdef WIN32
#include <fcntl.h>
#include <io.h>
#endif

#endif /* KPATHSEA */

#line 84 "lex.yy.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 1
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart(yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = NULL; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = NULL;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart (FILE *input_file  );
void yy_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer (FILE *file,int size  );
void yy_delete_buffer (YY_BUFFER_STATE b  );
void yy_flush_buffer (YY_BUFFER_STATE b  );
void yypush_buffer_state (YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state (void );

static void yyensure_buffer_stack (void );
static void yy_load_buffer_state (void );
static void yy_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER yy_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE yy_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes (yyconst char *bytes,int len  );

void *yyalloc (yy_size_t  );
void *yyrealloc (void *,yy_size_t  );
void yyfree (void *  );

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

typedef unsigned char YY_CHAR;

FILE *yyin = NULL, *yyout = NULL;

typedef int yy_state_type;

extern int yylineno;

int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yynoreturn yy_fatal_error (yyconst char* msg  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 173
#define YY_END_OF_BUFFER 174
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[1361] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  144,  144,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  166,  166,    0,    0,    0,    0,    0,    0,
      139,  139,    0,    0,  174,  173,   92,   91,   90,  107,
      105,  107,  106,  107,  107,  119,  122,  121,  120,  128,
      130,  129,  113,  110,  109,  112,  113,  113,  158,  158,
      159,  158,  158,  108,    1,  158,  158,  158,  157,  158,
      146,  151,  154,  146,  155,  148,  145,  144,  142,  141,
      145,  145,  143,   12,   12,  173,   11,   12,  102,  100,

      101,  102,  102,   18,   16,   17,   15,   14,   15,   97,
       95,   96,   97,   97,  115,  117,  116,  124,  126,  125,
      164,  161,  162,  163,  166,  165,  170,  167,  168,  169,
      172,  171,    6,    6,    7,  139,   44,   43,   46,  104,
        0,    0,    0,    0,    0,    0,    0,  119,  121,  128,
      129,  111,    0,    0,    0,    0,    0,    0,    0,  160,
        0,  147,  103,    1,  152,  153,  149,  157,    0,  156,
      138,  136,   93,  135,  135,  135,  135,   98,  137,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  150,    0,    0,

        0,  144,  143,  141,  141,    0,  140,    0,    0,   11,
        0,    0,    0,    0,    0,   99,    0,    0,    0,    0,
        0,    0,    0,   16,   14,    0,   94,    0,    0,    0,
        0,    0,    0,    0,  115,  116,  124,  125,  163,  166,
        6,    0,   44,    0,   45,    0,  106,    0,    0,    0,
        0,    0,    0,    0,  112,    0,    0,    0,    0,    0,
        0,    0,  149,  156,  135,  135,  133,  133,  137,    0,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,

      135,  135,  135,  135,  135,    0,    0,    0,    0,    0,
        0,    0,    0,  101,    0,    0,    0,    0,    0,    0,
        0,    0,   96,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  132,
      132,    0,  137,  135,  135,  135,  135,  135,  135,   89,
      135,   71,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
       78,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   13,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  135,  135,  135,  135,  135,  135,  135,
      135,  135,   67,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,   57,  135,  135,
      135,  135,  135,  135,   33,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,   85,
      135,  135,   25,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,   67,  135,  135,  135,  135,

        3,  135,  135,  135,  135,   48,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,   73,  127,    0,    0,
        0,    0,    0,   74,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,   57,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  131,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  106,    0,  112,    0,  135,  135,  135,
      135,  135,    0,    0,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,    0,    0,    0,    0,    0,

      135,  135,  135,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   19,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,   37,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,   35,  135,    0,
        0,    0,    0,    0,  135,    0,    0,    0,    0,    0,
      101,    0,   96,    0,    0,    0,    0,  135,  135,  135,
      135,  135,    0,    0,   64,  135,  135,   58,  135,  135,
      135,  135,  135,  135,  135,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,   22,    0,    0,    0,

      135,  114,    0,   19,   19,  135,   75,  135,  135,  135,
      135,  135,  135,   76,  135,  135,  135,  135,  135,  135,
      135,   34,  135,   59,  135,  135,  135,  135,  135,  135,
      123,  135,  135,  135,  135,  135,  135,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   20,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  135,  135,  135,  135,  135,    0,  135,   66,   58,
       50,  135,  135,  135,   53,   83,  135,    0,   22,   22,
       22,   22,    0,    0,    0,    0,    0,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,  135,   36,

      135,  135,  135,  135,   38,   59,  135,  135,  135,  135,
      135,  135,  135,  135,  135,  135,  135,  135,    0,   20,
       20,   20,   20,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  135,  135,  135,  135,  135,    0,
      135,  135,  135,  135,   51,    0,   84,    0,    0,   22,
       22,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  135,  135,  135,  134,  135,  135,  135,
       26,  135,   52,   77,   62,  135,  135,   39,   41,  135,
       27,  135,  135,  135,  135,  135,  135,  135,   49,  135,
      135,    0,    0,   20,   20,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    8,
        9,    0,    4,    0,  135,  135,  135,  135,    0,    0,
        0,  135,  135,  135,  135,    0,    0,    0,   22,   22,
        0,    0,    0,    0,    0,   23,   72,  135,  135,    0,
       86,   81,  135,   32,   62,   40,  135,   39,   79,   31,
      135,   29,  135,  135,   60,  135,  135,   70,    0,    0,
       20,   20,    0,    0,    0,    0,    0,   21,   10,    0,
      135,  135,  135,   28,    0,    0,    0,    0,    0,    0,
      135,   47,  135,  135,    0,    0,    0,   22,   22,    0,
        0,    0,    0,  135,  118,    0,  135,  135,   30,   82,

      135,   60,  135,  135,    0,    0,   20,   20,    0,    0,
        0,    0,    0,  135,  135,   80,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   65,
      135,  135,    0,    0,   22,   22,    0,    0,    0,    0,
        0,    0,    0,    0,  135,  134,  135,   87,   63,  135,
      135,    0,    0,   20,   20,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  135,  135,    0,    0,    0,    0,
        0,   24,    0,   69,   68,    0,    0,   22,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,   22,    0,    0,    0,    0,  135,  135,

       63,   61,   55,    0,    0,   20,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,   20,    0,    0,    0,    0,    0,    5,  135,   54,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   22,    0,   22,
       22,   22,    0,    0,    0,    0,    0,    0,    0,    0,
      135,   88,   61,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,   20,    0,   20,   20,   20,
        0,    0,    0,    0,    0,    0,    0,    0,   56,    0,
        0,    0,    0,    0,    2,    0,   22,   22,   22,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   42,    0,
       20,   20,   20,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    2,   22,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,   42,   42,   20,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,   22,    0,    0,    0,    0,   20,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   22,    0,   20,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,   22,    0,   20,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0
    } ;

static yyconst YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    4,    5,    1,    1,    6,    7,    1,    8,    9,
       10,   11,   12,   13,   14,   15,    1,   16,   16,   16,
       16,   16,   17,   17,   17,   17,   17,    1,    1,   18,
       19,   20,    5,   21,   22,   23,   23,   23,   24,   23,
       23,   23,   23,   23,   23,   25,   23,   23,   26,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
       27,   28,   29,    1,    1,   30,   31,   32,   33,   34,

       35,   36,   37,   38,   39,   25,   40,   41,   42,   43,
       44,   45,   46,   47,   48,   49,   50,   51,   52,   53,
       54,   55,   56,   57,   58,   59,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst YY_CHAR yy_meta[60] =
    {   0,
        1,    2,    3,    2,    1,    1,    1,    4,    1,    1,
        1,    1,    5,    6,    1,    6,    6,    1,    6,    1,
        7,    8,    8,    8,    8,    8,    1,    9,   10,    6,
        8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,   11,    1,   12,    1
    } ;

static yyconst flex_uint16_t yy_base[1415] =
    {   0,
        0,    0,    0,    1,    2,    6,   14,   29,   11,   33,
       40,   45,   93,    0,  152,    0,  211,    0,  268,  271,
      319,    0,   16,   25,  376,  379,  381,  384,  387,  398,
       20,  378, 3305, 3304,  390,  403,   26,   37,   46,   49,
     3316, 3315,   23,   24, 3330, 3335, 3335, 3335, 3335, 3335,
     3335, 3323, 3335,  236, 3278,    0, 3335, 3324, 3335,    0,
     3335, 3323, 3335, 3335, 3335, 3335,  266, 3275, 3335, 3322,
     3335, 3295, 3292, 3315,    0, 3312, 3306, 3304,   22, 3309,
      461, 3286,  396, 3335, 3335, 3335, 3335,  519, 3335,    0,
      287,    0, 3259, 3335,  522,  525,    0,  528, 3335, 3335,

     3335,  504, 3264, 3335,    0, 3335, 3335, 3310, 3277, 3335,
     3335, 3335,  410, 3261,    0, 3335, 3307,    0, 3335, 3306,
     3335, 3335, 3335, 3305,    0, 3335, 3335, 3335, 3335, 3335,
     3335, 3335,    0,    0, 3272, 3335,    0, 3335,  278, 3335,
     3271, 3262, 3269, 3272, 3267,   36, 3269,    0, 3297,    0,
     3296, 3335, 3263, 3254, 3261, 3264, 3259,  244, 3261, 3290,
     3258, 3335, 3335,    0, 3335, 3335, 3275,   45, 3268, 3243,
     3335, 3335, 3335,    0,   68,  532,  535, 3335,  265,  384,
        6,  274,  258, 3207,  267,  250,  546, 3214,  552,  390,
      559, 3203,  391,  564,  393, 3175,   36, 3335,  550,  416,

      556,  572, 3150,    0,    0,  592,    0,  582,  605,    0,
      616, 3166, 3157, 3164, 3153, 3335, 3150, 3134, 3141, 3142,
     3137,  353, 3139,    0, 3157, 3107, 3335, 3114, 3099, 3105,
     3108, 2897,  405, 2899,    0, 2927,    0, 2926, 3335,    0,
        0, 2885,    0,  621,  627, 2881, 3335, 2880, 2880, 2878,
     2881,  265, 2874, 2875, 3335, 2874, 2874, 2872, 2874,  384,
     2867, 2875, 3335, 2905,    0,  630,  633, 3335, 2885, 2882,
     2876, 2872, 2876, 2876, 2857, 2864, 2868, 2869, 2867, 2856,
      514,  369, 2854,  535, 2851, 2865, 2853, 2853, 2842,  413,
     2854,  603, 2839, 2835, 2841, 2853,  408, 2852, 2847, 2849,

     2827, 2836, 2839, 2826,  542,  599,  586, 2823, 2834, 2827,
     2837, 2821, 2821, 3335, 2820, 2820, 2818, 2821,  595, 2814,
     2827, 2813, 3335, 2812, 2812, 2810, 2813,  610, 2806, 2819,
     2804, 2803, 2802, 2814, 2800, 2799, 2797, 2809, 2794,  646,
     3335, 2813, 3335,  624, 2802,  503, 2795, 2804, 2794, 2798,
     2786,    0, 2790, 2788, 2779, 2778, 2787, 2794, 2789, 2782,
     2783, 2767, 2773, 2780, 2779, 2778,  628, 2777,  640, 2763,
     2769, 2774, 2769, 2776, 2771, 2752, 2763, 2753,  629, 2753,
     2755,  632, 2750, 2750,  621, 2765, 2757, 2764,  665, 2736,
     2743, 2753, 2750, 2758, 2740, 2739, 2738, 2750, 3335, 2736,

     2735, 2734, 2746,  681, 2731, 2744, 2739, 2723, 2722, 2735,
     2734, 2719, 2732, 2722, 2717, 2716, 2711, 2715, 2708, 2717,
     2706, 2705,    0, 2706, 2709, 2709, 2706, 2711, 2700, 2704,
     2700, 2711, 2696, 2692, 2688, 2691,  736, 2698, 2706, 2690,
     2692, 2692, 2699, 2702,  646, 2694, 2686, 2718, 2693, 2692,
     2674, 2670, 2675, 2691,    0, 2687, 2678, 2671, 2679, 2669,
     2674, 2678, 2671, 2678,  388, 2671, 2658, 2658, 2670,    0,
     2655, 2666, 3335, 2651, 2652, 2661, 2664, 2645, 2658, 2657,
     2641, 2640, 2653, 2652, 2637,  693,  696, 2641, 2635, 2634,
     2647, 2637, 2627, 2625, 2638, 3335, 2629, 2628,  668, 2625,

      703, 2634, 2624, 2609, 2627, 2629, 2625, 2624, 2611, 2622,
     2611, 2611,  763, 2619, 2605, 2618,    0,    0,  790,  696,
      670,  817,    0,    0, 2604, 2614,  666, 2597, 2604, 2595,
     2601, 2609, 2594, 2595, 2588, 3335, 2608, 2602, 2600, 2597,
     2596, 2586, 2597, 2584, 2577, 2579,  680,    0, 2577, 2579,
     2572, 2585, 2585, 2572, 2584, 2561, 2580,  864, 2577, 2576,
     2579,  718, 2559, 2563, 2557, 2556, 2569, 2559, 2553, 2552,
     2565,  721, 2564, 2559, 2546, 2556, 2544, 2540, 2539, 2543,
     2551, 2550,  725,  739, 2538, 2542, 2537, 2530, 2532, 2542,
     2531, 2541, 2541, 2536, 2521,  891,  718,  686,  918,    0,

      752, 2534, 2532,  729,  714,  741, 2521,  684, 2531, 2522,
     2520, 2520,  610, 2516,  758, 2525, 2523, 2516, 2510, 2512,
     2513, 2514, 2507, 2511, 2492, 2514,    0, 2496, 2490, 2493,
     2504, 2502, 2480, 2487, 2487, 2481, 2486, 2487, 2486, 2481,
     2468, 2482, 2485, 2466, 2466, 2471, 2474,    0, 2467,  965,
      753,  766,  992,    0,  784,  795, 2469,  811,  808, 2466,
     2469, 2457, 2467, 2455, 2452, 2452, 2447, 2457, 2455, 2440,
     2446, 2455,  820, 2442,    0, 2438, 2442, 2465, 2419, 2422,
     2416, 2419, 2428, 2427, 2424,  810,  768,  773, 2412,  767,
     2421, 2408, 2406, 2406,  641, 2402,  840,  827,  834, 1039,

     2394,  759,  800,  843,  868, 2411,    0, 2407, 2388, 2383,
     2380, 2396, 2383,    0, 2384, 2379, 2365, 2385, 2373, 2370,
     2368,    0, 2358, 2388, 2349, 2343, 2345, 2349, 2353, 2335,
        0, 2339, 2335, 2338, 2317, 2325, 2325,  858,  841,  844,
     2309,  806, 2319, 2299, 2304, 2296,  851, 2288,  884,  908,
      914, 1066,  928,  911, 2289,  921,    0, 2281, 2275, 2274,
     2278, 2266, 2270, 2261, 2265, 2266, 2266, 2267,    0, 3335,
        0, 2247,  856, 2234,    0,    0,  565,  847,  894,  942,
      971,  987,    0,  925,  885, 1093,    0, 2236, 2238, 2234,
     2226, 2221, 2228, 2215, 2220, 2207, 2147, 2158, 2153,    0,

     2146, 2146, 2134, 2131,    0, 3335, 2148, 2140, 2128, 2139,
     2126, 2125,   36,  241,  282,  333,  416,  485,  911, 1002,
     1015, 1019, 1046,    0,  939,  942, 1140,    0, 1071,    0,
     1082,  511, 1100,  529,  539,  567,  577,  596,  996,  614,
      647,  671,  678,  687,    0,    0, 3335,  732,  733, 1103,
     1109,  986,  945,  955,  756,  943,  794,  799,  812,  835,
      916,  846, 1118,  854,  878,  896,  916,  913,  931,  940,
        0,  935,    0,    0,  981,  944,  980, 1001,    0,  967,
        0,  977,  982,  992,  998, 1004,  993,  989,    0,  990,
     1010, 1007, 1018, 1162, 1166, 1084, 1046, 1049, 1026, 1081,

     1038, 1023, 1034, 1037, 1082, 1044, 1187, 1061, 1190, 3335,
     3335, 1193, 3335, 1043, 1045, 1067, 1082, 1080, 1196, 1251,
     1077, 1086, 1082, 1099, 1079, 1105, 1093, 1087, 1199, 1216,
     1133, 1231, 1235, 1267, 1139, 3335,    0, 1094, 1093, 1136,
        0,    0, 1111,    0, 3335,    0, 1118, 3335,    0,    0,
     1113,    0, 1120, 1126, 1166, 1142, 1129,    0, 1141, 1136,
     1279, 1288, 1193, 1292, 1296, 1300, 1173, 3335, 3335, 1148,
     1165, 1163, 1168,    0,    0, 1206, 1208, 1357,    0, 1182,
     1172,    0, 1179, 1187, 1174, 1181, 1188, 1353, 1404, 1201,
     1201, 1204, 1207, 1212,    0, 1227, 1224, 1226,    0,    0,

     1224, 3335, 1228, 1233, 1225, 1230, 1367, 1448, 1245, 1244,
     1258, 1266, 1244, 1248, 1241,    0, 1298, 1291, 1294, 1272,
     1285, 1285, 1267, 1279, 1281, 1295, 1281, 1380, 1288,    0,
     1284, 1300, 1292, 1492, 1519, 1384, 1331, 1335, 1546,    0,
     1300, 1299, 1314, 1327, 1323, 3335, 1320,    0, 1354, 1324,
     1333, 1328, 1593, 1620, 1432, 1362, 1364, 1647,    0, 1342,
     1343, 1361, 1355, 1439, 1354, 1369, 1397, 1468, 1482, 1499,
     1389, 3335, 1361,    0,    0, 1694,    0, 1513, 1438, 1407,
     1721,    0, 1441, 1423, 1428, 1372, 1426, 1393, 1389, 1390,
     1395, 1433, 1402, 1476, 1398, 1413, 1444, 1768, 1434, 1420,

     3335, 1462,    0, 1806,    0, 1526, 1472, 1482, 1833,    0,
     1536, 1495, 1526, 1430, 1458, 1447, 1452, 1471, 1477, 1521,
     1480, 1562, 1482, 1489, 1521, 1880, 1570, 3335, 1504,    0,
     1506, 1505, 1543, 1517, 1573,    0, 1583, 1567, 1573, 1514,
     1559, 1553, 1551, 1559, 1561, 1578, 1561, 1610, 1599, 1615,
     1636, 1651, 1572, 1918, 1945, 1642, 1626, 1609, 1972,    0,
     1581,    0, 3335,    0, 1643, 1649, 1651, 1585, 1614, 1599,
     1599, 1618, 1627, 1639, 1625, 1671, 1660, 1699, 1710, 1725,
     1623, 2019, 2046, 1716, 1700, 1688, 2073,    0,    0, 1640,
     1635, 1682, 1687, 1740, 1688, 1714, 1743, 1746, 1773, 2120,

        0, 1784, 1774, 1717, 2147,    0, 1777, 1723, 1762, 1649,
     1726, 1665, 1665, 1708, 1715, 1732, 1717, 1797, 2195, 1786,
     1802, 1809, 1828, 2253,    0, 1843, 1836, 1808, 2280,    0,
     1841, 1811, 1824, 1728, 1821, 1761, 1744, 1771, 1775, 1810,
     1774, 1858, 1783, 1790, 1825, 2327, 1841, 1887,    0, 1887,
     1860, 1863, 1824, 1865, 1840, 1844, 1844, 1851, 1866, 1860,
     1907, 1896, 1921, 1924, 1938,    0,    0, 1941,    0, 1935,
     1901, 1922, 1861, 1922, 1880, 1878, 1893, 1911, 1921, 1911,
     1982, 1951, 1995, 1999, 2025, 1910, 2365, 2392, 2040, 1977,
     1955, 2419,    0, 2052, 1992, 2022, 2067, 2099, 2124, 1996,

     2089, 2107, 2127, 2466,    0, 2258, 2080, 1999, 2493,    0,
     2123, 2002, 2022, 1924, 1948, 1944, 1942, 1957, 1968, 1997,
     1987, 2269, 2540, 2276, 2581, 2290,    0, 2128, 2035, 2049,
     2000, 2026, 2038, 2020, 2035, 2037, 2071, 2036, 2287, 2070,
     2304, 2333, 2347, 2622, 2355, 2663, 2368, 2097, 2361, 2381,
     2398, 2704, 2761, 2429, 2818, 2442, 2471, 2875, 2272, 3335,
     2933, 2945, 2957, 2969, 2981, 2993, 3005, 3017, 3029, 3041,
     3053, 3065, 3077, 3089, 3101, 3113, 3125, 3137, 3147, 3157,
     3166, 3174, 3183, 3185, 2076, 2091, 3193, 3203, 3213, 3225,
     3237, 3244, 3246, 3254, 2108, 2109, 2111, 2125, 2138, 2144,

     2145, 3266, 2146, 2147, 2148, 2150, 2151, 2152, 2153, 2159,
     2160, 3278, 2163, 2165
    } ;

static yyconst flex_int16_t yy_def[1415] =
    {   0,
     1361, 1361, 1362, 1362, 1363, 1363, 1364, 1364, 1365, 1365,
     1366, 1366, 1360,   13, 1360,   15, 1360,   17, 1367, 1367,
     1360,   21, 1368, 1368, 1369, 1369, 1370, 1370, 1371, 1371,
     1372, 1372, 1373, 1373, 1374, 1374, 1375, 1375, 1376, 1376,
     1361, 1361, 1377, 1377, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1378, 1360, 1360, 1360, 1379,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1380, 1360, 1360, 1360, 1360, 1381,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1382,
     1383, 1384, 1360, 1360, 1360, 1360, 1385, 1360, 1360, 1360,

     1360, 1360, 1360, 1360, 1386, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1387, 1360, 1360, 1388, 1360, 1360,
     1360, 1360, 1360, 1360, 1389, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1390, 1390, 1360, 1360, 1391, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1378, 1360, 1379,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1380, 1360, 1360, 1360, 1360, 1392, 1381,
     1360, 1360, 1360, 1393, 1393, 1393, 1393, 1360, 1360, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1360, 1360, 1360,

     1360, 1360, 1360, 1382, 1382, 1383, 1384, 1360, 1360, 1385,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1386, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1387, 1360, 1388, 1360, 1360, 1389,
     1390, 1360, 1391, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1392, 1393, 1393, 1360, 1360, 1360, 1394,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,

     1393, 1393, 1393, 1393, 1393, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1394, 1360, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,

     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1393, 1393, 1393, 1393,

     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1360, 1360,
     1360, 1360, 1395, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1360, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1393, 1393, 1393,
     1393, 1393, 1360, 1360, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1360, 1360, 1360, 1360, 1396,

     1393, 1393, 1393,  522,  604, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1395, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1360,
     1360, 1360, 1360, 1397, 1393, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1393, 1393, 1393,
     1393, 1393, 1360, 1360, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393,  599,  686, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1396, 1360, 1360, 1360,

     1393, 1393,  604, 1360, 1360, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393,  653,  738, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1397, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1398, 1360, 1360, 1360,
     1360, 1393, 1393, 1393, 1393, 1393, 1360, 1393, 1393, 1360,
     1393, 1393, 1393, 1393, 1393, 1393, 1393,  686, 1360, 1360,
     1396, 1396,  700, 1360, 1360, 1360, 1399, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,

     1393, 1393, 1393, 1393, 1393, 1360, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,  738, 1360,
     1360, 1397, 1397,  752, 1360, 1360, 1360, 1400, 1360, 1401,
     1360, 1398, 1360, 1360, 1393, 1393, 1393, 1393, 1393, 1360,
     1393, 1393, 1393, 1393, 1393, 1402, 1360, 1360, 1360, 1396,
     1396,  786,  852, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1399, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393,
     1393, 1360, 1360, 1397, 1397,  827,  896, 1360, 1360, 1360,

     1360, 1360, 1360, 1360, 1360, 1360, 1400, 1401, 1360, 1360,
     1360, 1360, 1360, 1360, 1393, 1393, 1393, 1393, 1360, 1360,
     1360, 1393, 1393, 1393, 1393, 1402, 1360, 1360, 1396, 1396,
      852, 1360, 1360, 1399,  934, 1360, 1393, 1393, 1393, 1360,
     1393, 1393, 1393, 1393, 1360, 1393, 1393, 1360, 1393, 1393,
     1393, 1393, 1393, 1393, 1393, 1393, 1393, 1393, 1360, 1360,
     1397, 1397,  896, 1360, 1360, 1400,  966, 1360, 1360, 1360,
     1393, 1393, 1393, 1393,  920, 1360, 1360, 1360, 1403, 1360,
     1393, 1393, 1393, 1393, 1360, 1360, 1360, 1396, 1396, 1360,
     1360,  934,  934, 1393, 1393, 1360, 1393, 1393, 1393, 1393,

     1393, 1360, 1393, 1393, 1360, 1360, 1397, 1397, 1360, 1360,
      966,  966, 1360, 1393, 1393, 1393,  978, 1017, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1403, 1360, 1393,
     1393, 1393, 1360, 1360,  989, 1034, 1360, 1360, 1360, 1404,
     1360, 1360,  934,  934, 1393, 1360, 1393, 1393, 1393, 1393,
     1393, 1360, 1360, 1008, 1053, 1360, 1360, 1360, 1405, 1360,
     1360,  966,  966, 1360, 1393, 1393, 1017, 1360, 1360, 1403,
     1070, 1360, 1360, 1393, 1393, 1360, 1034, 1076, 1360, 1360,
     1360, 1406, 1039, 1083, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1404, 1360, 1360,  934,  934, 1393, 1393,

     1360, 1393, 1393, 1360, 1053, 1104, 1360, 1360, 1360, 1407,
     1058, 1111, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1405, 1360, 1360,  966,  966, 1360, 1360, 1393, 1393,
     1360, 1360, 1070, 1070, 1360, 1076, 1081, 1137, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1406, 1083, 1360,
     1360, 1404, 1360, 1360, 1098, 1154, 1360, 1360, 1360, 1408,
     1393, 1393, 1360, 1104, 1109, 1165, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1407, 1111, 1360, 1360, 1405,
     1360, 1360, 1126, 1182, 1360, 1360, 1360, 1409, 1393, 1360,
     1360, 1070, 1070, 1360, 1360, 1137, 1360, 1360, 1404, 1360,

     1154, 1200, 1360, 1360, 1360, 1410, 1159, 1207, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1408, 1360, 1165,
     1360, 1360, 1405, 1360, 1182, 1224, 1360, 1360, 1360, 1411,
     1187, 1231, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1409, 1360, 1360, 1070, 1070, 1360, 1404, 1200, 1205,
     1250, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1410, 1207, 1360, 1360, 1408, 1412, 1219, 1405, 1224, 1229,
     1270, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1411, 1231, 1360, 1360, 1409, 1360, 1360, 1246, 1287, 1360,
     1360, 1360, 1413, 1404, 1250, 1360, 1360, 1408, 1405, 1270,

     1360, 1360, 1409, 1360, 1287, 1304, 1360, 1360, 1360, 1414,
     1292, 1311, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1413, 1404, 1408, 1405, 1409, 1304, 1309, 1328, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1414, 1311,
     1360, 1360, 1413, 1360, 1408, 1360, 1409, 1328, 1360, 1360,
     1413, 1408, 1409, 1413, 1360, 1224, 1413, 1413, 1306,    0,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,

     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360
    } ;

static yyconst flex_uint16_t yy_nxt[3395] =
    {   0,
     1360, 1360,   48,   48,   51, 1360, 1360,   52,   51, 1360,
     1360,   52,   61,   62,   61,   57,   58,   57,  108,   53,
       53,   53,   46,   53,   53,   53,   57,  108,   46,   54,
       57,   58,   57,   54,   61,   62,   61,  168,  168,   46,
      272,   57,   64,  109,  273,   65,  122,   64,  134,   55,
       65,  134,  109,   55,  132,   49,   49,   66,   66,   66,
      168,  168,   66,   66,   66,  132,   61,   67,   61,   57,
      304,   59,   67,  135,  251,  123,  135,  124,  138,  138,
      139,  139,  886,  305,   57,  252,   59,   68,   61,  266,
       61,  266,   68,   69,   70,   71,   72,   73,   74,   75,

       76,   69,   69,   69,   69,   77,   78,   69,   79,   79,
       69,   69,   69,   69,   80,   80,   80,   80,   80,   69,
       81,   69,   82,   80,   80,   80,   80,   80,   80,   80,
       80,   80,   80,   80,   80,   80,   80,   80,   80,   80,
       80,   80,   80,   80,   80,   80,   80,   80,   83,   84,
       85,   86,   87,   88,   89,   88,   87,   87,   87,   90,
       87,   87,   87,   87,   87,   90,   87,   91,   91,   87,
       90,   87,   91,   91,   91,   91,   91,   91,   87,   92,
       87,   90,   91,   91,   91,   91,   91,   91,   91,   91,
       91,   91,   91,   91,   91,   91,   91,   91,   91,   91,

       91,   91,   91,   91,   91,   91,   91,   93,   87,   87,
       87,   94,   95,   96,   95,   94,   94,   94,   94,   94,
       94,   94,   94,   94,   94,   94,   94,   94,   94,   94,
       94,   94,   97,   97,   97,   97,   97,   94,   94,   94,
       94,   97,   97,   97,   97,   97,   97,   97,   97,   97,
       97,   97,   97,   97,   97,   97,   97,   97,   97,   97,
       97,   97,   97,   97,   97,   97,   98,   94,   94,   94,
      100,  152,  141,  100,  142,  269,  143,  144,  145,  244,
      245,  244,  259,  146,  887,  101,  101,  101,  101,  101,
      101,  270,  277,  260,  205,  102,  332,  282,  102,  280,

      205,  278,  153,  283,  154,  205,  155,  156,  157,  333,
      281,  274,  275,  158,  888,  103,  205,  276,  103,  104,
      104,   46,  104,  104,  104,  104,  104,  104,  104,  104,
      104,  104,  104,  104,  104,  104,  104,  104,  104,  104,
      105,  105,  105,  105,  105,  104,  104,  104,  104,  105,
      105,  105,  105,  105,  105,  105,  105,  105,  105,  105,
      105,  105,  105,  105,  105,  105,  105,  105,  105,  105,
      105,  105,  105,  105,  104,  104,  106,  104,  111,  889,
       46,  111,  116,  117,  116,  116,  117,  116,  119,  120,
      119,  318,   46,  112,  112,  112,  112,  112,  112,  119,

      120,  119,  319,  113,  122,   46,  113,  199,  357,  199,
      200,  201,  201,  358,  266,  336,  128,  271,  266,  227,
      288,  291,  552,  114,  289,  292,  114,  301,  337,  128,
      302,  306,  306,  123,  293,  124,  116,  553,  116,  116,
      378,  116,  119,  327,  119,  129,  228,  130,  229,  368,
      230,  231,  232,  119,  328,  119,  379,  233,  129,  369,
      130,  171,  171,  890,  172,  171,  171,  171,  171,  173,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  174,  175,  174,  174,  176,  177,  178,  179,  171,
      171,  180,  181,  182,  183,  184,  185,  174,  186,  187,

      188,  189,  174,  190,  191,  192,  174,  193,  194,  195,
      196,  197,  174,  174,  174,  174,  171,  171,  171,  171,
      202,  891,  202,  208,  208,  208,  208,  208,  208,  211,
      211,  211,  216,  267,  268,  267,  267,  268,  267,  911,
      217,  419,  218,  420,  219,  220,  221,  267,  268,  267,
      421,  222,  354,  267,  268,  267,  355,  356,  266,  914,
      267,  268,  267,  212,  200,  201,  201,  360,  361,  213,
      307,  201,  201,  202,  203,  202,  214,  209,  215,  362,
      209,  387,  286,  208,  208,  208,  388,  915,  284,  268,
      287,  846,  268,  266,  294,  295,  296,  916,  297,  205,

      308,  389,  389,  268,  298,  205,  211,  211,  211,  268,
      205,  266,  299,  300,  306,  306,  268,  211,  211,  211,
      847,  205,  244,  245,  244,  917,  396,  203,  244,  245,
      244,  340,  341,  340,  267,  268,  267,  209,  371,  397,
      212,  401,  704,  308,  918,  372,  213,  340,  341,  340,
      373,  212,  468,  214,  402,  215,  414,  213,  704,  415,
      441,  458,  442,  921,  214,  469,  215,  463,  443,  459,
      446,  447,  416,  779,  417,  444,  464,  460,  531,  465,
      389,  389,  486,  486,  486,  604,  604,  341,  448,  779,
      268,  922,  532,  533,  486,  486,  486,  572,  572,  572,

      580,  686,  686,  341,  583,  583,  583,  618,  581,  308,
      521,  522,  522,  638,  923,  619,  704,  639,  924,  658,
      658,  658,  572,  572,  572,  704,  583,  583,  583, 1360,
     1360,  640,  598,  599,  599,  925,  487,  519,  519,  519,
      673,  673,  673, 1360,  604,  604,  573,  520,  487,  520,
      521,  522,  522,  698,  698,  698,  703,  703,  584,  705,
      705,  705,  699,  523,  596,  596,  596,  652,  653,  653,
      927,  573,  674,  928,  597,  659,  597,  598,  599,  599,
      584,  738,  738, 1360, 1360,  750,  750,  750,  778,  778,
      600,  519,  519,  519,  751,  789,  753,  753,  753,  779,

      932,  520,  790,  520,  521,  522,  522,  700,  779,  756,
      756,  756,  658,  658,  658,  703,  703,  523,  605,  605,
      605,  673,  673,  673, 1360,  686,  686,  932,  698,  698,
      698,  606,  522,  522,  757,  698,  698,  698,  820,  752,
      932,  780,  780,  780,  705,  705,  705,  820,  607,  608,
      609,  610,  754,  674,  932,  611, 1360, 1360,  612,  819,
      819,  613,  778,  778,  614,  650,  650,  650,  659,  705,
      705,  705, 1360,  738,  738,  651,  932,  651,  652,  653,
      653,  781,  700,  820,  782,  821,  821,  821,  843,  700,
      932,  654,  596,  596,  596,  780,  780,  780,  937,  820,

      852,  852,  597,  844,  597,  598,  599,  599,  938,  750,
      750,  750,  829,  829,  829,  750,  750,  750,  600,  687,
      687,  687,  756,  756,  756,  822,  819,  819,  823,  753,
      753,  753,  688,  599,  599,  848,  939,  830,  849,  785,
      786,  786,  940,  780,  780,  780,  941,  757,  932,  689,
      690,  691,  692,  826,  827,  827,  693,  896,  896,  694,
     1360, 1360,  695,  752,  932,  696,  650,  650,  650,  752,
      931,  931,  780,  780,  780,  932,  651,  942,  651,  652,
      653,  653,  943,  848,  932,  754,  849,  944,  780,  780,
      780,  945,  654,  739,  739,  739,  946,  919,  919,  919,

     1360,  852,  852,  821,  821,  821,  740,  653,  653,  850,
      947,  948,  781,  949,  950,  782,  821,  821,  821,  951,
      821,  821,  821,  741,  742,  743,  744,  851,  781,  952,
      745,  782,  953,  746,  954,  955,  747,  956,  957,  748,
      783,  783,  783,  892,  958,  959,  893,  821,  821,  821,
      784,  920,  784,  785,  786,  786,  892,  894,  960,  893,
      822, 1360, 1360,  823,  963,  963,  787,  824,  824,  824,
      964,  964,  829,  829,  829,  964,  964,  825,  964,  825,
      826,  827,  827,  909,  909,  909,  895,  822,  964,  969,
      823,  970,  971,  828,  853,  853,  853,  830, 1360,  896,

      896,  912,  912,  912,  780,  780,  780,  854,  786,  786,
      780,  780,  780,  964,  964,  972,  973,  974,  980,  933,
      933,  933,  964,  981,  855,  856,  857,  858,  982,  983,
      964,  859,  984,  985,  860,  986,  987,  861,  994,  910,
      862,  897,  897,  897,  781,  929,  995,  782,  931,  931,
      781,  996,  997,  782,  898,  827,  827,  913,  930,  934,
      998,  999,  935,  821,  821,  821, 1000,  821,  821,  821,
     1001,  899,  900,  901,  902,  936, 1002,  863,  903,  993,
     1003,  904, 1004, 1005,  905, 1006, 1013,  906,  965,  965,
      965,  909,  909,  909,  912,  912,  912,  919,  919,  919,

      780,  780,  780,  822,  961, 1014,  823,  822,  963,  963,
      823,  907, 1015, 1012, 1016,  962, 1029,  780,  780,  780,
      977,  978,  978, 1017, 1017, 1030, 1031, 1032,  966,  847,
     1033,  967,  933,  933,  933, 1034,  933,  933,  933, 1041,
      781, 1042,  863,  782,  968,  863, 1043,  910,  988, 1045,
      913,  920,  975,  975,  975, 1046, 1044,  781, 1047, 1048,
      782, 1049,  976,  989,  976,  977,  978,  978,  933,  933,
      933, 1050,  990, 1051, 1052,  991,  990, 1053,  979,  991,
      821,  821,  821, 1060, 1061, 1064, 1065, 1066,  936,  821,
      821,  821,  936,  965,  965,  965,  907,  965,  965,  965,

     1062,  965,  965,  965,  907,  992, 1360, 1360,  934, 1067,
     1067,  935, 1360, 1017, 1017, 1063, 1068, 1068, 1068, 1068,
      822, 1068, 1068,  823,  936, 1068, 1068, 1068, 1007,  822,
     1073, 1074,  823, 1009, 1075, 1008, 1010, 1009, 1011, 1076,
     1010,  966, 1095, 1068,  967, 1038, 1039, 1039, 1096,  968,
     1083, 1083,  863,  968,  780,  780,  780,  968, 1018, 1018,
     1018, 1099, 1100, 1097, 1101,  863, 1102, 1103,  821,  821,
      821, 1019,  978,  978, 1098, 1104, 1057, 1058, 1058, 1111,
     1111, 1069, 1069, 1069, 1123, 1036, 1036, 1036, 1020, 1021,
     1022, 1023, 1124,  907,  781, 1024, 1129,  782, 1025,  907,

     1035, 1026, 1126, 1130, 1027, 1036, 1036, 1036,  822, 1135,
     1125,  823, 1067, 1067, 1054, 1037, 1150, 1037, 1038, 1039,
     1039, 1070, 1137, 1137, 1071,  848, 1150, 1028,  849, 1134,
     1150, 1040, 1150, 1055, 1055, 1055, 1150, 1072, 1360, 1360,
     1127, 1127, 1127, 1149, 1149,  781, 1150, 1153,  782, 1055,
     1055, 1055, 1080, 1081, 1081, 1360, 1083, 1083, 1150, 1056,
     1154, 1056, 1057, 1058, 1058, 1150, 1161, 1150, 1162, 1069,
     1069, 1069, 1163,  892, 1178, 1059,  893, 1151, 1151, 1151,
     1178, 1150,  863, 1069, 1069, 1069, 1108, 1109, 1109,  822,
     1178, 1155,  823, 1077, 1077, 1077, 1128, 1165, 1165, 1178,

     1069, 1069, 1069, 1037, 1178, 1037, 1038, 1039, 1039, 1131,
     1360, 1360, 1132, 1178, 1078, 1078, 1078, 1152, 1178, 1040,
     1078, 1078, 1078, 1131, 1178, 1072, 1132, 1106, 1106, 1106,
     1079, 1181, 1079, 1080, 1081, 1081, 1182, 1133, 1189, 1072,
     1070, 1177, 1177, 1071, 1190, 1191, 1082, 1084, 1084, 1084,
     1360, 1111, 1111, 1178,  848, 1028, 1072,  849, 1197,  907,
     1085, 1039, 1039, 1179, 1179, 1179, 1193,  892, 1183, 1178,
      893, 1127, 1127, 1127, 1194, 1194, 1194, 1086, 1087, 1088,
     1089, 1028, 1360, 1360, 1090, 1192, 1197, 1091, 1196, 1196,
     1092, 1197, 1197, 1093, 1105, 1105, 1105, 1360, 1137, 1137,

     1197, 1197, 1197, 1180, 1056, 1197, 1056, 1057, 1058, 1058,
     1197, 1198, 1198, 1198, 1149, 1149, 1151, 1151, 1151, 1200,
     1059, 1106, 1106, 1106, 1207, 1207, 1197, 1128, 1219, 1221,
     1195, 1107, 1221, 1107, 1108, 1109, 1109, 1151, 1151, 1151,
     1158, 1159, 1159, 1156, 1156, 1156, 1221, 1110, 1112, 1112,
     1112, 1221, 1151, 1151, 1151, 1221,  848, 1360, 1165, 1165,
     1221, 1113, 1058, 1058, 1360, 1360, 1220, 1220, 1221, 1221,
     1224, 1221, 1222, 1222, 1222, 1177, 1177,  848, 1114, 1115,
     1116, 1117, 1243,  990, 1244, 1118,  991, 1221, 1119, 1199,
     1247, 1120, 1152, 1263, 1121, 1136, 1136, 1136, 1263,  936,

     1179, 1179, 1179, 1231, 1231, 1079, 1263, 1079, 1080, 1081,
     1081, 1179, 1179, 1179, 1186, 1187, 1187, 1184, 1184, 1184,
     1028, 1082, 1138, 1138, 1138, 1028, 1179, 1179, 1179, 1196,
     1196, 1245, 1250, 1250, 1246, 1139, 1081, 1081, 1360, 1360,
      892, 1194, 1194, 1194, 1198, 1198, 1198, 1198, 1198, 1198,
     1263,  892, 1140, 1141, 1142, 1143, 1263, 1009, 1263, 1144,
     1010, 1263, 1145, 1223, 1263, 1146, 1180, 1263, 1147, 1156,
     1156, 1156, 1283,  968, 1151, 1151, 1151, 1262, 1262, 1157,
     1263, 1157, 1158, 1159, 1159, 1202, 1202, 1202, 1204, 1205,
     1205, 1360, 1207, 1207, 1283, 1160, 1283, 1195, 1264, 1264,

     1264, 1220, 1220, 1222, 1222, 1222,  863, 1164, 1164, 1164,
     1222, 1222, 1222, 1283, 1152, 1248, 1283, 1107, 1283, 1107,
     1108, 1109, 1109, 1270, 1270,  990, 1360, 1360,  991, 1179,
     1179, 1179, 1286, 1110, 1166, 1166, 1166, 1287, 1265, 1282,
     1282,  936, 1283, 1247, 1226, 1226, 1226, 1167, 1109, 1109,
     1228, 1229, 1229, 1283,  936, 1360, 1231, 1231, 1283, 1284,
     1284, 1284, 1283, 1028, 1168, 1169, 1170, 1171, 1296, 1180,
     1268, 1172, 1288, 1296, 1173, 1360, 1360, 1174, 1295, 1295,
     1175, 1184, 1184, 1184, 1009, 1296, 1296, 1010, 1151, 1151,
     1151, 1185, 1296, 1185, 1186, 1187, 1187, 1296, 1296, 1285,

      968, 1360, 1250, 1250, 1296, 1301, 1296, 1188, 1297, 1297,
     1297, 1262, 1262, 1301, 1296,  968, 1360, 1360,  907, 1201,
     1201, 1201, 1264, 1264, 1264, 1264, 1264, 1264, 1152, 1157,
     1301, 1157, 1158, 1159, 1159, 1301, 1294, 1300, 1300, 1264,
     1264, 1264, 1179, 1179, 1179, 1160, 1202, 1202, 1202, 1360,
     1270, 1270, 1301, 1301, 1301, 1301, 1203, 1304, 1203, 1204,
     1205, 1205,  990, 1301,  936,  990, 1282, 1282, 1341, 1301,
     1311, 1311, 1206, 1208, 1208, 1208, 1298, 1341,  936, 1265,
     1341,  936, 1180, 1302, 1302, 1302, 1209, 1159, 1159, 1341,
     1299, 1291, 1292, 1292, 1341,  936, 1284, 1284, 1284, 1341,

     1284, 1284, 1284, 1210, 1211, 1212, 1213, 1295, 1295, 1341,
     1214, 1300, 1300, 1215, 1328, 1328, 1216, 1360, 1360, 1217,
     1225, 1225, 1225, 1297, 1297, 1297, 1284, 1284, 1284, 1341,
     1185, 1341, 1185, 1186, 1187, 1187, 1009, 1340, 1340,  968,
     1009, 1289, 1289, 1289, 1349, 1341, 1188, 1226, 1226, 1226,
     1360, 1360,  968, 1151, 1151, 1151,  968, 1227, 1349, 1227,
     1228, 1229, 1229, 1303, 1348, 1348, 1285, 1349, 1297, 1297,
     1297, 1349, 1349, 1230, 1232, 1232, 1232, 1349, 1349,  936,
     1349, 1131,  968,  210, 1132, 1340, 1340, 1233, 1187, 1187,
     1302, 1302, 1302, 1152, 1308, 1309, 1309, 1072,  224, 1323,

     1264, 1264, 1264, 1349, 1234, 1235, 1236, 1237, 1302, 1302,
     1302, 1238, 1348, 1348, 1239,  615,  697, 1240,  749, 1349,
     1241, 1249, 1249, 1249,  936, 1179, 1179, 1179, 1284, 1284,
     1284, 1203,  832, 1203, 1204, 1205, 1205, 1360, 1311, 1311,
     1265, 1324, 1360, 1328, 1328,  863,  968, 1206, 1251, 1251,
     1251,  907,  908, 1028, 1094, 1122,  936, 1148, 1176, 1218,
     1242, 1252, 1205, 1205,  968, 1180, 1261, 1281, 1285, 1326,
     1322, 1325, 1339,  885,  884,  883,  882,  881, 1253, 1254,
     1255, 1256,  880,  879,  968, 1257,  878,  877, 1258,  876,
      875, 1259,  874,  873, 1260, 1266, 1266, 1266, 1266, 1266,

     1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266,
     1266, 1266, 1266, 1266, 1266, 1267, 1267, 1267, 1267, 1267,
     1267, 1266, 1266, 1266, 1266, 1267, 1267, 1267, 1267, 1267,
     1267, 1267, 1267, 1267, 1267, 1267, 1267, 1267, 1267, 1267,
     1267, 1267, 1267, 1267, 1267, 1267, 1267, 1267, 1267, 1267,
      872, 1266, 1266, 1266, 1269, 1269, 1269,  871,  870, 1306,
     1306, 1306,  869,  868, 1227,  867, 1227, 1228, 1229, 1229,
     1342, 1342, 1342, 1359, 1359, 1359,  866, 1264, 1264, 1264,
     1230, 1271, 1271, 1271,  865,  864,  845,  842, 1350, 1350,
     1350, 1284, 1284, 1284, 1272, 1229, 1229,  841,  840, 1131,

      839,  838, 1132,  837,  836, 1342, 1342, 1342,  835,  834,
     1343, 1273, 1274, 1275, 1276, 1072, 1360, 1265, 1277,  323,
      314, 1278,  833,  831, 1279, 1345, 1072, 1280, 1289, 1289,
     1289, 1285,  820,  936, 1342, 1342, 1342,  820, 1290, 1347,
     1290, 1291, 1292, 1292, 1072, 1131,  820,  968, 1342, 1342,
     1342,  820,  820,  820, 1293,  818, 1264, 1264, 1264,  817,
      816, 1072, 1350, 1350, 1350, 1028, 1305, 1305, 1305, 1284,
     1284, 1284,  815,  814, 1131,  813, 1290,  812, 1290, 1291,
     1292, 1292, 1350, 1350, 1350, 1351,  811,  810, 1343,  809,
     1072,  808, 1293, 1306, 1306, 1306, 1265,  807,  806, 1342,

     1342, 1342, 1352, 1307, 1072, 1307, 1308, 1309, 1309, 1285,
      805,  804,  936,  803,  802, 1353,  801,  800, 1072, 1310,
     1312, 1312, 1312,  799,  798,  968,  797,  796,  795,  794,
     1342, 1342, 1342, 1313, 1292, 1292,  793,  792, 1072, 1343,
     1354,  791,  788, 1356, 1356, 1356,  779,  779,  779,  779,
     1314, 1315, 1316, 1317,  779, 1072,  779, 1318,  777,  776,
     1319,  775,  774, 1320,  773,  772, 1321, 1327, 1327, 1327,
     1343,  771, 1342, 1342, 1342,  770,  769, 1307, 1357, 1307,
     1308, 1309, 1309, 1009,  768,  767, 1072,  766,  765,  764,
      763,  762,  255, 1310, 1329, 1329, 1329,  247,  761,  968,

      323,  760,  314,  759,  758,  755,  737, 1330, 1309, 1309,
      736,  735, 1343,  734,  733,  732,  731,  730, 1358,  729,
      728,  727,  726,  725, 1331, 1332, 1333, 1334, 1072,  724,
      723, 1335,  722,  721, 1336,  720,  719, 1337,  718,  717,
     1338, 1344, 1344, 1344,  716,  715,  714,  713,  712,  711,
      710, 1079,  709, 1079, 1080, 1081, 1081,  708,  707,  706,
      704,  704,  704,  704,  704,  704,  702, 1082,  701,  685,
      684,  683,  682,  681,  680,  679,  678,  677,  676,  675,
      672, 1152, 1346, 1346, 1346,  671,  670,  669,  668,  255,
      667,  247, 1107,  666, 1107, 1108, 1109, 1109,  665,  664,

      323,  663,  323,  662,  314,  661,  314,  660, 1110,  657,
      656,  655,  649,  648,  647,  646,  645,  644,  643,  642,
      641,  637, 1180, 1344, 1344, 1344,  636,  635,  634,  633,
      632,  631,  630, 1079,  629, 1079, 1080, 1081, 1081,  628,
      627,  626,  625,  624,  623,  622,  621,  620,  617, 1082,
      616,  603,  602,  601,  595,  594,  593,  592,  591,  590,
      589,  588,  587,  848, 1346, 1346, 1346,  586,  585,  582,
      579,  578,  577,  255, 1107,  576, 1107, 1108, 1109, 1109,
      255,  575,  247,  574,  247,  571,  570,  569,  568,  567,
     1110,  566,  565,  564,  563,  562,  561,  560,  559,  558,

      557,  556,  555,  554,  892, 1355, 1355, 1355,  551,  550,
      549,  548,  547,  546,  545, 1203,  544, 1203, 1204, 1205,
     1205,  543,  542,  541,  540,  539,  538,  537,  536,  535,
      534, 1206,  530,  529,  528,  527,  526,  525,  524,  518,
      517,  516,  515,  514,  513, 1265,  512,  511,  510,  509,
      508,  507,  506,  505,  504,  503,  502,  501,  500,  499,
      498,  936, 1356, 1356, 1356,  497,  496,  495,  494,  493,
      492,  491, 1227,  490, 1227, 1228, 1229, 1229,  489,  488,
      485,  484,  483,  482,  481,  480,  479,  478, 1230,  477,
      476,  475,  474,  473,  472,  471,  470,  467,  466,  462,

      461,  457, 1285,  456,  455,  454,  453,  452,  451,  450,
      449,  445,  440,  439,  438,  437,  436,  435,  968, 1355,
     1355, 1355,  434,  433,  432,  431,  430,  429,  428, 1203,
      427, 1203, 1204, 1205, 1205,  426,  425,  424,  423,  422,
      418,  343,  413,  412,  411, 1206,  410,  409,  408,  407,
      406,  405,  404,  403,  323,  323,  400,  323,  323,  990,
      399,  398,  314,  314,  395,  314,  314,  394,  393,  392,
      391,  390,  386,  385,  384,  936, 1359, 1359, 1359,  383,
      382,  381,  380,  377,  376,  375, 1307,  374, 1307, 1308,
     1309, 1309,  370,  367,  366,  365,  364,  363,  359,  353,

      352,  351, 1310,  350,  349,  348,  347,  346,  345,  344,
      343,  270, 1360,  339,  338,  255, 1343,  255,  335,  255,
      255,  334,  247,  247,  331,  247,  247,  330,  238,  236,
      329,  326, 1072,   46,   46,   46,   46,   46,   46,   46,
       46,   46,   46,   46,   46,   47,   47,   47,   47,   47,
       47,   47,   47,   47,   47,   47,   47,   50,   50,   50,
       50,   50,   50,   50,   50,   50,   50,   50,   50,   56,
       56,   56,   56,   56,   56,   56,   56,   56,   56,   56,
       56,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   63,   63,   63,   63,   63,   63,   63,

       63,   63,   63,   63,   63,   99,   99,   99,   99,   99,
       99,   99,   99,   99,   99,   99,   99,  107,  107,  107,
      107,  107,  107,  107,  107,  107,  107,  107,  107,  110,
      110,  110,  110,  110,  110,  110,  110,  110,  110,  110,
      110,  115,  115,  115,  115,  115,  115,  115,  115,  115,
      115,  115,  115,  118,  118,  118,  118,  118,  118,  118,
      118,  118,  118,  118,  118,  121,  121,  121,  121,  121,
      121,  121,  121,  121,  121,  121,  121,  125,  125,  125,
      125,  125,  125,  125,  125,  125,  125,  125,  125,  127,
      127,  127,  127,  127,  127,  127,  127,  127,  127,  127,

      127,  131,  131,  131,  131,  131,  131,  131,  131,  131,
      131,  131,  131,  133,  133,  133,  133,  133,  133,  133,
      133,  133,  133,  133,  133,  137,  137,  137,  137,  137,
      137,  137,  137,  137,  137,  137,  137,  148,  325,  324,
      148,  323,  148,  148,  148,  148,  148,  150,  322,  321,
      150,  150,  150,  150,  150,  150,  150,  164,  164,  225,
      164,  164,  164,  164,  164,  164,  164,  164,  164,  170,
      320,  317,  316,  170,  204,  315,  314,  204,  204,  204,
      204,  204,  204,  204,  313,  204,  206,  312,  206,  206,
      206,  207,  207,  235,  311,  310,  235,  235,  235,  235,

      235,  235,  235,  237,  309,  203,  237,  237,  237,  237,
      237,  237,  237,  240,  240,  240,  240,  240,  240,  240,
      240,  240,  303,  240,  240,  241,  241,  241,  241,  241,
      241,  241,  241,  290,  241,  241,  241,  243,  243,  243,
      243,  243,  243,  243,  243,  243,  243,  264,  285,  279,
      169,  264,  265,  265,  342,  342,  342,  342,  342,  342,
      342,  342,  342,  342,  342,  342,  926,  926,  926,  926,
      926,  926,  926,  926,  926,  169,  926,  926, 1266, 1266,
     1266, 1266, 1266, 1266, 1266, 1266, 1266, 1266,  263, 1266,
      262,  160,  261,  258,  257,  256,  255,  254,  151,  149,

      253,  250,  249,  248,  247,  246,  242,  239,  238,  236,
      234,  226,  225,  223,  203,  198,  169,  167,  166,  165,
      163,  162,  161,  160,  159,  151,  149,  147,  140, 1360,
      136,  136,  126,  126,   45, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360

    } ;

static yyconst flex_int16_t yy_chk[3395] =
    {   0,
        0,    0,    3,    4,    5,    0,    0,    5,    6,    0,
        0,    6,    9,    9,    9,    7,    7,    7,   23,    5,
        5,    5,   31,    6,    6,    6,    7,   24,   37,    5,
        8,    8,    8,    6,   10,   10,   10,   79,   79,   38,
      181,    8,   11,   23,  181,   11,   31,   12,   39,    5,
       12,   40,   24,    6,   37,    3,    4,   11,   11,   11,
      168,  168,   12,   12,   12,   38,    9,   11,    9,    7,
      197,    7,   12,   39,  146,   31,   40,   31,   43,   44,
       43,   44,  813,  197,    8,  146,    8,   11,   10,  175,
       10,  175,   12,   13,   13,   13,   13,   13,   13,   13,

       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   15,   15,   15,   15,   15,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
       15,   15,   15,   15,   15,   15,   15,   15,   15,   15,

       15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
       15,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
       19,   67,   54,   20,   54,  179,   54,   54,   54,  139,
      139,  139,  158,   54,  814,   19,   19,   19,   20,   20,
       20,  179,  183,  158,   91,   19,  252,  186,   20,  185,

       91,  183,   67,  186,   67,   91,   67,   67,   67,  252,
      185,  182,  182,   67,  815,   19,   91,  182,   20,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   25,  816,
       32,   26,   27,   27,   27,   28,   28,   28,   29,   29,
       29,  222,   35,   25,   25,   25,   26,   26,   26,   30,

       30,   30,  222,   25,   32,   36,   26,   83,  282,   83,
       83,   83,   83,  282,  180,  260,   35,  180,  180,  113,
      190,  193,  465,   25,  190,  193,   26,  195,  260,   36,
      195,  200,  200,   32,  193,   32,   27,  465,   27,   28,
      297,   28,   29,  233,   29,   35,  113,   35,  113,  290,
      113,  113,  113,   30,  233,   30,  297,  113,   36,  290,
       36,   81,   81,  817,   81,   81,   81,   81,   81,   81,
       81,   81,   81,   81,   81,   81,   81,   81,   81,   81,
       81,   81,   81,   81,   81,   81,   81,   81,   81,   81,
       81,   81,   81,   81,   81,   81,   81,   81,   81,   81,

       81,   81,   81,   81,   81,   81,   81,   81,   81,   81,
       81,   81,   81,   81,   81,   81,   81,   81,   81,   81,
       88,  818,   88,   95,   95,   95,   96,   96,   96,   98,
       98,   98,  102,  176,  176,  176,  177,  177,  177,  832,
      102,  346,  102,  346,  102,  102,  102,  187,  187,  187,
      346,  102,  281,  189,  189,  189,  281,  281,  177,  834,
      191,  191,  191,   98,  199,  199,  199,  284,  284,   98,
      201,  201,  201,  202,   88,  202,   98,   95,   98,  284,
       96,  305,  189,  208,  208,  208,  305,  835,  187,  176,
      189,  777,  177,  191,  194,  194,  194,  836,  194,  206,

      201,  307,  307,  187,  194,  206,  209,  209,  209,  189,
      206,  194,  194,  194,  306,  306,  191,  211,  211,  211,
      777,  206,  244,  244,  244,  837,  319,  202,  245,  245,
      245,  266,  266,  266,  267,  267,  267,  208,  292,  319,
      209,  328,  613,  306,  838,  292,  209,  340,  340,  340,
      292,  211,  385,  209,  328,  209,  344,  211,  613,  344,
      367,  379,  367,  840,  211,  385,  211,  382,  367,  379,
      369,  369,  344,  695,  344,  367,  382,  379,  445,  382,
      389,  389,  404,  404,  404,  521,  521,  266,  369,  695,
      267,  841,  445,  445,  486,  486,  486,  487,  487,  487,

      499,  598,  598,  340,  501,  501,  501,  527,  499,  389,
      520,  520,  520,  547,  842,  527,  608,  547,  843,  562,
      562,  562,  572,  572,  572,  608,  583,  583,  583,  605,
      605,  547,  597,  597,  597,  844,  404,  437,  437,  437,
      584,  584,  584,  604,  604,  604,  487,  437,  486,  437,
      437,  437,  437,  601,  601,  601,  606,  606,  501,  615,
      615,  615,  601,  437,  513,  513,  513,  651,  651,  651,
      848,  572,  584,  849,  513,  562,  513,  513,  513,  513,
      583,  652,  652,  687,  687,  655,  655,  655,  688,  688,
      513,  519,  519,  519,  655,  702,  656,  656,  656,  690,

      855,  519,  702,  519,  519,  519,  519,  601,  690,  659,
      659,  659,  658,  658,  658,  703,  703,  519,  522,  522,
      522,  673,  673,  673,  686,  686,  686,  857,  698,  698,
      698,  522,  522,  522,  659,  699,  699,  699,  742,  655,
      858,  697,  697,  697,  704,  704,  704,  742,  522,  522,
      522,  522,  656,  673,  859,  522,  739,  739,  522,  740,
      740,  522,  778,  778,  522,  558,  558,  558,  658,  705,
      705,  705,  738,  738,  738,  558,  860,  558,  558,  558,
      558,  697,  698,  747,  697,  749,  749,  749,  773,  699,
      862,  558,  596,  596,  596,  779,  779,  779,  864,  747,

      785,  785,  596,  773,  596,  596,  596,  596,  865,  750,
      750,  750,  754,  754,  754,  751,  751,  751,  596,  599,
      599,  599,  756,  756,  756,  749,  819,  819,  749,  753,
      753,  753,  599,  599,  599,  779,  866,  754,  779,  784,
      784,  784,  867,  780,  780,  780,  868,  756,  861,  599,
      599,  599,  599,  825,  825,  825,  599,  826,  826,  599,
      853,  853,  599,  750,  861,  599,  650,  650,  650,  751,
      854,  854,  781,  781,  781,  856,  650,  869,  650,  650,
      650,  650,  870,  780,  856,  753,  780,  872,  782,  782,
      782,  875,  650,  653,  653,  653,  876,  839,  839,  839,

      852,  852,  852,  820,  820,  820,  653,  653,  653,  781,
      877,  878,  781,  880,  882,  781,  821,  821,  821,  883,
      822,  822,  822,  653,  653,  653,  653,  782,  782,  884,
      653,  782,  885,  653,  886,  887,  653,  888,  890,  653,
      700,  700,  700,  820,  891,  892,  820,  823,  823,  823,
      700,  839,  700,  700,  700,  700,  821,  822,  893,  821,
      822,  897,  897,  822,  898,  898,  700,  752,  752,  752,
      899,  901,  829,  829,  829,  902,  903,  752,  904,  752,
      752,  752,  752,  831,  831,  831,  823,  823,  906,  908,
      823,  914,  915,  752,  786,  786,  786,  829,  896,  896,

      896,  833,  833,  833,  850,  850,  850,  786,  786,  786,
      851,  851,  851,  900,  905,  916,  917,  918,  921,  863,
      863,  863,  900,  922,  786,  786,  786,  786,  923,  924,
      905,  786,  925,  926,  786,  927,  928,  786,  938,  831,
      786,  827,  827,  827,  850,  850,  939,  850,  931,  931,
      851,  940,  943,  851,  827,  827,  827,  833,  851,  863,
      947,  951,  863,  894,  894,  894,  953,  895,  895,  895,
      954,  827,  827,  827,  827,  863,  955,  935,  827,  935,
      956,  827,  957,  959,  827,  960,  970,  827,  907,  907,
      907,  909,  909,  909,  912,  912,  912,  919,  919,  919,

      929,  929,  929,  894,  894,  971,  894,  895,  963,  963,
      895,  967,  972,  967,  973,  895,  980,  930,  930,  930,
      976,  976,  976,  977,  977,  981,  983,  984,  907,  985,
      986,  907,  932,  932,  932,  987,  933,  933,  933,  990,
      929,  991,  992,  929,  907,  993,  992,  909,  929,  994,
      912,  919,  920,  920,  920,  996,  993,  930,  997,  998,
      930, 1001,  920,  930,  920,  920,  920,  920,  934,  934,
      934, 1003,  932, 1004, 1005,  932,  933, 1006,  920,  933,
      961,  961,  961, 1009, 1010, 1013, 1014, 1015,  932,  962,
      962,  962,  933,  964,  964,  964, 1011,  965,  965,  965,

     1011,  966,  966,  966, 1012,  934, 1018, 1018,  934, 1019,
     1019,  934, 1017, 1017, 1017, 1012, 1020, 1021, 1022, 1023,
      961, 1024, 1025,  961,  934, 1027, 1021, 1026,  961,  962,
     1029, 1031,  962,  964, 1032,  962,  964,  965,  966, 1033,
      965,  966, 1041, 1026,  966, 1037, 1037, 1037, 1042,  964,
     1038, 1038, 1043,  965,  988,  988,  988,  966,  978,  978,
      978, 1045, 1047, 1043, 1049, 1044, 1050, 1051, 1007, 1007,
     1007,  978,  978,  978, 1044, 1052, 1056, 1056, 1056, 1057,
     1057, 1028, 1028, 1028, 1060, 1036, 1036, 1036,  978,  978,
      978,  978, 1061, 1063,  988,  978, 1065,  988,  978, 1062,

      988,  978, 1063, 1066,  978,  989,  989,  989, 1007, 1073,
     1062, 1007, 1067, 1067, 1007,  989, 1086,  989,  989,  989,
      989, 1028, 1080, 1080, 1028, 1036, 1088, 1071, 1036, 1071,
     1089,  989, 1090, 1055, 1055, 1055, 1091, 1028, 1084, 1084,
     1064, 1064, 1064, 1085, 1085,  989, 1093, 1095,  989, 1008,
     1008, 1008, 1079, 1079, 1079, 1083, 1083, 1083, 1087, 1008,
     1096, 1008, 1008, 1008, 1008, 1092, 1099, 1087, 1100, 1068,
     1068, 1068, 1102, 1055, 1114, 1008, 1055, 1094, 1094, 1094,
     1116, 1092, 1097, 1069, 1069, 1069, 1107, 1107, 1107, 1008,
     1115, 1097, 1008, 1034, 1034, 1034, 1064, 1108, 1108, 1115,

     1070, 1070, 1070, 1034, 1117, 1034, 1034, 1034, 1034, 1068,
     1112, 1112, 1068, 1118, 1078, 1078, 1078, 1094, 1119, 1034,
     1035, 1035, 1035, 1069, 1121, 1068, 1069, 1106, 1106, 1106,
     1035, 1123, 1035, 1035, 1035, 1035, 1124, 1070, 1129, 1069,
     1070, 1113, 1113, 1070, 1131, 1132, 1035, 1039, 1039, 1039,
     1111, 1111, 1111, 1120, 1078, 1134, 1070, 1078, 1140, 1125,
     1039, 1039, 1039, 1122, 1122, 1122, 1134, 1106, 1125, 1120,
     1106, 1127, 1127, 1127, 1135, 1135, 1135, 1039, 1039, 1039,
     1039, 1133, 1138, 1138, 1039, 1133, 1142, 1039, 1139, 1139,
     1039, 1141, 1143, 1039, 1053, 1053, 1053, 1137, 1137, 1137,

     1141, 1144, 1145, 1122, 1053, 1147, 1053, 1053, 1053, 1053,
     1146, 1148, 1148, 1148, 1149, 1149, 1150, 1150, 1150, 1153,
     1053, 1054, 1054, 1054, 1158, 1158, 1146, 1127, 1161, 1168,
     1135, 1054, 1170, 1054, 1054, 1054, 1054, 1151, 1151, 1151,
     1157, 1157, 1157, 1156, 1156, 1156, 1169, 1054, 1058, 1058,
     1058, 1171, 1152, 1152, 1152, 1169, 1150, 1165, 1165, 1165,
     1172, 1058, 1058, 1058, 1166, 1166, 1167, 1167, 1173, 1175,
     1181, 1174, 1176, 1176, 1176, 1177, 1177, 1151, 1058, 1058,
     1058, 1058, 1190, 1156, 1191, 1058, 1156, 1174, 1058, 1152,
     1195, 1058, 1152, 1210, 1058, 1076, 1076, 1076, 1212, 1156,

     1178, 1178, 1178, 1186, 1186, 1076, 1213, 1076, 1076, 1076,
     1076, 1179, 1179, 1179, 1185, 1185, 1185, 1184, 1184, 1184,
     1192, 1076, 1081, 1081, 1081, 1193, 1180, 1180, 1180, 1196,
     1196, 1192, 1204, 1204, 1193, 1081, 1081, 1081, 1208, 1208,
     1178, 1194, 1194, 1194, 1197, 1197, 1197, 1198, 1198, 1198,
     1214, 1179, 1081, 1081, 1081, 1081, 1215, 1184, 1211, 1081,
     1184, 1217, 1081, 1180, 1216, 1081, 1180, 1211, 1081, 1098,
     1098, 1098, 1234, 1184, 1199, 1199, 1199, 1209, 1209, 1098,
     1216, 1098, 1098, 1098, 1098, 1202, 1202, 1202, 1203, 1203,
     1203, 1207, 1207, 1207, 1236, 1098, 1237, 1194, 1218, 1218,

     1218, 1220, 1220, 1221, 1221, 1221, 1098, 1104, 1104, 1104,
     1222, 1222, 1222, 1238, 1199, 1199, 1239, 1104, 1241, 1104,
     1104, 1104, 1104, 1228, 1228, 1202, 1232, 1232, 1202, 1223,
     1223, 1223, 1243, 1104, 1109, 1109, 1109, 1244, 1218, 1233,
     1233, 1202, 1240, 1247, 1226, 1226, 1226, 1109, 1109, 1109,
     1227, 1227, 1227, 1235, 1218, 1231, 1231, 1231, 1240, 1242,
     1242, 1242, 1235, 1245, 1109, 1109, 1109, 1109, 1253, 1223,
     1223, 1109, 1245, 1255, 1109, 1251, 1251, 1109, 1252, 1252,
     1109, 1126, 1126, 1126, 1226, 1256, 1257, 1226, 1248, 1248,
     1248, 1126, 1258, 1126, 1126, 1126, 1126, 1254, 1259, 1242,

     1226, 1250, 1250, 1250, 1260, 1273, 1254, 1126, 1261, 1261,
     1261, 1262, 1262, 1275, 1259, 1242, 1271, 1271, 1126, 1154,
     1154, 1154, 1263, 1263, 1263, 1264, 1264, 1264, 1248, 1154,
     1276, 1154, 1154, 1154, 1154, 1277, 1248, 1272, 1272, 1265,
     1265, 1265, 1268, 1268, 1268, 1154, 1155, 1155, 1155, 1270,
     1270, 1270, 1278, 1279, 1274, 1280, 1155, 1286, 1155, 1155,
     1155, 1155, 1263, 1274, 1261, 1264, 1282, 1282, 1314, 1279,
     1291, 1291, 1155, 1159, 1159, 1159, 1265, 1316, 1263, 1265,
     1315, 1264, 1268, 1281, 1281, 1281, 1159, 1159, 1159, 1315,
     1268, 1290, 1290, 1290, 1317, 1265, 1283, 1283, 1283, 1318,

     1284, 1284, 1284, 1159, 1159, 1159, 1159, 1295, 1295, 1319,
     1159, 1300, 1300, 1159, 1308, 1308, 1159, 1312, 1312, 1159,
     1182, 1182, 1182, 1296, 1296, 1296, 1285, 1285, 1285, 1320,
     1182, 1321, 1182, 1182, 1182, 1182, 1283, 1313, 1313, 1281,
     1284, 1289, 1289, 1289, 1331, 1320, 1182, 1183, 1183, 1183,
     1329, 1329, 1283, 1294, 1294, 1294, 1284, 1183, 1332, 1183,
     1183, 1183, 1183, 1285, 1330, 1330, 1285, 1332, 1297, 1297,
     1297, 1333, 1334, 1183, 1187, 1187, 1187, 1335, 1336, 1296,
     1338, 1289, 1285, 1385, 1289, 1340, 1340, 1187, 1187, 1187,
     1301, 1301, 1301, 1294, 1307, 1307, 1307, 1289, 1386, 1294,

     1298, 1298, 1298, 1337, 1187, 1187, 1187, 1187, 1302, 1302,
     1302, 1187, 1348, 1348, 1187, 1395, 1396, 1187, 1397, 1337,
     1187, 1200, 1200, 1200, 1297, 1299, 1299, 1299, 1303, 1303,
     1303, 1200, 1398, 1200, 1200, 1200, 1200, 1311, 1311, 1311,
     1298, 1298, 1328, 1328, 1328, 1399, 1301, 1200, 1205, 1205,
     1205, 1400, 1401, 1403, 1404, 1405, 1298, 1406, 1407, 1408,
     1409, 1205, 1205, 1205, 1302, 1299, 1410, 1411, 1303, 1303,
     1413, 1299, 1414,  812,  811,  810,  809,  808, 1205, 1205,
     1205, 1205,  807,  804, 1303, 1205,  803,  802, 1205,  801,
      799, 1205,  798,  797, 1205, 1219, 1219, 1219, 1219, 1219,

     1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
     1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
     1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
     1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
     1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219, 1219,
      796, 1219, 1219, 1219, 1224, 1224, 1224,  795,  794, 1306,
     1306, 1306,  793,  792, 1224,  791, 1224, 1224, 1224, 1224,
     1322, 1322, 1322, 1359, 1359, 1359,  790, 1324, 1324, 1324,
     1224, 1229, 1229, 1229,  789,  788,  774,  772, 1339, 1339,
     1339, 1326, 1326, 1326, 1229, 1229, 1229,  768,  767, 1306,

      766,  765, 1306,  764,  763, 1341, 1341, 1341,  762,  761,
     1322, 1229, 1229, 1229, 1229, 1306, 1359, 1324, 1229,  760,
      759, 1229,  758,  755, 1229, 1324, 1322, 1229, 1246, 1246,
     1246, 1326,  748, 1324, 1342, 1342, 1342,  746, 1246, 1326,
     1246, 1246, 1246, 1246, 1339, 1341,  745, 1326, 1343, 1343,
     1343,  744,  743,  741, 1246,  737, 1345, 1345, 1345,  736,
      735, 1341, 1349, 1349, 1349, 1246, 1287, 1287, 1287, 1347,
     1347, 1347,  734,  733, 1342,  732, 1287,  730, 1287, 1287,
     1287, 1287, 1350, 1350, 1350, 1343,  729,  728, 1343,  727,
     1342,  726, 1287, 1288, 1288, 1288, 1345,  725,  724, 1351,

     1351, 1351, 1345, 1288, 1343, 1288, 1288, 1288, 1288, 1347,
      723,  721, 1345,  720,  719, 1347,  718,  717, 1349, 1288,
     1292, 1292, 1292,  716,  715, 1347,  713,  712,  711,  710,
     1354, 1354, 1354, 1292, 1292, 1292,  709,  708, 1350, 1351,
     1351,  706,  701, 1356, 1356, 1356,  696,  694,  693,  692,
     1292, 1292, 1292, 1292,  691, 1351,  689, 1292,  685,  684,
     1292,  683,  682, 1292,  681,  680, 1292, 1304, 1304, 1304,
     1354,  679, 1357, 1357, 1357,  678,  677, 1304, 1354, 1304,
     1304, 1304, 1304, 1356,  676,  674, 1354,  672,  671,  670,
      669,  668,  667, 1304, 1309, 1309, 1309,  666,  665, 1356,

      664,  663,  662,  661,  660,  657,  649, 1309, 1309, 1309,
      647,  646, 1357,  645,  644,  643,  642,  641, 1357,  640,
      639,  638,  637,  636, 1309, 1309, 1309, 1309, 1357,  635,
      634, 1309,  633,  632, 1309,  631,  630, 1309,  629,  628,
     1309, 1323, 1323, 1323,  626,  625,  624,  623,  622,  621,
      620, 1323,  619, 1323, 1323, 1323, 1323,  618,  617,  616,
      614,  612,  611,  610,  609,  607,  603, 1323,  602,  595,
      594,  593,  592,  591,  590,  589,  588,  587,  586,  585,
      582, 1323, 1325, 1325, 1325,  581,  580,  579,  578,  577,
      576,  575, 1325,  574, 1325, 1325, 1325, 1325,  573,  571,

      570,  569,  568,  567,  566,  565,  564,  563, 1325,  561,
      560,  559,  557,  556,  555,  554,  553,  552,  551,  550,
      549,  546, 1325, 1344, 1344, 1344,  545,  544,  543,  542,
      541,  540,  539, 1344,  538, 1344, 1344, 1344, 1344,  537,
      535,  534,  533,  532,  531,  530,  529,  528,  526, 1344,
      525,  516,  515,  514,  512,  511,  510,  509,  508,  507,
      506,  505,  504, 1344, 1346, 1346, 1346,  503,  502,  500,
      498,  497,  495,  494, 1346,  493, 1346, 1346, 1346, 1346,
      492,  491,  490,  489,  488,  485,  484,  483,  482,  481,
     1346,  480,  479,  478,  477,  476,  475,  474,  472,  471,

      469,  468,  467,  466, 1346, 1352, 1352, 1352,  464,  463,
      462,  461,  460,  459,  458, 1352,  457, 1352, 1352, 1352,
     1352,  456,  454,  453,  452,  451,  450,  449,  448,  447,
      446, 1352,  444,  443,  442,  441,  440,  439,  438,  436,
      435,  434,  433,  432,  431, 1352,  430,  429,  428,  427,
      426,  425,  424,  422,  421,  420,  419,  418,  417,  416,
      415, 1352, 1353, 1353, 1353,  414,  413,  412,  411,  410,
      409,  408, 1353,  407, 1353, 1353, 1353, 1353,  406,  405,
      403,  402,  401,  400,  398,  397,  396,  395, 1353,  394,
      393,  392,  391,  390,  388,  387,  386,  384,  383,  381,

      380,  378, 1353,  377,  376,  375,  374,  373,  372,  371,
      370,  368,  366,  365,  364,  363,  362,  361, 1353, 1355,
     1355, 1355,  360,  359,  358,  357,  356,  355,  354, 1355,
      353, 1355, 1355, 1355, 1355,  351,  350,  349,  348,  347,
      345,  342,  339,  338,  337, 1355,  336,  335,  334,  333,
      332,  331,  330,  329,  327,  326,  325,  324,  322, 1355,
      321,  320,  318,  317,  316,  315,  313,  312,  311,  310,
      309,  308,  304,  303,  302, 1355, 1358, 1358, 1358,  301,
      300,  299,  298,  296,  295,  294, 1358,  293, 1358, 1358,
     1358, 1358,  291,  289,  288,  287,  286,  285,  283,  280,

      279,  278, 1358,  277,  276,  275,  274,  273,  272,  271,
      270,  269,  264,  262,  261,  259, 1358,  258,  257,  256,
      254,  253,  251,  250,  249,  248,  246,  242,  238,  236,
      234,  232, 1358, 1361, 1361, 1361, 1361, 1361, 1361, 1361,
     1361, 1361, 1361, 1361, 1361, 1362, 1362, 1362, 1362, 1362,
     1362, 1362, 1362, 1362, 1362, 1362, 1362, 1363, 1363, 1363,
     1363, 1363, 1363, 1363, 1363, 1363, 1363, 1363, 1363, 1364,
     1364, 1364, 1364, 1364, 1364, 1364, 1364, 1364, 1364, 1364,
     1364, 1365, 1365, 1365, 1365, 1365, 1365, 1365, 1365, 1365,
     1365, 1365, 1365, 1366, 1366, 1366, 1366, 1366, 1366, 1366,

     1366, 1366, 1366, 1366, 1366, 1367, 1367, 1367, 1367, 1367,
     1367, 1367, 1367, 1367, 1367, 1367, 1367, 1368, 1368, 1368,
     1368, 1368, 1368, 1368, 1368, 1368, 1368, 1368, 1368, 1369,
     1369, 1369, 1369, 1369, 1369, 1369, 1369, 1369, 1369, 1369,
     1369, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370, 1370,
     1370, 1370, 1370, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
     1371, 1371, 1371, 1371, 1371, 1372, 1372, 1372, 1372, 1372,
     1372, 1372, 1372, 1372, 1372, 1372, 1372, 1373, 1373, 1373,
     1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373, 1374,
     1374, 1374, 1374, 1374, 1374, 1374, 1374, 1374, 1374, 1374,

     1374, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375, 1375,
     1375, 1375, 1375, 1376, 1376, 1376, 1376, 1376, 1376, 1376,
     1376, 1376, 1376, 1376, 1376, 1377, 1377, 1377, 1377, 1377,
     1377, 1377, 1377, 1377, 1377, 1377, 1377, 1378,  231,  230,
     1378,  229, 1378, 1378, 1378, 1378, 1378, 1379,  228,  226,
     1379, 1379, 1379, 1379, 1379, 1379, 1379, 1380, 1380,  225,
     1380, 1380, 1380, 1380, 1380, 1380, 1380, 1380, 1380, 1381,
      223,  221,  220, 1381, 1382,  219,  218, 1382, 1382, 1382,
     1382, 1382, 1382, 1382,  217, 1382, 1383,  215, 1383, 1383,
     1383, 1384, 1384, 1387,  214,  213, 1387, 1387, 1387, 1387,

     1387, 1387, 1387, 1388,  212,  203, 1388, 1388, 1388, 1388,
     1388, 1388, 1388, 1389, 1389, 1389, 1389, 1389, 1389, 1389,
     1389, 1389,  196, 1389, 1389, 1390, 1390, 1390, 1390, 1390,
     1390, 1390, 1390,  192, 1390, 1390, 1390, 1391, 1391, 1391,
     1391, 1391, 1391, 1391, 1391, 1391, 1391, 1392,  188,  184,
      170, 1392, 1393, 1393, 1394, 1394, 1394, 1394, 1394, 1394,
     1394, 1394, 1394, 1394, 1394, 1394, 1402, 1402, 1402, 1402,
     1402, 1402, 1402, 1402, 1402,  169, 1402, 1402, 1412, 1412,
     1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,  167, 1412,
      161,  160,  159,  157,  156,  155,  154,  153,  151,  149,

      147,  145,  144,  143,  142,  141,  135,  124,  120,  117,
      114,  109,  108,  103,   93,   82,   80,   78,   77,   76,
       74,   73,   72,   70,   68,   62,   58,   55,   52,   45,
       42,   41,   34,   33, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360, 1360,
     1360, 1360, 1360, 1360

    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "detex.l"

#line 89 "detex.l"
#undef IGNORE

#define	LaBEGIN		if (fLatex) BEGIN
#define	IGNORE		if (fSpace && !fWord) putchar(' ')
#define NOUN		if (fSpace && !fWord && !fReplace) putchar(' '); else {if (fReplace) printf("noun");}
#define VERBNOUN		if (fReplace) printf(" verbs noun"); /* puts a verb and a noun to make grammar checking work */
#define	SPACE		if (!fWord) putchar(' ')
#define	NEWLINE		if (!fWord) putchar('\n')
#define	LATEX		fLatex=!fForcetex
#define KILLARGS(x)	cArgs=x; LaBEGIN LaMacro
#define STRIPARGS(x)	cArgs=x; LaBEGIN LaMacro2
#define	CITE(x)		if (fLatex && !fCite) KILLARGS(x)

#define NO_MALLOC_DECL

void AddInclude(char *sbFile);
void ErrorExit(const char *sb1);
void UsageExit(void);
void IncludeFile(char *sbFile);
void InputFile(char *sbFile);
void SetEnvIgnore(const char *sbEnvList);
#ifndef KPATHSEA
void SetInputPaths(void);
#endif
void Warning(const char *sb1, const char *sb2);
int BeginEnv(const char *sbEnv);
int EndEnv(const char *sbEnv);
int InList(char *sbFile);
int SeparateList(char *sbList, char *rgsbList[] ,char chSep, int csbMax);
FILE *TexOpen(char *sbFile);
char *SafeMalloc(int cch, const char *sbMessage);
#ifndef KPATHSEA
char *getenv();
#ifndef NO_MALLOC_DECL
char	*malloc();
#endif
#ifdef OS2
void	yyless(int);
void	OS2UsageExit(void);
#endif
#endif /* KPATHSEA */

char	*rgsbEnvIgnore[MAXENVS];	/* list of environments ignored */
char	*rgsbIncList[MAXINCLIST];	/* list of includeonly files */
char	*rgsbInputPaths[MAXINPUTPATHS];	/* list of input paths in order */
char	sbCurrentIgnoredEnv[CCHMAXENV];	/* current environment being ignored */
char	*sbProgName;			/* name we were invoked with */
#ifndef NOFILE /* might be defined in <sys/param.h> */
#define NOFILE 256
#endif
FILE	*rgfp[NOFILE+1];		/* stack of input/include files */
int	cfp = 0;			/* count of files in stack */
int	cOpenBrace = 0;			/* count of `{' in <LaMacro> and <LaMacro2> */
int	cArgs = 0;			/* argument connt in <LaArgs> */
int	csbEnvIgnore;			/* count of environments ignored */
int	csbIncList = 0;			/* count of includeonly files */
int	csbInputPaths;			/* count of input paths */
int	fLatex = 0;			/* flag to indicated delatex */
int	fWord = 0;			/* flag for -w option */
int	fFollow = 1;			/* flag to follow input/include */
int	fCite = 0;			/* flag to echo \cite and \ref args */
int	fSpace = 0;			/* flag to replace \cs with space */
int	fForcetex = 0;			/* flag to inhibit latex mode */
int fShowPictures = 0;  /* flag to show picture names */
int fReplace = 0;  /* flag to replace envirnments with "noun" */

int currBracesLevel = 0;
int footnoteLevel = -100;

#ifdef FLEX_SCANNER
/* flex has contexts for buffers that need to be switched when file changes
 * otherwise output contains imported files in reverse order.  Weird, but
 * true.
 */
YY_BUFFER_STATE rgsb[NOFILE + 1]; /* flex context stack */
int             csb = 0;		 /* depth of flex context stack */
#endif /* FLEX_SCANNER */



 

#line 1824 "lex.yy.c"

#define INITIAL 0
#define Define 1
#define Display 2
#define IncludeOnly 3
#define Input 4
#define Math 5
#define Normal 6
#define Control 7
#define LaBegin 8
#define LaDisplay 9
#define LaEnd 10
#define LaEnv 11
#define LaFormula 12
#define LaInclude 13
#define LaSubfile 14
#define LaMacro 15
#define LaOptArg 16
#define LaMacro2 17
#define LaOptArg2 18
#define LaVerbatim 19
#define LaBreak 20
#define LaPicture 21

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy (void );

int yyget_debug (void );

void yyset_debug (int debug_flag  );

YY_EXTRA_TYPE yyget_extra (void );

void yyset_extra (YY_EXTRA_TYPE user_defined  );

FILE *yyget_in (void );

void yyset_in  (FILE * _in_str  );

FILE *yyget_out (void );

void yyset_out  (FILE * _out_str  );

			int yyget_leng (void );

char *yyget_text (void );

int yyget_lineno (void );

void yyset_lineno (int _line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap (void );
#else
extern int yywrap (void );
#endif
#endif

#ifndef YY_NO_UNPUT
    
    static void yyunput (int c,char *buf_ptr  );
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer(yyin,YY_BUF_SIZE );
		}

		yy_load_buffer_state( );
		}

	{
#line 187 "detex.l"

#line 2065 "lex.yy.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 1361 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (flex_int16_t) yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 1360 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 188 "detex.l"
/* ignore comments */	;
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 190 "detex.l"
{LATEX; IGNORE;}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 192 "detex.l"
/* environment start */	{LaBEGIN LaBegin; IGNORE;}
	YY_BREAK
case 4:
/* rule 4 can match eol */
YY_RULE_SETUP
#line 194 "detex.l"
{ if (BeginEnv("verbatim"))
							BEGIN LaEnv;
						    else
							BEGIN LaVerbatim;
						    IGNORE;
						}
	YY_BREAK
case 5:
/* rule 5 can match eol */
YY_RULE_SETUP
#line 201 "detex.l"
/* verbatim mode */	{BEGIN Normal; IGNORE;}
	YY_BREAK
case 6:
/* rule 6 can match eol */
YY_RULE_SETUP
#line 202 "detex.l"
ECHO;
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 203 "detex.l"
ECHO;
	YY_BREAK
case 8:
/* rule 8 can match eol */
YY_RULE_SETUP
#line 205 "detex.l"
{ KILLARGS(1);
						  if (BeginEnv("minipage"))
							BEGIN LaEnv;
						  else
							BEGIN LaMacro; /* Normal; */
						  IGNORE;
						}
	YY_BREAK
case 9:
/* rule 9 can match eol */
YY_RULE_SETUP
#line 213 "detex.l"
{
						  if (BeginEnv("table"))
							BEGIN LaEnv;
						  else
							BEGIN Normal;
						  IGNORE;
						}
	YY_BREAK
case 10:
/* rule 10 can match eol */
YY_RULE_SETUP
#line 221 "detex.l"
{
						  if (BeginEnv("figure"))
							BEGIN LaEnv;
						  else
							BEGIN Normal;
						  IGNORE;
						}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 229 "detex.l"
{ if (BeginEnv(yytext))
							BEGIN LaEnv;
						    else
							BEGIN Normal;
						    IGNORE;
						}
	YY_BREAK
/*<LaBegin>"\n"					NEWLINE;*/
case 12:
YY_RULE_SETUP
#line 236 "detex.l"
;
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 238 "detex.l"
/* absorb some environments */	{LaBEGIN LaEnd; IGNORE;}
	YY_BREAK
case 14:
/* rule 14 can match eol */
YY_RULE_SETUP
#line 239 "detex.l"
;/*NEWLINE;*/
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 240 "detex.l"
;
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 242 "detex.l"
/* end environment */	{   if (EndEnv(yytext))
							BEGIN Normal;
						    IGNORE;
						}
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 246 "detex.l"
{BEGIN LaEnv; IGNORE;}
	YY_BREAK
/*<LaEnd>"\n"					NEWLINE;*/
case 18:
YY_RULE_SETUP
#line 248 "detex.l"
;
	YY_BREAK
case 19:
/* rule 19 can match eol */
YY_RULE_SETUP
#line 250 "detex.l"
;
	YY_BREAK
case 20:
/* rule 20 can match eol */
YY_RULE_SETUP
#line 251 "detex.l"
;
	YY_BREAK
case 21:
/* rule 21 can match eol */
YY_RULE_SETUP
#line 252 "detex.l"
;
	YY_BREAK
case 22:
/* rule 22 can match eol */
YY_RULE_SETUP
#line 253 "detex.l"
;
	YY_BREAK
case 23:
/* rule 23 can match eol */
YY_RULE_SETUP
#line 254 "detex.l"
;
	YY_BREAK
case 24:
/* rule 24 can match eol */
YY_RULE_SETUP
#line 255 "detex.l"
;
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 256 "detex.l"
; /* hack to fix \begin{minipage}{300pt} */
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 258 "detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 259 "detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 260 "detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 261 "detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 262 "detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 263 "detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 264 "detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 265 "detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 266 "detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 267 "detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 268 "detex.l"
{ STRIPARGS(2); }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 269 "detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 270 "detex.l"
{ STRIPARGS(2); }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 271 "detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 272 "detex.l"
;
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 273 "detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 42:
/* rule 42 can match eol */
YY_RULE_SETUP
#line 274 "detex.l"
{ LaBEGIN LaPicture; }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 276 "detex.l"
;
	YY_BREAK
case 44:
/* rule 44 can match eol */
YY_RULE_SETUP
#line 277 "detex.l"
{ if(fShowPictures) { printf("<Picture %s>", yytext); } }
	YY_BREAK
case 45:
/* rule 45 can match eol */
YY_RULE_SETUP
#line 278 "detex.l"
BEGIN Normal;
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 279 "detex.l"
BEGIN Normal;
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 281 "detex.l"
{ KILLARGS(3); }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 282 "detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 283 "detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 284 "detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 285 "detex.l"
{ KILLARGS(3); }
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 286 "detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 287 "detex.l"
{ STRIPARGS(1); }
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 288 "detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 289 "detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 290 "detex.l"
{ KILLARGS(3); }
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 292 "detex.l"
;/*NEWLINE;*/
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 293 "detex.l"
;/*NEWLINE;*/
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 294 "detex.l"
;/*NEWLINE;*/
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 295 "detex.l"
;/*NEWLINE;*/
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 296 "detex.l"
;/*NEWLINE;*/
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 297 "detex.l"
;/*NEWLINE;*/
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 298 "detex.l"
;/*NEWLINE;*/
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 300 "detex.l"
/* ignore args  */	{KILLARGS(1); IGNORE;}
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 301 "detex.l"
/* of these \cs */	{KILLARGS(1); IGNORE;}
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 302 "detex.l"
{KILLARGS(1); IGNORE;}
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 303 "detex.l"
{KILLARGS(1);} /* kill space before */
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 304 "detex.l"
{LATEX; KILLARGS(1); IGNORE;}
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 305 "detex.l"
{LATEX; KILLARGS(1); IGNORE;}
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 306 "detex.l"
{KILLARGS(1); IGNORE;}
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 307 "detex.l"
{KILLARGS(1); IGNORE;}
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 308 "detex.l"
{KILLARGS(1);}
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 309 "detex.l"
{KILLARGS(1);}
	YY_BREAK
/*<Normal>"\\footnote"				{KILLARGS(1); SPACE;}*/
case 74:
YY_RULE_SETUP
#line 311 "detex.l"
{KILLARGS(1); IGNORE;}
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 312 "detex.l"
{CITE(1); IGNORE;}
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 313 "detex.l"
{CITE(1); IGNORE;}
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 314 "detex.l"
{KILLARGS(1); IGNORE;}
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 315 "detex.l"
{CITE(1); IGNORE;}
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 316 "detex.l"
{KILLARGS(2); IGNORE;}
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 317 "detex.l"
{KILLARGS(2); IGNORE;}
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 318 "detex.l"
{ KILLARGS(1); }
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 319 "detex.l"
{ KILLARGS(2); }
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 321 "detex.l"
{KILLARGS(1);}
	YY_BREAK
case 84:
/* rule 84 can match eol */
YY_RULE_SETUP
#line 323 "detex.l"
{
							putchar('(');
							footnoteLevel = currBracesLevel;
							++currBracesLevel;
							}
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 328 "detex.l"
/* ignore \verb<ch>...<ch> */	{   if (fLatex) {
						 	char verbchar, c;
						 	verbchar = input();
						 	while ((c = input()) != verbchar)
							    /*if (c == '\n')
								NEWLINE;*/
								putchar(c);
						    }
						    IGNORE;
						}
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 339 "detex.l"
{ LATEX; KILLARGS(2); }
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 340 "detex.l"
{ LATEX; KILLARGS(2); }
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 341 "detex.l"
{ LATEX; KILLARGS(3); }
	YY_BREAK
case 89:
YY_RULE_SETUP
#line 343 "detex.l"
/* ignore def begin */	{BEGIN Define; IGNORE;}
	YY_BREAK
case 90:
YY_RULE_SETUP
#line 344 "detex.l"
BEGIN Normal;
	YY_BREAK
case 91:
/* rule 91 can match eol */
YY_RULE_SETUP
#line 345 "detex.l"
NEWLINE;
	YY_BREAK
case 92:
YY_RULE_SETUP
#line 346 "detex.l"
;
	YY_BREAK
case 93:
YY_RULE_SETUP
#line 348 "detex.l"
/* formula mode */	{LaBEGIN LaFormula; NOUN;}
	YY_BREAK
case 94:
YY_RULE_SETUP
#line 349 "detex.l"
BEGIN Normal;
	YY_BREAK
case 95:
/* rule 95 can match eol */
YY_RULE_SETUP
#line 350 "detex.l"
NEWLINE;
	YY_BREAK
case 96:
YY_RULE_SETUP
#line 351 "detex.l"
VERBNOUN;
	YY_BREAK
case 97:
YY_RULE_SETUP
#line 352 "detex.l"
;
	YY_BREAK
case 98:
YY_RULE_SETUP
#line 354 "detex.l"
/* display mode */	{LaBEGIN LaDisplay; NOUN;}
	YY_BREAK
case 99:
YY_RULE_SETUP
#line 355 "detex.l"
BEGIN Normal;
	YY_BREAK
case 100:
/* rule 100 can match eol */
YY_RULE_SETUP
#line 356 "detex.l"
NEWLINE;
	YY_BREAK
case 101:
YY_RULE_SETUP
#line 357 "detex.l"
VERBNOUN;
	YY_BREAK
case 102:
YY_RULE_SETUP
#line 358 "detex.l"
;
	YY_BREAK
case 103:
YY_RULE_SETUP
#line 360 "detex.l"
/* display mode */	{BEGIN Display; NOUN;}
	YY_BREAK
case 104:
YY_RULE_SETUP
#line 361 "detex.l"
BEGIN Normal;
	YY_BREAK
case 105:
/* rule 105 can match eol */
YY_RULE_SETUP
#line 362 "detex.l"
NEWLINE;
	YY_BREAK
case 106:
YY_RULE_SETUP
#line 363 "detex.l"
VERBNOUN;
	YY_BREAK
case 107:
YY_RULE_SETUP
#line 364 "detex.l"
;
	YY_BREAK
case 108:
YY_RULE_SETUP
#line 366 "detex.l"
/* math mode */		{BEGIN Math; NOUN;}
	YY_BREAK
case 109:
YY_RULE_SETUP
#line 367 "detex.l"
BEGIN Normal;
	YY_BREAK
case 110:
/* rule 110 can match eol */
YY_RULE_SETUP
#line 368 "detex.l"
;
	YY_BREAK
case 111:
YY_RULE_SETUP
#line 369 "detex.l"
;
	YY_BREAK
case 112:
YY_RULE_SETUP
#line 370 "detex.l"
VERBNOUN;
	YY_BREAK
case 113:
YY_RULE_SETUP
#line 371 "detex.l"
;
	YY_BREAK
case 114:
YY_RULE_SETUP
#line 373 "detex.l"
/* process files */	{LaBEGIN LaInclude; IGNORE;}
	YY_BREAK
case 115:
YY_RULE_SETUP
#line 374 "detex.l"
{   IncludeFile(yytext);
						    BEGIN Normal;
						}
	YY_BREAK
case 116:
/* rule 116 can match eol */
YY_RULE_SETUP
#line 377 "detex.l"
NEWLINE;
	YY_BREAK
case 117:
YY_RULE_SETUP
#line 378 "detex.l"
;
	YY_BREAK
case 118:
YY_RULE_SETUP
#line 380 "detex.l"
{BEGIN IncludeOnly; IGNORE;}
	YY_BREAK
case 119:
YY_RULE_SETUP
#line 381 "detex.l"
AddInclude(yytext);
	YY_BREAK
case 120:
YY_RULE_SETUP
#line 382 "detex.l"
{   if (csbIncList == 0)
							rgsbIncList[csbIncList++] = '\0';
						    BEGIN Normal;
						}
	YY_BREAK
case 121:
/* rule 121 can match eol */
YY_RULE_SETUP
#line 386 "detex.l"
NEWLINE;
	YY_BREAK
case 122:
YY_RULE_SETUP
#line 387 "detex.l"
;
	YY_BREAK
case 123:
YY_RULE_SETUP
#line 389 "detex.l"
/* process files */	{LaBEGIN LaSubfile; IGNORE;}
	YY_BREAK
case 124:
YY_RULE_SETUP
#line 390 "detex.l"
{   IncludeFile(yytext);
						    BEGIN Normal;
						}
	YY_BREAK
case 125:
/* rule 125 can match eol */
YY_RULE_SETUP
#line 393 "detex.l"
NEWLINE;
	YY_BREAK
case 126:
YY_RULE_SETUP
#line 394 "detex.l"
;
	YY_BREAK
case 127:
YY_RULE_SETUP
#line 396 "detex.l"
{BEGIN Input; IGNORE;}
	YY_BREAK
case 128:
YY_RULE_SETUP
#line 397 "detex.l"
{   InputFile(yytext);
						    BEGIN Normal;
						}
	YY_BREAK
case 129:
/* rule 129 can match eol */
YY_RULE_SETUP
#line 400 "detex.l"
NEWLINE;
	YY_BREAK
case 130:
YY_RULE_SETUP
#line 401 "detex.l"
;
	YY_BREAK
/* escaping commands */
case 131:
YY_RULE_SETUP
#line 404 "detex.l"
putchar('/');
	YY_BREAK
case 132:
/* rule 132 can match eol */
YY_RULE_SETUP
#line 406 "detex.l"
/* handle ligatures */	{(void)printf("%.2s", yytext+1);}
	YY_BREAK
case 133:
/* rule 133 can match eol */
YY_RULE_SETUP
#line 407 "detex.l"
{(void)printf("%.1s", yytext+1);}
	YY_BREAK
case 134:
YY_RULE_SETUP
#line 408 "detex.l"
{NEWLINE;}	/*BEGIN LaBreak;*/
	YY_BREAK
case 135:
YY_RULE_SETUP
#line 410 "detex.l"
/* ignore other \cs */	{BEGIN Control; IGNORE;}
	YY_BREAK
case 136:
YY_RULE_SETUP
#line 411 "detex.l"
SPACE;
	YY_BREAK
case 137:
/* rule 137 can match eol */
YY_RULE_SETUP
#line 412 "detex.l"
NEWLINE;
	YY_BREAK
case 138:
YY_RULE_SETUP
#line 413 "detex.l"
IGNORE;
	YY_BREAK
case 139:
YY_RULE_SETUP
#line 414 "detex.l"
{  if (yytext==NULL || strlen(yytext)==0
							|| atoi(yytext)>=0)
							NEWLINE;
						BEGIN Normal;
						}
	YY_BREAK
case 140:
YY_RULE_SETUP
#line 420 "detex.l"
IGNORE;
	YY_BREAK
case 141:
YY_RULE_SETUP
#line 421 "detex.l"
IGNORE;
	YY_BREAK
case 142:
/* rule 142 can match eol */
YY_RULE_SETUP
#line 422 "detex.l"
{BEGIN Normal; /*NEWLINE;*/}
	YY_BREAK
case 143:
YY_RULE_SETUP
#line 423 "detex.l"
{++currBracesLevel;BEGIN Normal; IGNORE;}
	YY_BREAK
case 144:
YY_RULE_SETUP
#line 424 "detex.l"
{BEGIN Normal; IGNORE;}
	YY_BREAK
case 145:
YY_RULE_SETUP
#line 425 "detex.l"
{yyless(0);BEGIN Normal;}
	YY_BREAK
case 146:
YY_RULE_SETUP
#line 427 "detex.l"
/* special characters */	IGNORE;
	YY_BREAK
case 147:
YY_RULE_SETUP
#line 428 "detex.l"
IGNORE;
	YY_BREAK
case 148:
YY_RULE_SETUP
#line 429 "detex.l"
SPACE;
	YY_BREAK
case 149:
YY_RULE_SETUP
#line 430 "detex.l"
putchar('-');
	YY_BREAK
case 150:
YY_RULE_SETUP
#line 431 "detex.l"
putchar('"');
	YY_BREAK
case 151:
YY_RULE_SETUP
#line 432 "detex.l"
putchar('\'');
	YY_BREAK
case 152:
YY_RULE_SETUP
#line 433 "detex.l"
putchar('"');
	YY_BREAK
case 153:
YY_RULE_SETUP
#line 434 "detex.l"
putchar('"');
	YY_BREAK
/* braces */
case 154:
YY_RULE_SETUP
#line 437 "detex.l"
{ ++currBracesLevel;
							}
	YY_BREAK
case 155:
YY_RULE_SETUP
#line 439 "detex.l"
{
							--currBracesLevel;
							if (currBracesLevel == footnoteLevel) {
								putchar(')');
								footnoteLevel = -100;
							}
							}
	YY_BREAK
case 156:
YY_RULE_SETUP
#line 446 "detex.l"
{   if (fWord)
							(void)printf("%s\n", yytext);
						    else
							ECHO;
						}
	YY_BREAK
case 157:
YY_RULE_SETUP
#line 451 "detex.l"
if (!fWord) ECHO;
	YY_BREAK
case 158:
YY_RULE_SETUP
#line 452 "detex.l"
if (!fWord) ECHO;
	YY_BREAK
case 159:
/* rule 159 can match eol */
YY_RULE_SETUP
#line 453 "detex.l"
if (!fWord) NEWLINE;
	YY_BREAK
case 160:
YY_RULE_SETUP
#line 454 "detex.l"
if (!fWord) putchar('\t');
	YY_BREAK
case 161:
YY_RULE_SETUP
#line 456 "detex.l"
{ BEGIN LaOptArg; }
	YY_BREAK
case 162:
YY_RULE_SETUP
#line 457 "detex.l"
{ cOpenBrace++; }
	YY_BREAK
case 163:
/* rule 163 can match eol */
YY_RULE_SETUP
#line 458 "detex.l"
{   cOpenBrace--;
						    if (cOpenBrace == 0)
						    {
							if (--cArgs==0)
							BEGIN Normal;
						    }
						}
	YY_BREAK
case 164:
YY_RULE_SETUP
#line 465 "detex.l"
;
	YY_BREAK
case 165:
YY_RULE_SETUP
#line 466 "detex.l"
BEGIN LaMacro;	
	YY_BREAK
case 166:
/* rule 166 can match eol */
YY_RULE_SETUP
#line 467 "detex.l"
;
	YY_BREAK
case 167:
YY_RULE_SETUP
#line 469 "detex.l"
{ BEGIN LaOptArg2; }
	YY_BREAK
case 168:
YY_RULE_SETUP
#line 470 "detex.l"
{ if (cOpenBrace == 0)
						    {
							if (--cArgs==0)
							{
							    BEGIN Normal;
							    cOpenBrace--;
							}
						    }
						  cOpenBrace++;
						}
	YY_BREAK
case 169:
YY_RULE_SETUP
#line 480 "detex.l"
{   cOpenBrace--; }
	YY_BREAK
case 170:
YY_RULE_SETUP
#line 481 "detex.l"
;
	YY_BREAK
case 171:
YY_RULE_SETUP
#line 482 "detex.l"
BEGIN LaMacro2;	
	YY_BREAK
case 172:
YY_RULE_SETUP
#line 483 "detex.l"
;
	YY_BREAK
case 173:
YY_RULE_SETUP
#line 484 "detex.l"
ECHO;
	YY_BREAK
#line 3105 "lex.yy.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(Define):
case YY_STATE_EOF(Display):
case YY_STATE_EOF(IncludeOnly):
case YY_STATE_EOF(Input):
case YY_STATE_EOF(Math):
case YY_STATE_EOF(Normal):
case YY_STATE_EOF(Control):
case YY_STATE_EOF(LaBegin):
case YY_STATE_EOF(LaDisplay):
case YY_STATE_EOF(LaEnd):
case YY_STATE_EOF(LaEnv):
case YY_STATE_EOF(LaFormula):
case YY_STATE_EOF(LaInclude):
case YY_STATE_EOF(LaSubfile):
case YY_STATE_EOF(LaMacro):
case YY_STATE_EOF(LaOptArg):
case YY_STATE_EOF(LaMacro2):
case YY_STATE_EOF(LaOptArg2):
case YY_STATE_EOF(LaVerbatim):
case YY_STATE_EOF(LaBreak):
case YY_STATE_EOF(LaPicture):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart(yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 1361 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (flex_int16_t) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	int yy_is_jam;
    	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 1361 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (flex_int16_t) yy_c];
	yy_is_jam = (yy_current_state == 1360);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

    static void yyunput (int c, char * yy_bp )
{
	char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up yytext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		int number_to_move = (yy_n_chars) + 2;
		char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = (int) YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart(yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer(yyin,YY_BUF_SIZE );
	}

	yy_init_buffer(YY_CURRENT_BUFFER,input_file );
	yy_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = (yy_size_t)size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree((void *) b->yy_ch_buf  );

	yyfree((void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	int num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (yyconst char * yystr )
{
    
	return yy_scan_bytes(yystr,(int) strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (yyconst char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (yyconst char* msg )
{
			(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
    
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = NULL;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = NULL;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return malloc(size);
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 484 "detex.l"



/******
** main --
**	Set sbProgName to the base of arg 0.
**	Set the input paths.
**	Check for options
**		-c		echo LaTeX \cite, \ref, and \pageref values
**		-e <env-list>	list of LaTeX environments to ignore
**		-l		force latex mode
**		-n		do not follow \input and \include
**		-s		replace control sequences with space
**		-t		force tex mode
**		-w		word only output
**	Set the list of LaTeX environments to ignore.
**	Process each input file.
**	If no input files are specified on the command line, process stdin.
******/

int
main(int cArgs, char *rgsbArgs[])
{
	char	*pch, sbBadOpt[2];
	const char *sbEnvList = DEFAULTENV;
	int	fSawFile = 0, iArgs = 1;
	
	/* get base name and decide what we are doing, detex or delatex */
#ifdef OS2
	char drive[_MAX_DRIVE], dir[_MAX_DIR];
	char fname[_MAX_FNAME], ext[_MAX_EXT];
#ifdef __EMX__
	_wildcard(&cArgs, &rgsbArgs);
	_response(&cArgs, &rgsbArgs);
#endif
	_splitpath (rgsbArgs[0], drive, dir, fname, ext);
	sbProgName = strlwr(fname);
#elif defined(KPATHSEA)
	kpse_set_program_name (rgsbArgs[0], NULL);
	sbProgName = kpse_program_name;
#else
	if ((sbProgName = strrchr(rgsbArgs[0], '/')) != NULL)
	    sbProgName++;
	else
	    sbProgName = rgsbArgs[0];
#endif
	if (strcmp("delatex",sbProgName) == 0)
	    fLatex = 1;

#ifndef KPATHSEA
	/* set rgsbInputPaths for use with TexOpen() */
	SetInputPaths();
#endif

	/* process command line options */
	while (iArgs < cArgs && *(pch = rgsbArgs[iArgs]) == CHOPT) {
		while (*++pch)
		    switch (*pch) {
		    case CHCITEOPT:
			fCite = 1;
			break;
		    case CHENVOPT:
			if (++iArgs >= cArgs) {
				ErrorExit("-e option requires an argument");
			}
			sbEnvList = rgsbArgs[iArgs];
			break;
		    case CHLATEXOPT:
			fLatex = 1;
			break;
		    case CHNOFOLLOWOPT:
			fFollow = 0;
			break;
		    case CHSPACEOPT:
			fSpace = 1;
			break;
		    case CHTEXOPT:
			fForcetex = 1;
			break;
		    case CHWORDOPT:
			fWord = 1;
			break;
			case CHREPLACE:
			fReplace = 1;
			break;
		    default:
			sbBadOpt[0] = *pch;
			sbBadOpt[1] = '\0';
			Warning("unknown option ignored -", sbBadOpt);
			UsageExit();
		    }
		iArgs++;
	}
	SetEnvIgnore(sbEnvList);

#ifdef WIN32
	_setmode(fileno(stdout), _O_BINARY);
#endif

	/* process input files */
	for (; iArgs < cArgs; iArgs++) {
	    fSawFile++;
	    if ((yyin = TexOpen(rgsbArgs[iArgs])) == NULL) {
		Warning("can't open file", rgsbArgs[iArgs]);
		continue;;
	    }
	    BEGIN Normal;
	    (void)yylex();
	}

	/* if there were no input files, assume stdin */
	if (!fSawFile) {
	    yyin = stdin;
#ifdef OS2
	    if (isatty(fileno(stdin)))
		OS2UsageExit();
#endif
	    BEGIN Normal;
	    (void)yylex();
	}
#ifndef FLEX_SCANNER
	if (YYSTATE != Normal)
	    ErrorExit("input contains an unterminated mode or environment");
#endif
	return(0);
}

#ifdef FLEX_SCANNER
#undef yywrap
#endif

/******
** yywrap -- handles EOF for lex.  Check to see if the stack of open files
**	has anything on it.  If it does, set yyin to the to value.  If not
**	return the termination signal for lex.
******/

int
yywrap(void)
{
	(void)fclose(yyin);
#ifdef FLEX_SCANNER
        /* Pop context state */
	if (csb > 0) {
		yy_delete_buffer(YY_CURRENT_BUFFER );
		yy_switch_to_buffer(rgsb[--csb] );
	}
#endif /* FLEX_SCANNER */
	if (cfp > 0) {
	    yyin = rgfp[--cfp];
	    return(0);
	}
	return(1);
}

#ifdef OS2

/******
** yyless -- return characters to the input stream.  Some systems don't have
**	a yyless routine
******/

void
yyless(int n)
{
	int 	i = strlen(yytext);

	while (i > n) unput(yytext[--i]);
	yytext[yyleng = n] = '\0';
}
#endif

/******
** SetEnvIgnore -- sets rgsbEnvIgnore to the values indicated by the
**	sbEnvList.
******/

void
SetEnvIgnore(const char *sbEnvList)
{
	char *sb;
	sb = SafeMalloc(strlen(sbEnvList) + 1, "malloc for SetEnvIgnore failed");
	(void) strcpy(sb, sbEnvList);

	
	csbEnvIgnore = SeparateList(sb, rgsbEnvIgnore, CHENVSEP, MAXENVS);
	if (csbEnvIgnore == my_ERROR)
	    ErrorExit("The environment list contains too many environments");
}

/******
** BeginEnv -- checks to see if sbEnv is in the list rgsbEnvIgnore.  If it
**	is, sbCurrentIgnoredEnv is set to sbEnv.
******/

int
BeginEnv(const char *sbEnv)
{
	int	i;

	if (!fLatex) return(0);
	for (i = 0; i < csbEnvIgnore; ++i)
	    if (strcmp(sbEnv, rgsbEnvIgnore[i]) == 0) {
			(void)strcpy(sbCurrentIgnoredEnv, sbEnv);
			return(1);
	    }
	return(0);
}

/******
** EndEnv -- checks to see if sbEnv is the current environment being ignored.
******/

int
EndEnv(const char *sbEnv)
{
	if (!fLatex) return(0);
	if (strcmp(sbEnv, sbCurrentIgnoredEnv) == 0)
	    return(1);
	return(0);
}

/******
** InputFile -- push the current yyin and open sbFile.  If the open fails,
**	the sbFile is ignored.
******/

void
InputFile(char *sbFile)
{
	FILE	*TexOpen();

	if (!fFollow)
	    return;
	rgfp[cfp++] = yyin;
	if ((yyin = TexOpen(sbFile)) == NULL) {
	    Warning("can't open \\input file", sbFile);
	    yyin = rgfp[--cfp];
            return;
	} 
#ifdef FLEX_SCANNER
        rgsb[csb++] = YY_CURRENT_BUFFER;
        yy_switch_to_buffer(yy_create_buffer(yyin,YY_BUF_SIZE ) );
#endif /* FLEX_SCANNER */
}

/******
** IncludeFile -- if sbFile is not in the rgsbIncList, push current yyin
**	and open sbFile.  If the open fails, the sbFile is ignored.
******/

void
IncludeFile(char *sbFile)
{
	FILE	*TexOpen();

	if (!fFollow)
	    return;
	if (!InList(sbFile))
	    return;
	rgfp[cfp++] = yyin;
	if ((yyin = TexOpen(sbFile)) == NULL) {
	    Warning("can't open \\include file", sbFile);
	    yyin = rgfp[--cfp];
            return;
	}
#ifdef FLEX_SCANNER
        rgsb[csb++] = YY_CURRENT_BUFFER;
        yy_switch_to_buffer(yy_create_buffer(yyin,YY_BUF_SIZE ) );
#endif /* FLEX_SCANNER */
}

/******
** AddInclude -- adds sbFile to the rgsbIncList and increments csbIncList.
**	If the include list is too long, sbFile is ignored.
******/

void
AddInclude(char *sbFile)
{
	if (!fFollow)
	    return;
	if (csbIncList >= MAXINCLIST)
	    Warning("\\includeonly list is too long, ignoring", sbFile);
	rgsbIncList[csbIncList] = SafeMalloc(strlen(sbFile) + 1, "malloc for AddInclude failed");
	(void)strcpy(rgsbIncList[csbIncList++], sbFile);
}

/******
** InList -- checks to see if sbFile is in the rgsbIncList.  If there is
**	no list, all files are assumed to be "in the list".
******/

int
InList(char *sbFile)
{
	char	*pch, sbBase[PATH_MAX];
	int	i;

	if (csbIncList == 0)	/* no list */
	    return(1);
	(void)strcpy(sbBase, sbFile);
	if ((pch = strrchr(sbBase, '.')) != NULL)
	    *pch = '\0';
	i = 0;
	while ((i < csbIncList) && rgsbIncList[i])
	    if (strcmp(rgsbIncList[i++], sbBase) == 0)
	        return(1);
	return(0);
}

#ifndef KPATHSEA
/******
** SetInputPaths -- sets rgsbInputPaths to the values indicated by the
**	TEXINPUTS environment variable if set or else DEFAULTINPUTS.  If
**	the user's TEXINPUTS has a leading ':' prepend the DEFAULTINPUTS
**	to the path, if there is a trailing ':' append the DEFAULTINPUTS.
**	This is consistent with the most recent TeX.  However, this
**	routine does not honor the '//' construct (expand subdirs).
******/

void
SetInputPaths(void)
{
	const char *sb;
	char *sbPaths;
	int cchDefaults, cchPaths;

	cchDefaults = strlen(DEFAULTINPUTS);
#ifdef OS2
	if ((sb = getenv("TEXINPUT")) == NULL)
#endif
	    if ((sb = getenv("TEXINPUTS")) == NULL)
		sb = DEFAULTINPUTS;
	cchPaths = strlen(sb);
	if (sb[0] == CHPATHSEP)
	    cchPaths += cchDefaults;
	if (sb[strlen(sb) - 1] == CHPATHSEP)
	    cchPaths += cchDefaults;
	sbPaths = SafeMalloc(cchPaths + 1, "malloc for SetInputPaths failed");
	sbPaths[0] = '\0';
	if (sb[0] == CHPATHSEP)
	    (void)strcat(sbPaths, DEFAULTINPUTS);
	(void)strcat(sbPaths, sb);
	if (sb[strlen(sb) - 1] == CHPATHSEP)
	    (void)strcat(sbPaths, DEFAULTINPUTS);

	csbInputPaths = SeparateList(sbPaths, rgsbInputPaths, CHPATHSEP, MAXINPUTPATHS);
	if (csbInputPaths == my_ERROR)
#ifdef OS2
	    ErrorExit("TEXINPUT(S) environment variable has too many paths");
#else
	    ErrorExit("TEXINPUTS environment variable has too many paths");
#endif
}
#endif

/******
** SeparateList -- takes a chSep separated list sbList, replaces the
**	chSep's with NULLs and sets rgsbList[i] to the beginning of
**	the ith word in sbList.  The number of words is returned.  A
**	my_ERROR is returned if there are more than csbMax words.
******/

int
SeparateList(char *sbList, char *rgsbList[], char chSep, int csbMax)
{
	int	csbList = 0;

	while (sbList && *sbList && csbList < csbMax) {
	    rgsbList[csbList++] = sbList;
	    if ((sbList = strchr(sbList, chSep))) {
			*sbList++ = '\0';
		}
	}
	return(sbList && *sbList ? my_ERROR : csbList);
}

/******
** TexOpen -- tries to open sbFile in each of the rgsbInputPaths in turn.
**	For each input path the following order is used:
**		file.tex - must be as named, if not there go to the next path
**		file.ext - random extension, try it
**		file     - base name, add .tex and try it
**		file     - try it as is
**	Notice that if file exists in the first path and file.tex exists in
**	one of the other paths, file in the first path is what is opened.
**	If the sbFile begins with a '/', no paths are searched.
******/

FILE *
TexOpen(char *sbFile)
{
	char	*sbNew;
#ifndef KPATHSEA
	char	*pch;
	FILE	*fp;
	int	iPath;
	static char	sbFullPath[PATH_MAX];

	for (iPath = 0; iPath < csbInputPaths; iPath++) {
#ifdef OS2
	    if (*sbFile == '/' || *sbFile == '\\' || strchr(sbFile, ':')) {	/* absolute path */
#else
	    if (*sbFile == '/') {	/* absolute path */
#endif
		(void)sprintf(sbFullPath, "%s", sbFile);
		iPath = csbInputPaths;	/* only check once */
	    } else
		(void)sprintf(sbFullPath, "%s/%s", rgsbInputPaths[iPath], sbFile);
#ifdef OS2
	    pch = sbFullPath;
	    while (pch = strchr(pch, '\\'))
		*pch = '/';
#endif

	    /* If sbFile ends in .tex then it must be there */
	    if ((pch = strrchr(sbFullPath, '.')) != NULL
			&& (strcmp(pch, ".tex") == 0))
	    {
		if ((fp = fopen(sbFullPath, "r")) != NULL)
		    return(fp);
		else
		    continue;
	    }

	    /* if .<ext> then try to open it.  the '.' represents   */
	    /* the beginning of an extension if it is not the first */
	    /* character and it does not follow a '.' or a '/'      */
	    if (pch != NULL && pch > &(sbFullPath[0])
                    && *(pch - 1) != '.' && *(pch - 1) != '/'
		    && (fp = fopen(sbFullPath, "r")) != NULL) {
			return(fp);
		}

	    /* just base name, add .tex to the name */
	    sbNew = SafeMalloc(strlen(sbFullPath) + 5, "malloc for TexOpen failed");
	    (void)strcpy(sbNew, sbFullPath);
	    (void)strcat(sbNew, ".tex");
	    if ((fp = fopen(sbNew, "r")) != NULL) {
			free(sbNew);
			return(fp);
		}
		free(sbNew);

	    /* try sbFile regardless */
	    if ((fp = fopen(sbFullPath, "r")) != NULL)
			return(fp);
	}
	return NULL;
#else
	sbNew = kpse_find_file (sbFile, kpse_tex_format, false);

	if (sbNew == NULL)
	    return NULL;

	return fopen (sbNew, "r");
#endif
}

/******
** SafeMalloc -- wrapper around malloc() to check for failure.
******/

char *
SafeMalloc(int cch, const char *sbMessage)
{
	char *sb;

	if ((sb = (char *)malloc((unsigned)cch)) == NULL)
	    ErrorExit(sbMessage);
	return(sb);
}

/******
** Warning -- print a warning message preceded by the program name.
******/

void
Warning(const char *sb1, const char *sb2)
{
	(void)fprintf(stderr, "%s: warning: %s %s\n", sbProgName, sb1, sb2);
}

/******
** ErrorExit -- print an error message preceded by the program name.
**	Stdout is flushed and detex exits.
******/

void
ErrorExit(const char *sb1)
{
	(void)fflush(stdout);
	(void)fprintf(stderr, "%s: error: %s\n", sbProgName, sb1);
	exit(1);
}

/******
** UsageExit -- print OS/2 usage message and exit.
******/

void
UsageExit(void)
{
	(void)printf("\n%s [ -clnrstw ] [ -e environment-list ] [ filename[.tex] ... ]\n",
		sbProgName);
	puts("  -c  echo LaTeX \\cite, \\ref, and \\pageref values\n  \
-e  <env-list> list of LaTeX environments to ignore\n  \
-l  force latex mode\n  \
-n  do not follow \\input, \\include and \\subfile\n  \
-r  replace math with \"noun\" and \"noun verbs noun\" to preserve grammar\n  \
-s  replace control sequences with space\n  \
-t  force tex mode\n  \
-w  word only output");
	exit(0);
}

