#include <glib-object.h>
#include <dbus/dbus-glib.h>

G_BEGIN_DECLS

/**
 * TplSvcLogger:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _TplSvcLogger TplSvcLogger;

/**
 * TplSvcLoggerClass:
 *
 * The class of TplSvcLogger.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_logger (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tpl_svc_logger_implement_###x (\
 *   klass, my_object_###x)
 *   IMPLEMENT (get_recent_messages);
 *   IMPLEMENT (get_favourite_contacts);
 *   IMPLEMENT (add_favourite_contact);
 *   IMPLEMENT (remove_favourite_contact);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */
typedef struct _TplSvcLoggerClass TplSvcLoggerClass;

GType tpl_svc_logger_get_type (void);
#define TPL_TYPE_SVC_LOGGER \
  (tpl_svc_logger_get_type ())
#define TPL_SVC_LOGGER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TPL_TYPE_SVC_LOGGER, TplSvcLogger))
#define TPL_IS_SVC_LOGGER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TPL_TYPE_SVC_LOGGER))
#define TPL_SVC_LOGGER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), TPL_TYPE_SVC_LOGGER, TplSvcLoggerClass))


typedef void (*tpl_svc_logger_get_recent_messages_impl) (TplSvcLogger *self,
    const gchar *in_Account,
    const gchar *in_Identifier,
    gboolean in_Is_Chatroom,
    guint in_Lines,
    DBusGMethodInvocation *context);
void tpl_svc_logger_implement_get_recent_messages (TplSvcLoggerClass *klass, tpl_svc_logger_get_recent_messages_impl impl);
/**
 * tpl_svc_logger_return_from_get_recent_messages:
 * @context: The D-Bus method invocation context
 * @out_Messages: const GPtrArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tpl_svc_logger_return_from_get_recent_messages (DBusGMethodInvocation *context,
    const GPtrArray *out_Messages);
static inline void
tpl_svc_logger_return_from_get_recent_messages (DBusGMethodInvocation *context,
    const GPtrArray *out_Messages)
{
  dbus_g_method_return (context,
      out_Messages);
}

typedef void (*tpl_svc_logger_get_favourite_contacts_impl) (TplSvcLogger *self,
    DBusGMethodInvocation *context);
void tpl_svc_logger_implement_get_favourite_contacts (TplSvcLoggerClass *klass, tpl_svc_logger_get_favourite_contacts_impl impl);
/**
 * tpl_svc_logger_return_from_get_favourite_contacts:
 * @context: The D-Bus method invocation context
 * @out_Favourite_Contacts: const GPtrArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tpl_svc_logger_return_from_get_favourite_contacts (DBusGMethodInvocation *context,
    const GPtrArray *out_Favourite_Contacts);
static inline void
tpl_svc_logger_return_from_get_favourite_contacts (DBusGMethodInvocation *context,
    const GPtrArray *out_Favourite_Contacts)
{
  dbus_g_method_return (context,
      out_Favourite_Contacts);
}

typedef void (*tpl_svc_logger_add_favourite_contact_impl) (TplSvcLogger *self,
    const gchar *in_Account,
    const gchar *in_Identifier,
    DBusGMethodInvocation *context);
void tpl_svc_logger_implement_add_favourite_contact (TplSvcLoggerClass *klass, tpl_svc_logger_add_favourite_contact_impl impl);
/**
 * tpl_svc_logger_return_from_add_favourite_contact:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tpl_svc_logger_return_from_add_favourite_contact (DBusGMethodInvocation *context);
static inline void
tpl_svc_logger_return_from_add_favourite_contact (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*tpl_svc_logger_remove_favourite_contact_impl) (TplSvcLogger *self,
    const gchar *in_Account,
    const gchar *in_Identifier,
    DBusGMethodInvocation *context);
void tpl_svc_logger_implement_remove_favourite_contact (TplSvcLoggerClass *klass, tpl_svc_logger_remove_favourite_contact_impl impl);
/**
 * tpl_svc_logger_return_from_remove_favourite_contact:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void tpl_svc_logger_return_from_remove_favourite_contact (DBusGMethodInvocation *context);
static inline void
tpl_svc_logger_return_from_remove_favourite_contact (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

void tpl_svc_logger_emit_favourite_contacts_changed (gpointer instance,
    const gchar *arg_Account,
    const gchar **arg_Added,
    const gchar **arg_Removed);


G_END_DECLS
