# ui.py - user interface interface class
# Copyright (C) 2008  Canonical, Ltd.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, version 3 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


import cruftremover


class UserInterface(object):

    """This is the base class for user interfaces.
    
    The user interface is in charge of obeying command line arguments,
    and interacting with the user.
    
    The app and pm given to the constructor are stored in the app and
    pm attributes.
        
    """

    def __init__(self, app, pm, mustberoot=True):
        self.pm = pm
        self.app = app
        self.mustberoot = mustberoot

    def run(self, options, args):
        """Obey command line arguments in ARGS, and options in OPTIONS."""
        raise cruftremover.UnimplementedMethod(self.run)
