/*
 * Copyright (c) 2003-2005 Todd C. Miller <Todd.Miller@courtesan.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Sponsored in part by the Defense Advanced Research Projects
 * Agency (DARPA) and Air Force Research Laboratory, Air Force
 * Materiel Command, USAF, under agreement number F39502-99-1-0512.
 */

#include <stdio.h>
#include <string.h>

#include <config.h>
#include <compat.h>

#ifndef lint
__unused static const char rcsid[] = "$Sudo: getprogname.c,v 1.7 2005/02/12 22:56:06 millert Exp $";
#endif /* lint */

const char *
getprogname()
{
    static const char *progname;
    extern int Argc;
    extern char **Argv;

    if (progname == NULL) {
	if (Argc < 0)
	    progname = "sudo";
	else if ((progname = strrchr(Argv[0], '/')) != NULL)
	    progname++;
	else
	    progname = Argv[0];
    }
    return(progname);
}
