/*
 * Copyright (c) 2004 Ulrich Drepper <drepper@redhat.com>
 * Copyright (c) 2005-2015 Dmitry V. Levin <ldv@altlinux.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "defs.h"
#include <fcntl.h>

SYS_FUNC(mq_open)
{
	printpath(tcp, tcp->u_arg[0]);
	tprints(", ");
	/* flags */
	tprint_open_modes(tcp->u_arg[1]);
	if (tcp->u_arg[1] & O_CREAT) {
		/* mode */
		tprints(", ");
		print_numeric_umode_t(tcp->u_arg[2]);
		tprints(", ");
		printmqattr(tcp, tcp->u_arg[3], false);
	}
	return RVAL_DECODED;
}

SYS_FUNC(mq_timedsend)
{
	tprintf("%d, ", (int) tcp->u_arg[0]);
	printstr(tcp, tcp->u_arg[1], tcp->u_arg[2]);
	tprintf(", %llu, %u, ", getarg_ull(tcp, 2),
		(unsigned int) tcp->u_arg[3]);
	print_timespec(tcp, tcp->u_arg[4]);
	return RVAL_DECODED;
}

SYS_FUNC(mq_timedreceive)
{
	if (entering(tcp)) {
		tprintf("%d, ", (int) tcp->u_arg[0]);
	} else {
		if (!syserror(tcp) && (tcp->u_rval >= 0))
			printstr(tcp, tcp->u_arg[1], tcp->u_rval);
		else
			printaddr(tcp->u_arg[1]);
		tprintf(", %llu, ", getarg_ull(tcp, 2));
		printnum_int(tcp, tcp->u_arg[3], "%u");
		tprintf(", ");
		/*
		 * Since the timeout parameter is read by the kernel
		 * on entering syscall, it has to be decoded the same way
		 * whether the syscall has failed or not.
		 */
		temporarily_clear_syserror(tcp);
		print_timespec(tcp, tcp->u_arg[4]);
		restore_cleared_syserror(tcp);
	}
	return 0;
}

SYS_FUNC(mq_notify)
{
	tprintf("%d, ", (int) tcp->u_arg[0]);
	print_sigevent(tcp, tcp->u_arg[1]);
	return RVAL_DECODED;
}

SYS_FUNC(mq_getsetattr)
{
	if (entering(tcp)) {
		tprintf("%d, ", (int) tcp->u_arg[0]);
		printmqattr(tcp, tcp->u_arg[1], true);
		tprints(", ");
	} else {
		printmqattr(tcp, tcp->u_arg[2], true);
	}
	return 0;
}
