/* This file is part of the SpeedCrunch project
   Copyright (C) 2004,2005 Ariya Hidayat <ariya@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "aboutbox.h"

#include "config.h"

#include <qdialog.h>
#include <qhbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpainter.h>
#include <qpushbutton.h>
#include <qsimplerichtext.h>
#include <qtimer.h>
#include <qvbox.h>
#include <qpixmap.h>

class MarqueeText::Private
{
  public:
    QSimpleRichText* doc;
    QBrush bgBrush;
    unsigned pos;
};

MarqueeText::MarqueeText( QWidget* parent, const char* name ):
QFrame( parent, name )
{
  d = new Private;  
  d->doc = 0;
  d->pos = 50;
  d->bgBrush = backgroundBrush();
  
  setFrameStyle( Panel | Sunken );
  setLineWidth( 1 );
  setBackgroundMode( NoBackground );
  
  QTimer* scrollTimer = new QTimer( this );
  connect( scrollTimer, SIGNAL( timeout() ), this, SLOT( scroll() ) );
  scrollTimer->start( 250 );
  
  setMinimumSize( 300, 150 );
}

MarqueeText::~MarqueeText()
{
  delete d->doc;
  delete d;
}

QSizePolicy MarqueeText::sizePolicy() const
{
  return QSizePolicy( QSizePolicy::Expanding, QSizePolicy::Expanding );
}

void MarqueeText::setText( const QString& text )
{
  delete d->doc;
  d->doc = new QSimpleRichText( text, font() );
  update();
}

void MarqueeText::paintEvent( QPaintEvent *e )
{
  QFrame::paintEvent( e );
  
  if( !d->doc ) return;
  
  QRect paintRect =  rect();
  paintRect.addCoords( 10, 2, -10, -2 );

  QPixmap pix( width() - 2, height() - 2 );
  QPainter painter( &pix );

  painter.fillRect( pix.rect(), d->bgBrush );

  d->doc->setWidth( &painter, paintRect.width() );
  d->doc->draw( &painter, 10, d->pos, paintRect, colorGroup() );

  bitBlt( this, QPoint( 1, 1 ), &pix, rect(), CopyROP );
}

void MarqueeText::scroll()
{
  if( !d->doc ) return;
  
  d->pos -= 5;
  int offset = d->pos + d->doc->height();
  
  if( offset < 0 )
    d->pos = height() + 10;
  
  update();
}


AboutBox::AboutBox( QWidget* parent, const char* name ):
  QDialog( parent, name )
{
  QBoxLayout* mainLayout = new QVBoxLayout( this, 11, 6 );
  
  QHBox* centerBox = new QHBox( this );
  mainLayout->addWidget( centerBox );
  centerBox->setSpacing( 10 );
  centerBox->setMinimumWidth( 400 );
  
  QVBox* textBox = new QVBox( centerBox );
  textBox->setSpacing( 10 );

  QHBox *bannerBox = new QHBox( textBox );
   bannerBox->setSpacing( 10 );
  
  QLabel* infoLabel = new QLabel( bannerBox );
  QString info = "<b>";
  info += tr("SpeedCrunch version %1").arg( SPEEDCRUNCH_VERSION );
  info += "</b><br>";
  info += tr("Copyright (C) 2004,2005 Ariya Hidayat (ariya@kde.org)");
  info += "<br>";
  info += tr( "http://speedcrunch.berlios.de");
  infoLabel->setText( info );
  bannerBox->setStretchFactor( infoLabel, 1 );

  QLabel *iconLabel = new QLabel( bannerBox );
  iconLabel->setPixmap( QPixmap::fromMimeSource( "crunch.png" ) );
  iconLabel->setAlignment( AlignVCenter | AlignRight );

  MarqueeText* marqueeText = new MarqueeText( textBox );
  mainLayout->addWidget( marqueeText );
  
  QString msg = "<center>";
  msg += "<p><b>";
  msg += tr( "SpeedCrunch version %1").arg( SPEEDCRUNCH_VERSION );
  msg += "</b></p>";
  msg += QString( "<p>%1:<br>%2" ).arg( tr("Author/Maintainer") ).arg( "Ariya Hidayat" );
  msg += QString( "<p>%1:<br>%2" ).arg( tr("Based on idea from") ).arg( "Roberto Alsina" );
  msg += QString( "<p>%1:<br>%2" ).arg( tr("Special thanks to") ).arg( "Michael Pyne" );
  msg += QString( "<p>%1:<br>%2" ).arg( tr("Artworks are courtesy of") ).arg( "Kuswanto (aka Zeus)" );
  msg += QString( "<p>%1<br>" ).arg( tr("Thanks to:") );
  msg += "Damir Perisa<br>"
         "Melchior Franz<br>"
         "Maciek Borowka<br>"
         "Bernhard Schiffner<br>"
         "Mohamed Eldesoky<br>"
         "Anders Lund<br>"
         "Thomas Nagy<br>"
         "Helder Correia<br>"
         "Pieter Pareit<br>"
         "Thomas Luebking<br>"
         "Jean-Remy Falleri<br>"
         "Gary Cramblitt<br>"
         "Philippe Fremy<br>"
         ;
  msg += QString( "<br>%1</p>" ).arg( tr("and many others.") );

  msg += QString( "<p>%1<br>" ).arg( tr("Translators:") );
  
  msg += QString( "%1: %2<br>" ).arg( tr("Czech") ).arg( " Blondak (blondak@neser.cz)" );
  msg += QString( "%1: %2<br>" ).arg( tr("French") ).arg( "Vibet Alexis (bevi@netcourrier.com)" );
  msg += QString( "%1: %2<br>" ).arg( tr("German") ).arg( "Damir Perisa (damir.perisa@solnet.ch)" );
  msg += QString( "%1: %2<br>" ).arg( tr("Indonesian") ).arg( "Yolla Indria (yolla.indria@gmail.com)" );
  msg += QString( "%1: %2<br>" ).arg( tr("Portuguese") ).arg( "Helder Correia (helder.correia@gmail.com)" );
  msg += QString( "%1: %2<br>" ).arg( tr("Portuguese BR") ).arg( "Henrique Pinto (henrique.pinto@kdemail.net)" );
  msg += QString( "%1: %2<br>" ).arg( tr("Russian") ).arg( "Alexey Kouznetsov (kouznetsov@phtf.stu.neva.ru)" );
  msg += QString( "%1: %2<br>" ).arg( tr("Italian") ).arg( "Francesco di Cugno (fdicugno@gmail.com)" );
  msg += QString( "</p>" );

  msg += "<p>";
  msg += tr("This program is free software; you can redistribute it and/or "
    "modify it under the terms of the GNU General Public License "
    "as published by the Free Software Foundation; either version 2 "
    "of the License, or (at your option) any later version" );
  msg += "</p>";
  msg += "<p>";
  msg += tr("This program is distributed in the hope that it will be useful, "
    "but WITHOUT ANY WARRANTY; without even the implied warranty of "
    "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the "
    "GNU General Public License for more details.");
  msg += "</p>";
  msg +=  "<p>&nbsp;</p>";
  msg += QString( "<p>%1</p>" ).arg( tr("Visit http://speedcrunch.berlios.de for more information!") );
  marqueeText->setText( msg );

  QHBox* buttonBox = new QHBox( this );
  mainLayout->addWidget( buttonBox );
  (new QWidget( buttonBox ))->setSizePolicy( QSizePolicy::Expanding, QSizePolicy::Minimum );
  QPushButton* okButton = new QPushButton( tr("OK"), buttonBox );
  okButton->setDefault( true );
  (new QWidget( buttonBox ))->setSizePolicy( QSizePolicy::Expanding, QSizePolicy::Minimum );
  
  connect( okButton, SIGNAL( clicked() ), SLOT( accept() ) );
}
