#  Smeg - Simple Menu Editor for GNOME
#
#  Travis Watkins <alleykat@gmail.com>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  (C) Copyright 2005 Travis Watkins

import os, sys, pickle, cgi
cmddir = os.path.split(sys.argv[0])[0]
prefix = os.path.split(cmddir)[0]
if prefix == '': prefix = '.'
libdir = os.path.join(prefix, 'lib/smeg')
sys.path = [libdir] + sys.path

import pygtk
pygtk.require('2.0')
import gtk, gtk.glade

class DialogHandler:
    def __init__(self, gui):
        self.gui = gui
        self.menu_tree = gtk.glade.XML(os.path.join(libdir, 'smeg.glade'), 'menudialog')
        self.entry_tree = gtk.glade.XML(os.path.join(libdir, 'smeg.glade'), 'entrydialog')
        signals = {}
        for attr in dir(self):
            signals[attr] = getattr(self, attr)
        self.menu_tree.signal_autoconnect(signals)
        self.entry_tree.signal_autoconnect(signals)

    def newMenuDialog(self):
        return self.setupMenuDialog()

    def setupMenuDialog(self, name=None, comment=None, icon=None, pixbuf=None):
        menu_dialog = self.menu_tree.get_widget('menudialog')
        if self.gui.icon:
            menu_dialog.set_icon(self.gui.icon)
        name_entry = self.menu_tree.get_widget('mnameentry')
        comment_entry = self.menu_tree.get_widget('mcommententry')
        icon_button = self.menu_tree.get_widget('miconbutton')

        icon_button.my_icon_name = None
        name_entry.set_text(name or '')
        comment_entry.set_text(comment or '')
        if icon and pixbuf:
            image = gtk.Image()
            image.set_from_pixbuf(pixbuf)
            image.show()
            icon_button.my_icon_name = icon
            icon_button.remove(icon_button.get_child())
            icon_button.add(image)

        menu_dialog.show()
        response = menu_dialog.run()
        if response == gtk.RESPONSE_OK:
            if len(name_entry.get_text()) > 0:
                menu_dialog.destroy()
                return (name_entry.get_text(), comment_entry.get_text(),
                    icon_button.my_icon_name)
        menu_dialog.destroy()
        return None, None, None

    def newEntryDialog(self):
        return self.setupEntryDialog()

    def setupEntryDialog(self, name=None, comment=None, command=None, icon=None, pixbuf=None, term=None):
        entry_dialog = self.entry_tree.get_widget('entrydialog')
        if self.gui.icon:
            entry_dialog.set_icon(self.gui.icon)
        name_entry = self.entry_tree.get_widget('enameentry')
        comment_entry = self.entry_tree.get_widget('ecommententry')
        command_entry = self.entry_tree.get_widget('ecommandentry')
        icon_button = self.entry_tree.get_widget('eiconbutton')
        term_check = self.entry_tree.get_widget('etermcheck')

        icon_button.my_icon_name = None
        name_entry.set_text(name or '')
        comment_entry.set_text(comment or '')
        command_entry.set_text(command or '')
        if icon and pixbuf:
            image = gtk.Image()
            image.set_from_pixbuf(pixbuf)
            image.show()
            icon_button.my_icon_name = icon
            icon_button.remove(icon_button.get_child())
            icon_button.add(image)

        if term is True:
            term_check.set_active(1)

        entry_dialog.show()
        response = entry_dialog.run()
        if response == gtk.RESPONSE_OK:
            if len(name_entry.get_text()) > 0:
                entry_dialog.destroy()
                return (name_entry.get_text(), comment_entry.get_text(),
                    command_entry.get_text(), icon_button.my_icon_name,
                    term_check.get_active())
        entry_dialog.destroy()
        return None, None, None, None, None

    def chooseFile(self, image=False):
        buttons = (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
            gtk.STOCK_OPEN, gtk.RESPONSE_ACCEPT)
        action = gtk.FILE_CHOOSER_ACTION_OPEN
        file_dialog = gtk.FileChooserDialog(action=action, buttons=buttons)
        if image:
            file_dialog.set_current_folder('/usr/share/pixmaps/')
        response = file_dialog.run()
        if response in (gtk.RESPONSE_ACCEPT, gtk.RESPONSE_OK):
            selected_file = file_dialog.get_filename()
        else:
            selected_file = None
        file_dialog.destroy()
        return selected_file

    def selectFile(self, entry):
        selected_file = self.chooseFile()
        if selected_file:
            entry.set_text(selected_file)

    def selectIcon(self, button):
        selected_file = self.chooseFile(True)
        if selected_file:
            pixbuf = self.gui.getIcon(selected_file, size=48)
            image = gtk.Image()
            image.set_from_pixbuf(pixbuf)
            image.show()
            button.my_icon_name = selected_file
            button.remove(button.get_child())
            button.add(image)

    def on_miconbutton_clicked(self, button):
        self.selectIcon(button)

    def on_ecommandbutton_clicked(self, button):
        self.selectFile(self.entry_tree.get_widget('ecommandentry'))

    def on_eiconbutton_clicked(self, button):
        self.selectIcon(button)
