/* book.c generated by valac 0.20.1, the Vala compiler
 * generated from book.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <cairo-ps.h>
#include <zlib.h>
#include <gobject/gvaluecollector.h>


#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;
typedef struct _BookPrivate BookPrivate;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define __g_list_free__page_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__page_unref0_ (var), NULL)))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

#define TYPE_PS_WRITER (ps_writer_get_type ())
#define PS_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PS_WRITER, PsWriter))
#define PS_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PS_WRITER, PsWriterClass))
#define IS_PS_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PS_WRITER))
#define IS_PS_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PS_WRITER))
#define PS_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PS_WRITER, PsWriterClass))

typedef struct _PsWriter PsWriter;
typedef struct _PsWriterClass PsWriterClass;
typedef struct _PsWriterPrivate PsWriterPrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _ps_writer_unref0(var) ((var == NULL) ? NULL : (var = (ps_writer_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_PDF_WRITER (pdf_writer_get_type ())
#define PDF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PDF_WRITER, PDFWriter))
#define PDF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PDF_WRITER, PDFWriterClass))
#define IS_PDF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PDF_WRITER))
#define IS_PDF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PDF_WRITER))
#define PDF_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PDF_WRITER, PDFWriterClass))

typedef struct _PDFWriter PDFWriter;
typedef struct _PDFWriterClass PDFWriterClass;
typedef struct _PDFWriterPrivate PDFWriterPrivate;
#define _pdf_writer_unref0(var) ((var == NULL) ? NULL : (var = (pdf_writer_unref (var), NULL)))
typedef struct _ParamSpecBook ParamSpecBook;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _ParamSpecPDFWriter ParamSpecPDFWriter;
typedef struct _ParamSpecPsWriter ParamSpecPsWriter;

struct _Book {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookPrivate * priv;
};

struct _BookClass {
	GTypeClass parent_class;
	void (*finalize) (Book *self);
};

struct _BookPrivate {
	GList* pages;
	gboolean needs_saving;
	GByteArray* jpeg_data;
};

struct _PsWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PsWriterPrivate * priv;
	cairo_surface_t* surface;
	GFileOutputStream* stream;
};

struct _PsWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PsWriter *self);
};

struct _PDFWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PDFWriterPrivate * priv;
	gsize offset;
	GList* object_offsets;
};

struct _PDFWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PDFWriter *self);
};

struct _ParamSpecBook {
	GParamSpec parent_instance;
};

struct _PDFWriterPrivate {
	GFileOutputStream* stream;
};

struct _ParamSpecPDFWriter {
	GParamSpec parent_instance;
};

struct _ParamSpecPsWriter {
	GParamSpec parent_instance;
};


static gpointer book_parent_class = NULL;
static gpointer pdf_writer_parent_class = NULL;
static gpointer ps_writer_parent_class = NULL;

gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
#define BOOK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BOOK, BookPrivate))
enum  {
	BOOK_DUMMY_PROPERTY
};
static void book_page_changed_cb (Book* self, Page* page);
static void _book_page_changed_cb_page_pixels_changed (Page* _sender, gpointer self);
static void _book_page_changed_cb_page_crop_changed (Page* _sender, gpointer self);
static void _page_unref0_ (gpointer var);
static void _g_list_free__page_unref0_ (GList* self);
Book* book_new (void);
Book* book_construct (GType object_type);
void book_clear (Book* self);
void book_set_needs_saving (Book* self, gboolean needs_saving);
void book_append_page (Book* self, Page* page);
void book_move_page (Book* self, Page* page, guint location);
void book_delete_page (Book* self, Page* page);
guint book_get_n_pages (Book* self);
Page* book_get_page (Book* self, gint page_number);
guint book_get_page_index (Book* self, Page* page);
static GFile* book_make_indexed_file (Book* self, const gchar* uri, gint i);
static void book_save_multi_file (Book* self, const gchar* type, gint quality, GFile* file, GError** error);
void page_save (Page* self, const gchar* type, gint quality, GFile* file, GError** error);
static void book_save_ps_pdf_surface (Book* self, cairo_surface_t* surface, GdkPixbuf* image, gdouble dpi);
static void book_save_ps (Book* self, GFile* file, GError** error);
PsWriter* ps_writer_new (GFileOutputStream* stream);
PsWriter* ps_writer_construct (GType object_type, GFileOutputStream* stream);
gpointer ps_writer_ref (gpointer instance);
void ps_writer_unref (gpointer instance);
GParamSpec* param_spec_ps_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_ps_writer (GValue* value, gpointer v_object);
void value_take_ps_writer (GValue* value, gpointer v_object);
gpointer value_get_ps_writer (const GValue* value);
GType ps_writer_get_type (void) G_GNUC_CONST;
GdkPixbuf* page_get_image (Page* self, gboolean apply_crop);
gint page_get_dpi (Page* self);
static guint8* book_compress_zlib (Book* self, guint8* data, int data_length1, int* result_length1);
static guint8* book_compress_jpeg (Book* self, GdkPixbuf* image, gint quality, gint dpi, int* result_length1);
static gboolean book_write_pixbuf_data (Book* self, guint8* buf, int buf_length1, GError** error);
static gboolean _book_write_pixbuf_data_gdk_pixbuf_save_func (guint8* buf, gsize buf_length1, GError** error, gpointer self);
static void book_save_pdf (Book* self, GFile* file, gint quality, GError** error);
PDFWriter* pdf_writer_new (GFileOutputStream* stream);
PDFWriter* pdf_writer_construct (GType object_type, GFileOutputStream* stream);
gpointer pdf_writer_ref (gpointer instance);
void pdf_writer_unref (gpointer instance);
GParamSpec* param_spec_pdf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pdf_writer (GValue* value, gpointer v_object);
void value_take_pdf_writer (GValue* value, gpointer v_object);
gpointer value_get_pdf_writer (const GValue* value);
GType pdf_writer_get_type (void) G_GNUC_CONST;
void pdf_writer_write_string (PDFWriter* self, const gchar* text);
guint pdf_writer_start_object (PDFWriter* self);
gboolean page_is_color (Page* self);
gint page_get_depth (Page* self);
static guint8* _vala_array_dup1 (guint8* self, int length);
static guint8* _vala_array_dup2 (guint8* self, int length);
void pdf_writer_write (PDFWriter* self, guint8* data, int data_length1);
void book_save (Book* self, const gchar* type, gint quality, GFile* file, GError** error);
gboolean book_get_needs_saving (Book* self);
static void g_cclosure_user_marshal_VOID__PAGE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void book_finalize (Book* obj);
#define PDF_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PDF_WRITER, PDFWriterPrivate))
enum  {
	PDF_WRITER_DUMMY_PROPERTY
};
static void pdf_writer_finalize (PDFWriter* obj);
enum  {
	PS_WRITER_DUMMY_PROPERTY
};
static cairo_status_t ps_writer_write_cairo_data (PsWriter* self, guint8* data, int data_length1);
static cairo_status_t _ps_writer_write_cairo_data_cairo_write_func_t (gpointer self, guchar* data, int data_length1);
static void ps_writer_finalize (PsWriter* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _page_ref0 (gpointer self) {
#line 32 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return self ? page_ref (self) : NULL;
#line 244 "book.c"
}


static void _book_page_changed_cb_page_pixels_changed (Page* _sender, gpointer self) {
#line 34 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	book_page_changed_cb (self, _sender);
#line 251 "book.c"
}


static void _book_page_changed_cb_page_crop_changed (Page* _sender, gpointer self) {
#line 35 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	book_page_changed_cb (self, _sender);
#line 258 "book.c"
}


static void _page_unref0_ (gpointer var) {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	(var == NULL) ? NULL : (var = (page_unref (var), NULL));
#line 265 "book.c"
}


static void _g_list_free__page_unref0_ (GList* self) {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_list_foreach (self, (GFunc) _page_unref0_, NULL);
#line 14 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_list_free (self);
#line 274 "book.c"
}


Book* book_construct (GType object_type) {
	Book* self = NULL;
#line 25 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self = (Book*) g_type_create_instance (object_type);
#line 27 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	__g_list_free__page_unref0_0 (self->priv->pages);
#line 27 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->priv->pages = NULL;
#line 25 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return self;
#line 288 "book.c"
}


Book* book_new (void) {
#line 25 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return book_construct (TYPE_BOOK);
#line 295 "book.c"
}


void book_clear (Book* self) {
	GList* _tmp0_;
#line 39 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (self != NULL);
#line 41 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 305 "book.c"
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
#line 41 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		page_collection = _tmp0_;
#line 41 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
#line 313 "book.c"
			Page* _tmp1_;
			Page* page = NULL;
#line 41 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			_tmp1_ = _page_ref0 ((Page*) page_it->data);
#line 41 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			page = _tmp1_;
#line 320 "book.c"
			{
				Page* _tmp2_;
				guint _tmp3_ = 0U;
				Page* _tmp4_;
				guint _tmp5_ = 0U;
#line 43 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp2_ = page;
#line 43 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 43 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 44 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp4_ = page;
#line 44 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
#line 44 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 41 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_page_unref0 (page);
#line 340 "book.c"
			}
		}
	}
#line 46 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	__g_list_free__page_unref0_0 (self->priv->pages);
#line 46 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->priv->pages = NULL;
#line 47 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_emit_by_name (self, "cleared");
#line 350 "book.c"
}


static void book_page_changed_cb (Book* self, Page* page) {
#line 50 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (self != NULL);
#line 50 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (page != NULL);
#line 52 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 361 "book.c"
}


void book_append_page (Book* self, Page* page) {
	Page* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	Page* _tmp4_;
#line 55 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (self != NULL);
#line 55 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (page != NULL);
#line 57 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = page;
#line 57 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_connect (_tmp0_, "pixels-changed", (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 58 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = page;
#line 58 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_connect (_tmp1_, "crop-changed", (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 60 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp2_ = page;
#line 60 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp3_ = _page_ref0 (_tmp2_);
#line 60 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->priv->pages = g_list_append (self->priv->pages, _tmp3_);
#line 61 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp4_ = page;
#line 61 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_emit_by_name (self, "page-added", _tmp4_);
#line 62 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 395 "book.c"
}


void book_move_page (Book* self, Page* page, guint location) {
	Page* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	guint _tmp3_;
#line 65 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (self != NULL);
#line 65 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (page != NULL);
#line 67 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = page;
#line 67 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->priv->pages = g_list_remove (self->priv->pages, _tmp0_);
#line 68 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = page;
#line 68 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp2_ = _page_ref0 (_tmp1_);
#line 68 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp3_ = location;
#line 68 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->priv->pages = g_list_insert (self->priv->pages, _tmp2_, (gint) _tmp3_);
#line 69 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_emit_by_name (self, "reordered");
#line 70 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 424 "book.c"
}


void book_delete_page (Book* self, Page* page) {
	Page* _tmp0_;
	guint _tmp1_ = 0U;
	Page* _tmp2_;
	guint _tmp3_ = 0U;
	Page* _tmp4_;
	Page* _tmp5_;
#line 73 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (self != NULL);
#line 73 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (page != NULL);
#line 75 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = page;
#line 75 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
#line 75 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 76 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp2_ = page;
#line 76 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 76 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 77 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp4_ = page;
#line 77 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_emit_by_name (self, "page-removed", _tmp4_);
#line 78 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp5_ = page;
#line 78 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->priv->pages = g_list_remove (self->priv->pages, _tmp5_);
#line 79 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 461 "book.c"
}


guint book_get_n_pages (Book* self) {
	guint result = 0U;
	GList* _tmp0_;
	guint _tmp1_ = 0U;
#line 82 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 84 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 84 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = g_list_length (_tmp0_);
#line 84 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	result = _tmp1_;
#line 84 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return result;
#line 479 "book.c"
}


Page* book_get_page (Book* self, gint page_number) {
	Page* result = NULL;
	gint _tmp0_;
	GList* _tmp4_;
	gint _tmp5_;
	gconstpointer _tmp6_ = NULL;
	Page* _tmp7_;
#line 87 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 89 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = page_number;
#line 89 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (_tmp0_ < 0) {
#line 496 "book.c"
		GList* _tmp1_;
		guint _tmp2_ = 0U;
		gint _tmp3_;
#line 90 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp1_ = self->priv->pages;
#line 90 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp2_ = g_list_length (_tmp1_);
#line 90 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp3_ = page_number;
#line 90 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		page_number = ((gint) _tmp2_) + _tmp3_;
#line 508 "book.c"
	}
#line 91 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp4_ = self->priv->pages;
#line 91 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp5_ = page_number;
#line 91 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp6_ = g_list_nth_data (_tmp4_, (guint) _tmp5_);
#line 91 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp7_ = _page_ref0 ((Page*) _tmp6_);
#line 91 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	result = _tmp7_;
#line 91 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return result;
#line 522 "book.c"
}


guint book_get_page_index (Book* self, Page* page) {
	guint result = 0U;
	GList* _tmp0_;
	Page* _tmp1_;
	gint _tmp2_ = 0;
#line 94 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 94 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (page != NULL, 0U);
#line 96 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 96 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = page;
#line 96 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp2_ = g_list_index (_tmp0_, _tmp1_);
#line 96 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	result = (guint) _tmp2_;
#line 96 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return result;
#line 545 "book.c"
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
#line 928 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 929 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 929 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 929 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
#line 929 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 931 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 931 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 570 "book.c"
		gchar* _tmp4_;
#line 932 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 932 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 932 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 578 "book.c"
	} else {
#line 934 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = -1;
#line 934 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 584 "book.c"
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1190 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1191 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1191 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1191 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1192 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1192 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 620 "book.c"
		glong _tmp3_;
		glong _tmp4_;
#line 1193 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1193 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1193 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 629 "book.c"
	}
#line 1195 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1195 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 635 "book.c"
		glong _tmp6_;
		glong _tmp7_;
#line 1196 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1196 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1196 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 644 "book.c"
	}
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 650 "book.c"
		glong _tmp10_;
		glong _tmp11_;
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 659 "book.c"
	} else {
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 663 "book.c"
	}
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp12_ = _tmp8_;
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp14_ = end;
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp14_ >= ((glong) 0)) {
#line 673 "book.c"
		glong _tmp15_;
		glong _tmp16_;
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp15_ = end;
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp13_ = _tmp15_ <= _tmp16_;
#line 682 "book.c"
	} else {
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp13_ = FALSE;
#line 686 "book.c"
	}
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp17_ = _tmp13_;
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp17_, NULL);
#line 1200 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1200 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1200 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp21_ = end;
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp22_ = start;
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 710 "book.c"
}


static GFile* book_make_indexed_file (Book* self, const gchar* uri, gint i) {
	GFile* result = NULL;
	guint _tmp0_ = 0U;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* basename;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* prefix;
	gchar* _tmp7_;
	gchar* suffix;
	const gchar* _tmp8_;
	gint _tmp9_ = 0;
	gint extension_index;
	gint _tmp10_;
	guint _tmp25_ = 0U;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gint width;
	gint _tmp31_;
	gchar* _tmp32_ = NULL;
	gchar* number_format;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	const gchar* _tmp36_;
	gint _tmp37_;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* filename;
	const gchar* _tmp45_;
	GFile* _tmp46_ = NULL;
#line 99 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 99 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 101 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = book_get_n_pages (self);
#line 101 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (_tmp0_ == ((guint) 1)) {
#line 762 "book.c"
		const gchar* _tmp1_;
		GFile* _tmp2_ = NULL;
#line 102 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp1_ = uri;
#line 102 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp2_ = g_file_new_for_uri (_tmp1_);
#line 102 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		result = _tmp2_;
#line 102 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		return result;
#line 773 "book.c"
	}
#line 105 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp3_ = uri;
#line 105 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp4_ = g_path_get_basename (_tmp3_);
#line 105 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	basename = _tmp4_;
#line 106 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp5_ = uri;
#line 106 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 106 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	prefix = _tmp6_;
#line 106 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp7_ = g_strdup ("");
#line 106 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	suffix = _tmp7_;
#line 107 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp8_ = basename;
#line 107 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp9_ = string_last_index_of_char (_tmp8_, (gunichar) '.', 0);
#line 107 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	extension_index = _tmp9_;
#line 108 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp10_ = extension_index;
#line 108 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (_tmp10_ >= 0) {
#line 801 "book.c"
		const gchar* _tmp11_;
		gint _tmp12_;
		const gchar* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gchar* _tmp16_ = NULL;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		const gchar* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gchar* _tmp24_ = NULL;
#line 110 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp11_ = basename;
#line 110 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp12_ = extension_index;
#line 110 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp13_ = basename;
#line 110 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp14_ = strlen (_tmp13_);
#line 110 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp15_ = _tmp14_;
#line 110 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp16_ = string_slice (_tmp11_, (glong) _tmp12_, (glong) _tmp15_);
#line 110 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_g_free0 (suffix);
#line 110 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		suffix = _tmp16_;
#line 111 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp17_ = uri;
#line 111 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp18_ = uri;
#line 111 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp19_ = strlen (_tmp18_);
#line 111 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp20_ = _tmp19_;
#line 111 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp21_ = suffix;
#line 111 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp22_ = strlen (_tmp21_);
#line 111 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp23_ = _tmp22_;
#line 111 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp24_ = string_slice (_tmp17_, (glong) 0, (glong) (_tmp20_ - _tmp23_));
#line 111 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_g_free0 (prefix);
#line 111 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		prefix = _tmp24_;
#line 852 "book.c"
	}
#line 113 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp25_ = book_get_n_pages (self);
#line 113 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp26_ = g_strdup_printf ("%u", _tmp25_);
#line 113 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp27_ = _tmp26_;
#line 113 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp28_ = strlen (_tmp27_);
#line 113 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp29_ = _tmp28_;
#line 113 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp30_ = _tmp29_;
#line 113 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp27_);
#line 113 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	width = _tmp30_;
#line 114 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp31_ = width;
#line 114 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp32_ = g_strdup_printf ("%%0%dd", _tmp31_);
#line 114 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	number_format = _tmp32_;
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp33_ = prefix;
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp34_ = g_strconcat (_tmp33_, "-", NULL);
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp35_ = _tmp34_;
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp36_ = number_format;
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp37_ = i;
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp38_ = g_strdup_printf (_tmp36_, _tmp37_ + 1);
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp39_ = _tmp38_;
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp40_ = g_strconcat (_tmp35_, _tmp39_, NULL);
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp41_ = _tmp40_;
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp42_ = suffix;
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp43_ = g_strconcat (_tmp41_, _tmp42_, NULL);
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp44_ = _tmp43_;
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp41_);
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp39_);
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp35_);
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	filename = _tmp44_;
#line 116 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp45_ = filename;
#line 116 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp46_ = g_file_new_for_uri (_tmp45_);
#line 116 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	result = _tmp46_;
#line 116 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (filename);
#line 116 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (number_format);
#line 116 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (suffix);
#line 116 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (prefix);
#line 116 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (basename);
#line 116 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return result;
#line 926 "book.c"
}


static void book_save_multi_file (Book* self, const gchar* type, gint quality, GFile* file, GError** error) {
	GError * _inner_error_ = NULL;
#line 119 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (self != NULL);
#line 119 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (type != NULL);
#line 119 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (file != NULL);
#line 938 "book.c"
	{
		gint i;
#line 121 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		i = 0;
#line 943 "book.c"
		{
			gboolean _tmp0_;
#line 121 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			_tmp0_ = TRUE;
#line 121 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			while (TRUE) {
#line 950 "book.c"
				gboolean _tmp1_;
				gint _tmp3_;
				guint _tmp4_ = 0U;
				gint _tmp5_;
				Page* _tmp6_ = NULL;
				Page* page;
				Page* _tmp7_;
				const gchar* _tmp8_;
				gint _tmp9_;
				GFile* _tmp10_;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				gint _tmp13_;
				GFile* _tmp14_ = NULL;
				GFile* _tmp15_;
				gint _tmp16_;
#line 121 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp1_ = _tmp0_;
#line 121 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (!_tmp1_) {
#line 971 "book.c"
					gint _tmp2_;
#line 121 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp2_ = i;
#line 121 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					i = _tmp2_ + 1;
#line 977 "book.c"
				}
#line 121 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp0_ = FALSE;
#line 121 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp3_ = i;
#line 121 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp4_ = book_get_n_pages (self);
#line 121 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (!(((guint) _tmp3_) < _tmp4_)) {
#line 121 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					break;
#line 989 "book.c"
				}
#line 123 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp5_ = i;
#line 123 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp6_ = book_get_page (self, _tmp5_);
#line 123 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				page = _tmp6_;
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp7_ = page;
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp8_ = type;
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp9_ = quality;
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp10_ = file;
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp11_ = g_file_get_uri (_tmp10_);
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp12_ = _tmp11_;
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp13_ = i;
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp14_ = book_make_indexed_file (self, _tmp12_, _tmp13_);
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp15_ = _tmp14_;
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				page_save (_tmp7_, _tmp8_, _tmp9_, _tmp15_, &_inner_error_);
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_object_unref0 (_tmp15_);
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp12_);
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (_inner_error_ != NULL) {
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_page_unref0 (page);
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					return;
#line 1029 "book.c"
				}
#line 125 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp16_ = i;
#line 125 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				g_signal_emit_by_name (self, "saving", _tmp16_);
#line 121 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_page_unref0 (page);
#line 1037 "book.c"
			}
		}
	}
}


static void book_save_ps_pdf_surface (Book* self, cairo_surface_t* surface, GdkPixbuf* image, gdouble dpi) {
	cairo_surface_t* _tmp0_;
	cairo_t* _tmp1_;
	cairo_t* context;
	gdouble _tmp2_;
	gdouble _tmp3_;
	GdkPixbuf* _tmp4_;
	cairo_pattern_t* _tmp5_ = NULL;
#line 129 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (self != NULL);
#line 129 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (surface != NULL);
#line 129 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (image != NULL);
#line 131 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = surface;
#line 131 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = cairo_create (_tmp0_);
#line 131 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	context = _tmp1_;
#line 132 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp2_ = dpi;
#line 132 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp3_ = dpi;
#line 132 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	cairo_scale (context, 72.0 / _tmp2_, 72.0 / _tmp3_);
#line 133 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp4_ = image;
#line 133 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	gdk_cairo_set_source_pixbuf (context, _tmp4_, (gdouble) 0, (gdouble) 0);
#line 134 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp5_ = cairo_get_source (context);
#line 134 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	cairo_pattern_set_filter (_tmp5_, CAIRO_FILTER_BEST);
#line 135 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	cairo_paint (context);
#line 129 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_cairo_destroy0 (context);
#line 1082 "book.c"
}


static gpointer _cairo_surface_reference0 (gpointer self) {
#line 142 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return self ? cairo_surface_reference (self) : NULL;
#line 1089 "book.c"
}


static void book_save_ps (Book* self, GFile* file, GError** error) {
	GFile* _tmp0_;
	GFileOutputStream* _tmp1_ = NULL;
	GFileOutputStream* stream;
	PsWriter* _tmp2_;
	PsWriter* writer;
	PsWriter* _tmp3_;
	cairo_surface_t* _tmp4_;
	cairo_surface_t* _tmp5_;
	cairo_surface_t* surface;
	GError * _inner_error_ = NULL;
#line 138 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (self != NULL);
#line 138 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (file != NULL);
#line 140 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = file;
#line 140 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = g_file_replace (_tmp0_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 140 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	stream = _tmp1_;
#line 140 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (_inner_error_ != NULL) {
#line 140 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_propagate_error (error, _inner_error_);
#line 140 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		return;
#line 1120 "book.c"
	}
#line 141 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp2_ = ps_writer_new (stream);
#line 141 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	writer = _tmp2_;
#line 142 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp3_ = writer;
#line 142 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp4_ = _tmp3_->surface;
#line 142 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp5_ = _cairo_surface_reference0 (_tmp4_);
#line 142 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	surface = _tmp5_;
#line 1134 "book.c"
	{
		gint i;
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		i = 0;
#line 1139 "book.c"
		{
			gboolean _tmp6_;
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			_tmp6_ = TRUE;
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			while (TRUE) {
#line 1146 "book.c"
				gboolean _tmp7_;
				gint _tmp9_;
				guint _tmp10_ = 0U;
				gint _tmp11_;
				Page* _tmp12_ = NULL;
				Page* page;
				Page* _tmp13_;
				GdkPixbuf* _tmp14_ = NULL;
				GdkPixbuf* image;
				GdkPixbuf* _tmp15_;
				gint _tmp16_ = 0;
				Page* _tmp17_;
				gint _tmp18_ = 0;
				gdouble width;
				GdkPixbuf* _tmp19_;
				gint _tmp20_ = 0;
				Page* _tmp21_;
				gint _tmp22_ = 0;
				gdouble height;
				cairo_surface_t* _tmp23_;
				gdouble _tmp24_;
				gdouble _tmp25_;
				cairo_surface_t* _tmp26_;
				GdkPixbuf* _tmp27_;
				Page* _tmp28_;
				gint _tmp29_ = 0;
				cairo_surface_t* _tmp30_;
				gint _tmp31_;
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp7_ = _tmp6_;
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (!_tmp7_) {
#line 1179 "book.c"
					gint _tmp8_;
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp8_ = i;
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					i = _tmp8_ + 1;
#line 1185 "book.c"
				}
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp6_ = FALSE;
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp9_ = i;
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp10_ = book_get_n_pages (self);
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (!(((guint) _tmp9_) < _tmp10_)) {
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					break;
#line 1197 "book.c"
				}
#line 146 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp11_ = i;
#line 146 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp12_ = book_get_page (self, _tmp11_);
#line 146 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				page = _tmp12_;
#line 147 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp13_ = page;
#line 147 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp14_ = page_get_image (_tmp13_, TRUE);
#line 147 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				image = _tmp14_;
#line 148 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp15_ = image;
#line 148 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp16_ = gdk_pixbuf_get_width (_tmp15_);
#line 148 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp17_ = page;
#line 148 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp18_ = page_get_dpi (_tmp17_);
#line 148 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				width = (_tmp16_ * 72.0) / _tmp18_;
#line 149 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp19_ = image;
#line 149 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp20_ = gdk_pixbuf_get_height (_tmp19_);
#line 149 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp21_ = page;
#line 149 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp22_ = page_get_dpi (_tmp21_);
#line 149 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				height = (_tmp20_ * 72.0) / _tmp22_;
#line 150 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp23_ = surface;
#line 150 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp24_ = width;
#line 150 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp25_ = height;
#line 150 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				cairo_ps_surface_set_size (_tmp23_, _tmp24_, _tmp25_);
#line 151 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp26_ = surface;
#line 151 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp27_ = image;
#line 151 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp28_ = page;
#line 151 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp29_ = page_get_dpi (_tmp28_);
#line 151 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				book_save_ps_pdf_surface (self, _tmp26_, _tmp27_, (gdouble) _tmp29_);
#line 152 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp30_ = surface;
#line 152 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				cairo_surface_show_page (_tmp30_);
#line 153 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp31_ = i;
#line 153 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				g_signal_emit_by_name (self, "saving", _tmp31_);
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_object_unref0 (image);
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_page_unref0 (page);
#line 1261 "book.c"
			}
		}
	}
#line 138 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_cairo_surface_destroy0 (surface);
#line 138 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_ps_writer_unref0 (writer);
#line 138 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_object_unref0 (stream);
#line 1271 "book.c"
}


static guint8* book_compress_zlib (Book* self, guint8* data, int data_length1, int* result_length1) {
	guint8* result = NULL;
	z_stream stream = {0};
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_ = NULL;
	guint8* out_data;
	gint out_data_length1;
	gint _out_data_size_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	z_stream _tmp7_;
	guint _tmp8_;
	guint8* _tmp10_;
	gint _tmp10__length1;
	z_stream _tmp11_;
	guint _tmp12_;
	guint n_written;
	guint _tmp13_;
	gint _tmp14_ = 0;
	guint8* _tmp15_;
	gint _tmp15__length1;
#line 157 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 159 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	deflateInit (&stream, (gint) Z_BEST_COMPRESSION);
#line 160 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = data;
#line 160 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0__length1 = data_length1;
#line 160 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = g_new0 (guint8, _tmp0__length1);
#line 160 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	out_data = _tmp1_;
#line 160 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	out_data_length1 = _tmp0__length1;
#line 160 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_out_data_size_ = out_data_length1;
#line 162 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp2_ = data;
#line 162 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp2__length1 = data_length1;
#line 162 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	stream.next_in = _tmp2_;
#line 162 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	stream.avail_in = _tmp2__length1;
#line 163 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp3_ = out_data;
#line 163 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp3__length1 = out_data_length1;
#line 163 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	stream.next_out = _tmp3_;
#line 163 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	stream.avail_out = _tmp3__length1;
#line 164 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	while (TRUE) {
#line 1333 "book.c"
		z_stream _tmp4_;
		guint _tmp5_;
		gint _tmp6_ = 0;
#line 164 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp4_ = stream;
#line 164 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp5_ = _tmp4_.avail_in;
#line 164 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		if (!(_tmp5_ > ((guint) 0))) {
#line 164 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			break;
#line 1345 "book.c"
		}
#line 166 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp6_ = deflate (&stream, (gint) Z_FINISH);
#line 166 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		if (_tmp6_ == ((gint) Z_STREAM_ERROR)) {
#line 167 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			break;
#line 1353 "book.c"
		}
	}
#line 170 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp7_ = stream;
#line 170 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp8_ = _tmp7_.avail_in;
#line 170 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (_tmp8_ > ((guint) 0)) {
#line 1362 "book.c"
		guint8* _tmp9_;
		gint _tmp9__length1;
#line 171 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp9_ = NULL;
#line 171 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp9__length1 = 0;
#line 171 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		if (result_length1) {
#line 171 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			*result_length1 = _tmp9__length1;
#line 1373 "book.c"
		}
#line 171 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		result = _tmp9_;
#line 171 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		out_data = (g_free (out_data), NULL);
#line 171 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		deflateEnd (&stream);
#line 171 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		return result;
#line 1383 "book.c"
	}
#line 173 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp10_ = data;
#line 173 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp10__length1 = data_length1;
#line 173 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp11_ = stream;
#line 173 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp12_ = _tmp11_.avail_out;
#line 173 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	n_written = _tmp10__length1 - _tmp12_;
#line 174 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp13_ = n_written;
#line 174 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp14_ = (gint) _tmp13_;
#line 174 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	out_data = g_renew (guint8, out_data, (gint) _tmp13_);
#line 174 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	(_tmp14_ > out_data_length1) ? memset (out_data + out_data_length1, 0, sizeof (guint8) * (_tmp14_ - out_data_length1)) : NULL;
#line 174 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	out_data_length1 = _tmp14_;
#line 174 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_out_data_size_ = _tmp14_;
#line 176 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp15_ = out_data;
#line 176 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp15__length1 = out_data_length1;
#line 176 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (result_length1) {
#line 176 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		*result_length1 = _tmp15__length1;
#line 1415 "book.c"
	}
#line 176 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	result = _tmp15_;
#line 176 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	deflateEnd (&stream);
#line 176 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return result;
#line 1423 "book.c"
}


static gboolean _book_write_pixbuf_data_gdk_pixbuf_save_func (guint8* buf, gsize buf_length1, GError** error, gpointer self) {
	gboolean result;
	result = book_write_pixbuf_data (self, buf, buf_length1, error);
#line 188 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return result;
#line 1432 "book.c"
}


static guint8* book_compress_jpeg (Book* self, GdkPixbuf* image, gint quality, gint dpi, int* result_length1) {
	guint8* result = NULL;
	GByteArray* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_ = NULL;
	gchar** keys;
	gint keys_length1;
	gint _keys_size_;
	gint _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gint _tmp9_;
	gchar* _tmp10_ = NULL;
	gint _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	gchar** values;
	gint values_length1;
	gint _values_size_;
	GByteArray* _tmp15_;
	guint8* _tmp16_;
	gint _tmp16__length1;
	guint8* data;
	gint data_length1;
	gint _data_size_;
	guint8* _tmp17_;
	gint _tmp17__length1;
	GError * _inner_error_ = NULL;
#line 181 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 181 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (image != NULL, NULL);
#line 183 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = g_byte_array_new ();
#line 183 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_byte_array_unref0 (self->priv->jpeg_data);
#line 183 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->priv->jpeg_data = _tmp0_;
#line 184 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = g_strdup ("quality");
#line 184 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp2_ = g_strdup ("density-unit");
#line 184 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp3_ = g_strdup ("x-density");
#line 184 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp4_ = g_strdup ("y-density");
#line 184 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp5_ = g_new0 (gchar*, 5 + 1);
#line 184 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp5_[0] = _tmp1_;
#line 184 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp5_[1] = _tmp2_;
#line 184 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp5_[2] = _tmp3_;
#line 184 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp5_[3] = _tmp4_;
#line 184 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp5_[4] = NULL;
#line 184 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	keys = _tmp5_;
#line 184 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	keys_length1 = 5;
#line 184 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_keys_size_ = keys_length1;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp6_ = quality;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp7_ = g_strdup_printf ("%d", _tmp6_);
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp8_ = g_strdup ("dots-per-inch");
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp9_ = dpi;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp10_ = g_strdup_printf ("%d", _tmp9_);
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp11_ = dpi;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp12_ = g_strdup_printf ("%d", _tmp11_);
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp13_ = g_new0 (gchar*, 5 + 1);
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp13_[0] = _tmp7_;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp13_[1] = _tmp8_;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp13_[2] = _tmp10_;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp13_[3] = _tmp12_;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp13_[4] = NULL;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	values = _tmp13_;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	values_length1 = 5;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_values_size_ = values_length1;
#line 1535 "book.c"
	{
		GdkPixbuf* _tmp14_;
#line 188 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp14_ = image;
#line 188 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		gdk_pixbuf_save_to_callbackv (_tmp14_, _book_write_pixbuf_data_gdk_pixbuf_save_func, self, "jpeg", keys, values, &_inner_error_);
#line 188 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		if (_inner_error_ != NULL) {
#line 1544 "book.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
#line 186 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		e = _inner_error_;
#line 186 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_inner_error_ = NULL;
#line 186 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_g_error_free0 (e);
#line 1558 "book.c"
	}
	__finally0:
#line 186 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (_inner_error_ != NULL) {
#line 186 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 186 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 186 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 186 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_clear_error (&_inner_error_);
#line 186 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		return NULL;
#line 1573 "book.c"
	}
#line 193 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp15_ = self->priv->jpeg_data;
#line 193 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp16_ = _tmp15_->data;
#line 193 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp16__length1 = _tmp15_->len;
#line 193 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp15_->data = NULL;
#line 193 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	data = _tmp16_;
#line 193 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	data_length1 = _tmp16__length1;
#line 193 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_data_size_ = data_length1;
#line 194 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_byte_array_unref0 (self->priv->jpeg_data);
#line 194 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->priv->jpeg_data = NULL;
#line 196 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp17_ = data;
#line 196 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp17__length1 = data_length1;
#line 196 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (result_length1) {
#line 196 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		*result_length1 = _tmp17__length1;
#line 1601 "book.c"
	}
#line 196 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	result = _tmp17_;
#line 196 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 196 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 196 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return result;
#line 1611 "book.c"
}


static gboolean book_write_pixbuf_data (Book* self, guint8* buf, int buf_length1, GError** error) {
	gboolean result = FALSE;
	GByteArray* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
#line 199 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 201 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = self->priv->jpeg_data;
#line 201 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = buf;
#line 201 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1__length1 = buf_length1;
#line 201 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_byte_array_append (_tmp0_, _tmp1_, _tmp1__length1);
#line 202 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	result = TRUE;
#line 202 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return result;
#line 1634 "book.c"
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
#line 401 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 1641 "book.c"
}


static guint8* _vala_array_dup2 (guint8* self, int length) {
#line 408 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 1648 "book.c"
}


static void book_save_pdf (Book* self, GFile* file, gint quality, GError** error) {
	GFile* _tmp0_;
	GFileOutputStream* _tmp1_ = NULL;
	GFileOutputStream* stream;
	PDFWriter* _tmp2_;
	PDFWriter* writer;
	PDFWriter* _tmp3_;
	PDFWriter* _tmp4_;
	PDFWriter* _tmp5_;
	guint _tmp6_ = 0U;
	guint catalog_number;
	PDFWriter* _tmp7_;
	guint _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	PDFWriter* _tmp11_;
	PDFWriter* _tmp12_;
	PDFWriter* _tmp13_;
	guint _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	PDFWriter* _tmp17_;
	PDFWriter* _tmp18_;
	PDFWriter* _tmp19_;
	PDFWriter* _tmp20_;
	guint _tmp21_ = 0U;
	guint pages_number;
	PDFWriter* _tmp22_;
	guint _tmp23_;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_;
	PDFWriter* _tmp26_;
	PDFWriter* _tmp27_;
	PDFWriter* _tmp28_;
	PDFWriter* _tmp39_;
	PDFWriter* _tmp40_;
	guint _tmp41_ = 0U;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_;
	PDFWriter* _tmp44_;
	PDFWriter* _tmp45_;
	PDFWriter* _tmp352_;
	PDFWriter* _tmp353_;
	guint _tmp354_ = 0U;
	guint info_number;
	PDFWriter* _tmp355_;
	guint _tmp356_;
	gchar* _tmp357_ = NULL;
	gchar* _tmp358_;
	PDFWriter* _tmp359_;
	PDFWriter* _tmp360_;
	gchar* _tmp361_ = NULL;
	gchar* _tmp362_;
	PDFWriter* _tmp363_;
	PDFWriter* _tmp364_;
	PDFWriter* _tmp365_;
	gsize _tmp366_;
	gsize xref_offset;
	PDFWriter* _tmp367_;
	PDFWriter* _tmp368_;
	PDFWriter* _tmp369_;
	GList* _tmp370_;
	guint _tmp371_ = 0U;
	gchar* _tmp372_ = NULL;
	gchar* _tmp373_;
	PDFWriter* _tmp374_;
	GList* _tmp375_;
	PDFWriter* _tmp380_;
	PDFWriter* _tmp381_;
	PDFWriter* _tmp382_;
	PDFWriter* _tmp383_;
	GList* _tmp384_;
	guint _tmp385_ = 0U;
	gchar* _tmp386_ = NULL;
	gchar* _tmp387_;
	PDFWriter* _tmp388_;
	guint _tmp389_;
	gchar* _tmp390_ = NULL;
	gchar* _tmp391_;
	PDFWriter* _tmp392_;
	guint _tmp393_;
	gchar* _tmp394_ = NULL;
	gchar* _tmp395_;
	PDFWriter* _tmp396_;
	PDFWriter* _tmp397_;
	PDFWriter* _tmp398_;
	gsize _tmp399_;
	gchar* _tmp400_ = NULL;
	gchar* _tmp401_;
	PDFWriter* _tmp402_;
	GError * _inner_error_ = NULL;
#line 205 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (self != NULL);
#line 205 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (file != NULL);
#line 207 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = file;
#line 207 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = g_file_replace (_tmp0_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 207 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	stream = _tmp1_;
#line 207 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (_inner_error_ != NULL) {
#line 207 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_propagate_error (error, _inner_error_);
#line 207 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		return;
#line 1759 "book.c"
	}
#line 208 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp2_ = pdf_writer_new (stream);
#line 208 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	writer = _tmp2_;
#line 211 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp3_ = writer;
#line 211 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp3_, "%PDF-1.3\n");
#line 214 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp4_ = writer;
#line 214 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp4_, "%\xe2\xe3\xcf\xd3\n");
#line 217 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp5_ = writer;
#line 217 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp6_ = pdf_writer_start_object (_tmp5_);
#line 217 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	catalog_number = _tmp6_;
#line 218 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp7_ = writer;
#line 218 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp8_ = catalog_number;
#line 218 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp9_ = g_strdup_printf ("%u 0 obj\n", _tmp8_);
#line 218 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp10_ = _tmp9_;
#line 218 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp7_, _tmp10_);
#line 218 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp10_);
#line 219 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp11_ = writer;
#line 219 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp11_, "<<\n");
#line 220 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp12_ = writer;
#line 220 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp12_, "/Type /Catalog\n");
#line 222 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp13_ = writer;
#line 222 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp14_ = catalog_number;
#line 222 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp15_ = g_strdup_printf ("/Pages %u 0 R\n", _tmp14_ + 1);
#line 222 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp16_ = _tmp15_;
#line 222 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp13_, _tmp16_);
#line 222 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp16_);
#line 223 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp17_ = writer;
#line 223 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp17_, ">>\n");
#line 224 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp18_ = writer;
#line 224 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp18_, "endobj\n");
#line 242 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp19_ = writer;
#line 242 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp19_, "\n");
#line 243 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp20_ = writer;
#line 243 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp21_ = pdf_writer_start_object (_tmp20_);
#line 243 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pages_number = _tmp21_;
#line 244 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp22_ = writer;
#line 244 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp23_ = pages_number;
#line 244 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp24_ = g_strdup_printf ("%u 0 obj\n", _tmp23_);
#line 244 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp25_ = _tmp24_;
#line 244 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp22_, _tmp25_);
#line 244 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp25_);
#line 245 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp26_ = writer;
#line 245 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp26_, "<<\n");
#line 246 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp27_ = writer;
#line 246 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp27_, "/Type /Pages\n");
#line 247 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp28_ = writer;
#line 247 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp28_, "/Kids [");
#line 1853 "book.c"
	{
		gint i;
#line 248 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		i = 0;
#line 1858 "book.c"
		{
			gboolean _tmp29_;
#line 248 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			_tmp29_ = TRUE;
#line 248 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			while (TRUE) {
#line 1865 "book.c"
				gboolean _tmp30_;
				gint _tmp32_;
				guint _tmp33_ = 0U;
				PDFWriter* _tmp34_;
				guint _tmp35_;
				gint _tmp36_;
				gchar* _tmp37_ = NULL;
				gchar* _tmp38_;
#line 248 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp30_ = _tmp29_;
#line 248 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (!_tmp30_) {
#line 1878 "book.c"
					gint _tmp31_;
#line 248 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp31_ = i;
#line 248 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					i = _tmp31_ + 1;
#line 1884 "book.c"
				}
#line 248 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp29_ = FALSE;
#line 248 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp32_ = i;
#line 248 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp33_ = book_get_n_pages (self);
#line 248 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (!(((guint) _tmp32_) < _tmp33_)) {
#line 248 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					break;
#line 1896 "book.c"
				}
#line 249 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp34_ = writer;
#line 249 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp35_ = pages_number;
#line 249 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp36_ = i;
#line 249 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp37_ = g_strdup_printf (" %u 0 R", (_tmp35_ + 1) + (_tmp36_ * 3));
#line 249 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp38_ = _tmp37_;
#line 249 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp34_, _tmp38_);
#line 249 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp38_);
#line 1912 "book.c"
			}
		}
	}
#line 250 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp39_ = writer;
#line 250 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp39_, " ]\n");
#line 251 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp40_ = writer;
#line 251 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp41_ = book_get_n_pages (self);
#line 251 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp42_ = g_strdup_printf ("/Count %u\n", _tmp41_);
#line 251 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp43_ = _tmp42_;
#line 251 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp40_, _tmp43_);
#line 251 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp43_);
#line 252 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp44_ = writer;
#line 252 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp44_, ">>\n");
#line 253 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp45_ = writer;
#line 253 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp45_, "endobj\n");
#line 1940 "book.c"
	{
		gint i;
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		i = 0;
#line 1945 "book.c"
		{
			gboolean _tmp46_;
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			_tmp46_ = TRUE;
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			while (TRUE) {
#line 1952 "book.c"
				gboolean _tmp47_;
				gint _tmp49_;
				guint _tmp50_ = 0U;
				gint _tmp51_;
				Page* _tmp52_ = NULL;
				Page* page;
				Page* _tmp53_;
				GdkPixbuf* _tmp54_ = NULL;
				GdkPixbuf* image;
				GdkPixbuf* _tmp55_;
				gint _tmp56_ = 0;
				gint width;
				GdkPixbuf* _tmp57_;
				gint _tmp58_ = 0;
				gint height;
				GdkPixbuf* _tmp59_;
				guint8* _tmp60_ = NULL;
				guint8* pixels;
				gint pixels_length1;
				gint _pixels_size_;
				gint _tmp61_;
				Page* _tmp62_;
				gint _tmp63_ = 0;
				gdouble page_width;
				gint _tmp64_;
				Page* _tmp65_;
				gint _tmp66_ = 0;
				gdouble page_height;
				gint depth;
				gchar* _tmp67_;
				gchar* color_space;
				gchar* filter;
				gchar* _tmp68_ = NULL;
				gchar* width_buffer;
				gint width_buffer_length1;
				gint _width_buffer_size_;
				gchar* _tmp69_ = NULL;
				gchar* height_buffer;
				gint height_buffer_length1;
				gint _height_buffer_size_;
				guint8* data = NULL;
				gint data_length1 = 0;
				gint _data_size_ = 0;
				Page* _tmp70_;
				gboolean _tmp71_ = FALSE;
				guint8* _tmp227_;
				gint _tmp227__length1;
				gint _tmp228_ = 0;
				guint8* _tmp229_ = NULL;
				guint8* compressed_data;
				gint compressed_data_length1;
				gint _compressed_data_size_;
				guint8* _tmp230_;
				gint _tmp230__length1;
				PDFWriter* _tmp247_;
				PDFWriter* _tmp248_;
				guint _tmp249_ = 0U;
				guint number;
				PDFWriter* _tmp250_;
				guint _tmp251_;
				gchar* _tmp252_ = NULL;
				gchar* _tmp253_;
				PDFWriter* _tmp254_;
				PDFWriter* _tmp255_;
				PDFWriter* _tmp256_;
				guint _tmp257_;
				gchar* _tmp258_ = NULL;
				gchar* _tmp259_;
				PDFWriter* _tmp260_;
				gint _tmp261_;
				guint _tmp262_;
				gchar* _tmp263_ = NULL;
				gchar* _tmp264_;
				PDFWriter* _tmp265_;
				gdouble _tmp266_;
				gchar* _tmp267_;
				gint _tmp267__length1;
				const gchar* _tmp268_ = NULL;
				gdouble _tmp269_;
				gchar* _tmp270_;
				gint _tmp270__length1;
				const gchar* _tmp271_ = NULL;
				gchar* _tmp272_ = NULL;
				gchar* _tmp273_;
				PDFWriter* _tmp274_;
				guint _tmp275_;
				gchar* _tmp276_ = NULL;
				gchar* _tmp277_;
				PDFWriter* _tmp278_;
				PDFWriter* _tmp279_;
				PDFWriter* _tmp280_;
				PDFWriter* _tmp281_;
				guint _tmp282_ = 0U;
				PDFWriter* _tmp283_;
				guint _tmp284_;
				gchar* _tmp285_ = NULL;
				gchar* _tmp286_;
				PDFWriter* _tmp287_;
				PDFWriter* _tmp288_;
				PDFWriter* _tmp289_;
				PDFWriter* _tmp290_;
				gint _tmp291_;
				gchar* _tmp292_ = NULL;
				gchar* _tmp293_;
				PDFWriter* _tmp294_;
				gint _tmp295_;
				gchar* _tmp296_ = NULL;
				gchar* _tmp297_;
				PDFWriter* _tmp298_;
				const gchar* _tmp299_;
				gchar* _tmp300_ = NULL;
				gchar* _tmp301_;
				PDFWriter* _tmp302_;
				gint _tmp303_;
				gchar* _tmp304_ = NULL;
				gchar* _tmp305_;
				PDFWriter* _tmp306_;
				guint8* _tmp307_;
				gint _tmp307__length1;
				gchar* _tmp308_ = NULL;
				gchar* _tmp309_;
				const gchar* _tmp310_;
				PDFWriter* _tmp315_;
				PDFWriter* _tmp316_;
				PDFWriter* _tmp317_;
				guint8* _tmp318_;
				gint _tmp318__length1;
				PDFWriter* _tmp319_;
				PDFWriter* _tmp320_;
				PDFWriter* _tmp321_;
				gdouble _tmp322_;
				gchar* _tmp323_;
				gint _tmp323__length1;
				const gchar* _tmp324_ = NULL;
				gdouble _tmp325_;
				gchar* _tmp326_;
				gint _tmp326__length1;
				const gchar* _tmp327_ = NULL;
				gint _tmp328_;
				gchar* _tmp329_ = NULL;
				gchar* command;
				PDFWriter* _tmp330_;
				PDFWriter* _tmp331_;
				guint _tmp332_ = 0U;
				PDFWriter* _tmp333_;
				guint _tmp334_;
				gchar* _tmp335_ = NULL;
				gchar* _tmp336_;
				PDFWriter* _tmp337_;
				PDFWriter* _tmp338_;
				const gchar* _tmp339_;
				gint _tmp340_;
				gint _tmp341_;
				gchar* _tmp342_ = NULL;
				gchar* _tmp343_;
				PDFWriter* _tmp344_;
				PDFWriter* _tmp345_;
				PDFWriter* _tmp346_;
				const gchar* _tmp347_;
				PDFWriter* _tmp348_;
				PDFWriter* _tmp349_;
				PDFWriter* _tmp350_;
				gint _tmp351_;
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp47_ = _tmp46_;
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (!_tmp47_) {
#line 2120 "book.c"
					gint _tmp48_;
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp48_ = i;
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					i = _tmp48_ + 1;
#line 2126 "book.c"
				}
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp46_ = FALSE;
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp49_ = i;
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp50_ = book_get_n_pages (self);
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (!(((guint) _tmp49_) < _tmp50_)) {
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					break;
#line 2138 "book.c"
				}
#line 257 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp51_ = i;
#line 257 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp52_ = book_get_page (self, _tmp51_);
#line 257 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				page = _tmp52_;
#line 258 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp53_ = page;
#line 258 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp54_ = page_get_image (_tmp53_, TRUE);
#line 258 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				image = _tmp54_;
#line 259 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp55_ = image;
#line 259 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp56_ = gdk_pixbuf_get_width (_tmp55_);
#line 259 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				width = _tmp56_;
#line 260 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp57_ = image;
#line 260 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp58_ = gdk_pixbuf_get_height (_tmp57_);
#line 260 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				height = _tmp58_;
#line 261 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp59_ = image;
#line 261 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp60_ = gdk_pixbuf_get_pixels (_tmp59_);
#line 261 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pixels = _tmp60_;
#line 261 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pixels_length1 = -1;
#line 261 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_pixels_size_ = pixels_length1;
#line 262 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp61_ = width;
#line 262 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp62_ = page;
#line 262 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp63_ = page_get_dpi (_tmp62_);
#line 262 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				page_width = (_tmp61_ * 72.0) / _tmp63_;
#line 263 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp64_ = height;
#line 263 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp65_ = page;
#line 263 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp66_ = page_get_dpi (_tmp65_);
#line 263 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				page_height = (_tmp64_ * 72.0) / _tmp66_;
#line 265 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				depth = 8;
#line 266 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp67_ = g_strdup ("DeviceRGB");
#line 266 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				color_space = _tmp67_;
#line 267 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				filter = NULL;
#line 268 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp68_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 268 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				width_buffer = _tmp68_;
#line 268 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				width_buffer_length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 268 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_width_buffer_size_ = width_buffer_length1;
#line 269 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp69_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 269 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				height_buffer = _tmp69_;
#line 269 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				height_buffer_length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 269 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_height_buffer_size_ = height_buffer_length1;
#line 271 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp70_ = page;
#line 271 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp71_ = page_is_color (_tmp70_);
#line 271 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (_tmp71_) {
#line 2220 "book.c"
					gchar* _tmp72_;
					gint _tmp73_;
					gint _tmp74_;
					gint data_length;
					gint _tmp75_;
					guint8* _tmp76_ = NULL;
#line 273 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					depth = 8;
#line 274 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp72_ = g_strdup ("DeviceRGB");
#line 274 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_g_free0 (color_space);
#line 274 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					color_space = _tmp72_;
#line 275 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp73_ = height;
#line 275 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp74_ = width;
#line 275 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					data_length = (_tmp73_ * _tmp74_) * 3;
#line 276 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp75_ = data_length;
#line 276 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp76_ = g_new0 (guint8, _tmp75_);
#line 276 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					data = (g_free (data), NULL);
#line 276 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					data = _tmp76_;
#line 276 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					data_length1 = _tmp75_;
#line 276 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_data_size_ = data_length1;
#line 2253 "book.c"
					{
						gint row;
#line 277 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						row = 0;
#line 2258 "book.c"
						{
							gboolean _tmp77_;
#line 277 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp77_ = TRUE;
#line 277 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							while (TRUE) {
#line 2265 "book.c"
								gboolean _tmp78_;
								gint _tmp80_;
								gint _tmp81_;
								gint _tmp82_;
								GdkPixbuf* _tmp83_;
								gint _tmp84_ = 0;
								gint in_offset;
								gint _tmp85_;
								gint _tmp86_;
								gint out_offset;
#line 277 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								_tmp78_ = _tmp77_;
#line 277 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								if (!_tmp78_) {
#line 2280 "book.c"
									gint _tmp79_;
#line 277 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									_tmp79_ = row;
#line 277 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									row = _tmp79_ + 1;
#line 2286 "book.c"
								}
#line 277 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								_tmp77_ = FALSE;
#line 277 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								_tmp80_ = row;
#line 277 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								_tmp81_ = height;
#line 277 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								if (!(_tmp80_ < _tmp81_)) {
#line 277 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									break;
#line 2298 "book.c"
								}
#line 279 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								_tmp82_ = row;
#line 279 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								_tmp83_ = image;
#line 279 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								_tmp84_ = gdk_pixbuf_get_rowstride (_tmp83_);
#line 279 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								in_offset = _tmp82_ * _tmp84_;
#line 280 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								_tmp85_ = row;
#line 280 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								_tmp86_ = width;
#line 280 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								out_offset = (_tmp85_ * _tmp86_) * 3;
#line 2314 "book.c"
								{
									gint x;
#line 281 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									x = 0;
#line 2319 "book.c"
									{
										gboolean _tmp87_;
#line 281 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp87_ = TRUE;
#line 281 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										while (TRUE) {
#line 2326 "book.c"
											gboolean _tmp88_;
											gint _tmp90_;
											gint _tmp91_;
											gint _tmp92_;
											gint _tmp93_;
											gint in_o;
											gint _tmp94_;
											gint _tmp95_;
											gint out_o;
											guint8* _tmp96_;
											gint _tmp96__length1;
											gint _tmp97_;
											guint8* _tmp98_;
											gint _tmp98__length1;
											gint _tmp99_;
											guint8 _tmp100_;
											guint8 _tmp101_;
											guint8* _tmp102_;
											gint _tmp102__length1;
											gint _tmp103_;
											guint8* _tmp104_;
											gint _tmp104__length1;
											gint _tmp105_;
											guint8 _tmp106_;
											guint8 _tmp107_;
											guint8* _tmp108_;
											gint _tmp108__length1;
											gint _tmp109_;
											guint8* _tmp110_;
											gint _tmp110__length1;
											gint _tmp111_;
											guint8 _tmp112_;
											guint8 _tmp113_;
#line 281 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp88_ = _tmp87_;
#line 281 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											if (!_tmp88_) {
#line 2364 "book.c"
												gint _tmp89_;
#line 281 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp89_ = x;
#line 281 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												x = _tmp89_ + 1;
#line 2370 "book.c"
											}
#line 281 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp87_ = FALSE;
#line 281 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp90_ = x;
#line 281 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp91_ = width;
#line 281 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											if (!(_tmp90_ < _tmp91_)) {
#line 281 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												break;
#line 2382 "book.c"
											}
#line 283 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp92_ = in_offset;
#line 283 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp93_ = x;
#line 283 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											in_o = _tmp92_ + (_tmp93_ * 3);
#line 284 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp94_ = out_offset;
#line 284 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp95_ = x;
#line 284 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											out_o = _tmp94_ + (_tmp95_ * 3);
#line 286 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp96_ = data;
#line 286 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp96__length1 = data_length1;
#line 286 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp97_ = out_o;
#line 286 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp98_ = pixels;
#line 286 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp98__length1 = pixels_length1;
#line 286 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp99_ = in_o;
#line 286 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp100_ = _tmp98_[_tmp99_];
#line 286 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp96_[_tmp97_] = _tmp100_;
#line 286 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp101_ = _tmp96_[_tmp97_];
#line 287 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp102_ = data;
#line 287 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp102__length1 = data_length1;
#line 287 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp103_ = out_o;
#line 287 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp104_ = pixels;
#line 287 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp104__length1 = pixels_length1;
#line 287 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp105_ = in_o;
#line 287 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp106_ = _tmp104_[_tmp105_ + 1];
#line 287 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp102_[_tmp103_ + 1] = _tmp106_;
#line 287 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp107_ = _tmp102_[_tmp103_ + 1];
#line 288 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp108_ = data;
#line 288 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp108__length1 = data_length1;
#line 288 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp109_ = out_o;
#line 288 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp110_ = pixels;
#line 288 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp110__length1 = pixels_length1;
#line 288 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp111_ = in_o;
#line 288 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp112_ = _tmp110_[_tmp111_ + 2];
#line 288 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp108_[_tmp109_ + 2] = _tmp112_;
#line 288 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp113_ = _tmp108_[_tmp109_ + 2];
#line 2450 "book.c"
										}
									}
								}
							}
						}
					}
				} else {
					Page* _tmp114_;
					gint _tmp115_ = 0;
#line 292 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp114_ = page;
#line 292 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp115_ = page_get_depth (_tmp114_);
#line 292 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					if (_tmp115_ == 2) {
#line 2466 "book.c"
						gint shift_count;
						gchar* _tmp116_;
						gint _tmp117_;
						gint _tmp118_;
						gint data_length;
						gint _tmp119_;
						guint8* _tmp120_ = NULL;
						gint offset;
#line 294 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						shift_count = 6;
#line 295 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						depth = 2;
#line 296 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp116_ = g_strdup ("DeviceGray");
#line 296 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_g_free0 (color_space);
#line 296 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						color_space = _tmp116_;
#line 297 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp117_ = height;
#line 297 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp118_ = width;
#line 297 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						data_length = _tmp117_ * (((_tmp118_ * 2) + 7) / 8);
#line 298 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp119_ = data_length;
#line 298 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp120_ = g_new0 (guint8, _tmp119_);
#line 298 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						data = (g_free (data), NULL);
#line 298 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						data = _tmp120_;
#line 298 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						data_length1 = _tmp119_;
#line 298 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_data_size_ = data_length1;
#line 299 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						offset = 0;
#line 2505 "book.c"
						{
							gint row;
#line 300 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							row = 0;
#line 2510 "book.c"
							{
								gboolean _tmp121_;
#line 300 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								_tmp121_ = TRUE;
#line 300 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								while (TRUE) {
#line 2517 "book.c"
									gboolean _tmp122_;
									gint _tmp124_;
									gint _tmp125_;
									gint _tmp126_;
									gint _tmp128_;
									GdkPixbuf* _tmp129_;
									gint _tmp130_ = 0;
									gint in_offset;
#line 300 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									_tmp122_ = _tmp121_;
#line 300 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									if (!_tmp122_) {
#line 2530 "book.c"
										gint _tmp123_;
#line 300 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp123_ = row;
#line 300 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										row = _tmp123_ + 1;
#line 2536 "book.c"
									}
#line 300 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									_tmp121_ = FALSE;
#line 300 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									_tmp124_ = row;
#line 300 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									_tmp125_ = height;
#line 300 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									if (!(_tmp124_ < _tmp125_)) {
#line 300 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										break;
#line 2548 "book.c"
									}
#line 303 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									_tmp126_ = shift_count;
#line 303 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									if (_tmp126_ != 6) {
#line 2554 "book.c"
										gint _tmp127_;
#line 305 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp127_ = offset;
#line 305 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										offset = _tmp127_ + 1;
#line 306 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										shift_count = 6;
#line 2562 "book.c"
									}
#line 309 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									_tmp128_ = row;
#line 309 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									_tmp129_ = image;
#line 309 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									_tmp130_ = gdk_pixbuf_get_rowstride (_tmp129_);
#line 309 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									in_offset = _tmp128_ * _tmp130_;
#line 2572 "book.c"
									{
										gint x;
#line 310 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										x = 0;
#line 2577 "book.c"
										{
											gboolean _tmp131_;
#line 310 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp131_ = TRUE;
#line 310 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											while (TRUE) {
#line 2584 "book.c"
												gboolean _tmp132_;
												gint _tmp134_;
												gint _tmp135_;
												gint _tmp136_;
												guint8* _tmp140_;
												gint _tmp140__length1;
												gint _tmp141_;
												gint _tmp142_;
												guint8 _tmp143_;
												guint8 p;
												guint8 _tmp144_;
												gint _tmp159_;
#line 310 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp132_ = _tmp131_;
#line 310 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												if (!_tmp132_) {
#line 2601 "book.c"
													gint _tmp133_;
#line 310 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp133_ = x;
#line 310 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													x = _tmp133_ + 1;
#line 2607 "book.c"
												}
#line 310 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp131_ = FALSE;
#line 310 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp134_ = x;
#line 310 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp135_ = width;
#line 310 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												if (!(_tmp134_ < _tmp135_)) {
#line 310 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													break;
#line 2619 "book.c"
												}
#line 313 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp136_ = shift_count;
#line 313 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												if (_tmp136_ == 6) {
#line 2625 "book.c"
													guint8* _tmp137_;
													gint _tmp137__length1;
													gint _tmp138_;
													guint8 _tmp139_;
#line 314 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp137_ = data;
#line 314 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp137__length1 = data_length1;
#line 314 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp138_ = offset;
#line 314 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp137_[_tmp138_] = (guint8) 0;
#line 314 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp139_ = _tmp137_[_tmp138_];
#line 2640 "book.c"
												}
#line 317 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp140_ = pixels;
#line 317 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp140__length1 = pixels_length1;
#line 317 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp141_ = in_offset;
#line 317 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp142_ = x;
#line 317 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp143_ = _tmp140_[_tmp141_ + (_tmp142_ * 3)];
#line 317 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												p = _tmp143_;
#line 318 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp144_ = p;
#line 318 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												if (((gint) _tmp144_) >= 192) {
#line 2658 "book.c"
													guint8* _tmp145_;
													gint _tmp145__length1;
													gint _tmp146_;
													gint _tmp147_;
													guint8 _tmp148_;
#line 319 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp145_ = data;
#line 319 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp145__length1 = data_length1;
#line 319 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp146_ = offset;
#line 319 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp147_ = shift_count;
#line 319 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp145_[_tmp146_] |= (guint8) (3 << _tmp147_);
#line 319 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp148_ = _tmp145_[_tmp146_];
#line 2676 "book.c"
												} else {
													guint8 _tmp149_;
#line 320 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp149_ = p;
#line 320 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													if (((gint) _tmp149_) >= 128) {
#line 2683 "book.c"
														guint8* _tmp150_;
														gint _tmp150__length1;
														gint _tmp151_;
														gint _tmp152_;
														guint8 _tmp153_;
#line 321 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp150_ = data;
#line 321 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp150__length1 = data_length1;
#line 321 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp151_ = offset;
#line 321 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp152_ = shift_count;
#line 321 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp150_[_tmp151_] |= (guint8) (2 << _tmp152_);
#line 321 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp153_ = _tmp150_[_tmp151_];
#line 2701 "book.c"
													} else {
														guint8 _tmp154_;
#line 322 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp154_ = p;
#line 322 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														if (((gint) _tmp154_) >= 64) {
#line 2708 "book.c"
															guint8* _tmp155_;
															gint _tmp155__length1;
															gint _tmp156_;
															gint _tmp157_;
															guint8 _tmp158_;
#line 323 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
															_tmp155_ = data;
#line 323 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
															_tmp155__length1 = data_length1;
#line 323 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
															_tmp156_ = offset;
#line 323 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
															_tmp157_ = shift_count;
#line 323 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
															_tmp155_[_tmp156_] |= (guint8) (1 << _tmp157_);
#line 323 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
															_tmp158_ = _tmp155_[_tmp156_];
#line 2726 "book.c"
														}
													}
												}
#line 326 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp159_ = shift_count;
#line 326 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												if (_tmp159_ == 0) {
#line 2734 "book.c"
													gint _tmp160_;
#line 328 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp160_ = offset;
#line 328 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													offset = _tmp160_ + 1;
#line 329 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													shift_count = 6;
#line 2742 "book.c"
												} else {
													gint _tmp161_;
#line 332 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp161_ = shift_count;
#line 332 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													shift_count = _tmp161_ - 2;
#line 2749 "book.c"
												}
											}
										}
									}
								}
							}
						}
					} else {
						Page* _tmp162_;
						gint _tmp163_ = 0;
#line 336 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp162_ = page;
#line 336 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp163_ = page_get_depth (_tmp162_);
#line 336 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						if (_tmp163_ == 1) {
#line 2766 "book.c"
							gint mask;
							gchar* _tmp164_;
							gint _tmp165_;
							gint _tmp166_;
							gint data_length;
							gint _tmp167_;
							guint8* _tmp168_ = NULL;
							gint offset;
#line 338 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							mask = 0x80;
#line 340 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							depth = 1;
#line 341 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp164_ = g_strdup ("DeviceGray");
#line 341 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_g_free0 (color_space);
#line 341 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							color_space = _tmp164_;
#line 342 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp165_ = height;
#line 342 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp166_ = width;
#line 342 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							data_length = _tmp165_ * ((_tmp166_ + 7) / 8);
#line 343 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp167_ = data_length;
#line 343 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp168_ = g_new0 (guint8, _tmp167_);
#line 343 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							data = (g_free (data), NULL);
#line 343 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							data = _tmp168_;
#line 343 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							data_length1 = _tmp167_;
#line 343 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_data_size_ = data_length1;
#line 344 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							offset = 0;
#line 2805 "book.c"
							{
								gint row;
#line 345 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								row = 0;
#line 2810 "book.c"
								{
									gboolean _tmp169_;
#line 345 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									_tmp169_ = TRUE;
#line 345 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									while (TRUE) {
#line 2817 "book.c"
										gboolean _tmp170_;
										gint _tmp172_;
										gint _tmp173_;
										gint _tmp174_;
										gint _tmp176_;
										GdkPixbuf* _tmp177_;
										gint _tmp178_ = 0;
										gint in_offset;
#line 345 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp170_ = _tmp169_;
#line 345 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										if (!_tmp170_) {
#line 2830 "book.c"
											gint _tmp171_;
#line 345 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp171_ = row;
#line 345 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											row = _tmp171_ + 1;
#line 2836 "book.c"
										}
#line 345 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp169_ = FALSE;
#line 345 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp172_ = row;
#line 345 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp173_ = height;
#line 345 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										if (!(_tmp172_ < _tmp173_)) {
#line 345 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											break;
#line 2848 "book.c"
										}
#line 348 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp174_ = mask;
#line 348 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										if (_tmp174_ != 0x80) {
#line 2854 "book.c"
											gint _tmp175_;
#line 350 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp175_ = offset;
#line 350 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											offset = _tmp175_ + 1;
#line 351 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											mask = 0x80;
#line 2862 "book.c"
										}
#line 354 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp176_ = row;
#line 354 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp177_ = image;
#line 354 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp178_ = gdk_pixbuf_get_rowstride (_tmp177_);
#line 354 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										in_offset = _tmp176_ * _tmp178_;
#line 2872 "book.c"
										{
											gint x;
#line 355 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											x = 0;
#line 2877 "book.c"
											{
												gboolean _tmp179_;
#line 355 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp179_ = TRUE;
#line 355 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												while (TRUE) {
#line 2884 "book.c"
													gboolean _tmp180_;
													gint _tmp182_;
													gint _tmp183_;
													gint _tmp184_;
													guint8* _tmp188_;
													gint _tmp188__length1;
													gint _tmp189_;
													gint _tmp190_;
													guint8 _tmp191_;
													gint _tmp196_;
													gint _tmp197_;
#line 355 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp180_ = _tmp179_;
#line 355 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													if (!_tmp180_) {
#line 2900 "book.c"
														gint _tmp181_;
#line 355 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp181_ = x;
#line 355 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														x = _tmp181_ + 1;
#line 2906 "book.c"
													}
#line 355 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp179_ = FALSE;
#line 355 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp182_ = x;
#line 355 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp183_ = width;
#line 355 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													if (!(_tmp182_ < _tmp183_)) {
#line 355 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														break;
#line 2918 "book.c"
													}
#line 358 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp184_ = mask;
#line 358 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													if (_tmp184_ == 0x80) {
#line 2924 "book.c"
														guint8* _tmp185_;
														gint _tmp185__length1;
														gint _tmp186_;
														guint8 _tmp187_;
#line 359 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp185_ = data;
#line 359 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp185__length1 = data_length1;
#line 359 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp186_ = offset;
#line 359 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp185_[_tmp186_] = (guint8) 0;
#line 359 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp187_ = _tmp185_[_tmp186_];
#line 2939 "book.c"
													}
#line 362 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp188_ = pixels;
#line 362 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp188__length1 = pixels_length1;
#line 362 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp189_ = in_offset;
#line 362 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp190_ = x;
#line 362 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp191_ = _tmp188_[_tmp189_ + (_tmp190_ * 3)];
#line 362 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													if (((gint) _tmp191_) != 0) {
#line 2953 "book.c"
														guint8* _tmp192_;
														gint _tmp192__length1;
														gint _tmp193_;
														gint _tmp194_;
														guint8 _tmp195_;
#line 363 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp192_ = data;
#line 363 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp192__length1 = data_length1;
#line 363 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp193_ = offset;
#line 363 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp194_ = mask;
#line 363 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp192_[_tmp193_] |= (guint8) _tmp194_;
#line 363 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp195_ = _tmp192_[_tmp193_];
#line 2971 "book.c"
													}
#line 366 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp196_ = mask;
#line 366 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													mask = _tmp196_ >> 1;
#line 367 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp197_ = mask;
#line 367 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													if (_tmp197_ == 0) {
#line 2981 "book.c"
														gint _tmp198_;
#line 369 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp198_ = offset;
#line 369 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														offset = _tmp198_ + 1;
#line 370 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														mask = 0x80;
#line 2989 "book.c"
													}
												}
											}
										}
									}
								}
							}
						} else {
							gchar* _tmp199_;
							gint _tmp200_;
							gint _tmp201_;
							gint data_length;
							gint _tmp202_;
							guint8* _tmp203_ = NULL;
#line 377 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							depth = 8;
#line 378 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp199_ = g_strdup ("DeviceGray");
#line 378 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_g_free0 (color_space);
#line 378 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							color_space = _tmp199_;
#line 379 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp200_ = height;
#line 379 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp201_ = width;
#line 379 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							data_length = _tmp200_ * _tmp201_;
#line 380 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp202_ = data_length;
#line 380 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp203_ = g_new0 (guint8, _tmp202_);
#line 380 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							data = (g_free (data), NULL);
#line 380 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							data = _tmp203_;
#line 380 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							data_length1 = _tmp202_;
#line 380 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_data_size_ = data_length1;
#line 3030 "book.c"
							{
								gint row;
#line 381 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								row = 0;
#line 3035 "book.c"
								{
									gboolean _tmp204_;
#line 381 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									_tmp204_ = TRUE;
#line 381 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									while (TRUE) {
#line 3042 "book.c"
										gboolean _tmp205_;
										gint _tmp207_;
										gint _tmp208_;
										gint _tmp209_;
										GdkPixbuf* _tmp210_;
										gint _tmp211_ = 0;
										gint in_offset;
										gint _tmp212_;
										gint _tmp213_;
										gint out_offset;
#line 381 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp205_ = _tmp204_;
#line 381 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										if (!_tmp205_) {
#line 3057 "book.c"
											gint _tmp206_;
#line 381 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp206_ = row;
#line 381 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											row = _tmp206_ + 1;
#line 3063 "book.c"
										}
#line 381 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp204_ = FALSE;
#line 381 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp207_ = row;
#line 381 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp208_ = height;
#line 381 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										if (!(_tmp207_ < _tmp208_)) {
#line 381 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											break;
#line 3075 "book.c"
										}
#line 383 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp209_ = row;
#line 383 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp210_ = image;
#line 383 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp211_ = gdk_pixbuf_get_rowstride (_tmp210_);
#line 383 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										in_offset = _tmp209_ * _tmp211_;
#line 384 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp212_ = row;
#line 384 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp213_ = width;
#line 384 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										out_offset = _tmp212_ * _tmp213_;
#line 3091 "book.c"
										{
											gint x;
#line 385 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											x = 0;
#line 3096 "book.c"
											{
												gboolean _tmp214_;
#line 385 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp214_ = TRUE;
#line 385 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												while (TRUE) {
#line 3103 "book.c"
													gboolean _tmp215_;
													gint _tmp217_;
													gint _tmp218_;
													guint8* _tmp219_;
													gint _tmp219__length1;
													gint _tmp220_;
													gint _tmp221_;
													guint8* _tmp222_;
													gint _tmp222__length1;
													gint _tmp223_;
													gint _tmp224_;
													guint8 _tmp225_;
													guint8 _tmp226_;
#line 385 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp215_ = _tmp214_;
#line 385 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													if (!_tmp215_) {
#line 3121 "book.c"
														gint _tmp216_;
#line 385 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp216_ = x;
#line 385 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														x = _tmp216_ + 1;
#line 3127 "book.c"
													}
#line 385 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp214_ = FALSE;
#line 385 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp217_ = x;
#line 385 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp218_ = width;
#line 385 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													if (!(_tmp217_ < _tmp218_)) {
#line 385 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														break;
#line 3139 "book.c"
													}
#line 386 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp219_ = data;
#line 386 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp219__length1 = data_length1;
#line 386 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp220_ = out_offset;
#line 386 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp221_ = x;
#line 386 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp222_ = pixels;
#line 386 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp222__length1 = pixels_length1;
#line 386 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp223_ = in_offset;
#line 386 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp224_ = x;
#line 386 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp225_ = _tmp222_[_tmp223_ + (_tmp224_ * 3)];
#line 386 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp219_[_tmp220_ + _tmp221_] = _tmp225_;
#line 386 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp226_ = _tmp219_[_tmp220_ + _tmp221_];
#line 3163 "book.c"
												}
											}
										}
									}
								}
							}
						}
					}
				}
#line 391 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp227_ = data;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp227__length1 = data_length1;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp229_ = book_compress_zlib (self, _tmp227_, _tmp227__length1, &_tmp228_);
#line 391 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				compressed_data = _tmp229_;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				compressed_data_length1 = _tmp228_;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_compressed_data_size_ = compressed_data_length1;
#line 392 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp230_ = compressed_data;
#line 392 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp230__length1 = compressed_data_length1;
#line 392 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (_tmp230_ != NULL) {
#line 3191 "book.c"
					gint _tmp231_;
					const gchar* _tmp243_;
#line 395 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp231_ = depth;
#line 395 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					if (_tmp231_ > 1) {
#line 3198 "book.c"
						GdkPixbuf* _tmp232_;
						gint _tmp233_;
						Page* _tmp234_;
						gint _tmp235_ = 0;
						gint _tmp236_ = 0;
						guint8* _tmp237_ = NULL;
						guint8* jpeg_data;
						gint jpeg_data_length1;
						gint _jpeg_data_size_;
						guint8* _tmp238_;
						gint _tmp238__length1;
						guint8* _tmp239_;
						gint _tmp239__length1;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp232_ = image;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp233_ = quality;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp234_ = page;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp235_ = page_get_dpi (_tmp234_);
#line 397 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp237_ = book_compress_jpeg (self, _tmp232_, _tmp233_, _tmp235_, &_tmp236_);
#line 397 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						jpeg_data = _tmp237_;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						jpeg_data_length1 = _tmp236_;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_jpeg_data_size_ = jpeg_data_length1;
#line 398 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp238_ = jpeg_data;
#line 398 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp238__length1 = jpeg_data_length1;
#line 398 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp239_ = compressed_data;
#line 398 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp239__length1 = compressed_data_length1;
#line 398 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						if (_tmp238__length1 < _tmp239__length1) {
#line 3238 "book.c"
							gchar* _tmp240_;
							guint8* _tmp241_;
							gint _tmp241__length1;
							guint8* _tmp242_;
							gint _tmp242__length1;
#line 400 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp240_ = g_strdup ("DCTDecode");
#line 400 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_g_free0 (filter);
#line 400 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							filter = _tmp240_;
#line 401 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp241_ = jpeg_data;
#line 401 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp241__length1 = jpeg_data_length1;
#line 401 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp242_ = (_tmp241_ != NULL) ? _vala_array_dup1 (_tmp241_, _tmp241__length1) : ((gpointer) _tmp241_);
#line 401 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp242__length1 = _tmp241__length1;
#line 401 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							data = (g_free (data), NULL);
#line 401 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							data = _tmp242_;
#line 401 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							data_length1 = _tmp242__length1;
#line 401 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_data_size_ = data_length1;
#line 3266 "book.c"
						}
#line 395 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						jpeg_data = (g_free (jpeg_data), NULL);
#line 3270 "book.c"
					}
#line 405 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp243_ = filter;
#line 405 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					if (_tmp243_ == NULL) {
#line 3276 "book.c"
						gchar* _tmp244_;
						guint8* _tmp245_;
						gint _tmp245__length1;
						guint8* _tmp246_;
						gint _tmp246__length1;
#line 407 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp244_ = g_strdup ("FlateDecode");
#line 407 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_g_free0 (filter);
#line 407 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						filter = _tmp244_;
#line 408 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp245_ = compressed_data;
#line 408 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp245__length1 = compressed_data_length1;
#line 408 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp246_ = (_tmp245_ != NULL) ? _vala_array_dup2 (_tmp245_, _tmp245__length1) : ((gpointer) _tmp245_);
#line 408 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp246__length1 = _tmp245__length1;
#line 408 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						data = (g_free (data), NULL);
#line 408 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						data = _tmp246_;
#line 408 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						data_length1 = _tmp246__length1;
#line 408 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_data_size_ = data_length1;
#line 3304 "book.c"
					}
				}
#line 413 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp247_ = writer;
#line 413 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp247_, "\n");
#line 414 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp248_ = writer;
#line 414 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp249_ = pdf_writer_start_object (_tmp248_);
#line 414 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				number = _tmp249_;
#line 415 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp250_ = writer;
#line 415 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp251_ = number;
#line 415 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp252_ = g_strdup_printf ("%u 0 obj\n", _tmp251_);
#line 415 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp253_ = _tmp252_;
#line 415 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp250_, _tmp253_);
#line 415 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp253_);
#line 416 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp254_ = writer;
#line 416 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp254_, "<<\n");
#line 417 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp255_ = writer;
#line 417 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp255_, "/Type /Page\n");
#line 418 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp256_ = writer;
#line 418 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp257_ = pages_number;
#line 418 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp258_ = g_strdup_printf ("/Parent %u 0 R\n", _tmp257_);
#line 418 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp259_ = _tmp258_;
#line 418 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp256_, _tmp259_);
#line 418 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp259_);
#line 419 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp260_ = writer;
#line 419 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp261_ = i;
#line 419 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp262_ = number;
#line 419 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp263_ = g_strdup_printf ("/Resources << /XObject << /Im%d %u 0 R >> >>\n", _tmp261_, _tmp262_ + 1);
#line 419 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp264_ = _tmp263_;
#line 419 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp260_, _tmp264_);
#line 419 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp264_);
#line 420 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp265_ = writer;
#line 420 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp266_ = page_width;
#line 420 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp267_ = width_buffer;
#line 420 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp267__length1 = width_buffer_length1;
#line 420 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp268_ = g_ascii_formatd (_tmp267_, _tmp267__length1, "%.2f", _tmp266_);
#line 420 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp269_ = page_height;
#line 420 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp270_ = height_buffer;
#line 420 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp270__length1 = height_buffer_length1;
#line 420 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp271_ = g_ascii_formatd (_tmp270_, _tmp270__length1, "%.2f", _tmp269_);
#line 420 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp272_ = g_strdup_printf ("/MediaBox [ 0 0 %s %s ]\n", _tmp268_, _tmp271_);
#line 420 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp273_ = _tmp272_;
#line 420 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp265_, _tmp273_);
#line 420 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp273_);
#line 421 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp274_ = writer;
#line 421 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp275_ = number;
#line 421 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp276_ = g_strdup_printf ("/Contents %u 0 R\n", _tmp275_ + 2);
#line 421 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp277_ = _tmp276_;
#line 421 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp274_, _tmp277_);
#line 421 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp277_);
#line 422 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp278_ = writer;
#line 422 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp278_, ">>\n");
#line 423 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp279_ = writer;
#line 423 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp279_, "endobj\n");
#line 426 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp280_ = writer;
#line 426 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp280_, "\n");
#line 427 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp281_ = writer;
#line 427 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp282_ = pdf_writer_start_object (_tmp281_);
#line 427 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				number = _tmp282_;
#line 428 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp283_ = writer;
#line 428 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp284_ = number;
#line 428 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp285_ = g_strdup_printf ("%u 0 obj\n", _tmp284_);
#line 428 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp286_ = _tmp285_;
#line 428 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp283_, _tmp286_);
#line 428 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp286_);
#line 429 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp287_ = writer;
#line 429 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp287_, "<<\n");
#line 430 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp288_ = writer;
#line 430 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp288_, "/Type /XObject\n");
#line 431 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp289_ = writer;
#line 431 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp289_, "/Subtype /Image\n");
#line 432 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp290_ = writer;
#line 432 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp291_ = width;
#line 432 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp292_ = g_strdup_printf ("/Width %d\n", _tmp291_);
#line 432 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp293_ = _tmp292_;
#line 432 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp290_, _tmp293_);
#line 432 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp293_);
#line 433 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp294_ = writer;
#line 433 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp295_ = height;
#line 433 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp296_ = g_strdup_printf ("/Height %d\n", _tmp295_);
#line 433 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp297_ = _tmp296_;
#line 433 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp294_, _tmp297_);
#line 433 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp297_);
#line 434 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp298_ = writer;
#line 434 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp299_ = color_space;
#line 434 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp300_ = g_strdup_printf ("/ColorSpace /%s\n", _tmp299_);
#line 434 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp301_ = _tmp300_;
#line 434 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp298_, _tmp301_);
#line 434 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp301_);
#line 435 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp302_ = writer;
#line 435 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp303_ = depth;
#line 435 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp304_ = g_strdup_printf ("/BitsPerComponent %d\n", _tmp303_);
#line 435 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp305_ = _tmp304_;
#line 435 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp302_, _tmp305_);
#line 435 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp305_);
#line 436 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp306_ = writer;
#line 436 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp307_ = data;
#line 436 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp307__length1 = data_length1;
#line 436 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp308_ = g_strdup_printf ("/Length %d\n", _tmp307__length1);
#line 436 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp309_ = _tmp308_;
#line 436 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp306_, _tmp309_);
#line 436 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp309_);
#line 437 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp310_ = filter;
#line 437 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (_tmp310_ != NULL) {
#line 3509 "book.c"
					PDFWriter* _tmp311_;
					const gchar* _tmp312_;
					gchar* _tmp313_ = NULL;
					gchar* _tmp314_;
#line 438 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp311_ = writer;
#line 438 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp312_ = filter;
#line 438 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp313_ = g_strdup_printf ("/Filter /%s\n", _tmp312_);
#line 438 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp314_ = _tmp313_;
#line 438 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					pdf_writer_write_string (_tmp311_, _tmp314_);
#line 438 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_g_free0 (_tmp314_);
#line 3526 "book.c"
				}
#line 439 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp315_ = writer;
#line 439 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp315_, ">>\n");
#line 440 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp316_ = writer;
#line 440 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp316_, "stream\n");
#line 441 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp317_ = writer;
#line 441 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp318_ = data;
#line 441 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp318__length1 = data_length1;
#line 441 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write (_tmp317_, _tmp318_, _tmp318__length1);
#line 442 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp319_ = writer;
#line 442 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp319_, "\n");
#line 443 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp320_ = writer;
#line 443 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp320_, "endstream\n");
#line 444 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp321_ = writer;
#line 444 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp321_, "endobj\n");
#line 447 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp322_ = page_width;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp323_ = width_buffer;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp323__length1 = width_buffer_length1;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp324_ = g_ascii_formatd (_tmp323_, _tmp323__length1, "%f", _tmp322_);
#line 447 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp325_ = page_height;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp326_ = height_buffer;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp326__length1 = height_buffer_length1;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp327_ = g_ascii_formatd (_tmp326_, _tmp326__length1, "%f", _tmp325_);
#line 447 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp328_ = i;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp329_ = g_strdup_printf ("q\n%s 0 0 %s 0 0 cm\n/Im%d Do\nQ", _tmp324_, _tmp327_, _tmp328_);
#line 447 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				command = _tmp329_;
#line 448 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp330_ = writer;
#line 448 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp330_, "\n");
#line 449 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp331_ = writer;
#line 449 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp332_ = pdf_writer_start_object (_tmp331_);
#line 449 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				number = _tmp332_;
#line 450 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp333_ = writer;
#line 450 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp334_ = number;
#line 450 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp335_ = g_strdup_printf ("%u 0 obj\n", _tmp334_);
#line 450 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp336_ = _tmp335_;
#line 450 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp333_, _tmp336_);
#line 450 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp336_);
#line 451 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp337_ = writer;
#line 451 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp337_, "<<\n");
#line 452 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp338_ = writer;
#line 452 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp339_ = command;
#line 452 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp340_ = strlen (_tmp339_);
#line 452 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp341_ = _tmp340_;
#line 452 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp342_ = g_strdup_printf ("/Length %d\n", _tmp341_ + 1);
#line 452 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp343_ = _tmp342_;
#line 452 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp338_, _tmp343_);
#line 452 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp343_);
#line 453 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp344_ = writer;
#line 453 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp344_, ">>\n");
#line 454 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp345_ = writer;
#line 454 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp345_, "stream\n");
#line 455 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp346_ = writer;
#line 455 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp347_ = command;
#line 455 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp346_, _tmp347_);
#line 456 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp348_ = writer;
#line 456 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp348_, "\n");
#line 457 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp349_ = writer;
#line 457 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp349_, "endstream\n");
#line 458 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp350_ = writer;
#line 458 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp350_, "endobj\n");
#line 460 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp351_ = i;
#line 460 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				g_signal_emit_by_name (self, "saving", _tmp351_);
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (command);
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				compressed_data = (g_free (compressed_data), NULL);
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				data = (g_free (data), NULL);
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				height_buffer = (g_free (height_buffer), NULL);
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				width_buffer = (g_free (width_buffer), NULL);
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (filter);
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (color_space);
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_object_unref0 (image);
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_page_unref0 (page);
#line 3668 "book.c"
			}
		}
	}
#line 464 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp352_ = writer;
#line 464 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp352_, "\n");
#line 465 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp353_ = writer;
#line 465 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp354_ = pdf_writer_start_object (_tmp353_);
#line 465 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	info_number = _tmp354_;
#line 466 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp355_ = writer;
#line 466 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp356_ = info_number;
#line 466 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp357_ = g_strdup_printf ("%u 0 obj\n", _tmp356_);
#line 466 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp358_ = _tmp357_;
#line 466 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp355_, _tmp358_);
#line 466 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp358_);
#line 467 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp359_ = writer;
#line 467 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp359_, "<<\n");
#line 468 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp360_ = writer;
#line 468 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp361_ = g_strdup_printf ("/Creator (Simple Scan %s)\n", VERSION);
#line 468 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp362_ = _tmp361_;
#line 468 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp360_, _tmp362_);
#line 468 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp362_);
#line 469 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp363_ = writer;
#line 469 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp363_, ">>\n");
#line 470 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp364_ = writer;
#line 470 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp364_, "endobj\n");
#line 473 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp365_ = writer;
#line 473 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp366_ = _tmp365_->offset;
#line 473 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	xref_offset = _tmp366_;
#line 474 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp367_ = writer;
#line 474 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp367_, "xref\n");
#line 475 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp368_ = writer;
#line 475 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp369_ = writer;
#line 475 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp370_ = _tmp369_->object_offsets;
#line 475 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp371_ = g_list_length (_tmp370_);
#line 475 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp372_ = g_strdup_printf ("1 %zu\n", (gsize) _tmp371_);
#line 475 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp373_ = _tmp372_;
#line 475 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp368_, _tmp373_);
#line 475 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp373_);
#line 476 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp374_ = writer;
#line 476 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp375_ = _tmp374_->object_offsets;
#line 3746 "book.c"
	{
		GList* offset_collection = NULL;
		GList* offset_it = NULL;
#line 476 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		offset_collection = _tmp375_;
#line 476 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		for (offset_it = offset_collection; offset_it != NULL; offset_it = offset_it->next) {
#line 3754 "book.c"
			guint offset = 0U;
#line 476 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			offset = (guint) ((guintptr) offset_it->data);
#line 3758 "book.c"
			{
				PDFWriter* _tmp376_;
				guint _tmp377_;
				gchar* _tmp378_ = NULL;
				gchar* _tmp379_;
#line 477 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp376_ = writer;
#line 477 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp377_ = offset;
#line 477 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp378_ = g_strdup_printf ("%010zu 00000 n \n", (gsize) _tmp377_);
#line 477 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp379_ = _tmp378_;
#line 477 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp376_, _tmp379_);
#line 477 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp379_);
#line 3776 "book.c"
			}
		}
	}
#line 480 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp380_ = writer;
#line 480 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp380_, "trailer\n");
#line 481 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp381_ = writer;
#line 481 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp381_, "<<\n");
#line 482 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp382_ = writer;
#line 482 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp383_ = writer;
#line 482 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp384_ = _tmp383_->object_offsets;
#line 482 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp385_ = g_list_length (_tmp384_);
#line 482 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp386_ = g_strdup_printf ("/Size %zu\n", (gsize) _tmp385_);
#line 482 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp387_ = _tmp386_;
#line 482 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp382_, _tmp387_);
#line 482 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp387_);
#line 483 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp388_ = writer;
#line 483 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp389_ = info_number;
#line 483 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp390_ = g_strdup_printf ("/Info %u 0 R\n", _tmp389_);
#line 483 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp391_ = _tmp390_;
#line 483 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp388_, _tmp391_);
#line 483 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp391_);
#line 484 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp392_ = writer;
#line 484 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp393_ = catalog_number;
#line 484 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp394_ = g_strdup_printf ("/Root %u 0 R\n", _tmp393_);
#line 484 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp395_ = _tmp394_;
#line 484 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp392_, _tmp395_);
#line 484 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp395_);
#line 486 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp396_ = writer;
#line 486 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp396_, ">>\n");
#line 487 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp397_ = writer;
#line 487 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp397_, "startxref\n");
#line 488 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp398_ = writer;
#line 488 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp399_ = xref_offset;
#line 488 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp400_ = g_strdup_printf ("%zu\n", _tmp399_);
#line 488 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp401_ = _tmp400_;
#line 488 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp398_, _tmp401_);
#line 488 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp401_);
#line 489 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp402_ = writer;
#line 489 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp402_, "%%EOF\n");
#line 205 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_pdf_writer_unref0 (writer);
#line 205 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_object_unref0 (stream);
#line 3856 "book.c"
}


void book_save (Book* self, const gchar* type, gint quality, GFile* file, GError** error) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
#line 494 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	static GQuark _tmp2_label0 = 0;
#line 494 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	static GQuark _tmp2_label1 = 0;
#line 494 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	static GQuark _tmp2_label2 = 0;
#line 494 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	static GQuark _tmp2_label3 = 0;
#line 494 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	static GQuark _tmp2_label4 = 0;
#line 3874 "book.c"
	GError * _inner_error_ = NULL;
#line 492 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (self != NULL);
#line 492 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (type != NULL);
#line 492 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (file != NULL);
#line 494 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = type;
#line 494 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = _tmp0_;
#line 494 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 494 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("jpeg")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("png"))))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("tiff"))))) {
#line 494 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		switch (0) {
#line 3892 "book.c"
			default:
			{
				const gchar* _tmp4_;
				gint _tmp5_;
				GFile* _tmp6_;
#line 499 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp4_ = type;
#line 499 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp5_ = quality;
#line 499 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp6_ = file;
#line 499 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				book_save_multi_file (self, _tmp4_, _tmp5_, _tmp6_, &_inner_error_);
#line 499 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (_inner_error_ != NULL) {
#line 499 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 499 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					return;
#line 3912 "book.c"
				}
#line 500 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				break;
#line 3916 "book.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("ps")))) {
#line 494 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		switch (0) {
#line 3922 "book.c"
			default:
			{
				GFile* _tmp7_;
#line 502 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp7_ = file;
#line 502 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				book_save_ps (self, _tmp7_, &_inner_error_);
#line 502 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (_inner_error_ != NULL) {
#line 502 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 502 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					return;
#line 3936 "book.c"
				}
#line 503 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				break;
#line 3940 "book.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("pdf")))) {
#line 494 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		switch (0) {
#line 3946 "book.c"
			default:
			{
				GFile* _tmp8_;
				gint _tmp9_;
#line 505 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp8_ = file;
#line 505 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp9_ = quality;
#line 505 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				book_save_pdf (self, _tmp8_, _tmp9_, &_inner_error_);
#line 505 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (_inner_error_ != NULL) {
#line 505 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 505 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					return;
#line 3963 "book.c"
				}
#line 506 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				break;
#line 3967 "book.c"
			}
		}
	}
}


void book_set_needs_saving (Book* self, gboolean needs_saving) {
	gboolean _tmp0_;
	gboolean needed_saving;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
#line 510 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (self != NULL);
#line 512 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = self->priv->needs_saving;
#line 512 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	needed_saving = _tmp0_;
#line 513 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = needs_saving;
#line 513 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->priv->needs_saving = _tmp1_;
#line 514 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp2_ = needed_saving;
#line 514 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp3_ = needs_saving;
#line 514 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (_tmp2_ != _tmp3_) {
#line 515 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_signal_emit_by_name (self, "needs-saving-changed");
#line 3998 "book.c"
	}
}


gboolean book_get_needs_saving (Book* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 518 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 520 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = self->priv->needs_saving;
#line 520 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	result = _tmp0_;
#line 520 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return result;
#line 4014 "book.c"
}


static void g_cclosure_user_marshal_VOID__PAGE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__PAGE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__PAGE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (n_param_values == 2);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		data1 = closure->data;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		data2 = param_values->data[0].v_pointer;
#line 4033 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		data1 = param_values->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		data2 = closure->data;
#line 4039 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	callback = (GMarshalFunc_VOID__PAGE) (marshal_data ? marshal_data : cc->callback);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	callback (data1, value_get_page (param_values + 1), data2);
#line 4045 "book.c"
}


static void value_book_init (GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	value->data[0].v_pointer = NULL;
#line 4052 "book.c"
}


static void value_book_free_value (GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		book_unref (value->data[0].v_pointer);
#line 4061 "book.c"
	}
}


static void value_book_copy_value (const GValue* src_value, GValue* dest_value) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (src_value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		dest_value->data[0].v_pointer = book_ref (src_value->data[0].v_pointer);
#line 4071 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4075 "book.c"
	}
}


static gpointer value_book_peek_pointer (const GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return value->data[0].v_pointer;
#line 4083 "book.c"
}


static gchar* value_book_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (collect_values[0].v_pointer) {
#line 4090 "book.c"
		Book* object;
		object = collect_values[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		if (object->parent_instance.g_class == NULL) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4097 "book.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4101 "book.c"
		}
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = book_ref (object);
#line 4105 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4109 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return NULL;
#line 4113 "book.c"
}


static gchar* value_book_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Book** object_p;
	object_p = collect_values[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (!object_p) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4124 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (!value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		*object_p = NULL;
#line 4130 "book.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		*object_p = value->data[0].v_pointer;
#line 4134 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		*object_p = book_ref (value->data[0].v_pointer);
#line 4138 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return NULL;
#line 4142 "book.c"
}


GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecBook* spec;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BOOK), NULL);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return G_PARAM_SPEC (spec);
#line 4156 "book.c"
}


gpointer value_get_book (const GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK), NULL);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return value->data[0].v_pointer;
#line 4165 "book.c"
}


void value_set_book (GValue* value, gpointer v_object) {
	Book* old;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (v_object) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		book_ref (value->data[0].v_pointer);
#line 4185 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4189 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (old) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		book_unref (old);
#line 4195 "book.c"
	}
}


void value_take_book (GValue* value, gpointer v_object) {
	Book* old;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (v_object) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 4214 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4218 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (old) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		book_unref (old);
#line 4224 "book.c"
	}
}


static void book_class_init (BookClass * klass) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	book_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	BOOK_CLASS (klass)->finalize = book_finalize;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_type_class_add_private (klass, sizeof (BookPrivate));
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_new ("page_added", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__PAGE, G_TYPE_NONE, 1, TYPE_PAGE);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_new ("page_removed", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__PAGE, G_TYPE_NONE, 1, TYPE_PAGE);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_new ("reordered", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_new ("cleared", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_new ("needs_saving_changed", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_new ("saving", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
#line 4248 "book.c"
}


static void book_instance_init (Book * self) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->priv = BOOK_GET_PRIVATE (self);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->ref_count = 1;
#line 4257 "book.c"
}


static void book_finalize (Book* obj) {
	Book * self;
	GList* _tmp0_;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOK, Book);
#line 32 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 4268 "book.c"
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
#line 32 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		page_collection = _tmp0_;
#line 32 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
#line 4276 "book.c"
			Page* _tmp1_;
			Page* page = NULL;
#line 32 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			_tmp1_ = _page_ref0 ((Page*) page_it->data);
#line 32 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			page = _tmp1_;
#line 4283 "book.c"
			{
				Page* _tmp2_;
				guint _tmp3_ = 0U;
				Page* _tmp4_;
				guint _tmp5_ = 0U;
#line 34 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp2_ = page;
#line 34 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 34 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 35 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp4_ = page;
#line 35 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
#line 35 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 32 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_page_unref0 (page);
#line 4303 "book.c"
			}
		}
	}
#line 14 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	__g_list_free__page_unref0_0 (self->priv->pages);
#line 179 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_byte_array_unref0 (self->priv->jpeg_data);
#line 4311 "book.c"
}


GType book_get_type (void) {
	static volatile gsize book_type_id__volatile = 0;
	if (g_once_init_enter (&book_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_book_init, value_book_free_value, value_book_copy_value, value_book_peek_pointer, "p", value_book_collect_value, "p", value_book_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BookClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) book_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Book), 0, (GInstanceInitFunc) book_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType book_type_id;
		book_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Book", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&book_type_id__volatile, book_type_id);
	}
	return book_type_id__volatile;
}


gpointer book_ref (gpointer instance) {
	Book* self;
	self = instance;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_atomic_int_inc (&self->ref_count);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return instance;
#line 4336 "book.c"
}


void book_unref (gpointer instance) {
	Book* self;
	self = instance;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		BOOK_GET_CLASS (self)->finalize (self);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4349 "book.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 532 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return self ? g_object_ref (self) : NULL;
#line 4357 "book.c"
}


PDFWriter* pdf_writer_construct (GType object_type, GFileOutputStream* stream) {
	PDFWriter* self = NULL;
	GFileOutputStream* _tmp0_;
	GFileOutputStream* _tmp1_;
#line 530 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (stream != NULL, NULL);
#line 530 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self = (PDFWriter*) g_type_create_instance (object_type);
#line 532 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = stream;
#line 532 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 532 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_object_unref0 (self->priv->stream);
#line 532 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->priv->stream = _tmp1_;
#line 530 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return self;
#line 4379 "book.c"
}


PDFWriter* pdf_writer_new (GFileOutputStream* stream) {
#line 530 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return pdf_writer_construct (TYPE_PDF_WRITER, stream);
#line 4386 "book.c"
}


void pdf_writer_write (PDFWriter* self, guint8* data, int data_length1) {
	gsize _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	GError * _inner_error_ = NULL;
#line 535 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (self != NULL);
#line 4397 "book.c"
	{
		GFileOutputStream* _tmp0_;
		guint8* _tmp1_;
		gint _tmp1__length1;
#line 539 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp0_ = self->priv->stream;
#line 539 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp1_ = data;
#line 539 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp1__length1 = data_length1;
#line 539 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_output_stream_write_all ((GOutputStream*) _tmp0_, _tmp1_, (gsize) _tmp1__length1, NULL, NULL, &_inner_error_);
#line 539 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		if (_inner_error_ != NULL) {
#line 4412 "book.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 537 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		e = _inner_error_;
#line 537 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_inner_error_ = NULL;
#line 543 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp2_ = e;
#line 543 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp3_ = _tmp2_->message;
#line 543 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_warning ("book.vala:543: Error writing PDF: %s", _tmp3_);
#line 537 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_g_error_free0 (e);
#line 4434 "book.c"
	}
	__finally1:
#line 537 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (_inner_error_ != NULL) {
#line 537 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 537 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_clear_error (&_inner_error_);
#line 537 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		return;
#line 4445 "book.c"
	}
#line 545 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp4_ = self->offset;
#line 545 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp5_ = data;
#line 545 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp5__length1 = data_length1;
#line 545 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->offset = _tmp4_ + _tmp5__length1;
#line 4455 "book.c"
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gint _tmp7__length1;
#line 1267 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1268 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1268 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1268 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
#line 1268 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1268 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_result__length1 = _tmp1_ + 1;
#line 1268 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	__result__size_ = _result__length1;
#line 1269 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = _result__length1;
#line 1269 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_result__length1 = _tmp3_ - 1;
#line 1270 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp4_ = _result_;
#line 1270 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp4__length1 = _result__length1;
#line 1270 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp5_ = strlen (self);
#line 1270 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp6_ = _tmp5_;
#line 1270 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	memcpy (_tmp4_, self, (gsize) _tmp6_);
#line 1271 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp7_ = _result_;
#line 1271 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp7__length1 = _result__length1;
#line 1271 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1271 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		*result_length1 = _tmp7__length1;
#line 4510 "book.c"
	}
#line 1271 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1271 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 4516 "book.c"
}


void pdf_writer_write_string (PDFWriter* self, const gchar* text) {
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	guint8* _tmp3_;
	gint _tmp3__length1;
#line 548 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (self != NULL);
#line 548 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (text != NULL);
#line 550 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = text;
#line 550 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp2_ = string_to_utf8 (_tmp0_, &_tmp1_);
#line 550 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp3_ = (guint8*) _tmp2_;
#line 550 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp3__length1 = (_tmp1_ * sizeof (gchar)) / sizeof (guint8);
#line 550 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write (self, _tmp3_, (_tmp1_ * sizeof (gchar)) / sizeof (guint8));
#line 550 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp3_ = (g_free (_tmp3_), NULL);
#line 4542 "book.c"
}


guint pdf_writer_start_object (PDFWriter* self) {
	guint result = 0U;
	gsize _tmp0_;
	GList* _tmp1_;
	guint _tmp2_ = 0U;
#line 553 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 555 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = self->offset;
#line 555 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->object_offsets = g_list_append (self->object_offsets, (gpointer) ((guintptr) ((guint) _tmp0_)));
#line 556 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = self->object_offsets;
#line 556 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp2_ = g_list_length (_tmp1_);
#line 556 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	result = _tmp2_;
#line 556 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return result;
#line 4565 "book.c"
}


static void value_pdf_writer_init (GValue* value) {
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	value->data[0].v_pointer = NULL;
#line 4572 "book.c"
}


static void value_pdf_writer_free_value (GValue* value) {
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (value->data[0].v_pointer) {
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		pdf_writer_unref (value->data[0].v_pointer);
#line 4581 "book.c"
	}
}


static void value_pdf_writer_copy_value (const GValue* src_value, GValue* dest_value) {
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (src_value->data[0].v_pointer) {
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		dest_value->data[0].v_pointer = pdf_writer_ref (src_value->data[0].v_pointer);
#line 4591 "book.c"
	} else {
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4595 "book.c"
	}
}


static gpointer value_pdf_writer_peek_pointer (const GValue* value) {
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return value->data[0].v_pointer;
#line 4603 "book.c"
}


static gchar* value_pdf_writer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (collect_values[0].v_pointer) {
#line 4610 "book.c"
		PDFWriter* object;
		object = collect_values[0].v_pointer;
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		if (object->parent_instance.g_class == NULL) {
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4617 "book.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4621 "book.c"
		}
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = pdf_writer_ref (object);
#line 4625 "book.c"
	} else {
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4629 "book.c"
	}
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return NULL;
#line 4633 "book.c"
}


static gchar* value_pdf_writer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PDFWriter** object_p;
	object_p = collect_values[0].v_pointer;
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (!object_p) {
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4644 "book.c"
	}
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (!value->data[0].v_pointer) {
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		*object_p = NULL;
#line 4650 "book.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		*object_p = value->data[0].v_pointer;
#line 4654 "book.c"
	} else {
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		*object_p = pdf_writer_ref (value->data[0].v_pointer);
#line 4658 "book.c"
	}
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return NULL;
#line 4662 "book.c"
}


GParamSpec* param_spec_pdf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPDFWriter* spec;
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PDF_WRITER), NULL);
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return G_PARAM_SPEC (spec);
#line 4676 "book.c"
}


gpointer value_get_pdf_writer (const GValue* value) {
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER), NULL);
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return value->data[0].v_pointer;
#line 4685 "book.c"
}


void value_set_pdf_writer (GValue* value, gpointer v_object) {
	PDFWriter* old;
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER));
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	old = value->data[0].v_pointer;
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (v_object) {
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PDF_WRITER));
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		pdf_writer_ref (value->data[0].v_pointer);
#line 4705 "book.c"
	} else {
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4709 "book.c"
	}
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (old) {
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		pdf_writer_unref (old);
#line 4715 "book.c"
	}
}


void value_take_pdf_writer (GValue* value, gpointer v_object) {
	PDFWriter* old;
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER));
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	old = value->data[0].v_pointer;
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (v_object) {
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PDF_WRITER));
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 4734 "book.c"
	} else {
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4738 "book.c"
	}
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (old) {
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		pdf_writer_unref (old);
#line 4744 "book.c"
	}
}


static void pdf_writer_class_init (PDFWriterClass * klass) {
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_parent_class = g_type_class_peek_parent (klass);
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	PDF_WRITER_CLASS (klass)->finalize = pdf_writer_finalize;
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_type_class_add_private (klass, sizeof (PDFWriterPrivate));
#line 4756 "book.c"
}


static void pdf_writer_instance_init (PDFWriter * self) {
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->priv = PDF_WRITER_GET_PRIVATE (self);
#line 526 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->offset = (gsize) 0;
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->ref_count = 1;
#line 4767 "book.c"
}


static void pdf_writer_finalize (PDFWriter* obj) {
	PDFWriter * self;
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PDF_WRITER, PDFWriter);
#line 527 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_list_free0 (self->object_offsets);
#line 528 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_object_unref0 (self->priv->stream);
#line 4779 "book.c"
}


GType pdf_writer_get_type (void) {
	static volatile gsize pdf_writer_type_id__volatile = 0;
	if (g_once_init_enter (&pdf_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pdf_writer_init, value_pdf_writer_free_value, value_pdf_writer_copy_value, value_pdf_writer_peek_pointer, "p", value_pdf_writer_collect_value, "p", value_pdf_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PDFWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pdf_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PDFWriter), 0, (GInstanceInitFunc) pdf_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pdf_writer_type_id;
		pdf_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PDFWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&pdf_writer_type_id__volatile, pdf_writer_type_id);
	}
	return pdf_writer_type_id__volatile;
}


gpointer pdf_writer_ref (gpointer instance) {
	PDFWriter* self;
	self = instance;
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_atomic_int_inc (&self->ref_count);
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return instance;
#line 4804 "book.c"
}


void pdf_writer_unref (gpointer instance) {
	PDFWriter* self;
	self = instance;
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		PDF_WRITER_GET_CLASS (self)->finalize (self);
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4817 "book.c"
	}
}


static cairo_status_t _ps_writer_write_cairo_data_cairo_write_func_t (gpointer self, guchar* data, int data_length1) {
	cairo_status_t result;
	result = ps_writer_write_cairo_data (self, data, data_length1);
#line 568 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return result;
#line 4827 "book.c"
}


PsWriter* ps_writer_construct (GType object_type, GFileOutputStream* stream) {
	PsWriter* self = NULL;
	GFileOutputStream* _tmp0_;
	GFileOutputStream* _tmp1_;
	cairo_surface_t* _tmp2_;
#line 565 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (stream != NULL, NULL);
#line 565 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self = (PsWriter*) g_type_create_instance (object_type);
#line 567 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = stream;
#line 567 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 567 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_object_unref0 (self->stream);
#line 567 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->stream = _tmp1_;
#line 568 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp2_ = cairo_ps_surface_create_for_stream (_ps_writer_write_cairo_data_cairo_write_func_t, self, (gdouble) 0, (gdouble) 0);
#line 568 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_cairo_surface_destroy0 (self->surface);
#line 568 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->surface = _tmp2_;
#line 565 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return self;
#line 4856 "book.c"
}


PsWriter* ps_writer_new (GFileOutputStream* stream) {
#line 565 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return ps_writer_construct (TYPE_PS_WRITER, stream);
#line 4863 "book.c"
}


static cairo_status_t ps_writer_write_cairo_data (PsWriter* self, guint8* data, int data_length1) {
	cairo_status_t result = 0;
	GError * _inner_error_ = NULL;
#line 571 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 4872 "book.c"
	{
		GFileOutputStream* _tmp0_;
		guint8* _tmp1_;
		gint _tmp1__length1;
#line 575 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp0_ = self->stream;
#line 575 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp1_ = data;
#line 575 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp1__length1 = data_length1;
#line 575 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_output_stream_write_all ((GOutputStream*) _tmp0_, _tmp1_, (gsize) _tmp1__length1, NULL, NULL, &_inner_error_);
#line 575 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		if (_inner_error_ != NULL) {
#line 4887 "book.c"
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 573 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		e = _inner_error_;
#line 573 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_inner_error_ = NULL;
#line 579 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp2_ = e;
#line 579 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp3_ = _tmp2_->message;
#line 579 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_warning ("book.vala:579: Error writing data: %s", _tmp3_);
#line 580 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		result = CAIRO_STATUS_WRITE_ERROR;
#line 580 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_g_error_free0 (e);
#line 580 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		return result;
#line 4913 "book.c"
	}
	__finally2:
#line 573 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (_inner_error_ != NULL) {
#line 573 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 573 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_clear_error (&_inner_error_);
#line 573 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		return 0;
#line 4924 "book.c"
	}
#line 583 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	result = CAIRO_STATUS_SUCCESS;
#line 583 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return result;
#line 4930 "book.c"
}


static void value_ps_writer_init (GValue* value) {
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	value->data[0].v_pointer = NULL;
#line 4937 "book.c"
}


static void value_ps_writer_free_value (GValue* value) {
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (value->data[0].v_pointer) {
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		ps_writer_unref (value->data[0].v_pointer);
#line 4946 "book.c"
	}
}


static void value_ps_writer_copy_value (const GValue* src_value, GValue* dest_value) {
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (src_value->data[0].v_pointer) {
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		dest_value->data[0].v_pointer = ps_writer_ref (src_value->data[0].v_pointer);
#line 4956 "book.c"
	} else {
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4960 "book.c"
	}
}


static gpointer value_ps_writer_peek_pointer (const GValue* value) {
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return value->data[0].v_pointer;
#line 4968 "book.c"
}


static gchar* value_ps_writer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (collect_values[0].v_pointer) {
#line 4975 "book.c"
		PsWriter* object;
		object = collect_values[0].v_pointer;
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		if (object->parent_instance.g_class == NULL) {
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4982 "book.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4986 "book.c"
		}
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = ps_writer_ref (object);
#line 4990 "book.c"
	} else {
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4994 "book.c"
	}
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return NULL;
#line 4998 "book.c"
}


static gchar* value_ps_writer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PsWriter** object_p;
	object_p = collect_values[0].v_pointer;
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (!object_p) {
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5009 "book.c"
	}
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (!value->data[0].v_pointer) {
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		*object_p = NULL;
#line 5015 "book.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		*object_p = value->data[0].v_pointer;
#line 5019 "book.c"
	} else {
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		*object_p = ps_writer_ref (value->data[0].v_pointer);
#line 5023 "book.c"
	}
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return NULL;
#line 5027 "book.c"
}


GParamSpec* param_spec_ps_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPsWriter* spec;
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PS_WRITER), NULL);
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return G_PARAM_SPEC (spec);
#line 5041 "book.c"
}


gpointer value_get_ps_writer (const GValue* value) {
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER), NULL);
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return value->data[0].v_pointer;
#line 5050 "book.c"
}


void value_set_ps_writer (GValue* value, gpointer v_object) {
	PsWriter* old;
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER));
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	old = value->data[0].v_pointer;
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (v_object) {
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PS_WRITER));
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		ps_writer_ref (value->data[0].v_pointer);
#line 5070 "book.c"
	} else {
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5074 "book.c"
	}
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (old) {
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		ps_writer_unref (old);
#line 5080 "book.c"
	}
}


void value_take_ps_writer (GValue* value, gpointer v_object) {
	PsWriter* old;
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER));
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	old = value->data[0].v_pointer;
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (v_object) {
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PS_WRITER));
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 5099 "book.c"
	} else {
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5103 "book.c"
	}
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (old) {
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		ps_writer_unref (old);
#line 5109 "book.c"
	}
}


static void ps_writer_class_init (PsWriterClass * klass) {
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	ps_writer_parent_class = g_type_class_peek_parent (klass);
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	PS_WRITER_CLASS (klass)->finalize = ps_writer_finalize;
#line 5119 "book.c"
}


static void ps_writer_instance_init (PsWriter * self) {
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->ref_count = 1;
#line 5126 "book.c"
}


static void ps_writer_finalize (PsWriter* obj) {
	PsWriter * self;
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PS_WRITER, PsWriter);
#line 562 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_cairo_surface_destroy0 (self->surface);
#line 563 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_object_unref0 (self->stream);
#line 5138 "book.c"
}


GType ps_writer_get_type (void) {
	static volatile gsize ps_writer_type_id__volatile = 0;
	if (g_once_init_enter (&ps_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_ps_writer_init, value_ps_writer_free_value, value_ps_writer_copy_value, value_ps_writer_peek_pointer, "p", value_ps_writer_collect_value, "p", value_ps_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PsWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ps_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PsWriter), 0, (GInstanceInitFunc) ps_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType ps_writer_type_id;
		ps_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PsWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&ps_writer_type_id__volatile, ps_writer_type_id);
	}
	return ps_writer_type_id__volatile;
}


gpointer ps_writer_ref (gpointer instance) {
	PsWriter* self;
	self = instance;
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_atomic_int_inc (&self->ref_count);
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return instance;
#line 5163 "book.c"
}


void ps_writer_unref (gpointer instance) {
	PsWriter* self;
	self = instance;
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		PS_WRITER_GET_CLASS (self)->finalize (self);
#line 560 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 5176 "book.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



