/*
 *  Copyright (C) 2003 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef SCREEM_DROPDOWN_ACTION_H
#define SCREEM_DROPDOWN_ACTION_H

#include <gtk/gtkaction.h>

#include "screem-window.h"

#define SCREEM_TYPE_DROPDOWN_ACTION            (screem_dropdown_action_get_type ())
#define SCREEM_DROPDOWN_ACTION(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCREEM_TYPE_DROPDOWN_ACTION, ScreemDropdownAction))
#define SCREEM_DROPDOWN_ACTION_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), SCREEM_TYPE_DROPDOWN_ACTION, ScreemDropdownActionClass))
#define SCREEM_IS_DROPDOWN_ACTION(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCREEM_TYPE_DROPDOWN_ACTION))
#define SCREEM_IS_DROPDOWN_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((obj), SCREEM_TYPE_DROPDOWN_ACTION))
#define SCREEM_DROPDOWN_ACTION_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), SCREEM_TYPE_DROPDOWN_ACTION, ScreemDropdownActionClass))

typedef struct _ScreemDropdownAction		ScreemDropdownAction;
typedef struct _ScreemDropdownActionClass	ScreemDropdownActionClass;
typedef struct _ScreemDropdownActionPrivate	ScreemDropdownActionPrivate;

typedef struct {
	const gchar *name;
	const gchar *stock_id;
	const gchar *label;
	const gchar *accelerator;
	const gchar *tooltip;
	GCallback    callback;
	const gchar *arrow_tooltip;
	const gchar *menu_path;
} ScreemDropdownActionEntry;

struct _ScreemDropdownAction
{
	GtkAction parent;
	
	/*< private >*/
	ScreemDropdownActionPrivate *priv;
};

struct _ScreemDropdownActionClass
{
	GtkActionClass parent_class;
};

GType screem_dropdown_action_get_type( void );
ScreemDropdownAction *screem_dropdown_action_new( const gchar *name,
		const gchar *label, const gchar *tooltip,
		const gchar *stock_id,
		const gchar *arrow_tooltip,
		const gchar *menu_path,
		ScreemWindow *window );
		
#endif


