#ifndef SCREEM_LINK_VIEW_H
#define SCREEM_LINK_VIEW_H

#include <gconf/gconf-client.h>

#include <libgnomecanvas/gnome-canvas.h>

#include "screem-view.h"

#define SCREEM_TYPE_LINK_VIEW  (screem_link_view_get_type())
#define SCREEM_LINK_VIEW(obj)  (G_TYPE_CHECK_INSTANCE_CAST( ( obj ), SCREEM_TYPE_LINK_VIEW, \
                                                ScreemLinkView ) )
#define SCREEM_LINK_VIEW_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST( ( klass ), \
                                                             SCREEM_TYPE_LINK_VIEW, \
                                                             ScreemLinkViewClass ) )
#define SCREEM_IS_LINK_VIEW(obj)  (G_TYPE_CHECK_INSTANCE_TYPE( ( obj ), SCREEM_TYPE_LINK_VIEW ) )

#ifndef SCREEM_WINDOW_DEFINED
#define SCREEM_WINDOW_DEFINED
typedef struct ScreemWindow ScreemWindow;
#endif

typedef struct ScreemLinkViewPrivate ScreemLinkViewPrivate;

typedef struct {
	ScreemView parent;

	ScreemLinkViewPrivate *private;
} ScreemLinkView;

typedef struct {
	ScreemViewClass parent_class;

} ScreemLinkViewClass;

GType screem_link_view_get_type( void );
ScreemLinkView *screem_link_view_new( ScreemWindow *window );

#endif
