#ifndef SCREEM_SITE_VIEW_H
#define SCREEM_SITE_VIEW_H

#include <config.h>

#include <gtk/gtktreestore.h>
#include <gtk/gtktreemodelsort.h>
#include <gtk/gtkliststore.h>
#include <gtk/gtkwindow.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "screem-site.h"

#include "screem-file-browser.h"

typedef enum {
        SCREEM_SITE_VIEW_FOLDER,
        SCREEM_SITE_VIEW_FILE
} ScreemSiteViewNodeType;


typedef struct {
	GtkTreeIter  *images;
	GtkTreeIter  *styles;
	GtkTreeIter  *scripts;

	ScreemFileBrowser *browser;
} ScreemSiteView;

typedef struct {
        gchar *fullname;
        ScreemSite *site;
	ScreemSiteViewNodeType type;
	gpointer monitor_handle;

	ScreemSiteView *view;
} ScreemSiteViewNodeInfo;


struct ScreemSitePrivate{
	GObject *application;

	ScreemSiteView *view;

     	gchar *name;
	gchar *pathname;
	gchar *remote_url;
	UploadMethods remote_method;
	gchar *remote_path;
	gchar *remote_user;
	gchar *remote_pass;
	gboolean passive_ftp;	/* sitecopy : use passive ftp  */
	gboolean no_delete;	/* sitecopy : delete remote files */
	gboolean check_moved;	/* sitecopy : check moved files */
	gboolean no_overwrite;	/* sitecopy : overwrite remote files */
	ScreemSitePerms permissions;	/* sitecopy : permissions handling */
	ScreemSiteSymlinks symlinks;	/* sitecopy : symlinks handling */
	gchar *http_url;
	gchar *cvs_root;
	gchar *site_template_path;
	gchar *template_path;

	GList *pages;

	/* the site todo object */
	GObject *tasks;

	/* a hash table of open documents in this site, keyed
	 * by the window they are in */
	GHashTable *documents;

	gboolean is_import;  /* flag to signify if we are importing a
				non screem site */

	gboolean fake_site;  /* indicates if we are just a bunch of random
				open pages rather than a screem site */

	GList *auto_open;    /* list of files to be auto opened */

	gboolean auto_update; /* auto update from CVS upon opening the site */
	gboolean auto_update_ask;

	/* if we should preview from publish address for static and
	   dynamic pages */
	gboolean preview_static;
	gboolean preview_dynamic;


	GtkListStore *excludes;
	GtkListStore *ignores;
	GtkListStore *asciis;

	/* if ctags should be used or not */
	gboolean ctags;
};

void screem_site_view_destroy( ScreemSite *site );

gint screem_site_view_compare_func( GtkTreeModel *model, 
				    GtkTreeIter *a, GtkTreeIter *b,
				    ScreemSite *site );

ScreemSiteViewNodeInfo* 
screem_site_view_node_info_new( ScreemSiteViewNodeType type, ScreemSite *site,
                                gpointer data, struct stat *s );

void screem_site_view_set_val_at( GtkTreeStore *store, GtkTreeIter *iter,
				  ScreemSiteViewNodeInfo *info );


void screem_site_view_set_model( ScreemSite *site );
void screem_site_init_tree_view( GtkWidget *view );

GtkTreeModel *screem_site_get_model( ScreemSite *site );

gboolean screem_site_view_create_dir( ScreemSite *site, GtkWidget *widget,
				      const gchar *dir );

void screem_site_view_show_properties( ScreemSite *site,
					const gchar *uri,
				       GtkWindow *window );

GtkTreeModel *screem_site_get_statistics( ScreemSite *site );

void screem_site_view_update( ScreemSite *site );

void screem_site_view_removed( ScreemFileBrowser *browser, const gchar *uri,
			       GtkTreeIter *it,
			       gpointer data );
void screem_site_view_added( ScreemFileBrowser *browser, const gchar *uri,
			     const gchar *mime_type,
			     GtkTreeIter *it,
			     gpointer data );
void screem_site_view_icon_change( ScreemFileBrowser *browser, const gchar *uri,
				     const gchar *mime_type,
				     GtkTreeIter *it,
				     gpointer data );

#endif
