.TH "sane\-pixma" "5" "28 Feb 2009" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane\-pixma
.SH NAME
sane\-pixma \- SANE backend for Canon PIXMA MP series
.SH DESCRIPTION
The
.B sane\-pixma
library implements a SANE (Scanner Access Now Easy) backend that provides
access to Canon PIXMA multi-function devices (All-in-one printers).
The backend implements both USB interface and Network LAN interface
using Canon's BJNP protocol.
Currently, the following models work with this backend:
.PP
.RS
PIXMA MP140, MP150, MP160, MP170, MP180, MP190
.br
PIXMA MP210, MP220, MP240
.br
PIXMA MP450, MP460, MP470, MP480
.br
PIXMA MP500, MP510, MP520, MP530, MP540
.br
PIXMA MP600, MP600R, MP610, MP620, MP630, MP710
.br
PIXMA MP800, MP800R, MP810, MP830, MP960, MP970, MP980
.br
PIXMA MX300, MX310, MX700, MX850, MX7600
.br
MultiPASS MP700, PIXMA MP750 (no grayscale)
.br
ImageCLASS MF4010, MF4018, MF4120, MF4122, MF4140, MF4150
.br
ImageCLASS MF4270
.RE
.PP
The following models are not well tested and/or the scanner sometimes hangs
and must be switched off and on.
.PP
.RS
SmartBase MP360, MP370, MP390
.br
MultiPASS MP730, PIXMA MP760, PIXMA MP780
.RE
.PP
The following models may use the same Pixma protocol as those listed 
above, but have not yet been reported to work (or not). They are declared 
in the backend so that they get recognized and activated. 
Feedback in the Sane-dev mailing list welcome.
.PP
.RS
PIXMA MP740
.br
PIXMA MP260
.br
ImageCLASS MF3110, MF3240
.br
ImageCLASS MF5630, MF5650, MF5730, MF5750, MF5770, MF8170c
.RE
.PP
\#The following models may use partly the same Pixma protocol as MPs listed
\#above, but may still need some work. They are declared in the backend as 
\#experimental. Snoop logs are required to further investigate, please contact 
\#the sane\-devel mailing list.
.PP
.RS
\#PIXMA MX850
.RE
.PP
The backend supports
.br
* resolutions at 75,150,300,600,1200,2400 and 4800 DPI (some maybe buggy),
.br
* color and grayscale mode,
.br
* a custom gamma table,
.br
* Automatic Document Feeder (Duplex for some models).
.br
* Transparency Unit, 24 or 48 bits depth.
.PP
The device name is in the form pixma:xxxxyyyy_zzzzz
where x, y and z are vendor ID, product ID and serial number respectively.
Example: pixma:04A91709_123456 is a MP150.
.PP
This backend, based on cloning original Canon drivers protocols, is in 
a production stage. Designed has been carried out without any applicable
manufacturer documentation, probably never available. However, we have tested 
it as well as we could, but it may not work in every situations. You will find 
an up-to-date status at the project homepage. (See below). 
Users feedback is essential to help improve features and performances. 
.SH OPTIONS
Besides "well-known" options (e.g. resolution, mode etc.) pixma backend also
provides the following
\#.B experimental
options for button handling, i.e. the options might change in the future.
.br
Button scan is disabled on MAC OS X due to darwin libusb not handling
timeouts in usb interrupt reads. 
.TP
.I button\-controlled
This option can be used in combination with
.BR scanadf (1)
and
.BR scanimage (1)
in batch mode, for example when you want to scan many photos or
multiple-page documents. If it is enabled (i.e. is set to true or yes), the
backend waits before every scan until the user presses the "SCAN" button
(for MP150) or the color-scan button (for other models). Just put the
first page in the scanner, press the button, then the next page, press
the button and so on. When you finished, press the gray-scan button. (For
MP150 you have to stop the frontend by pressing Ctrl-C for example.)
.TP
.I button\-update button\-1 button\-2
These options are interesting for developers. To check button status: (1) set
.I button\-1
and
.I button\-2
to zero, (2) set
.I button-update
(Its type is SANE_TYPE_BUTTON.), (3) get
.I button\-1
and
.IR button\-2 .
If the result is not zero, the corresponding button was pressed.
.SH FILES
.TP
.I @LIBDIR@/libsane\-pixma.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane\-pixma.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.SH ENVIRONMENT
.TP
.B SANE_DEBUG_PIXMA
If the library was compiled with debug support enabled, this environment
variable controls the debug level for this backend. Higher value increases
the verbosity.
.PP
.RS
0  print nothing (default)
.br
1  print error and warning messages (recommended)
.br
2  print informational messages
.br
3  print debug-level messages
.br
11 dump USB traffics
.br
21 full dump USB traffics
.br
.RE
.TP
.B PIXMA_EXPERIMENT
Setting to a non-zero value will enable the support for experimental models.
You should also set SANE_DEBUG_PIXMA to 10.
.SH "SEE ALSO"
.BR sane (7),
.BR sane\-dll (5),
.I http://home.arcor.de/wittawat/pixma/,
.I http://mp610.blogspot.com/
.SH AUTHORS
Wittawat Yamwong, Nicolas Martin, Dennis Lou, Louis Lagendijk
.PP
We would like to thank all testers and helpers. Without them we could not be
able to write subdrivers for models we don't have. See also the project
homepage.
