.TH "sane-pixma" "5" "09 April 2007" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane-pixma
.SH NAME
sane-pixma \- SANE backend for Canon PIXMA MP series
.SH DESCRIPTION
The
.B sane-pixma
library implements a SANE (Scanner Access Now Easy) backend that provides
access to Canon PIXMA multi-function devices (All-in-one printers).
Currently, the following models work with this backend:
.PP
.RS
PIXMA MP150, PIXMA MP170, PIXMA MP450, PIXMA MP500
.br
PIXMA MP530, PIXMA MP800, PIXMA MP800R, PIXMA MP830,
.br
MultiPASS MP700, PIXMA MP750 (no grayscale)
.RE
.PP
The following models are not well tested and/or the scanner sometimes hangs
and must be switched off and on.
.PP
.RS
PIXMA MP160, PIXMA MP180, PIXMA MP460, PIXMA MP510, PIXMA MP600
.br
SmartBase MP360, MultiPASS MP730, PIXMA MP760, PIXMA MP780
.RE
.PP
The backend supports
.br
* resolutions at 75,150,300,600,1200 and 2400 DPI,
.br
* color and grayscale mode,
.br
* a custom gamma table with 4096 entries and
.br
* automatic document feeder.
.PP
The device name is in the form pixma:xxxxyyyy_zzzzz
where x, y and z are vendor ID, product ID and serial number respectively.
Example: pixma:04A91709_123456 is a MP150.
.PP
This backend is in
.B alpha
stage and will stay in this stage until we get the programming manual
for the hardware. Although we have tested it as good as we could, it will
not work in every situations. You will find an up-to-date status at the
project homepage. (See below)
.SH OPTIONS
Besides "well-known" options (e.g. resolution, mode etc.) pixma backend also
provides the following
.B experimental
options for button handling, i.e. the options might change in the future.
.TP
.I button-controlled
This option can be used in combination with
.BR scanadf (1)
and
.BR scanimage (1)
in batch mode, for example when you want to scan many photos or
multiple-page documents. If it is enabled (i.e. is set to true or yes), the
backend waits before every scan until the user presses the "SCAN" button
(for MP150) or the color-scan button (for other models). Just put the
first page in the scanner, press the button, then the next page, press
the button and so on. When you finished, press the gray-scan button. (For
MP150 you have to stop the frontend by pressing Ctrl-C for example.)
.TP
.I button-update button-1 button-2
These options are interesting for developers. To check button status: (1) set
.I button-1
and
.I button-2
to zero, (2) set
.I button-update
(Its type is SANE_TYPE_BUTTON.), (3) get
.I button-1
and
.IR button-2 .
If the result is not zero, the corresponding button was pressed.
.SH FILES
.TP
.I @LIBDIR@/libsane-pixma.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane-pixma.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.SH ENVIRONMENT
.TP
.B SANE_DEBUG_PIXMA
If the library was compiled with debug support enabled, this environment
variable controls the debug level for this backend. Higher value increases
the verbosity.
.PP
.RS
0  print nothing (default)
.br
1  print error and warning messages (recommended)
.br
2  print informational messages
.br
3  print debug-level messages
.br
10 dump USB traffics
.br
.RE
.TP
.B PIXMA_EXPERIMENT
Setting to a non-zero value will enable the support for experimental models.
You should also set SANE_DEBUG_PIXMA to 10.
.SH "SEE ALSO"
.BR sane (7),
.BR sane-dll (5),
.I http://home.arcor.de/wittawat/pixma/
.SH AUTHOR
Wittawat Yamwong
.PP
I would like to thank all testers and helpers. Without them I would not be
able to write subdrivers for models I don't have. See also the project
homepage.
