/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This source file is part of SableVM.                            *
 *                                                                 *
 * See the file "LICENSE" for the copyright information and for    *
 * the terms and conditions for copying, distribution and          *
 * modification of this source file.                               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/*
----------------------------------------------------------------------
Java_java_lang_VMSecurityManager_getClassContext
----------------------------------------------------------------------
*/



/*
 * Class:     java_lang_VMSecurityManager
 * Method:    getClassContext
 * Signature: ()[Ljava/lang/Class;
 */
JNIEXPORT static jobjectArray JNICALL
Java_java_lang_VMSecurityManager_getClassContext (JNIEnv *_env, jclass class)
{
  _svmt_JNIEnv *env = _svmf_cast_svmt_JNIEnv (_env);
  jobjectArray class_array = NULL;

  _svmf_resuming_java (env);

  {
    _svmt_JavaVM *vm = env->vm;
    _svmt_stack_frame *frame;
    _svmt_method_info *method;
    jint count;

    jboolean monitor_acquired = JNI_FALSE;

    if (_svmf_enter_object_monitor
	(env,
	 *(vm->class_loading.boot_loader.classes.virtualmachine->
	   class_instance)) != JNI_OK)
      {
	goto end;
      }

    monitor_acquired = JNI_TRUE;


    /* compute array size */

    /* trace stack */
    count = 0;
    frame = env->stack.current_frame;
    method = frame->method;

    while (method != &vm->stack_bottom_method)
      {

	if (!(_svmf_is_set_flag (method->access_flags, SVM_ACC_INTERNAL) ||
	      (((strcmp (method->class_info->name,
			 "java/lang/VMSecurityManager") == 0) ||
		(strcmp (method->class_info->name,
			 "java/lang/SecurityManager") == 0)) &&
	       (strcmp (DREF (method->name, value), "getClassContext") == 0)))
	    /* we do not check descriptor, should not be necessary */
	  )
	  {
	    count++;
	  }

	/* pop stack frame */
	frame = (_svmt_stack_frame *)
	  (((char *) frame) - frame->previous_offset);
	method = frame->method;
      }


    {
      _svmt_class_info *class_class_info;
      static _svmt_array_info *class_array_info = NULL;

      class_class_info = vm->class_loading.boot_loader.classes.jlclass;

      /* create Class[] array type */
      if (class_array_info == NULL)
	{
	  if (_svmm_create_array
	      (env,
	       class_class_info->class_loader_info,
	       class_class_info->array_type_name, class_array_info) != JNI_OK)
	    {
	      goto end;
	    }
	  /* link the type Class[] */
	  if (_svmf_link_array (env, class_array_info) != JNI_OK)
	    {
	      goto end;
	    }
	}

      class_array = _svmf_get_jni_frame_native_local_array (env);
      if (_svmm_new_array_instance
	  (env, class_array_info, count, *class_array) != JNI_OK)
	{
	  class_array = NULL;
	  goto end;
	}

      /* fill in the array */
      {
	jint array_index = 0;
	frame = env->stack.current_frame;
	method = frame->method;
	while (method != &env->vm->stack_bottom_method)
	  {

	    if (!
		(_svmf_is_set_flag (method->access_flags, SVM_ACC_INTERNAL)
		 ||
		 (((strcmp
		    (method->class_info->name,
		     "java/lang/VMSecurityManager") == 0)
		   ||
		   (strcmp
		    (method->class_info->name,
		     "java/lang/SecurityManager") == 0))
		  && (strcmp (DREF (method->name, value), "getClassContext")
		      == 0)))
/* we do not check descriptor, should not be necessary */
	      )
	      {

		/* add Class of method to array. */

		if (_svmf_set_reference_array_element_no_exception
		    (env, *class_array, array_index++,
		     *(method->class_info->class_instance)) != JNI_OK)
		  {
		    class_array = NULL;
		    goto end;
		  }
	      }

	    /* pop stack frame */
	    frame = (_svmt_stack_frame *)
	      (((char *) frame) - frame->previous_offset);
	    method = frame->method;
	  }
      }
    }

  end:
    if (monitor_acquired)
      {
	monitor_acquired = JNI_FALSE;

	if (_svmf_exit_object_monitor
	    (env,
	     *(vm->class_loading.boot_loader.classes.virtualmachine->
	       class_instance)) != JNI_OK)
	  {
	    goto end;
	  }
      }
  }

  _svmf_stopping_java (env);

  return class_array;

}


/*
----------------------------------------------------------------------
Java_java_lang_VMSecurityManager_currentClassLoader
----------------------------------------------------------------------
*/

/*
 * Class:     java_lang_VMSecurityManager
 * Method:    currentClassLoader
 * Signature: ()Ljava/lang/ClassLoader;
 */

JNIEXPORT static jobject JNICALL
Java_java_lang_VMSecurityManager_currentClassLoader (JNIEnv *_env,
						     jclass class)
{
  _svmt_JNIEnv *env = _svmf_cast_svmt_JNIEnv (_env);
  jobject class_loader = NULL;

  _svmf_resuming_java (env);

  {
    _svmt_class_loader_info *class_loader_info =
      _svmf_get_current_class_loader (env);

    if (class_loader_info->class_loader != NULL)
      {
	class_loader = _svmf_get_jni_frame_native_local (env);
	*class_loader = *(class_loader_info->class_loader);
      }
  }

  _svmf_stopping_java (env);

  return class_loader;
}
