%% The contents of this file are subject to the Mozilla Public License
%% Version 1.1 (the "License"); you may not use this file except in
%% compliance with the License. You may obtain a copy of the License
%% at http://www.mozilla.org/MPL/
%%
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and
%% limitations under the License.
%%
%% The Original Code is RabbitMQ.
%%
%% The Initial Developer of the Original Code is VMware, Inc.
%% Copyright (c) 2007-2011 VMware, Inc.  All rights reserved.
%%

-module(rabbit_auth_mechanism).

-export([behaviour_info/1]).

behaviour_info(callbacks) ->
    [
     %% A description.
     {description, 0},

     %% Called before authentication starts. Should create a state
     %% object to be passed through all the stages of authentication.
     {init, 1},

     %% Handle a stage of authentication. Possible responses:
     %% {ok, User}
     %%     Authentication succeeded, and here's the user record.
     %% {challenge, Challenge, NextState}
     %%     Another round is needed. Here's the state I want next time.
     %% {protocol_error, Msg, Args}
     %%     Client got the protocol wrong. Log and die.
     %% {refused, Msg, Args}
     %%     Client failed authentication. Log and die.
     {handle_response, 2}
    ];
behaviour_info(_Other) ->
    undefined.
