/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QZion.
 *
 * QZion is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QZion is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QZion.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "main.h"

#include <iostream>
#include <math.h>
#include <QtGui>
#include <qzion.h>
#include <QTimer>
#include <QSize>

Scene::Scene(QZionAbstractCanvas *canvas)
    :group(new QZionGroup(canvas))
{
    group->setSize(QSize(400,400));
    img = new QZionImage(group, "../images/square.png");
    img->setPos(QPoint(20,20));
    img->setSize(QSize(30,30));
    img->setBorder(3,3,27,3);
    img->show();

    group->show();
    connect(&timer, SIGNAL(timeout()), this, SLOT(resize()));

    timer.start(5);

}
void Scene::resize()
{
    img->setSize(QSize(img->size().width()+3, img->size().height() + 3));
    img->changed();
    if (img->size().width() > 400)
        img->setSize(QSize(30, 30));
};

int main(int argc, char **argv)
{
    QApplication app(argc, argv);
    QZionCanvas canvas;
    QSize size(800, 480);

    canvas.setSize(size);
    canvas.show();
    QZionRectangle *bg = new QZionRectangle(&canvas);
    bg->setColor(QColor(0, 0, 150));
    bg->setSize(size);
    bg->show();

    Scene scene(&canvas);


    app.exec();

    return 0;
}
