/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QZion.
 *
 * QZion is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QZion is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QZion.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __QZIONTEXTBLOCK_P_H__
#define __QZIONTEXTBLOCK_P_H__

#include <QGraphicsItem>
#include <QAbstractGraphicsShapeItem>
#include <QWebPage>
#include <QWebFrame>

#include "qziontextblock.h"
#include "qzionrectangle.h"
#include "qzioncommon.h"

class QGraphicsQZionTextBlockItem : public QAbstractGraphicsShapeItem
{
public:
    QGraphicsQZionTextBlockItem(QGraphicsItem *parent = 0);

    QRectF boundingRect () const;
    virtual void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
                       QWidget *widget = 0);

    QString text() const;
    void setText(const QString &text);

    QSize size() const;
    void setSize(const QSize &size);

    double scale();
    void setScale(double factor);

    QWebPage *page() { return &_page; };

    int preferredWidth;

private:
    QWebPage _page;
    QString _text;
    QSize _size;
    double _scale;
};


class QZionTextBlockPrivate : public QGraphicsQZionTextBlockItem
{
public:
    QZionTextBlock *owner;

    QZionTextBlockPrivate(QGraphicsItem *parent = 0)
        : QGraphicsQZionTextBlockItem(parent) {};

    virtual inline void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
                       QWidget *widget = 0);

    QGV_EFFECTIVE_SHAPE(QGraphicsQZionTextBlockItem);
};

void QZionTextBlockPrivate::paint(QPainter *painter,
                                  const QStyleOptionGraphicsItem *option,
                                  QWidget *widget)
{
    int opacity = owner->effectiveColor().alpha();

    if (opacity >= 255) {
        QGraphicsQZionTextBlockItem::paint(painter, option, widget);
    } else {
        painter->setOpacity(opacity / (float) 255);
        QGraphicsQZionTextBlockItem::paint(painter, option, widget);
        painter->setOpacity(1.0);
    }
}

#endif
