/****************************************************************************
**
** Copyright (C) 2013 Digia Plc and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
**
** This file is part of the QtSql module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Digia.  For licensing terms and
** conditions see http://qt.digia.com/licensing.  For further information
** use the contact form at http://qt.digia.com/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Digia gives you certain additional
** rights.  These rights are described in the Digia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QSQLRESULT_P_H
#define QSQLRESULT_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of qsql*model.h .  This header file may change from version to version
// without notice, or even be removed.
//
// We mean it.
//

#include <QtCore/qpointer.h>
#include <QtSql/qsqldriver.h>
#include "qsqlerror.h"
#include "qsqlresult.h"

QT_BEGIN_NAMESPACE

struct QHolder {
    QHolder(const QString &hldr = QString(), int index = -1): holderName(hldr), holderPos(index) { }
    bool operator==(const QHolder &h) const { return h.holderPos == holderPos && h.holderName == holderName; }
    bool operator!=(const QHolder &h) const { return h.holderPos != holderPos || h.holderName != holderName; }
    QString holderName;
    int holderPos;
};

class Q_SQL_EXPORT QSqlResultPrivate
{
public:
    QSqlResultPrivate(QSqlResult *d)
      : q(d),
        idx(QSql::BeforeFirstRow),
        active(false),
        isSel(false),
        forwardOnly(false),
        precisionPolicy(QSql::LowPrecisionDouble),
        bindCount(0),
        binds(QSqlResult::PositionalBinding)
    { }

    void clearValues()
    {
        values.clear();
        bindCount = 0;
    }

    void resetBindCount()
    {
        bindCount = 0;
    }

    void clearIndex()
    {
        indexes.clear();
        holders.clear();
        types.clear();
    }

    void clear()
    {
        clearValues();
        clearIndex();;
    }

    // positionalToNamedBinding uses fieldSerial() by default, which converts to Oracle-style names,
    // because this style is used in the API. A driver can reuse positionalToNamedBinding()
    // internally for its own naming style by supplying its own fieldSerialFunc. We cannot make
    // fieldSerial() virtual because it would allow a driver to impose its naming style on
    // executedQuery when set by QSqlResult::savePrepare().
    static QString fieldSerial(int);
    static QString positionalToNamedBinding(const QString &query, QString (fieldSerialFunc)(int idx) = fieldSerial);
    QString namedToPositionalBinding(const QString &query);
    QString holderAt(int index) const;

    QSqlResult *q;
    QPointer<QSqlDriver> sqldriver;
    int idx;
    QString sql;
    bool active;
    bool isSel;
    QSqlError error;
    bool forwardOnly;
    QSql::NumericalPrecisionPolicy precisionPolicy;

    int bindCount;
    QSqlResult::BindingSyntax binds;

    QString executedQuery;
    QHash<int, QSql::ParamType> types;
    QVector<QVariant> values;
    typedef QHash<QString, QList<int> > IndexMap;
    IndexMap indexes;

    typedef QVector<QHolder> QHolderVector;
    QHolderVector holders;
};

QT_END_NAMESPACE

#endif // QSQLRESULT_P_H
