#!/usr/bin/python

import unittest
import subprocess

class TestParseVersions(unittest.TestCase):
    def get_output(self, control):
        subp = subprocess.Popen(["parseversions", "--pycentral", control],
                                stdout=subprocess.PIPE)
        output = subp.communicate()[0]
        if subp.returncode != 0:
            raise RuntimeError, subp.returncode
        return output

    def test_regular(self):
        self.assertEqual(self.get_output('testparseversions.regular.control'), '2.6 2.7\n')

    def test_leading_newline(self):
        self.assertEqual(self.get_output('testparseversions.leading-newline.control'), '2.6 2.7\n')

    def test_missing(self):
        self.assertRaises(RuntimeError, self.get_output, 'testparseversions.missing.control')

    def test_second_paragraph(self):
        self.assertRaises(RuntimeError, self.get_output, 'testparseversions.second-paragraph.control')

    def test_spaces(self):
        self.assertRaises(RuntimeError, self.get_output, 'testparseversions.spaces.control')

if __name__ == '__main__':
    unittest.main()
