#!/usr/bin/env python

import sqlite

# Aggregate Class
class variance:

    def __init__(self):
        self.X = []

    def step(self, x):
        if x: self.X.append(float(x))

    def reset(self):
        self.X = []

    def finalize(self):
        mu = 0
        n = len(self.X)

        for x in self.X:
            mu += x
        mu = float(mu)/n

        sigma = 0
        for x in self.X:
            sigma += (x-mu)**2

        sigma = sigma / (n - 1)

        return sigma

conn = sqlite.connect("db", 077)

# Add the aggregate
conn.create_aggregate("variance", 1, variance)

cursor = conn.cursor()

# Expect float value for column
cursor.execute('-- types float')

# Execute SQL with custom aggregate
cursor.execute("select variance(upper_elev_ft) from calflora")

# Fetch
row = cursor.fetchone()

# Print
print "Upper elevation variance: %.2f" % row[0]

conn.close()
