# $Progeny: setup.py,v 1.4 2002/09/17 19:08:15 branden Exp $

from distutils.core import setup, Extension

longdesc = """GNU Parted is a library for manipulating disk
partitions.  This module contains Python bindings for the library.
"""

pyparted = Extension("_partedmodule",
                     ["pyparted.c"],
                     libraries=["uuid", "parted"])

setup(name="python-parted", version="0.11",
      author="Progeny Linux Systems, Inc.", author_email="bugs@progeny.com",
      url="http://hackers.progeny.com/python-parted/",
      licence="GPL",
      description="Python bindings for GNU Parted",
      long_description=longdesc,
      keywords=["partitioning", "parted", "linux"],
      platforms="all",
      py_modules=["parted"],
      ext_modules=[pyparted,])

# vim: set ai et fo=tcroq sts=4 sw=4 tw=75:
