
#include <Python.h>
#include <stdio.h>
#include <math.h>
#include "libnumarray.h"

#ifdef MS_WIN32
#pragma warning(once : 4244)
#endif

#define logical_and(arg1, arg2) (arg1 != 0) & (arg2 != 0)
#define logical_or(arg1, arg2)  (arg1 != 0) | (arg2 != 0)
#define logical_xor(arg1, arg2) ((arg1 != 0) ^ (arg2 != 0)) & 1
#define ufmaximum(arg1, arg2) (((temp1=arg1) > (temp2=arg2)) ? temp1 : temp2)
#define ufminimum(arg1, arg2) (((temp1=arg1) < (temp2=arg2)) ? temp1 : temp2)

static PyObject *_Error;

/*********************  minus  *********************/

static int minus_Int16_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin = (Int16 *) buffers[0];
    Int16 *tout = (Int16 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = -*tin;
    }
    return 0;
}

UFUNC_DESCR2(minus_Int16_vector, sizeof(Int16), sizeof(Int16));
/*********************  add  *********************/

static int add_Int16_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16  *tin1  = (Int16 *) buffers[0];
    Int16  *tin2  = (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 + *tin2;
    }
    return 0;
}

UFUNC_DESCR3(add_Int16_vector_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int add_Int16_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin1     = (Int16 *) buffers[0];
    Int16 tscalar   = *(Int16 *) buffers[1];
    Int16 *tout    = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 + tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(add_Int16_vector_scalar, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int add_Int16_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 tscalar = *(Int16 *) buffers[0];
    Int16 *tin2   =  (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar + *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(add_Int16_scalar_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int add_Int16_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16 *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout = (Int16 *) ((char *) output + outboffset);
    Int16 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            tout = (Int16 *) ((char *) tout + outbstrides[dim]);
            *tout = lastval + *tin;
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            add_Int16_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(add_Int16_accumulate, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));

static int add_Int16_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16  *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout  = (Int16 *) ((char *) output + outboffset);
    Int16 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            net = net + *tin;
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            add_Int16_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(add_Int16_reduce, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));
/*********************  subtract  *********************/

static int subtract_Int16_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16  *tin1  = (Int16 *) buffers[0];
    Int16  *tin2  = (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 - *tin2;
    }
    return 0;
}

UFUNC_DESCR3(subtract_Int16_vector_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int subtract_Int16_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin1     = (Int16 *) buffers[0];
    Int16 tscalar   = *(Int16 *) buffers[1];
    Int16 *tout    = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 - tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(subtract_Int16_vector_scalar, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int subtract_Int16_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 tscalar = *(Int16 *) buffers[0];
    Int16 *tin2   =  (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar - *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(subtract_Int16_scalar_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int subtract_Int16_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16 *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout = (Int16 *) ((char *) output + outboffset);
    Int16 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            tout = (Int16 *) ((char *) tout + outbstrides[dim]);
            *tout = lastval - *tin;
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            subtract_Int16_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(subtract_Int16_accumulate, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));

static int subtract_Int16_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16  *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout  = (Int16 *) ((char *) output + outboffset);
    Int16 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            net = net - *tin;
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            subtract_Int16_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(subtract_Int16_reduce, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/

static int multiply_Int16_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16  *tin1  = (Int16 *) buffers[0];
    Int16  *tin2  = (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    Int32 temp;
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        temp = ((Int32) *tin1) * ((Int32) *tin2);
    if (temp > 32767) temp = int_overflow_error(32767.);
if (temp < -32768) temp = int_overflow_error(-32768);
    *tout = (Int16) temp;
    }
    return 0;
}

UFUNC_DESCR3(multiply_Int16_vector_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int multiply_Int16_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin1     = (Int16 *) buffers[0];
    Int16 tscalar   = *(Int16 *) buffers[1];
    Int16 *tout    = (Int16 *) buffers[2];
    Int32 temp;
    for (i=0; i<niter; i++, tin1++, tout++) {
        temp = ((Int32) *tin1) * ((Int32) tscalar);
    if (temp > 32767) temp = int_overflow_error(32767.);
if (temp < -32768) temp = int_overflow_error(-32768);
    *tout = (Int16) temp;
    }
    return 0;
}

UFUNC_DESCR3vs(multiply_Int16_vector_scalar, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int multiply_Int16_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 tscalar = *(Int16 *) buffers[0];
    Int16 *tin2   =  (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    Int32 temp;
    for (i=0; i<niter; i++, tin2++, tout++) {
        temp = ((Int32) tscalar) * ((Int32) *tin2);
    if (temp > 32767) temp = int_overflow_error(32767.);
if (temp < -32768) temp = int_overflow_error(-32768);
    *tout = (Int16) temp;
    }
    return 0;
}

UFUNC_DESCR3sv(multiply_Int16_scalar_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int multiply_Int16_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16 *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout = (Int16 *) ((char *) output + outboffset);
    Int16 lastval;
    Int32 temp;
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            tout = (Int16 *) ((char *) tout + outbstrides[dim]);
            temp = ((Int32) lastval) * ((Int32) *tin);
    if (temp > 32767) temp = int_overflow_error(32767.);
if (temp < -32768) temp = int_overflow_error(-32768);
    *tout = (Int16) temp;
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            multiply_Int16_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(multiply_Int16_accumulate, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));

static int multiply_Int16_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16  *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout  = (Int16 *) ((char *) output + outboffset);
    Int16 net;
    Int32 temp;
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            temp = ((Int32) net) * ((Int32) *tin);
    if (temp > 32767) temp = int_overflow_error(32767.);
if (temp < -32768) temp = int_overflow_error(-32768);
    net = (Int16) temp;
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            multiply_Int16_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(multiply_Int16_reduce, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  multiply  *********************/
/*********************  divide  *********************/

static int divide_Int16_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16  *tin1  = (Int16 *) buffers[0];
    Int16  *tin2  = (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = ((*tin2==0) ? int_dividebyzero_error(*tin2, *tin1) : *tin1 / *tin2);
    }
    return 0;
}

UFUNC_DESCR3(divide_Int16_vector_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int divide_Int16_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin1     = (Int16 *) buffers[0];
    Int16 tscalar   = *(Int16 *) buffers[1];
    Int16 *tout    = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = ((tscalar==0) ? int_dividebyzero_error(tscalar, *tin1) : *tin1 / tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(divide_Int16_vector_scalar, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int divide_Int16_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 tscalar = *(Int16 *) buffers[0];
    Int16 *tin2   =  (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = ((*tin2==0) ? int_dividebyzero_error(*tin2, 0) : tscalar / *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(divide_Int16_scalar_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int divide_Int16_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16 *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout = (Int16 *) ((char *) output + outboffset);
    Int16 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            tout = (Int16 *) ((char *) tout + outbstrides[dim]);
            *tout = ((*tin==0) ? int_dividebyzero_error(*tin, 0) : lastval / *tin);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            divide_Int16_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(divide_Int16_accumulate, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));

static int divide_Int16_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16  *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout  = (Int16 *) ((char *) output + outboffset);
    Int16 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            net = ((*tin==0) ? int_dividebyzero_error(*tin, 0) : net / *tin);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            divide_Int16_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(divide_Int16_reduce, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));
/*********************  divide  *********************/
/*********************  floor_divide  *********************/

static int floor_divide_Int16_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16  *tin1  = (Int16 *) buffers[0];
    Int16  *tin2  = (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = ((*tin2==0) ? int_dividebyzero_error(*tin2, *tin1) : floor(*tin1 / (double) *tin2));
    }
    return 0;
}

UFUNC_DESCR3(floor_divide_Int16_vector_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int floor_divide_Int16_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin1     = (Int16 *) buffers[0];
    Int16 tscalar   = *(Int16 *) buffers[1];
    Int16 *tout    = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = ((tscalar==0) ? int_dividebyzero_error(tscalar, *tin1) : floor(*tin1 / (double) tscalar));
    }
    return 0;
}

UFUNC_DESCR3vs(floor_divide_Int16_vector_scalar, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int floor_divide_Int16_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 tscalar = *(Int16 *) buffers[0];
    Int16 *tin2   =  (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = ((*tin2==0) ? int_dividebyzero_error(*tin2, 0) : floor(tscalar / (double) *tin2));
    }
    return 0;
}

UFUNC_DESCR3sv(floor_divide_Int16_scalar_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int floor_divide_Int16_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16 *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout = (Int16 *) ((char *) output + outboffset);
    Int16 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            tout = (Int16 *) ((char *) tout + outbstrides[dim]);
            *tout = ((*tin==0) ? int_dividebyzero_error(*tin, 0) : floor(lastval / (double) *tin));
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            floor_divide_Int16_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(floor_divide_Int16_accumulate, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));

static int floor_divide_Int16_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16  *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout  = (Int16 *) ((char *) output + outboffset);
    Int16 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            net = ((*tin==0) ? int_dividebyzero_error(*tin, 0) : floor(net / (double) *tin));
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            floor_divide_Int16_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(floor_divide_Int16_reduce, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));
/*********************  floor_divide  *********************/
/*********************  true_divide  *********************/

static int true_divide_Int16_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16  *tin1  = (Int16 *) buffers[0];
    Int16  *tin2  = (Int16 *) buffers[1];
    Float32 *tout  = (Float32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = ((*tin2==0) ? int_dividebyzero_error(*tin2, *tin1) : *tin1 / (double) *tin2);
    }
    return 0;
}

UFUNC_DESCR3(true_divide_Int16_vector_vector, sizeof(Int16), sizeof(Int16), sizeof(Float32));


static int true_divide_Int16_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin1     = (Int16 *) buffers[0];
    Int16 tscalar   = *(Int16 *) buffers[1];
    Float32 *tout    = (Float32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = ((tscalar==0) ? int_dividebyzero_error(tscalar, *tin1) : *tin1 / (double) tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(true_divide_Int16_vector_scalar, sizeof(Int16), sizeof(Int16), sizeof(Float32));


static int true_divide_Int16_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 tscalar = *(Int16 *) buffers[0];
    Int16 *tin2   =  (Int16 *) buffers[1];
    Float32 *tout  = (Float32 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = ((*tin2==0) ? int_dividebyzero_error(*tin2, 0) : tscalar / (double) *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(true_divide_Int16_scalar_vector, sizeof(Int16), sizeof(Int16), sizeof(Float32));

/*********************  true_divide  *********************/
/*********************  remainder  *********************/

static int remainder_Int16_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16  *tin1  = (Int16 *) buffers[0];
    Int16  *tin2  = (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = ((*tin2==0) ? int_dividebyzero_error(*tin2, *tin1) : *tin1  %  *tin2);
    }
    return 0;
}

UFUNC_DESCR3(remainder_Int16_vector_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int remainder_Int16_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin1     = (Int16 *) buffers[0];
    Int16 tscalar   = *(Int16 *) buffers[1];
    Int16 *tout    = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = ((tscalar==0) ? int_dividebyzero_error(tscalar, *tin1) : *tin1  %  tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(remainder_Int16_vector_scalar, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int remainder_Int16_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 tscalar = *(Int16 *) buffers[0];
    Int16 *tin2   =  (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = ((*tin2==0) ? int_dividebyzero_error(*tin2, 0) : tscalar  %  *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(remainder_Int16_scalar_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int remainder_Int16_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16 *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout = (Int16 *) ((char *) output + outboffset);
    Int16 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            tout = (Int16 *) ((char *) tout + outbstrides[dim]);
            *tout = ((*tin==0) ? int_dividebyzero_error(*tin, 0) : lastval  %  *tin);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            remainder_Int16_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(remainder_Int16_accumulate, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));

static int remainder_Int16_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16  *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout  = (Int16 *) ((char *) output + outboffset);
    Int16 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            net = ((*tin==0) ? int_dividebyzero_error(*tin, 0) : net  %  *tin);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            remainder_Int16_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(remainder_Int16_reduce, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));
/*********************  remainder  *********************/
/*********************  power  *********************/

static int power_Int16_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16  *tin1  = (Int16 *) buffers[0];
    Int16  *tin2  = (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = num_pow(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(power_Int16_vector_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int power_Int16_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin1     = (Int16 *) buffers[0];
    Int16 tscalar   = *(Int16 *) buffers[1];
    Int16 *tout    = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = num_pow(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(power_Int16_vector_scalar, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int power_Int16_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 tscalar = *(Int16 *) buffers[0];
    Int16 *tin2   =  (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = num_pow(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(power_Int16_scalar_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int power_Int16_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16 *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout = (Int16 *) ((char *) output + outboffset);
    Int16 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            tout = (Int16 *) ((char *) tout + outbstrides[dim]);
            *tout = num_pow(lastval ,*tin);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            power_Int16_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(power_Int16_accumulate, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));

static int power_Int16_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16  *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout  = (Int16 *) ((char *) output + outboffset);
    Int16 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            net = num_pow(net, *tin);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            power_Int16_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(power_Int16_reduce, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));
/*********************  abs  *********************/

static int abs_Int16_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin = (Int16 *) buffers[0];
    Int16 *tout = (Int16 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = fabs(*tin);
    }
    return 0;
}

UFUNC_DESCR2(abs_Int16_vector, sizeof(Int16), sizeof(Int16));
/*********************  sin  *********************/

static int sin_Int16_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin = (Int16 *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = sin(*tin);
    }
    return 0;
}

UFUNC_DESCR2(sin_Int16_vector, sizeof(Int16), sizeof(Float64));
/*********************  cos  *********************/

static int cos_Int16_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin = (Int16 *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = cos(*tin);
    }
    return 0;
}

UFUNC_DESCR2(cos_Int16_vector, sizeof(Int16), sizeof(Float64));
/*********************  tan  *********************/

static int tan_Int16_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin = (Int16 *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = tan(*tin);
    }
    return 0;
}

UFUNC_DESCR2(tan_Int16_vector, sizeof(Int16), sizeof(Float64));
/*********************  arcsin  *********************/

static int arcsin_Int16_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin = (Int16 *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = asin(*tin);
    }
    return 0;
}

UFUNC_DESCR2(arcsin_Int16_vector, sizeof(Int16), sizeof(Float64));
/*********************  arccos  *********************/

static int arccos_Int16_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin = (Int16 *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = acos(*tin);
    }
    return 0;
}

UFUNC_DESCR2(arccos_Int16_vector, sizeof(Int16), sizeof(Float64));
/*********************  arctan  *********************/

static int arctan_Int16_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin = (Int16 *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = atan(*tin);
    }
    return 0;
}

UFUNC_DESCR2(arctan_Int16_vector, sizeof(Int16), sizeof(Float64));
/*********************  arctan2  *********************/

static int arctan2_Int16_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16  *tin1  = (Int16 *) buffers[0];
    Int16  *tin2  = (Int16 *) buffers[1];
    Float64 *tout  = (Float64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = atan2(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(arctan2_Int16_vector_vector, sizeof(Int16), sizeof(Int16), sizeof(Float64));


static int arctan2_Int16_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin1     = (Int16 *) buffers[0];
    Int16 tscalar   = *(Int16 *) buffers[1];
    Float64 *tout    = (Float64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = atan2(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(arctan2_Int16_vector_scalar, sizeof(Int16), sizeof(Int16), sizeof(Float64));


static int arctan2_Int16_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 tscalar = *(Int16 *) buffers[0];
    Int16 *tin2   =  (Int16 *) buffers[1];
    Float64 *tout  = (Float64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = atan2(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(arctan2_Int16_scalar_vector, sizeof(Int16), sizeof(Int16), sizeof(Float64));

/*********************  log  *********************/

static int log_Int16_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin = (Int16 *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = num_log(*tin);
    }
    return 0;
}

UFUNC_DESCR2(log_Int16_vector, sizeof(Int16), sizeof(Float64));
/*********************  log10  *********************/

static int log10_Int16_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin = (Int16 *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = num_log10(*tin);
    }
    return 0;
}

UFUNC_DESCR2(log10_Int16_vector, sizeof(Int16), sizeof(Float64));
/*********************  exp  *********************/

static int exp_Int16_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin = (Int16 *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = exp(*tin);
    }
    return 0;
}

UFUNC_DESCR2(exp_Int16_vector, sizeof(Int16), sizeof(Float64));
/*********************  sinh  *********************/

static int sinh_Int16_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin = (Int16 *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = sinh(*tin);
    }
    return 0;
}

UFUNC_DESCR2(sinh_Int16_vector, sizeof(Int16), sizeof(Float64));
/*********************  cosh  *********************/

static int cosh_Int16_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin = (Int16 *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = cosh(*tin);
    }
    return 0;
}

UFUNC_DESCR2(cosh_Int16_vector, sizeof(Int16), sizeof(Float64));
/*********************  tanh  *********************/

static int tanh_Int16_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin = (Int16 *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = tanh(*tin);
    }
    return 0;
}

UFUNC_DESCR2(tanh_Int16_vector, sizeof(Int16), sizeof(Float64));
/*********************  arcsinh  *********************/

static int arcsinh_Int16_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin = (Int16 *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = num_asinh(*tin);
    }
    return 0;
}

UFUNC_DESCR2(arcsinh_Int16_vector, sizeof(Int16), sizeof(Float64));
/*********************  arccosh  *********************/

static int arccosh_Int16_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin = (Int16 *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = num_acosh(*tin);
    }
    return 0;
}

UFUNC_DESCR2(arccosh_Int16_vector, sizeof(Int16), sizeof(Float64));
/*********************  arctanh  *********************/

static int arctanh_Int16_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin = (Int16 *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = num_atanh(*tin);
    }
    return 0;
}

UFUNC_DESCR2(arctanh_Int16_vector, sizeof(Int16), sizeof(Float64));
/*********************  ieeemask  *********************/
/*********************  ieeemask  *********************/
/*********************  sqrt  *********************/

static int sqrt_Int16_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin = (Int16 *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = sqrt(*tin);
    }
    return 0;
}

UFUNC_DESCR2(sqrt_Int16_vector, sizeof(Int16), sizeof(Float64));
/*********************  equal  *********************/

static int equal_Int16_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16  *tin1  = (Int16 *) buffers[0];
    Int16  *tin2  = (Int16 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 == *tin2;
    }
    return 0;
}

UFUNC_DESCR3(equal_Int16_vector_vector, sizeof(Int16), sizeof(Int16), sizeof(Bool));


static int equal_Int16_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin1     = (Int16 *) buffers[0];
    Int16 tscalar   = *(Int16 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 == tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(equal_Int16_vector_scalar, sizeof(Int16), sizeof(Int16), sizeof(Bool));


static int equal_Int16_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 tscalar = *(Int16 *) buffers[0];
    Int16 *tin2   =  (Int16 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar == *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(equal_Int16_scalar_vector, sizeof(Int16), sizeof(Int16), sizeof(Bool));

/*********************  not_equal  *********************/

static int not_equal_Int16_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16  *tin1  = (Int16 *) buffers[0];
    Int16  *tin2  = (Int16 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 != *tin2;
    }
    return 0;
}

UFUNC_DESCR3(not_equal_Int16_vector_vector, sizeof(Int16), sizeof(Int16), sizeof(Bool));


static int not_equal_Int16_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin1     = (Int16 *) buffers[0];
    Int16 tscalar   = *(Int16 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 != tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(not_equal_Int16_vector_scalar, sizeof(Int16), sizeof(Int16), sizeof(Bool));


static int not_equal_Int16_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 tscalar = *(Int16 *) buffers[0];
    Int16 *tin2   =  (Int16 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar != *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(not_equal_Int16_scalar_vector, sizeof(Int16), sizeof(Int16), sizeof(Bool));

/*********************  greater  *********************/

static int greater_Int16_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16  *tin1  = (Int16 *) buffers[0];
    Int16  *tin2  = (Int16 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 > *tin2;
    }
    return 0;
}

UFUNC_DESCR3(greater_Int16_vector_vector, sizeof(Int16), sizeof(Int16), sizeof(Bool));


static int greater_Int16_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin1     = (Int16 *) buffers[0];
    Int16 tscalar   = *(Int16 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 > tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(greater_Int16_vector_scalar, sizeof(Int16), sizeof(Int16), sizeof(Bool));


static int greater_Int16_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 tscalar = *(Int16 *) buffers[0];
    Int16 *tin2   =  (Int16 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar > *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(greater_Int16_scalar_vector, sizeof(Int16), sizeof(Int16), sizeof(Bool));

/*********************  greater_equal  *********************/

static int greater_equal_Int16_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16  *tin1  = (Int16 *) buffers[0];
    Int16  *tin2  = (Int16 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 >= *tin2;
    }
    return 0;
}

UFUNC_DESCR3(greater_equal_Int16_vector_vector, sizeof(Int16), sizeof(Int16), sizeof(Bool));


static int greater_equal_Int16_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin1     = (Int16 *) buffers[0];
    Int16 tscalar   = *(Int16 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 >= tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(greater_equal_Int16_vector_scalar, sizeof(Int16), sizeof(Int16), sizeof(Bool));


static int greater_equal_Int16_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 tscalar = *(Int16 *) buffers[0];
    Int16 *tin2   =  (Int16 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar >= *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(greater_equal_Int16_scalar_vector, sizeof(Int16), sizeof(Int16), sizeof(Bool));

/*********************  less  *********************/

static int less_Int16_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16  *tin1  = (Int16 *) buffers[0];
    Int16  *tin2  = (Int16 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 < *tin2;
    }
    return 0;
}

UFUNC_DESCR3(less_Int16_vector_vector, sizeof(Int16), sizeof(Int16), sizeof(Bool));


static int less_Int16_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin1     = (Int16 *) buffers[0];
    Int16 tscalar   = *(Int16 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 < tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(less_Int16_vector_scalar, sizeof(Int16), sizeof(Int16), sizeof(Bool));


static int less_Int16_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 tscalar = *(Int16 *) buffers[0];
    Int16 *tin2   =  (Int16 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar < *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(less_Int16_scalar_vector, sizeof(Int16), sizeof(Int16), sizeof(Bool));

/*********************  less_equal  *********************/

static int less_equal_Int16_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16  *tin1  = (Int16 *) buffers[0];
    Int16  *tin2  = (Int16 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 <= *tin2;
    }
    return 0;
}

UFUNC_DESCR3(less_equal_Int16_vector_vector, sizeof(Int16), sizeof(Int16), sizeof(Bool));


static int less_equal_Int16_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin1     = (Int16 *) buffers[0];
    Int16 tscalar   = *(Int16 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 <= tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(less_equal_Int16_vector_scalar, sizeof(Int16), sizeof(Int16), sizeof(Bool));


static int less_equal_Int16_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 tscalar = *(Int16 *) buffers[0];
    Int16 *tin2   =  (Int16 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar <= *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(less_equal_Int16_scalar_vector, sizeof(Int16), sizeof(Int16), sizeof(Bool));

/*********************  logical_and  *********************/

static int logical_and_Int16_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16  *tin1  = (Int16 *) buffers[0];
    Int16  *tin2  = (Int16 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = logical_and(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(logical_and_Int16_vector_vector, sizeof(Int16), sizeof(Int16), sizeof(Bool));


static int logical_and_Int16_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin1     = (Int16 *) buffers[0];
    Int16 tscalar   = *(Int16 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = logical_and(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(logical_and_Int16_vector_scalar, sizeof(Int16), sizeof(Int16), sizeof(Bool));


static int logical_and_Int16_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 tscalar = *(Int16 *) buffers[0];
    Int16 *tin2   =  (Int16 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = logical_and(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(logical_and_Int16_scalar_vector, sizeof(Int16), sizeof(Int16), sizeof(Bool));

/*********************  logical_or  *********************/

static int logical_or_Int16_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16  *tin1  = (Int16 *) buffers[0];
    Int16  *tin2  = (Int16 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = logical_or(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(logical_or_Int16_vector_vector, sizeof(Int16), sizeof(Int16), sizeof(Bool));


static int logical_or_Int16_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin1     = (Int16 *) buffers[0];
    Int16 tscalar   = *(Int16 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = logical_or(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(logical_or_Int16_vector_scalar, sizeof(Int16), sizeof(Int16), sizeof(Bool));


static int logical_or_Int16_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 tscalar = *(Int16 *) buffers[0];
    Int16 *tin2   =  (Int16 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = logical_or(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(logical_or_Int16_scalar_vector, sizeof(Int16), sizeof(Int16), sizeof(Bool));

/*********************  logical_xor  *********************/

static int logical_xor_Int16_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16  *tin1  = (Int16 *) buffers[0];
    Int16  *tin2  = (Int16 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = logical_xor(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(logical_xor_Int16_vector_vector, sizeof(Int16), sizeof(Int16), sizeof(Bool));


static int logical_xor_Int16_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin1     = (Int16 *) buffers[0];
    Int16 tscalar   = *(Int16 *) buffers[1];
    Bool *tout    = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = logical_xor(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(logical_xor_Int16_vector_scalar, sizeof(Int16), sizeof(Int16), sizeof(Bool));


static int logical_xor_Int16_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 tscalar = *(Int16 *) buffers[0];
    Int16 *tin2   =  (Int16 *) buffers[1];
    Bool *tout  = (Bool *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = logical_xor(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(logical_xor_Int16_scalar_vector, sizeof(Int16), sizeof(Int16), sizeof(Bool));

/*********************  logical_not  *********************/

static int logical_not_Int16_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin = (Int16 *) buffers[0];
    Bool *tout = (Bool *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = !*tin;
    }
    return 0;
}

UFUNC_DESCR2(logical_not_Int16_vector, sizeof(Int16), sizeof(Bool));
/*********************  bitwise_and  *********************/

static int bitwise_and_Int16_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16  *tin1  = (Int16 *) buffers[0];
    Int16  *tin2  = (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 & *tin2;
    }
    return 0;
}

UFUNC_DESCR3(bitwise_and_Int16_vector_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int bitwise_and_Int16_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin1     = (Int16 *) buffers[0];
    Int16 tscalar   = *(Int16 *) buffers[1];
    Int16 *tout    = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 & tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(bitwise_and_Int16_vector_scalar, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int bitwise_and_Int16_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 tscalar = *(Int16 *) buffers[0];
    Int16 *tin2   =  (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar & *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(bitwise_and_Int16_scalar_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int bitwise_and_Int16_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16 *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout = (Int16 *) ((char *) output + outboffset);
    Int16 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            tout = (Int16 *) ((char *) tout + outbstrides[dim]);
            *tout = lastval & *tin;
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            bitwise_and_Int16_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(bitwise_and_Int16_accumulate, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));

static int bitwise_and_Int16_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16  *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout  = (Int16 *) ((char *) output + outboffset);
    Int16 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            net = net & *tin;
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            bitwise_and_Int16_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(bitwise_and_Int16_reduce, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));
/*********************  bitwise_or  *********************/

static int bitwise_or_Int16_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16  *tin1  = (Int16 *) buffers[0];
    Int16  *tin2  = (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 | *tin2;
    }
    return 0;
}

UFUNC_DESCR3(bitwise_or_Int16_vector_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int bitwise_or_Int16_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin1     = (Int16 *) buffers[0];
    Int16 tscalar   = *(Int16 *) buffers[1];
    Int16 *tout    = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 | tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(bitwise_or_Int16_vector_scalar, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int bitwise_or_Int16_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 tscalar = *(Int16 *) buffers[0];
    Int16 *tin2   =  (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar | *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(bitwise_or_Int16_scalar_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int bitwise_or_Int16_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16 *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout = (Int16 *) ((char *) output + outboffset);
    Int16 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            tout = (Int16 *) ((char *) tout + outbstrides[dim]);
            *tout = lastval | *tin;
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            bitwise_or_Int16_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(bitwise_or_Int16_accumulate, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));

static int bitwise_or_Int16_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16  *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout  = (Int16 *) ((char *) output + outboffset);
    Int16 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            net = net | *tin;
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            bitwise_or_Int16_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(bitwise_or_Int16_reduce, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));
/*********************  bitwise_xor  *********************/

static int bitwise_xor_Int16_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16  *tin1  = (Int16 *) buffers[0];
    Int16  *tin2  = (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 ^ *tin2;
    }
    return 0;
}

UFUNC_DESCR3(bitwise_xor_Int16_vector_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int bitwise_xor_Int16_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin1     = (Int16 *) buffers[0];
    Int16 tscalar   = *(Int16 *) buffers[1];
    Int16 *tout    = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 ^ tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(bitwise_xor_Int16_vector_scalar, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int bitwise_xor_Int16_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 tscalar = *(Int16 *) buffers[0];
    Int16 *tin2   =  (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar ^ *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(bitwise_xor_Int16_scalar_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int bitwise_xor_Int16_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16 *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout = (Int16 *) ((char *) output + outboffset);
    Int16 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            tout = (Int16 *) ((char *) tout + outbstrides[dim]);
            *tout = lastval ^ *tin;
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            bitwise_xor_Int16_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(bitwise_xor_Int16_accumulate, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));

static int bitwise_xor_Int16_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16  *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout  = (Int16 *) ((char *) output + outboffset);
    Int16 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            net = net ^ *tin;
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            bitwise_xor_Int16_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(bitwise_xor_Int16_reduce, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));
/*********************  bitwise_not  *********************/

static int bitwise_not_Int16_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin = (Int16 *) buffers[0];
    Int16 *tout = (Int16 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = ~*tin;
    }
    return 0;
}

UFUNC_DESCR2(bitwise_not_Int16_vector, sizeof(Int16), sizeof(Int16));
/*********************  bitwise_not  *********************/
/*********************  rshift  *********************/

static int rshift_Int16_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16  *tin1  = (Int16 *) buffers[0];
    Int16  *tin2  = (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 >> *tin2;
    }
    return 0;
}

UFUNC_DESCR3(rshift_Int16_vector_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int rshift_Int16_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin1     = (Int16 *) buffers[0];
    Int16 tscalar   = *(Int16 *) buffers[1];
    Int16 *tout    = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 >> tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(rshift_Int16_vector_scalar, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int rshift_Int16_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 tscalar = *(Int16 *) buffers[0];
    Int16 *tin2   =  (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar >> *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(rshift_Int16_scalar_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int rshift_Int16_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16 *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout = (Int16 *) ((char *) output + outboffset);
    Int16 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            tout = (Int16 *) ((char *) tout + outbstrides[dim]);
            *tout = lastval >> *tin;
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            rshift_Int16_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(rshift_Int16_accumulate, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));

static int rshift_Int16_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16  *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout  = (Int16 *) ((char *) output + outboffset);
    Int16 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            net = net >> *tin;
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            rshift_Int16_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(rshift_Int16_reduce, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));
/*********************  lshift  *********************/

static int lshift_Int16_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16  *tin1  = (Int16 *) buffers[0];
    Int16  *tin2  = (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = *tin1 << *tin2;
    }
    return 0;
}

UFUNC_DESCR3(lshift_Int16_vector_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int lshift_Int16_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin1     = (Int16 *) buffers[0];
    Int16 tscalar   = *(Int16 *) buffers[1];
    Int16 *tout    = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = *tin1 << tscalar;
    }
    return 0;
}

UFUNC_DESCR3vs(lshift_Int16_vector_scalar, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int lshift_Int16_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 tscalar = *(Int16 *) buffers[0];
    Int16 *tin2   =  (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = tscalar << *tin2;
    }
    return 0;
}

UFUNC_DESCR3sv(lshift_Int16_scalar_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int lshift_Int16_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16 *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout = (Int16 *) ((char *) output + outboffset);
    Int16 lastval;
    
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            tout = (Int16 *) ((char *) tout + outbstrides[dim]);
            *tout = lastval << *tin;
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            lshift_Int16_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(lshift_Int16_accumulate, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));

static int lshift_Int16_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16  *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout  = (Int16 *) ((char *) output + outboffset);
    Int16 net;
    
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            net = net << *tin;
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            lshift_Int16_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(lshift_Int16_reduce, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));
/*********************  floor  *********************/

static int floor_Int16_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin = (Int16 *) buffers[0];
    Int16 *tout = (Int16 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = (*tin);
    }
    return 0;
}

UFUNC_DESCR2(floor_Int16_vector, sizeof(Int16), sizeof(Int16));
/*********************  floor  *********************/
/*********************  ceil  *********************/

static int ceil_Int16_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin = (Int16 *) buffers[0];
    Int16 *tout = (Int16 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = (*tin);
    }
    return 0;
}

UFUNC_DESCR2(ceil_Int16_vector, sizeof(Int16), sizeof(Int16));
/*********************  ceil  *********************/
/*********************  maximum  *********************/

static int maximum_Int16_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16  *tin1  = (Int16 *) buffers[0];
    Int16  *tin2  = (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    Int16 temp1, temp2;
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = ufmaximum(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(maximum_Int16_vector_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int maximum_Int16_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin1     = (Int16 *) buffers[0];
    Int16 tscalar   = *(Int16 *) buffers[1];
    Int16 *tout    = (Int16 *) buffers[2];
    Int16 temp1, temp2;
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = ufmaximum(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(maximum_Int16_vector_scalar, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int maximum_Int16_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 tscalar = *(Int16 *) buffers[0];
    Int16 *tin2   =  (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    Int16 temp1, temp2;
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = ufmaximum(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(maximum_Int16_scalar_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int maximum_Int16_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16 *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout = (Int16 *) ((char *) output + outboffset);
    Int16 lastval;
    Int16 temp1, temp2;
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            tout = (Int16 *) ((char *) tout + outbstrides[dim]);
            *tout = ufmaximum(lastval ,*tin);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            maximum_Int16_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(maximum_Int16_accumulate, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));

static int maximum_Int16_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16  *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout  = (Int16 *) ((char *) output + outboffset);
    Int16 net;
    Int16 temp1, temp2;
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            net = ufmaximum(net, *tin);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            maximum_Int16_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(maximum_Int16_reduce, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));
/*********************  minimum  *********************/

static int minimum_Int16_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16  *tin1  = (Int16 *) buffers[0];
    Int16  *tin2  = (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    Int16 temp1, temp2;
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = ufminimum(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(minimum_Int16_vector_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int minimum_Int16_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin1     = (Int16 *) buffers[0];
    Int16 tscalar   = *(Int16 *) buffers[1];
    Int16 *tout    = (Int16 *) buffers[2];
    Int16 temp1, temp2;
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = ufminimum(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(minimum_Int16_vector_scalar, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int minimum_Int16_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 tscalar = *(Int16 *) buffers[0];
    Int16 *tin2   =  (Int16 *) buffers[1];
    Int16 *tout  = (Int16 *) buffers[2];
    Int16 temp1, temp2;
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = ufminimum(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(minimum_Int16_scalar_vector, sizeof(Int16), sizeof(Int16), sizeof(Int16));


static int minimum_Int16_accumulate(
            long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16 *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout = (Int16 *) ((char *) output + outboffset);
    Int16 lastval;
    Int16 temp1, temp2;
    if (dim == 0) {
        for (i=1; i<niters[dim]; i++) {
            lastval = *tout;
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            tout = (Int16 *) ((char *) tout + outbstrides[dim]);
            *tout = ufminimum(lastval ,*tin);
        }
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            minimum_Int16_accumulate(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(minimum_Int16_accumulate, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));

static int minimum_Int16_reduce(long dim, long dummy, maybelong *niters,
            void *input,  long inboffset,  maybelong *inbstrides,
            void *output, long outboffset, maybelong *outbstrides) {
    long i;
    Int16  *tin   = (Int16 *) ((char *) input  + inboffset);
    Int16 *tout  = (Int16 *) ((char *) output + outboffset);
    Int16 net;
    Int16 temp1, temp2;
    if (dim == 0) {
        net = *tout;
        for (i=1; i<niters[dim]; i++) {
            tin = (Int16 *) ((char *) tin + inbstrides[dim]);
            net = ufminimum(net, *tin);
        }
        *tout = net;
    }
    else {
        for (i=0; i<niters[dim]; i++) {
            minimum_Int16_reduce(dim-1, dummy, niters,
               input,  inboffset  + i*inbstrides[dim],  inbstrides,
               output, outboffset + i*outbstrides[dim], outbstrides);
        }
    }
    return 0;
}

STRIDING_DESCR2(minimum_Int16_reduce, CHECK_ALIGN, sizeof(Int16), sizeof(Int16));
/*********************  fabs  *********************/

static int fabs_Int16_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin = (Int16 *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = fabs(*tin);
    }
    return 0;
}

UFUNC_DESCR2(fabs_Int16_vector, sizeof(Int16), sizeof(Float64));
/*********************  _round  *********************/

static int _round_Int16_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin = (Int16 *) buffers[0];
    Float64 *tout = (Float64 *) buffers[1];
    
    for (i=0; i<niter; i++, tin++, tout++) {
        *tout = num_round(*tin);
    }
    return 0;
}

UFUNC_DESCR2(_round_Int16_vector, sizeof(Int16), sizeof(Float64));
/*********************  hypot  *********************/

static int hypot_Int16_vector_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16  *tin1  = (Int16 *) buffers[0];
    Int16  *tin2  = (Int16 *) buffers[1];
    Float64 *tout  = (Float64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tin2++, tout++) {
        *tout = hypot(*tin1, *tin2);
    }
    return 0;
}

UFUNC_DESCR3(hypot_Int16_vector_vector, sizeof(Int16), sizeof(Int16), sizeof(Float64));


static int hypot_Int16_vector_scalar(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 *tin1     = (Int16 *) buffers[0];
    Int16 tscalar   = *(Int16 *) buffers[1];
    Float64 *tout    = (Float64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin1++, tout++) {
        *tout = hypot(*tin1, tscalar);
    }
    return 0;
}

UFUNC_DESCR3vs(hypot_Int16_vector_scalar, sizeof(Int16), sizeof(Int16), sizeof(Float64));


static int hypot_Int16_scalar_vector(long niter, long ninargs, long noutargs, void **buffers, long *bsizes) {
    long i;
    Int16 tscalar = *(Int16 *) buffers[0];
    Int16 *tin2   =  (Int16 *) buffers[1];
    Float64 *tout  = (Float64 *) buffers[2];
    
    for (i=0; i<niter; i++, tin2++, tout++) {
        *tout = hypot(tscalar, *tin2);
    }
    return 0;
}

UFUNC_DESCR3sv(hypot_Int16_scalar_vector, sizeof(Int16), sizeof(Int16), sizeof(Float64));

/*********************  minus  *********************/
/*********************  add  *********************/
/*********************  subtract  *********************/
/*********************  multiply  *********************/
/*********************  divide  *********************/
/*********************  true_divide  *********************/
/*********************  remainder  *********************/
/*********************  power  *********************/
/*********************  abs  *********************/
/*********************  sin  *********************/
/*********************  cos  *********************/
/*********************  tan  *********************/
/*********************  arcsin  *********************/
/*********************  arccos  *********************/
/*********************  arctan  *********************/
/*********************  arcsinh  *********************/
/*********************  arccosh  *********************/
/*********************  arctanh  *********************/
/*********************  log  *********************/
/*********************  log10  *********************/
/*********************  exp  *********************/
/*********************  sinh  *********************/
/*********************  cosh  *********************/
/*********************  tanh  *********************/
/*********************  sqrt  *********************/
/*********************  equal  *********************/
/*********************  not_equal  *********************/
/*********************  logical_and  *********************/
/*********************  logical_or  *********************/
/*********************  logical_xor  *********************/
/*********************  logical_not  *********************/
/*********************  floor  *********************/
/*********************  ceil  *********************/
/*********************  maximum  *********************/
/*********************  minimum  *********************/
/*********************  fabs  *********************/
/*********************  _round  *********************/
/*********************  hypot  *********************/

static PyMethodDef _ufuncInt16Methods[] = {

	{NULL,      NULL}        /* Sentinel */
};

static PyObject *init_funcDict(void) {
    PyObject *dict;
    dict = PyDict_New();
    NA_add_cfunc(dict, "('minus', 'vector', (('Int16',), ('Int16',)))", (void *) &minus_Int16_vector_descr);
    NA_add_cfunc(dict, "('add', 'vector_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &add_Int16_vector_vector_descr);
    NA_add_cfunc(dict, "('add', 'vector_scalar', (('Int16', 'Int16'), ('Int16',)))", (void *) &add_Int16_vector_scalar_descr);
    NA_add_cfunc(dict, "('add', 'scalar_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &add_Int16_scalar_vector_descr);
    NA_add_cfunc(dict, "('add', 'reduce', (('Int16',), ('Int16',)))", (void *) &add_Int16_reduce_descr);
    NA_add_cfunc(dict, "('add', 'accumulate', (('Int16',), ('Int16',)))", (void *) &add_Int16_accumulate_descr);
    NA_add_cfunc(dict, "('subtract', 'vector_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &subtract_Int16_vector_vector_descr);
    NA_add_cfunc(dict, "('subtract', 'vector_scalar', (('Int16', 'Int16'), ('Int16',)))", (void *) &subtract_Int16_vector_scalar_descr);
    NA_add_cfunc(dict, "('subtract', 'scalar_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &subtract_Int16_scalar_vector_descr);
    NA_add_cfunc(dict, "('subtract', 'reduce', (('Int16',), ('Int16',)))", (void *) &subtract_Int16_reduce_descr);
    NA_add_cfunc(dict, "('subtract', 'accumulate', (('Int16',), ('Int16',)))", (void *) &subtract_Int16_accumulate_descr);
    NA_add_cfunc(dict, "('multiply', 'vector_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &multiply_Int16_vector_vector_descr);
    NA_add_cfunc(dict, "('multiply', 'vector_scalar', (('Int16', 'Int16'), ('Int16',)))", (void *) &multiply_Int16_vector_scalar_descr);
    NA_add_cfunc(dict, "('multiply', 'scalar_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &multiply_Int16_scalar_vector_descr);
    NA_add_cfunc(dict, "('multiply', 'reduce', (('Int16',), ('Int16',)))", (void *) &multiply_Int16_reduce_descr);
    NA_add_cfunc(dict, "('multiply', 'accumulate', (('Int16',), ('Int16',)))", (void *) &multiply_Int16_accumulate_descr);
    NA_add_cfunc(dict, "('divide', 'vector_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &divide_Int16_vector_vector_descr);
    NA_add_cfunc(dict, "('divide', 'vector_scalar', (('Int16', 'Int16'), ('Int16',)))", (void *) &divide_Int16_vector_scalar_descr);
    NA_add_cfunc(dict, "('divide', 'scalar_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &divide_Int16_scalar_vector_descr);
    NA_add_cfunc(dict, "('divide', 'reduce', (('Int16',), ('Int16',)))", (void *) &divide_Int16_reduce_descr);
    NA_add_cfunc(dict, "('divide', 'accumulate', (('Int16',), ('Int16',)))", (void *) &divide_Int16_accumulate_descr);
    NA_add_cfunc(dict, "('floor_divide', 'vector_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &floor_divide_Int16_vector_vector_descr);
    NA_add_cfunc(dict, "('floor_divide', 'vector_scalar', (('Int16', 'Int16'), ('Int16',)))", (void *) &floor_divide_Int16_vector_scalar_descr);
    NA_add_cfunc(dict, "('floor_divide', 'scalar_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &floor_divide_Int16_scalar_vector_descr);
    NA_add_cfunc(dict, "('floor_divide', 'reduce', (('Int16',), ('Int16',)))", (void *) &floor_divide_Int16_reduce_descr);
    NA_add_cfunc(dict, "('floor_divide', 'accumulate', (('Int16',), ('Int16',)))", (void *) &floor_divide_Int16_accumulate_descr);
    NA_add_cfunc(dict, "('true_divide', 'vector_vector', (('Int16', 'Int16'), ('Float32',)))", (void *) &true_divide_Int16_vector_vector_descr);
    NA_add_cfunc(dict, "('true_divide', 'vector_scalar', (('Int16', 'Int16'), ('Float32',)))", (void *) &true_divide_Int16_vector_scalar_descr);
    NA_add_cfunc(dict, "('true_divide', 'scalar_vector', (('Int16', 'Int16'), ('Float32',)))", (void *) &true_divide_Int16_scalar_vector_descr);
    NA_add_cfunc(dict, "('remainder', 'vector_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &remainder_Int16_vector_vector_descr);
    NA_add_cfunc(dict, "('remainder', 'vector_scalar', (('Int16', 'Int16'), ('Int16',)))", (void *) &remainder_Int16_vector_scalar_descr);
    NA_add_cfunc(dict, "('remainder', 'scalar_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &remainder_Int16_scalar_vector_descr);
    NA_add_cfunc(dict, "('remainder', 'reduce', (('Int16',), ('Int16',)))", (void *) &remainder_Int16_reduce_descr);
    NA_add_cfunc(dict, "('remainder', 'accumulate', (('Int16',), ('Int16',)))", (void *) &remainder_Int16_accumulate_descr);
    NA_add_cfunc(dict, "('power', 'vector_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &power_Int16_vector_vector_descr);
    NA_add_cfunc(dict, "('power', 'vector_scalar', (('Int16', 'Int16'), ('Int16',)))", (void *) &power_Int16_vector_scalar_descr);
    NA_add_cfunc(dict, "('power', 'scalar_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &power_Int16_scalar_vector_descr);
    NA_add_cfunc(dict, "('power', 'reduce', (('Int16',), ('Int16',)))", (void *) &power_Int16_reduce_descr);
    NA_add_cfunc(dict, "('power', 'accumulate', (('Int16',), ('Int16',)))", (void *) &power_Int16_accumulate_descr);
    NA_add_cfunc(dict, "('abs', 'vector', (('Int16',), ('Int16',)))", (void *) &abs_Int16_vector_descr);
    NA_add_cfunc(dict, "('sin', 'vector', (('Int16',), ('Float64',)))", (void *) &sin_Int16_vector_descr);
    NA_add_cfunc(dict, "('cos', 'vector', (('Int16',), ('Float64',)))", (void *) &cos_Int16_vector_descr);
    NA_add_cfunc(dict, "('tan', 'vector', (('Int16',), ('Float64',)))", (void *) &tan_Int16_vector_descr);
    NA_add_cfunc(dict, "('arcsin', 'vector', (('Int16',), ('Float64',)))", (void *) &arcsin_Int16_vector_descr);
    NA_add_cfunc(dict, "('arccos', 'vector', (('Int16',), ('Float64',)))", (void *) &arccos_Int16_vector_descr);
    NA_add_cfunc(dict, "('arctan', 'vector', (('Int16',), ('Float64',)))", (void *) &arctan_Int16_vector_descr);
    NA_add_cfunc(dict, "('arctan2', 'vector_vector', (('Int16', 'Int16'), ('Float64',)))", (void *) &arctan2_Int16_vector_vector_descr);
    NA_add_cfunc(dict, "('arctan2', 'vector_scalar', (('Int16', 'Int16'), ('Float64',)))", (void *) &arctan2_Int16_vector_scalar_descr);
    NA_add_cfunc(dict, "('arctan2', 'scalar_vector', (('Int16', 'Int16'), ('Float64',)))", (void *) &arctan2_Int16_scalar_vector_descr);
    NA_add_cfunc(dict, "('log', 'vector', (('Int16',), ('Float64',)))", (void *) &log_Int16_vector_descr);
    NA_add_cfunc(dict, "('log10', 'vector', (('Int16',), ('Float64',)))", (void *) &log10_Int16_vector_descr);
    NA_add_cfunc(dict, "('exp', 'vector', (('Int16',), ('Float64',)))", (void *) &exp_Int16_vector_descr);
    NA_add_cfunc(dict, "('sinh', 'vector', (('Int16',), ('Float64',)))", (void *) &sinh_Int16_vector_descr);
    NA_add_cfunc(dict, "('cosh', 'vector', (('Int16',), ('Float64',)))", (void *) &cosh_Int16_vector_descr);
    NA_add_cfunc(dict, "('tanh', 'vector', (('Int16',), ('Float64',)))", (void *) &tanh_Int16_vector_descr);
    NA_add_cfunc(dict, "('arcsinh', 'vector', (('Int16',), ('Float64',)))", (void *) &arcsinh_Int16_vector_descr);
    NA_add_cfunc(dict, "('arccosh', 'vector', (('Int16',), ('Float64',)))", (void *) &arccosh_Int16_vector_descr);
    NA_add_cfunc(dict, "('arctanh', 'vector', (('Int16',), ('Float64',)))", (void *) &arctanh_Int16_vector_descr);
    NA_add_cfunc(dict, "('sqrt', 'vector', (('Int16',), ('Float64',)))", (void *) &sqrt_Int16_vector_descr);
    NA_add_cfunc(dict, "('equal', 'vector_vector', (('Int16', 'Int16'), ('Bool',)))", (void *) &equal_Int16_vector_vector_descr);
    NA_add_cfunc(dict, "('equal', 'vector_scalar', (('Int16', 'Int16'), ('Bool',)))", (void *) &equal_Int16_vector_scalar_descr);
    NA_add_cfunc(dict, "('equal', 'scalar_vector', (('Int16', 'Int16'), ('Bool',)))", (void *) &equal_Int16_scalar_vector_descr);
    NA_add_cfunc(dict, "('not_equal', 'vector_vector', (('Int16', 'Int16'), ('Bool',)))", (void *) &not_equal_Int16_vector_vector_descr);
    NA_add_cfunc(dict, "('not_equal', 'vector_scalar', (('Int16', 'Int16'), ('Bool',)))", (void *) &not_equal_Int16_vector_scalar_descr);
    NA_add_cfunc(dict, "('not_equal', 'scalar_vector', (('Int16', 'Int16'), ('Bool',)))", (void *) &not_equal_Int16_scalar_vector_descr);
    NA_add_cfunc(dict, "('greater', 'vector_vector', (('Int16', 'Int16'), ('Bool',)))", (void *) &greater_Int16_vector_vector_descr);
    NA_add_cfunc(dict, "('greater', 'vector_scalar', (('Int16', 'Int16'), ('Bool',)))", (void *) &greater_Int16_vector_scalar_descr);
    NA_add_cfunc(dict, "('greater', 'scalar_vector', (('Int16', 'Int16'), ('Bool',)))", (void *) &greater_Int16_scalar_vector_descr);
    NA_add_cfunc(dict, "('greater_equal', 'vector_vector', (('Int16', 'Int16'), ('Bool',)))", (void *) &greater_equal_Int16_vector_vector_descr);
    NA_add_cfunc(dict, "('greater_equal', 'vector_scalar', (('Int16', 'Int16'), ('Bool',)))", (void *) &greater_equal_Int16_vector_scalar_descr);
    NA_add_cfunc(dict, "('greater_equal', 'scalar_vector', (('Int16', 'Int16'), ('Bool',)))", (void *) &greater_equal_Int16_scalar_vector_descr);
    NA_add_cfunc(dict, "('less', 'vector_vector', (('Int16', 'Int16'), ('Bool',)))", (void *) &less_Int16_vector_vector_descr);
    NA_add_cfunc(dict, "('less', 'vector_scalar', (('Int16', 'Int16'), ('Bool',)))", (void *) &less_Int16_vector_scalar_descr);
    NA_add_cfunc(dict, "('less', 'scalar_vector', (('Int16', 'Int16'), ('Bool',)))", (void *) &less_Int16_scalar_vector_descr);
    NA_add_cfunc(dict, "('less_equal', 'vector_vector', (('Int16', 'Int16'), ('Bool',)))", (void *) &less_equal_Int16_vector_vector_descr);
    NA_add_cfunc(dict, "('less_equal', 'vector_scalar', (('Int16', 'Int16'), ('Bool',)))", (void *) &less_equal_Int16_vector_scalar_descr);
    NA_add_cfunc(dict, "('less_equal', 'scalar_vector', (('Int16', 'Int16'), ('Bool',)))", (void *) &less_equal_Int16_scalar_vector_descr);
    NA_add_cfunc(dict, "('logical_and', 'vector_vector', (('Int16', 'Int16'), ('Bool',)))", (void *) &logical_and_Int16_vector_vector_descr);
    NA_add_cfunc(dict, "('logical_and', 'vector_scalar', (('Int16', 'Int16'), ('Bool',)))", (void *) &logical_and_Int16_vector_scalar_descr);
    NA_add_cfunc(dict, "('logical_and', 'scalar_vector', (('Int16', 'Int16'), ('Bool',)))", (void *) &logical_and_Int16_scalar_vector_descr);
    NA_add_cfunc(dict, "('logical_or', 'vector_vector', (('Int16', 'Int16'), ('Bool',)))", (void *) &logical_or_Int16_vector_vector_descr);
    NA_add_cfunc(dict, "('logical_or', 'vector_scalar', (('Int16', 'Int16'), ('Bool',)))", (void *) &logical_or_Int16_vector_scalar_descr);
    NA_add_cfunc(dict, "('logical_or', 'scalar_vector', (('Int16', 'Int16'), ('Bool',)))", (void *) &logical_or_Int16_scalar_vector_descr);
    NA_add_cfunc(dict, "('logical_xor', 'vector_vector', (('Int16', 'Int16'), ('Bool',)))", (void *) &logical_xor_Int16_vector_vector_descr);
    NA_add_cfunc(dict, "('logical_xor', 'vector_scalar', (('Int16', 'Int16'), ('Bool',)))", (void *) &logical_xor_Int16_vector_scalar_descr);
    NA_add_cfunc(dict, "('logical_xor', 'scalar_vector', (('Int16', 'Int16'), ('Bool',)))", (void *) &logical_xor_Int16_scalar_vector_descr);
    NA_add_cfunc(dict, "('logical_not', 'vector', (('Int16',), ('Bool',)))", (void *) &logical_not_Int16_vector_descr);
    NA_add_cfunc(dict, "('bitwise_and', 'vector_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &bitwise_and_Int16_vector_vector_descr);
    NA_add_cfunc(dict, "('bitwise_and', 'vector_scalar', (('Int16', 'Int16'), ('Int16',)))", (void *) &bitwise_and_Int16_vector_scalar_descr);
    NA_add_cfunc(dict, "('bitwise_and', 'scalar_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &bitwise_and_Int16_scalar_vector_descr);
    NA_add_cfunc(dict, "('bitwise_and', 'reduce', (('Int16',), ('Int16',)))", (void *) &bitwise_and_Int16_reduce_descr);
    NA_add_cfunc(dict, "('bitwise_and', 'accumulate', (('Int16',), ('Int16',)))", (void *) &bitwise_and_Int16_accumulate_descr);
    NA_add_cfunc(dict, "('bitwise_or', 'vector_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &bitwise_or_Int16_vector_vector_descr);
    NA_add_cfunc(dict, "('bitwise_or', 'vector_scalar', (('Int16', 'Int16'), ('Int16',)))", (void *) &bitwise_or_Int16_vector_scalar_descr);
    NA_add_cfunc(dict, "('bitwise_or', 'scalar_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &bitwise_or_Int16_scalar_vector_descr);
    NA_add_cfunc(dict, "('bitwise_or', 'reduce', (('Int16',), ('Int16',)))", (void *) &bitwise_or_Int16_reduce_descr);
    NA_add_cfunc(dict, "('bitwise_or', 'accumulate', (('Int16',), ('Int16',)))", (void *) &bitwise_or_Int16_accumulate_descr);
    NA_add_cfunc(dict, "('bitwise_xor', 'vector_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &bitwise_xor_Int16_vector_vector_descr);
    NA_add_cfunc(dict, "('bitwise_xor', 'vector_scalar', (('Int16', 'Int16'), ('Int16',)))", (void *) &bitwise_xor_Int16_vector_scalar_descr);
    NA_add_cfunc(dict, "('bitwise_xor', 'scalar_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &bitwise_xor_Int16_scalar_vector_descr);
    NA_add_cfunc(dict, "('bitwise_xor', 'reduce', (('Int16',), ('Int16',)))", (void *) &bitwise_xor_Int16_reduce_descr);
    NA_add_cfunc(dict, "('bitwise_xor', 'accumulate', (('Int16',), ('Int16',)))", (void *) &bitwise_xor_Int16_accumulate_descr);
    NA_add_cfunc(dict, "('bitwise_not', 'vector', (('Int16',), ('Int16',)))", (void *) &bitwise_not_Int16_vector_descr);
    NA_add_cfunc(dict, "('rshift', 'vector_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &rshift_Int16_vector_vector_descr);
    NA_add_cfunc(dict, "('rshift', 'vector_scalar', (('Int16', 'Int16'), ('Int16',)))", (void *) &rshift_Int16_vector_scalar_descr);
    NA_add_cfunc(dict, "('rshift', 'scalar_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &rshift_Int16_scalar_vector_descr);
    NA_add_cfunc(dict, "('rshift', 'reduce', (('Int16',), ('Int16',)))", (void *) &rshift_Int16_reduce_descr);
    NA_add_cfunc(dict, "('rshift', 'accumulate', (('Int16',), ('Int16',)))", (void *) &rshift_Int16_accumulate_descr);
    NA_add_cfunc(dict, "('lshift', 'vector_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &lshift_Int16_vector_vector_descr);
    NA_add_cfunc(dict, "('lshift', 'vector_scalar', (('Int16', 'Int16'), ('Int16',)))", (void *) &lshift_Int16_vector_scalar_descr);
    NA_add_cfunc(dict, "('lshift', 'scalar_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &lshift_Int16_scalar_vector_descr);
    NA_add_cfunc(dict, "('lshift', 'reduce', (('Int16',), ('Int16',)))", (void *) &lshift_Int16_reduce_descr);
    NA_add_cfunc(dict, "('lshift', 'accumulate', (('Int16',), ('Int16',)))", (void *) &lshift_Int16_accumulate_descr);
    NA_add_cfunc(dict, "('floor', 'vector', (('Int16',), ('Int16',)))", (void *) &floor_Int16_vector_descr);
    NA_add_cfunc(dict, "('ceil', 'vector', (('Int16',), ('Int16',)))", (void *) &ceil_Int16_vector_descr);
    NA_add_cfunc(dict, "('maximum', 'vector_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &maximum_Int16_vector_vector_descr);
    NA_add_cfunc(dict, "('maximum', 'vector_scalar', (('Int16', 'Int16'), ('Int16',)))", (void *) &maximum_Int16_vector_scalar_descr);
    NA_add_cfunc(dict, "('maximum', 'scalar_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &maximum_Int16_scalar_vector_descr);
    NA_add_cfunc(dict, "('maximum', 'reduce', (('Int16',), ('Int16',)))", (void *) &maximum_Int16_reduce_descr);
    NA_add_cfunc(dict, "('maximum', 'accumulate', (('Int16',), ('Int16',)))", (void *) &maximum_Int16_accumulate_descr);
    NA_add_cfunc(dict, "('minimum', 'vector_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &minimum_Int16_vector_vector_descr);
    NA_add_cfunc(dict, "('minimum', 'vector_scalar', (('Int16', 'Int16'), ('Int16',)))", (void *) &minimum_Int16_vector_scalar_descr);
    NA_add_cfunc(dict, "('minimum', 'scalar_vector', (('Int16', 'Int16'), ('Int16',)))", (void *) &minimum_Int16_scalar_vector_descr);
    NA_add_cfunc(dict, "('minimum', 'reduce', (('Int16',), ('Int16',)))", (void *) &minimum_Int16_reduce_descr);
    NA_add_cfunc(dict, "('minimum', 'accumulate', (('Int16',), ('Int16',)))", (void *) &minimum_Int16_accumulate_descr);
    NA_add_cfunc(dict, "('fabs', 'vector', (('Int16',), ('Float64',)))", (void *) &fabs_Int16_vector_descr);
    NA_add_cfunc(dict, "('_round', 'vector', (('Int16',), ('Float64',)))", (void *) &_round_Int16_vector_descr);
    NA_add_cfunc(dict, "('hypot', 'vector_vector', (('Int16', 'Int16'), ('Float64',)))", (void *) &hypot_Int16_vector_vector_descr);
    NA_add_cfunc(dict, "('hypot', 'vector_scalar', (('Int16', 'Int16'), ('Float64',)))", (void *) &hypot_Int16_vector_scalar_descr);
    NA_add_cfunc(dict, "('hypot', 'scalar_vector', (('Int16', 'Int16'), ('Float64',)))", (void *) &hypot_Int16_scalar_vector_descr);
    return dict;
}

/* platform independent*/
#ifdef MS_WIN32
__declspec(dllexport)
#endif
void init_ufuncInt16(void) {
    PyObject *m, *d;
    m = Py_InitModule("_ufuncInt16", _ufuncInt16Methods);
    d = PyModule_GetDict(m);
    _Error = PyErr_NewException("_ufuncInt16.error", NULL, NULL);
    PyDict_SetItemString(d, "error", _Error);
    import_libnumarray();
    PyDict_SetItemString(d, "functionDict", init_funcDict());
}
