Index: pygobject-3.0.0/gi/_gobject/gobjectmodule.c
===================================================================
--- pygobject-3.0.0.orig/gi/_gobject/gobjectmodule.c	2011-09-26 10:05:17.080421068 +0200
+++ pygobject-3.0.0/gi/_gobject/gobjectmodule.c	2011-09-26 10:05:14.200421051 +0200
@@ -1048,7 +1048,7 @@
                            gpointer         g_class)
 {
     GObject *object = (GObject *) instance;
-    PyObject *wrapper;
+    PyObject *wrapper, *args, *kwargs;
 
     wrapper = g_object_get_qdata(object, pygobject_wrapper_key);
     if (wrapper == NULL) {
@@ -1059,6 +1059,27 @@
         }
     }
     pygobject_init_wrapper_set(NULL);
+    if (wrapper == NULL) {
+          /* this looks like a python object created through
+           * g_object_new -> we have no python wrapper, so create it
+           * now */
+        PyGILState_STATE state;
+        state = pyglib_gil_state_ensure();
+        wrapper = pygobject_new_full(object, FALSE, g_class);
+
+        /* float the wrapper ref here because we are going to orphan it
+         * so we don't destroy the wrapper. The next call to pygobject_new_full
+         * will take the ref */
+        pygobject_ref_float (wrapper);
+        args = PyTuple_New(0);
+        kwargs = PyDict_New();
+        if (Py_TYPE(wrapper)->tp_init(wrapper, args, kwargs))
+            PyErr_Print();
+
+        Py_DECREF(args);
+        Py_DECREF(kwargs);
+        pyglib_gil_state_release(state);
+    }
 }
 
 
@@ -1730,22 +1751,8 @@
     g_type_class_unref(class);
 
     if (obj) {
-        PyObject *empty_args;
-        PyObject *empty_kwargs;
-        PyGILState_STATE state;
-
         pygobject_sink (obj);
 	self = (PyGObject *) pygobject_new_full((GObject *)obj, FALSE, NULL);
-        empty_args = PyTuple_New(0);
-        empty_kwargs = PyDict_New();
-
-        state = pyglib_gil_state_ensure();
-        if (Py_TYPE(self)->tp_init((PyObject *)self, empty_args, empty_kwargs))
-            PyErr_Print();
-        pyglib_gil_state_release(state);
-
-        Py_DECREF(empty_args);
-        Py_DECREF(empty_kwargs);
         g_object_unref(obj);
     } else
         self = NULL;
Index: pygobject-3.0.0/gi/_gobject/pygobject-private.h
===================================================================
--- pygobject-3.0.0.orig/gi/_gobject/pygobject-private.h	2011-09-26 10:05:17.130421068 +0200
+++ pygobject-3.0.0/gi/_gobject/pygobject-private.h	2011-09-26 10:05:14.200421051 +0200
@@ -96,6 +96,9 @@
 
 gboolean pyg_gerror_exception_check(GError **error);
 
+void pygobject_ref_float(PyGObject *self);
+void pygobject_ref_sink(PyGObject *self);
+
 /* from pygtype.h */
 extern PyTypeObject PyGTypeWrapper_Type;
 
Index: pygobject-3.0.0/gi/_gobject/pygobject.c
===================================================================
--- pygobject-3.0.0.orig/gi/_gobject/pygobject.c	2011-09-26 10:05:16.960421070 +0200
+++ pygobject-3.0.0/gi/_gobject/pygobject.c	2011-09-26 10:05:14.200421051 +0200
@@ -560,6 +560,31 @@
     g_object_unref(self->obj);
 }
 
+/* Called when an custom gobject is initalized via g_object_new instead of
+   its constructor.  The next time the wrapper is access via 
+   pygobject_new_full it will sink the floating reference instead of
+   adding a new reference and causing a leak */
+ 
+void
+pygobject_ref_float(PyGObject *self)
+{
+    /* should only be floated once */
+    g_assert(!(self->private_flags.flags & PYGOBJECT_IS_FLOATING_REF));
+    
+    self->private_flags.flags |= PYGOBJECT_IS_FLOATING_REF;
+}
+
+/* Called by gobject_new_full, if the floating flag is set remove it, otherwise
+   ref the pyobject */
+void
+pygobject_ref_sink(PyGObject *self)
+{
+    if (self->private_flags.flags & PYGOBJECT_IS_FLOATING_REF)
+        self->private_flags.flags &= ~PYGOBJECT_IS_FLOATING_REF;
+    else
+        Py_INCREF ( (PyObject *) self);
+}
+
 /**
  * pygobject_register_wrapper:
  * @self: the wrapper instance
@@ -888,7 +913,7 @@
     /* we already have a wrapper for this object -- return it. */
     self = (PyGObject *)g_object_get_qdata(obj, pygobject_wrapper_key);
     if (self != NULL) {
-	Py_INCREF(self);
+	pygobject_ref_sink(self);
     } else {
 	/* create wrapper */
         PyGObjectData *inst_data = pyg_object_peek_inst_data(obj);
Index: pygobject-3.0.0/gi/_gobject/pygobject.h
===================================================================
--- pygobject-3.0.0.orig/gi/_gobject/pygobject.h	2011-09-26 10:05:17.030421067 +0200
+++ pygobject-3.0.0/gi/_gobject/pygobject.h	2011-09-26 10:05:14.200421051 +0200
@@ -23,7 +23,8 @@
 };
 
 typedef enum {
-    PYGOBJECT_USING_TOGGLE_REF = 1 << 0
+    PYGOBJECT_USING_TOGGLE_REF = 1 << 0,
+    PYGOBJECT_IS_FLOATING_REF = 1 << 1
 } PyGObjectFlags;
 
   /* closures is just an alias for what is found in the
