/*
 * Plasma applet to display indicators from libindicate
 *
 * Copyright 2009 Canonical Ltd.
 *
 * Authors:
 * - Aurélien Gâteau <aurelien.gateau@canonical.com>
 *
 * License: GPL v3
 */
// Self
#include "filtermodeltest.h"

// Qt
#include <QtTest>

// KDE
#include <qtest_kde.h>
#include <KDebug>

// libindicate-qt
#include <qindicatelistener.h>
#include <qindicateindicator.h>
#include <qindicateserver.h>

const QString SERVER_TYPE = "message";
const QString APP_NAME = "An application using libindicate";

QTEST_KDEMAIN(FilterModelTest, GUI)

void FilterModelTest::init()
{
    mServer = QIndicate::Server::defaultInstance();
    const QString desktopFile = KDESRCDIR "test.desktop";

    mServer->setType(SERVER_TYPE);
    mServer->setDesktopFile(desktopFile);
}

void FilterModelTest::cleanup()
{
    delete mServer;
    mServer = 0;
}

void FilterModelTest::testFilter()
{
    // Show server
    mServer->show();

    // Show an indicator
    QIndicate::Indicator indicator;
    indicator.setIndicatorProperty("name", "John Doe");
    indicator.show();
    QTest::qWait(500);

    // Create a ListenerModel with a wrong server type
    QIndicate::Listener listener1;
    ListenerModel listenerModel1(&listener1, QRegExp("^foo"));

    // We should not find any index
    QTest::qWait(500);
    QModelIndex serverIndex = listenerModel1.index(0, 0);
    QVERIFY(!serverIndex.isValid());

    // FIXME: ListenerModel can't list servers or indicators which have already
    // been received by Listener, so we create another instance of Listener
    // Create a ListenerModel with the correct server type
    QIndicate::Listener listener2;
    ListenerModel listenerModel2(&listener2, QRegExp('^' + SERVER_TYPE));

    // We should see the server and its indicator now
    QTest::qWait(500);
    serverIndex = listenerModel2.index(0, 0);
    QVERIFY(serverIndex.isValid());

    QVERIFY(listenerModel2.hasChildren(serverIndex));
    QModelIndex indicatorIndex = listenerModel2.index(0, 0, serverIndex);

    QCOMPARE(indicatorIndex.data().toString(), QString("John Doe"));

    indicator.setIndicatorProperty("name", "Bruce Wayne");
    QTest::qWait(500);

    QCOMPARE(indicatorIndex.data().toString(), QString("Bruce Wayne"));
}

#include "filtermodeltest.moc"
