/*
 * Plasma applet to display indicators from libindicate
 *
 * Copyright 2009 Canonical Ltd.
 *
 * Authors:
 * - Aurélien Gâteau <aurelien.gateau@canonical.com>
 *
 * License: GPL v3
 */
#ifndef VIEW_H
#define VIEW_H

// Qt
#include <QTreeView>

/**
 * A tree view which is always fully expanded
 */
class ExpandedTreeView : public QTreeView
{
Q_OBJECT
public:
    ExpandedTreeView(QWidget* parent = 0);

    virtual QSize minimumSizeHint() const;

    virtual QSize sizeHint() const;

Q_SIGNALS:
    void sizeChanged();

protected:
    virtual void rowsInserted(const QModelIndex& parent, int start, int end);

    virtual void rowsAboutToBeRemoved(const QModelIndex& parent, int start, int end);

    virtual void dataChanged(const QModelIndex& topLeft, const QModelIndex& bottomRight);

    virtual void reset();

    virtual void drawTree(QPainter*, const QRegion&) const;

    virtual void drawBranches(QPainter*, const QRect&, const QModelIndex&) const;

private Q_SLOTS:
    void adjustSizeTightly();

private:
    void setUpRootIndex(int row);
    QSize sizeHintForIndexAndChildren(const QModelIndex& parent, int depth) const;
};

#endif /* VIEW_H */
