/*
 * Plasma applet to display indicators from libindicate
 *
 * Copyright 2009 Canonical Ltd.
 *
 * Authors:
 * - Aurélien Gâteau <aurelien.gateau@canonical.com>
 *
 * License: GPL v3
 */
#ifndef LISTENERMODEL_H
#define LISTENERMODEL_H

// Qt
#include <QStandardItemModel>

// Local
#include <qindicatelistener.h>

class QRegExp;

struct ListenerModelPrivate;
class ListenerModel : public QStandardItemModel
{
Q_OBJECT
public:
    ListenerModel(QIndicate::Listener*, const QRegExp& acceptedServerType);
    ~ListenerModel();

    enum AdditionalRoles
    {
        ServerTypeRole = 0x0F3B4320,
        CountRole = 0x2CFC6823,
        IndicatorDateTimeRole = 0x215B03CC,
        IndicatorDrawAttentionRole = 0x28304470
    };

    /**
     * Get server and indicator proxies corresponding to index.
     * If index is invalid, server and indicator will be 0.
     * If index points to a server row, indicator will be 0.
     */
    void getProxiesForIndex(const QModelIndex& index,
                            QIndicate::Listener::Server** server,
                            QIndicate::Listener::Indicator** indicator) const;

Q_SIGNALS:
    void drawAttentionChanged(const QModelIndex&);

private Q_SLOTS:
    void slotServerAdded(QIndicate::Listener::Server* server, const QString& type);
    void slotServerCountChanged(QIndicate::Listener::Server* server, int count);
    void slotServerRemoved(QIndicate::Listener::Server* server);
    void slotDesktopFileReceived(QIndicate::Listener::Server* server, const QByteArray&);

    void slotIndicatorAdded(QIndicate::Listener::Server* server,
                            QIndicate::Listener::Indicator* indicator);
    void slotIndicatorRemoved(QIndicate::Listener::Server* server,
                              QIndicate::Listener::Indicator* indicator);
    void slotIndicatorModified(QIndicate::Listener::Server* server,
                               QIndicate::Listener::Indicator* indicator,
                               const QString& key);
    void slotPropertyReceived(QIndicate::Listener::Server*,
                              QIndicate::Listener::Indicator*,
                              const QString& key,
                              const QByteArray& value);

private:
    ListenerModelPrivate* const d;
};

#endif /* LISTENERMODEL_H */
