/*
 * Plasma applet to display indicators from libindicate
 *
 * Copyright 2009 Canonical Ltd.
 *
 * Authors:
 * - Aurélien Gâteau <aurelien.gateau@canonical.com>
 *
 * License: GPL v3
 */
#ifndef INDICATORDISPLAY_H
#define INDICATORDISPLAY_H

// Qt
#include <QTreeView>

// KDE
#include <Plasma/PopupApplet>

// QIndicate
#include <qindicatelistener.h>

// Local
#include <listenermodel.h>

class IndicatorDisplay : public Plasma::PopupApplet
{
Q_OBJECT
public:
    IndicatorDisplay(QObject* parent, const QVariantList& args);
    ~IndicatorDisplay();

    virtual void init();

    virtual QWidget* widget();

public Q_SLOTS:
    void toolTipAboutToShow();

protected:
    virtual void popupEvent(bool show);

private Q_SLOTS:
    void slotRowsChanged(const QModelIndex& parent);
    void slotDrawAttentionChanged();
    void slotClicked(const QModelIndex& index);
    void slotServerAdded(QIndicate::Listener::Server* server);
    void dumpModels();
    void initPalette();
    void adjustViewSize();

private:
    QIndicate::Listener* mListener;
    ListenerModel* mSourceModel;
    QTreeView* mView;
    Plasma::IconWidget* mIconWidget;

    void initIcon();
    void initSourceModel();
    void initView();
    void updateIcon(bool newStuff);
    void updateIconState();
    void updateIconFromIndicators();
    void removeInterestOnServers();
};

#endif /* INDICATORDISPLAY_H */
